/* SPDX-License-Identifier: GPL-2.0 */
/*
 * sircs_code_table.h - sircs driver
 *
 * Copyright 2019, 2020, 2021, 2022 Sony Corporation
 */

#ifndef _SIRCS_CODE_TABLE_H_
#define _SIRCS_CODE_TABLE_H_

#ifdef _SIRCS_C_

#define SIRCS_CODE_NUM              (sizeof(sircs_code_table) / sizeof(struct SIRCS_CODE_TABLE))
#define SIRCS_CODE_DEF(data, cate)  ((cate << 7) | (data & 0x7F))
const struct SIRCS_CODE_TABLE {
    u32         sircs_code;
    u32         key_code;
    char        key_name[32];
} sircs_code_table[] = {
    /* PF key */
    {SIRCS_CODE_DEF(0x0c, 0x30),    KEY_ENTER,          "ENTER"     },
    {SIRCS_CODE_DEF(0x15, 0x30),    KEY_POWER,          "POWER"     },
    {SIRCS_CODE_DEF(0x53, 0x30),    KEY_HOMEPAGE,       "HOME"      },
    {SIRCS_CODE_DEF(0x78, 0xb0),    KEY_UP,             "UP"        },
    {SIRCS_CODE_DEF(0x79, 0xb0),    KEY_DOWN,           "DOWN"      },
    {SIRCS_CODE_DEF(0x7a, 0xb0),    KEY_LEFT,           "LEFT"      },
    {SIRCS_CODE_DEF(0x7b, 0xb0),    KEY_RIGHT,          "RIGHT"     },
    {SIRCS_CODE_DEF(0x7d, 0x0110),  KEY_BACK,           "BACK"      },
    /* Bar key */
    {SIRCS_CODE_DEF(0x32, 0x0110),  KEY_PLAY,           "PLAY"      },
    {SIRCS_CODE_DEF(0x38, 0x0110),  KEY_STOP,           "STOP"      },
    {SIRCS_CODE_DEF(0x39, 0x0110),  KEY_PAUSE,          "PAUSE"     },
    {SIRCS_CODE_DEF(0x5C, 0x30),    KEY_F1,             "SW VOL+"   },
    {SIRCS_CODE_DEF(0x5D, 0x30),    KEY_F2,             "SW VOL-"   },
    {SIRCS_CODE_DEF(0x20, 0xB0),    KEY_F8,             "NIGHT"     },
    {SIRCS_CODE_DEF(0x6E, 0xB0),    KEY_FN_F8,          "SND FLD+"  },
    {SIRCS_CODE_DEF(0x1D, 0x0510),  KEY_FN_F11,         "MUSIC SVC" },
    {SIRCS_CODE_DEF(0x39, 0x0510),  KEY_FN_F12,         "VOICE"     },
    {SIRCS_CODE_DEF(0x77, 0x0510),  KEY_F10,            "PAIRING"   },
    {SIRCS_CODE_DEF(0x2F, 0x0D10),  KEY_FN_F6,          "AUTO SND"  },
    {SIRCS_CODE_DEF(0x6C, 0x30),    KEY_NUMERIC_0,      "ANALOG"    },
    {SIRCS_CODE_DEF(0x6E, 0x30),    KEY_NUMERIC_0,      "_ANALOG"   },
    {SIRCS_CODE_DEF(0x4E, 0xB0),    KEY_F3,             "REAR VOL+" },
    {SIRCS_CODE_DEF(0x4F, 0xB0),    KEY_F4,             "REAR VOL-" },
    {SIRCS_CODE_DEF(0x6F, 0xB0),    KEY_FN_F9,          "SND FLD-"  },
    {SIRCS_CODE_DEF(0x10, 0x0510),  KEY_NUMERIC_1,      "HDMI1"     },
    {SIRCS_CODE_DEF(0x11, 0x0510),  KEY_NUMERIC_2,      "HDMI2"     },
    {SIRCS_CODE_DEF(0x15, 0x0510),  KEY_FN_F10,         "HOME NET"  },
    {SIRCS_CODE_DEF(0x45, 0x0510),  KEY_F9,             "TV AMP"    },
    {SIRCS_CODE_DEF(0x78, 0x0510),  KEY_FN_F3,          "GAME"      },
    {SIRCS_CODE_DEF(0x7E, 0x0510),  KEY_F11,            "ENHANCER"  },
    {SIRCS_CODE_DEF(0x18, 0x0D10),  KEY_FN_F4,          "SPORTS"    },
    {SIRCS_CODE_DEF(0x1D, 0x0D10),  KEY_FN_F5,          "STANDARD"  },
    {SIRCS_CODE_DEF(0x3B, 0x0D10),  KEY_FN_F7,          "NEWS"      },
    {SIRCS_CODE_DEF(0x50, 0xB0),    KEY_F16,            "BASS+"     },
    {SIRCS_CODE_DEF(0x51, 0xB0),    KEY_F17,            "BASS-"     },
    {SIRCS_CODE_DEF(0x62, 0x0510),  KEY_BRL_DOT4,       "AUTO VOLUME"               },
    {SIRCS_CODE_DEF(0x74, 0x0d10),  KEY_BRL_DOT3,       "REAR ON/OFF"               },
    {SIRCS_CODE_DEF(0x4e, 0x90),    KEY_F3,             "REAR+ DEMO"                },
    {SIRCS_CODE_DEF(0x4f, 0x90),    KEY_F4,             "REAR- DEMO"                },
    /* MAIN MODE */
    {SIRCS_CODE_DEF(0x15, 0x0179),  KEY_ESC,            "ZONE3 I/O POWER ON/OFF"    },
    {SIRCS_CODE_DEF(0x15, 0x79),    KEY_MINUS,          "ZONE2 I/O POWER ON/OFF"    },
    /* MAIN I/O POWER ON/OFF AV2 is the same as PF key */
    {SIRCS_CODE_DEF(0x15, 0x10),    KEY_Y,              "MAIN I/O POWER ON/OFF AV1" },
    {SIRCS_CODE_DEF(0x7c, 0x30),    KEY_R,              "GAME MAIN AV2"             },
    {SIRCS_CODE_DEF(0x7c, 0x10),    KEY_U,              "GAME MAIN AV1"             },
    {SIRCS_CODE_DEF(0x02, 0x0510),  KEY_T,              "STB MAIN AV2"              },
    {SIRCS_CODE_DEF(0x02, 0x0410),  KEY_I,              "STB MAIN AV1"              },
    {SIRCS_CODE_DEF(0x16, 0x0510),  KEY_RADIO,          "BD MAIN AV2"               },
    {SIRCS_CODE_DEF(0x16, 0x0410),  KEY_O,              "BD MAIN AV1"               },
    {SIRCS_CODE_DEF(0x03, 0xb0),    KEY_TUNER,          "SAT/CATV MAIN AV2"         },
    {SIRCS_CODE_DEF(0x03, 0x90),    KEY_P,              "SAT/CATV MAIN AV1"         },
    {SIRCS_CODE_DEF(0x22, 0x30),    KEY_PLAYER,         "VIDEO1 MAIN AV2"           },
    {SIRCS_CODE_DEF(0x22, 0x10),    KEY_LEFTBRACE,      "VIDEO1 MAIN AV1"           },
    {SIRCS_CODE_DEF(0x1d, 0x30),    KEY_NUMERIC_0,      "AUX 1/LINE IN MAIN AV2"    },
    {SIRCS_CODE_DEF(0x1d, 0x10),    KEY_RIGHTBRACE,     "AUX 1/LINE IN MAIN AV1"    },
    {SIRCS_CODE_DEF(0x6a, 0x30),    KEY_TV,             "TV MAIN AV2"               },
    {SIRCS_CODE_DEF(0x6a, 0x10),    KEY_LEFTCTRL,       "TV MAIN AV1"               },
    {SIRCS_CODE_DEF(0x25, 0x30),    KEY_COFFEE,         "SA-CD/CD MAIN AV2"         },
    {SIRCS_CODE_DEF(0x25, 0x10),    KEY_A,              "SA-CD/CD MAIN AV1"         },
    {SIRCS_CODE_DEF(0x42, 0x0d10),  KEY_BACKSPACE,      "OTHERS MAIN AV2"           },
    {SIRCS_CODE_DEF(0x42, 0x0c10),  KEY_S,              "OTHERS MAIN AV1"           },
    {SIRCS_CODE_DEF(0x41, 0xb0),    KEY_FN_B,           "SOUND FIELD OFF MAIN AV2"  },
    {SIRCS_CODE_DEF(0x41, 0x90),    KEY_D,              "SOUND FIELD OFF MAIN AV1"  },
    {SIRCS_CODE_DEF(0x43, 0xb0),    KEY_FN_F1,          "MOVIE MAIN AV2"            },
    {SIRCS_CODE_DEF(0x43, 0x90),    KEY_F,              "MOVIE MAIN AV1"            },
    {SIRCS_CODE_DEF(0x49, 0xb0),    KEY_FN_F2,          "MUSIC MAIN AV2"            },
    {SIRCS_CODE_DEF(0x49, 0x90),    KEY_G,              "MUSIC MAIN AV1"            },
    {SIRCS_CODE_DEF(0x6e, 0x90),    KEY_DOLLAR,         "SOUND FIELD+ MAIN AV1"     },
    {SIRCS_CODE_DEF(0x6f, 0x90),    KEY_EURO,           "SOUND FIELD- MAIN AV1"     },
    {SIRCS_CODE_DEF(0x3d, 0x0d10),  KEY_FN_F,           "360SSM MAIN AV2"           },
    {SIRCS_CODE_DEF(0x3d, 0x0c10),  KEY_H,              "360SSM MAIN AV1"           },
    {SIRCS_CODE_DEF(0x4b, 0x30),    KEY_F5,             "DISPLAY MAIN AV2"          },
    {SIRCS_CODE_DEF(0x4b, 0x10),    KEY_J,              "DISPLAY MAIN AV1"          },
    {SIRCS_CODE_DEF(0x77, 0xb0),    KEY_SELECT,         "AMP MENU MAIN AV2"         },
    {SIRCS_CODE_DEF(0x77, 0x90),    KEY_K,              "AMP MENU MAIN AV1"         },
    /* CURSOR UP AV2 is the same as PF key */
    {SIRCS_CODE_DEF(0x78, 0x90),    KEY_L,              "CURSOR UP MAIN AV1"        },
    /* CURSOR LEFT AV2 is the same as PF key */
    {SIRCS_CODE_DEF(0x7a, 0x90),    KEY_SEMICOLON,      "CURSOR LEFT MAIN AV1"      },
    /* CURSOR RIGHT AV2 is the same as PF key */
    {SIRCS_CODE_DEF(0x7b, 0x90),    KEY_APOSTROPHE,     "CURSOR RIGHT MAIN AV1"     },
    /* CURSOR DOWN AV2 is the same as PF key */
    {SIRCS_CODE_DEF(0x79, 0x90),    KEY_GRAVE,          "CURSOR DOWN MAIN AV1"      },
    /* CURSOR ENTER AV2 is the same as PF key */
    {SIRCS_CODE_DEF(0x0c, 0x10),    KEY_LEFTSHIFT,      "ENTER MAIN AV1"            },
    /* MENU RETURN(BACK) AV2 is the same as PF key */
    {SIRCS_CODE_DEF(0x7d, 0x073a),  KEY_BACKSLASH,      "MENU RETURN MAIN AV1"      },
    /* ON SCREEN ON/OFF(HOME) AV2 is the same as PF key */
    {SIRCS_CODE_DEF(0x53, 0x10),    KEY_Z,              "ON SCREEN ON/OFF MAIN AV1" },
    {SIRCS_CODE_DEF(0x73, 0x0110),  KEY_OPTION,         "TOOL MENU MAIN AV2"        },
    {SIRCS_CODE_DEF(0x73, 0x073a),  KEY_X,              "TOOL MENU MAIN AV1"        },
    {SIRCS_CODE_DEF(0x6a, 0x0d10),  KEY_KP7,            "BLEUETOOTH RX/TX MAIN AV2" },
    {SIRCS_CODE_DEF(0x6a, 0x0c10),  KEY_C,              "BLEUETOOTH RX/TX MAIN AV1" },
    {SIRCS_CODE_DEF(0x14, 0x30),    KEY_MUTE,           "MUTING MAIN AV2"           },
    {SIRCS_CODE_DEF(0x14, 0x10),    KEY_V,              "MUTING MAIN AV1"           },
    {SIRCS_CODE_DEF(0x12, 0x30),    KEY_VOLUMEUP,       "VOL+ MAIN AV2"             },
    {SIRCS_CODE_DEF(0x12, 0x10),    KEY_B,              "VOL+ MAIN AV1"             },
    {SIRCS_CODE_DEF(0x13, 0x30),    KEY_VOLUMEDOWN,     "VOL- MAIN AV2"             },
    {SIRCS_CODE_DEF(0x13, 0x10),    KEY_N,              "VOL- MAIN AV1"             },
    {SIRCS_CODE_DEF(0x79, 0x0510),  KEY_EQUAL,          "PURE DIRECT MAIN AV2"      },
    {SIRCS_CODE_DEF(0x79, 0x0410),  KEY_M,              "PURE DIRECT MAIN AV1"      },
    {SIRCS_CODE_DEF(0x58, 0x30),    KEY_TAB,            "PRESET MAIN AV2"           },
    {SIRCS_CODE_DEF(0x58, 0x10),    KEY_COMMA,          "PRESET MAIN AV1"           },
    {SIRCS_CODE_DEF(0x32, 0x073a),  KEY_FRAMEBACK,      "PLAY MAIN AV1"             },
    {SIRCS_CODE_DEF(0x39, 0x073a),  KEY_FRAMEFORWARD,   "PAUSE MAIN AV1"            },
    {SIRCS_CODE_DEF(0x38, 0x073a),  KEY_CONTEXT_MENU,   "STOP MAIN AV1"             },
    {SIRCS_CODE_DEF(0x30, 0x0110),  KEY_PREVIOUS,       "PREVIOUS MAIN AV2"         },
    {SIRCS_CODE_DEF(0x30, 0x073a),  KEY_DOT,            "PREVIOUS MAIN AV1"         },
    {SIRCS_CODE_DEF(0x33, 0x0110),  KEY_REWIND,         "FR MAIN AV2"               },
    {SIRCS_CODE_DEF(0x33, 0x073a),  KEY_SLASH,          "FR MAIN AV1"               },
    {SIRCS_CODE_DEF(0x3a, 0x0110),  KEY_PLAYPAUSE,      "PLAY/PAUSE MAIN AV2"       },
    {SIRCS_CODE_DEF(0x3a, 0x073a),  KEY_RIGHTSHIFT,     "PLAY/PAUSE MAIN AV1"       },
    {SIRCS_CODE_DEF(0x31, 0x0110),  KEY_NEXT,           "NEXT MAIN AV2"             },
    {SIRCS_CODE_DEF(0x31, 0x073a),  KEY_KPASTERISK,     "NEXT MAIN AV1"             },
    {SIRCS_CODE_DEF(0x34, 0x0110),  KEY_FASTFORWARD,    "FF MAIN AV2"               },
    {SIRCS_CODE_DEF(0x34, 0x073a),  KEY_LEFTALT,        "FF MAIN AV1"               },
    {SIRCS_CODE_DEF(0x37, 0x0510),  KEY_NUMERIC_3,      "HDMI OUTPUT MAIN AV2"      },
    {SIRCS_CODE_DEF(0x37, 0x0410),  KEY_SPACE,          "HDMI OUTPUT MAIN AV1"      },
    {SIRCS_CODE_DEF(0x76, 0xb0),    KEY_Q,              "SETUP MENU MAIN AV2"       },
    {SIRCS_CODE_DEF(0x76, 0x90),    KEY_CAPSLOCK,       "SETUP MENU MAIN AV1"       },
    {SIRCS_CODE_DEF(0x73, 0x0d10),  KEY_W,              "TEST MENU MAIN AV2"        },
    {SIRCS_CODE_DEF(0x73, 0x0c10),  KEY_NUMLOCK,        "TEST MENU MAIN AV1"        },
    {SIRCS_CODE_DEF(0x28, 0x0510),  KEY_E,              "AUTO CAL MAIN AV2"         },
    {SIRCS_CODE_DEF(0x28, 0x0410),  KEY_SCROLLLOCK,     "AUTO CAL MAIN AV1"         },
    /* ZONE2 MODE */
    /* Power key is the same as Main mode */
    {SIRCS_CODE_DEF(0x78, 0x79),    KEY_ADDRESSBOOK,    "GAME ZONE2"            },
    {SIRCS_CODE_DEF(0x76, 0x79),    KEY_KP8,            "STB ZONE2"             },
    {SIRCS_CODE_DEF(0x4f, 0x79),    KEY_KP9,            "BD ZONE2"              },
    {SIRCS_CODE_DEF(0x4e, 0x79),    KEY_KPMINUS,        "SAT/CABLE ZONE2"       },
    {SIRCS_CODE_DEF(0x22, 0x79),    KEY_KP4,            "VIDEO1 ZONE2"          },
    {SIRCS_CODE_DEF(0x1d, 0x79),    KEY_KP5,            "AUX 1 ZONE2"           },
    {SIRCS_CODE_DEF(0x6a, 0x79),    KEY_KP6,            "TV ZONE2"              },
    {SIRCS_CODE_DEF(0x25, 0x79),    KEY_KPPLUS,         "SA-CD/CD ZONE2"        },
    {SIRCS_CODE_DEF(0x24, 0x0479),  KEY_KP1,            "OTHERS ZONE2"          },
    {SIRCS_CODE_DEF(0x50, 0x79),    KEY_KP2,            "CURSOR UP ZONE2"       },
    {SIRCS_CODE_DEF(0x52, 0x79),    KEY_KP3,            "CURSOR LEFT ZONE2"     },
    {SIRCS_CODE_DEF(0x53, 0x79),    KEY_KP0,            "CURSOR RIGHT ZONE2"    },
    {SIRCS_CODE_DEF(0x51, 0x79),    KEY_KPDOT,          "CURSOR DOWN ZONE2"     },
    {SIRCS_CODE_DEF(0x54, 0x79),    KEY_ZENKAKUHANKAKU, "ENTER ZONE2"           },
    {SIRCS_CODE_DEF(0x59, 0x79),    KEY_102ND,          "MENU RETURN ZONE2"     },
    {SIRCS_CODE_DEF(0x58, 0x79),    KEY_RO,             "MENU ZONE2"            },
    {SIRCS_CODE_DEF(0x14, 0x79),    KEY_KATAKANA,       "MUTING ZONE2"          },
    {SIRCS_CODE_DEF(0x12, 0x79),    KEY_HIRAGANA,       "VOL+ ZONE2"            },
    {SIRCS_CODE_DEF(0x13, 0x79),    KEY_HENKAN,         "VOL- ZONE2"            },
    {SIRCS_CODE_DEF(0x30, 0x79),    KEY_FIRST,          "PREVIOUS ZONE2"        },
    {SIRCS_CODE_DEF(0x33, 0x79),    KEY_SPELLCHECK,     "FR ZONE2"              },
    {SIRCS_CODE_DEF(0x31, 0x79),    KEY_VOICEMAIL,      "NEXT ZONE2"            },
    {SIRCS_CODE_DEF(0x34, 0x79),    KEY_LOGOFF,         "FF ZONE2"              },
    /* ZONE3 MODE */                
    /* Power key is the same as Main mode */
    {SIRCS_CODE_DEF(0x78, 0x0179),  KEY_KATAKANAHIRAGANA,   "GAME ZONE3"            },
    {SIRCS_CODE_DEF(0x76, 0x0179),  KEY_MUHENKAN,           "STB ZONE3"             },
    {SIRCS_CODE_DEF(0x4f, 0x0179),  KEY_KPJPCOMMA,          "BD ZONE3"              },
    {SIRCS_CODE_DEF(0x4e, 0x0179),  KEY_KPENTER,            "SAT/CABLE ZONE3"       },
    {SIRCS_CODE_DEF(0x22, 0x0179),  KEY_RIGHTCTRL,          "VIDEO1 ZONE3"          },
    {SIRCS_CODE_DEF(0x1d, 0x0179),  KEY_KPSLASH,            "AUX 1 ZONE3"           },
    {SIRCS_CODE_DEF(0x6a, 0x0179),  KEY_SYSRQ,              "TV ZONE3"              },
    {SIRCS_CODE_DEF(0x25, 0x0179),  KEY_RIGHTALT,           "SA-CD/CD ZONE3"        },
    {SIRCS_CODE_DEF(0x24, 0x0579),  KEY_LINEFEED,           "OTHERS ZONE3"          },
    {SIRCS_CODE_DEF(0x50, 0x0179),  KEY_END,                "CURSOR UP ZONE3"       },
    {SIRCS_CODE_DEF(0x52, 0x0179),  KEY_INSERT,             "CURSOR LEFT ZONE3"     },
    {SIRCS_CODE_DEF(0x53, 0x0179),  KEY_DELETE,             "CURSOR RIGHT ZONE3"    },
    {SIRCS_CODE_DEF(0x51, 0x0179),  KEY_MACRO,              "CURSOR DOWN ZONE3"     },
    {SIRCS_CODE_DEF(0x54, 0x0179),  KEY_KPEQUAL,            "ENTER ZONE3"           },
    {SIRCS_CODE_DEF(0x59, 0x0179),  KEY_KPPLUSMINUS,        "MENU RETURN ZONE3"     },
    {SIRCS_CODE_DEF(0x58, 0x0179),  KEY_SCALE,              "MENU ZONE3"            },
    {SIRCS_CODE_DEF(0x14, 0x0179),  KEY_KPCOMMA,            "MUTING ZONE3"          },
    {SIRCS_CODE_DEF(0x12, 0x0179),  KEY_HANGEUL,            "VOL+ ZONE3"            },
    {SIRCS_CODE_DEF(0x13, 0x0179),  KEY_MP3,                "VOL- ZONE3"            },
    {SIRCS_CODE_DEF(0x30, 0x0179),  KEY_AB,                 "PREVIOUS ZONE3"        },
    {SIRCS_CODE_DEF(0x33, 0x0179),  KEY_DISPLAYTOGGLE,      "FR ZONE3"              },
    {SIRCS_CODE_DEF(0x31, 0x0179),  KEY_LAST,               "NEXT ZONE3"            },
    {SIRCS_CODE_DEF(0x34, 0x0179),  KEY_MESSENGER,          "FF ZONE3"              },

    /* DEALER MODE(MAIN) */
    {SIRCS_CODE_DEF(0x2e, 0x0179),  KEY_LIST,       "POWER ON(ZONE3)"           },
    {SIRCS_CODE_DEF(0x2e, 0x79),    KEY_HANJA,      "POWER ON(ZONE2)"           },
    {SIRCS_CODE_DEF(0x2e, 0x30),    KEY_F14,        "POWER ON AV2"              },
    {SIRCS_CODE_DEF(0x2e, 0x10),    KEY_YEN,        "POWER ON AV1"              },
    {SIRCS_CODE_DEF(0x71, 0x0510),  KEY_BLUETOOTH,  "Bluetooth MAIN AV2"        },
    {SIRCS_CODE_DEF(0x71, 0x0410),  KEY_LEFTMETA,   "Bluetooth MAIN AV1"        },
    {SIRCS_CODE_DEF(0x18, 0x30),    KEY_RIGHTMETA,  "FM MAIN AV2"               },
    {SIRCS_CODE_DEF(0x18, 0x10),    KEY_COMPOSE,    "FM MAIN AV1"               },
    {SIRCS_CODE_DEF(0x17, 0x0510),  KEY_NUMERIC_7,  "USB MAIN AV2"              },
    {SIRCS_CODE_DEF(0x17, 0x0410),  KEY_AGAIN,      "USB MAIN AV1"              },
    {SIRCS_CODE_DEF(0x6e, 0x0510),  KEY_PROPS,      "WATCH MAIN AV2"            },
    {SIRCS_CODE_DEF(0x6e, 0x0410),  KEY_UNDO,       "WATCH MAIN AV1"            },
    {SIRCS_CODE_DEF(0x6f, 0x0510),  KEY_FRONT,      "LISTEN1/LINE IN MAIN AV2"  },
    {SIRCS_CODE_DEF(0x6f, 0x0410),  KEY_COPY,       "LISTEN1/LINE IN MAIN AV1"  },
    {SIRCS_CODE_DEF(0x7d, 0x0510),  KEY_OPEN,       "CP(SOFA MODE) MAIN AV2"    },
    {SIRCS_CODE_DEF(0x7d, 0x0410),  KEY_PASTE,      "CP(SOFA MODE) MAIN AV1"    },
    {SIRCS_CODE_DEF(0x64, 0x0510),  KEY_FIND,       "SOUND EFFECT MAIN AV2"     },
    {SIRCS_CODE_DEF(0x64, 0x0410),  KEY_CUT,        "SOUND EFFECT MAIN AV1"     },
    {SIRCS_CODE_DEF(0x7c, 0xb0),    KEY_HELP,       "Zone Controls MAIN AV2"    },
    {SIRCS_CODE_DEF(0x7c, 0x90),    KEY_CALC,       "Zone Controls MAIN AV1"    },
    /* CUSTOM PRESET1 key is the same as normal mode */
    {SIRCS_CODE_DEF(0x59, 0x30),    KEY_FILE,       "CUSTOM PRESET2 MAIN AV2"   },
    {SIRCS_CODE_DEF(0x59, 0x10),    KEY_SENDFILE,   "CUSTOM PRESET2 MAIN AV1"   },
    {SIRCS_CODE_DEF(0x72, 0x0d10),  KEY_DELETEFILE, "TEST PICTURE MAIN AV2"     },
    {SIRCS_CODE_DEF(0x72, 0x0c10),  KEY_XFER,       "TEST PICTURE MAIN AV1"     },
    {SIRCS_CODE_DEF(0x70, 0x0d10),  KEY_PROG1,      "SPEAKER SETUP MAIN AV2"    },
    {SIRCS_CODE_DEF(0x70, 0x0c10),  KEY_PROG2,      "SPEAKER SETUP MAIN AV1"    },
    /* CURSOR key is the same as normal mode */
    /* ENTER key is the same as normal mode */
    /* MENU RETURN key is the same as normal mode */
    /* ON SCREEN key is the same as normal mode */
    {SIRCS_CODE_DEF(0x0e, 0x30),    KEY_COMPUTER,       "MEMORY MAIN AV2"       },
    {SIRCS_CODE_DEF(0x0e, 0x10),    KEY_CLOSECD,        "MEMORY MAIN AV1"       },
    {SIRCS_CODE_DEF(0x2d, 0xb0),    KEY_EJECTCD,        "STEREO/MONO MAIN AV2"  },
    {SIRCS_CODE_DEF(0x2d, 0x90),    KEY_EJECTCLOSECD,   "STEREO/MONO MAIN AV1"  },
    {SIRCS_CODE_DEF(0x20, 0x0d10),  KEY_RECORD,         "MUTING ON MAIN AV2"    },
    {SIRCS_CODE_DEF(0x20, 0x0c10),  KEY_PHONE,          "MUTING ON MAIN AV1"    },
    /* VOL key is the same as normal mode */
    {SIRCS_CODE_DEF(0x69, 0xb0),    KEY_NUMERIC_8,      "FUNCTION+ MAIN AV2"    },
    {SIRCS_CODE_DEF(0x69, 0x90),    KEY_REFRESH,        "FUNCTION+ MAIN AV1"    },
    {SIRCS_CODE_DEF(0x6a, 0xb0),    KEY_NUMERIC_9,      "FUNCTION- MAIN AV2"    },
    {SIRCS_CODE_DEF(0x6a, 0x90),    KEY_EXIT,           "FUNCTION- MAIN AV1"    },
    {SIRCS_CODE_DEF(0x2c, 0xb0),    KEY_MOVE,           "TUNING- MAIN AV2"      },
    {SIRCS_CODE_DEF(0x2c, 0x90),    KEY_EDIT,           "TUNING- MAIN AV1"      },
    {SIRCS_CODE_DEF(0x21, 0x0d10),  KEY_KPLEFTPAREN,    "MUTING OFF MAIN AV2"   },
    {SIRCS_CODE_DEF(0x21, 0x0c10),  KEY_KPRIGHTPAREN,   "MUTING OFF MAIN AV1"   },
    {SIRCS_CODE_DEF(0x2b, 0xb0),    KEY_NEW,            "TUNING+ MAIN AV2"      },
    {SIRCS_CODE_DEF(0x2b, 0x90),    KEY_REDO,           "TUNING+ MAIN AV1"      },
    {SIRCS_CODE_DEF(0x30, 0xb0),    KEY_F24,            "INPUT MODE MAIN AV2"   },
    {SIRCS_CODE_DEF(0x30, 0x90),    KEY_PROG3,          "INPUT MODE MAIN AV1"   },
    {SIRCS_CODE_DEF(0x71, 0x0d10),  KEY_PROG4,          "INPUT SETUP MAIN AV2"  },
    {SIRCS_CODE_DEF(0x71, 0x0c10),  KEY_DASHBOARD,      "INPUT SETUP MAIN AV1"  },
    {SIRCS_CODE_DEF(0x4a, 0xb0),    KEY_SUSPEND,        "TEST TONE MAIN AV2"    },
    {SIRCS_CODE_DEF(0x4a, 0x90),    KEY_CLOSE,          "TEST TONE MAIN AV1"    },
    /* DEALER MODE(ZONE2) */
    {SIRCS_CODE_DEF(0x2f, 0x0179),  KEY_BASSBOOST,          "POWER OFF(ZONE3)"          },
    {SIRCS_CODE_DEF(0x2f, 0x79),    KEY_HP,                 "POWER OFF(ZONE2)"          },
    {SIRCS_CODE_DEF(0x2f, 0x30),    KEY_F15,                "POWER OFF AV2"             },
    {SIRCS_CODE_DEF(0x2f, 0x10),    KEY_SOUND,              "POWER OFF AV1"             },
    {SIRCS_CODE_DEF(0x1a, 0x0d10),  KEY_QUESTION,           "2ch Stereo ZONE2 AV2"      },
    {SIRCS_CODE_DEF(0x1a, 0x0c10),  KEY_EMAIL,              "2ch Stereo ZONE2 AV1"      },
    {SIRCS_CODE_DEF(0x0a, 0x0d10),  KEY_CHAT,               "Multi Ch Stereo ZONE2 AV2" },
    {SIRCS_CODE_DEF(0x0a, 0x0c10),  KEY_SEARCH,             "Multi Ch Stereo ZONE2 AV1" },
    {SIRCS_CODE_DEF(0x00, 0x0d10),  KEY_CONNECT,            "Direct ZONE2 AV2"          },
    {SIRCS_CODE_DEF(0x00, 0x0c10),  KEY_FINANCE,            "Direct ZONE2 AV1"          },
    {SIRCS_CODE_DEF(0x47, 0xb0),    KEY_SPORT,              "A.F.D. ZONE2 AV2"          },
    {SIRCS_CODE_DEF(0x47, 0x90),    KEY_SHOP,               "A.F.D. ZONE2 AV1"          },
    {SIRCS_CODE_DEF(0x02, 0x0d10),  KEY_ALTERASE,           "Dolby Mode ZONE2 AV2"      },
    {SIRCS_CODE_DEF(0x02, 0x0c10),  KEY_CANCEL,             "Dolby Mode ZONE2 AV1"      },
    {SIRCS_CODE_DEF(0x08, 0x0d10),  KEY_BRIGHTNESSDOWN,     "DTS Mode ZONE2 AV2"        },
    {SIRCS_CODE_DEF(0x08, 0x0c10),  KEY_BRIGHTNESSUP,       "DTS Mode ZONE2 AV1"        },
    {SIRCS_CODE_DEF(0x0f, 0x0d10),  KEY_MEDIA,              "A.F.D Movie ZONE2 AV2"     },
    {SIRCS_CODE_DEF(0x0f, 0x0c10),  KEY_SWITCHVIDEOMODE,    "A.F.D Movie ZONE2 AV1"     },
    {SIRCS_CODE_DEF(0x1b, 0x0d10),  KEY_KBDILLUMTOGGLE,     "DSEE ZONE2 AV2"            },
    {SIRCS_CODE_DEF(0x1b, 0x0c10),  KEY_KBDILLUMDOWN,       "DSEE ZONE2 AV1"            },
    {SIRCS_CODE_DEF(0x64, 0x0d10),  KEY_KBDILLUMUP,         "FRONT SP A+B ZONE2 AV2"    },
    {SIRCS_CODE_DEF(0x64, 0x0c10),  KEY_SEND,               "FRONT SP A+B ZONE2 AV1"    },
    {SIRCS_CODE_DEF(0x62, 0x0d10),  KEY_REPLY,              "FRONT SP A ZONE2 AV2"      },
    {SIRCS_CODE_DEF(0x62, 0x0c10),  KEY_FORWARDMAIL,        "FRONT SP A ZONE2 AV1"      },
    {SIRCS_CODE_DEF(0x63, 0x0d10),  KEY_DOCUMENTS,          "FRONT SP B ZONE2 AV2"      },
    {SIRCS_CODE_DEF(0x63, 0x0c10),  KEY_BATTERY,            "FRONT SP B ZONE2 AV1"      },
    {SIRCS_CODE_DEF(0x61, 0x0d10),  KEY_WLAN,               "FRONT SP OFF ZONE2 AV2"    },
    {SIRCS_CODE_DEF(0x61, 0x0c10),  KEY_UWB,                "FRONT SP OFF ZONE2 AV1"    },
    {SIRCS_CODE_DEF(0x10, 0xb0),    KEY_F7,                 "DIMMER ZONE2 AV2"          },
    {SIRCS_CODE_DEF(0x10, 0x90),    KEY_UNKNOWN,            "DIMMER ZONE2 AV1"          },
    {SIRCS_CODE_DEF(0x12, 0x0110),  KEY_AUDIO,              "AUDIO ZONE2 AV2"           },
    {SIRCS_CODE_DEF(0x12, 0x073a),  KEY_VIDEO_NEXT,         "AUDIO ZONE2 AV1"           },
    {SIRCS_CODE_DEF(0x3d, 0x0510),  KEY_VIDEO_PREV,         "PARTY MODE ON/OFF AV2"     },
    {SIRCS_CODE_DEF(0x3d, 0x0410),  KEY_BRIGHTNESS_CYCLE,   "PARTY MODE ON/OFF AV1"     },
    {SIRCS_CODE_DEF(0x34, 0x0479),  KEY_BRIGHTNESS_AUTO,    "ZONE2 PARTY MODE AV2"      },
    {SIRCS_CODE_DEF(0x34, 0x0579),  KEY_DISPLAY_OFF,        "ZONE2 PARTY MODE AV1"      },
    {SIRCS_CODE_DEF(0x35, 0x0479),  KEY_WWAN,               "ZONE3 PARTY MODE AV2"      },
    {SIRCS_CODE_DEF(0x35, 0x0579),  KEY_RFKILL,             "ZONE3 PARTY MODE AV1"      },
    {SIRCS_CODE_DEF(0x36, 0x0479),  KEY_MICMUTE,            "ZONE2+3 PARTY MODE AV2"    },
    {SIRCS_CODE_DEF(0x36, 0x0579),  KEY_OK,                 "ZONE2+3 PARTY MODE AV1"    },
    {SIRCS_CODE_DEF(0x7c, 0x0510),  KEY_GOTO,               "DSD NATIVE ZONE2 AV2"      },
    {SIRCS_CODE_DEF(0x7c, 0x0410),  KEY_CLEAR,              "DSD NATIVE ZONE2 AV1"      },
    {SIRCS_CODE_DEF(0x6f, 0x0d10),  KEY_INFO,               "IN-CEILING SP ZONE2 AV2"   },
    {SIRCS_CODE_DEF(0x6f, 0x0c10),  KEY_TIME,               "IN-CEILING SP ZONE2 AV1"   },
    {SIRCS_CODE_DEF(0x10, 0x0479),  KEY_VENDOR,             "MUTING ON ZONE2"           },
    {SIRCS_CODE_DEF(0x22, 0x0479),  KEY_ARCHIVE,            "FUNCTION+ ZONE2"           },
    {SIRCS_CODE_DEF(0x23, 0x0479),  KEY_PROGRAM,            "FUNCTION- ZONE2"           },
    {SIRCS_CODE_DEF(0x11, 0x30),    KEY_CHANNEL,            "PRESET- ZONE2 AV2"         },
    {SIRCS_CODE_DEF(0x11, 0x10),    KEY_FAVORITES,          "PRESET- ZONE2 AV1"         },
    {SIRCS_CODE_DEF(0x11, 0x0479),  KEY_EPG,                "MUTING OFF ZONE2"          },
    {SIRCS_CODE_DEF(0x10, 0x30),    KEY_PVR,                "PRESET+ ZONE2 AV2"         },
    {SIRCS_CODE_DEF(0x10, 0x10),    KEY_MHP,                "PRESET+ ZONE2 AV1"         },
    {SIRCS_CODE_DEF(0x43, 0x0510),  KEY_LANGUAGE,           "HDMI OUT A+B ZONE2 AV2"    },
    {SIRCS_CODE_DEF(0x43, 0x0410),  KEY_TITLE,              "HDMI OUT A+B ZONE2 AV1"    },
    {SIRCS_CODE_DEF(0x3e, 0x0510),  KEY_SUBTITLE,           "HDMI OUT A ZONE2 AV2"      },
    {SIRCS_CODE_DEF(0x3e, 0x0410),  KEY_ANGLE,              "HDMI OUT A ZONE2 AV1"      },
    {SIRCS_CODE_DEF(0x3f, 0x0510),  KEY_ZOOM,               "HDMI OUT B ZONE2 AV2"      },
    {SIRCS_CODE_DEF(0x3f, 0x0410),  KEY_KEYBOARD,           "HDMI OUT B ZONE2 AV1"      },
    {SIRCS_CODE_DEF(0x44, 0x0510),  KEY_SCREEN,             "HDMI OUT OFF ZONE2 AV2"    },
    {SIRCS_CODE_DEF(0x44, 0x0410),  KEY_PC,                 "HDMI OUT OFF ZONE2 AV1"    },
    /* DEALER MODE(ZONE3) */
    /* Power key is the same as DEALER MODE(MAIN) */
    {SIRCS_CODE_DEF(0x10, 0x0579),  KEY_TV2,        "MUTING ON ZONE3"           },
    {SIRCS_CODE_DEF(0x22, 0x0579),  KEY_VCR,        "FUNCTION+ ZONE3"           },
    {SIRCS_CODE_DEF(0x23, 0x0579),  KEY_VCR2,       "FUNCTION- ZONE3"           },
    {SIRCS_CODE_DEF(0x11, 0x0579),  KEY_CD,         "MUTING OFF ZONE3"          },
    {SIRCS_CODE_DEF(0x7f, 0x0d10),  KEY_F13,        "INITIALIZE ZONE3 AV2"      },
    {SIRCS_CODE_DEF(0x7f, 0x0c10),  KEY_WWW,        "INITIALIZE ZONE3 AV1"      },
    {SIRCS_CODE_DEF(0x7e, 0x0d10),  KEY_F12,        "DEMO MODE ZONE3 AV2"       },
    {SIRCS_CODE_DEF(0x7e, 0x0c10),  KEY_MSDOS,      "DEMO MODE ZONE3 AV1"       },
    {SIRCS_CODE_DEF(0x37, 0x04),    KEY_POWER2,     "SYSTEM POWER OFF ZONE3"    },
};

#endif /* _SIRCS_C_ */

#endif /* _SIRCS_CODE_TABLE_H_ */
