/* SPDX-License-Identifier: GPL-2.0 */
/*
 * IFCON Communication Driver header
 *
 * Copyright 2017, 2018, 2019, 2020, 2021, 2022 Sony Corporation
 *
 */

#ifndef DRIVERS_IFCON_DRV_IFCON_DRV_H_
#define DRIVERS_IFCON_DRV_IFCON_DRV_H_

#include <linux/types.h>

#define IFCON_DRV_DEVNAME "ifcon_drv"

/*---- read / wrire --------------------------------------------------------*/

#define IFCON_DRV_FRAME_TYPE0	0	/* Normal size frame (default) */
#define IFCON_DRV_FRAME_TYPE1	1	/* Large size frame            */

/* Frame type 0 : FRAME_ALL_SIZE 256 [byte] ----------------*/

struct ifcon_drv_frame_ctl_def {
	__u8	frame_size;	/* frame size */
	__u8	ctl_0;		/* ctrl data0 */
	__u8	ctl_1;		/* ctrl data1 */
	__u8	dest;		/* destination */
};
#define IFCON_DRV_CTL_SIZE	\
	((unsigned int)sizeof(struct ifcon_drv_frame_ctl_def))

struct ifcon_drv_frame_def {
	struct ifcon_drv_frame_ctl_def	info;	/* frame ctrl info */
	__u8   data[236];
};
#define IFCON_DRV_DATA_SIZE	\
	((unsigned int)sizeof(struct ifcon_drv_frame_def.data))

/* one package max size */
#define IFCON_DRV_PACKAGE_SIZE_MAX	\
	((unsigned int)sizeof(struct ifcon_drv_frame_def))
/* Total package size */
#define IFCON_DRV_RW_DATA_SIZE		\
	((unsigned int)sizeof(struct ifcon_drv_frame_def))

#define IFCON_DRV_PACKET_CTRL_AREA_SIZE		(8)
#define IFCON_DRV_FIXED_DATA_SIZE		(6)
#define IFCON_DRV_PACKET_DATA_OFFSET \
		(IFCON_DRV_PACKET_CTRL_AREA_SIZE + \
		 IFCON_DRV_FIXED_DATA_SIZE)
#define IFCON_DRV_CHECK_SUM_SIZE		(2)
#define IFCON_DRV_FRAME_ALL_SIZE \
		(IFCON_DRV_PACKET_CTRL_AREA_SIZE + \
		 IFCON_DRV_FIXED_DATA_SIZE + \
		 IFCON_DRV_RW_DATA_SIZE + \
		 IFCON_DRV_CHECK_SUM_SIZE)

/* Frame common area */
/* Base size is excluding the data part */
#define IFCON_DRV_FRAME_BASE_SIZE	\
	(IFCON_DRV_FRAME_ALL_SIZE - IFCON_DRV_RW_DATA_SIZE)

/* Frame type 1 : FRAME_ALL_SIZE 576 [byte] ----------------*/

struct ifcon_drv_t1_frame_ctl_def {
	__u8	frame_size_l;	/* frame size low  */
	__u8	frame_size_h;	/* frame size high */
	__u8	ctl_0;		/* ctrl data0 */
	__u8	dest;		/* destination */
};
#define IFCON_DRV_T1_CTL_SIZE	\
	((unsigned int)sizeof(struct ifcon_drv_t1_frame_ctl_def))

struct ifcon_drv_t1_frame_def {
	struct ifcon_drv_t1_frame_ctl_def	info;	/* frame ctrl info */
	__u8   data[556];
};
#define IFCON_DRV_T1_DATA_SIZE	\
	((unsigned int)sizeof(struct ifcon_drv_t1_frame_def.data))

/* one package max size */
#define IFCON_DRV_T1_PACKAGE_SIZE_MAX	\
	((unsigned int)sizeof(struct ifcon_drv_t1_frame_def))
/* Total package size */
#define IFCON_DRV_T1_RW_DATA_SIZE	\
	((unsigned int)sizeof(struct ifcon_drv_t1_frame_def))

#define IFCON_DRV_T1_PACKET_CTRL_AREA_SIZE	IFCON_DRV_PACKET_CTRL_AREA_SIZE
#define IFCON_DRV_T1_FIXED_DATA_SIZE		IFCON_DRV_FIXED_DATA_SIZE
#define IFCON_DRV_T1_CHECK_SUM_SIZE		IFCON_DRV_CHECK_SUM_SIZE
#define IFCON_DRV_T1_FRAME_ALL_SIZE \
		(IFCON_DRV_T1_PACKET_CTRL_AREA_SIZE + \
		 IFCON_DRV_T1_FIXED_DATA_SIZE + \
		 IFCON_DRV_T1_RW_DATA_SIZE + \
		 IFCON_DRV_T1_CHECK_SUM_SIZE)


/*---- IOCTL ---------------------------------------------------------------*/
#define IFCON_DRV_IOC_MAGIC	'i'

/* Parameter of IFCON_IOC_WRITE_FIXED / IFCON_IOC_READ_FIXED */
struct st_ifcon_fixed_data_param_def {
	__u32	offset;	/* offset from top address */
	__u32	sz;	/* data size */
	__u8	*data;	/* data pointer */
};

#define IFCON_DRV_IOC_WRITE_FIXED			\
		_IOW(IFCON_DRV_IOC_MAGIC, 0x90,		\
		struct st_ifcon_fixed_data_param_def)
#define IFCON_DRV_IOC_READ_FIXED			\
		_IOR(IFCON_DRV_IOC_MAGIC, 0x90,		\
		struct st_ifcon_fixed_data_param_def)

#define IFCON_DRV_OK			(0)
#define IFCON_DRV_NG			(-1)

#define IFCON_DRV_NOT_CONNECT		(0x00F2)
#define IFCON_DRV_BUFF_FULL		(0x00F3)
#define IFCON_DRV_RX_BUFF_SIZE_ERROR	(0x00F4)
#define IFCON_DRV_SUSPEND		(0x00F7)
#define IFCON_DRV_BADTYPE		(0x00F8)

#endif	/* DRIVERS_IFCON_DRV_IFCON_DRV_H_ */
