/* SPDX-License-Identifier: GPL-2.0 */
#ifndef __DRIVERS_USB_CHIPIDEA_HOST_H
#define __DRIVERS_USB_CHIPIDEA_HOST_H

#ifdef CONFIG_USB_CHIPIDEA_HOST

int ci_hdrc_host_init(struct ci_hdrc *ci);
void ci_hdrc_host_destroy(struct ci_hdrc *ci);
void ci_hdrc_host_driver_init(void);
bool ci_hdrc_reg_vbus_is_enabled(struct ci_hdrc *ci);
int ci_hdrc_reg_vbus(struct ci_hdrc *ci, bool enable);

#else

static inline int ci_hdrc_host_init(struct ci_hdrc *ci)
{
	return -ENXIO;
}

static inline void ci_hdrc_host_destroy(struct ci_hdrc *ci)
{

}

static inline void ci_hdrc_host_driver_init(void)
{

}

static inline bool ci_hdrc_reg_vbus_is_enabled(struct ci_hdrc *ci)
{	/* Note: Implement stub as static. */
	return false;
}

static inline int ci_hdrc_reg_vbus(struct ci_hdrc *ci, bool enable)
{	/* Note: Implement stub as static. */
	return 0;
}

static inline int ci_hdrc_reg_vbus_root_power(struct ci_hdrc *ci,
	bool rh_vbus)
{	/* Note: Implement stub as static. */
	return 0;
}

#endif

#endif /* __DRIVERS_USB_CHIPIDEA_HOST_H */
