/* SPDX-License-Identifier: GPL-2.0 */
/*
 * cm4.h - CM4 communication driver header
 *
 * Copyright 2019, 2020, 2021, 2022, 2023 Sony Corporation
 */


#ifndef _LINUX_RPMSG_CM4_H
#define _LINUX_RPMSG_CM4_H

#define CM4_MSG_HEADER_LEN 4

/*******************************************************************************
 * Definition
 ******************************************************************************/
enum cm4_message_id {
	CM4_MESSAGE_ID_SYSTEM = 0x01,
	CM4_MESSAGE_ID_CEC = 0x02,
	CM4_MESSAGE_ID_SIRCS = 0x03,
	CM4_MESSAGE_ID_CONSOLE = 0x04,
	CM4_MESSAGE_ID_LED = 0x05,
	CM4_MESSAGE_ID_232C = 0x06,
	CM4_MESSAGE_ID_KEY = 0x07,
	CM4_MESSAGE_ID_KPAV = 0x08,
};

enum cm4_message_type {
	CM4_MESSAGE_TYPE_REQ = 0x01,
	CM4_MESSAGE_TYPE_RES = 0x02,
};


typedef void (*cm4_rx_cb_t)(u8 type, u8 length, u8 seq, u8 *data);


/*******************************************************************************
 * Function
 ******************************************************************************/
#ifdef CONFIG_RPMSG_CM4_EVENT_DISPATCHER
int rpmsg_cm4_send(enum cm4_message_id id, u8 type, u8 length, u8 seq,
								u8 *data);
int rpmsg_cm4_register_callback(enum cm4_message_id id, cm4_rx_cb_t func);
void rpmsg_cm4_accut_notifier(void);
#else

static inline int rpmsg_cm4_send(enum cm4_message_id id, u8 type, u8 length,
							u8 seq, u8 *data)
{
	return -ENXIO;
}
static inline int rpmsg_cm4_register_callback(enum cm4_message_id id,
							cm4_rx_cb_t func)
{
	return -ENXIO;
}
static inline void rpmsg_cm4_accut_notifier(void)
{
	return -ENXIO;
}


#endif

#endif /* _LINUX_RPMSG_CM4_H */
