/* SPDX-License-Identifier: GPL-2.0-only */
/* include/linux/fec.h
 *
 * Copyright (c) 2009 Orex Computed Radiography
 *   Baruch Siach <baruch@tkos.co.il>
 *
 * Copyright (C) 2010 Freescale Semiconductor, Inc.
 * Copyright 2022 Sony Corporation
 *
 * Header file for the FEC platform data
 */
#ifndef __LINUX_FEC_H__
#define __LINUX_FEC_H__

#include <linux/phy.h>

struct fec_platform_data {
	phy_interface_t phy;
	unsigned char mac[ETH_ALEN];
	void (*sleep_mode_enable)(int enabled);
};

int fec_enet_get_wol_wake(void);
#define FEC_WOL_PHY_WAKE_OFF		0
#define FEC_WOL_PHY_WAKE_ON		1

#endif
