/* SPDX-License-Identifier: GPL-2.0-or-later */
/*
 * fixed.h
 *
 * Copyright 2008 Wolfson Microelectronics PLC.
 * Copyright 2019, 2021, 2022 Sony Corporation
 *
 * Author: Mark Brown <broonie@opensource.wolfsonmicro.com>
 *
 * Copyright (c) 2009 Nokia Corporation
 * Roger Quadros <ext-roger.quadros@nokia.com>
 */

#ifndef __REGULATOR_FIXED_H
#define __REGULATOR_FIXED_H

struct regulator_init_data;

/**
 * struct fixed_voltage_config - fixed_voltage_config structure
 * @supply_name:	Name of the regulator supply
 * @input_supply:	Name of the input regulator supply
 * @microvolts:		Output voltage of regulator
 * @startup_delay:	Start-up time in microseconds
 * @shutdown_delay:	shutdown time in microseconds
 * @enabled_at_boot:	Whether regulator has been enabled at
 * 			boot or not. 1 = Yes, 0 = No
 * 			This is used to keep the regulator at
 * 			the default state
 * @init_data:		regulator_init_data
 *
 * This structure contains fixed voltage regulator configuration
 * information that must be passed by platform code to the fixed
 * voltage regulator driver.
 */
struct fixed_voltage_config {
	const char *supply_name;
	const char *input_supply;
	int microvolts;
	unsigned startup_delay;
#ifdef CONFIG_REGULATOR_SHUTDOWN_DELAY_TIME
	unsigned shutdown_delay;
#endif /* CONFIG_REGULATOR_SHUTDOWN_DELAY_TIME */
	unsigned int off_on_delay;
#ifdef CONFIG_REGULATOR_INDEPEND
	unsigned independ_auto_disable:1;
#endif /* CONFIG_REGULATOR_INDEPEND */
	unsigned enabled_at_boot:1;
	struct regulator_init_data *init_data;
};

struct regulator_consumer_supply;

#if IS_ENABLED(CONFIG_REGULATOR)
struct platform_device *regulator_register_always_on(int id, const char *name,
		struct regulator_consumer_supply *supplies, int num_supplies, int uv);
#else
static inline struct platform_device *regulator_register_always_on(int id, const char *name,
		struct regulator_consumer_supply *supplies, int num_supplies, int uv)
{
	return NULL;
}
#endif

#define regulator_register_fixed(id, s, ns) regulator_register_always_on(id, \
						"fixed-dummy", s, ns, 0)

#endif
