// SPDX-License-Identifier: GPL-2.0
/*
 * sony_sw_pll.h : Sony software pll driver
 *
 *  Copyright 2020 Sony Home Entertainment & Sound Products Inc.
 */


#ifndef _SW_PLL_Driver_h
#define _SW_PLL_Driver_h

#define REF_INVAL      0x1
#define FB_INVAL       0x2
#define FB_TIMEOUT     0x4
#define DSM_UNDER      0x8
#define DSM_OVER      0x10
#define PHASE_OVF     0x20
#define PHASE_JUMP    0x40
#define INTVL_OVER   0x100
#define INTVL_UNDER  0x200
#define PHASE_SPIKE 0x1000
#define T1_UNDER   0x10000
#define OFS_OVER   0x20000

#define MUTE_REL   0x1
#define CHNG_HLD   0x2

#define SW_PLL_MODE_NONE 0
#define SW_PLL_MODE_OPT 1
#define SW_PLL_MODE_I2S 2

#define SPDIF_CBITS_INVALID (1ull << 63)

#define posMax  50
#define idxMax  50
#define grpMax  20

enum _State {
	Fixed = 0,
	Invalid,
	Change,
	Transition,
	Stable,
	State_max,
};

typedef struct SW_PLL_Parameter {
	uint32_t  RBCR;
	uint32_t  RBCTR;
	uint32_t  TBCR;
	uint32_t  TBCTR;
	uint8_t   Fixed_fs;
	uint8_t   Mute_Ack;
	uint32_t  Valid_Upper[8];
	uint32_t  Valid_Lower[8];
	uint16_t  Ph_Para[14];
	uint32_t  Trans_Time[5];
	uint8_t   Valid_Count;
	uint16_t  Frq_Para[19];
	uint32_t  Cond_Flag;
} SW_PLL_PARA;

typedef struct SW_PLL_Status {
	int16_t   PLL_DSM;
	uint16_t  PLL_MAIN_DIV;
	uint8_t   PLL_PRE_DIV;
	uint8_t   TCR2_DIV;
	uint8_t   Detect_fs;
	uint8_t   Mute_Req;
	uint32_t  Alert;
	uint8_t   State;
	int32_t   PLL2_Freq;
	int32_t   Phase_Err;
} SW_PLL_STAT;

extern int register_sw_pll_notifier(struct notifier_block *nb);
extern int unregister_sw_pll_notifier(struct notifier_block *nb);

extern int sw_pll_set_spdif_event(uint32_t spdif_event_flag);

extern int sw_pll_set_fixed(uint8_t is_fixed);

extern int sw_pll_get_dsm_lock(void);
extern int sw_pll_get_dsm_unlock(void);

extern int sw_pll_register_cbits_read_func(u64 (*cbits_read)(int, int*));
extern int sw_pll_register_lock_read_func(int (*lock_read)(int*, int*, int*, uint32_t*));
extern int sw_pll_register_softreset_func(int (*softreset)(void));

extern int sw_pll_set_mode(uint8_t spdif_i2s);

extern int sw_pll_set_task_enable(uint8_t enable);

#endif  // _SW_PLL_Driver_h
