/*
 * mt8570-adsp-utils.h  --  Mediatek 8570 adsp utility
 *
 * Copyright (c) 2018 MediaTek Inc.
 * Author: Hidalgo Huang <hidalgo.huang@mediatek.com>
 * Copyright 2022 Sony Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef _MT8570_ADSP_UTILS_H_
#define _MT8570_ADSP_UTILS_H_

#include <soc/mediatek/hifi4dsp/audio_task_manager.h>
#include <soc/mediatek/hifi4dsp/audio_shared_info.h>

#define HOST_VOLUME_MAX_LEVEL 100

#ifdef CONFIG_SND_SOC_MT8570_COMPRESS
#ifndef CONFIG_SND_SOC_COMPRESS_NR_PLAYBACK_STREAMS
#define CONFIG_SND_SOC_COMPRESS_NR_PLAYBACK_STREAMS 1
#endif
#endif

enum {
	MT8570_ADSP_FE_MIC_RECORD = 0,
#ifdef CONFIG_SND_SOC_MT8570_ADSP_VOICE_ASSIST
	MT8570_ADSP_FE_VA_HOSTLESS,
	MT8570_ADSP_FE_VA_UPLOAD,
#endif
#ifdef CONFIG_SND_SOC_MT8570_ADSP_PCM_PLAYBACK
	MT8570_ADSP_FE_PCM_PLAYBACK1,
#endif
#ifdef CONFIG_SND_SOC_MT8570_COMPRESS
#if CONFIG_SND_SOC_COMPRESS_NR_PLAYBACK_STREAMS > 0
	MT8570_ADSP_FE_COMPR_PLAYBACK1,
#endif
#if CONFIG_SND_SOC_COMPRESS_NR_PLAYBACK_STREAMS > 1
	MT8570_ADSP_FE_COMPR_PLAYBACK2,
#endif
#if CONFIG_SND_SOC_COMPRESS_NR_PLAYBACK_STREAMS > 2
	MT8570_ADSP_FE_COMPR_PLAYBACK3,
#endif
#endif
#ifdef CONFIG_SND_SOC_MT8570_ADSP_LINEIN_CAPTURE
	MT8570_ADSP_FE_LINEIN_RECORD,
#endif
	MT8570_ADSP_FE_CNT,
	MT8570_ADSP_BE_START = MT8570_ADSP_FE_CNT,
	MT8570_ADSP_BE_MIC_RECORD = MT8570_ADSP_BE_START,
	MT8570_ADSP_BE_PRIMARY_PLAYBACK,
	MT8570_ADSP_BE_LINEIN_RECORD,
	MT8570_ADSP_BE_END,
	MT8570_ADSP_BE_CNT = MT8570_ADSP_BE_END - MT8570_ADSP_BE_START,
#ifdef CONFIG_SND_SOC_MT8570_ADSP_PCM_PLAYBACK
	MT8570_ADSP_FE_PCM_BASE = MT8570_ADSP_FE_PCM_PLAYBACK1,
	MT8570_ADSP_FE_PCM_END = MT8570_ADSP_FE_PCM_PLAYBACK1,
	MT8570_ADSP_FE_PCM_CNT = MT8570_ADSP_FE_PCM_END -
				 MT8570_ADSP_FE_PCM_BASE + 1,
#endif
};

enum {
#ifdef CONFIG_SND_SOC_MT8570_COMPRESS
#if CONFIG_SND_SOC_COMPRESS_NR_PLAYBACK_STREAMS > 0
	MT8570_ADSP_COMPR_PLAYBACK1,
#endif
#if CONFIG_SND_SOC_COMPRESS_NR_PLAYBACK_STREAMS > 1
	MT8570_ADSP_COMPR_PLAYBACK2,
#endif
#if CONFIG_SND_SOC_COMPRESS_NR_PLAYBACK_STREAMS > 2
	MT8570_ADSP_COMPR_PLAYBACK3,
#endif
#endif
	MT8570_ADSP_COMPR_STREAM_CNT,
#ifdef CONFIG_SND_SOC_MT8570_COMPRESS
	MT8570_ADSP_COMPRP_STREAM_CNT =
		CONFIG_SND_SOC_COMPRESS_NR_PLAYBACK_STREAMS,
#endif
};

enum {
	MT8570_ETDM_DATA_ONE_PIN = 0,
	MT8570_ETDM_DATA_MULTI_PIN,
};

enum {
	MT8570_ETDM_SEPARATE_CLOCK = 0,
	MT8570_ETDM_SHARED_CLOCK,
};

enum {
	MT8570_ETDM_FORMAT_I2S = 0,
	MT8570_ETDM_FORMAT_LJ,
	MT8570_ETDM_FORMAT_RJ,
	MT8570_ETDM_FORMAT_EIAJ,
	MT8570_ETDM_FORMAT_DSPA,
	MT8570_ETDM_FORMAT_DSPB,
};

enum {
	MT8570_UL_TS_MIC_RECORD = 0,
#ifdef CONFIG_SND_SOC_MT8570_ADSP_VOICE_ASSIST
	MT8570_UL_TS_VOICE_UPLOAD,
#endif
	MT8570_UL_TS_CNT
};

struct mt8570_dsp_dma_buffer {
	uint32_t buf_paddr;
	uint32_t buf_size;
	uint32_t hw_offset_paddr;
	uint32_t appl_offset_paddr;
	uint32_t hw_offset;
	uint32_t appl_offset;
};

struct mt8570_host_dma_buffer {
	unsigned char *buf_vaddr;
	uint32_t buf_size;
	uint32_t hw_offset;
	uint32_t transfer;
	atomic_t data_size;
};

struct mt8570_preroll_dma_buffer {
	unsigned char *buf_vaddr;
	dma_addr_t buf_paddr;
	uint32_t buf_size;
	uint32_t hw_offset;
	uint32_t appl_offset;
	uint32_t data_size;
};

struct mt8570_ul_ts_data {
	int id;
	unsigned long long timestamp;
};

const char *mt8570_adsp_dai_name(int id);

int mt8570_adsp_get_scene_by_dai_id(int id);

bool mt8570_adsp_need_ul_dma_copy(int id);

bool mt8570_adsp_need_dl_dma_copy(int id);

bool mt8570_adsp_check_dma_copy_by_ack(int id);

int mt8570_adsp_get_compr_index(int id);

bool mt8570_adsp_is_compr_scene(int scene);

bool mt8570_adsp_is_compr_playback_scene(int scene);

bool mt8570_adsp_is_tdm_config_scene(int scene);

int mt8570_adsp_activate_compr(int id, atomic_t *active);

int mt8570_adsp_deactivate_compr(int id, atomic_t *active);

int mt8570_adsp_send_ipi_cmd(struct ipi_msg_t *p_msg,
			     uint8_t task_scene,
			     uint8_t target,
			     uint8_t data_type,
			     uint8_t ack_type,
			     uint16_t msg_id,
			     uint32_t param1,
			     uint32_t param2,
			     char *payload);

int mt8570_adsp_verify_ack_hw_param(struct host_ipc_msg_hw_param *host_param,
	struct ipi_msg_t *ack_msg,
	struct dsp_ipc_msg_hw_param *dsp_param);

int mt8570_adsp_verify_ack_dbg_param(struct host_debug_start_param *host_param,
	struct ipi_msg_t *ack_msg,
	struct dsp_debug_start_param *dsp_param);

int mt8570_adsp_verify_ack_vol_info(struct ipi_msg_t *ack_msg,
	struct dsp_vol_info *vol_info);

int mt8570_adsp_etdm_format(unsigned int format);

int mt8570_adsp_etdm_data_mode(unsigned int mode);

int mt8570_adsp_etdm_clock_mode(unsigned int mode);

int mt8570_adsp_init_dsp_dmab(struct mt8570_dsp_dma_buffer *dmab);

int mt8570_adsp_reset_dsp_dmab_offset(struct mt8570_dsp_dma_buffer *dmab);

int mt8570_adsp_init_host_dmab(struct mt8570_host_dma_buffer *dmab);

int mt8570_adsp_reset_host_dmab_offset(struct mt8570_host_dma_buffer *dmab);

int mt8570_adsp_init_preroll_dmab(struct mt8570_preroll_dma_buffer *dmab);

int mt8570_adsp_reset_preroll_dmab_offset(
	struct mt8570_preroll_dma_buffer *dmab);

int mt8570_adsp_notify_power_state(int scene);

int mt8570_adsp_clear_power_state(int scene);

int mt8570_adsp_host_to_dsp_vol(int level, struct dsp_vol_info *vol_info);

int mt8570_adsp_dsp_to_host_vol(struct dsp_vol_info *vol_info, int *level);

#endif
