/*
 * mtk-adsp-ppc-def.h  --  Mediatek adsp ppc definition
 *
 * Copyright (c) 2019 MediaTek Inc.
 * Author: Hidalgo Huang <hidalgo.huang@mediatek.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __MTK_ADSP_PPC_DEF_H__
#define __MTK_ADSP_PPC_DEF_H__

#define ADSP_PPC_DEV "/dev/adsp_ppc"

struct ppc_para {
	unsigned int element_id;
	unsigned int para_id;
	unsigned int num;
	int __user *value;
};

struct ppc_elem_byp {
	unsigned int element_id;
	int __user *enable;
};

struct ppc_swip_ver {
	unsigned int id;
	unsigned int ver;
};

struct ppc_elem_dump {
	unsigned int element_id;
	int __user *enable;
};

#define PPC_IOCTL_ENABLE	_IOW('A', 0x00, int)
#define PPC_IOCTL_SET_PARA	_IOWR('A', 0x01, struct ppc_para)
#define PPC_IOCTL_GET_PARA	_IOWR('A', 0x02, struct ppc_para)
#define PPC_IOCTL_SET_MODE	_IOW('A', 0x03, int)
#define PPC_IOCTL_GET_MODE	_IOR('A', 0x04, int)
#define PPC_IOCTL_SET_ELEM_BYP	_IOWR('A', 0x05, struct ppc_elem_byp)
#define PPC_IOCTL_GET_ELEM_BYP	_IOWR('A', 0x06, struct ppc_elem_byp)
#define PPC_IOCTL_TOOL_VER	_IOWR('A', 0x07, unsigned int)
#define PPC_IOCTL_SWIP_VER	_IOWR('A', 0x08, struct ppc_swip_ver)
#define PPC_IOCTL_SET_ELEM_DUMP	_IOWR('A', 0x09, struct ppc_elem_dump)

#endif
