// SPDX-License-Identifier: (GPL-2.0+
//
// MTK DSP machine driver
//
// Copyright (c) 2020 by Sony Corporation. ALL RIGHTS RESERVED.
// Based on imx-dsp.c


#include <linux/module.h>
#include <linux/of_platform.h>
#include <linux/i2c.h>
#include <linux/of_gpio.h>
#include <linux/slab.h>
#include <linux/gpio.h>
#include <linux/clk.h>
#include <sound/soc.h>
#include <sound/jack.h>
#include <sound/control.h>
#include <sound/pcm_params.h>
#include <sound/soc-dapm.h>

#define TEST_BACKEND_WITH_ENDPOINT

struct imx_mtkdsp_audio_data {
	/*struct device_node *afe_plat_node;*/
#ifdef CONFIG_SND_SOC_MT8570
	struct device_node *spi_plat_node;
#endif
	struct snd_soc_dai_link dai[2];
	struct snd_soc_card card;
};

enum {
	/* FE */
	DAI_LINK_FE_BASE = 0,
	DAI_LINK_FE_AFE_BASE = DAI_LINK_FE_BASE,
	DAI_LINK_FE_DLM_PLAYBACK = DAI_LINK_FE_AFE_BASE,
	DAI_LINK_FE_DL2_PLAYBACK,
	DAI_LINK_FE_DL3_PLAYBACK,
	DAI_LINK_FE_DL6_PLAYBACK,
	DAI_LINK_FE_DL8_PLAYBACK,
	DAI_LINK_FE_UL2_CAPTURE,
	DAI_LINK_FE_UL3_CAPTURE,
	DAI_LINK_FE_UL4_CAPTURE,
	DAI_LINK_FE_UL5_CAPTURE,
	DAI_LINK_FE_UL8_CAPTURE,
	DAI_LINK_FE_UL9_CAPTURE,
	DAI_LINK_FE_UL10_CAPTURE,
	DAI_LINK_FE_DL7_PLAYBACK,
	DAI_LINK_FE_UL1_CAPTURE,
	DAI_LINK_FE_AFE_END,
#ifdef CONFIG_SND_SOC_MT8570
	DAI_LINK_FE_SPI_BASE = DAI_LINK_FE_AFE_END,
	DAI_LINK_FE_VA_HOSTLESS = DAI_LINK_FE_SPI_BASE,
	DAI_LINK_FE_SPI_MIC_CAPTURE,
	DAI_LINK_FE_VA_UPLOAD,
	DAI_LINK_SPI_RESERVE2,
	DAI_LINK_SPI_RESERVE3,
	DAI_LINK_SPI_RESERVE4,
	DAI_LINK_FE_SPI_PCMP1,
	DAI_LINK_SPI_RESERVE6,
	DAI_LINK_SPI_RESERVE7,
	DAI_LINK_FE_SPI_LINEIN_CAPTURE,
	DAI_LINK_FE_COMPR_BASE,
	DAI_LINK_FE_COMPRP1 = DAI_LINK_FE_COMPR_BASE,
	DAI_LINK_FE_COMPRP2,
	DAI_LINK_FE_COMPRP3,
	DAI_LINK_FE_COMPR_END,
	DAI_LINK_FE_SPI_END = DAI_LINK_FE_COMPR_END,
	DAI_LINK_FE_END = DAI_LINK_FE_SPI_END,
#else
	DAI_LINK_FE_END = DAI_LINK_FE_AFE_END,
#endif
	/* BE */
	DAI_LINK_BE_BASE = DAI_LINK_FE_END,
	DAI_LINK_BE_AFE_BASE = DAI_LINK_BE_BASE,
	DAI_LINK_BE_ETDM1_OUT = DAI_LINK_BE_AFE_BASE,
	DAI_LINK_BE_ETDM1_IN,
	DAI_LINK_BE_ETDM2_OUT,
	DAI_LINK_BE_ETDM2_IN,
	DAI_LINK_BE_PCM_INTF,
	DAI_LINK_BE_VIRTUAL_DL_SOURCE,
	DAI_LINK_BE_DMIC,
	DAI_LINK_BE_INT_ADDA,
	DAI_LINK_BE_GASRC0,
	DAI_LINK_BE_GASRC1,
	DAI_LINK_BE_GASRC2,
	DAI_LINK_BE_GASRC3,
	DAI_LINK_BE_SPDIF_OUT,
	DAI_LINK_BE_SPDIF_IN,
	DAI_LINK_BE_MULTI_IN,
	DAI_LINK_BE_AFE_END,
#ifdef CONFIG_SND_SOC_MT8570
	DAI_LINK_BE_SPI_BASE = DAI_LINK_BE_AFE_END,
	DAI_LINK_BE_SPI_MIC = DAI_LINK_BE_SPI_BASE,
	DAI_LINK_BE_SPI_PRIMARY_PLAYBACK,
	DAI_LINK_BE_SPI_LINEIN,
	DAI_LINK_BE_SPI_END,
	DAI_LINK_BE_END = DAI_LINK_BE_SPI_END,
#else
	DAI_LINK_BE_END = DAI_LINK_BE_AFE_END,
#endif
	DAI_LINK_NUM = DAI_LINK_BE_END,
	DAI_LINK_FE_NUM = DAI_LINK_FE_END - DAI_LINK_FE_BASE,
	DAI_LINK_BE_NUM = DAI_LINK_BE_END - DAI_LINK_BE_BASE,
};

static int imx_mtkdsp_hw_params(struct snd_pcm_substream *substream,
					 struct snd_pcm_hw_params *params)
{
	struct snd_soc_pcm_runtime *rtd = substream->private_data;
	struct snd_soc_dai *cpu_dai = asoc_rtd_to_cpu(rtd, 0);
	//struct snd_soc_dai *codec_dai = rtd->codec_dai;
	int ret;
	u32 dai_format = SND_SOC_DAIFMT_NB_NF | SND_SOC_DAIFMT_I2S |
			SND_SOC_DAIFMT_CBM_CFM;
/*
	ret = snd_soc_dai_set_sysclk(codec_dai, 0,
					24576000, SND_SOC_CLOCK_IN);
	if (ret) {
		dev_err(rtd->dev, "failed to set codec sysclk: %d\n", ret);
		return ret;
	}
*/
	ret = snd_soc_dai_set_fmt(cpu_dai, dai_format);
	if (ret) {
		dev_err(rtd->dev, "failed to set codec dai fmt: %d\n", ret);
		return ret;
	}

	return 0;
}

static struct snd_soc_ops imx_mtkdsp_ops_be = {
	.hw_params = imx_mtkdsp_hw_params,
};

static int be_hw_params_fixup(struct snd_soc_pcm_runtime *rtd,
				struct snd_pcm_hw_params *params) {

	struct snd_interval *rate;
	struct snd_interval *channels;
	struct snd_mask *mask;

	rate = hw_param_interval(params, SNDRV_PCM_HW_PARAM_RATE);
	rate->min = 8000;
	rate->max = 96000;

	channels = hw_param_interval(params, SNDRV_PCM_HW_PARAM_CHANNELS);
	channels->min = 1;
	channels->max = 16;

	mask = hw_param_mask(params, SNDRV_PCM_HW_PARAM_FORMAT);
	snd_mask_none(mask);
	snd_mask_set(mask, SNDRV_PCM_FORMAT_S32_LE);

	return 0;
}

static const struct snd_soc_dapm_widget imx_mtkdsp_dapm_widgets[] = {
	SND_SOC_DAPM_INPUT("DMIC In"),
};
static const struct snd_soc_dapm_route imx_mtkdsp_audio_map[] = {
	//{"CPU-Playback",  NULL, "Playback"},
	{"DMIC Capture",  NULL, "DMIC In"},/* dai route for be and fe */
};

#if 0
static const struct snd_soc_dapm_route imx_mtkdsp_audio_map[] = {
	{"HFP Out", NULL, "PCM1 Playback"},
	{"PCM1 Capture", NULL, "HFP In"},
#ifdef TEST_BACKEND_WITH_ENDPOINT
	{"ETDM1 Out", NULL, "ETDM1 Playback"},
	{"ETDM1 Capture", NULL, "ETDM1 In"},
	{"ETDM2 Out", NULL, "ETDM2 Playback"},
	{"ETDM2 Capture", NULL, "ETDM2 In"},
#endif
	{"DMIC Capture", NULL, "DMIC In"},

#ifdef CONFIG_SND_SOC_MT8518_CODEC
	{"DIG_DAC_CLK", NULL, "AFE_DAC_CLK"},
	{"DIG_ADC_CLK", NULL, "AFE_ADC_CLK"},
	{"Ext Spk Amp", NULL, "AU_LOL"},
#endif
};
#endif

static int imx_mtkdsp_audio_probe(struct platform_device *pdev)
{
/*	struct device_node *cpu_np=NULL, *codec_np=NULL, *platform_np=NULL;*/
	struct device_node *cpu_np=NULL;
	struct platform_device *cpu_pdev;
	struct imx_mtkdsp_audio_data *data;
	/*struct device_node *afe_plat_node;*/
#ifdef CONFIG_SND_SOC_MT8570
	struct device_node *spi_plat_node=NULL;
#endif
	int ret;

	data = devm_kzalloc(&pdev->dev, sizeof(*data), GFP_KERNEL);
	if (!data) {
		ret = -ENOMEM;
		goto fail;
	}

	/*afe_plat_node = of_parse_phandle(pdev->dev.of_node, "mediatek,platform", 0);
	if (!afe_plat_node) {
		dev_info(&pdev->dev, "Property 'platform' missing or invalid\n");
		return -EINVAL;
	}*/

#ifdef CONFIG_SND_SOC_MT8570
	spi_plat_node = of_parse_phandle(pdev->dev.of_node,
		"mediatek,spi-platform", 0);
	if (!spi_plat_node) {
		dev_info(&pdev->dev, "Property 'spi-platform' missing or invalid\n");
		return -EINVAL;
	}
#endif

	cpu_np = of_parse_phandle(pdev->dev.of_node, "cpu-dai", 0);
	if (!cpu_np) {
		dev_err(&pdev->dev, "cpu dai phandle missing or invalid\n");
		ret = -EINVAL;
		goto fail;
	}

	cpu_pdev = of_find_device_by_node(cpu_np);
	if (!cpu_pdev) {
		dev_err(&pdev->dev, "failed to find rpmsg platform device\n");
		ret = -EINVAL;
		goto fail;
	}

	data->dai[0].name = "SPI_MIC_FE";
	data->dai[0].stream_name = "SPI MIC Capture";
//	data->dai[0].codec_dai_name = "snd-soc-dummy-dai";
//	data->dai[0].codec_name = "snd-soc-dummy";
//	data->dai[0].cpu_dai_name = "FE_MICR"; //dev_name(&cpu_pdev->dev);
	data->dai[0].playback_only = false;
	data->dai[0].capture_only = true;
	data->dai[0].dpcm_playback = 0;
	data->dai[0].dpcm_capture = 1;
	data->dai[0].id = DAI_LINK_FE_SPI_MIC_CAPTURE;
	data->dai[0].dynamic = 1;
	data->dai[0].ignore_pmdown_time = 1;

	data->dai[1].name = "SPI MIC BE";
	data->dai[1].stream_name = "BE_MICR";
//	data->dai[1].codec_name = "snd-soc-dummy";
//	data->dai[1].codec_dai_name = "snd-soc-dummy-dai";
//	data->dai[1].cpu_dai_name = "BE_MICR";
	data->dai[1].playback_only = false;
	data->dai[1].capture_only = true;
	data->dai[1].dpcm_playback = 0;
	data->dai[1].dpcm_capture = 1,
	data->dai[1].no_pcm = 1,
	data->dai[1].ignore_pmdown_time = 1,
	data->dai[1].dai_fmt = SND_SOC_DAIFMT_I2S |
			    SND_SOC_DAIFMT_NB_NF |
			    SND_SOC_DAIFMT_CBM_CFM;
	data->dai[1].ops = &imx_mtkdsp_ops_be;
	data->dai[1].be_hw_params_fixup = be_hw_params_fixup;

	#if 0
	data->card.dapm_routes = imx_mtkdsp_audio_map;
	data->card.num_dapm_routes = ARRAY_SIZE(imx_mtkdsp_audio_map);
	data->card.dapm_widgets = imx_mtkdsp_dapm_widgets;
	data->card.num_dapm_widgets = ARRAY_SIZE(imx_mtkdsp_dapm_widgets);
	#endif
	
	data->card.num_links = 2;
	data->card.dai_link = data->dai;

	data->card.dev = &pdev->dev;
	data->card.owner = THIS_MODULE;
	ret = snd_soc_of_parse_card_name(&data->card, "model");
	if (ret)
		goto fail;

	platform_set_drvdata(pdev, &data->card);
	snd_soc_card_set_drvdata(&data->card, data);
	ret = devm_snd_soc_register_card(&pdev->dev, &data->card);
	if (ret) {
		dev_err(&pdev->dev, "snd_soc_register_card failed (%d)\n", ret);
		goto fail;
	}

fail:
	/*if (afe_plat_node)
		of_node_put(afe_plat_node);*/
	if (spi_plat_node)
		of_node_put(spi_plat_node);
	if (cpu_np)
		of_node_put(cpu_np);
	return ret;
}

static const struct of_device_id imx_mtkdsp_audio_dt_ids[] = {
	{ .compatible = "fsl,imx-mtkdsp-audio", },
	{ /* sentinel */ }
};
MODULE_DEVICE_TABLE(of, imx_mtkdsp_audio_dt_ids);

static struct platform_driver imx_mtkdsp_audio_driver = {
	.driver = {
		.name = "imx-mtkdsp-audio",
		.owner = THIS_MODULE,
		.pm = &snd_soc_pm_ops,
		.of_match_table = imx_mtkdsp_audio_dt_ids,
	},
	.probe = imx_mtkdsp_audio_probe,
};
module_platform_driver(imx_mtkdsp_audio_driver);

MODULE_LICENSE("GPL v2");
