// SPDX-License-Identifier: GPL-2.0+
/*
 * Copyright 2018,2022 Sony Corporation
 *
 * Sony port initialize driver device tree part
 */

#ifndef _DT_BINDINGS_SONY_PORT_INIT_DT_H
#define _DT_BINDINGS_SONY_PORT_INIT_DT_H

#define IMX_GPIO_NR(port, index)	((((port)-1)*32)+((index)&31))
#define	IMX_GPIO_GROUP(nr)		((nr) >> 0x5)
#define	IMX_GPIO_GROUP_MAX		(5)
#define	IMX_GPIO_NR_MAX		(IMX_GPIO_NR(IMX_GPIO_GROUP_MAX, 31))
#define	IMX_GPIO_IS_VALID(nr)	((nr) <= IMX_GPIO_NR_MAX)

#define	SONY_PORT_INIT_LOW	(0)
#define	SONY_PORT_INIT_HIGH	(1)
#define	SONY_PORT_INIT_IN	(2)
#define	SONY_PORT_INIT_NUMS	(3)

#endif /* _DT_BINDINGS_SONY_PORT_INIT_DT_H */
