//
// Copyright 2020, 2021 Sony Corporation
//

#include "mpegh_dec.h"


static int decode_init( AVCodecContext *avctx ){
  MpeghHandle *handle = (MpeghHandle*)avctx->priv_data;

  int result = mpegh_open( &handle->context, avctx );
  av_log( NULL, AV_LOG_DEBUG, "mpegh_open = %x\n", result );

  return result;
}


static int decode( AVCodecContext *avctx, void *data, int *got_frame_ptr, AVPacket *avpkt ){
  MpeghHandle *handle = (MpeghHandle*)avctx->priv_data;
  AVFrame *frame = (AVFrame*)data;
  int out_size  = 0;
  int result    = 0;

  av_frame_unref( frame );

  frame->nb_samples = mpegh_get_samples();

  if( (result = ff_get_buffer( avctx, frame, 0) ) < 0 ){
    av_log( NULL, AV_LOG_ERROR, "ff_get_buffer fail = %x\n", result );
    return result;
  }

  result = mpegh_decode( (const MpeghDecContext*)handle->context, (const AVPacket*)avpkt, frame, &out_size, got_frame_ptr );

  if( result != 0 ){
    av_log( NULL, AV_LOG_ERROR, "mpegh_decode error = %x\n", result );
    return result;
  }

  return( out_size );
}


static int decode_close( AVCodecContext *avctx ){
  MpeghHandle *handle = (MpeghHandle*)avctx->priv_data;

  av_log( NULL, AV_LOG_DEBUG, "mpegh_close\n" );

  mpegh_close( &handle->context );

  return 0;
}


static int decode_flush( AVCodecContext *avctx ){
  MpeghHandle *handle = (MpeghHandle*)avctx->priv_data;

  av_log( NULL, AV_LOG_DEBUG, "mpegh_flush\n");

  mpegh_flush( (const MpeghDecContext*)handle->context );

  return 0;
}


AVCodec ff_mpegh_3d_audio_decoder = {
  .name                   = "mpegh_3d_audio",
  .long_name              = NULL_IF_CONFIG_SMALL("MPEG-H 3D Audio"),
  .type                   = AVMEDIA_TYPE_AUDIO,
  .id                     = AV_CODEC_ID_MPEGH_3D_AUDIO,
  .priv_data_size         = sizeof(MpeghHandle),
  .init                   = decode_init,
  .decode                 = decode,
  .close                  = decode_close,
  .flush                  = decode_flush,
  .channel_layouts        = (const uint64_t[]) {  AV_CH_LAYOUT_STEREO,                //2ch
                                                  AV_CH_LAYOUT_5POINT1,               //5.1ch
                                                  AV_CH_LAYOUT_7POINT1,               //7.1ch
                                                  AV_CH_LAYOUT_5POINT1_POINT4,        //9.1ch
                                                  0 },
  .capabilities           = AV_CODEC_CAP_DR1,
  .sample_fmts            = (const enum AVSampleFormat[]) { AV_SAMPLE_FMT_S16P,       //16bit int format
                                                            AV_SAMPLE_FMT_S32P,       //32bit int format
                                                            AV_SAMPLE_FMT_FLTP,       //32bit float format
                                                            AV_SAMPLE_FMT_FLT,        //32bit float interleave format
                                                            AV_SAMPLE_FMT_NONE },
};
