//
// Copyright 2020, 2021 Sony Corporation
//

#ifndef MPEGH_DEC_H
#define MPEGH_DEC_H

#include "avcodec.h"
#include "internal.h"

typedef struct MpeghDecContext MpeghDecContext;

typedef struct {
  MpeghDecContext*  context;
} MpeghHandle;

int mpegh_get_samples( void );
int mpegh_open( MpeghDecContext** context, AVCodecContext *avctx );
int mpegh_decode( const MpeghDecContext* context, const AVPacket* avpkt, AVFrame* frame, int* outsize, int* got_frame );
int mpegh_flush( const MpeghDecContext* context );
int mpegh_close( MpeghDecContext** context );


#endif//MPEGH_DEC_H
