/****************************************************************************/
/* AUTHOR:  Sobal Koichi.Nagase                                             */
/* PURPOSE: HDMI Module Common define                                       */
/*                                                                          */
/* Copyright 2011, 2012, 2013, 2014, 2015, 2021 Sony Corporation            */
/****************************************************************************/

#ifndef __HD_DEFINE_H__
#define __HD_DEFINE_H__

/*==== Include =============================================================*/

/*==== Define ==============================================================*/
#define HD_TRUE		true
#define HD_FALSE	false

#define HD_OK		true
#define HD_NG		false

/* VIC */
#define HD_VIC1			(0x01)	/* 640x480p/60HZ 4:3 */
#define HD_VIC2			(0x02)	/* 720x480p/60HZ 4:3 */
#define HD_VIC3			(0x03)	/* 720x480p/60HZ 16:9 */
#define HD_VIC4			(0x04)	/* 1280x720p/60HZ 16:9 */
#define HD_VIC5			(0x05)	/* 1980x1080i/60HZ 16:9 */
#define HD_VIC16		(0x10)	/* 1980x1080p/60HZ 16:9 */
#define HD_VIC17		(0x11)	/* 720x576p/50HZ 4:3 */
#define HD_VIC18		(0x12)	/* 720x576p/50HZ 16:9 */
#define HD_VIC19		(0x13)	/* 1280x720p/50HZ 16:9 */
#define HD_VIC20		(0x14)	/* 1980x1080i/50HZ 16:9 */
#define HD_VIC31		(0x1f)	/* 1980x1080p/50HZ 16:9 */
#define HD_VIC32		(0x20)	/* 1980x1080p/24HZ 16:9 */
#define HD_VIC33		(0x21)	/* 1980x1080p/25HZ 16:9 */
#define HD_VIC34		(0x22)	/* 1980x1080p/30HZ 16:9 */
#define HD_VIC39		(0x27)	/* 1980x1080i/50HZ 16:9 */
#define HD_VIC40		(0x28)	/* 1980x1080i/100HZ 16:9 */
#define HD_VIC41		(0x29)	/* 1280x720p/100HZ 16:9 */
#define HD_VIC42		(0x2a)	/* 720x576p/100HZ 4:3 */
#define HD_VIC43		(0x2b)	/* 720x576p/100HZ 4:3 */
#define HD_VIC46		(0x2e)	/* 1980x1080i/120HZ 16:9 */
#define HD_VIC47		(0x2f)	/* 1280x720p/120HZ 16:9 */
#define HD_VIC48		(0x30)	/* 720x480p/120HZ 4:3 */
#define HD_VIC49		(0x31)	/* 720x480p/120HZ 16:9 */
#define HD_VIC52		(0x34)	/* 720x576p/200HZ 4:3 */
#define HD_VIC53		(0x35)	/* 720x576p/200HZ 4:3 */
#define HD_VIC56		(0x38)	/* 720x480p/240HZ 4:3 */
#define HD_VIC57		(0x39)	/* 720x480p/240HZ 16:9 */
#define HD_VIC60		(0x3c)	/* 1280x720p/24HZ 16:9 */
#define HD_VIC61		(0x3d)	/* 1280x720p/25HZ 16:9 */
#define HD_VIC62		(0x3e)	/* 1280x720p/30HZ 16:9 */
#define HD_VIC63		(0x3f)	/* 1980x1080p/120HZ 16:9 */
#define HD_VIC64		(0x40)	/* 1980x1080p/100HZ 16:9 */
#define HD_VIC65		(0x41)	/* 1280x720p/24HZ 64:27 */
#define HD_VIC66		(0x42)	/* 1280x720p/25HZ 64:27 */
#define HD_VIC67		(0x43)	/* 1280x720p/30HZ 64:27 */
#define HD_VIC68		(0x44)	/* 1280x720p/50HZ 64:27 */
#define HD_VIC69		(0x45)	/* 1280x720p/60HZ 64:27 */
#define HD_VIC70		(0x46)	/* 1280x720p/100HZ 64:27 */
#define HD_VIC71		(0x47)	/* 1280x720p/120HZ 64:27 */
#define HD_VIC72		(0x48)	/* 1980x1080p/24HZ 64:27 */
#define HD_VIC73		(0x49)	/* 1980x1080p/25HZ 64:27 */
#define HD_VIC74		(0x4a)	/* 1980x1080p/30HZ 64:27 */
#define HD_VIC75		(0x4b)	/* 1980x1080p/50HZ 64:27 */
#define HD_VIC76		(0x4c)	/* 1980x1080p/60HZ 64:27 */
#define HD_VIC77		(0x4d)	/* 1980x1080p/100HZ 64:27 */
#define HD_VIC78		(0x4e)	/* 1980x1080p/120HZ 64:27 */
/* HDMI2.0 Y420 EDID */
#define HD_VIC93		(0x5d)	/* 3840x2160p/24HZ 16:9 */
#define HD_VIC94		(0x5e)	/* 3840x2160p/25HZ 16:9 */
#define HD_VIC95		(0x5f)	/* 3840x2160p/30HZ 16:9 */
#define HD_VIC98		(0x62)	/* 4096x2160p/24Hz 16:9 */

#define HD_VIC96		(0x60)	/* 3840x2160p/50Hz 16:9 */
#define HD_VIC97		(0x61)	/* 3840x2160p/60HZ 16:9 */
#define HD_VIC99		(0x63)	/* 4096x2160p/25Hz 256:135 */
#define HD_VIC100		(0x64)	/* 4096x2160p/30Hz 256:135 */
#define HD_VIC101		(0x65)	/* 4096x2160p/50Hz 256:135 */
#define HD_VIC102		(0x66)	/* 4096x2160p/60HZ 256:135 */
#define HD_VIC103		(0x67)	/* 3840x2160p/24Hz 64:27 */
#define HD_VIC104		(0x68)	/* 3840x2160p/25Hz 64:27 */
#define HD_VIC105		(0x69)	/* 3840x2160p/30Hz 64:27 */
/* #define HD_VIC106	(0x6a)*//* 3840x2160p/50Hz 4:3 */
/* #define HD_VIC107	(0x6b)*//* 3840x2160p/60HZ 4:3 */
#define HD_VIC117		(0x75)	/* 3840x2160p/100HZ */
#define HD_VIC118		(0x76)	/* 3840x2160p/120HZ */
#define HD_VIC127		(0x7f)
#define HD_VIC193		(0xc1)
#define HD_VIC194		(0xc2)	/* 7680x4320p/24HZ */
#define HD_VIC195		(0xc3)	/* 7680x4320p/25HZ */
#define HD_VIC196		(0xc4)	/* 7680x4320p/30HZ */
#define HD_VIC198		(0xc6)	/* 7680x4320p/50HZ */
#define HD_VIC199		(0xc7)	/* 7680x4320p/60HZ */
#define HD_VIC218		(0xda)	/* 4096x2160p/100HZ */
#define HD_VIC219		(0xdb)	/* 4096x2160p/120HZ */

/*==== Typedef =============================================================*/
typedef enum {
	HD_MODULE_PORT_TX_0 = 0,
	HD_MODULE_PORT_TX_1,
} HD_MODULE_PORT_TX_t;
#define HD_MAX__MODULE_PORT_TX			2

#endif
