/****************************************************************************/
/* AUTHOR:  Nagase                                                          */
/* PURPOSE: EDID Common                                                     */
/*                                                                          */
/* Copyright 2021 Sony Corporation                                          */
/****************************************************************************/
#ifndef _HD_EDID_COMMON_H_
#define _HD_EDID_COMMON_H_

/*==== Include =============================================================*/
#include <stdbool.h>
#include <hd_datatypes.h>
#include <hd_define.h>

/*==== Define ==============================================================*/
/* EDID BLOCK ID */
#define HD_EDID_BLOCK_0			0
#define HD_EDID_BLOCK_1			1
#define HD_EDID_BLOCK_2			2
#define HD_EDID_BLOCK_COUNT		2		/* last data (use for count id) */

/* TABLE SIZE */
/* #define HD_EDID_TABLE_SIZE	(512) */
#define HD_EDID_TABLE_SIZE	(1024)
#define HD_EDID_BLOCK_SIZE	(128)

/*---- EDID data position */
#define HD_EDID_POS_BLOCK_0_TOP			(0x00)
#define HD_EDID_POS_BLOCK_1_TOP			(0x80)
#define HD_EDID_POS_BLOCK_MAP			(0x80)

#define HD_EDID_POS_CHECKSUM			(0x7f)

/* Block 0 */
#define HD_EDID_POS_MANUFACTURE			(0x08)
#define HD_EDID_LEN_MANUFACTURE			(0x02)

#define HD_EDID_POS_PRODUCT				(0x0a)
#define HD_EDID_LEN_PRODUCT				(0x02)

#define HD_EDID_POS_SIRIAL_NUM			(0x0c)
#define HD_EDID_LEN_SIRIAL_NUM			(0x04)

#define HD_EDID_POS_WEEK				(0x10)
#define HD_EDID_LEN_WEEK				(0x01)

#define HD_EDID_POS_YEAR				(0x11)
#define HD_EDID_LEN_YEAR				(0x01)

#define HD_EDID_POS_EDID_VERSION		(0x12)
#define HD_EDID_LEN_EDID_VERSION		(0x02)

#define HD_EDID_POS_BASIC_DISPLAY		(0x14)
#define HD_EDID_LEN_BASIC_DISPLAY		(0x05)
#define HD_EDID_POS_SINK_V_IMAGE_SIZE	(2)

#define HD_EDID_POS_COLOR				(0x19)
#define HD_EDID_LEN_COLOR				(0x0a)

#define HD_EDID_POS_ETD					(0x23)
#define HD_EDID_LEN_ETD					(0x03)

#define HD_EDID_POS_STD					(0x26)
#define HD_EDID_LEN_STD					(0x10)

/* DTD */
#define HD_EDID_POS_DTD_1				(0x36)
#define HD_EDID_POS_DTD_2				(0x48)
#define HD_EDID_POS_DTD_3				(0x5a)
#define HD_EDID_MASK_DTD_EXTENTION_FLAG	(0xF0)
#define HD_EDID_POS_DTD_4				(0x6c)
#define HD_EDID_LEN_DTD					(0x12)
#define HD_EDID_CNT_DTD					(4)
#define HD_EDID_CNT_DTD_TIMING0			(2)
#define HD_EDID_CNT_DTD_TIMING1			(5)
#define HD_EDID_CNT_DTD_TIMING			(HD_EDID_CNT_DTD_TIMING0 + HD_EDID_CNT_DTD_TIMING1)

#define HD_EDID_POS_DTD_DESC_FLAG		(0)
#define HD_EDID_DTD_DESC_FLAG			(0x0000)
#define HD_EDID_POS_DTD_TAG				(3)
#define HD_EDID_DTD_TAG_RANGE			(0xfd)
#define HD_EDID_DTD_TAG_NAME			(0xfc)
#define HD_EDID_POS_MONITOR_NAME_DATA	(5)

#define HD_EDID_MASK_DTD_NAME__SIMUL_VIEW	0x01
#define HD_EDID_MASK_DTD_NAME__4K_HDMI		0x02
#define HD_EDID_MASK_DTD_NAME__FTZ			0x04
#define HD_EDID_MASK_DTD_NAME__SCE			0x08

#define HD_EDID_POS_DTD_PIXEL_CLOCK_LOW	(0)
#define HD_EDID_POS_DTD_PIXEL_CLOCK_UP	(1)

#define HD_EDID_POS_DTD_H_ACTIVE_LOW	(2)
#define HD_EDID_POS_DTD_H_ACTIVE_UP		(4)
#define HD_EDID_MASK_DTD_H_ACTIVE_UP	(0xf0)
#define HD_EDID_SHFT_DTD_H_ACTIVE_UP	(4)

#define HD_EDID_POS_DTD_H_BLANK_LOW		(3)
#define HD_EDID_POS_DTD_H_BLANK_UP		HD_EDID_POS_DTD_H_ACTIVE_UP
#define HD_EDID_MASK_DTD_H_BLANK_UP		(0x0f)
#define HD_EDID_SHFT_DTD_H_BLANK_UP		(0)

#define HD_EDID_POS_DTD_V_ACTIVE_LOW	(5)
#define HD_EDID_POS_DTD_V_ACTIVE_UP		(7)
#define HD_EDID_MASK_DTD_V_ACTIVE_UP	(0xf0)
#define HD_EDID_SHFT_DTD_V_ACTIVE_UP	(4)

#define HD_EDID_POS_DTD_V_BLANK_LOW		(6)
#define HD_EDID_POS_DTD_V_BLANK_UP		HD_EDID_POS_DTD_V_ACTIVE_UP
#define HD_EDID_MASK_DTD_V_BLANK_UP		(0x0f)
#define HD_EDID_SHFT_DTD_V_BLANK_UP		(0)

#define HD_EDID_POS_DTD_H_TOTAL_LOW		(12)
#define HD_EDID_POS_DTD_H_TOTAL_UP		(14)
#define HD_EDID_MASK_DTD_H_TOTAL_UP		(0xf0)
#define HD_EDID_SHFT_DTD_H_TOTAL_UP		(4)

#define HD_EDID_POS_DTD_V_TOTAL_LOW		(13)
#define HD_EDID_POS_DTD_V_TOTAL_UP		HD_EDID_POS_DTD_H_TOTAL_UP
#define HD_EDID_MASK_DTD_V_TOTAL_UP		(0x0f)
#define HD_EDID_SHFT_DTD_V_TOTAL_UP		(0)

#define HD_EDID_POS_DTD_INTERLACE		(17)
#define HD_EDID_MASK_DTD_INTERLACE		(0x80)

#define HD_EDID_POS_EXTENSION			(0x7e)

/* Block 1 */
#define HD_EDID_POS_CEA_VERSION			(0x01)
#define HD_EDID_POS_OFFSET_DTD			(0x02)
#define HD_EDID_POS_DTV_MONITOR			(0x03)
#define HD_EDID_POS_START_DATA_BLOCK	(0x04)

/* DTV_MONITOR */
#define HD_EDID_MASK_DTV_UNDERSCAN		(0x80)
#define HD_EDID_SHFT_DTV_UNDERSCAN		(7)
#define HD_EDID_MASK_DTV_AUDIO			(0x40)
#define HD_EDID_SHFT_DTV_AUDIO			(6)
#define HD_EDID_MASK_DTV_YCBCR444		(0x20)
#define HD_EDID_SHFT_DTV_YCBCR444		(5)
#define HD_EDID_MASK_DTV_YCBCR422		(0x10)
#define HD_EDID_SHFT_DTV_YCBCR422		(4)
#define HD_EDID_MASK_DTV_NATIVE			(0x0f)

/* EDID Block Header (Extention TAG) */
#define HD_EDID_LEN_MAP_HEADER			(1)
#define HD_EDID_EXTAG_MAP				(0xf0)
#define HD_EDID_EXTAG_ADDITIONAL_TIMING	(0x02)

/* HF-EEODB */
#define HD_EDID_EXTAG_HFEEODB			(0x78)
#define HD_EDID_POS_HFEEODB_BLOCK_COUNT	(1)
#define HD_EDID_LEN_DESC_HFEEODB		(1)

/*---- EDID CEA */
#define HD_EDID_CEA_TAG_AUDIO		(0x01)
#define HD_EDID_CEA_TAG_VIDEO		(0x02)
#define HD_EDID_CEA_TAG_VENDOR		(0x03)
#define HD_EDID_CEA_TAG_SPEAKER		(0x04)
#define HD_EDID_CEA_TAG_EXT			(0x07)

#define HD_EDID_POS_CEA_HEADER		(0)
#define HD_EDID_LEN_CEA_HEADER		(1)
#define HD_EDID_LEN_CEA_MAX			(31)
#define HD_EDID_LEN_CEA_VIDEO_MAX	(31)
#define HD_EDID_LEN_CEA_AUDIO_MAX	(31)
#define HD_EDID_LEN_CEA_SPEAKER_MAX	(4)
#define HD_EDID_LEN_CEA_VENDOR_MAX	(31)
#define HD_EDID_LEN_CEA_VSDB_MAX	(15)
#define HD_EDID_LEN_CEA_HFVSDB_MAX	(14)
#define HD_EDID_LEN_CEA_VCDB_MAX	(3)
#define HD_EDID_MASK_CEA_TAG		(0xe0)
#define HD_EDID_SHFT_CEA_TAG		(5)
#define HD_EDID_MASK_CEA_LEN		(0x1f)
#define HD_EDID_LEN_CEA_DATA_MAX	(32)
#define HD_EDID_LEN_CHECKSUM		(1)
#define HD_EDID_LEN_CEA_AUDIO_DATA_MAX	(10)

/*---- EDID SAD */
#define HD_EDID_LEN_DESC_SAD		(3)
#define HD_EDID_POS_SAD_FREQ		(1)
#define HD_EDID_POS_SAD_PARAM		(2)
#define HD_EDID_MASK_SAD_FORMAT		(0x78)
#define HD_EDID_SHFT_SAD_FORMAT		(3)
#define HD_EDID_MASK_SAD_CHANNEL	(0x07)
#define HD_EDID_MASK_SAD_FREQ		(0x7f)
#define HD_EDID_SAD_FORMAT_PCM		(0x01)
#define HD_EDID_SAD_FORMAT_AC3		(0x02)
#define HD_EDID_SAD_FORMAT_AAC		(0x06)
#define HD_EDID_SAD_FORMAT_DTS		(0x07)
#define HD_EDID_SAD_FORMAT_DSD		(0x09)
#define HD_EDID_SAD_FORMAT_DDP		(0x0a)
#define HD_EDID_SAD_FORMAT_DTSHD	(0x0b)
#define HD_EDID_SAD_FORMAT_MAT		(0x0c)
#define HD_EDID_SAD_FORMAT_EXTENSION_TYPE		(0x0f)
#define HD_EDID_MASK_SAD_EXTENSION_TYPE_CODE	(0xf8)
#define HD_EDID_SHFT_SAD_EXTENSION_TYPE_CODE	(3)

#define HD_EDID_SAD_FORMAT_DTSUHD	(0x10)

#define HD_EDID_SAD_FORMAT_MPEG_4AAC		(0x06)
#define HD_EDID_SAD_FORMAT_MPEG_H_3D_AUDIO	(0x0b)
#define HD_EDID_SAD_FREQ_32K				(0x01)
#define HD_EDID_SAD_FREQ_44K				(0x02)
#define HD_EDID_SAD_FREQ_48K				(0x04)
#define HD_EDID_SAD_FREQ_88K				(0x08)
#define HD_EDID_SAD_FREQ_96K				(0x10)
#define HD_EDID_SAD_FREQ_176K				(0x20)
#define HD_EDID_SAD_FREQ_192K				(0x40)
#define HD_EDID_SAD_FORMAT_SUB_DTSHD		(0x00)
#define HD_EDID_SAD_FORMAT_SUB_DTSUHD		(0x02)
#define HD_EDID_SAD_FORMAT_SUB_RESERVE		(0x06)
#define HD_EDID_MASK_SAD_DTSX_PARAM_V1		(0x02)
#define HD_EDID_MASK_SAD_DTSX_PARAM_V2		(0x04)
#define HD_EDID_MASK_SAD_DTSHD_PARAM		(0x01)
#define HD_EDID_MASK_SAD_DTSHD_PARAM_V1		(0x01)
#define HD_EDID_MASK_SAD_DTSHD_PARAM_V1_V3	(0x03)

/*---- EDID SVD */
#define HD_EDID_LEN_DESC_SVD		(1)
#define HD_EDID_MASK_SVD_FORMAT		(0x7f)
#define HD_EDID_MASK_SVD_NATIVE		(0x80)
#define HD_EDID_SHFT_SVD_NATIVE		(7)

/*---- EDID SPD */
#define HD_EDID_LEN_DESC_SPD		(3)


/*---- EDID VSDB */
#define HD_EDID_POS_VSDB_IEEE					(1)
#define HD_EDID_LEN_VSDB_IEEE					(3)

#define HD_EDID_POS_PHY_ADDR					(4)
#define HD_EDID_LEN_PHY_ADDR					(2)

#define HD_EDID_POS_VSDB_EXTENSION				(6)

#define HD_EDID_MASK_VSDB_SUPPORTS_AI			(0x80)
#define HD_EDID_SHFT_VSDB_SUPPORTS_AI			(7)
#define HD_EDID_MASK_VSDB_DEEP_COLOR			(0x78)
#define HD_EDID_MASK_VSDB_DEEP_COLOR_48			(0x40)
#define HD_EDID_MASK_VSDB_DEEP_COLOR_36			(0x20)
#define HD_EDID_MASK_VSDB_DEEP_COLOR_30			(0x10)
#define HD_EDID_MASK_VSDB_DEEP_COLOR_Y444		(0x08)
#define HD_EDID_SHFT_VSDB_DEEP_COLOR			(3)

#define HD_EDID_POS_VSDB_TMDS_CLOCK				(7)

#define HD_EDID_MASK_VSDB_LATENCY_PRESENT		(0x80)
#define HD_EDID_SHFT_VSDB_LATENCY_PRESENT		(7)
#define HD_EDID_MASK_VSDB_I_LATENCY_PRESENT		(0x40)
#define HD_EDID_SHFT_VSDB_I_LATENCY_PRESENT		(6)
#define HD_EDID_LEN_VSDB_LATENCY				(2)
#define HD_EDID_LEN_VSDB_I_LATENCY				(2)
#
#define HD_EDID_MASK_VSDB_HDMI_VIDEO_PRESENT	(0x20)
#define HD_EDID_SHFT_VSDB_HDMI_VIDEO_PRESENT	(5)

#define HD_EDID_MASK_VSDB_CNC					(0x0f)

#define HD_EDID_MASK_VSDB_3D_PRESENT			(0x80)
#define HD_EDID_SHFT_VSDB_3D_PRESENT			(7)
#define HD_EDID_MASK_VSDB_3D_MULTI_PRESENT		(0x60)
#define HD_EDID_SHFT_VSDB_3D_MULTI_PRESENT		(5)
#define HD_EDID_VSDB_3D_MULTI_NONE				(0)
#define HD_EDID_VSDB_3D_MULTI_STRUCTURE			(1)
#define HD_EDID_VSDB_3D_MULTI_MASK				(2)
#define HD_EDID_VSDB_3D_MULTI_FUTURE			(3)
#define HD_EDID_LEN_VSDB_3D_MULTI_STRUCTURE		(2)
#define HD_EDID_LEN_VSDB_3D_MULTI_MASK			(2)

#define HD_EDID_MASK_VSDB_IMAGE_SIZE			(0x18)
#define HD_EDID_SHFT_VSDB_IMAGE_SIZE			(3)

#define HD_EDID_MASK_VSDB_HDMI_VIC_LEN			(0xe0)
#define HD_EDID_SHFT_VSDB_HDMI_VIC_LEN			(5)
#define HD_EDID_CNT_VSDB_HDMI_VIC				(7)
#define HD_EDID_MASK_VSDB_HDMI_3D_LEN			(0x1f)

/* HF-VSDB */
#define HD_EDID_LEN_DESC_SCDS					(7)
#define HD_EDID_LEN_DESC_SCDS_MAX				(13)

#define HD_EDID_SUPPORT_VERSION					(0x01)

#define HD_EDID_SHFT_SCDS_DUAL_VIEW				(1)
#define HD_EDID_SHFT_SCDS_INDEPENDENT_VIEW		(2)
#define HD_EDID_SHFT_SCDS_LTE_SCRAMBLE			(3)
#define HD_EDID_SHFT_SCDS_RR_CAPABLE			(6)
#define HD_EDID_SHFT_SCDS_SCDC_PRESENT			(7)

#define HD_EDID_MASK_SCDS_3D_OSD_DISPARITY		(0x01)
#define HD_EDID_MASK_SCDS_DUAL_VIEW				(0x02)
#define HD_EDID_MASK_SCDS_INDEPENDENT_VIEW		(0x04)
#define HD_EDID_MASK_SCDS_LTE_SCRAMBLE			(0x08)
#define HD_EDID_MASK_SCDS_RR_CAPABLE			(0x40)
#define HD_EDID_MASK_SCDS_SCDC_PRESENT			(0x80)

#define HD_EDID_POS_SCDS_VERSION				4
#define HD_EDID_POS_SCDS_TMDS_CLOCK				5
#define HD_EDID_POS_SCDS_3D_OSD_DISPARITY		6
#define HD_EDID_POS_SCDS_DUAL_VIEW				6
#define HD_EDID_POS_SCDS_INDEPENDENT_VIEW		6
#define HD_EDID_POS_SCDS_LTE_SCRAMBLE			6
#define HD_EDID_POS_SCDS_RR_CAPABLE				6
#define HD_EDID_POS_SCDS_SCDC_PRESENT			6

#define HD_EDID_POS_SCDS_DEEP_COLOR_420			7
#define HD_EDID_POS_SCDS_CABLE_STATUS			6
#define HD_EDID_POS_SCDS_CCBPCI					6
#define HD_EDID_POS_SCDS_MAX_FRL_RATE			7
#define HD_EDID_POS_SCDS_UHD_VIC				7
#define HD_EDID_POS_SCDS_M_DELTA				8
#define HD_EDID_POS_SCDS_CINEMA_VRR				8
#define HD_EDID_POS_SCDS_CNM_VRR				8
#define HD_EDID_POS_SCDS_FVA					8
#define HD_EDID_POS_SCDS_ALLM					8
#define HD_EDID_POS_SCDS_FAPA_START_LOCATION	8
#define HD_EDID_POS_SCDS_VRR_MAX_9_8			9
#define HD_EDID_POS_SCDS_VRR_MIN				9
#define HD_EDID_POS_SCDS_VRR_MAX_7_0			10
#define HD_EDID_POS_SCDS_DSC_1p2				11
#define HD_EDID_POS_SCDS_DSC_NATIVE_420			11
#define HD_EDID_POS_SCDS_DSC_ALL_BPP			11
#define HD_EDID_POS_SCDS_DSC_16bpc				11
#define HD_EDID_POS_SCDS_DSC_12bpc				11
#define HD_EDID_POS_SCDS_DSC_10bpc				11
#define HD_EDID_POS_SCDS_DSC_MAX_FRL_RATE		12
#define HD_EDID_POS_SCDS_DSC_MAX_SLICES			12
#define HD_EDID_POS_SCDS_DSC_TOTAL_CHUNK_KBYTES	13

#define HD_EDID_MASK_SCDS_DEEP_COLOR			(0x07)
#define HD_EDID_MASK_SCDS_DEEP_COLOR_48			(0x04)
#define HD_EDID_MASK_SCDS_DEEP_COLOR_36			(0x02)
#define HD_EDID_MASK_SCDS_DEEP_COLOR_30			(0x01)
#define HD_EDID_SHFT_SCDS_DEEP_COLOR			(0)

#define HD_EDID_MASK_SCDS_CABLE_STATUS			(0x20)
#define HD_EDID_SHFT_SCDS_CABLE_STATUS			(5)
#define HD_EDID_MASK_SCDS_CCBPCI				(0x10)
#define HD_EDID_SHFT_SCDS_CCBPCI				(4)
#define HD_EDID_MASK_SCDS_MAX_FRL_RATE			(0xf0)
#define HD_EDID_SHFT_SCDS_MAX_FRL_RATE			(4)
#define HD_EDID_MASK_SCDS_UHD_VIC				(0x08)
#define HD_EDID_SHFT_SCDS_UHD_VIC				(3)
#define HD_EDID_MASK_SCDS_M_DELTA				(0x20)
#define HD_EDID_SHFT_SCDS_M_DELTA				(5)
#define HD_EDID_MASK_SCDS_CINEMA_VRR			(0x10)
#define HD_EDID_SHFT_SCDS_CINEMA_VRR			(4)
#define HD_EDID_MASK_SCDS_CNM_VRR				(0x08)
#define HD_EDID_SHFT_SCDS_CNM_VRR				(3)
#define HD_EDID_MASK_SCDS_FVA					(0x04)
#define HD_EDID_SHFT_SCDS_FVA					(2)
#define HD_EDID_MASK_SCDS_ALLM					(0x02)
#define HD_EDID_SHFT_SCDS_ALLM					(1)
#define HD_EDID_MASK_SCDS_FAPA_START_LOCATION	(0x01)
#define HD_EDID_SHFT_SCDS_FAPA_START_LOCATION	(0)
#define HD_EDID_MASK_SCDS_VRR_MAX_9_8			(0xC0)
#define HD_EDID_SHFT_SCDS_VRR_MAX_9_8			(6)
#define HD_EDID_MASK_SCDS_VRR_MIN				(0x3F)
#define HD_EDID_SHFT_SCDS_VRR_MIN				(0)
#define HD_EDID_MASK_SCDS_VRR_MAX_7_0			(0xFF)
#define HD_EDID_SHFT_SCDS_VRR_MAX_7_0			(0)
#define HD_EDID_MASK_SCDS_DSC_1p2				(0x80)
#define HD_EDID_SHFT_SCDS_DSC_1p2				(7)
#define HD_EDID_MASK_SCDS_DSC_NATIVE_420		(0x40)
#define HD_EDID_SHFT_SCDS_DSC_NATIVE_420		(6)
#define HD_EDID_MASK_SCDS_DSC_ALL_BPP			(0x08)
#define HD_EDID_SHFT_SCDS_DSC_ALL_BPP			(3)
#define HD_EDID_MASK_SCDS_DSC_16bpc				(0x04)
#define HD_EDID_SHFT_SCDS_DSC_16bpc				(2)
#define HD_EDID_MASK_SCDS_DSC_12bpc				(0x02)
#define HD_EDID_SHFT_SCDS_DSC_12bpc				(1)
#define HD_EDID_MASK_SCDS_DSC_10bpc				(0x01)
#define HD_EDID_SHFT_SCDS_DSC_10bpc				(0)
#define HD_EDID_MASK_SCDS_DSC_MAX_FRL_RATE		(0xF0)
#define HD_EDID_SHFT_SCDS_DSC_MAX_FRL_RATE		(4)
#define HD_EDID_MASK_SCDS_DSC_MAX_SLICES		(0x0F)
#define HD_EDID_SHFT_SCDS_DSC_MAX_SLICES		(0)
#define HD_EDID_MASK_SCDS_DSC_TOTAL_CHUNK_KBYTES	(0x3F)
#define HD_EDID_SHFT_SCDS_DSC_TOTAL_CHUNK_KBYTES	(0)

#define HD_EDID_POS_SCDS_PB_7					(10)
#define HD_EDID_POS_SCDS_PB_8					(11)
#define HD_EDID_POS_SCDS_PB_9					(12)
#define HD_EDID_POS_SCDS_PB_10					(13)

#define HD_EDID_LEN_FIXED_DATA			(8)
#define HD_EDID_LEN_MIN					(0x05)

/*---- Extended */
#define HD_EDID_POS_EXT_TAG				(1)
#define HD_EDID_LEN_EXT_TAG				(1)
#define HD_EDID_EXT_TAG_CODE_VCDB		(0x00)	/* video capability data block */
#define HD_EDID_EXT_TAG_CODE_VSVDB		(0x01)	/* vendor-specific video data block */
#define HD_EDID_EXT_TAG_CODE_VSADB		(0x11)
#define HD_EDID_EXT_TAG_CODE_CMR		(0x05)	/* colorimetry data block */
/* HDMI2.0 Y420 EDID */
#define HD_EDID_EXT_TAG_CODE_Y420VDB	(0x0E)	/* YCbCr420 Video Data Block */
#define HD_EDID_EXT_TAG_CODE_Y420CMDB	(0x0F)	/* YCbCr420 Capability Map Data Block */
#define HD_EDID_EXT_TAG_CODE_HDR		(0x06)	/* high dynamic range data block */
/* HDMI2.1 HF-SCDB EDID */
#define HD_EDID_EXT_TAG_CODE_HFSCDB		(0x79)

/* Colorimetry */
#define HD_EDID_POS_DESC_CMR			(2)
#define HD_EDID_LEN_DESC_CMR			(3)
#define HD_EDID_POS_CMR_BT2020			(1)
#define HD_EDID_MASK_CMR_BT2020			(0xE0)
#define HD_EDID_SHFT_CMR_BT2020			(5)
#define HD_EDID_POS_CMR_ADOBE			(1)
#define HD_EDID_MASK_CMR_ADOBE			(0x18)
#define HD_EDID_SHFT_CMR_ADOBE			(3)
#define HD_EDID_POS_CMR_YCC				(1)
#define HD_EDID_BIT_CMR_XVYCC601		(BIT0)
#define HD_EDID_BIT_CMR_XVYCC709		(BIT1)
#define HD_EDID_MASK_CMR_YCC			(0x07)
#define HD_EDID_POS_CMR_MD				(2)
#define HD_EDID_MASK_CMR_MD				(0x0f)

/* VCDB */
#define HD_EDID_POS_DESC_VCDB			(2)
#define HD_EDID_LEN_DESC_VCDB			(2)
#define HD_EDID_POS_VCDB_QY				(1)
#define HD_EDID_MASK_VCDB_QY			(0x80)
#define HD_EDID_SHFT_VCDB_QY			(7)
#define HD_EDID_POS_VCDB_QS				(1)
#define HD_EDID_MASK_VCDB_QS			(0x40)
#define HD_EDID_SHFT_VCDB_QS			(6)
#define HD_EDID_POS_VCDB_SPT			(1)
#define HD_EDID_MASK_VCDB_SPT			(0x30)
#define HD_EDID_SHFT_VCDB_SPT			(4)
#define HD_EDID_POS_VCDB_SIT			(1)
#define HD_EDID_MASK_VCDB_SIT			(0x0c)
#define HD_EDID_SHFT_VCDB_SIT			(2)
#define HD_EDID_POS_VCDB_SCE			(1)
#define HD_EDID_MASK_VCDB_SCE			(0x03)

/* Vendor-Specific Video Data Block */
#define HD_EDID_LEN_VSVDB_MAX			(0x1f)
#define HD_EDID_LEN_VSVDB_OUI			(4)
#define HD_EDID_POS_VSVDB_OUI0			(1)
#define HD_EDID_VAL_VSVDB_OUI_DOLBY_0	(0x46)
#define HD_EDID_POS_VSVDB_OUI1			(2)
#define HD_EDID_VAL_VSVDB_OUI_DOLBY_1	(0xD0)
#define HD_EDID_POS_VSVDB_OUI2			(3)
#define HD_EDID_VAL_VSVDB_OUI_DOLBY_2	(0x00)
#define HD_EDID_LEN_VSVDB_DV_VERSION	(5)
#define HD_EDID_POS_VSVDB_DV_VERSION	(4)
#define HD_EDID_MASK_VSVDB_DV_VERSION	(0xE0)
#define HD_EDID_SHFT_VSVDB_DV_VERSION	(5)
#define HD_EDID_VAL_VSVDB_DV_VERSION_0	(0)
#define HD_EDID_VAL_VSVDB_DV_VERSION_1	(1)
#define HD_EDID_VAL_VSVDB_DV_VERSION_2	(2)
#define HD_EDID_LEN_VSVDB_DV_V0			(25)
#define HD_EDID_LEN_VSVDB_DV_V1_15		(14)
#define HD_EDID_LEN_VSVDB_DV_V1_12		(11)
#define HD_EDID_LEN_VSVDB_DV_V2			(11)

#define HD_EDID_POS_VSVDB_DV_V0_GLOBAL_DIMMING	(4)
#define HD_EDID_MASK_VSVDB_DV_V0_GLOBAL_DIMMING	(0x04)
#define HD_EDID_SHFT_VSVDB_DV_V0_GLOBAL_DIMMING	(2)
#define HD_EDID_POS_VSVDB_DV_V0_2160P60HZ		(4)
#define HD_EDID_MASK_VSVDB_DV_V0_2160P60HZ		(0x02)
#define HD_EDID_SHFT_VSVDB_DV_V0_2160P60HZ		(1)
#define HD_EDID_POS_VSVDB_DV_V0_YUV422_12BIT	(4)
#define HD_EDID_MASK_VSVDB_DV_V0_YUV422_12BIT	(0x01)
#define HD_EDID_SHFT_VSVDB_DV_V0_YUV422_12BIT	(0)
#define HD_EDID_POS_VSVDB_DV_V0_RX3_0			(5)
#define HD_EDID_MASK_VSVDB_DV_V0_RX3_0			(0xf0)
#define HD_EDID_SHFT_VSVDB_DV_V0_RX3_0			(4)
#define HD_EDID_POS_VSVDB_DV_V0_RY3_0			(5)
#define HD_EDID_MASK_VSVDB_DV_V0_RY3_0			(0x0f)
#define HD_EDID_SHFT_VSVDB_DV_V0_RY3_0			(0)
#define HD_EDID_POS_VSVDB_DV_V0_RX11_4			(6)
#define HD_EDID_POS_VSVDB_DV_V0_RY11_4			(7)
#define HD_EDID_POS_VSVDB_DV_V0_GX3_0			(8)
#define HD_EDID_MASK_VSVDB_DV_V0_GX3_0			(0xf0)
#define HD_EDID_SHFT_VSVDB_DV_V0_GX3_0			(4)
#define HD_EDID_POS_VSVDB_DV_V0_GY3_0			(8)
#define HD_EDID_MASK_VSVDB_DV_V0_GY3_0			(0x0f)
#define HD_EDID_SHFT_VSVDB_DV_V0_GY3_0			(0)
#define HD_EDID_POS_VSVDB_DV_V0_GX11_4			(9)
#define HD_EDID_POS_VSVDB_DV_V0_GY11_4			(10)
#define HD_EDID_POS_VSVDB_DV_V0_BX3_0			(11)
#define HD_EDID_MASK_VSVDB_DV_V0_BX3_0			(0xf0)
#define HD_EDID_SHFT_VSVDB_DV_V0_BX3_0			(4)
#define HD_EDID_POS_VSVDB_DV_V0_BY3_0			(11)
#define HD_EDID_MASK_VSVDB_DV_V0_BY3_0			(0x0f)
#define HD_EDID_SHFT_VSVDB_DV_V0_BY3_0			(0)
#define HD_EDID_POS_VSVDB_DV_V0_BX11_4			(12)
#define HD_EDID_POS_VSVDB_DV_V0_BY11_4			(13)
#define HD_EDID_POS_VSVDB_DV_V0_WX3_0			(14)
#define HD_EDID_MASK_VSVDB_DV_V0_WX3_0			(0xf0)
#define HD_EDID_SHFT_VSVDB_DV_V0_WX3_0			(4)
#define HD_EDID_POS_VSVDB_DV_V0_WY3_0			(14)
#define HD_EDID_MASK_VSVDB_DV_V0_WY3_0			(0x0f)
#define HD_EDID_SHFT_VSVDB_DV_V0_WY3_0			(0)
#define HD_EDID_POS_VSVDB_DV_V0_WX11_4			(15)
#define HD_EDID_POS_VSVDB_DV_V0_WY11_4			(16)
#define HD_EDID_POS_VSVDB_DV_V0_TGT_MIN_PQ3_0	(17)
#define HD_EDID_MASK_VSVDB_DV_V0_TGT_MIN_PQ3_0	(0xf0)
#define HD_EDID_SHFT_VSVDB_DV_V0_TGT_MIN_PQ3_0	(4)
#define HD_EDID_POS_VSVDB_DV_V0_TGT_MAX_PQ3_0	(17)
#define HD_EDID_MASK_VSVDB_DV_V0_TGT_MAX_PQ3_0	(0x0f)
#define HD_EDID_SHFT_VSVDB_DV_V0_TGT_MAX_PQ3_0	(0)
#define HD_EDID_POS_VSVDB_DV_V0_TGT_MIN_PQ11_4	(18)
#define HD_EDID_POS_VSVDB_DV_V0_TGT_MAX_PQ11_4	(19)
#define HD_EDID_POS_VSVDB_DV_V0_DM_MAJOR_VER	(20)
#define HD_EDID_MASK_VSVDB_DV_V0_DM_MAJOR_VER	(0xf0)
#define HD_EDID_SHFT_VSVDB_DV_V0_DM_MAJOR_VER	(4)
#define HD_EDID_POS_VSVDB_DV_V0_DM_MINOR_VER	(20)
#define HD_EDID_MASK_VSVDB_DV_V0_DM_MINOR_VER	(0x0f)
#define HD_EDID_SHFT_VSVDB_DV_V0_DM_MINOR_VER	(0)

#define HD_EDID_POS_VSVDB_DV_15V1_DM_VERSION		(4)
#define HD_EDID_MASK_VSVDB_DV_15V1_DM_VERSION		(0x1c)
#define HD_EDID_SHFT_VSVDB_DV_15V1_DM_VERSION		(2)
#define HD_EDID_POS_VSVDB_DV_15V1_2160P60HZ			(4)
#define HD_EDID_MASK_VSVDB_DV_15V1_2160P60HZ		(0x02)
#define HD_EDID_SHFT_VSVDB_DV_15V1_2160P60HZ		(1)
#define HD_EDID_POS_VSVDB_DV_15V1_YUV422_12BIT		(4)
#define HD_EDID_MASK_VSVDB_DV_15V1_YUV422_12BIT		(0x01)
#define HD_EDID_SHFT_VSVDB_DV_15V1_YUV422_12BIT		(0)
#define HD_EDID_POS_VSVDB_DV_15V1_TGT_MAX_LUM		(5)
#define HD_EDID_MASK_VSVDB_DV_15V1_TGT_MAX_LUM		(0xfe)
#define HD_EDID_SHFT_VSVDB_DV_15V1_TGT_MAX_LUM		(1)
#define HD_EDID_POS_VSVDB_DV_15V1_GLOBAL_DIMMING	(5)
#define HD_EDID_MASK_VSVDB_DV_15V1_GLOBAL_DIMMING	(0x01)
#define HD_EDID_SHFT_VSVDB_DV_15V1_GLOBAL_DIMMING	(0)
#define HD_EDID_POS_VSVDB_DV_15V1_TGT_MIN_LUM		(6)
#define HD_EDID_MASK_VSVDB_DV_15V1_TGT_MIN_LUM		(0xfe)
#define HD_EDID_SHFT_VSVDB_DV_15V1_TGT_MIN_LUM		(1)
#define HD_EDID_POS_VSVDB_DV_15V1_COLORIMETRY		(6)
#define HD_EDID_MASK_VSVDB_DV_15V1_COLORIMETRY		(0x01)
#define HD_EDID_SHFT_VSVDB_DV_15V1_COLORIMETRY		(0)
#define HD_EDID_POS_VSVDB_DV_15V1_RX				(8)
#define HD_EDID_POS_VSVDB_DV_15V1_RY				(9)
#define HD_EDID_POS_VSVDB_DV_15V1_GX				(10)
#define HD_EDID_POS_VSVDB_DV_15V1_GY				(11)
#define HD_EDID_POS_VSVDB_DV_15V1_BX				(12)
#define HD_EDID_POS_VSVDB_DV_15V1_BY				(13)

#define HD_EDID_POS_VSVDB_DV_12V1_DM_VERSION		(4)
#define HD_EDID_MASK_VSVDB_DV_12V1_DM_VERSION		(0x1c)
#define HD_EDID_SHFT_VSVDB_DV_12V1_DM_VERSION		(2)
#define HD_EDID_POS_VSVDB_DV_12V1_2160P60HZ			(4)
#define HD_EDID_MASK_VSVDB_DV_12V1_2160P60HZ		(0x02)
#define HD_EDID_SHFT_VSVDB_DV_12V1_2160P60HZ		(1)
#define HD_EDID_POS_VSVDB_DV_12V1_YUV422_12BIT		(4)
#define HD_EDID_MASK_VSVDB_DV_12V1_YUV422_12BIT		(0x01)
#define HD_EDID_SHFT_VSVDB_DV_12V1_YUV422_12BIT		(0)
#define HD_EDID_POS_VSVDB_DV_12V1_TGT_MAX_LUM		(5)
#define HD_EDID_MASK_VSVDB_DV_12V1_TGT_MAX_LUM		(0xfe)
#define HD_EDID_SHFT_VSVDB_DV_12V1_TGT_MAX_LUM		(1)
#define HD_EDID_POS_VSVDB_DV_12V1_GLOBAL_DIMMING	(5)
#define HD_EDID_MASK_VSVDB_DV_12V1_GLOBAL_DIMMING	(0x01)
#define HD_EDID_SHFT_VSVDB_DV_12V1_GLOBAL_DIMMING	(0)
#define HD_EDID_POS_VSVDB_DV_12V1_TGT_MIN_LUM		(6)
#define HD_EDID_MASK_VSVDB_DV_12V1_TGT_MIN_LUM		(0xfe)
#define HD_EDID_SHFT_VSVDB_DV_12V1_TGT_MIN_LUM		(1)
#define HD_EDID_POS_VSVDB_DV_12V1_COLORIMETRY		(6)
#define HD_EDID_MASK_VSVDB_DV_12V1_COLORIMETRY		(0x01)
#define HD_EDID_SHFT_VSVDB_DV_12V1_COLORIMETRY		(0)
#define HD_EDID_POS_VSVDB_DV_12V1_UNIQUE_BX2_0		(7)
#define HD_EDID_MASK_VSVDB_DV_12V1_UNIQUE_BX2_0		(0xe0)
#define HD_EDID_SHFT_VSVDB_DV_12V1_UNIQUE_BX2_0		(5)
#define HD_EDID_POS_VSVDB_DV_12V1_UNIQUE_BY2_0		(7)
#define HD_EDID_MASK_VSVDB_DV_12V1_UNIQUE_BY2_0		(0x1c)
#define HD_EDID_SHFT_VSVDB_DV_12V1_UNIQUE_BY2_0		(2)
#define HD_EDID_POS_VSVDB_DV_12V1_LOW_LATENCY		(7)
#define HD_EDID_MASK_VSVDB_DV_12V1_LOW_LATENCY		(0x03)
#define HD_EDID_SHFT_VSVDB_DV_12V1_LOW_LATENCY		(0)
#define HD_EDID_POS_VSVDB_DV_12V1_UNIQUE_GX6_0		(8)
#define HD_EDID_MASK_VSVDB_DV_12V1_UNIQUE_GX6_0		(0xfe)
#define HD_EDID_SHFT_VSVDB_DV_12V1_UNIQUE_GX6_0		(1)
#define HD_EDID_POS_VSVDB_DV_12V1_UNIQUE_RY0		(8)
#define HD_EDID_MASK_VSVDB_DV_12V1_UNIQUE_RY0		(0x01)
#define HD_EDID_SHFT_VSVDB_DV_12V1_UNIQUE_RY0		(0)
#define HD_EDID_POS_VSVDB_DV_12V1_UNIQUE_GY6_0		(9)
#define HD_EDID_MASK_VSVDB_DV_12V1_UNIQUE_GY6_0		(0xfe)
#define HD_EDID_SHFT_VSVDB_DV_12V1_UNIQUE_GY6_0		(1)
#define HD_EDID_POS_VSVDB_DV_12V1_UNIQUE_RY1		(9)
#define HD_EDID_MASK_VSVDB_DV_12V1_UNIQUE_RY1		(0x01)
#define HD_EDID_SHFT_VSVDB_DV_12V1_UNIQUE_RY1		(0)
#define HD_EDID_POS_VSVDB_DV_12V1_UNIQUE_RX4_0		(10)
#define HD_EDID_MASK_VSVDB_DV_12V1_UNIQUE_RX4_0		(0xf8)
#define HD_EDID_SHFT_VSVDB_DV_12V1_UNIQUE_RX4_0		(3)
#define HD_EDID_POS_VSVDB_DV_12V1_UNIQUE_RY4_2		(10)
#define HD_EDID_MASK_VSVDB_DV_12V1_UNIQUE_RY4_2		(0x07)
#define HD_EDID_SHFT_VSVDB_DV_12V1_UNIQUE_RY4_2		(0)

#define HD_EDID_POS_VSVDB_DV_V2_DM_VERSION			(4)
#define HD_EDID_MASK_VSVDB_DV_V2_DM_VERSION			(0x1c)
#define HD_EDID_SHFT_VSVDB_DV_V2_DM_VERSION			(2)
#define HD_EDID_POS_VSVDB_DV_V2_BACKLIGHT_CTRL		(4)
#define HD_EDID_MASK_VSVDB_DV_V2_BACKLIGHT_CTRL		(0x02)
#define HD_EDID_SHFT_VSVDB_DV_V2_BACKLIGHT_CTRL		(1)
#define HD_EDID_POS_VSVDB_DV_V2_YUV422_12BIT		(4)
#define HD_EDID_MASK_VSVDB_DV_V2_YUV422_12BIT		(0x01)
#define HD_EDID_SHFT_VSVDB_DV_V2_YUV422_12BIT		(0)
#define HD_EDID_POS_VSVDB_DV_V2_TGT_MIN_PQV2_4_0	(5)
#define HD_EDID_MASK_VSVDB_DV_V2_TGT_MIN_PQV2_4_0	(0xf8)
#define HD_EDID_SHFT_VSVDB_DV_V2_TGT_MIN_PQV2_4_0	(3)
#define HD_EDID_POS_VSVDB_DV_V2_GLOBAL_DIMMING		(5)
#define HD_EDID_MASK_VSVDB_DV_V2_GLOBAL_DIMMING		(0x04)
#define HD_EDID_SHFT_VSVDB_DV_V2_GLOBAL_DIMMING		(2)
#define HD_EDID_POS_VSVDB_DV_V2_BACKLT_MIN_LUMA1_0	(5)
#define HD_EDID_MASK_VSVDB_DV_V2_BACKLT_MIN_LUMA1_0	(0x03)
#define HD_EDID_SHFT_VSVDB_DV_V2_BACKLT_MIN_LUMA1_0	(0)
#define HD_EDID_POS_VSVDB_DV_V2_TGT_MAX_PQV2_4_0	(6)
#define HD_EDID_MASK_VSVDB_DV_V2_TGT_MAX_PQV2_4_0	(0xf8)
#define HD_EDID_SHFT_VSVDB_DV_V2_TGT_MAX_PQV2_4_0	(3)
#define HD_EDID_POS_VSVDB_DV_V2_RESERVED			(6)
#define HD_EDID_MASK_VSVDB_DV_V2_RESERVED			(0x04)
#define HD_EDID_SHFT_VSVDB_DV_V2_RESERVED			(2)
#define HD_EDID_POS_VSVDB_DV_V2_INTERFACE1_0		(6)
#define HD_EDID_MASK_VSVDB_DV_V2_INTERFACE1_0		(0x03)
#define HD_EDID_SHFT_VSVDB_DV_V2_INTERFACE1_0		(0)
#define HD_EDID_POS_VSVDB_DV_V2_UNIQUE_GX6_0		(7)
#define HD_EDID_MASK_VSVDB_DV_V2_UNIQUE_GX6_0		(0xfe)
#define HD_EDID_SHFT_VSVDB_DV_V2_UNIQUE_GX6_0		(1)
#define HD_EDID_POS_VSVDB_DV_V2_10B12B_444_1		(7)
#define HD_EDID_MASK_VSVDB_DV_V2_10B12B_444_1		(0x01)
#define HD_EDID_SHFT_VSVDB_DV_V2_10B12B_444_1		(0)
#define HD_EDID_POS_VSVDB_DV_V2_UNIQUE_GY6_0		(8)
#define HD_EDID_MASK_VSVDB_DV_V2_UNIQUE_GY6_0		(0xfe)
#define HD_EDID_SHFT_VSVDB_DV_V2_UNIQUE_GY6_0		(1)
#define HD_EDID_POS_VSVDB_DV_V2_10B12B_444_0		(8)
#define HD_EDID_MASK_VSVDB_DV_V2_10B12B_444_0		(0x01)
#define HD_EDID_SHFT_VSVDB_DV_V2_10B12B_444_0		(0)
#define HD_EDID_POS_VSVDB_DV_V2_UNIQUE_RX4_0		(9)
#define HD_EDID_MASK_VSVDB_DV_V2_UNIQUE_RX4_0		(0xf8)
#define HD_EDID_SHFT_VSVDB_DV_V2_UNIQUE_RX4_0		(3)
#define HD_EDID_POS_VSVDB_DV_V2_UNIQUE_BX2_0		(9)
#define HD_EDID_MASK_VSVDB_DV_V2_UNIQUE_BX2_0		(0x07)
#define HD_EDID_SHFT_VSVDB_DV_V2_UNIQUE_BX2_0		(0)
#define HD_EDID_POS_VSVDB_DV_V2_UNIQUE_RY4_0		(10)
#define HD_EDID_MASK_VSVDB_DV_V2_UNIQUE_RY4_0		(0xf8)
#define HD_EDID_SHFT_VSVDB_DV_V2_UNIQUE_RY4_0		(3)
#define HD_EDID_POS_VSVDB_DV_V2_UNIQUE_BY2_0		(10)
#define HD_EDID_MASK_VSVDB_DV_V2_UNIQUE_BY2_0		(0x07)
#define HD_EDID_SHFT_VSVDB_DV_V2_UNIQUE_BY2_0		(0)

/* Vendor-Specific Audio Data Block */
#define HD_EDID_LEN_VSADB							(6)
#define HD_EDID_POS_VSADB_HEAD_PHONE				(4)
#define HD_EDID_MASK_VSADB_HEAD_PHONE				(0x80)
#define HD_EDID_SHFT_VSADB_HEAD_PHONE				(7)
#define HD_EDID_POS_VSADB_OUTPUT_CONF_SUPPORT		(4)
#define HD_EDID_MASK_VSADB_OUTPUT_CONF_SUPPORT		(0x70)
#define HD_EDID_SHFT_VSADB_OUTPUT_CONF_SUPPORT		(6)
#define HD_EDID_POS_VSADB_F63						(4)
#define HD_EDID_MASK_VSADB_F63						(0x08)
#define HD_EDID_SHFT_VSADB_F63						(3)
#define HD_EDID_POS_VSADB_VERSION					(4)
#define HD_EDID_MASK_VSADB_VERSION					(0x07)
#define HD_EDID_SHFT_VSADB_VERSION					(0)
#define HD_EDID_POS_VSADB_F77						(5)
#define HD_EDID_MASK_VSADB_F77						(0x80)
#define HD_EDID_SHFT_VSADB_F77						(7)
#define HD_EDID_POS_VSADB_SINK_PRODUCT_CAP			(5)
#define HD_EDID_MASK_VSADB_SINK_PRODUCT_CAP			(0x7F)
#define HD_EDID_SHFT_VSADB_SINK_PRODUCT_CAP			(0)

/* HDMI2.0 Y420 EDID */
/* YCbCr420 Video Data Block */
#define HD_EDID_LEN_Y420VDB_VIC			(13)
#define HD_EDID_LEN_Y420VDB_EXTAG		(1)
#define HD_EDID_POS_Y420VDB_FIRST_VIC	(2)

/* YCbCr420 Capability Map Data Block */
#define HD_EDID_LEN_Y420CMDB_EXTAG		(1)
#define HD_EDID_LEN_Y420CMDB_MASK		(4)		/* == HD_EDID_LEN_Y420CMDB_VIC / 8VIC */

#define HD_EDID_POS_DESC_HDR					(2)
#define HD_EDID_LEN_HDR_LUMINANCE_NON_SUPPORT	(3)

#define HD_EDID_POS_HDR_SUPPORT_EOTF	(1)
#define HD_EDID_POS_HDR_MD				(2)

#define HD_EDID_NUM_HDR_LUMINANCE_DATA		(3)
#define HD_EDID_POS_HDR_LUMINANCE_DATA		(3)
#define HD_EDID_POS_HDR_LUMINANCE_DATA_MAX	(0)
#define HD_EDID_POS_HDR_LUMINANCE_DATA_AVE	(1)
#define HD_EDID_POS_HDR_LUMINANCE_DATA_MIN	(2)

/* HDMI2.1 HF-SCDB EDID */
#define HD_EDID_LEN_HFSCDB_DATA				(2)

/*==== Prototype Declaration ===============================================*/
#undef EXTERN
#ifdef _HD_EDID_COMMON_C_
	#define EXTERN
#else	/* _HD_EDID_COMMON_C_ */
	#define EXTERN	extern
#endif	/* _HD_EDID_COMMON_C_ */

extern bool_t hd_edid_IsHeaderCorrectBlockN(uint8_t);
extern bool_t hd_edid_IsCorrectHdmiDisplay(uint8_t *);
extern bool_t hd_edid_IsCorrectScdsIeee(uint8_t *);
EXTERN uint8_t hd_edid_GetCeaBlockData(uint8_t *, uint8_t, uint8_t, uint8_t *);
#endif	/* _HD_EDID_COMMON_H_ */
