/*
 * Copyright 2018-2020 NXP
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <drm/drmP.h>
#include <drm/drm_atomic.h>
#include <drm/drm_atomic_helper.h>
#include <drm/drm_crtc.h>
#include <drm/drm_fb_cma_helper.h>
#include "imx-drm.h"

static void imx_drm_output_poll_changed(struct drm_device *drm)
{
	struct imx_drm_device *imxdrm = drm->dev_private;
	if (imxdrm)
		drm_fbdev_cma_hotplug_event(imxdrm->fbhelper);
}

static void lcdif_drm_atomic_commit_tail(struct drm_atomic_state *state)
{
	struct drm_device *dev = state->dev;

	drm_atomic_helper_commit_modeset_disables(dev, state);

	drm_atomic_helper_commit_modeset_enables(dev, state);

	drm_atomic_helper_commit_planes(dev, state, DRM_PLANE_COMMIT_ACTIVE_ONLY);

	drm_atomic_helper_commit_hw_done(state);

	drm_atomic_helper_wait_for_vblanks(dev, state);

	drm_atomic_helper_cleanup_planes(dev, state);
}

#if IS_ENABLED(CONFIG_DRM_IMX_CUSTOMIZATION_MAX_RESOLUTION)
static enum drm_mode_status
lcdif_drm_mode_valid(struct drm_device *dev,
		     const struct drm_display_mode *mode)
{
	DRM_DEBUG_DRIVER("lcdif_drm: mode name %s", mode->name);

	if (mode->hdisplay > dev->customized_fb_res.max_width ||
	    mode->vdisplay > dev->customized_fb_res.max_height)
		return MODE_BAD;
	else
		return MODE_OK;
}
#endif /* IS_ENABLED(CONFIG_DRM_IMX_CUSTOMIZATION_MAX_RESOLUTION) */

const struct drm_mode_config_funcs lcdif_drm_mode_config_funcs = {
	.fb_create     = drm_fb_cma_create,
	.atomic_check  = drm_atomic_helper_check,
	.atomic_commit = drm_atomic_helper_commit,
#if IS_ENABLED(CONFIG_DRM_IMX_CUSTOMIZATION_MAX_RESOLUTION)
	.mode_valid    = lcdif_drm_mode_valid,
#endif
	.output_poll_changed = imx_drm_output_poll_changed,
};

struct drm_mode_config_helper_funcs lcdif_drm_mode_config_helpers = {
	.atomic_commit_tail = lcdif_drm_atomic_commit_tail,
};
