/*
 * mt8570-adsp-common.h  --  Mediatek 8570 adsp driver common definitions
 *
 * Copyright (c) 2019 MediaTek Inc.
 * Author: Hidalgo Huang <hidalgo.huang@mediatek.com>
 * Copyright 2021, 2022 Sony Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef _MT8570_ADSP_COMMON_H_
#define _MT8570_ADSP_COMMON_H_

#include "mt8570-adsp-utils.h"
#include <linux/ktime.h>
#include <linux/hrtimer.h>
#include "hifi4dsp_load/hifi4dsp_load.h"

#define MT8570_HOST_DRV_VER "0.0.1"

/* #define MT8570_AUDIO_SPI_UL_DMA_DEBUG */
/* #define MT8570_AUDIO_SPI_UL_DMA_READ_LATENCY_DEBUG */
/* #define MT8570_AUDIO_SPI_UL_DMA_CONSUME_DEBUG */
/* #define MT8570_AUDIO_SPI_UL_COPY_LATENCY_DEBUG */
/* #define MT8570_AUDIO_SPI_UL_IRQ_LATENCY_DEBUG */
/* #define MT8570_AUDIO_SPI_DL_DMA_DEBUG */
/* #define MT8570_AUDIO_SPI_DL_DMA_WRITE_LATENCY_DEBUG */
/* #define MT8570_AUDIO_SPI_DL_DMA_CONSUME_DEBUG */
/* #define MT8570_AUDIO_SPI_DL_COPY_LATENCY_DEBUG */
/* #define MT8570_AUDIO_SPI_DL_IRQ_LATENCY_DEBUG */

struct mt8570_adsp_dai_memory {
	int id;
	struct snd_pcm_substream *substream;
	struct mt8570_dsp_dma_buffer dsp_dmab;
	struct mt8570_host_dma_buffer host_dmab;
	struct mt8570_preroll_dma_buffer preroll_dmab;
	struct work_struct dma_work;
	struct workqueue_struct *dma_wq;
	struct hrtimer dma_elapse_hrt;
	u64 period_time_ns;
	atomic_t dma_pending_elapse;
	struct timespec trigger_start_ts;
	struct timespec prev_elapse_ts;
	ktime_t target_elapse_kt;
	u64 total_transfer_bytes;
	bool data_copied;
	uint32_t prev_hw_offset;
	spinlock_t host_dma_lock;
	struct device *dev;
	void *priv;
#if defined(MT8570_AUDIO_SPI_UL_COPY_LATENCY_DEBUG) || \
	defined(MT8570_AUDIO_SPI_DL_COPY_LATENCY_DEBUG)
	struct timespec64 prev_copy_ts;
#endif
#if defined(MT8570_AUDIO_SPI_UL_IRQ_LATENCY_DEBUG) || \
	defined(MT8570_AUDIO_SPI_DL_IRQ_LATENCY_DEBUG)
	struct timespec64 prev_irq_ts;
#endif
#if defined(MT8570_AUDIO_SPI_UL_DMA_CONSUME_DEBUG) || \
	defined(MT8570_AUDIO_SPI_DL_DMA_CONSUME_DEBUG)
	u32 copy_count;
	ktime_t first_copy_kt;
#endif
};

struct mt8570_adsp_pcm_be_data {
	bool slave_mode;
	bool lrck_inv;
	bool bck_inv;
	unsigned int lrck_width;
	unsigned int data_mode;
	unsigned int format;
	unsigned int mclk_freq;
	unsigned int clock_mode;
};

struct mt8570_adsp_control_data {
	bool wakeword_detect_en;
	int master_vol;
#ifdef CONFIG_SND_SOC_MT8570_ADSP_PCM_PLAYBACK
	int pcm_vol[MT8570_ADSP_FE_PCM_CNT];
#endif
#ifdef CONFIG_SND_SOC_MT8570_COMPRESS
	int compress_vol[MT8570_ADSP_COMPRP_STREAM_CNT];
#endif
	int dsp_tic_ns;
	int hotword_trig;
	int voice_trig;
};

struct mt8570_adsp_volume {
	struct dsp_vol_info master;
#ifdef CONFIG_SND_SOC_MT8570_ADSP_PCM_PLAYBACK
	struct dsp_vol_info pcm[MT8570_ADSP_FE_PCM_CNT];
#endif
#ifdef CONFIG_SND_SOC_MT8570_COMPRESS
	struct dsp_vol_info compress[MT8570_ADSP_COMPRP_STREAM_CNT];
#endif
};

struct mt8570_adsp_pcm_priv {
	struct device *dev;
	phys_addr_t reserved_memory_paddr;
	void __iomem *reserved_memory_vaddr;
	u64 reserved_memory_size;
	wait_queue_head_t wait_dsp;
	bool dsp_ready;
	bool dsp_init;
	u32 firmware_version;
	u64 ps_per_tick;
	struct mt8570_adsp_dai_memory dai_mem[MT8570_ADSP_FE_CNT];
	struct dsp_mem_ifo mem_info[MT8570_ADSP_FE_CNT];
	struct mt8570_adsp_pcm_be_data be_data[MT8570_ADSP_BE_CNT];
	struct mt8570_adsp_volume adsp_vol;
	struct mt8570_adsp_control_data ctrl_data;
	uint32_t va_ul_preroll_period_count;
#ifdef CONFIG_SND_SOC_COMPRESS
	atomic_t compr_active[MT8570_ADSP_COMPR_STREAM_CNT];
#endif
#ifdef CONFIG_DEBUG_FS
	void *dbg_data;
#endif
#ifdef MULTI_DSP_LOAD
	int dspcs_gpio;
	int dspsw2_gpio;
#endif /* MULTI_DSP_LOAD */
};

#endif
