/*
 * Copyright (c) 2012-2018 The Linux Foundation. All rights reserved.
 *
 * Permission to use, copy, modify, and/or distribute this software for
 * any purpose with or without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE
 * AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __WLAN_POLICY_MGR_TABLES_2X2_2G_1X1_5G_DBS_H
#define __WLAN_POLICY_MGR_TABLES_2X2_2G_1X1_5G_DBS_H

#include "wlan_policy_mgr_api.h"

/**
 * next_action_two_connection_table - table which provides next
 * action while a new connection is coming up, with one
 * connection already in the system
 */
static policy_mgr_next_action_two_connection_table_type
	pm_next_action_two_connection_dbs_2x2_2g_1x1_5g_table = {
	[PM_STA_24_1x1] = {PM_NOP, PM_DBS2},
	[PM_STA_24_2x2] = {PM_NOP, PM_DBS2},
	[PM_STA_5_1x1] = {PM_DBS2, PM_NOP},
	[PM_STA_5_2x2] = {PM_DBS2, PM_NOP},
	[PM_P2P_CLI_24_1x1] = {PM_NOP, PM_DBS2},
	[PM_P2P_CLI_24_2x2] = {PM_NOP, PM_DBS2},
	[PM_P2P_CLI_5_1x1] = {PM_DBS2, PM_NOP},
	[PM_P2P_CLI_5_2x2] = {PM_DBS2, PM_NOP},
	[PM_P2P_GO_24_1x1] = {PM_NOP, PM_DBS2},
	[PM_P2P_GO_24_2x2] = {PM_NOP, PM_DBS2},
	[PM_P2P_GO_5_1x1] = {PM_DBS2, PM_NOP},
	[PM_P2P_GO_5_2x2] = {PM_DBS2_DOWNGRADE, PM_NOP},
	[PM_SAP_24_1x1] = {PM_NOP, PM_DBS2},
	[PM_SAP_24_2x2] = {PM_NOP, PM_DBS2},
	[PM_SAP_5_1x1] = {PM_DBS2, PM_NOP},
	[PM_SAP_5_2x2] = {PM_DBS2_DOWNGRADE, PM_NOP},
	[PM_IBSS_24_1x1] = {PM_NOP, PM_DBS2},
	[PM_IBSS_24_2x2] = {PM_NOP, PM_DBS2},
	[PM_IBSS_5_1x1] = {PM_DBS2, PM_NOP},
	[PM_IBSS_5_2x2] = {PM_DBS2_DOWNGRADE, PM_NOP},
};

/**
 * next_action_three_connection_table - table which provides next
 * action while a new connection is coming up, with two
 * connections already in the system
 */
static policy_mgr_next_action_three_connection_table_type
	pm_next_action_three_connection_dbs_2x2_2g_1x1_5g_table = {
	[PM_STA_SAP_SCC_24_1x1] = {PM_NOP, PM_DBS2},
	[PM_STA_SAP_SCC_24_2x2] = {PM_NOP, PM_DBS2},
	[PM_STA_SAP_MCC_24_1x1] = {PM_NOP, PM_DBS2},
	[PM_STA_SAP_MCC_24_2x2] = {PM_NOP, PM_DBS2},
	[PM_STA_SAP_SCC_5_1x1] = {PM_DBS2, PM_NOP},
	[PM_STA_SAP_SCC_5_2x2] = {PM_DBS2_DOWNGRADE, PM_NOP},
	[PM_STA_SAP_MCC_5_1x1] = {PM_DBS2, PM_NOP},
	[PM_STA_SAP_MCC_5_2x2] = {PM_DBS2_DOWNGRADE, PM_NOP},
	[PM_STA_SAP_MCC_24_5_1x1] = {PM_DBS2_DOWNGRADE, PM_DBS2_DOWNGRADE},
	[PM_STA_SAP_MCC_24_5_2x2] = {PM_DBS2_DOWNGRADE, PM_DBS2_DOWNGRADE},
	[PM_STA_SAP_DBS_1x1] = {PM_DBS2_DOWNGRADE, PM_DBS2_DOWNGRADE},
	[PM_STA_SAP_DBS_2x2] = {PM_DBS2_DOWNGRADE, PM_DBS2_DOWNGRADE},

	[PM_STA_P2P_GO_SCC_24_1x1] = {PM_NOP, PM_DBS2},
	[PM_STA_P2P_GO_SCC_24_2x2] = {PM_NOP, PM_DBS2},
	[PM_STA_P2P_GO_MCC_24_1x1] = {PM_NOP, PM_DBS2},
	[PM_STA_P2P_GO_MCC_24_2x2] = {PM_NOP, PM_DBS2},
	[PM_STA_P2P_GO_SCC_5_1x1] = {PM_DBS2, PM_NOP},
	[PM_STA_P2P_GO_SCC_5_2x2] = {PM_DBS2_DOWNGRADE, PM_NOP},
	[PM_STA_P2P_GO_MCC_5_1x1] = {PM_DBS2, PM_NOP},
	[PM_STA_P2P_GO_MCC_5_2x2] = {PM_DBS2_DOWNGRADE, PM_NOP},
	[PM_STA_P2P_GO_MCC_24_5_1x1] = {PM_DBS2_DOWNGRADE, PM_DBS2_DOWNGRADE},
	[PM_STA_P2P_GO_MCC_24_5_2x2] = {PM_DBS2_DOWNGRADE, PM_DBS2_DOWNGRADE},
	[PM_STA_P2P_GO_DBS_1x1] = {PM_DBS2_DOWNGRADE, PM_DBS2_DOWNGRADE},
	[PM_STA_P2P_GO_DBS_2x2] = {PM_DBS2_DOWNGRADE, PM_DBS2_DOWNGRADE},

	[PM_STA_P2P_CLI_SCC_24_1x1] = {PM_NOP, PM_DBS2},
	[PM_STA_P2P_CLI_SCC_24_2x2] = {PM_NOP, PM_DBS2},
	[PM_STA_P2P_CLI_MCC_24_1x1] = {PM_NOP, PM_DBS2},
	[PM_STA_P2P_CLI_MCC_24_2x2] = {PM_NOP, PM_DBS2},
	[PM_STA_P2P_CLI_SCC_5_1x1] = {PM_DBS2, PM_NOP},
	[PM_STA_P2P_CLI_SCC_5_2x2] = {PM_DBS2, PM_NOP},
	[PM_STA_P2P_CLI_MCC_5_1x1] = {PM_DBS2, PM_NOP},
	[PM_STA_P2P_CLI_MCC_5_2x2] = {PM_DBS2, PM_NOP},
	[PM_STA_P2P_CLI_MCC_24_5_1x1] = {PM_NOP, PM_DBS2},
	[PM_STA_P2P_CLI_MCC_24_5_2x2] = {PM_NOP, PM_DBS2},
	[PM_STA_P2P_CLI_DBS_1x1] = {PM_NOP, PM_DBS2},
	[PM_STA_P2P_CLI_DBS_2x2] = {PM_NOP, PM_DBS2},

	[PM_P2P_GO_P2P_CLI_SCC_24_1x1] = {PM_NOP, PM_DBS2},
	[PM_P2P_GO_P2P_CLI_SCC_24_2x2] = {PM_NOP, PM_DBS2},
	[PM_P2P_GO_P2P_CLI_MCC_24_1x1] = {PM_NOP, PM_DBS2},
	[PM_P2P_GO_P2P_CLI_MCC_24_2x2] = {PM_NOP, PM_DBS2},
	[PM_P2P_GO_P2P_CLI_SCC_5_1x1] = {PM_DBS2, PM_NOP},
	[PM_P2P_GO_P2P_CLI_SCC_5_2x2] = {PM_DBS2_DOWNGRADE, PM_NOP},
	[PM_P2P_GO_P2P_CLI_MCC_5_1x1] = {PM_DBS2, PM_NOP},
	[PM_P2P_GO_P2P_CLI_MCC_5_2x2] = {PM_DBS2_DOWNGRADE, PM_NOP},
	[PM_P2P_GO_P2P_CLI_MCC_24_5_1x1] = {PM_DBS2_DOWNGRADE,
					    PM_DBS2_DOWNGRADE},
	[PM_P2P_GO_P2P_CLI_MCC_24_5_2x2] = {PM_DBS2_DOWNGRADE,
					    PM_DBS2_DOWNGRADE},
	[PM_P2P_GO_P2P_CLI_DBS_1x1] = {PM_DBS2_DOWNGRADE, PM_DBS2_DOWNGRADE},
	[PM_P2P_GO_P2P_CLI_DBS_2x2] = {PM_DBS2_DOWNGRADE, PM_DBS2_DOWNGRADE},

	[PM_P2P_GO_SAP_SCC_24_1x1] = {PM_NOP, PM_DBS2},
	[PM_P2P_GO_SAP_SCC_24_2x2] = {PM_NOP, PM_DBS2},
	[PM_P2P_GO_SAP_MCC_24_1x1] = {PM_NOP, PM_DBS2},
	[PM_P2P_GO_SAP_MCC_24_2x2] = {PM_NOP, PM_DBS2},
	[PM_P2P_GO_SAP_SCC_5_1x1] = {PM_DBS2, PM_NOP},
	[PM_P2P_GO_SAP_SCC_5_2x2] = {PM_DBS2_DOWNGRADE, PM_NOP},
	[PM_P2P_GO_SAP_MCC_5_1x1] = {PM_DBS2, PM_NOP},
	[PM_P2P_GO_SAP_MCC_5_2x2] = {PM_DBS2_DOWNGRADE, PM_NOP},
	[PM_P2P_GO_SAP_MCC_24_5_1x1] = {PM_DBS2_DOWNGRADE, PM_DBS2_DOWNGRADE},
	[PM_P2P_GO_SAP_MCC_24_5_2x2] = {PM_DBS2_DOWNGRADE, PM_DBS2_DOWNGRADE},
	[PM_P2P_GO_SAP_DBS_1x1] = {PM_DBS2_DOWNGRADE, PM_DBS2_DOWNGRADE},
	[PM_P2P_GO_SAP_DBS_2x2] = {PM_DBS2_DOWNGRADE, PM_DBS2_DOWNGRADE},

	[PM_P2P_CLI_SAP_SCC_24_1x1] = {PM_NOP, PM_DBS2},
	[PM_P2P_CLI_SAP_SCC_24_2x2] = {PM_NOP, PM_DBS2},
	[PM_P2P_CLI_SAP_MCC_24_1x1] = {PM_NOP, PM_DBS2},
	[PM_P2P_CLI_SAP_MCC_24_2x2] = {PM_NOP, PM_DBS2},
	[PM_P2P_CLI_SAP_SCC_5_1x1] = {PM_DBS2, PM_NOP},
	[PM_P2P_CLI_SAP_SCC_5_2x2] = {PM_DBS2_DOWNGRADE, PM_NOP},
	[PM_P2P_CLI_SAP_MCC_5_1x1] = {PM_DBS2, PM_NOP},
	[PM_P2P_CLI_SAP_MCC_5_2x2] = {PM_DBS2_DOWNGRADE, PM_NOP},
	[PM_P2P_CLI_SAP_MCC_24_5_1x1] = {PM_DBS2_DOWNGRADE, PM_DBS2_DOWNGRADE},
	[PM_P2P_CLI_SAP_MCC_24_5_2x2] = {PM_DBS2_DOWNGRADE, PM_DBS2_DOWNGRADE},
	[PM_P2P_CLI_SAP_DBS_1x1] = {PM_DBS2_DOWNGRADE, PM_DBS2_DOWNGRADE},
	[PM_P2P_CLI_SAP_DBS_2x2] = {PM_DBS2_DOWNGRADE, PM_DBS2_DOWNGRADE},

	[PM_SAP_SAP_SCC_24_1x1] = {PM_NOP, PM_DBS2},
	[PM_SAP_SAP_SCC_24_2x2] = {PM_NOP, PM_DBS2},
	[PM_SAP_SAP_MCC_24_1x1] = {PM_NOP, PM_DBS2},
	[PM_SAP_SAP_MCC_24_2x2] = {PM_NOP, PM_DBS2},
	[PM_SAP_SAP_SCC_5_1x1] = {PM_DBS2, PM_NOP},
	[PM_SAP_SAP_SCC_5_2x2] = {PM_DBS2_DOWNGRADE, PM_NOP},
	[PM_SAP_SAP_MCC_5_1x1] = {PM_DBS2, PM_NOP},
	[PM_SAP_SAP_MCC_5_2x2] = {PM_DBS2_DOWNGRADE, PM_NOP},
	[PM_SAP_SAP_MCC_24_5_1x1] = {PM_DBS2_DOWNGRADE, PM_DBS2_DOWNGRADE},
	[PM_SAP_SAP_MCC_24_5_2x2] = {PM_DBS2_DOWNGRADE, PM_DBS2_DOWNGRADE},
	[PM_SAP_SAP_DBS_1x1] = {PM_DBS2_DOWNGRADE, PM_DBS2_DOWNGRADE},
	[PM_SAP_SAP_DBS_2x2] = {PM_DBS2_DOWNGRADE, PM_DBS2_DOWNGRADE},
};

#endif
