/*
 * Copyright (c) 2012-2017 The Linux Foundation. All rights reserved.
 *
 * Permission to use, copy, modify, and/or distribute this software for
 * any purpose with or without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE
 * AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __WLAN_POLICY_MGR_TABLES_NO_DBS_H
#define __WLAN_POLICY_MGR_TABLES_NO_DBS_H

#include "wlan_policy_mgr_api.h"

/**
 * second_connection_pcl_nodbs_table - table which provides PCL
 * for the 2nd connection, when we have a connection already in
 * the system (with DBS not supported by HW)
 */
static const enum policy_mgr_pcl_type
second_connection_pcl_nodbs_table[PM_MAX_ONE_CONNECTION_MODE]
			[PM_MAX_NUM_OF_MODE][PM_MAX_CONC_PRIORITY_MODE] = {
	[PM_STA_24_1x1] = {
	[PM_STA_MODE] = {PM_5G, PM_SCC_CH, PM_SCC_CH},
	[PM_SAP_MODE] = {PM_SCC_CH_5G, PM_SCC_CH, PM_SCC_CH_5G},
	[PM_P2P_CLIENT_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH_5G},
	[PM_P2P_GO_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH_5G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_24_2x2] = {
	[PM_STA_MODE] = {PM_5G, PM_SCC_CH, PM_SCC_CH},
	[PM_SAP_MODE] = {PM_SCC_CH_5G, PM_SCC_CH, PM_SCC_CH_5G},
	[PM_P2P_CLIENT_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH_5G},
	[PM_P2P_GO_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH_5G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_5_1x1] = {
	[PM_STA_MODE] = {PM_SCC_CH_5G, PM_SCC_CH, PM_SCC_CH_5G},
	[PM_SAP_MODE] = {PM_SCC_CH_5G, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_CLIENT_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_5_2x2] = {
	[PM_STA_MODE] = {PM_SCC_CH_5G, PM_SCC_CH, PM_SCC_CH_5G},
	[PM_SAP_MODE] = {PM_SCC_CH_5G, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_CLIENT_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_CLI_24_1x1] = {
	[PM_STA_MODE] = {PM_5G, PM_SCC_CH, PM_SCC_CH},
	[PM_SAP_MODE] = {PM_SCC_CH_5G, PM_SCC_CH, PM_SCC_CH_5G},
	[PM_P2P_CLIENT_MODE] = {PM_5G, PM_SCC_CH, PM_SCC_CH_5G},
	[PM_P2P_GO_MODE] = {PM_5G, PM_SCC_CH, PM_SCC_CH_5G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_CLI_24_2x2] = {
	[PM_STA_MODE] = {PM_5G, PM_SCC_CH, PM_SCC_CH},
	[PM_SAP_MODE] = {PM_SCC_CH_5G, PM_SCC_CH, PM_SCC_CH_5G},
	[PM_P2P_CLIENT_MODE] = {PM_5G, PM_SCC_CH, PM_SCC_CH_5G},
	[PM_P2P_GO_MODE] = {PM_5G, PM_SCC_CH, PM_SCC_CH_5G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_CLI_5_1x1] = {
	[PM_STA_MODE] = {PM_SCC_CH_5G, PM_SCC_CH, PM_SCC_CH_5G},
	[PM_SAP_MODE] = {PM_SCC_CH_5G, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_CLIENT_MODE] = {PM_SCC_CH_5G, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_SCC_CH_5G, PM_SCC_CH, PM_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_CLI_5_2x2] = {
	[PM_STA_MODE] = {PM_SCC_CH_5G, PM_SCC_CH, PM_SCC_CH_5G},
	[PM_SAP_MODE] = {PM_SCC_CH_5G, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_CLIENT_MODE] = {PM_SCC_CH_5G, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_SCC_CH_5G, PM_SCC_CH, PM_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_24_1x1] = {
	[PM_STA_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_SAP_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_CLIENT_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_24_2x2] = {
	[PM_STA_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_SAP_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_CLIENT_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_5_1x1] = {
	[PM_STA_MODE] = {PM_SCC_CH_5G, PM_SCC_CH, PM_SCC_CH},
	[PM_SAP_MODE] = {PM_SCC_CH,    PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_CLIENT_MODE] = {PM_SCC_CH,    PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_SCC_CH,    PM_SCC_CH, PM_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_5_2x2] = {
	[PM_STA_MODE] = {PM_SCC_CH_5G, PM_SCC_CH, PM_SCC_CH},
	[PM_SAP_MODE] = {PM_SCC_CH,    PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_CLIENT_MODE] = {PM_SCC_CH,    PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_SCC_CH,    PM_SCC_CH, PM_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_SAP_24_1x1] = {
	[PM_STA_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_SAP_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_CLIENT_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_SAP_24_2x2] = {
	[PM_STA_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_SAP_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_CLIENT_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_SAP_5_1x1] = {
	[PM_STA_MODE] = {PM_SCC_CH_5G, PM_SCC_CH, PM_SCC_CH},
	[PM_SAP_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_CLIENT_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_SAP_5_2x2] = {
	[PM_STA_MODE] = {PM_SCC_CH_5G, PM_SCC_CH, PM_SCC_CH},
	[PM_SAP_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_CLIENT_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_IBSS_24_1x1] = {
	[PM_STA_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_IBSS_24_2x2] = {
	[PM_STA_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_IBSS_5_1x1] = {
	[PM_STA_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_IBSS_5_2x2] = {
	[PM_STA_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },
};

/**
 * third_connection_pcl_nodbs_table - table which provides PCL
 * for the 3rd connection, when we have two connections already
 * in the system (with DBS not supported by HW)
 */
static const enum policy_mgr_pcl_type
third_connection_pcl_nodbs_table[PM_MAX_TWO_CONNECTION_MODE]
			[PM_MAX_NUM_OF_MODE][PM_MAX_CONC_PRIORITY_MODE] = {
	[PM_STA_SAP_SCC_24_1x1] = {
	[PM_STA_MODE] = {PM_SCC_CH_5G, PM_SCC_CH, PM_SCC_CH},
	[PM_SAP_MODE] = {PM_SCC_CH_5G, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_SAP_SCC_24_2x2] = {
	[PM_STA_MODE] = {PM_SCC_CH_5G, PM_SCC_CH, PM_SCC_CH},
	[PM_SAP_MODE] = {PM_SCC_CH_5G, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_SAP_MCC_24_1x1] = {
	[PM_STA_MODE] = {PM_5G_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_SAP_MODE] = {PM_5G_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_SAP_MCC_24_2x2] = {
	[PM_STA_MODE] = {PM_5G_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_SAP_MODE] = {PM_5G_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_SAP_SCC_5_1x1] = {
	[PM_STA_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_SAP_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_SAP_SCC_5_2x2] = {
	[PM_STA_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_SAP_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_SAP_MCC_5_1x1] = {
	[PM_STA_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_SAP_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_SAP_MCC_5_2x2] = {
	[PM_STA_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_SAP_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_SAP_MCC_24_5_1x1] = {
	[PM_STA_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_SAP_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_SAP_MCC_24_5_2x2] = {
	[PM_STA_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_SAP_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_SAP_DBS_1x1] = {
	[PM_STA_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_GO_SCC_24_1x1] = {
	[PM_STA_MODE] = {PM_5G,        PM_SCC_CH, PM_SCC_CH},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {PM_5G,        PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_5G_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_GO_SCC_24_2x2] = {
	[PM_STA_MODE] = {PM_5G, PM_SCC_CH, PM_SCC_CH},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {PM_5G, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_5G_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_GO_MCC_24_1x1] = {
	[PM_STA_MODE] = {PM_5G_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_5G_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_GO_MODE] = {
			PM_5G_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_GO_MCC_24_2x2] = {
	[PM_STA_MODE] = {PM_5G_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_5G_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_GO_MODE] = {
			PM_5G_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_GO_SCC_5_1x1] = {
	[PM_STA_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_GO_SCC_5_2x2] = {
	[PM_STA_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_GO_MCC_5_1x1] = {
	[PM_STA_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_GO_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_GO_MCC_5_2x2] = {
	[PM_STA_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_GO_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_GO_MCC_24_5_1x1] = {
	[PM_STA_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_GO_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_GO_MCC_24_5_2x2] = {
	[PM_STA_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_GO_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_GO_DBS_1x1] = {
	[PM_STA_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_CLI_SCC_24_1x1] = {
	[PM_STA_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {PM_5G_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_5G_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_CLI_SCC_24_2x2] = {
	[PM_STA_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {PM_5G_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_5G_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_CLI_MCC_24_1x1] = {
	[PM_STA_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {PM_5G_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_GO_MODE] = {PM_5G_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_CLI_MCC_24_2x2] = {
	[PM_STA_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {PM_5G_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_GO_MODE] = {PM_5G_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_CLI_SCC_5_1x1] = {
	[PM_STA_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_CLI_SCC_5_2x2] = {
	[PM_STA_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_CLI_MCC_5_1x1] = {
	[PM_STA_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_GO_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_CLI_MCC_5_2x2] = {
	[PM_STA_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_GO_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_CLI_MCC_24_5_1x1] = {
	[PM_STA_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_GO_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_CLI_MCC_24_5_2x2] = {
	[PM_STA_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_GO_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_CLI_DBS_1x1] = {
	[PM_STA_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_P2P_CLI_SCC_24_1x1] = {
	[PM_STA_MODE] = {PM_5G, PM_SCC_CH, PM_SCC_CH},
	[PM_SAP_MODE] = {PM_SCC_CH_5G, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_CLIENT_MODE] = {PM_5G, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_5G_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_P2P_CLI_SCC_24_2x2] = {
	[PM_STA_MODE] = {PM_5G, PM_SCC_CH, PM_SCC_CH},
	[PM_SAP_MODE] = {PM_SCC_CH_5G, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_CLIENT_MODE] = {PM_5G, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_5G_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_P2P_CLI_MCC_24_1x1] = {
	[PM_STA_MODE] = {PM_5G_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_SAP_MODE] = {PM_5G_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_CLIENT_MODE] = {
			PM_5G_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_GO_MODE] = {
			PM_5G_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_P2P_CLI_MCC_24_2x2] = {
	[PM_STA_MODE] = {PM_5G_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_SAP_MODE] = {PM_5G_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_CLIENT_MODE] = {
			PM_5G_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_GO_MODE] = {
			PM_5G_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_P2P_CLI_SCC_5_1x1] = {
	[PM_STA_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_SAP_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_CLIENT_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_P2P_CLI_SCC_5_2x2] = {
	[PM_STA_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_SAP_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_CLIENT_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_SCC_CH, PM_SCC_CH, PM_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_P2P_CLI_MCC_5_1x1] = {
	[PM_STA_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_SAP_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_CLIENT_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_GO_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_P2P_CLI_MCC_5_2x2] = {
	[PM_STA_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_SAP_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_CLIENT_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_GO_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_P2P_CLI_MCC_24_5_1x1] = {
	[PM_STA_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_SAP_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_CLIENT_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_GO_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_P2P_CLI_MCC_24_5_2x2] = {
	[PM_STA_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_SAP_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_CLIENT_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_P2P_GO_MODE] = {PM_MCC_CH, PM_MCC_CH, PM_MCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_P2P_CLI_DBS_1x1] = {
	[PM_STA_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_SAP_SCC_24_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_SAP_SCC_24_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_SAP_MCC_24_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_SAP_MCC_24_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_SAP_SCC_5_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_SAP_SCC_5_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_SAP_MCC_5_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_SAP_MCC_5_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_SAP_MCC_24_5_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_SAP_MCC_24_5_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_SAP_DBS_1x1] = {
	[PM_STA_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },


	[PM_P2P_CLI_SAP_SCC_24_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_CLI_SAP_SCC_24_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_CLI_SAP_MCC_24_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_CLI_SAP_MCC_24_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_CLI_SAP_SCC_5_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_CLI_SAP_SCC_5_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_CLI_SAP_MCC_5_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_CLI_SAP_MCC_5_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_CLI_SAP_MCC_24_5_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_CLI_SAP_MCC_24_5_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_CLI_SAP_DBS_1x1] = {
	[PM_STA_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

};

#endif
