/*
 * Copyright (c) 2014-2018 The Linux Foundation. All rights reserved.
 *
 * Permission to use, copy, modify, and/or distribute this software for
 * any purpose with or without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE
 * AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __WLAN_HDD_TRACE_H__
#define __WLAN_HDD_TRACE_H__

#include "mac_trace.h"

#define NO_SESSION 0xFF

#undef ENUMS
#define ENUMS \
	ENUM(TRACE_CODE_HDD_OPEN_REQUEST) \
	ENUM(TRACE_CODE_HDD_STOP_REQUEST) \
	ENUM(TRACE_CODE_HDD_TX_TIMEOUT) \
	ENUM(TRACE_CODE_HDD_P2P_DEV_ADDR_IOCTL) \
	ENUM(TRACE_CODE_HDD_SETSUSPENDMODE_IOCTL) \
	ENUM(TRACE_CODE_HDD_SETROAMTRIGGER_IOCTL) \
	ENUM(TRACE_CODE_HDD_GETROAMTRIGGER_IOCTL) \
	ENUM(TRACE_CODE_HDD_SETROAMSCANPERIOD_IOCTL) \
	ENUM(TRACE_CODE_HDD_GETROAMSCANPERIOD_IOCTL) \
	ENUM(TRACE_CODE_HDD_SETROAMDELTA_IOCTL) \
	ENUM(TRACE_CODE_HDD_GETROAMDELTA_IOCTL) \
	ENUM(TRACE_CODE_HDD_GETBAND_IOCTL) \
	ENUM(TRACE_CODE_HDD_GETCOUNTRYREV_IOCTL) \
	ENUM(TRACE_CODE_HDD_SETROAMSCANCHANNELS_IOCTL) \
	ENUM(TRACE_CODE_HDD_GETROAMSCANCHANNELS_IOCTL) \
	ENUM(TRACE_CODE_HDD_HOSTAPD_OPEN_REQUEST) \
	ENUM(TRACE_CODE_HDD_HOSTAPD_STOP_REQUEST) \
	ENUM(TRACE_CODE_HDD_HOSTAPD_UNINIT_REQUEST) \
	ENUM(TRACE_CODE_HDD_SOFTAP_TX_TIMEOUT) \
	ENUM(TRACE_CODE_HDD_HOSTAPD_SET_MAC_ADDR) \
	ENUM(TRACE_CODE_HDD_HOSTAPD_P2P_SET_NOA_IOCTL) \
	ENUM(TRACE_CODE_HDD_HOSTAPD_P2P_SET_PS_IOCTL) \
	ENUM(TRACE_CODE_HDD_HOSTAPD_SET_SAP_CHANNEL_LIST_IOCTL) \
	ENUM(TRACE_CODE_HDD_ADD_VIRTUAL_INTF) \
	ENUM(TRACE_CODE_HDD_DEL_VIRTUAL_INTF) \
	ENUM(TRACE_CODE_HDD_CHANGE_VIRTUAL_INTF) \
	ENUM(TRACE_CODE_HDD_CFG80211_START_AP) \
	ENUM(TRACE_CODE_HDD_CFG80211_CHANGE_BEACON) \
	ENUM(TRACE_CODE_HDD_CFG80211_STOP_AP) \
	ENUM(TRACE_CODE_HDD_CFG80211_CHANGE_BSS) \
	ENUM(TRACE_CODE_HDD_CFG80211_ADD_KEY) \
	ENUM(TRACE_CODE_HDD_CFG80211_GET_KEY) \
	ENUM(TRACE_CODE_HDD_CFG80211_SET_DEFAULT_KEY) \
	ENUM(TRACE_CODE_HDD_CFG80211_CONNECT) \
	ENUM(TRACE_CODE_HDD_CFG80211_DISCONNECT) \
	ENUM(TRACE_CODE_HDD_CFG80211_JOIN_IBSS) \
	ENUM(TRACE_CODE_HDD_CFG80211_LEAVE_IBSS) \
	ENUM(TRACE_CODE_HDD_CFG80211_SET_WIPHY_PARAMS) \
	ENUM(TRACE_CODE_HDD_CFG80211_SET_TXPOWER) \
	ENUM(TRACE_CODE_HDD_CFG80211_GET_TXPOWER) \
	ENUM(TRACE_CODE_HDD_CFG80211_SET_CHANNEL) \
	ENUM(TRACE_CODE_HDD_CFG80211_ADD_BEACON) \
	ENUM(TRACE_CODE_HDD_CFG80211_SET_BEACON) \
	ENUM(TRACE_CODE_HDD_CFG80211_CHANGE_IFACE) \
	ENUM(TRACE_CODE_HDD_CHANGE_STATION) \
	ENUM(TRACE_CODE_HDD_CFG80211_UPDATE_BSS) \
	ENUM(TRACE_CODE_HDD_CFG80211_SCAN) \
	ENUM(TRACE_CODE_HDD_REMAIN_ON_CHANNEL) \
	ENUM(TRACE_CODE_HDD_REMAINCHANREADYHANDLER) \
	ENUM(TRACE_CODE_HDD_CFG80211_CANCEL_REMAIN_ON_CHANNEL) \
	ENUM(TRACE_CODE_HDD_ACTION) \
	ENUM(TRACE_CODE_HDD_MGMT_TX_CANCEL_WAIT) \
	ENUM(TRACE_CODE_HDD_CFG80211_GET_STA) \
	ENUM(TRACE_CODE_HDD_CFG80211_SET_POWER_MGMT) \
	ENUM(TRACE_CODE_HDD_CFG80211_DEL_STA) \
	ENUM(TRACE_CODE_HDD_CFG80211_ADD_STA) \
	ENUM(TRACE_CODE_HDD_CFG80211_SET_PMKSA) \
	ENUM(TRACE_CODE_HDD_CFG80211_UPDATE_FT_IES) \
	ENUM(TRACE_CODE_HDD_CFG80211_TDLS_MGMT) \
	ENUM(TRACE_CODE_HDD_CFG80211_TDLS_OPER) \
	ENUM(TRACE_CODE_HDD_CFG80211_SET_REKEY_DATA) \
	ENUM(TRACE_CODE_HDD_UNSUPPORTED_IOCTL) \
	ENUM(TRACE_CODE_HDD_SETROAMSCANCHANNELMINTIME_IOCTL) \
	ENUM(TRACE_CODE_HDD_GETROAMSCANCHANNELMINTIME_IOCTL) \
	ENUM(TRACE_CODE_HDD_STORE_JOIN_REQ) \
	ENUM(TRACE_CODE_HDD_CLEAR_JOIN_REQ) \
	ENUM(TRACE_CODE_HDD_ISSUE_JOIN_REQ) \
	ENUM(TRACE_CODE_HDD_CFG80211_RESUME_WLAN) \
	ENUM(TRACE_CODE_HDD_CFG80211_SUSPEND_WLAN) \
	ENUM(TRACE_CODE_HDD_CFG80211_SET_MAC_ACL) \
	ENUM(TRACE_CODE_HDD_CFG80211_TESTMODE) \
	ENUM(TRACE_CODE_HDD_CFG80211_DUMP_SURVEY) \
	ENUM(TRACE_CODE_HDD_CFG80211_SCHED_SCAN_START) \
	ENUM(TRACE_CODE_HDD_CFG80211_SCHED_SCAN_STOP) \
	ENUM(TRACE_CODE_HDD_CFG80211_DEL_PMKSA) \
	ENUM(TRACE_CODE_HDD_SEND_MGMT_TX) \
	/*
	 * New CFG80211 enums to be added before this comment.
	 * TRACE_CODE_HDD_RX_SME_MSG is used as code for MTRACE commands.
	 */ \
	ENUM(TRACE_CODE_HDD_RX_SME_MSG)

enum {
#undef ENUM
#define ENUM(enum) enum,
	ENUMS
};

/**
 * hdd_trace_event_string() - Convert trace event to string
 * @code: trace event enumeration to convert
 *
 * Return: string representation of the input enumeration
 */
static inline const char *hdd_trace_event_string(uint32_t code)
{
	switch (code) {
	default:
		return "UNKNOWN";
#undef ENUM
#define ENUM(enum) CASE_RETURN_STRING(enum)
	ENUMS
	}
}

#undef ENUMS
#undef ENUM

#ifdef HDD_TRACE_RECORD
void hdd_trace_init(void);
#else
static inline void hdd_trace_init(void) {}
#endif

#endif
