/*
 * Copyright 2017 NXP
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_MU_REGISTERS_H__
#define __HW_MU_REGISTERS_H__

/* ----------------------------------------------------------------------------
   -- MU Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MU_Peripheral_Access_Layer MU Peripheral Access Layer
 * @{
 */

/** MU - Register Layout Typedef */
typedef struct {
  __IO uint32_t TR[4];                             /**< Transmit Register n, array offset: 0x20, array step: 0x4 */
  __I  uint32_t RR[4];                             /**< Receive Register n, array offset: 0x40, array step: 0x4 */
  __IO uint32_t SR;                                /**< Status Register, offset: 0x60 */
  __IO uint32_t CR;                                /**< Control Register, offset: 0x64 */
} MU_Type, *MU_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- MU - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MU_Register_Accessor_Macros MU - Register accessor macros
 * @{
 */


/* MU - Register accessors */
#define MU_TR_REG(base,index)                    ((base)->TR[index])
#define MU_TR_COUNT                              4
#define MU_RR_REG(base,index)                    ((base)->RR[index])
#define MU_RR_COUNT                              4
#define MU_SR_REG(base)                          ((base)->SR)
#define MU_CR_REG(base)                          ((base)->CR)

/*!
 * @}
 */ /* end of group MU_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- MU Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MU_Register_Masks MU Register Masks
 * @{
 */

/* TR Bit Fields */
#define MU_TR_DATA_MASK                          0xFFFFFFFFu
#define MU_TR_DATA_SHIFT                         0
#define MU_TR_DATA_WIDTH                         32
#define MU_TR_DATA(x)                            (((uint32_t)(((uint32_t)(x))<<MU_TR_DATA_SHIFT))&MU_TR_DATA_MASK)
/* RR Bit Fields */
#define MU_RR_DATA_MASK                          0xFFFFFFFFu
#define MU_RR_DATA_SHIFT                         0
#define MU_RR_DATA_WIDTH                         32
#define MU_RR_DATA(x)                            (((uint32_t)(((uint32_t)(x))<<MU_RR_DATA_SHIFT))&MU_RR_DATA_MASK)
/* SR Bit Fields */
#define MU_SR_Fn_MASK                            0x7u
#define MU_SR_Fn_SHIFT                           0
#define MU_SR_Fn_WIDTH                           3
#define MU_SR_Fn(x)                              (((uint32_t)(((uint32_t)(x))<<MU_SR_Fn_SHIFT))&MU_SR_Fn_MASK)
#define MU_SR_EP_MASK                            0x10u
#define MU_SR_EP_SHIFT                           4
#define MU_SR_EP_WIDTH                           1
#define MU_SR_EP(x)                              (((uint32_t)(((uint32_t)(x))<<MU_SR_EP_SHIFT))&MU_SR_EP_MASK)
#define MU_SR_PM_MASK                            0x60u
#define MU_SR_PM_SHIFT                           5
#define MU_SR_PM_WIDTH                           2
#define MU_SR_PM(x)                              (((uint32_t)(((uint32_t)(x))<<MU_SR_PM_SHIFT))&MU_SR_PM_MASK)
#define MU_SR_FUP_MASK                           0x100u
#define MU_SR_FUP_SHIFT                          8
#define MU_SR_FUP_WIDTH                          1
#define MU_SR_FUP(x)                             (((uint32_t)(((uint32_t)(x))<<MU_SR_FUP_SHIFT))&MU_SR_FUP_MASK)
#define MU_SR_TEn_MASK                           0xF00000u
#define MU_SR_TEn_SHIFT                          20
#define MU_SR_TEn_WIDTH                          4
#define MU_SR_TEn(x)                             (((uint32_t)(((uint32_t)(x))<<MU_SR_TEn_SHIFT))&MU_SR_TEn_MASK)
#define MU_SR_RFn_MASK                           0xF000000u
#define MU_SR_RFn_SHIFT                          24
#define MU_SR_RFn_WIDTH                          4
#define MU_SR_RFn(x)                             (((uint32_t)(((uint32_t)(x))<<MU_SR_RFn_SHIFT))&MU_SR_RFn_MASK)
#define MU_SR_GIPn_MASK                          0xF0000000u
#define MU_SR_GIPn_SHIFT                         28
#define MU_SR_GIPn_WIDTH                         4
#define MU_SR_GIPn(x)                            (((uint32_t)(((uint32_t)(x))<<MU_SR_GIPn_SHIFT))&MU_SR_GIPn_MASK)
/* CR Bit Fields */
#define MU_CR_Fn_MASK                            0x7u
#define MU_CR_Fn_SHIFT                           0
#define MU_CR_Fn_WIDTH                           3
#define MU_CR_Fn(x)                              (((uint32_t)(((uint32_t)(x))<<MU_CR_Fn_SHIFT))&MU_CR_Fn_MASK)
#define MU_CR_NMI_MASK                           0x8u
#define MU_CR_NMI_SHIFT                          3
#define MU_CR_NMI_WIDTH                          1
#define MU_CR_NMI(x)                             (((uint32_t)(((uint32_t)(x))<<MU_CR_NMI_SHIFT))&MU_CR_NMI_MASK)
#define MU_CR_MUR_MASK                           0x20u
#define MU_CR_MUR_SHIFT                          5
#define MU_CR_MUR_WIDTH                          1
#define MU_CR_MUR(x)                             (((uint32_t)(((uint32_t)(x))<<MU_CR_MUR_SHIFT))&MU_CR_MUR_MASK)
#define MU_CR_GIRn_MASK                          0xF0000u
#define MU_CR_GIRn_SHIFT                         16
#define MU_CR_GIRn_WIDTH                         4
#define MU_CR_GIRn(x)                            (((uint32_t)(((uint32_t)(x))<<MU_CR_GIRn_SHIFT))&MU_CR_GIRn_MASK)
#define MU_CR_TIEn_MASK                          0xF00000u
#define MU_CR_TIEn_SHIFT                         20
#define MU_CR_TIEn_WIDTH                         4
#define MU_CR_TIEn(x)                            (((uint32_t)(((uint32_t)(x))<<MU_CR_TIEn_SHIFT))&MU_CR_TIEn_MASK)
#define MU_CR_RIEn_MASK                          0xF000000u
#define MU_CR_RIEn_SHIFT                         24
#define MU_CR_RIEn_WIDTH                         4
#define MU_CR_RIEn(x)                            (((uint32_t)(((uint32_t)(x))<<MU_CR_RIEn_SHIFT))&MU_CR_RIEn_MASK)
#define MU_CR_GIEn_MASK                          0xF0000000u
#define MU_CR_GIEn_SHIFT                         28
#define MU_CR_GIEn_WIDTH                         4
#define MU_CR_GIEn(x)                            (((uint32_t)(((uint32_t)(x))<<MU_CR_GIEn_SHIFT))&MU_CR_GIEn_MASK)

/*!
 * @}
 */ /* end of group MU_Register_Masks */

/* MU - Peripheral instance base addresses */

/** Peripheral SC_MU_0B base address */
#define SC_MU_0B_BASE                               (0x41043000u)
/** Peripheral SC_MU_0B base pointer */
#define SC_MU_0B                                    ((MU_Type *)SC_MU_0B_BASE)
#define SC_MU_0B_BASE_PTR                           (SC_MU_0B)

/** Peripheral SC_MU_0A0 base address */
#define SC_MU_0A0_BASE                              (0x41044000u)
/** Peripheral SC_MU_0A0 base pointer */
#define SC_MU_0A0                                   ((MU_Type *)SC_MU_0A0_BASE)
#define SC_MU_0A0_BASE_PTR                          (SC_MU_0A0)

/** Peripheral SC_MU_0A1 base address */
#define SC_MU_0A1_BASE                              (0x41045000u)
/** Peripheral SC_MU_0A1 base pointer */
#define SC_MU_0A1                                   ((MU_Type *)SC_MU_0A1_BASE)
#define SC_MU_0A1_BASE_PTR                          (SC_MU_0A1)

/** Peripheral SC_MU_0A2 base address */
#define SC_MU_0A2_BASE                              (0x41046000u)
/** Peripheral SC_MU_0A2 base pointer */
#define SC_MU_0A2                                   ((MU_Type *)SC_MU_0A2_BASE)
#define SC_MU_0A2_BASE_PTR                          (SC_MU_0A2)

/** Peripheral SC_MU_0A3 base address */
#define SC_MU_0A3_BASE                              (0x41047000u)
/** Peripheral SC_MU_0A3 base pointer */
#define SC_MU_0A3                                   ((MU_Type *)SC_MU_0A3_BASE)
#define SC_MU_0A3_BASE_PTR                          (SC_MU_0A3)

/** Peripheral SC_MU_1A base address */
#define SC_MU_1A_BASE                               (0x41048000u)
/** Peripheral SC_MU_1A base pointer */
#define SC_MU_1A                                    ((MU_Type *)SC_MU_1A_BASE)
#define SC_MU_1A_BASE_PTR                           (SC_MU_1A)

/** Peripheral MU_0A base address */
#define MU_0A_BASE                                  (0x5E1B0000u)
/** Peripheral MU_0A base pointer */
#define MU_0A                                       ((MU_Type *)MU_0A_BASE)
#define MU_0A_BASE_PTR                              (MU_0A)

/** Peripheral MU_1A base address */
#define MU_1A_BASE                                  (0x5E1C0000)
/** Peripheral MU_1A base pointer */
#define MU_1A                                       ((MU_Type *)MU_1A_BASE)
#define MU_1A_BASE_PTR                              (MU_1A)

/** Peripheral MU_2A base address */
#define MU_2A_BASE                                  (0x5E1D0000)
/** Peripheral MU_2A base pointer */
#define MU_2A                                       ((MU_Type *)MU_2A_BASE)
#define MU_2A_BASE_PTR                              (MU_2A)

/** Peripheral MU_3A base address */
#define MU_3A_BASE                                  (0x5E1E0000)
/** Peripheral MU_3A base pointer */
#define MU_3A                                       ((MU_Type *)MU_3A_BASE)
#define MU_3A_BASE_PTR                              (MU_3A)

/** Peripheral MU_4A base address */
#define MU_4A_BASE                                  (0x5E1F0000)
/** Peripheral MU_4A base pointer */
#define MU_4A                                       ((MU_Type *)MU_4A_BASE)
#define MU_4A_BASE_PTR                              (MU_0A)

/* ----------------------------------------------------------------------------
   -- MU - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @}
 */ /* end of group MU_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group MU_Peripheral_Access_Layer */

#endif /* __HW_MU_REGISTERS_H__ */

