/*
 * Copyright 2018 NXP
 *
 * SPDX-License-Identifier: GPL-2.0+
 */

#ifndef ANAMIX_COMMON_TMP_H
#define ANAMIX_COMMON_TMP_H

/*ANAMIX Address Definition*/
#define ANAMIX_PLL_BASE_ADDR         0x30360000
#define ANAMIX_OSC_BASE_ADDR         0x30270000
#define ANAMIX_TSN_BASE_ADDR         0x30260000

/*  PLL TOP REG */
#define AUDIO_PLL1_GNRL_CTL_ADDR  (ANAMIX_PLL_BASE_ADDR + 0x00)
#define AUDIO_PLL1_FDIV_CTL0_ADDR (ANAMIX_PLL_BASE_ADDR + 0x04)
#define AUDIO_PLL1_FDIV_CTL1_ADDR (ANAMIX_PLL_BASE_ADDR + 0x08)
#define AUDIO_PLL1_SSCG_CTL_ADDR  (ANAMIX_PLL_BASE_ADDR + 0x0c)
#define AUDIO_PLL1_MINT_CTL_ADDR  (ANAMIX_PLL_BASE_ADDR + 0x10)
#define AUDIO_PLL2_GNRL_CTL_ADDR  (ANAMIX_PLL_BASE_ADDR + 0x14)
#define AUDIO_PLL2_FDIV_CTL0_ADDR (ANAMIX_PLL_BASE_ADDR + 0x18)
#define AUDIO_PLL2_FDIV_CTL1_ADDR (ANAMIX_PLL_BASE_ADDR + 0x1c)
#define AUDIO_PLL2_SSCG_CTL_ADDR  (ANAMIX_PLL_BASE_ADDR + 0x20)
#define AUDIO_PLL2_MINT_CTL_ADDR  (ANAMIX_PLL_BASE_ADDR + 0x24)
#define VIDEO_PLL1_GNRL_CTL_ADDR  (ANAMIX_PLL_BASE_ADDR + 0x28)
#define VIDEO_PLL1_FDIV_CTL0_ADDR (ANAMIX_PLL_BASE_ADDR + 0x2c)
#define VIDEO_PLL1_FDIV_CTL1_ADDR (ANAMIX_PLL_BASE_ADDR + 0x30)
#define VIDEO_PLL1_SSCG_CTL_ADDR  (ANAMIX_PLL_BASE_ADDR + 0x34)
#define VIDEO_PLL1_MINT_CTL_ADDR  (ANAMIX_PLL_BASE_ADDR + 0x38)
#define VIDEO_PLL2_GNRL_CTL_ADDR  (ANAMIX_PLL_BASE_ADDR + 0x3c)
#define VIDEO_PLL2_FDIV_CTL0_ADDR (ANAMIX_PLL_BASE_ADDR + 0x40)
#define VIDEO_PLL2_FDIV_CTL1_ADDR (ANAMIX_PLL_BASE_ADDR + 0x44)
#define VIDEO_PLL2_SSCG_CTL_ADDR  (ANAMIX_PLL_BASE_ADDR + 0x48)
#define VIDEO_PLL2_MINT_CTL_ADDR  (ANAMIX_PLL_BASE_ADDR + 0x4c)
#define DRAM_PLL_GNRL_CTL_ADDR    (ANAMIX_PLL_BASE_ADDR + 0x50)
#define DRAM_PLL_FDIV_CTL0_ADDR   (ANAMIX_PLL_BASE_ADDR + 0x54)
#define DRAM_PLL_FDIV_CTL1_ADDR   (ANAMIX_PLL_BASE_ADDR + 0x58)
#define DRAM_PLL_SSCG_CTL_ADDR    (ANAMIX_PLL_BASE_ADDR + 0x5c)
#define DRAM_PLL_MINT_CTL_ADDR    (ANAMIX_PLL_BASE_ADDR + 0x60)
#define GPU_PLL_GNRL_CTL_ADDR     (ANAMIX_PLL_BASE_ADDR + 0x64)
#define GPU_PLL_DIV_CTL_ADDR	  (ANAMIX_PLL_BASE_ADDR + 0x68)
#define GPU_PLL_LOCKD_CTL_ADDR    (ANAMIX_PLL_BASE_ADDR + 0x6c)
#define GPU_PLL_MINT_CTL_ADDR     (ANAMIX_PLL_BASE_ADDR + 0x70)
#define VPU_PLL_GNRL_CTL_ADDR     (ANAMIX_PLL_BASE_ADDR + 0x74)
#define VPU_PLL_DIV_CTL_ADDR	  (ANAMIX_PLL_BASE_ADDR + 0x78)
#define VPU_PLL_LOCKD_CTL_ADDR    (ANAMIX_PLL_BASE_ADDR + 0x7c)
#define VPU_PLL_MINT_CTL_ADDR     (ANAMIX_PLL_BASE_ADDR + 0x80)
#define ARM_PLL_GNRL_CTL_ADDR     (ANAMIX_PLL_BASE_ADDR + 0x84)
#define ARM_PLL_DIV_CTL_ADDR      (ANAMIX_PLL_BASE_ADDR + 0x88)
#define ARM_PLL_LOCKD_CTL_ADDR    (ANAMIX_PLL_BASE_ADDR + 0x8c)
#define ARM_PLL_MINT_CTL_ADDR     (ANAMIX_PLL_BASE_ADDR + 0x90)
#define SYS_PLL1_GNRL_CTL_ADDR    (ANAMIX_PLL_BASE_ADDR + 0x94)
#define SYS_PLL1_DIV_CTL_ADDR     (ANAMIX_PLL_BASE_ADDR + 0x98)
#define SYS_PLL1_LOCKD_CTL_ADDR   (ANAMIX_PLL_BASE_ADDR + 0x9c)
#define SYS_PLL1_MINT_CTL_ADDR    (ANAMIX_PLL_BASE_ADDR + 0x100)
#define SYS_PLL2_GNRL_CTL_ADDR    (ANAMIX_PLL_BASE_ADDR + 0x104)
#define SYS_PLL2_DIV_CTL_ADDR     (ANAMIX_PLL_BASE_ADDR + 0x108)
#define SYS_PLL2_LOCKD_CTL_ADDR   (ANAMIX_PLL_BASE_ADDR + 0x10c)
#define SYS_PLL2_MINT_CTL_ADDR    (ANAMIX_PLL_BASE_ADDR + 0x110)
#define SYS_PLL3_GNRL_CTL_ADDR    (ANAMIX_PLL_BASE_ADDR + 0x114)
#define SYS_PLL3_DIV_CTL_ADDR     (ANAMIX_PLL_BASE_ADDR + 0x118)
#define SYS_PLL3_LOCKD_CTL_ADDR   (ANAMIX_PLL_BASE_ADDR + 0x11c)
#define SYS_PLL3_MINT_CTL_ADDR    (ANAMIX_PLL_BASE_ADDR + 0x120)
#define ANAMIX_MISC_CTL_ADDR      (ANAMIX_PLL_BASE_ADDR + 0x124)
#define ANAMIX_CLK_MINT_CTL_ADDR  (ANAMIX_PLL_BASE_ADDR + 0x128)

/* TMP SNSR REG */
#define TER_ADDR      (ANAMIX_TSN_BASE_ADDR + 0x00)
#define TSR_ADDR      (ANAMIX_TSN_BASE_ADDR + 0x04)
#define TIER_ADDR     (ANAMIX_TSN_BASE_ADDR + 0x08)
#define TIDR_ADDR     (ANAMIX_TSN_BASE_ADDR + 0x0c)
#define TMHTITR_ADDR  (ANAMIX_TSN_BASE_ADDR + 0x10)
#define TMHTATR_ADDR  (ANAMIX_TSN_BASE_ADDR + 0x14)
#define TMHTACTR_ADDR (ANAMIX_TSN_BASE_ADDR + 0x18)
#define TSCR_ADDR     (ANAMIX_TSN_BASE_ADDR + 0x1c)
#define TRITSR_ADDR   (ANAMIX_TSN_BASE_ADDR + 0x20)
#define TRATSR_ADDR   (ANAMIX_TSN_BASE_ADDR + 0x24)
#define TASR_ADDR     (ANAMIX_TSN_BASE_ADDR + 0x28)
#define TTMC_ADDR     (ANAMIX_TSN_BASE_ADDR + 0x2c)

/* OSC */
#define SYS_OSCNML_CTL0_ADDR  (ANAMIX_OSC_BASE_ADDR + 0x00)
#define SYS_OSCNML_CTL1_ADDR  (ANAMIX_OSC_BASE_ADDR + 0x04)
#define HDMI_OSCNML_CTL0_ADDR (ANAMIX_OSC_BASE_ADDR + 0x8000)
#define HDMI_OSCNML_CTL1_ADDR (ANAMIX_OSC_BASE_ADDR + 0x8004)

#endif
