/******************************************************************************
 *
 * Copyright (C) 2016-2017 Cadence Design Systems, Inc.
 * All rights reserved worldwide.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its contributors
 * may be used to endorse or promote products derived from this software without
 * specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. THE SOFTWARE IS PROVIDED "AS IS",
 * WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 * FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Copyright 2017-2018 NXP
 *
 ******************************************************************************
 *
 * externs.h
 *
 ******************************************************************************
 */

#ifndef EXTERNS_H_
#define EXTERNS_H_

#ifndef __UBOOT__
#include <stdint.h>

#else
#include <common.h>
#endif
/**
 * \addtogroup UTILS
 * \{
 */
/**
 * \brief read from apb
 * \param addr - address to read
 * \param value - pointer to store value
 * \return non-zero value if error
 */
/*extern int cdn_bus_read(unsigned int addr, unsigned int* value);*/

/**
 * \brief write to apb
 * \param addr - address to write
 * \param value - value to write
 * \return non-zero if error
 */
/*extern int cdn_bus_write(unsigned int addr, unsigned int value);*/

uint32_t cdn_apb_read(uint32_t addr, uint32_t *value);
uint32_t cdn_sapb_read(uint32_t addr, uint32_t *value);
uint32_t cdn_apb_write(uint32_t addr, uint32_t value);
uint32_t cdn_sapb_write(uint32_t addr, uint32_t value);
uint32_t hdp_rx_apb_read(uint32_t addr, uint32_t *value);
uint32_t hdp_rx_sapb_read(uint32_t addr, uint32_t *value);
uint32_t hdp_rx_apb_write(uint32_t addr, uint32_t value);
uint32_t hdp_rx_sapb_write(uint32_t addr, uint32_t value);
#endif

