/*
 * Freescale PXP Register Definitions
 *
 * Copyright 2014-2015 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * This file is created by xml file. Don't Edit it.
 *
 * Xml Revision: 1.77
 * Template revision: 1.3
 */

#ifndef __ARCH_ARM___PXP_H
#define __ARCH_ARM___PXP_H


#define HW_PXP_CTRL	(0x00000000)
#define HW_PXP_CTRL_SET	(0x00000004)
#define HW_PXP_CTRL_CLR	(0x00000008)
#define HW_PXP_CTRL_TOG	(0x0000000c)

#define BM_PXP_CTRL_SFTRST 0x80000000
#define BF_PXP_CTRL_SFTRST(v) \
        (((v) << 31) & BM_PXP_CTRL_SFTRST)
#define BM_PXP_CTRL_CLKGATE 0x40000000
#define BF_PXP_CTRL_CLKGATE(v)  \
        (((v) << 30) & BM_PXP_CTRL_CLKGATE)
#define BM_PXP_CTRL_RSVD4 0x20000000
#define BF_PXP_CTRL_RSVD4(v)  \
        (((v) << 29) & BM_PXP_CTRL_RSVD4)
#define BM_PXP_CTRL_EN_REPEAT 0x10000000
#define BF_PXP_CTRL_EN_REPEAT(v)  \
        (((v) << 28) & BM_PXP_CTRL_EN_REPEAT)
#define BM_PXP_CTRL_ENABLE_ROTATE1 0x08000000
#define BF_PXP_CTRL_ENABLE_ROTATE1(v)  \
        (((v) << 27) & BM_PXP_CTRL_ENABLE_ROTATE1)
#define BM_PXP_CTRL_ENABLE_ROTATE0 0x04000000
#define BF_PXP_CTRL_ENABLE_ROTATE0(v)  \
        (((v) << 26) & BM_PXP_CTRL_ENABLE_ROTATE0)
#define BM_PXP_CTRL_ENABLE_LUT 0x02000000
#define BF_PXP_CTRL_ENABLE_LUT(v)  \
        (((v) << 25) & BM_PXP_CTRL_ENABLE_LUT)
#define BM_PXP_CTRL_ENABLE_CSC2 0x01000000
#define BF_PXP_CTRL_ENABLE_CSC2(v)  \
        (((v) << 24) & BM_PXP_CTRL_ENABLE_CSC2)
#define BM_PXP_CTRL_BLOCK_SIZE 0x00800000
#define BF_PXP_CTRL_BLOCK_SIZE(v)  \
        (((v) << 23) & BM_PXP_CTRL_BLOCK_SIZE)
#define BV_PXP_CTRL_BLOCK_SIZE__8X8   0x0
#define BV_PXP_CTRL_BLOCK_SIZE__16X16 0x1
#define BM_PXP_CTRL_RSVD1 0x00400000
#define BF_PXP_CTRL_RSVD1(v)  \
        (((v) << 22) & BM_PXP_CTRL_RSVD1)
#define BM_PXP_CTRL_ENABLE_ALPHA_B 0x00200000
#define BF_PXP_CTRL_ENABLE_ALPHA_B(v)  \
        (((v) << 21) & BM_PXP_CTRL_ENABLE_ALPHA_B)
#define BM_PXP_CTRL_ENABLE_INPUT_FETCH_STORE 0x00100000
#define BF_PXP_CTRL_ENABLE_INPUT_FETCH_STORE(v)  \
        (((v) << 20) & BM_PXP_CTRL_ENABLE_INPUT_FETCH_STORE)
#define BM_PXP_CTRL_ENABLE_WFE_B 0x00080000
#define BF_PXP_CTRL_ENABLE_WFE_B(v)  \
        (((v) << 19) & BM_PXP_CTRL_ENABLE_WFE_B)
#define BM_PXP_CTRL_ENABLE_WFE_A 0x00040000
#define BF_PXP_CTRL_ENABLE_WFE_A(v)  \
        (((v) << 18) & BM_PXP_CTRL_ENABLE_WFE_A)
#define BM_PXP_CTRL_ENABLE_DITHER 0x00020000
#define BF_PXP_CTRL_ENABLE_DITHER(v)  \
        (((v) << 17) & BM_PXP_CTRL_ENABLE_DITHER)
#define BM_PXP_CTRL_ENABLE_PS_AS_OUT 0x00010000
#define BF_PXP_CTRL_ENABLE_PS_AS_OUT(v)  \
        (((v) << 16) & BM_PXP_CTRL_ENABLE_PS_AS_OUT)
#define BM_PXP_CTRL_VFLIP1 0x00008000
#define BF_PXP_CTRL_VFLIP1(v)  \
        (((v) << 15) & BM_PXP_CTRL_VFLIP1)
#define BM_PXP_CTRL_HFLIP1 0x00004000
#define BF_PXP_CTRL_HFLIP1(v)  \
        (((v) << 14) & BM_PXP_CTRL_HFLIP1)
#define BP_PXP_CTRL_ROTATE1      12
#define BM_PXP_CTRL_ROTATE1 0x00003000
#define BF_PXP_CTRL_ROTATE1(v)  \
        (((v) << 12) & BM_PXP_CTRL_ROTATE1)
#define BV_PXP_CTRL_ROTATE1__ROT_0   0x0
#define BV_PXP_CTRL_ROTATE1__ROT_90  0x1
#define BV_PXP_CTRL_ROTATE1__ROT_180 0x2
#define BV_PXP_CTRL_ROTATE1__ROT_270 0x3
#define BM_PXP_CTRL_VFLIP0 0x00000800
#define BF_PXP_CTRL_VFLIP0(v)  \
        (((v) << 11) & BM_PXP_CTRL_VFLIP0)
#define BM_PXP_CTRL_HFLIP0 0x00000400
#define BF_PXP_CTRL_HFLIP0(v)  \
        (((v) << 10) & BM_PXP_CTRL_HFLIP0)
#define BP_PXP_CTRL_ROTATE0      8
#define BM_PXP_CTRL_ROTATE0 0x00000300
#define BF_PXP_CTRL_ROTATE0(v)  \
        (((v) << 8) & BM_PXP_CTRL_ROTATE0)
#define BV_PXP_CTRL_ROTATE0__ROT_0   0x0
#define BV_PXP_CTRL_ROTATE0__ROT_90  0x1
#define BV_PXP_CTRL_ROTATE0__ROT_180 0x2
#define BV_PXP_CTRL_ROTATE0__ROT_270 0x3
#define BP_PXP_CTRL_RSVD0      6
#define BM_PXP_CTRL_RSVD0 0x000000C0
#define BF_PXP_CTRL_RSVD0(v)  \
        (((v) << 6) & BM_PXP_CTRL_RSVD0)
#define BM_PXP_CTRL_HANDSHAKE_ABORT_SKIP 0x00000020
#define BF_PXP_CTRL_HANDSHAKE_ABORT_SKIP(v)  \
        (((v) << 5) & BM_PXP_CTRL_HANDSHAKE_ABORT_SKIP)
#define BM_PXP_CTRL_ENABLE_LCD0_HANDSHAKE 0x00000010
#define BF_PXP_CTRL_ENABLE_LCD0_HANDSHAKE(v)  \
        (((v) << 4) & BM_PXP_CTRL_ENABLE_LCD0_HANDSHAKE)
#define BM_PXP_CTRL_LUT_DMA_IRQ_ENABLE 0x00000008
#define BF_PXP_CTRL_LUT_DMA_IRQ_ENABLE(v)  \
        (((v) << 3) & BM_PXP_CTRL_LUT_DMA_IRQ_ENABLE)
#define BM_PXP_CTRL_NEXT_IRQ_ENABLE 0x00000004
#define BF_PXP_CTRL_NEXT_IRQ_ENABLE(v)  \
        (((v) << 2) & BM_PXP_CTRL_NEXT_IRQ_ENABLE)
#define BM_PXP_CTRL_IRQ_ENABLE 0x00000002
#define BF_PXP_CTRL_IRQ_ENABLE(v)  \
        (((v) << 1) & BM_PXP_CTRL_IRQ_ENABLE)
#define BM_PXP_CTRL_ENABLE 0x00000001
#define BF_PXP_CTRL_ENABLE(v)  \
        (((v) << 0) & BM_PXP_CTRL_ENABLE)

#define HW_PXP_STAT	(0x00000010)
#define HW_PXP_STAT_SET	(0x00000014)
#define HW_PXP_STAT_CLR	(0x00000018)
#define HW_PXP_STAT_TOG	(0x0000001c)

#define BP_PXP_STAT_BLOCKX      24
#define BM_PXP_STAT_BLOCKX 0xFF000000
#define BF_PXP_STAT_BLOCKX(v) \
        (((v) << 24) & BM_PXP_STAT_BLOCKX)
#define BP_PXP_STAT_BLOCKY      16
#define BM_PXP_STAT_BLOCKY 0x00FF0000
#define BF_PXP_STAT_BLOCKY(v)  \
        (((v) << 16) & BM_PXP_STAT_BLOCKY)
#define BP_PXP_STAT_AXI_ERROR_ID_1      12
#define BM_PXP_STAT_AXI_ERROR_ID_1 0x0000F000
#define BF_PXP_STAT_AXI_ERROR_ID_1(v)  \
        (((v) << 12) & BM_PXP_STAT_AXI_ERROR_ID_1)
#define BM_PXP_STAT_RSVD2 0x00000800
#define BF_PXP_STAT_RSVD2(v)  \
        (((v) << 11) & BM_PXP_STAT_RSVD2)
#define BM_PXP_STAT_AXI_READ_ERROR_1 0x00000400
#define BF_PXP_STAT_AXI_READ_ERROR_1(v)  \
        (((v) << 10) & BM_PXP_STAT_AXI_READ_ERROR_1)
#define BM_PXP_STAT_AXI_WRITE_ERROR_1 0x00000200
#define BF_PXP_STAT_AXI_WRITE_ERROR_1(v)  \
        (((v) << 9) & BM_PXP_STAT_AXI_WRITE_ERROR_1)
#define BM_PXP_STAT_LUT_DMA_LOAD_DONE_IRQ 0x00000100
#define BF_PXP_STAT_LUT_DMA_LOAD_DONE_IRQ(v)  \
        (((v) << 8) & BM_PXP_STAT_LUT_DMA_LOAD_DONE_IRQ)
#define BP_PXP_STAT_AXI_ERROR_ID_0      4
#define BM_PXP_STAT_AXI_ERROR_ID_0 0x000000F0
#define BF_PXP_STAT_AXI_ERROR_ID_0(v)  \
        (((v) << 4) & BM_PXP_STAT_AXI_ERROR_ID_0)
#define BM_PXP_STAT_NEXT_IRQ 0x00000008
#define BF_PXP_STAT_NEXT_IRQ(v)  \
        (((v) << 3) & BM_PXP_STAT_NEXT_IRQ)
#define BM_PXP_STAT_AXI_READ_ERROR_0 0x00000004
#define BF_PXP_STAT_AXI_READ_ERROR_0(v)  \
        (((v) << 2) & BM_PXP_STAT_AXI_READ_ERROR_0)
#define BM_PXP_STAT_AXI_WRITE_ERROR_0 0x00000002
#define BF_PXP_STAT_AXI_WRITE_ERROR_0(v)  \
        (((v) << 1) & BM_PXP_STAT_AXI_WRITE_ERROR_0)
#define BM_PXP_STAT_IRQ0 0x00000001
#define BF_PXP_STAT_IRQ0(v)  \
        (((v) << 0) & BM_PXP_STAT_IRQ0)

#define HW_PXP_OUT_CTRL	(0x00000020)
#define HW_PXP_OUT_CTRL_SET	(0x00000024)
#define HW_PXP_OUT_CTRL_CLR	(0x00000028)
#define HW_PXP_OUT_CTRL_TOG	(0x0000002c)

#define BP_PXP_OUT_CTRL_ALPHA      24
#define BM_PXP_OUT_CTRL_ALPHA 0xFF000000
#define BF_PXP_OUT_CTRL_ALPHA(v) \
        (((v) << 24) & BM_PXP_OUT_CTRL_ALPHA)
#define BM_PXP_OUT_CTRL_ALPHA_OUTPUT 0x00800000
#define BF_PXP_OUT_CTRL_ALPHA_OUTPUT(v)  \
        (((v) << 23) & BM_PXP_OUT_CTRL_ALPHA_OUTPUT)
#define BP_PXP_OUT_CTRL_RSVD1      10
#define BM_PXP_OUT_CTRL_RSVD1 0x007FFC00
#define BF_PXP_OUT_CTRL_RSVD1(v)  \
        (((v) << 10) & BM_PXP_OUT_CTRL_RSVD1)
#define BP_PXP_OUT_CTRL_INTERLACED_OUTPUT      8
#define BM_PXP_OUT_CTRL_INTERLACED_OUTPUT 0x00000300
#define BF_PXP_OUT_CTRL_INTERLACED_OUTPUT(v)  \
        (((v) << 8) & BM_PXP_OUT_CTRL_INTERLACED_OUTPUT)
#define BV_PXP_OUT_CTRL_INTERLACED_OUTPUT__PROGRESSIVE 0x0
#define BV_PXP_OUT_CTRL_INTERLACED_OUTPUT__FIELD0      0x1
#define BV_PXP_OUT_CTRL_INTERLACED_OUTPUT__FIELD1      0x2
#define BV_PXP_OUT_CTRL_INTERLACED_OUTPUT__INTERLACED  0x3
#define BP_PXP_OUT_CTRL_RSVD0      5
#define BM_PXP_OUT_CTRL_RSVD0 0x000000E0
#define BF_PXP_OUT_CTRL_RSVD0(v)  \
        (((v) << 5) & BM_PXP_OUT_CTRL_RSVD0)
#define BP_PXP_OUT_CTRL_FORMAT      0
#define BM_PXP_OUT_CTRL_FORMAT 0x0000001F
#define BF_PXP_OUT_CTRL_FORMAT(v)  \
        (((v) << 0) & BM_PXP_OUT_CTRL_FORMAT)
#define BV_PXP_OUT_CTRL_FORMAT__ARGB8888  0x0
#define BV_PXP_OUT_CTRL_FORMAT__RGB888    0x4
#define BV_PXP_OUT_CTRL_FORMAT__RGB888P   0x5
#define BV_PXP_OUT_CTRL_FORMAT__ARGB1555  0x8
#define BV_PXP_OUT_CTRL_FORMAT__ARGB4444  0x9
#define BV_PXP_OUT_CTRL_FORMAT__RGB555    0xC
#define BV_PXP_OUT_CTRL_FORMAT__RGB444    0xD
#define BV_PXP_OUT_CTRL_FORMAT__RGB565    0xE
#define BV_PXP_OUT_CTRL_FORMAT__YUV1P444  0x10
#define BV_PXP_OUT_CTRL_FORMAT__UYVY1P422 0x12
#define BV_PXP_OUT_CTRL_FORMAT__VYUY1P422 0x13
#define BV_PXP_OUT_CTRL_FORMAT__Y8        0x14
#define BV_PXP_OUT_CTRL_FORMAT__Y4        0x15
#define BV_PXP_OUT_CTRL_FORMAT__YUV2P422  0x18
#define BV_PXP_OUT_CTRL_FORMAT__YUV2P420  0x19
#define BV_PXP_OUT_CTRL_FORMAT__YVU2P422  0x1A
#define BV_PXP_OUT_CTRL_FORMAT__YVU2P420  0x1B

#define HW_PXP_OUT_BUF	(0x00000030)

#define BP_PXP_OUT_BUF_ADDR      0
#define BM_PXP_OUT_BUF_ADDR 0xFFFFFFFF
#define BF_PXP_OUT_BUF_ADDR(v)   (v)

#define HW_PXP_OUT_BUF2	(0x00000040)

#define BP_PXP_OUT_BUF2_ADDR      0
#define BM_PXP_OUT_BUF2_ADDR 0xFFFFFFFF
#define BF_PXP_OUT_BUF2_ADDR(v)   (v)

#define HW_PXP_OUT_PITCH	(0x00000050)

#define BP_PXP_OUT_PITCH_RSVD      16
#define BM_PXP_OUT_PITCH_RSVD 0xFFFF0000
#define BF_PXP_OUT_PITCH_RSVD(v) \
        (((v) << 16) & BM_PXP_OUT_PITCH_RSVD)
#define BP_PXP_OUT_PITCH_PITCH      0
#define BM_PXP_OUT_PITCH_PITCH 0x0000FFFF
#define BF_PXP_OUT_PITCH_PITCH(v)  \
        (((v) << 0) & BM_PXP_OUT_PITCH_PITCH)

#define HW_PXP_OUT_LRC	(0x00000060)

#define BP_PXP_OUT_LRC_RSVD1      30
#define BM_PXP_OUT_LRC_RSVD1 0xC0000000
#define BF_PXP_OUT_LRC_RSVD1(v) \
        (((v) << 30) & BM_PXP_OUT_LRC_RSVD1)
#define BP_PXP_OUT_LRC_X      16
#define BM_PXP_OUT_LRC_X 0x3FFF0000
#define BF_PXP_OUT_LRC_X(v)  \
        (((v) << 16) & BM_PXP_OUT_LRC_X)
#define BP_PXP_OUT_LRC_RSVD0      14
#define BM_PXP_OUT_LRC_RSVD0 0x0000C000
#define BF_PXP_OUT_LRC_RSVD0(v)  \
        (((v) << 14) & BM_PXP_OUT_LRC_RSVD0)
#define BP_PXP_OUT_LRC_Y      0
#define BM_PXP_OUT_LRC_Y 0x00003FFF
#define BF_PXP_OUT_LRC_Y(v)  \
        (((v) << 0) & BM_PXP_OUT_LRC_Y)

#define HW_PXP_OUT_PS_ULC	(0x00000070)

#define BP_PXP_OUT_PS_ULC_RSVD1      30
#define BM_PXP_OUT_PS_ULC_RSVD1 0xC0000000
#define BF_PXP_OUT_PS_ULC_RSVD1(v) \
        (((v) << 30) & BM_PXP_OUT_PS_ULC_RSVD1)
#define BP_PXP_OUT_PS_ULC_X      16
#define BM_PXP_OUT_PS_ULC_X 0x3FFF0000
#define BF_PXP_OUT_PS_ULC_X(v)  \
        (((v) << 16) & BM_PXP_OUT_PS_ULC_X)
#define BP_PXP_OUT_PS_ULC_RSVD0      14
#define BM_PXP_OUT_PS_ULC_RSVD0 0x0000C000
#define BF_PXP_OUT_PS_ULC_RSVD0(v)  \
        (((v) << 14) & BM_PXP_OUT_PS_ULC_RSVD0)
#define BP_PXP_OUT_PS_ULC_Y      0
#define BM_PXP_OUT_PS_ULC_Y 0x00003FFF
#define BF_PXP_OUT_PS_ULC_Y(v)  \
        (((v) << 0) & BM_PXP_OUT_PS_ULC_Y)

#define HW_PXP_OUT_PS_LRC	(0x00000080)

#define BP_PXP_OUT_PS_LRC_RSVD1      30
#define BM_PXP_OUT_PS_LRC_RSVD1 0xC0000000
#define BF_PXP_OUT_PS_LRC_RSVD1(v) \
        (((v) << 30) & BM_PXP_OUT_PS_LRC_RSVD1)
#define BP_PXP_OUT_PS_LRC_X      16
#define BM_PXP_OUT_PS_LRC_X 0x3FFF0000
#define BF_PXP_OUT_PS_LRC_X(v)  \
        (((v) << 16) & BM_PXP_OUT_PS_LRC_X)
#define BP_PXP_OUT_PS_LRC_RSVD0      14
#define BM_PXP_OUT_PS_LRC_RSVD0 0x0000C000
#define BF_PXP_OUT_PS_LRC_RSVD0(v)  \
        (((v) << 14) & BM_PXP_OUT_PS_LRC_RSVD0)
#define BP_PXP_OUT_PS_LRC_Y      0
#define BM_PXP_OUT_PS_LRC_Y 0x00003FFF
#define BF_PXP_OUT_PS_LRC_Y(v)  \
        (((v) << 0) & BM_PXP_OUT_PS_LRC_Y)

#define HW_PXP_OUT_AS_ULC	(0x00000090)

#define BP_PXP_OUT_AS_ULC_RSVD1      30
#define BM_PXP_OUT_AS_ULC_RSVD1 0xC0000000
#define BF_PXP_OUT_AS_ULC_RSVD1(v) \
        (((v) << 30) & BM_PXP_OUT_AS_ULC_RSVD1)
#define BP_PXP_OUT_AS_ULC_X      16
#define BM_PXP_OUT_AS_ULC_X 0x3FFF0000
#define BF_PXP_OUT_AS_ULC_X(v)  \
        (((v) << 16) & BM_PXP_OUT_AS_ULC_X)
#define BP_PXP_OUT_AS_ULC_RSVD0      14
#define BM_PXP_OUT_AS_ULC_RSVD0 0x0000C000
#define BF_PXP_OUT_AS_ULC_RSVD0(v)  \
        (((v) << 14) & BM_PXP_OUT_AS_ULC_RSVD0)
#define BP_PXP_OUT_AS_ULC_Y      0
#define BM_PXP_OUT_AS_ULC_Y 0x00003FFF
#define BF_PXP_OUT_AS_ULC_Y(v)  \
        (((v) << 0) & BM_PXP_OUT_AS_ULC_Y)

#define HW_PXP_OUT_AS_LRC	(0x000000a0)

#define BP_PXP_OUT_AS_LRC_RSVD1      30
#define BM_PXP_OUT_AS_LRC_RSVD1 0xC0000000
#define BF_PXP_OUT_AS_LRC_RSVD1(v) \
        (((v) << 30) & BM_PXP_OUT_AS_LRC_RSVD1)
#define BP_PXP_OUT_AS_LRC_X      16
#define BM_PXP_OUT_AS_LRC_X 0x3FFF0000
#define BF_PXP_OUT_AS_LRC_X(v)  \
        (((v) << 16) & BM_PXP_OUT_AS_LRC_X)
#define BP_PXP_OUT_AS_LRC_RSVD0      14
#define BM_PXP_OUT_AS_LRC_RSVD0 0x0000C000
#define BF_PXP_OUT_AS_LRC_RSVD0(v)  \
        (((v) << 14) & BM_PXP_OUT_AS_LRC_RSVD0)
#define BP_PXP_OUT_AS_LRC_Y      0
#define BM_PXP_OUT_AS_LRC_Y 0x00003FFF
#define BF_PXP_OUT_AS_LRC_Y(v)  \
        (((v) << 0) & BM_PXP_OUT_AS_LRC_Y)

#define HW_PXP_PS_CTRL	(0x000000b0)
#define HW_PXP_PS_CTRL_SET	(0x000000b4)
#define HW_PXP_PS_CTRL_CLR	(0x000000b8)
#define HW_PXP_PS_CTRL_TOG	(0x000000bc)

#define BP_PXP_PS_CTRL_RSVD1      12
#define BM_PXP_PS_CTRL_RSVD1 0xFFFFF000
#define BF_PXP_PS_CTRL_RSVD1(v) \
        (((v) << 12) & BM_PXP_PS_CTRL_RSVD1)
#define BP_PXP_PS_CTRL_DECX      10
#define BM_PXP_PS_CTRL_DECX 0x00000C00
#define BF_PXP_PS_CTRL_DECX(v)  \
        (((v) << 10) & BM_PXP_PS_CTRL_DECX)
#define BV_PXP_PS_CTRL_DECX__DISABLE 0x0
#define BV_PXP_PS_CTRL_DECX__DECX2   0x1
#define BV_PXP_PS_CTRL_DECX__DECX4   0x2
#define BV_PXP_PS_CTRL_DECX__DECX8   0x3
#define BP_PXP_PS_CTRL_DECY      8
#define BM_PXP_PS_CTRL_DECY 0x00000300
#define BF_PXP_PS_CTRL_DECY(v)  \
        (((v) << 8) & BM_PXP_PS_CTRL_DECY)
#define BV_PXP_PS_CTRL_DECY__DISABLE 0x0
#define BV_PXP_PS_CTRL_DECY__DECY2   0x1
#define BV_PXP_PS_CTRL_DECY__DECY4   0x2
#define BV_PXP_PS_CTRL_DECY__DECY8   0x3
#define BM_PXP_PS_CTRL_RSVD0 0x00000080
#define BF_PXP_PS_CTRL_RSVD0(v)  \
        (((v) << 7) & BM_PXP_PS_CTRL_RSVD0)
#define BM_PXP_PS_CTRL_WB_SWAP 0x00000040
#define BF_PXP_PS_CTRL_WB_SWAP(v)  \
        (((v) << 6) & BM_PXP_PS_CTRL_WB_SWAP)
#define BP_PXP_PS_CTRL_FORMAT      0
#define BM_PXP_PS_CTRL_FORMAT 0x0000003F
#define BF_PXP_PS_CTRL_FORMAT(v)  \
        (((v) << 0) & BM_PXP_PS_CTRL_FORMAT)
#define BV_PXP_PS_CTRL_FORMAT__RGB888    0x4
#define BV_PXP_PS_CTRL_FORMAT__RGB555    0xC
#define BV_PXP_PS_CTRL_FORMAT__RGB444    0xD
#define BV_PXP_PS_CTRL_FORMAT__RGB565    0xE
#define BV_PXP_PS_CTRL_FORMAT__YUV1P444  0x10
#define BV_PXP_PS_CTRL_FORMAT__UYVY1P422 0x12
#define BV_PXP_PS_CTRL_FORMAT__VYUY1P422 0x13
#define BV_PXP_PS_CTRL_FORMAT__Y8        0x14
#define BV_PXP_PS_CTRL_FORMAT__Y4        0x15
#define BV_PXP_PS_CTRL_FORMAT__YUV2P422  0x18
#define BV_PXP_PS_CTRL_FORMAT__YUV2P420  0x19
#define BV_PXP_PS_CTRL_FORMAT__YVU2P422  0x1A
#define BV_PXP_PS_CTRL_FORMAT__YVU2P420  0x1B
#define BV_PXP_PS_CTRL_FORMAT__YUV422    0x1E
#define BV_PXP_PS_CTRL_FORMAT__YUV420    0x1F
#define BV_PXP_PS_CTRL_FORMAT__RGBA888	 0x24

#define HW_PXP_PS_BUF	(0x000000c0)

#define BP_PXP_PS_BUF_ADDR      0
#define BM_PXP_PS_BUF_ADDR 0xFFFFFFFF
#define BF_PXP_PS_BUF_ADDR(v)   (v)

#define HW_PXP_PS_UBUF	(0x000000d0)

#define BP_PXP_PS_UBUF_ADDR      0
#define BM_PXP_PS_UBUF_ADDR 0xFFFFFFFF
#define BF_PXP_PS_UBUF_ADDR(v)   (v)

#define HW_PXP_PS_VBUF	(0x000000e0)

#define BP_PXP_PS_VBUF_ADDR      0
#define BM_PXP_PS_VBUF_ADDR 0xFFFFFFFF
#define BF_PXP_PS_VBUF_ADDR(v)   (v)

#define HW_PXP_PS_PITCH	(0x000000f0)

#define BP_PXP_PS_PITCH_RSVD      16
#define BM_PXP_PS_PITCH_RSVD 0xFFFF0000
#define BF_PXP_PS_PITCH_RSVD(v) \
        (((v) << 16) & BM_PXP_PS_PITCH_RSVD)
#define BP_PXP_PS_PITCH_PITCH      0
#define BM_PXP_PS_PITCH_PITCH 0x0000FFFF
#define BF_PXP_PS_PITCH_PITCH(v)  \
        (((v) << 0) & BM_PXP_PS_PITCH_PITCH)

#define HW_PXP_PS_BACKGROUND_0	(0x00000100)

#define BP_PXP_PS_BACKGROUND_0_RSVD      24
#define BM_PXP_PS_BACKGROUND_0_RSVD 0xFF000000
#define BF_PXP_PS_BACKGROUND_0_RSVD(v) \
        (((v) << 24) & BM_PXP_PS_BACKGROUND_0_RSVD)
#define BP_PXP_PS_BACKGROUND_0_COLOR      0
#define BM_PXP_PS_BACKGROUND_0_COLOR 0x00FFFFFF
#define BF_PXP_PS_BACKGROUND_0_COLOR(v)  \
        (((v) << 0) & BM_PXP_PS_BACKGROUND_0_COLOR)

#define HW_PXP_PS_SCALE	(0x00000110)

#define BM_PXP_PS_SCALE_RSVD2 0x80000000
#define BF_PXP_PS_SCALE_RSVD2(v) \
        (((v) << 31) & BM_PXP_PS_SCALE_RSVD2)
#define BP_PXP_PS_SCALE_YSCALE      16
#define BM_PXP_PS_SCALE_YSCALE 0x7FFF0000
#define BF_PXP_PS_SCALE_YSCALE(v)  \
        (((v) << 16) & BM_PXP_PS_SCALE_YSCALE)
#define BM_PXP_PS_SCALE_RSVD1 0x00008000
#define BF_PXP_PS_SCALE_RSVD1(v)  \
        (((v) << 15) & BM_PXP_PS_SCALE_RSVD1)
#define BP_PXP_PS_SCALE_XSCALE      0
#define BM_PXP_PS_SCALE_XSCALE 0x00007FFF
#define BF_PXP_PS_SCALE_XSCALE(v)  \
        (((v) << 0) & BM_PXP_PS_SCALE_XSCALE)

#define BP_PXP_PS_SCALE_OFFSET	12

#define HW_PXP_PS_OFFSET	(0x00000120)

#define BP_PXP_PS_OFFSET_RSVD2      28
#define BM_PXP_PS_OFFSET_RSVD2 0xF0000000
#define BF_PXP_PS_OFFSET_RSVD2(v) \
        (((v) << 28) & BM_PXP_PS_OFFSET_RSVD2)
#define BP_PXP_PS_OFFSET_YOFFSET      16
#define BM_PXP_PS_OFFSET_YOFFSET 0x0FFF0000
#define BF_PXP_PS_OFFSET_YOFFSET(v)  \
        (((v) << 16) & BM_PXP_PS_OFFSET_YOFFSET)
#define BP_PXP_PS_OFFSET_RSVD1      12
#define BM_PXP_PS_OFFSET_RSVD1 0x0000F000
#define BF_PXP_PS_OFFSET_RSVD1(v)  \
        (((v) << 12) & BM_PXP_PS_OFFSET_RSVD1)
#define BP_PXP_PS_OFFSET_XOFFSET      0
#define BM_PXP_PS_OFFSET_XOFFSET 0x00000FFF
#define BF_PXP_PS_OFFSET_XOFFSET(v)  \
        (((v) << 0) & BM_PXP_PS_OFFSET_XOFFSET)

#define HW_PXP_PS_CLRKEYLOW_0	(0x00000130)

#define BP_PXP_PS_CLRKEYLOW_0_RSVD1      24
#define BM_PXP_PS_CLRKEYLOW_0_RSVD1 0xFF000000
#define BF_PXP_PS_CLRKEYLOW_0_RSVD1(v) \
        (((v) << 24) & BM_PXP_PS_CLRKEYLOW_0_RSVD1)
#define BP_PXP_PS_CLRKEYLOW_0_PIXEL      0
#define BM_PXP_PS_CLRKEYLOW_0_PIXEL 0x00FFFFFF
#define BF_PXP_PS_CLRKEYLOW_0_PIXEL(v)  \
        (((v) << 0) & BM_PXP_PS_CLRKEYLOW_0_PIXEL)

#define HW_PXP_PS_CLRKEYHIGH_0	(0x00000140)

#define BP_PXP_PS_CLRKEYHIGH_0_RSVD1      24
#define BM_PXP_PS_CLRKEYHIGH_0_RSVD1 0xFF000000
#define BF_PXP_PS_CLRKEYHIGH_0_RSVD1(v) \
        (((v) << 24) & BM_PXP_PS_CLRKEYHIGH_0_RSVD1)
#define BP_PXP_PS_CLRKEYHIGH_0_PIXEL      0
#define BM_PXP_PS_CLRKEYHIGH_0_PIXEL 0x00FFFFFF
#define BF_PXP_PS_CLRKEYHIGH_0_PIXEL(v)  \
        (((v) << 0) & BM_PXP_PS_CLRKEYHIGH_0_PIXEL)

#define HW_PXP_AS_CTRL	(0x00000150)

#define BP_PXP_AS_CTRL_RSVD1      22
#define BM_PXP_AS_CTRL_RSVD1 0xFFC00000
#define BF_PXP_AS_CTRL_RSVD1(v) \
        (((v) << 22) & BM_PXP_AS_CTRL_RSVD1)
#define BM_PXP_AS_CTRL_ALPHA1_INVERT 0x00200000
#define BF_PXP_AS_CTRL_ALPHA1_INVERT(v)  \
        (((v) << 21) & BM_PXP_AS_CTRL_ALPHA1_INVERT)
#define BM_PXP_AS_CTRL_ALPHA0_INVERT 0x00100000
#define BF_PXP_AS_CTRL_ALPHA0_INVERT(v)  \
        (((v) << 20) & BM_PXP_AS_CTRL_ALPHA0_INVERT)
#define BP_PXP_AS_CTRL_ROP      16
#define BM_PXP_AS_CTRL_ROP 0x000F0000
#define BF_PXP_AS_CTRL_ROP(v)  \
        (((v) << 16) & BM_PXP_AS_CTRL_ROP)
#define BV_PXP_AS_CTRL_ROP__MASKAS     0x0
#define BV_PXP_AS_CTRL_ROP__MASKNOTAS  0x1
#define BV_PXP_AS_CTRL_ROP__MASKASNOT  0x2
#define BV_PXP_AS_CTRL_ROP__MERGEAS    0x3
#define BV_PXP_AS_CTRL_ROP__MERGENOTAS 0x4
#define BV_PXP_AS_CTRL_ROP__MERGEASNOT 0x5
#define BV_PXP_AS_CTRL_ROP__NOTCOPYAS  0x6
#define BV_PXP_AS_CTRL_ROP__NOT        0x7
#define BV_PXP_AS_CTRL_ROP__NOTMASKAS  0x8
#define BV_PXP_AS_CTRL_ROP__NOTMERGEAS 0x9
#define BV_PXP_AS_CTRL_ROP__XORAS      0xA
#define BV_PXP_AS_CTRL_ROP__NOTXORAS   0xB
#define BP_PXP_AS_CTRL_ALPHA      8
#define BM_PXP_AS_CTRL_ALPHA 0x0000FF00
#define BF_PXP_AS_CTRL_ALPHA(v)  \
        (((v) << 8) & BM_PXP_AS_CTRL_ALPHA)
#define BP_PXP_AS_CTRL_FORMAT      4
#define BM_PXP_AS_CTRL_FORMAT 0x000000F0
#define BF_PXP_AS_CTRL_FORMAT(v)  \
        (((v) << 4) & BM_PXP_AS_CTRL_FORMAT)
#define BV_PXP_AS_CTRL_FORMAT__ARGB8888 0x0
#define BV_PXP_AS_CTRL_FORMAT__RGBA8888 0x1
#define BV_PXP_AS_CTRL_FORMAT__RGB888   0x4
#define BV_PXP_AS_CTRL_FORMAT__ARGB1555 0x8
#define BV_PXP_AS_CTRL_FORMAT__ARGB4444 0x9
#define BV_PXP_AS_CTRL_FORMAT__RGBA5551 0xA
#define BV_PXP_AS_CTRL_FORMAT__RGBA4444 0xB
#define BV_PXP_AS_CTRL_FORMAT__RGB555   0xC
#define BV_PXP_AS_CTRL_FORMAT__RGB444   0xD
#define BV_PXP_AS_CTRL_FORMAT__RGB565   0xE
#define BM_PXP_AS_CTRL_ENABLE_COLORKEY 0x00000008
#define BF_PXP_AS_CTRL_ENABLE_COLORKEY(v)  \
        (((v) << 3) & BM_PXP_AS_CTRL_ENABLE_COLORKEY)
#define BP_PXP_AS_CTRL_ALPHA_CTRL      1
#define BM_PXP_AS_CTRL_ALPHA_CTRL 0x00000006
#define BF_PXP_AS_CTRL_ALPHA_CTRL(v)  \
        (((v) << 1) & BM_PXP_AS_CTRL_ALPHA_CTRL)
#define BV_PXP_AS_CTRL_ALPHA_CTRL__Embedded 0x0
#define BV_PXP_AS_CTRL_ALPHA_CTRL__Override 0x1
#define BV_PXP_AS_CTRL_ALPHA_CTRL__Multiply 0x2
#define BV_PXP_AS_CTRL_ALPHA_CTRL__ROPs     0x3
#define BM_PXP_AS_CTRL_RSVD0 0x00000001
#define BF_PXP_AS_CTRL_RSVD0(v)  \
        (((v) << 0) & BM_PXP_AS_CTRL_RSVD0)

#define HW_PXP_AS_BUF	(0x00000160)

#define BP_PXP_AS_BUF_ADDR      0
#define BM_PXP_AS_BUF_ADDR 0xFFFFFFFF
#define BF_PXP_AS_BUF_ADDR(v)   (v)

#define HW_PXP_AS_PITCH	(0x00000170)

#define BP_PXP_AS_PITCH_RSVD      16
#define BM_PXP_AS_PITCH_RSVD 0xFFFF0000
#define BF_PXP_AS_PITCH_RSVD(v) \
        (((v) << 16) & BM_PXP_AS_PITCH_RSVD)
#define BP_PXP_AS_PITCH_PITCH      0
#define BM_PXP_AS_PITCH_PITCH 0x0000FFFF
#define BF_PXP_AS_PITCH_PITCH(v)  \
        (((v) << 0) & BM_PXP_AS_PITCH_PITCH)

#define HW_PXP_AS_CLRKEYLOW_0	(0x00000180)

#define BP_PXP_AS_CLRKEYLOW_0_RSVD1      24
#define BM_PXP_AS_CLRKEYLOW_0_RSVD1 0xFF000000
#define BF_PXP_AS_CLRKEYLOW_0_RSVD1(v) \
        (((v) << 24) & BM_PXP_AS_CLRKEYLOW_0_RSVD1)
#define BP_PXP_AS_CLRKEYLOW_0_PIXEL      0
#define BM_PXP_AS_CLRKEYLOW_0_PIXEL 0x00FFFFFF
#define BF_PXP_AS_CLRKEYLOW_0_PIXEL(v)  \
        (((v) << 0) & BM_PXP_AS_CLRKEYLOW_0_PIXEL)

#define HW_PXP_AS_CLRKEYHIGH_0	(0x00000190)

#define BP_PXP_AS_CLRKEYHIGH_0_RSVD1      24
#define BM_PXP_AS_CLRKEYHIGH_0_RSVD1 0xFF000000
#define BF_PXP_AS_CLRKEYHIGH_0_RSVD1(v) \
        (((v) << 24) & BM_PXP_AS_CLRKEYHIGH_0_RSVD1)
#define BP_PXP_AS_CLRKEYHIGH_0_PIXEL      0
#define BM_PXP_AS_CLRKEYHIGH_0_PIXEL 0x00FFFFFF
#define BF_PXP_AS_CLRKEYHIGH_0_PIXEL(v)  \
        (((v) << 0) & BM_PXP_AS_CLRKEYHIGH_0_PIXEL)

#define HW_PXP_CSC1_COEF0	(0x000001a0)

#define BM_PXP_CSC1_COEF0_YCBCR_MODE 0x80000000
#define BF_PXP_CSC1_COEF0_YCBCR_MODE(v) \
        (((v) << 31) & BM_PXP_CSC1_COEF0_YCBCR_MODE)
#define BM_PXP_CSC1_COEF0_BYPASS 0x40000000
#define BF_PXP_CSC1_COEF0_BYPASS(v)  \
        (((v) << 30) & BM_PXP_CSC1_COEF0_BYPASS)
#define BM_PXP_CSC1_COEF0_RSVD1 0x20000000
#define BF_PXP_CSC1_COEF0_RSVD1(v)  \
        (((v) << 29) & BM_PXP_CSC1_COEF0_RSVD1)
#define BP_PXP_CSC1_COEF0_C0      18
#define BM_PXP_CSC1_COEF0_C0 0x1FFC0000
#define BF_PXP_CSC1_COEF0_C0(v)  \
        (((v) << 18) & BM_PXP_CSC1_COEF0_C0)
#define BP_PXP_CSC1_COEF0_UV_OFFSET      9
#define BM_PXP_CSC1_COEF0_UV_OFFSET 0x0003FE00
#define BF_PXP_CSC1_COEF0_UV_OFFSET(v)  \
        (((v) << 9) & BM_PXP_CSC1_COEF0_UV_OFFSET)
#define BP_PXP_CSC1_COEF0_Y_OFFSET      0
#define BM_PXP_CSC1_COEF0_Y_OFFSET 0x000001FF
#define BF_PXP_CSC1_COEF0_Y_OFFSET(v)  \
        (((v) << 0) & BM_PXP_CSC1_COEF0_Y_OFFSET)

#define HW_PXP_CSC1_COEF1	(0x000001b0)

#define BP_PXP_CSC1_COEF1_RSVD1      27
#define BM_PXP_CSC1_COEF1_RSVD1 0xF8000000
#define BF_PXP_CSC1_COEF1_RSVD1(v) \
        (((v) << 27) & BM_PXP_CSC1_COEF1_RSVD1)
#define BP_PXP_CSC1_COEF1_C1      16
#define BM_PXP_CSC1_COEF1_C1 0x07FF0000
#define BF_PXP_CSC1_COEF1_C1(v)  \
        (((v) << 16) & BM_PXP_CSC1_COEF1_C1)
#define BP_PXP_CSC1_COEF1_RSVD0      11
#define BM_PXP_CSC1_COEF1_RSVD0 0x0000F800
#define BF_PXP_CSC1_COEF1_RSVD0(v)  \
        (((v) << 11) & BM_PXP_CSC1_COEF1_RSVD0)
#define BP_PXP_CSC1_COEF1_C4      0
#define BM_PXP_CSC1_COEF1_C4 0x000007FF
#define BF_PXP_CSC1_COEF1_C4(v)  \
        (((v) << 0) & BM_PXP_CSC1_COEF1_C4)

#define HW_PXP_CSC1_COEF2	(0x000001c0)

#define BP_PXP_CSC1_COEF2_RSVD1      27
#define BM_PXP_CSC1_COEF2_RSVD1 0xF8000000
#define BF_PXP_CSC1_COEF2_RSVD1(v) \
        (((v) << 27) & BM_PXP_CSC1_COEF2_RSVD1)
#define BP_PXP_CSC1_COEF2_C2      16
#define BM_PXP_CSC1_COEF2_C2 0x07FF0000
#define BF_PXP_CSC1_COEF2_C2(v)  \
        (((v) << 16) & BM_PXP_CSC1_COEF2_C2)
#define BP_PXP_CSC1_COEF2_RSVD0      11
#define BM_PXP_CSC1_COEF2_RSVD0 0x0000F800
#define BF_PXP_CSC1_COEF2_RSVD0(v)  \
        (((v) << 11) & BM_PXP_CSC1_COEF2_RSVD0)
#define BP_PXP_CSC1_COEF2_C3      0
#define BM_PXP_CSC1_COEF2_C3 0x000007FF
#define BF_PXP_CSC1_COEF2_C3(v)  \
        (((v) << 0) & BM_PXP_CSC1_COEF2_C3)

#define HW_PXP_CSC2_CTRL	(0x000001d0)

#define BP_PXP_CSC2_CTRL_RSVD      3
#define BM_PXP_CSC2_CTRL_RSVD 0xFFFFFFF8
#define BF_PXP_CSC2_CTRL_RSVD(v) \
        (((v) << 3) & BM_PXP_CSC2_CTRL_RSVD)
#define BP_PXP_CSC2_CTRL_CSC_MODE      1
#define BM_PXP_CSC2_CTRL_CSC_MODE 0x00000006
#define BF_PXP_CSC2_CTRL_CSC_MODE(v)  \
        (((v) << 1) & BM_PXP_CSC2_CTRL_CSC_MODE)
#define BV_PXP_CSC2_CTRL_CSC_MODE__YUV2RGB   0x0
#define BV_PXP_CSC2_CTRL_CSC_MODE__YCbCr2RGB 0x1
#define BV_PXP_CSC2_CTRL_CSC_MODE__RGB2YUV   0x2
#define BV_PXP_CSC2_CTRL_CSC_MODE__RGB2YCbCr 0x3
#define BM_PXP_CSC2_CTRL_BYPASS 0x00000001
#define BF_PXP_CSC2_CTRL_BYPASS(v)  \
        (((v) << 0) & BM_PXP_CSC2_CTRL_BYPASS)

#define HW_PXP_CSC2_COEF0	(0x000001e0)

#define BP_PXP_CSC2_COEF0_RSVD1      27
#define BM_PXP_CSC2_COEF0_RSVD1 0xF8000000
#define BF_PXP_CSC2_COEF0_RSVD1(v) \
        (((v) << 27) & BM_PXP_CSC2_COEF0_RSVD1)
#define BP_PXP_CSC2_COEF0_A2      16
#define BM_PXP_CSC2_COEF0_A2 0x07FF0000
#define BF_PXP_CSC2_COEF0_A2(v)  \
        (((v) << 16) & BM_PXP_CSC2_COEF0_A2)
#define BP_PXP_CSC2_COEF0_RSVD0      11
#define BM_PXP_CSC2_COEF0_RSVD0 0x0000F800
#define BF_PXP_CSC2_COEF0_RSVD0(v)  \
        (((v) << 11) & BM_PXP_CSC2_COEF0_RSVD0)
#define BP_PXP_CSC2_COEF0_A1      0
#define BM_PXP_CSC2_COEF0_A1 0x000007FF
#define BF_PXP_CSC2_COEF0_A1(v)  \
        (((v) << 0) & BM_PXP_CSC2_COEF0_A1)

#define HW_PXP_CSC2_COEF1	(0x000001f0)

#define BP_PXP_CSC2_COEF1_RSVD1      27
#define BM_PXP_CSC2_COEF1_RSVD1 0xF8000000
#define BF_PXP_CSC2_COEF1_RSVD1(v) \
        (((v) << 27) & BM_PXP_CSC2_COEF1_RSVD1)
#define BP_PXP_CSC2_COEF1_B1      16
#define BM_PXP_CSC2_COEF1_B1 0x07FF0000
#define BF_PXP_CSC2_COEF1_B1(v)  \
        (((v) << 16) & BM_PXP_CSC2_COEF1_B1)
#define BP_PXP_CSC2_COEF1_RSVD0      11
#define BM_PXP_CSC2_COEF1_RSVD0 0x0000F800
#define BF_PXP_CSC2_COEF1_RSVD0(v)  \
        (((v) << 11) & BM_PXP_CSC2_COEF1_RSVD0)
#define BP_PXP_CSC2_COEF1_A3      0
#define BM_PXP_CSC2_COEF1_A3 0x000007FF
#define BF_PXP_CSC2_COEF1_A3(v)  \
        (((v) << 0) & BM_PXP_CSC2_COEF1_A3)

#define HW_PXP_CSC2_COEF2	(0x00000200)

#define BP_PXP_CSC2_COEF2_RSVD1      27
#define BM_PXP_CSC2_COEF2_RSVD1 0xF8000000
#define BF_PXP_CSC2_COEF2_RSVD1(v) \
        (((v) << 27) & BM_PXP_CSC2_COEF2_RSVD1)
#define BP_PXP_CSC2_COEF2_B3      16
#define BM_PXP_CSC2_COEF2_B3 0x07FF0000
#define BF_PXP_CSC2_COEF2_B3(v)  \
        (((v) << 16) & BM_PXP_CSC2_COEF2_B3)
#define BP_PXP_CSC2_COEF2_RSVD0      11
#define BM_PXP_CSC2_COEF2_RSVD0 0x0000F800
#define BF_PXP_CSC2_COEF2_RSVD0(v)  \
        (((v) << 11) & BM_PXP_CSC2_COEF2_RSVD0)
#define BP_PXP_CSC2_COEF2_B2      0
#define BM_PXP_CSC2_COEF2_B2 0x000007FF
#define BF_PXP_CSC2_COEF2_B2(v)  \
        (((v) << 0) & BM_PXP_CSC2_COEF2_B2)

#define HW_PXP_CSC2_COEF3	(0x00000210)

#define BP_PXP_CSC2_COEF3_RSVD1      27
#define BM_PXP_CSC2_COEF3_RSVD1 0xF8000000
#define BF_PXP_CSC2_COEF3_RSVD1(v) \
        (((v) << 27) & BM_PXP_CSC2_COEF3_RSVD1)
#define BP_PXP_CSC2_COEF3_C2      16
#define BM_PXP_CSC2_COEF3_C2 0x07FF0000
#define BF_PXP_CSC2_COEF3_C2(v)  \
        (((v) << 16) & BM_PXP_CSC2_COEF3_C2)
#define BP_PXP_CSC2_COEF3_RSVD0      11
#define BM_PXP_CSC2_COEF3_RSVD0 0x0000F800
#define BF_PXP_CSC2_COEF3_RSVD0(v)  \
        (((v) << 11) & BM_PXP_CSC2_COEF3_RSVD0)
#define BP_PXP_CSC2_COEF3_C1      0
#define BM_PXP_CSC2_COEF3_C1 0x000007FF
#define BF_PXP_CSC2_COEF3_C1(v)  \
        (((v) << 0) & BM_PXP_CSC2_COEF3_C1)

#define HW_PXP_CSC2_COEF4	(0x00000220)

#define BP_PXP_CSC2_COEF4_RSVD1      25
#define BM_PXP_CSC2_COEF4_RSVD1 0xFE000000
#define BF_PXP_CSC2_COEF4_RSVD1(v) \
        (((v) << 25) & BM_PXP_CSC2_COEF4_RSVD1)
#define BP_PXP_CSC2_COEF4_D1      16
#define BM_PXP_CSC2_COEF4_D1 0x01FF0000
#define BF_PXP_CSC2_COEF4_D1(v)  \
        (((v) << 16) & BM_PXP_CSC2_COEF4_D1)
#define BP_PXP_CSC2_COEF4_RSVD0      11
#define BM_PXP_CSC2_COEF4_RSVD0 0x0000F800
#define BF_PXP_CSC2_COEF4_RSVD0(v)  \
        (((v) << 11) & BM_PXP_CSC2_COEF4_RSVD0)
#define BP_PXP_CSC2_COEF4_C3      0
#define BM_PXP_CSC2_COEF4_C3 0x000007FF
#define BF_PXP_CSC2_COEF4_C3(v)  \
        (((v) << 0) & BM_PXP_CSC2_COEF4_C3)

#define HW_PXP_CSC2_COEF5	(0x00000230)

#define BP_PXP_CSC2_COEF5_RSVD1      25
#define BM_PXP_CSC2_COEF5_RSVD1 0xFE000000
#define BF_PXP_CSC2_COEF5_RSVD1(v) \
        (((v) << 25) & BM_PXP_CSC2_COEF5_RSVD1)
#define BP_PXP_CSC2_COEF5_D3      16
#define BM_PXP_CSC2_COEF5_D3 0x01FF0000
#define BF_PXP_CSC2_COEF5_D3(v)  \
        (((v) << 16) & BM_PXP_CSC2_COEF5_D3)
#define BP_PXP_CSC2_COEF5_RSVD0      9
#define BM_PXP_CSC2_COEF5_RSVD0 0x0000FE00
#define BF_PXP_CSC2_COEF5_RSVD0(v)  \
        (((v) << 9) & BM_PXP_CSC2_COEF5_RSVD0)
#define BP_PXP_CSC2_COEF5_D2      0
#define BM_PXP_CSC2_COEF5_D2 0x000001FF
#define BF_PXP_CSC2_COEF5_D2(v)  \
        (((v) << 0) & BM_PXP_CSC2_COEF5_D2)

#define HW_PXP_LUT_CTRL	(0x00000240)

#define BM_PXP_LUT_CTRL_BYPASS 0x80000000
#define BF_PXP_LUT_CTRL_BYPASS(v) \
        (((v) << 31) & BM_PXP_LUT_CTRL_BYPASS)
#define BP_PXP_LUT_CTRL_RSVD3      26
#define BM_PXP_LUT_CTRL_RSVD3 0x7C000000
#define BF_PXP_LUT_CTRL_RSVD3(v)  \
        (((v) << 26) & BM_PXP_LUT_CTRL_RSVD3)
#define BP_PXP_LUT_CTRL_LOOKUP_MODE      24
#define BM_PXP_LUT_CTRL_LOOKUP_MODE 0x03000000
#define BF_PXP_LUT_CTRL_LOOKUP_MODE(v)  \
        (((v) << 24) & BM_PXP_LUT_CTRL_LOOKUP_MODE)
#define BV_PXP_LUT_CTRL_LOOKUP_MODE__CACHE_RGB565  0x0
#define BV_PXP_LUT_CTRL_LOOKUP_MODE__DIRECT_Y8     0x1
#define BV_PXP_LUT_CTRL_LOOKUP_MODE__DIRECT_RGB444 0x2
#define BV_PXP_LUT_CTRL_LOOKUP_MODE__DIRECT_RGB454 0x3
#define BP_PXP_LUT_CTRL_RSVD2      18
#define BM_PXP_LUT_CTRL_RSVD2 0x00FC0000
#define BF_PXP_LUT_CTRL_RSVD2(v)  \
        (((v) << 18) & BM_PXP_LUT_CTRL_RSVD2)
#define BP_PXP_LUT_CTRL_OUT_MODE      16
#define BM_PXP_LUT_CTRL_OUT_MODE 0x00030000
#define BF_PXP_LUT_CTRL_OUT_MODE(v)  \
        (((v) << 16) & BM_PXP_LUT_CTRL_OUT_MODE)
#define BV_PXP_LUT_CTRL_OUT_MODE__RESERVED    0x0
#define BV_PXP_LUT_CTRL_OUT_MODE__Y8          0x1
#define BV_PXP_LUT_CTRL_OUT_MODE__RGBW4444CFA 0x2
#define BV_PXP_LUT_CTRL_OUT_MODE__RGB888      0x3
#define BP_PXP_LUT_CTRL_RSVD1      11
#define BM_PXP_LUT_CTRL_RSVD1 0x0000F800
#define BF_PXP_LUT_CTRL_RSVD1(v)  \
        (((v) << 11) & BM_PXP_LUT_CTRL_RSVD1)
#define BM_PXP_LUT_CTRL_SEL_8KB 0x00000400
#define BF_PXP_LUT_CTRL_SEL_8KB(v)  \
        (((v) << 10) & BM_PXP_LUT_CTRL_SEL_8KB)
#define BM_PXP_LUT_CTRL_LRU_UPD 0x00000200
#define BF_PXP_LUT_CTRL_LRU_UPD(v)  \
        (((v) << 9) & BM_PXP_LUT_CTRL_LRU_UPD)
#define BM_PXP_LUT_CTRL_INVALID 0x00000100
#define BF_PXP_LUT_CTRL_INVALID(v)  \
        (((v) << 8) & BM_PXP_LUT_CTRL_INVALID)
#define BP_PXP_LUT_CTRL_RSVD0      1
#define BM_PXP_LUT_CTRL_RSVD0 0x000000FE
#define BF_PXP_LUT_CTRL_RSVD0(v)  \
        (((v) << 1) & BM_PXP_LUT_CTRL_RSVD0)
#define BM_PXP_LUT_CTRL_DMA_START 0x00000001
#define BF_PXP_LUT_CTRL_DMA_START(v)  \
        (((v) << 0) & BM_PXP_LUT_CTRL_DMA_START)

#define HW_PXP_LUT_ADDR	(0x00000250)

#define BM_PXP_LUT_ADDR_RSVD2 0x80000000
#define BF_PXP_LUT_ADDR_RSVD2(v) \
        (((v) << 31) & BM_PXP_LUT_ADDR_RSVD2)
#define BP_PXP_LUT_ADDR_NUM_BYTES      16
#define BM_PXP_LUT_ADDR_NUM_BYTES 0x7FFF0000
#define BF_PXP_LUT_ADDR_NUM_BYTES(v)  \
        (((v) << 16) & BM_PXP_LUT_ADDR_NUM_BYTES)
#define BP_PXP_LUT_ADDR_RSVD1      14
#define BM_PXP_LUT_ADDR_RSVD1 0x0000C000
#define BF_PXP_LUT_ADDR_RSVD1(v)  \
        (((v) << 14) & BM_PXP_LUT_ADDR_RSVD1)
#define BP_PXP_LUT_ADDR_ADDR      0
#define BM_PXP_LUT_ADDR_ADDR 0x00003FFF
#define BF_PXP_LUT_ADDR_ADDR(v)  \
        (((v) << 0) & BM_PXP_LUT_ADDR_ADDR)

#define HW_PXP_LUT_DATA	(0x00000260)

#define BP_PXP_LUT_DATA_DATA      0
#define BM_PXP_LUT_DATA_DATA 0xFFFFFFFF
#define BF_PXP_LUT_DATA_DATA(v)   (v)

#define HW_PXP_LUT_EXTMEM	(0x00000270)

#define BP_PXP_LUT_EXTMEM_ADDR      0
#define BM_PXP_LUT_EXTMEM_ADDR 0xFFFFFFFF
#define BF_PXP_LUT_EXTMEM_ADDR(v)   (v)

#define HW_PXP_CFA	(0x00000280)

#define BP_PXP_CFA_DATA      0
#define BM_PXP_CFA_DATA 0xFFFFFFFF
#define BF_PXP_CFA_DATA(v)   (v)

#define HW_PXP_ALPHA_A_CTRL	(0x00000290)

#define BP_PXP_ALPHA_A_CTRL_S1_GLOBAL_ALPHA      24
#define BM_PXP_ALPHA_A_CTRL_S1_GLOBAL_ALPHA 0xFF000000
#define BF_PXP_ALPHA_A_CTRL_S1_GLOBAL_ALPHA(v) \
        (((v) << 24) & BM_PXP_ALPHA_A_CTRL_S1_GLOBAL_ALPHA)
#define BP_PXP_ALPHA_A_CTRL_S0_GLOBAL_ALPHA      16
#define BM_PXP_ALPHA_A_CTRL_S0_GLOBAL_ALPHA 0x00FF0000
#define BF_PXP_ALPHA_A_CTRL_S0_GLOBAL_ALPHA(v)  \
        (((v) << 16) & BM_PXP_ALPHA_A_CTRL_S0_GLOBAL_ALPHA)
#define BP_PXP_ALPHA_A_CTRL_RSVD0      14
#define BM_PXP_ALPHA_A_CTRL_RSVD0 0x0000C000
#define BF_PXP_ALPHA_A_CTRL_RSVD0(v)  \
        (((v) << 14) & BM_PXP_ALPHA_A_CTRL_RSVD0)
#define BM_PXP_ALPHA_A_CTRL_S1_COLOR_MODE 0x00002000
#define BF_PXP_ALPHA_A_CTRL_S1_COLOR_MODE(v)  \
        (((v) << 13) & BM_PXP_ALPHA_A_CTRL_S1_COLOR_MODE)
#define BV_PXP_ALPHA_A_CTRL_S1_COLOR_MODE__0 0x0
#define BV_PXP_ALPHA_A_CTRL_S1_COLOR_MODE__1 0x1
#define BM_PXP_ALPHA_A_CTRL_S1_ALPHA_MODE 0x00001000
#define BF_PXP_ALPHA_A_CTRL_S1_ALPHA_MODE(v)  \
        (((v) << 12) & BM_PXP_ALPHA_A_CTRL_S1_ALPHA_MODE)
#define BV_PXP_ALPHA_A_CTRL_S1_ALPHA_MODE__0 0x0
#define BV_PXP_ALPHA_A_CTRL_S1_ALPHA_MODE__1 0x1
#define BP_PXP_ALPHA_A_CTRL_S1_GLOBAL_ALPHA_MODE      10
#define BM_PXP_ALPHA_A_CTRL_S1_GLOBAL_ALPHA_MODE 0x00000C00
#define BF_PXP_ALPHA_A_CTRL_S1_GLOBAL_ALPHA_MODE(v)  \
        (((v) << 10) & BM_PXP_ALPHA_A_CTRL_S1_GLOBAL_ALPHA_MODE)
#define BV_PXP_ALPHA_A_CTRL_S1_GLOBAL_ALPHA_MODE__0 0x0
#define BV_PXP_ALPHA_A_CTRL_S1_GLOBAL_ALPHA_MODE__1 0x0
#define BV_PXP_ALPHA_A_CTRL_S1_GLOBAL_ALPHA_MODE__2 0x0
#define BV_PXP_ALPHA_A_CTRL_S1_GLOBAL_ALPHA_MODE__3 0x0
#define BP_PXP_ALPHA_A_CTRL_S1_S0_FACTOR_MODE      8
#define BM_PXP_ALPHA_A_CTRL_S1_S0_FACTOR_MODE 0x00000300
#define BF_PXP_ALPHA_A_CTRL_S1_S0_FACTOR_MODE(v)  \
        (((v) << 8) & BM_PXP_ALPHA_A_CTRL_S1_S0_FACTOR_MODE)
#define BV_PXP_ALPHA_A_CTRL_S1_S0_FACTOR_MODE__0 0x0
#define BV_PXP_ALPHA_A_CTRL_S1_S0_FACTOR_MODE__1 0x1
#define BV_PXP_ALPHA_A_CTRL_S1_S0_FACTOR_MODE__2 0x2
#define BV_PXP_ALPHA_A_CTRL_S1_S0_FACTOR_MODE__3 0x3
#define BM_PXP_ALPHA_A_CTRL_RSVD1 0x00000080
#define BF_PXP_ALPHA_A_CTRL_RSVD1(v)  \
        (((v) << 7) & BM_PXP_ALPHA_A_CTRL_RSVD1)
#define BM_PXP_ALPHA_A_CTRL_S0_COLOR_MODE 0x00000040
#define BF_PXP_ALPHA_A_CTRL_S0_COLOR_MODE(v)  \
        (((v) << 6) & BM_PXP_ALPHA_A_CTRL_S0_COLOR_MODE)
#define BV_PXP_ALPHA_A_CTRL_S0_COLOR_MODE__0 0x0
#define BV_PXP_ALPHA_A_CTRL_S0_COLOR_MODE__1 0x1
#define BM_PXP_ALPHA_A_CTRL_S0_ALPHA_MODE 0x00000020
#define BF_PXP_ALPHA_A_CTRL_S0_ALPHA_MODE(v)  \
        (((v) << 5) & BM_PXP_ALPHA_A_CTRL_S0_ALPHA_MODE)
#define BV_PXP_ALPHA_A_CTRL_S0_ALPHA_MODE__0 0x0
#define BV_PXP_ALPHA_A_CTRL_S0_ALPHA_MODE__1 0x1
#define BP_PXP_ALPHA_A_CTRL_S0_GLOBAL_ALPHA_MODE      3
#define BM_PXP_ALPHA_A_CTRL_S0_GLOBAL_ALPHA_MODE 0x00000018
#define BF_PXP_ALPHA_A_CTRL_S0_GLOBAL_ALPHA_MODE(v)  \
        (((v) << 3) & BM_PXP_ALPHA_A_CTRL_S0_GLOBAL_ALPHA_MODE)
#define BV_PXP_ALPHA_A_CTRL_S0_GLOBAL_ALPHA_MODE__0 0x0
#define BV_PXP_ALPHA_A_CTRL_S0_GLOBAL_ALPHA_MODE__1 0x1
#define BV_PXP_ALPHA_A_CTRL_S0_GLOBAL_ALPHA_MODE__2 0x2
#define BV_PXP_ALPHA_A_CTRL_S0_GLOBAL_ALPHA_MODE__3 0x3
#define BP_PXP_ALPHA_A_CTRL_S0_S1_FACTOR_MODE      1
#define BM_PXP_ALPHA_A_CTRL_S0_S1_FACTOR_MODE 0x00000006
#define BF_PXP_ALPHA_A_CTRL_S0_S1_FACTOR_MODE(v)  \
        (((v) << 1) & BM_PXP_ALPHA_A_CTRL_S0_S1_FACTOR_MODE)
#define BV_PXP_ALPHA_A_CTRL_S0_S1_FACTOR_MODE__0 0x0
#define BV_PXP_ALPHA_A_CTRL_S0_S1_FACTOR_MODE__1 0x1
#define BV_PXP_ALPHA_A_CTRL_S0_S1_FACTOR_MODE__2 0x2
#define BV_PXP_ALPHA_A_CTRL_S0_S1_FACTOR_MODE__3 0x3
#define BM_PXP_ALPHA_A_CTRL_POTER_DUFF_ENABLE 0x00000001
#define BF_PXP_ALPHA_A_CTRL_POTER_DUFF_ENABLE(v)  \
        (((v) << 0) & BM_PXP_ALPHA_A_CTRL_POTER_DUFF_ENABLE)
#define BV_PXP_ALPHA_A_CTRL_POTER_DUFF_ENABLE__0 0x0
#define BV_PXP_ALPHA_A_CTRL_POTER_DUFF_ENABLE__1 0x1

#define HW_PXP_ALPHA_B_CTRL	(0x000002a0)

#define BP_PXP_ALPHA_B_CTRL_S1_GLOBAL_ALPHA      24
#define BM_PXP_ALPHA_B_CTRL_S1_GLOBAL_ALPHA 0xFF000000
#define BF_PXP_ALPHA_B_CTRL_S1_GLOBAL_ALPHA(v) \
        (((v) << 24) & BM_PXP_ALPHA_B_CTRL_S1_GLOBAL_ALPHA)
#define BP_PXP_ALPHA_B_CTRL_S0_GLOBAL_ALPHA      16
#define BM_PXP_ALPHA_B_CTRL_S0_GLOBAL_ALPHA 0x00FF0000
#define BF_PXP_ALPHA_B_CTRL_S0_GLOBAL_ALPHA(v)  \
        (((v) << 16) & BM_PXP_ALPHA_B_CTRL_S0_GLOBAL_ALPHA)
#define BP_PXP_ALPHA_B_CTRL_RSVD0      14
#define BM_PXP_ALPHA_B_CTRL_RSVD0 0x0000C000
#define BF_PXP_ALPHA_B_CTRL_RSVD0(v)  \
        (((v) << 14) & BM_PXP_ALPHA_B_CTRL_RSVD0)
#define BM_PXP_ALPHA_B_CTRL_S1_COLOR_MODE 0x00002000
#define BF_PXP_ALPHA_B_CTRL_S1_COLOR_MODE(v)  \
        (((v) << 13) & BM_PXP_ALPHA_B_CTRL_S1_COLOR_MODE)
#define BV_PXP_ALPHA_B_CTRL_S1_COLOR_MODE__0 0x0
#define BV_PXP_ALPHA_B_CTRL_S1_COLOR_MODE__1 0x1
#define BM_PXP_ALPHA_B_CTRL_S1_ALPHA_MODE 0x00001000
#define BF_PXP_ALPHA_B_CTRL_S1_ALPHA_MODE(v)  \
        (((v) << 12) & BM_PXP_ALPHA_B_CTRL_S1_ALPHA_MODE)
#define BV_PXP_ALPHA_B_CTRL_S1_ALPHA_MODE__0 0x0
#define BV_PXP_ALPHA_B_CTRL_S1_ALPHA_MODE__1 0x1
#define BP_PXP_ALPHA_B_CTRL_S1_GLOBAL_ALPHA_MODE      10
#define BM_PXP_ALPHA_B_CTRL_S1_GLOBAL_ALPHA_MODE 0x00000C00
#define BF_PXP_ALPHA_B_CTRL_S1_GLOBAL_ALPHA_MODE(v)  \
        (((v) << 10) & BM_PXP_ALPHA_B_CTRL_S1_GLOBAL_ALPHA_MODE)
#define BV_PXP_ALPHA_B_CTRL_S1_GLOBAL_ALPHA_MODE__0 0x0
#define BV_PXP_ALPHA_B_CTRL_S1_GLOBAL_ALPHA_MODE__1 0x1
#define BV_PXP_ALPHA_B_CTRL_S1_GLOBAL_ALPHA_MODE__2 0x2
#define BV_PXP_ALPHA_B_CTRL_S1_GLOBAL_ALPHA_MODE__3 0x3
#define BP_PXP_ALPHA_B_CTRL_S1_S0_FACTOR_MODE      8
#define BM_PXP_ALPHA_B_CTRL_S1_S0_FACTOR_MODE 0x00000300
#define BF_PXP_ALPHA_B_CTRL_S1_S0_FACTOR_MODE(v)  \
        (((v) << 8) & BM_PXP_ALPHA_B_CTRL_S1_S0_FACTOR_MODE)
#define BV_PXP_ALPHA_B_CTRL_S1_S0_FACTOR_MODE__0 0x0
#define BV_PXP_ALPHA_B_CTRL_S1_S0_FACTOR_MODE__1 0x1
#define BV_PXP_ALPHA_B_CTRL_S1_S0_FACTOR_MODE__2 0x2
#define BV_PXP_ALPHA_B_CTRL_S1_S0_FACTOR_MODE__3 0x3
#define BM_PXP_ALPHA_B_CTRL_RSVD1 0x00000080
#define BF_PXP_ALPHA_B_CTRL_RSVD1(v)  \
        (((v) << 7) & BM_PXP_ALPHA_B_CTRL_RSVD1)
#define BM_PXP_ALPHA_B_CTRL_S0_COLOR_MODE 0x00000040
#define BF_PXP_ALPHA_B_CTRL_S0_COLOR_MODE(v)  \
        (((v) << 6) & BM_PXP_ALPHA_B_CTRL_S0_COLOR_MODE)
#define BV_PXP_ALPHA_B_CTRL_S0_COLOR_MODE__0 0x0
#define BV_PXP_ALPHA_B_CTRL_S0_COLOR_MODE__1 0x1
#define BM_PXP_ALPHA_B_CTRL_S0_ALPHA_MODE 0x00000020
#define BF_PXP_ALPHA_B_CTRL_S0_ALPHA_MODE(v)  \
        (((v) << 5) & BM_PXP_ALPHA_B_CTRL_S0_ALPHA_MODE)
#define BV_PXP_ALPHA_B_CTRL_S0_ALPHA_MODE__0 0x0
#define BV_PXP_ALPHA_B_CTRL_S0_ALPHA_MODE__1 0x1
#define BP_PXP_ALPHA_B_CTRL_S0_GLOBAL_ALPHA_MODE      3
#define BM_PXP_ALPHA_B_CTRL_S0_GLOBAL_ALPHA_MODE 0x00000018
#define BF_PXP_ALPHA_B_CTRL_S0_GLOBAL_ALPHA_MODE(v)  \
        (((v) << 3) & BM_PXP_ALPHA_B_CTRL_S0_GLOBAL_ALPHA_MODE)
#define BV_PXP_ALPHA_B_CTRL_S0_GLOBAL_ALPHA_MODE__0 0x0
#define BV_PXP_ALPHA_B_CTRL_S0_GLOBAL_ALPHA_MODE__1 0x1
#define BV_PXP_ALPHA_B_CTRL_S0_GLOBAL_ALPHA_MODE__2 0x2
#define BV_PXP_ALPHA_B_CTRL_S0_GLOBAL_ALPHA_MODE__3 0x3
#define BP_PXP_ALPHA_B_CTRL_S0_S1_FACTOR_MODE      1
#define BM_PXP_ALPHA_B_CTRL_S0_S1_FACTOR_MODE 0x00000006
#define BF_PXP_ALPHA_B_CTRL_S0_S1_FACTOR_MODE(v)  \
        (((v) << 1) & BM_PXP_ALPHA_B_CTRL_S0_S1_FACTOR_MODE)
#define BV_PXP_ALPHA_B_CTRL_S0_S1_FACTOR_MODE__0 0x0
#define BV_PXP_ALPHA_B_CTRL_S0_S1_FACTOR_MODE__1 0x1
#define BV_PXP_ALPHA_B_CTRL_S0_S1_FACTOR_MODE__2 0x2
#define BV_PXP_ALPHA_B_CTRL_S0_S1_FACTOR_MODE__3 0x3
#define BM_PXP_ALPHA_B_CTRL_POTER_DUFF_ENABLE 0x00000001
#define BF_PXP_ALPHA_B_CTRL_POTER_DUFF_ENABLE(v)  \
        (((v) << 0) & BM_PXP_ALPHA_B_CTRL_POTER_DUFF_ENABLE)
#define BV_PXP_ALPHA_B_CTRL_POTER_DUFF_ENABLE__0 0x0
#define BV_PXP_ALPHA_B_CTRL_POTER_DUFF_ENABLE__1 0x1

#define HW_PXP_ALPHA_B_CTRL_1	(0x000002b0)

#define BP_PXP_ALPHA_B_CTRL_1_RSVD0      8
#define BM_PXP_ALPHA_B_CTRL_1_RSVD0 0xFFFFFF00
#define BF_PXP_ALPHA_B_CTRL_1_RSVD0(v) \
        (((v) << 8) & BM_PXP_ALPHA_B_CTRL_1_RSVD0)
#define BP_PXP_ALPHA_B_CTRL_1_ROP      4
#define BM_PXP_ALPHA_B_CTRL_1_ROP 0x000000F0
#define BF_PXP_ALPHA_B_CTRL_1_ROP(v)  \
        (((v) << 4) & BM_PXP_ALPHA_B_CTRL_1_ROP)
#define BV_PXP_ALPHA_B_CTRL_1_ROP__MASKAS     0x0
#define BV_PXP_ALPHA_B_CTRL_1_ROP__MASKNOTAS  0x1
#define BV_PXP_ALPHA_B_CTRL_1_ROP__MASKASNOT  0x2
#define BV_PXP_ALPHA_B_CTRL_1_ROP__MERGEAS    0x3
#define BV_PXP_ALPHA_B_CTRL_1_ROP__MERGENOTAS 0x4
#define BV_PXP_ALPHA_B_CTRL_1_ROP__MERGEASNOT 0x5
#define BV_PXP_ALPHA_B_CTRL_1_ROP__NOTCOPYAS  0x6
#define BV_PXP_ALPHA_B_CTRL_1_ROP__NOT        0x7
#define BV_PXP_ALPHA_B_CTRL_1_ROP__NOTMASKAS  0x8
#define BV_PXP_ALPHA_B_CTRL_1_ROP__NOTMERGEAS 0x9
#define BV_PXP_ALPHA_B_CTRL_1_ROP__XORAS      0xA
#define BV_PXP_ALPHA_B_CTRL_1_ROP__NOTXORAS   0xB
#define BP_PXP_ALPHA_B_CTRL_1_RSVD1      2
#define BM_PXP_ALPHA_B_CTRL_1_RSVD1 0x0000000C
#define BF_PXP_ALPHA_B_CTRL_1_RSVD1(v)  \
        (((v) << 2) & BM_PXP_ALPHA_B_CTRL_1_RSVD1)
#define BM_PXP_ALPHA_B_CTRL_1_OL_CLRKEY_ENABLE 0x00000002
#define BF_PXP_ALPHA_B_CTRL_1_OL_CLRKEY_ENABLE(v)  \
        (((v) << 1) & BM_PXP_ALPHA_B_CTRL_1_OL_CLRKEY_ENABLE)
#define BM_PXP_ALPHA_B_CTRL_1_ROP_ENABLE 0x00000001
#define BF_PXP_ALPHA_B_CTRL_1_ROP_ENABLE(v)  \
        (((v) << 0) & BM_PXP_ALPHA_B_CTRL_1_ROP_ENABLE)

#define HW_PXP_PS_BACKGROUND_1	(0x000002c0)

#define BP_PXP_PS_BACKGROUND_1_RSVD      24
#define BM_PXP_PS_BACKGROUND_1_RSVD 0xFF000000
#define BF_PXP_PS_BACKGROUND_1_RSVD(v) \
        (((v) << 24) & BM_PXP_PS_BACKGROUND_1_RSVD)
#define BP_PXP_PS_BACKGROUND_1_COLOR      0
#define BM_PXP_PS_BACKGROUND_1_COLOR 0x00FFFFFF
#define BF_PXP_PS_BACKGROUND_1_COLOR(v)  \
        (((v) << 0) & BM_PXP_PS_BACKGROUND_1_COLOR)

#define HW_PXP_PS_CLRKEYLOW_1	(0x000002d0)

#define BP_PXP_PS_CLRKEYLOW_1_RSVD1      24
#define BM_PXP_PS_CLRKEYLOW_1_RSVD1 0xFF000000
#define BF_PXP_PS_CLRKEYLOW_1_RSVD1(v) \
        (((v) << 24) & BM_PXP_PS_CLRKEYLOW_1_RSVD1)
#define BP_PXP_PS_CLRKEYLOW_1_PIXEL      0
#define BM_PXP_PS_CLRKEYLOW_1_PIXEL 0x00FFFFFF
#define BF_PXP_PS_CLRKEYLOW_1_PIXEL(v)  \
        (((v) << 0) & BM_PXP_PS_CLRKEYLOW_1_PIXEL)

#define HW_PXP_PS_CLRKEYHIGH_1	(0x000002e0)

#define BP_PXP_PS_CLRKEYHIGH_1_RSVD1      24
#define BM_PXP_PS_CLRKEYHIGH_1_RSVD1 0xFF000000
#define BF_PXP_PS_CLRKEYHIGH_1_RSVD1(v) \
        (((v) << 24) & BM_PXP_PS_CLRKEYHIGH_1_RSVD1)
#define BP_PXP_PS_CLRKEYHIGH_1_PIXEL      0
#define BM_PXP_PS_CLRKEYHIGH_1_PIXEL 0x00FFFFFF
#define BF_PXP_PS_CLRKEYHIGH_1_PIXEL(v)  \
        (((v) << 0) & BM_PXP_PS_CLRKEYHIGH_1_PIXEL)

#define HW_PXP_AS_CLRKEYLOW_1	(0x000002f0)

#define BP_PXP_AS_CLRKEYLOW_1_RSVD1      24
#define BM_PXP_AS_CLRKEYLOW_1_RSVD1 0xFF000000
#define BF_PXP_AS_CLRKEYLOW_1_RSVD1(v) \
        (((v) << 24) & BM_PXP_AS_CLRKEYLOW_1_RSVD1)
#define BP_PXP_AS_CLRKEYLOW_1_PIXEL      0
#define BM_PXP_AS_CLRKEYLOW_1_PIXEL 0x00FFFFFF
#define BF_PXP_AS_CLRKEYLOW_1_PIXEL(v)  \
        (((v) << 0) & BM_PXP_AS_CLRKEYLOW_1_PIXEL)

#define HW_PXP_AS_CLRKEYHIGH_1	(0x00000300)

#define BP_PXP_AS_CLRKEYHIGH_1_RSVD1      24
#define BM_PXP_AS_CLRKEYHIGH_1_RSVD1 0xFF000000
#define BF_PXP_AS_CLRKEYHIGH_1_RSVD1(v) \
        (((v) << 24) & BM_PXP_AS_CLRKEYHIGH_1_RSVD1)
#define BP_PXP_AS_CLRKEYHIGH_1_PIXEL      0
#define BM_PXP_AS_CLRKEYHIGH_1_PIXEL 0x00FFFFFF
#define BF_PXP_AS_CLRKEYHIGH_1_PIXEL(v)  \
        (((v) << 0) & BM_PXP_AS_CLRKEYHIGH_1_PIXEL)

#define HW_PXP_CTRL2	(0x00000310)
#define HW_PXP_CTRL2_SET	(0x00000314)
#define HW_PXP_CTRL2_CLR	(0x00000318)
#define HW_PXP_CTRL2_TOG	(0x0000031c)

#define BP_PXP_CTRL2_RSVD3      28
#define BM_PXP_CTRL2_RSVD3 0xF0000000
#define BF_PXP_CTRL2_RSVD3(v) \
        (((v) << 28) & BM_PXP_CTRL2_RSVD3)
#define BM_PXP_CTRL2_ENABLE_ROTATE1 0x08000000
#define BF_PXP_CTRL2_ENABLE_ROTATE1(v)  \
        (((v) << 27) & BM_PXP_CTRL2_ENABLE_ROTATE1)
#define BM_PXP_CTRL2_ENABLE_ROTATE0 0x04000000
#define BF_PXP_CTRL2_ENABLE_ROTATE0(v)  \
        (((v) << 26) & BM_PXP_CTRL2_ENABLE_ROTATE0)
#define BM_PXP_CTRL2_ENABLE_LUT 0x02000000
#define BF_PXP_CTRL2_ENABLE_LUT(v)  \
        (((v) << 25) & BM_PXP_CTRL2_ENABLE_LUT)
#define BM_PXP_CTRL2_ENABLE_CSC2 0x01000000
#define BF_PXP_CTRL2_ENABLE_CSC2(v)  \
        (((v) << 24) & BM_PXP_CTRL2_ENABLE_CSC2)
#define BM_PXP_CTRL2_BLOCK_SIZE 0x00800000
#define BF_PXP_CTRL2_BLOCK_SIZE(v)  \
        (((v) << 23) & BM_PXP_CTRL2_BLOCK_SIZE)
#define BV_PXP_CTRL2_BLOCK_SIZE__8X8   0x0
#define BV_PXP_CTRL2_BLOCK_SIZE__16X16 0x1
#define BM_PXP_CTRL2_RSVD2 0x00400000
#define BF_PXP_CTRL2_RSVD2(v)  \
        (((v) << 22) & BM_PXP_CTRL2_RSVD2)
#define BM_PXP_CTRL2_ENABLE_ALPHA_B 0x00200000
#define BF_PXP_CTRL2_ENABLE_ALPHA_B(v)  \
        (((v) << 21) & BM_PXP_CTRL2_ENABLE_ALPHA_B)
#define BM_PXP_CTRL2_ENABLE_INPUT_FETCH_STORE 0x00100000
#define BF_PXP_CTRL2_ENABLE_INPUT_FETCH_STORE(v)  \
        (((v) << 20) & BM_PXP_CTRL2_ENABLE_INPUT_FETCH_STORE)
#define BM_PXP_CTRL2_ENABLE_WFE_B 0x00080000
#define BF_PXP_CTRL2_ENABLE_WFE_B(v)  \
        (((v) << 19) & BM_PXP_CTRL2_ENABLE_WFE_B)
#define BM_PXP_CTRL2_ENABLE_WFE_A 0x00040000
#define BF_PXP_CTRL2_ENABLE_WFE_A(v)  \
        (((v) << 18) & BM_PXP_CTRL2_ENABLE_WFE_A)
#define BM_PXP_CTRL2_ENABLE_DITHER 0x00020000
#define BF_PXP_CTRL2_ENABLE_DITHER(v)  \
        (((v) << 17) & BM_PXP_CTRL2_ENABLE_DITHER)
#define BM_PXP_CTRL2_RSVD1 0x00010000
#define BF_PXP_CTRL2_RSVD1(v)  \
        (((v) << 16) & BM_PXP_CTRL2_RSVD1)
#define BM_PXP_CTRL2_VFLIP1 0x00008000
#define BF_PXP_CTRL2_VFLIP1(v)  \
        (((v) << 15) & BM_PXP_CTRL2_VFLIP1)
#define BM_PXP_CTRL2_HFLIP1 0x00004000
#define BF_PXP_CTRL2_HFLIP1(v)  \
        (((v) << 14) & BM_PXP_CTRL2_HFLIP1)
#define BP_PXP_CTRL2_ROTATE1      12
#define BM_PXP_CTRL2_ROTATE1 0x00003000
#define BF_PXP_CTRL2_ROTATE1(v)  \
        (((v) << 12) & BM_PXP_CTRL2_ROTATE1)
#define BV_PXP_CTRL2_ROTATE1__ROT_0   0x0
#define BV_PXP_CTRL2_ROTATE1__ROT_90  0x1
#define BV_PXP_CTRL2_ROTATE1__ROT_180 0x2
#define BV_PXP_CTRL2_ROTATE1__ROT_270 0x3
#define BM_PXP_CTRL2_VFLIP0 0x00000800
#define BF_PXP_CTRL2_VFLIP0(v)  \
        (((v) << 11) & BM_PXP_CTRL2_VFLIP0)
#define BM_PXP_CTRL2_HFLIP0 0x00000400
#define BF_PXP_CTRL2_HFLIP0(v)  \
        (((v) << 10) & BM_PXP_CTRL2_HFLIP0)
#define BP_PXP_CTRL2_ROTATE0      8
#define BM_PXP_CTRL2_ROTATE0 0x00000300
#define BF_PXP_CTRL2_ROTATE0(v)  \
        (((v) << 8) & BM_PXP_CTRL2_ROTATE0)
#define BV_PXP_CTRL2_ROTATE0__ROT_0   0x0
#define BV_PXP_CTRL2_ROTATE0__ROT_90  0x1
#define BV_PXP_CTRL2_ROTATE0__ROT_180 0x2
#define BV_PXP_CTRL2_ROTATE0__ROT_270 0x3
#define BP_PXP_CTRL2_RSVD0      1
#define BM_PXP_CTRL2_RSVD0 0x000000FE
#define BF_PXP_CTRL2_RSVD0(v)  \
        (((v) << 1) & BM_PXP_CTRL2_RSVD0)
#define BM_PXP_CTRL2_ENABLE 0x00000001
#define BF_PXP_CTRL2_ENABLE(v)  \
        (((v) << 0) & BM_PXP_CTRL2_ENABLE)

#define HW_PXP_POWER_REG0	(0x00000320)

#define BP_PXP_POWER_REG0_CTRL      12
#define BM_PXP_POWER_REG0_CTRL 0xFFFFF000
#define BF_PXP_POWER_REG0_CTRL(v) \
        (((v) << 12) & BM_PXP_POWER_REG0_CTRL)
#define BP_PXP_POWER_REG0_ROT0_MEM_LP_STATE      9
#define BM_PXP_POWER_REG0_ROT0_MEM_LP_STATE 0x00000E00
#define BF_PXP_POWER_REG0_ROT0_MEM_LP_STATE(v)  \
        (((v) << 9) & BM_PXP_POWER_REG0_ROT0_MEM_LP_STATE)
#define BV_PXP_POWER_REG0_ROT0_MEM_LP_STATE__NONE 0x0
#define BV_PXP_POWER_REG0_ROT0_MEM_LP_STATE__LS   0x1
#define BV_PXP_POWER_REG0_ROT0_MEM_LP_STATE__DS   0x2
#define BV_PXP_POWER_REG0_ROT0_MEM_LP_STATE__SD   0x4
#define BP_PXP_POWER_REG0_LUT_LP_STATE_WAY1_BANKN      6
#define BM_PXP_POWER_REG0_LUT_LP_STATE_WAY1_BANKN 0x000001C0
#define BF_PXP_POWER_REG0_LUT_LP_STATE_WAY1_BANKN(v)  \
        (((v) << 6) & BM_PXP_POWER_REG0_LUT_LP_STATE_WAY1_BANKN)
#define BV_PXP_POWER_REG0_LUT_LP_STATE_WAY1_BANKN__NONE 0x0
#define BV_PXP_POWER_REG0_LUT_LP_STATE_WAY1_BANKN__LS   0x1
#define BV_PXP_POWER_REG0_LUT_LP_STATE_WAY1_BANKN__DS   0x2
#define BV_PXP_POWER_REG0_LUT_LP_STATE_WAY1_BANKN__SD   0x4
#define BP_PXP_POWER_REG0_LUT_LP_STATE_WAY0_BANKN      3
#define BM_PXP_POWER_REG0_LUT_LP_STATE_WAY0_BANKN 0x00000038
#define BF_PXP_POWER_REG0_LUT_LP_STATE_WAY0_BANKN(v)  \
        (((v) << 3) & BM_PXP_POWER_REG0_LUT_LP_STATE_WAY0_BANKN)
#define BV_PXP_POWER_REG0_LUT_LP_STATE_WAY0_BANKN__NONE 0x0
#define BV_PXP_POWER_REG0_LUT_LP_STATE_WAY0_BANKN__LS   0x1
#define BV_PXP_POWER_REG0_LUT_LP_STATE_WAY0_BANKN__DS   0x2
#define BV_PXP_POWER_REG0_LUT_LP_STATE_WAY0_BANKN__SD   0x4
#define BP_PXP_POWER_REG0_LUT_LP_STATE_WAY0_BANK0      0
#define BM_PXP_POWER_REG0_LUT_LP_STATE_WAY0_BANK0 0x00000007
#define BF_PXP_POWER_REG0_LUT_LP_STATE_WAY0_BANK0(v)  \
        (((v) << 0) & BM_PXP_POWER_REG0_LUT_LP_STATE_WAY0_BANK0)
#define BV_PXP_POWER_REG0_LUT_LP_STATE_WAY0_BANK0__NONE 0x0
#define BV_PXP_POWER_REG0_LUT_LP_STATE_WAY0_BANK0__LS   0x1
#define BV_PXP_POWER_REG0_LUT_LP_STATE_WAY0_BANK0__DS   0x2
#define BV_PXP_POWER_REG0_LUT_LP_STATE_WAY0_BANK0__SD   0x4

#define HW_PXP_POWER_REG1	(0x00000330)

#define BP_PXP_POWER_REG1_RSVD0      24
#define BM_PXP_POWER_REG1_RSVD0 0xFF000000
#define BF_PXP_POWER_REG1_RSVD0(v) \
        (((v) << 24) & BM_PXP_POWER_REG1_RSVD0)
#define BP_PXP_POWER_REG1_ALU_B_MEM_LP_STATE      21
#define BM_PXP_POWER_REG1_ALU_B_MEM_LP_STATE 0x00E00000
#define BF_PXP_POWER_REG1_ALU_B_MEM_LP_STATE(v)  \
        (((v) << 21) & BM_PXP_POWER_REG1_ALU_B_MEM_LP_STATE)
#define BV_PXP_POWER_REG1_ALU_B_MEM_LP_STATE__NONE 0x0
#define BV_PXP_POWER_REG1_ALU_B_MEM_LP_STATE__LS   0x1
#define BV_PXP_POWER_REG1_ALU_B_MEM_LP_STATE__DS   0x2
#define BV_PXP_POWER_REG1_ALU_B_MEM_LP_STATE__SD   0x4
#define BP_PXP_POWER_REG1_ALU_A_MEM_LP_STATE      18
#define BM_PXP_POWER_REG1_ALU_A_MEM_LP_STATE 0x001C0000
#define BF_PXP_POWER_REG1_ALU_A_MEM_LP_STATE(v)  \
        (((v) << 18) & BM_PXP_POWER_REG1_ALU_A_MEM_LP_STATE)
#define BV_PXP_POWER_REG1_ALU_A_MEM_LP_STATE__NONE 0x0
#define BV_PXP_POWER_REG1_ALU_A_MEM_LP_STATE__LS   0x1
#define BV_PXP_POWER_REG1_ALU_A_MEM_LP_STATE__DS   0x2
#define BV_PXP_POWER_REG1_ALU_A_MEM_LP_STATE__SD   0x4
#define BP_PXP_POWER_REG1_DITH2_LUT_MEM_LP_STATE      15
#define BM_PXP_POWER_REG1_DITH2_LUT_MEM_LP_STATE 0x00038000
#define BF_PXP_POWER_REG1_DITH2_LUT_MEM_LP_STATE(v)  \
        (((v) << 15) & BM_PXP_POWER_REG1_DITH2_LUT_MEM_LP_STATE)
#define BV_PXP_POWER_REG1_DITH2_LUT_MEM_LP_STATE__NONE 0x0
#define BV_PXP_POWER_REG1_DITH2_LUT_MEM_LP_STATE__LS   0x1
#define BV_PXP_POWER_REG1_DITH2_LUT_MEM_LP_STATE__DS   0x2
#define BV_PXP_POWER_REG1_DITH2_LUT_MEM_LP_STATE__SD   0x4
#define BP_PXP_POWER_REG1_DITH1_LUT_MEM_LP_STATE      12
#define BM_PXP_POWER_REG1_DITH1_LUT_MEM_LP_STATE 0x00007000
#define BF_PXP_POWER_REG1_DITH1_LUT_MEM_LP_STATE(v)  \
        (((v) << 12) & BM_PXP_POWER_REG1_DITH1_LUT_MEM_LP_STATE)
#define BV_PXP_POWER_REG1_DITH1_LUT_MEM_LP_STATE__NONE 0x0
#define BV_PXP_POWER_REG1_DITH1_LUT_MEM_LP_STATE__LS   0x1
#define BV_PXP_POWER_REG1_DITH1_LUT_MEM_LP_STATE__DS   0x2
#define BV_PXP_POWER_REG1_DITH1_LUT_MEM_LP_STATE__SD   0x4
#define BP_PXP_POWER_REG1_DITH0_ERR1_MEM_LP_STATE      9
#define BM_PXP_POWER_REG1_DITH0_ERR1_MEM_LP_STATE 0x00000E00
#define BF_PXP_POWER_REG1_DITH0_ERR1_MEM_LP_STATE(v)  \
        (((v) << 9) & BM_PXP_POWER_REG1_DITH0_ERR1_MEM_LP_STATE)
#define BV_PXP_POWER_REG1_DITH0_ERR1_MEM_LP_STATE__NONE 0x0
#define BV_PXP_POWER_REG1_DITH0_ERR1_MEM_LP_STATE__LS   0x1
#define BV_PXP_POWER_REG1_DITH0_ERR1_MEM_LP_STATE__DS   0x2
#define BV_PXP_POWER_REG1_DITH0_ERR1_MEM_LP_STATE__SD   0x4
#define BP_PXP_POWER_REG1_DITH0_ERR0_MEM_LP_STATE      6
#define BM_PXP_POWER_REG1_DITH0_ERR0_MEM_LP_STATE 0x000001C0
#define BF_PXP_POWER_REG1_DITH0_ERR0_MEM_LP_STATE(v)  \
        (((v) << 6) & BM_PXP_POWER_REG1_DITH0_ERR0_MEM_LP_STATE)
#define BV_PXP_POWER_REG1_DITH0_ERR0_MEM_LP_STATE__NONE 0x0
#define BV_PXP_POWER_REG1_DITH0_ERR0_MEM_LP_STATE__LS   0x1
#define BV_PXP_POWER_REG1_DITH0_ERR0_MEM_LP_STATE__DS   0x2
#define BV_PXP_POWER_REG1_DITH0_ERR0_MEM_LP_STATE__SD   0x4
#define BP_PXP_POWER_REG1_DITH0_LUT_MEM_LP_STATE      3
#define BM_PXP_POWER_REG1_DITH0_LUT_MEM_LP_STATE 0x00000038
#define BF_PXP_POWER_REG1_DITH0_LUT_MEM_LP_STATE(v)  \
        (((v) << 3) & BM_PXP_POWER_REG1_DITH0_LUT_MEM_LP_STATE)
#define BV_PXP_POWER_REG1_DITH0_LUT_MEM_LP_STATE__NONE 0x0
#define BV_PXP_POWER_REG1_DITH0_LUT_MEM_LP_STATE__LS   0x1
#define BV_PXP_POWER_REG1_DITH0_LUT_MEM_LP_STATE__DS   0x2
#define BV_PXP_POWER_REG1_DITH0_LUT_MEM_LP_STATE__SD   0x4
#define BP_PXP_POWER_REG1_ROT1_MEM_LP_STATE      0
#define BM_PXP_POWER_REG1_ROT1_MEM_LP_STATE 0x00000007
#define BF_PXP_POWER_REG1_ROT1_MEM_LP_STATE(v)  \
        (((v) << 0) & BM_PXP_POWER_REG1_ROT1_MEM_LP_STATE)
#define BV_PXP_POWER_REG1_ROT1_MEM_LP_STATE__NONE 0x0
#define BV_PXP_POWER_REG1_ROT1_MEM_LP_STATE__LS   0x1
#define BV_PXP_POWER_REG1_ROT1_MEM_LP_STATE__DS   0x2
#define BV_PXP_POWER_REG1_ROT1_MEM_LP_STATE__SD   0x4

#define HW_PXP_DATA_PATH_CTRL0	(0x00000340)
#define HW_PXP_DATA_PATH_CTRL0_SET	(0x00000344)
#define HW_PXP_DATA_PATH_CTRL0_CLR	(0x00000348)
#define HW_PXP_DATA_PATH_CTRL0_TOG	(0x0000034c)

#define BP_PXP_DATA_PATH_CTRL0_MUX15_SEL      30
#define BM_PXP_DATA_PATH_CTRL0_MUX15_SEL 0xC0000000
#define BF_PXP_DATA_PATH_CTRL0_MUX15_SEL(v) \
        (((v) << 30) & BM_PXP_DATA_PATH_CTRL0_MUX15_SEL)
#define BV_PXP_DATA_PATH_CTRL0_MUX15_SEL__0 0x0
#define BV_PXP_DATA_PATH_CTRL0_MUX15_SEL__1 0x1
#define BV_PXP_DATA_PATH_CTRL0_MUX15_SEL__2 0x2
#define BV_PXP_DATA_PATH_CTRL0_MUX15_SEL__3 0x3
#define BP_PXP_DATA_PATH_CTRL0_MUX14_SEL      28
#define BM_PXP_DATA_PATH_CTRL0_MUX14_SEL 0x30000000
#define BF_PXP_DATA_PATH_CTRL0_MUX14_SEL(v)  \
        (((v) << 28) & BM_PXP_DATA_PATH_CTRL0_MUX14_SEL)
#define BV_PXP_DATA_PATH_CTRL0_MUX14_SEL__0 0x0
#define BV_PXP_DATA_PATH_CTRL0_MUX14_SEL__1 0x1
#define BV_PXP_DATA_PATH_CTRL0_MUX14_SEL__2 0x2
#define BV_PXP_DATA_PATH_CTRL0_MUX14_SEL__3 0x3
#define BP_PXP_DATA_PATH_CTRL0_MUX13_SEL      26
#define BM_PXP_DATA_PATH_CTRL0_MUX13_SEL 0x0C000000
#define BF_PXP_DATA_PATH_CTRL0_MUX13_SEL(v)  \
        (((v) << 26) & BM_PXP_DATA_PATH_CTRL0_MUX13_SEL)
#define BV_PXP_DATA_PATH_CTRL0_MUX13_SEL__0 0x0
#define BV_PXP_DATA_PATH_CTRL0_MUX13_SEL__1 0x1
#define BV_PXP_DATA_PATH_CTRL0_MUX13_SEL__2 0x2
#define BV_PXP_DATA_PATH_CTRL0_MUX13_SEL__3 0x3
#define BP_PXP_DATA_PATH_CTRL0_MUX12_SEL      24
#define BM_PXP_DATA_PATH_CTRL0_MUX12_SEL 0x03000000
#define BF_PXP_DATA_PATH_CTRL0_MUX12_SEL(v)  \
        (((v) << 24) & BM_PXP_DATA_PATH_CTRL0_MUX12_SEL)
#define BV_PXP_DATA_PATH_CTRL0_MUX12_SEL__0 0x0
#define BV_PXP_DATA_PATH_CTRL0_MUX12_SEL__1 0x1
#define BV_PXP_DATA_PATH_CTRL0_MUX12_SEL__2 0x2
#define BV_PXP_DATA_PATH_CTRL0_MUX12_SEL__3 0x3
#define BP_PXP_DATA_PATH_CTRL0_MUX11_SEL      22
#define BM_PXP_DATA_PATH_CTRL0_MUX11_SEL 0x00C00000
#define BF_PXP_DATA_PATH_CTRL0_MUX11_SEL(v)  \
        (((v) << 22) & BM_PXP_DATA_PATH_CTRL0_MUX11_SEL)
#define BV_PXP_DATA_PATH_CTRL0_MUX11_SEL__0 0x0
#define BV_PXP_DATA_PATH_CTRL0_MUX11_SEL__1 0x1
#define BV_PXP_DATA_PATH_CTRL0_MUX11_SEL__2 0x2
#define BV_PXP_DATA_PATH_CTRL0_MUX11_SEL__3 0x3
#define BP_PXP_DATA_PATH_CTRL0_MUX10_SEL      20
#define BM_PXP_DATA_PATH_CTRL0_MUX10_SEL 0x00300000
#define BF_PXP_DATA_PATH_CTRL0_MUX10_SEL(v)  \
        (((v) << 20) & BM_PXP_DATA_PATH_CTRL0_MUX10_SEL)
#define BV_PXP_DATA_PATH_CTRL0_MUX10_SEL__0 0x0
#define BV_PXP_DATA_PATH_CTRL0_MUX10_SEL__1 0x1
#define BV_PXP_DATA_PATH_CTRL0_MUX10_SEL__2 0x2
#define BV_PXP_DATA_PATH_CTRL0_MUX10_SEL__3 0x3
#define BP_PXP_DATA_PATH_CTRL0_MUX9_SEL      18
#define BM_PXP_DATA_PATH_CTRL0_MUX9_SEL 0x000C0000
#define BF_PXP_DATA_PATH_CTRL0_MUX9_SEL(v)  \
        (((v) << 18) & BM_PXP_DATA_PATH_CTRL0_MUX9_SEL)
#define BV_PXP_DATA_PATH_CTRL0_MUX9_SEL__0 0x0
#define BV_PXP_DATA_PATH_CTRL0_MUX9_SEL__1 0x1
#define BV_PXP_DATA_PATH_CTRL0_MUX9_SEL__2 0x2
#define BV_PXP_DATA_PATH_CTRL0_MUX9_SEL__3 0x3
#define BP_PXP_DATA_PATH_CTRL0_MUX8_SEL      16
#define BM_PXP_DATA_PATH_CTRL0_MUX8_SEL 0x00030000
#define BF_PXP_DATA_PATH_CTRL0_MUX8_SEL(v)  \
        (((v) << 16) & BM_PXP_DATA_PATH_CTRL0_MUX8_SEL)
#define BV_PXP_DATA_PATH_CTRL0_MUX8_SEL__0 0x0
#define BV_PXP_DATA_PATH_CTRL0_MUX8_SEL__1 0x1
#define BV_PXP_DATA_PATH_CTRL0_MUX8_SEL__2 0x2
#define BV_PXP_DATA_PATH_CTRL0_MUX8_SEL__3 0x3
#define BP_PXP_DATA_PATH_CTRL0_MUX7_SEL      14
#define BM_PXP_DATA_PATH_CTRL0_MUX7_SEL 0x0000C000
#define BF_PXP_DATA_PATH_CTRL0_MUX7_SEL(v)  \
        (((v) << 14) & BM_PXP_DATA_PATH_CTRL0_MUX7_SEL)
#define BV_PXP_DATA_PATH_CTRL0_MUX7_SEL__0 0x0
#define BV_PXP_DATA_PATH_CTRL0_MUX7_SEL__1 0x1
#define BV_PXP_DATA_PATH_CTRL0_MUX7_SEL__2 0x2
#define BV_PXP_DATA_PATH_CTRL0_MUX7_SEL__3 0x3
#define BP_PXP_DATA_PATH_CTRL0_MUX6_SEL      12
#define BM_PXP_DATA_PATH_CTRL0_MUX6_SEL 0x00003000
#define BF_PXP_DATA_PATH_CTRL0_MUX6_SEL(v)  \
        (((v) << 12) & BM_PXP_DATA_PATH_CTRL0_MUX6_SEL)
#define BV_PXP_DATA_PATH_CTRL0_MUX6_SEL__0 0x0
#define BV_PXP_DATA_PATH_CTRL0_MUX6_SEL__1 0x1
#define BV_PXP_DATA_PATH_CTRL0_MUX6_SEL__2 0x2
#define BV_PXP_DATA_PATH_CTRL0_MUX6_SEL__3 0x3
#define BP_PXP_DATA_PATH_CTRL0_MUX5_SEL      10
#define BM_PXP_DATA_PATH_CTRL0_MUX5_SEL 0x00000C00
#define BF_PXP_DATA_PATH_CTRL0_MUX5_SEL(v)  \
        (((v) << 10) & BM_PXP_DATA_PATH_CTRL0_MUX5_SEL)
#define BV_PXP_DATA_PATH_CTRL0_MUX5_SEL__0 0x0
#define BV_PXP_DATA_PATH_CTRL0_MUX5_SEL__1 0x1
#define BV_PXP_DATA_PATH_CTRL0_MUX5_SEL__2 0x2
#define BV_PXP_DATA_PATH_CTRL0_MUX5_SEL__3 0x3
#define BP_PXP_DATA_PATH_CTRL0_MUX4_SEL      8
#define BM_PXP_DATA_PATH_CTRL0_MUX4_SEL 0x00000300
#define BF_PXP_DATA_PATH_CTRL0_MUX4_SEL(v)  \
        (((v) << 8) & BM_PXP_DATA_PATH_CTRL0_MUX4_SEL)
#define BV_PXP_DATA_PATH_CTRL0_MUX4_SEL__0 0x0
#define BV_PXP_DATA_PATH_CTRL0_MUX4_SEL__1 0x1
#define BV_PXP_DATA_PATH_CTRL0_MUX4_SEL__2 0x2
#define BV_PXP_DATA_PATH_CTRL0_MUX4_SEL__3 0x3
#define BP_PXP_DATA_PATH_CTRL0_MUX3_SEL      6
#define BM_PXP_DATA_PATH_CTRL0_MUX3_SEL 0x000000C0
#define BF_PXP_DATA_PATH_CTRL0_MUX3_SEL(v)  \
        (((v) << 6) & BM_PXP_DATA_PATH_CTRL0_MUX3_SEL)
#define BV_PXP_DATA_PATH_CTRL0_MUX3_SEL__0 0x0
#define BV_PXP_DATA_PATH_CTRL0_MUX3_SEL__1 0x1
#define BV_PXP_DATA_PATH_CTRL0_MUX3_SEL__2 0x2
#define BV_PXP_DATA_PATH_CTRL0_MUX3_SEL__3 0x3
#define BP_PXP_DATA_PATH_CTRL0_MUX2_SEL      4
#define BM_PXP_DATA_PATH_CTRL0_MUX2_SEL 0x00000030
#define BF_PXP_DATA_PATH_CTRL0_MUX2_SEL(v)  \
        (((v) << 4) & BM_PXP_DATA_PATH_CTRL0_MUX2_SEL)
#define BV_PXP_DATA_PATH_CTRL0_MUX2_SEL__0 0x0
#define BV_PXP_DATA_PATH_CTRL0_MUX2_SEL__1 0x1
#define BV_PXP_DATA_PATH_CTRL0_MUX2_SEL__2 0x2
#define BV_PXP_DATA_PATH_CTRL0_MUX2_SEL__3 0x3
#define BP_PXP_DATA_PATH_CTRL0_MUX1_SEL      2
#define BM_PXP_DATA_PATH_CTRL0_MUX1_SEL 0x0000000C
#define BF_PXP_DATA_PATH_CTRL0_MUX1_SEL(v)  \
        (((v) << 2) & BM_PXP_DATA_PATH_CTRL0_MUX1_SEL)
#define BV_PXP_DATA_PATH_CTRL0_MUX1_SEL__0 0x0
#define BV_PXP_DATA_PATH_CTRL0_MUX1_SEL__1 0x1
#define BV_PXP_DATA_PATH_CTRL0_MUX1_SEL__2 0x2
#define BV_PXP_DATA_PATH_CTRL0_MUX1_SEL__3 0x3
#define BP_PXP_DATA_PATH_CTRL0_MUX0_SEL      0
#define BM_PXP_DATA_PATH_CTRL0_MUX0_SEL 0x00000003
#define BF_PXP_DATA_PATH_CTRL0_MUX0_SEL(v)  \
        (((v) << 0) & BM_PXP_DATA_PATH_CTRL0_MUX0_SEL)
#define BV_PXP_DATA_PATH_CTRL0_MUX0_SEL__0 0x0
#define BV_PXP_DATA_PATH_CTRL0_MUX0_SEL__1 0x1
#define BV_PXP_DATA_PATH_CTRL0_MUX0_SEL__2 0x2
#define BV_PXP_DATA_PATH_CTRL0_MUX0_SEL__3 0x3

#define HW_PXP_DATA_PATH_CTRL1	(0x00000350)
#define HW_PXP_DATA_PATH_CTRL1_SET	(0x00000354)
#define HW_PXP_DATA_PATH_CTRL1_CLR	(0x00000358)
#define HW_PXP_DATA_PATH_CTRL1_TOG	(0x0000035c)

#define BP_PXP_DATA_PATH_CTRL1_RSVD0      4
#define BM_PXP_DATA_PATH_CTRL1_RSVD0 0xFFFFFFF0
#define BF_PXP_DATA_PATH_CTRL1_RSVD0(v) \
        (((v) << 4) & BM_PXP_DATA_PATH_CTRL1_RSVD0)
#define BP_PXP_DATA_PATH_CTRL1_MUX17_SEL      2
#define BM_PXP_DATA_PATH_CTRL1_MUX17_SEL 0x0000000C
#define BF_PXP_DATA_PATH_CTRL1_MUX17_SEL(v)  \
        (((v) << 2) & BM_PXP_DATA_PATH_CTRL1_MUX17_SEL)
#define BV_PXP_DATA_PATH_CTRL1_MUX17_SEL__0 0x0
#define BV_PXP_DATA_PATH_CTRL1_MUX17_SEL__1 0x1
#define BV_PXP_DATA_PATH_CTRL1_MUX17_SEL__2 0x2
#define BV_PXP_DATA_PATH_CTRL1_MUX17_SEL__3 0x3
#define BP_PXP_DATA_PATH_CTRL1_MUX16_SEL      0
#define BM_PXP_DATA_PATH_CTRL1_MUX16_SEL 0x00000003
#define BF_PXP_DATA_PATH_CTRL1_MUX16_SEL(v)  \
        (((v) << 0) & BM_PXP_DATA_PATH_CTRL1_MUX16_SEL)
#define BV_PXP_DATA_PATH_CTRL1_MUX16_SEL__0 0x0
#define BV_PXP_DATA_PATH_CTRL1_MUX16_SEL__1 0x1
#define BV_PXP_DATA_PATH_CTRL1_MUX16_SEL__2 0x2
#define BV_PXP_DATA_PATH_CTRL1_MUX16_SEL__3 0x3

#define HW_PXP_INIT_MEM_CTRL	(0x00000360)
#define HW_PXP_INIT_MEM_CTRL_SET	(0x00000364)
#define HW_PXP_INIT_MEM_CTRL_CLR	(0x00000368)
#define HW_PXP_INIT_MEM_CTRL_TOG	(0x0000036c)

#define BM_PXP_INIT_MEM_CTRL_START 0x80000000
#define BF_PXP_INIT_MEM_CTRL_START(v) \
        (((v) << 31) & BM_PXP_INIT_MEM_CTRL_START)
#define BP_PXP_INIT_MEM_CTRL_SELECT      27
#define BM_PXP_INIT_MEM_CTRL_SELECT 0x78000000
#define BF_PXP_INIT_MEM_CTRL_SELECT(v)  \
        (((v) << 27) & BM_PXP_INIT_MEM_CTRL_SELECT)
#define BV_PXP_INIT_MEM_CTRL_SELECT__DITHER0_LUT  0x0
#define BV_PXP_INIT_MEM_CTRL_SELECT__DITHER0_ERR0 0x1
#define BV_PXP_INIT_MEM_CTRL_SELECT__DITHER0_ERR1 0x2
#define BV_PXP_INIT_MEM_CTRL_SELECT__DITHER1_LUT  0x3
#define BV_PXP_INIT_MEM_CTRL_SELECT__DITHER2_LUT  0x4
#define BV_PXP_INIT_MEM_CTRL_SELECT__ALU_A        0x5
#define BV_PXP_INIT_MEM_CTRL_SELECT__ALU_B        0x6
#define BV_PXP_INIT_MEM_CTRL_SELECT__WFE_A_FETCH  0x7
#define BV_PXP_INIT_MEM_CTRL_SELECT__WFE_B_FETCH  0x8
#define BV_PXP_INIT_MEM_CTRL_SELECT__RESERVED     0x15
#define BP_PXP_INIT_MEM_CTRL_RSVD0      16
#define BM_PXP_INIT_MEM_CTRL_RSVD0 0x07FF0000
#define BF_PXP_INIT_MEM_CTRL_RSVD0(v)  \
        (((v) << 16) & BM_PXP_INIT_MEM_CTRL_RSVD0)
#define BP_PXP_INIT_MEM_CTRL_ADDR      0
#define BM_PXP_INIT_MEM_CTRL_ADDR 0x0000FFFF
#define BF_PXP_INIT_MEM_CTRL_ADDR(v)  \
        (((v) << 0) & BM_PXP_INIT_MEM_CTRL_ADDR)

#define HW_PXP_INIT_MEM_DATA	(0x00000370)

#define BP_PXP_INIT_MEM_DATA_DATA      0
#define BM_PXP_INIT_MEM_DATA_DATA 0xFFFFFFFF
#define BF_PXP_INIT_MEM_DATA_DATA(v)   (v)

#define HW_PXP_INIT_MEM_DATA_HIGH	(0x00000380)

#define BP_PXP_INIT_MEM_DATA_HIGH_DATA      0
#define BM_PXP_INIT_MEM_DATA_HIGH_DATA 0xFFFFFFFF
#define BF_PXP_INIT_MEM_DATA_HIGH_DATA(v)   (v)

#define HW_PXP_IRQ_MASK	(0x00000390)
#define HW_PXP_IRQ_MASK_SET	(0x00000394)
#define HW_PXP_IRQ_MASK_CLR	(0x00000398)
#define HW_PXP_IRQ_MASK_TOG	(0x0000039c)

#define BM_PXP_IRQ_MASK_COMPRESS_DONE_IRQ_EN 0x80000000
#define BF_PXP_IRQ_MASK_COMPRESS_DONE_IRQ_EN(v) \
        (((v) << 31) & BM_PXP_IRQ_MASK_COMPRESS_DONE_IRQ_EN)
#define BP_PXP_IRQ_MASK_RSVD1      16
#define BM_PXP_IRQ_MASK_RSVD1 0x7FFF0000
#define BF_PXP_IRQ_MASK_RSVD1(v)  \
        (((v) << 16) & BM_PXP_IRQ_MASK_RSVD1)
#define BM_PXP_IRQ_MASK_WFE_B_STORE_IRQ_EN 0x00008000
#define BF_PXP_IRQ_MASK_WFE_B_STORE_IRQ_EN(v)  \
        (((v) << 15) & BM_PXP_IRQ_MASK_WFE_B_STORE_IRQ_EN)
#define BM_PXP_IRQ_MASK_WFE_A_STORE_IRQ_EN 0x00004000
#define BF_PXP_IRQ_MASK_WFE_A_STORE_IRQ_EN(v)  \
        (((v) << 14) & BM_PXP_IRQ_MASK_WFE_A_STORE_IRQ_EN)
#define BM_PXP_IRQ_MASK_DITHER_STORE_IRQ_EN 0x00002000
#define BF_PXP_IRQ_MASK_DITHER_STORE_IRQ_EN(v)  \
        (((v) << 13) & BM_PXP_IRQ_MASK_DITHER_STORE_IRQ_EN)
#define BM_PXP_IRQ_MASK_FIRST_STORE_IRQ_EN 0x00001000
#define BF_PXP_IRQ_MASK_FIRST_STORE_IRQ_EN(v)  \
        (((v) << 12) & BM_PXP_IRQ_MASK_FIRST_STORE_IRQ_EN)
#define BM_PXP_IRQ_MASK_WFE_B_CH1_STORE_IRQ_EN 0x00000800
#define BF_PXP_IRQ_MASK_WFE_B_CH1_STORE_IRQ_EN(v)  \
        (((v) << 11) & BM_PXP_IRQ_MASK_WFE_B_CH1_STORE_IRQ_EN)
#define BM_PXP_IRQ_MASK_WFE_B_CH0_STORE_IRQ_EN 0x00000400
#define BF_PXP_IRQ_MASK_WFE_B_CH0_STORE_IRQ_EN(v)  \
        (((v) << 10) & BM_PXP_IRQ_MASK_WFE_B_CH0_STORE_IRQ_EN)
#define BM_PXP_IRQ_MASK_WFE_A_CH1_STORE_IRQ_EN 0x00000200
#define BF_PXP_IRQ_MASK_WFE_A_CH1_STORE_IRQ_EN(v)  \
        (((v) << 9) & BM_PXP_IRQ_MASK_WFE_A_CH1_STORE_IRQ_EN)
#define BM_PXP_IRQ_MASK_WFE_A_CH0_STORE_IRQ_EN 0x00000100
#define BF_PXP_IRQ_MASK_WFE_A_CH0_STORE_IRQ_EN(v)  \
        (((v) << 8) & BM_PXP_IRQ_MASK_WFE_A_CH0_STORE_IRQ_EN)
#define BM_PXP_IRQ_MASK_DITHER_CH1_STORE_IRQ_EN 0x00000080
#define BF_PXP_IRQ_MASK_DITHER_CH1_STORE_IRQ_EN(v)  \
        (((v) << 7) & BM_PXP_IRQ_MASK_DITHER_CH1_STORE_IRQ_EN)
#define BM_PXP_IRQ_MASK_DITHER_CH0_STORE_IRQ_EN 0x00000040
#define BF_PXP_IRQ_MASK_DITHER_CH0_STORE_IRQ_EN(v)  \
        (((v) << 6) & BM_PXP_IRQ_MASK_DITHER_CH0_STORE_IRQ_EN)
#define BM_PXP_IRQ_MASK_DITHER_CH1_PREFETCH_IRQ_EN 0x00000020
#define BF_PXP_IRQ_MASK_DITHER_CH1_PREFETCH_IRQ_EN(v)  \
        (((v) << 5) & BM_PXP_IRQ_MASK_DITHER_CH1_PREFETCH_IRQ_EN)
#define BM_PXP_IRQ_MASK_DITHER_CH0_PREFETCH_IRQ_EN 0x00000010
#define BF_PXP_IRQ_MASK_DITHER_CH0_PREFETCH_IRQ_EN(v)  \
        (((v) << 4) & BM_PXP_IRQ_MASK_DITHER_CH0_PREFETCH_IRQ_EN)
#define BM_PXP_IRQ_MASK_FIRST_CH1_STORE_IRQ_EN 0x00000008
#define BF_PXP_IRQ_MASK_FIRST_CH1_STORE_IRQ_EN(v)  \
        (((v) << 3) & BM_PXP_IRQ_MASK_FIRST_CH1_STORE_IRQ_EN)
#define BM_PXP_IRQ_MASK_FIRST_CH0_STORE_IRQ_EN 0x00000004
#define BF_PXP_IRQ_MASK_FIRST_CH0_STORE_IRQ_EN(v)  \
        (((v) << 2) & BM_PXP_IRQ_MASK_FIRST_CH0_STORE_IRQ_EN)
#define BM_PXP_IRQ_MASK_FIRST_CH1_PREFETCH_IRQ_EN 0x00000002
#define BF_PXP_IRQ_MASK_FIRST_CH1_PREFETCH_IRQ_EN(v)  \
        (((v) << 1) & BM_PXP_IRQ_MASK_FIRST_CH1_PREFETCH_IRQ_EN)
#define BM_PXP_IRQ_MASK_FIRST_CH0_PREFETCH_IRQ_EN 0x00000001
#define BF_PXP_IRQ_MASK_FIRST_CH0_PREFETCH_IRQ_EN(v)  \
        (((v) << 0) & BM_PXP_IRQ_MASK_FIRST_CH0_PREFETCH_IRQ_EN)

#define HW_PXP_IRQ	(0x000003a0)
#define HW_PXP_IRQ_SET	(0x000003a4)
#define HW_PXP_IRQ_CLR	(0x000003a8)
#define HW_PXP_IRQ_TOG	(0x000003ac)

#define BM_PXP_IRQ_COMPRESS_DONE_IRQ 0x80000000
#define BF_PXP_IRQ_COMPRESS_DONE_IRQ(v) \
        (((v) << 31) & BM_PXP_IRQ_COMPRESS_DONE_IRQ)
#define BP_PXP_IRQ_RSVD1      16
#define BM_PXP_IRQ_RSVD1 0x7FFF0000
#define BF_PXP_IRQ_RSVD1(v)  \
        (((v) << 16) & BM_PXP_IRQ_RSVD1)
#define BM_PXP_IRQ_WFE_B_STORE_IRQ 0x00008000
#define BF_PXP_IRQ_WFE_B_STORE_IRQ(v)  \
        (((v) << 15) & BM_PXP_IRQ_WFE_B_STORE_IRQ)
#define BM_PXP_IRQ_WFE_A_STORE_IRQ 0x00004000
#define BF_PXP_IRQ_WFE_A_STORE_IRQ(v)  \
        (((v) << 14) & BM_PXP_IRQ_WFE_A_STORE_IRQ)
#define BM_PXP_IRQ_DITHER_STORE_IRQ 0x00002000
#define BF_PXP_IRQ_DITHER_STORE_IRQ(v)  \
        (((v) << 13) & BM_PXP_IRQ_DITHER_STORE_IRQ)
#define BM_PXP_IRQ_FIRST_STORE_IRQ 0x00001000
#define BF_PXP_IRQ_FIRST_STORE_IRQ(v)  \
        (((v) << 12) & BM_PXP_IRQ_FIRST_STORE_IRQ)
#define BM_PXP_IRQ_WFE_B_CH1_STORE_IRQ 0x00000800
#define BF_PXP_IRQ_WFE_B_CH1_STORE_IRQ(v)  \
        (((v) << 11) & BM_PXP_IRQ_WFE_B_CH1_STORE_IRQ)
#define BM_PXP_IRQ_WFE_B_CH0_STORE_IRQ 0x00000400
#define BF_PXP_IRQ_WFE_B_CH0_STORE_IRQ(v)  \
        (((v) << 10) & BM_PXP_IRQ_WFE_B_CH0_STORE_IRQ)
#define BM_PXP_IRQ_WFE_A_CH1_STORE_IRQ 0x00000200
#define BF_PXP_IRQ_WFE_A_CH1_STORE_IRQ(v)  \
        (((v) << 9) & BM_PXP_IRQ_WFE_A_CH1_STORE_IRQ)
#define BM_PXP_IRQ_WFE_A_CH0_STORE_IRQ 0x00000100
#define BF_PXP_IRQ_WFE_A_CH0_STORE_IRQ(v)  \
        (((v) << 8) & BM_PXP_IRQ_WFE_A_CH0_STORE_IRQ)
#define BM_PXP_IRQ_DITHER_CH1_STORE_IRQ 0x00000080
#define BF_PXP_IRQ_DITHER_CH1_STORE_IRQ(v)  \
        (((v) << 7) & BM_PXP_IRQ_DITHER_CH1_STORE_IRQ)
#define BM_PXP_IRQ_DITHER_CH0_STORE_IRQ 0x00000040
#define BF_PXP_IRQ_DITHER_CH0_STORE_IRQ(v)  \
        (((v) << 6) & BM_PXP_IRQ_DITHER_CH0_STORE_IRQ)
#define BM_PXP_IRQ_DITHER_CH1_PREFETCH_IRQ 0x00000020
#define BF_PXP_IRQ_DITHER_CH1_PREFETCH_IRQ(v)  \
        (((v) << 5) & BM_PXP_IRQ_DITHER_CH1_PREFETCH_IRQ)
#define BM_PXP_IRQ_DITHER_CH0_PREFETCH_IRQ 0x00000010
#define BF_PXP_IRQ_DITHER_CH0_PREFETCH_IRQ(v)  \
        (((v) << 4) & BM_PXP_IRQ_DITHER_CH0_PREFETCH_IRQ)
#define BM_PXP_IRQ_FIRST_CH1_STORE_IRQ 0x00000008
#define BF_PXP_IRQ_FIRST_CH1_STORE_IRQ(v)  \
        (((v) << 3) & BM_PXP_IRQ_FIRST_CH1_STORE_IRQ)
#define BM_PXP_IRQ_FIRST_CH0_STORE_IRQ 0x00000004
#define BF_PXP_IRQ_FIRST_CH0_STORE_IRQ(v)  \
        (((v) << 2) & BM_PXP_IRQ_FIRST_CH0_STORE_IRQ)
#define BM_PXP_IRQ_FIRST_CH1_PREFETCH_IRQ 0x00000002
#define BF_PXP_IRQ_FIRST_CH1_PREFETCH_IRQ(v)  \
        (((v) << 1) & BM_PXP_IRQ_FIRST_CH1_PREFETCH_IRQ)
#define BM_PXP_IRQ_FIRST_CH0_PREFETCH_IRQ 0x00000001
#define BF_PXP_IRQ_FIRST_CH0_PREFETCH_IRQ(v)  \
        (((v) << 0) & BM_PXP_IRQ_FIRST_CH0_PREFETCH_IRQ)

#define HW_PXP_NEXT	(0x00000400)

#define BP_PXP_NEXT_POINTER      2
#define BM_PXP_NEXT_POINTER 0xFFFFFFFC
#define BF_PXP_NEXT_POINTER(v) \
        (((v) << 2) & BM_PXP_NEXT_POINTER)
#define BM_PXP_NEXT_RSVD 0x00000002
#define BF_PXP_NEXT_RSVD(v)  \
        (((v) << 1) & BM_PXP_NEXT_RSVD)
#define BM_PXP_NEXT_ENABLED 0x00000001
#define BF_PXP_NEXT_ENABLED(v)  \
        (((v) << 0) & BM_PXP_NEXT_ENABLED)

#define HW_PXP_DEBUGCTRL	(0x00000410)

#define BP_PXP_DEBUGCTRL_RSVD      12
#define BM_PXP_DEBUGCTRL_RSVD 0xFFFFF000
#define BF_PXP_DEBUGCTRL_RSVD(v) \
        (((v) << 12) & BM_PXP_DEBUGCTRL_RSVD)
#define BP_PXP_DEBUGCTRL_LUT_CLR_STAT_CNT      8
#define BM_PXP_DEBUGCTRL_LUT_CLR_STAT_CNT 0x00000F00
#define BF_PXP_DEBUGCTRL_LUT_CLR_STAT_CNT(v)  \
        (((v) << 8) & BM_PXP_DEBUGCTRL_LUT_CLR_STAT_CNT)
#define BV_PXP_DEBUGCTRL_LUT_CLR_STAT_CNT__NONE     0x0
#define BV_PXP_DEBUGCTRL_LUT_CLR_STAT_CNT__MISS_CNT 0x1
#define BV_PXP_DEBUGCTRL_LUT_CLR_STAT_CNT__HIT_CNT  0x2
#define BV_PXP_DEBUGCTRL_LUT_CLR_STAT_CNT__LAT_CNT  0x4
#define BV_PXP_DEBUGCTRL_LUT_CLR_STAT_CNT__MAX_LAT  0x8
#define BP_PXP_DEBUGCTRL_SELECT      0
#define BM_PXP_DEBUGCTRL_SELECT 0x000000FF
#define BF_PXP_DEBUGCTRL_SELECT(v)  \
        (((v) << 0) & BM_PXP_DEBUGCTRL_SELECT)
#define BV_PXP_DEBUGCTRL_SELECT__NONE        0x0
#define BV_PXP_DEBUGCTRL_SELECT__CTRL        0x1
#define BV_PXP_DEBUGCTRL_SELECT__PSBUF       0x2
#define BV_PXP_DEBUGCTRL_SELECT__PSBAX       0x3
#define BV_PXP_DEBUGCTRL_SELECT__PSBAY       0x4
#define BV_PXP_DEBUGCTRL_SELECT__ASBUF       0x5
#define BV_PXP_DEBUGCTRL_SELECT__ROTATION    0x6
#define BV_PXP_DEBUGCTRL_SELECT__OUTBUF0     0x7
#define BV_PXP_DEBUGCTRL_SELECT__OUTBUF1     0x8
#define BV_PXP_DEBUGCTRL_SELECT__OUTBUF2     0x9
#define BV_PXP_DEBUGCTRL_SELECT__LUT_STAT    0x10
#define BV_PXP_DEBUGCTRL_SELECT__LUT_MISS    0x11
#define BV_PXP_DEBUGCTRL_SELECT__LUT_HIT     0x12
#define BV_PXP_DEBUGCTRL_SELECT__LUT_LAT     0x13
#define BV_PXP_DEBUGCTRL_SELECT__LUT_MAX_LAT 0x14

#define HW_PXP_DEBUG	(0x00000420)

#define BP_PXP_DEBUG_DATA      0
#define BM_PXP_DEBUG_DATA 0xFFFFFFFF
#define BF_PXP_DEBUG_DATA(v)   (v)

#define HW_PXP_VERSION	(0x00000430)

#define BP_PXP_VERSION_MAJOR      24
#define BM_PXP_VERSION_MAJOR 0xFF000000
#define BF_PXP_VERSION_MAJOR(v) \
        (((v) << 24) & BM_PXP_VERSION_MAJOR)
#define BP_PXP_VERSION_MINOR      16
#define BM_PXP_VERSION_MINOR 0x00FF0000
#define BF_PXP_VERSION_MINOR(v)  \
        (((v) << 16) & BM_PXP_VERSION_MINOR)
#define BP_PXP_VERSION_STEP      0
#define BM_PXP_VERSION_STEP 0x0000FFFF
#define BF_PXP_VERSION_STEP(v)  \
        (((v) << 0) & BM_PXP_VERSION_STEP)

#define HW_PXP_INPUT_FETCH_CTRL_CH0	(0x00000450)
#define HW_PXP_INPUT_FETCH_CTRL_CH0_SET	(0x00000454)
#define HW_PXP_INPUT_FETCH_CTRL_CH0_CLR	(0x00000458)
#define HW_PXP_INPUT_FETCH_CTRL_CH0_TOG	(0x0000045c)

#define BM_PXP_INPUT_FETCH_CTRL_CH0_ARBIT_EN 0x80000000
#define BF_PXP_INPUT_FETCH_CTRL_CH0_ARBIT_EN(v) \
        (((v) << 31) & BM_PXP_INPUT_FETCH_CTRL_CH0_ARBIT_EN)
#define BV_PXP_INPUT_FETCH_CTRL_CH0_ARBIT_EN__0 0x0
#define BV_PXP_INPUT_FETCH_CTRL_CH0_ARBIT_EN__1 0x1
#define BP_PXP_INPUT_FETCH_CTRL_CH0_RSVD0      26
#define BM_PXP_INPUT_FETCH_CTRL_CH0_RSVD0 0x7C000000
#define BF_PXP_INPUT_FETCH_CTRL_CH0_RSVD0(v)  \
        (((v) << 26) & BM_PXP_INPUT_FETCH_CTRL_CH0_RSVD0)
#define BP_PXP_INPUT_FETCH_CTRL_CH0_HANDSHAKE_SCAN_LINE_NUM      24
#define BM_PXP_INPUT_FETCH_CTRL_CH0_HANDSHAKE_SCAN_LINE_NUM 0x03000000
#define BF_PXP_INPUT_FETCH_CTRL_CH0_HANDSHAKE_SCAN_LINE_NUM(v)  \
        (((v) << 24) & BM_PXP_INPUT_FETCH_CTRL_CH0_HANDSHAKE_SCAN_LINE_NUM)
#define BV_PXP_INPUT_FETCH_CTRL_CH0_HANDSHAKE_SCAN_LINE_NUM__0 0x0
#define BV_PXP_INPUT_FETCH_CTRL_CH0_HANDSHAKE_SCAN_LINE_NUM__1 0x1
#define BV_PXP_INPUT_FETCH_CTRL_CH0_HANDSHAKE_SCAN_LINE_NUM__2 0x2
#define BV_PXP_INPUT_FETCH_CTRL_CH0_HANDSHAKE_SCAN_LINE_NUM__3 0x3
#define BP_PXP_INPUT_FETCH_CTRL_CH0_RSVD1      18
#define BM_PXP_INPUT_FETCH_CTRL_CH0_RSVD1 0x00FC0000
#define BF_PXP_INPUT_FETCH_CTRL_CH0_RSVD1(v)  \
        (((v) << 18) & BM_PXP_INPUT_FETCH_CTRL_CH0_RSVD1)
#define BP_PXP_INPUT_FETCH_CTRL_CH0_RD_NUM_BYTES      16
#define BM_PXP_INPUT_FETCH_CTRL_CH0_RD_NUM_BYTES 0x00030000
#define BF_PXP_INPUT_FETCH_CTRL_CH0_RD_NUM_BYTES(v)  \
        (((v) << 16) & BM_PXP_INPUT_FETCH_CTRL_CH0_RD_NUM_BYTES)
#define BV_PXP_INPUT_FETCH_CTRL_CH0_RD_NUM_BYTES__8_bytes  0x0
#define BV_PXP_INPUT_FETCH_CTRL_CH0_RD_NUM_BYTES__16_bytes 0x1
#define BV_PXP_INPUT_FETCH_CTRL_CH0_RD_NUM_BYTES__32_bytes 0x2
#define BV_PXP_INPUT_FETCH_CTRL_CH0_RD_NUM_BYTES__64_bytes 0x3
#define BP_PXP_INPUT_FETCH_CTRL_CH0_RSVD2      14
#define BM_PXP_INPUT_FETCH_CTRL_CH0_RSVD2 0x0000C000
#define BF_PXP_INPUT_FETCH_CTRL_CH0_RSVD2(v)  \
        (((v) << 14) & BM_PXP_INPUT_FETCH_CTRL_CH0_RSVD2)
#define BP_PXP_INPUT_FETCH_CTRL_CH0_ROTATION_ANGLE      12
#define BM_PXP_INPUT_FETCH_CTRL_CH0_ROTATION_ANGLE 0x00003000
#define BF_PXP_INPUT_FETCH_CTRL_CH0_ROTATION_ANGLE(v)  \
        (((v) << 12) & BM_PXP_INPUT_FETCH_CTRL_CH0_ROTATION_ANGLE)
#define BV_PXP_INPUT_FETCH_CTRL_CH0_ROTATION_ANGLE__ROT_0   0x0
#define BV_PXP_INPUT_FETCH_CTRL_CH0_ROTATION_ANGLE__ROT_90  0x1
#define BV_PXP_INPUT_FETCH_CTRL_CH0_ROTATION_ANGLE__ROT_180 0x2
#define BV_PXP_INPUT_FETCH_CTRL_CH0_ROTATION_ANGLE__ROT_270 0x3
#define BM_PXP_INPUT_FETCH_CTRL_CH0_RSVD3 0x00000800
#define BF_PXP_INPUT_FETCH_CTRL_CH0_RSVD3(v)  \
        (((v) << 11) & BM_PXP_INPUT_FETCH_CTRL_CH0_RSVD3)
#define BM_PXP_INPUT_FETCH_CTRL_CH0_VFLIP 0x00000400
#define BF_PXP_INPUT_FETCH_CTRL_CH0_VFLIP(v)  \
        (((v) << 10) & BM_PXP_INPUT_FETCH_CTRL_CH0_VFLIP)
#define BV_PXP_INPUT_FETCH_CTRL_CH0_VFLIP__0 0x0
#define BV_PXP_INPUT_FETCH_CTRL_CH0_VFLIP__1 0x1
#define BM_PXP_INPUT_FETCH_CTRL_CH0_HFLIP 0x00000200
#define BF_PXP_INPUT_FETCH_CTRL_CH0_HFLIP(v)  \
        (((v) << 9) & BM_PXP_INPUT_FETCH_CTRL_CH0_HFLIP)
#define BV_PXP_INPUT_FETCH_CTRL_CH0_HFLIP__0 0x0
#define BV_PXP_INPUT_FETCH_CTRL_CH0_HFLIP__1 0x1
#define BP_PXP_INPUT_FETCH_CTRL_CH0_RSVD4      6
#define BM_PXP_INPUT_FETCH_CTRL_CH0_RSVD4 0x000001C0
#define BF_PXP_INPUT_FETCH_CTRL_CH0_RSVD4(v)  \
        (((v) << 6) & BM_PXP_INPUT_FETCH_CTRL_CH0_RSVD4)
#define BM_PXP_INPUT_FETCH_CTRL_CH0_HIGH_BYTE 0x00000020
#define BF_PXP_INPUT_FETCH_CTRL_CH0_HIGH_BYTE(v)  \
        (((v) << 5) & BM_PXP_INPUT_FETCH_CTRL_CH0_HIGH_BYTE)
#define BV_PXP_INPUT_FETCH_CTRL_CH0_HIGH_BYTE__0 0x0
#define BV_PXP_INPUT_FETCH_CTRL_CH0_HIGH_BYTE__1 0x1
#define BM_PXP_INPUT_FETCH_CTRL_CH0_BYPASS_PIXEL_EN 0x00000010
#define BF_PXP_INPUT_FETCH_CTRL_CH0_BYPASS_PIXEL_EN(v)  \
        (((v) << 4) & BM_PXP_INPUT_FETCH_CTRL_CH0_BYPASS_PIXEL_EN)
#define BV_PXP_INPUT_FETCH_CTRL_CH0_BYPASS_PIXEL_EN__0 0x0
#define BV_PXP_INPUT_FETCH_CTRL_CH0_BYPASS_PIXEL_EN__1 0x1
#define BM_PXP_INPUT_FETCH_CTRL_CH0_HANDSHAKE_EN 0x00000008
#define BF_PXP_INPUT_FETCH_CTRL_CH0_HANDSHAKE_EN(v)  \
        (((v) << 3) & BM_PXP_INPUT_FETCH_CTRL_CH0_HANDSHAKE_EN)
#define BV_PXP_INPUT_FETCH_CTRL_CH0_HANDSHAKE_EN__0 0x0
#define BV_PXP_INPUT_FETCH_CTRL_CH0_HANDSHAKE_EN__1 0x1
#define BM_PXP_INPUT_FETCH_CTRL_CH0_BLOCK_16 0x00000004
#define BF_PXP_INPUT_FETCH_CTRL_CH0_BLOCK_16(v)  \
        (((v) << 2) & BM_PXP_INPUT_FETCH_CTRL_CH0_BLOCK_16)
#define BV_PXP_INPUT_FETCH_CTRL_CH0_BLOCK_16__8x8   0x0
#define BV_PXP_INPUT_FETCH_CTRL_CH0_BLOCK_16__16x16 0x1
#define BM_PXP_INPUT_FETCH_CTRL_CH0_BLOCK_EN 0x00000002
#define BF_PXP_INPUT_FETCH_CTRL_CH0_BLOCK_EN(v)  \
        (((v) << 1) & BM_PXP_INPUT_FETCH_CTRL_CH0_BLOCK_EN)
#define BV_PXP_INPUT_FETCH_CTRL_CH0_BLOCK_EN__0 0x0
#define BV_PXP_INPUT_FETCH_CTRL_CH0_BLOCK_EN__1 0x1
#define BM_PXP_INPUT_FETCH_CTRL_CH0_CH_EN 0x00000001
#define BF_PXP_INPUT_FETCH_CTRL_CH0_CH_EN(v)  \
        (((v) << 0) & BM_PXP_INPUT_FETCH_CTRL_CH0_CH_EN)
#define BV_PXP_INPUT_FETCH_CTRL_CH0_CH_EN__0 0x0
#define BV_PXP_INPUT_FETCH_CTRL_CH0_CH_EN__1 0x1

#define HW_PXP_INPUT_FETCH_CTRL_CH1	(0x00000460)
#define HW_PXP_INPUT_FETCH_CTRL_CH1_SET	(0x00000464)
#define HW_PXP_INPUT_FETCH_CTRL_CH1_CLR	(0x00000468)
#define HW_PXP_INPUT_FETCH_CTRL_CH1_TOG	(0x0000046c)

#define BP_PXP_INPUT_FETCH_CTRL_CH1_RSVD0      26
#define BM_PXP_INPUT_FETCH_CTRL_CH1_RSVD0 0xFC000000
#define BF_PXP_INPUT_FETCH_CTRL_CH1_RSVD0(v) \
        (((v) << 26) & BM_PXP_INPUT_FETCH_CTRL_CH1_RSVD0)
#define BP_PXP_INPUT_FETCH_CTRL_CH1_HANDSHAKE_SCAN_LINE_NUM      24
#define BM_PXP_INPUT_FETCH_CTRL_CH1_HANDSHAKE_SCAN_LINE_NUM 0x03000000
#define BF_PXP_INPUT_FETCH_CTRL_CH1_HANDSHAKE_SCAN_LINE_NUM(v)  \
        (((v) << 24) & BM_PXP_INPUT_FETCH_CTRL_CH1_HANDSHAKE_SCAN_LINE_NUM)
#define BV_PXP_INPUT_FETCH_CTRL_CH1_HANDSHAKE_SCAN_LINE_NUM__0 0x0
#define BV_PXP_INPUT_FETCH_CTRL_CH1_HANDSHAKE_SCAN_LINE_NUM__1 0x1
#define BV_PXP_INPUT_FETCH_CTRL_CH1_HANDSHAKE_SCAN_LINE_NUM__2 0x2
#define BV_PXP_INPUT_FETCH_CTRL_CH1_HANDSHAKE_SCAN_LINE_NUM__3 0x3
#define BP_PXP_INPUT_FETCH_CTRL_CH1_RSVD1      18
#define BM_PXP_INPUT_FETCH_CTRL_CH1_RSVD1 0x00FC0000
#define BF_PXP_INPUT_FETCH_CTRL_CH1_RSVD1(v)  \
        (((v) << 18) & BM_PXP_INPUT_FETCH_CTRL_CH1_RSVD1)
#define BP_PXP_INPUT_FETCH_CTRL_CH1_RD_NUM_BYTES      16
#define BM_PXP_INPUT_FETCH_CTRL_CH1_RD_NUM_BYTES 0x00030000
#define BF_PXP_INPUT_FETCH_CTRL_CH1_RD_NUM_BYTES(v)  \
        (((v) << 16) & BM_PXP_INPUT_FETCH_CTRL_CH1_RD_NUM_BYTES)
#define BV_PXP_INPUT_FETCH_CTRL_CH1_RD_NUM_BYTES__8_bytes  0x0
#define BV_PXP_INPUT_FETCH_CTRL_CH1_RD_NUM_BYTES__16_bytes 0x1
#define BV_PXP_INPUT_FETCH_CTRL_CH1_RD_NUM_BYTES__32_bytes 0x2
#define BV_PXP_INPUT_FETCH_CTRL_CH1_RD_NUM_BYTES__64_bytes 0x3
#define BP_PXP_INPUT_FETCH_CTRL_CH1_RSVD2      14
#define BM_PXP_INPUT_FETCH_CTRL_CH1_RSVD2 0x0000C000
#define BF_PXP_INPUT_FETCH_CTRL_CH1_RSVD2(v)  \
        (((v) << 14) & BM_PXP_INPUT_FETCH_CTRL_CH1_RSVD2)
#define BP_PXP_INPUT_FETCH_CTRL_CH1_ROTATION_ANGLE      12
#define BM_PXP_INPUT_FETCH_CTRL_CH1_ROTATION_ANGLE 0x00003000
#define BF_PXP_INPUT_FETCH_CTRL_CH1_ROTATION_ANGLE(v)  \
        (((v) << 12) & BM_PXP_INPUT_FETCH_CTRL_CH1_ROTATION_ANGLE)
#define BV_PXP_INPUT_FETCH_CTRL_CH1_ROTATION_ANGLE__ROT_0   0x0
#define BV_PXP_INPUT_FETCH_CTRL_CH1_ROTATION_ANGLE__ROT_90  0x1
#define BV_PXP_INPUT_FETCH_CTRL_CH1_ROTATION_ANGLE__ROT_180 0x2
#define BV_PXP_INPUT_FETCH_CTRL_CH1_ROTATION_ANGLE__ROT_270 0x3
#define BM_PXP_INPUT_FETCH_CTRL_CH1_RSVD3 0x00000800
#define BF_PXP_INPUT_FETCH_CTRL_CH1_RSVD3(v)  \
        (((v) << 11) & BM_PXP_INPUT_FETCH_CTRL_CH1_RSVD3)
#define BM_PXP_INPUT_FETCH_CTRL_CH1_VFLIP 0x00000400
#define BF_PXP_INPUT_FETCH_CTRL_CH1_VFLIP(v)  \
        (((v) << 10) & BM_PXP_INPUT_FETCH_CTRL_CH1_VFLIP)
#define BV_PXP_INPUT_FETCH_CTRL_CH1_VFLIP__0 0x0
#define BV_PXP_INPUT_FETCH_CTRL_CH1_VFLIP__1 0x1
#define BM_PXP_INPUT_FETCH_CTRL_CH1_HFLIP 0x00000200
#define BF_PXP_INPUT_FETCH_CTRL_CH1_HFLIP(v)  \
        (((v) << 9) & BM_PXP_INPUT_FETCH_CTRL_CH1_HFLIP)
#define BV_PXP_INPUT_FETCH_CTRL_CH1_HFLIP__0 0x0
#define BV_PXP_INPUT_FETCH_CTRL_CH1_HFLIP__1 0x1
#define BP_PXP_INPUT_FETCH_CTRL_CH1_RSVD4      5
#define BM_PXP_INPUT_FETCH_CTRL_CH1_RSVD4 0x000001E0
#define BF_PXP_INPUT_FETCH_CTRL_CH1_RSVD4(v)  \
        (((v) << 5) & BM_PXP_INPUT_FETCH_CTRL_CH1_RSVD4)
#define BM_PXP_INPUT_FETCH_CTRL_CH1_BYPASS_PIXEL_EN 0x00000010
#define BF_PXP_INPUT_FETCH_CTRL_CH1_BYPASS_PIXEL_EN(v)  \
        (((v) << 4) & BM_PXP_INPUT_FETCH_CTRL_CH1_BYPASS_PIXEL_EN)
#define BV_PXP_INPUT_FETCH_CTRL_CH1_BYPASS_PIXEL_EN__0 0x0
#define BV_PXP_INPUT_FETCH_CTRL_CH1_BYPASS_PIXEL_EN__1 0x1
#define BM_PXP_INPUT_FETCH_CTRL_CH1_HANDSHAKE_EN 0x00000008
#define BF_PXP_INPUT_FETCH_CTRL_CH1_HANDSHAKE_EN(v)  \
        (((v) << 3) & BM_PXP_INPUT_FETCH_CTRL_CH1_HANDSHAKE_EN)
#define BV_PXP_INPUT_FETCH_CTRL_CH1_HANDSHAKE_EN__0 0x0
#define BV_PXP_INPUT_FETCH_CTRL_CH1_HANDSHAKE_EN__1 0x1
#define BM_PXP_INPUT_FETCH_CTRL_CH1_BLOCK_16 0x00000004
#define BF_PXP_INPUT_FETCH_CTRL_CH1_BLOCK_16(v)  \
        (((v) << 2) & BM_PXP_INPUT_FETCH_CTRL_CH1_BLOCK_16)
#define BV_PXP_INPUT_FETCH_CTRL_CH1_BLOCK_16__8x8   0x0
#define BV_PXP_INPUT_FETCH_CTRL_CH1_BLOCK_16__16x16 0x1
#define BM_PXP_INPUT_FETCH_CTRL_CH1_BLOCK_EN 0x00000002
#define BF_PXP_INPUT_FETCH_CTRL_CH1_BLOCK_EN(v)  \
        (((v) << 1) & BM_PXP_INPUT_FETCH_CTRL_CH1_BLOCK_EN)
#define BV_PXP_INPUT_FETCH_CTRL_CH1_BLOCK_EN__0 0x0
#define BV_PXP_INPUT_FETCH_CTRL_CH1_BLOCK_EN__1 0x1
#define BM_PXP_INPUT_FETCH_CTRL_CH1_CH_EN 0x00000001
#define BF_PXP_INPUT_FETCH_CTRL_CH1_CH_EN(v)  \
        (((v) << 0) & BM_PXP_INPUT_FETCH_CTRL_CH1_CH_EN)
#define BV_PXP_INPUT_FETCH_CTRL_CH1_CH_EN__0 0x0
#define BV_PXP_INPUT_FETCH_CTRL_CH1_CH_EN__1 0x1

#define HW_PXP_INPUT_FETCH_STATUS_CH0	(0x00000470)

#define BP_PXP_INPUT_FETCH_STATUS_CH0_PREFETCH_BLOCK_Y      16
#define BM_PXP_INPUT_FETCH_STATUS_CH0_PREFETCH_BLOCK_Y 0xFFFF0000
#define BF_PXP_INPUT_FETCH_STATUS_CH0_PREFETCH_BLOCK_Y(v) \
        (((v) << 16) & BM_PXP_INPUT_FETCH_STATUS_CH0_PREFETCH_BLOCK_Y)
#define BP_PXP_INPUT_FETCH_STATUS_CH0_PREFETCH_BLOCK_X      0
#define BM_PXP_INPUT_FETCH_STATUS_CH0_PREFETCH_BLOCK_X 0x0000FFFF
#define BF_PXP_INPUT_FETCH_STATUS_CH0_PREFETCH_BLOCK_X(v)  \
        (((v) << 0) & BM_PXP_INPUT_FETCH_STATUS_CH0_PREFETCH_BLOCK_X)

#define HW_PXP_INPUT_FETCH_STATUS_CH1	(0x00000480)

#define BP_PXP_INPUT_FETCH_STATUS_CH1_PREFETCH_BLOCK_Y      16
#define BM_PXP_INPUT_FETCH_STATUS_CH1_PREFETCH_BLOCK_Y 0xFFFF0000
#define BF_PXP_INPUT_FETCH_STATUS_CH1_PREFETCH_BLOCK_Y(v) \
        (((v) << 16) & BM_PXP_INPUT_FETCH_STATUS_CH1_PREFETCH_BLOCK_Y)
#define BP_PXP_INPUT_FETCH_STATUS_CH1_PREFETCH_BLOCK_X      0
#define BM_PXP_INPUT_FETCH_STATUS_CH1_PREFETCH_BLOCK_X 0x0000FFFF
#define BF_PXP_INPUT_FETCH_STATUS_CH1_PREFETCH_BLOCK_X(v)  \
        (((v) << 0) & BM_PXP_INPUT_FETCH_STATUS_CH1_PREFETCH_BLOCK_X)

#define HW_PXP_INPUT_FETCH_ACTIVE_SIZE_ULC_CH0	(0x00000490)

#define BP_PXP_INPUT_FETCH_ACTIVE_SIZE_ULC_CH0_ACTIVE_SIZE_ULC_Y      16
#define BM_PXP_INPUT_FETCH_ACTIVE_SIZE_ULC_CH0_ACTIVE_SIZE_ULC_Y 0xFFFF0000
#define BF_PXP_INPUT_FETCH_ACTIVE_SIZE_ULC_CH0_ACTIVE_SIZE_ULC_Y(v) \
        (((v) << 16) & BM_PXP_INPUT_FETCH_ACTIVE_SIZE_ULC_CH0_ACTIVE_SIZE_ULC_Y)
#define BP_PXP_INPUT_FETCH_ACTIVE_SIZE_ULC_CH0_ACTIVE_SIZE_ULC_X      0
#define BM_PXP_INPUT_FETCH_ACTIVE_SIZE_ULC_CH0_ACTIVE_SIZE_ULC_X 0x0000FFFF
#define BF_PXP_INPUT_FETCH_ACTIVE_SIZE_ULC_CH0_ACTIVE_SIZE_ULC_X(v)  \
        (((v) << 0) & BM_PXP_INPUT_FETCH_ACTIVE_SIZE_ULC_CH0_ACTIVE_SIZE_ULC_X)

#define HW_PXP_INPUT_FETCH_ACTIVE_SIZE_LRC_CH0	(0x000004a0)

#define BP_PXP_INPUT_FETCH_ACTIVE_SIZE_LRC_CH0_ACTIVE_SIZE_LRC_Y      16
#define BM_PXP_INPUT_FETCH_ACTIVE_SIZE_LRC_CH0_ACTIVE_SIZE_LRC_Y 0xFFFF0000
#define BF_PXP_INPUT_FETCH_ACTIVE_SIZE_LRC_CH0_ACTIVE_SIZE_LRC_Y(v) \
        (((v) << 16) & BM_PXP_INPUT_FETCH_ACTIVE_SIZE_LRC_CH0_ACTIVE_SIZE_LRC_Y)
#define BP_PXP_INPUT_FETCH_ACTIVE_SIZE_LRC_CH0_ACTIVE_SIZE_LRC_X      0
#define BM_PXP_INPUT_FETCH_ACTIVE_SIZE_LRC_CH0_ACTIVE_SIZE_LRC_X 0x0000FFFF
#define BF_PXP_INPUT_FETCH_ACTIVE_SIZE_LRC_CH0_ACTIVE_SIZE_LRC_X(v)  \
        (((v) << 0) & BM_PXP_INPUT_FETCH_ACTIVE_SIZE_LRC_CH0_ACTIVE_SIZE_LRC_X)

#define HW_PXP_INPUT_FETCH_ACTIVE_SIZE_ULC_CH1	(0x000004b0)

#define BP_PXP_INPUT_FETCH_ACTIVE_SIZE_ULC_CH1_ACTIVE_SIZE_ULC_Y      16
#define BM_PXP_INPUT_FETCH_ACTIVE_SIZE_ULC_CH1_ACTIVE_SIZE_ULC_Y 0xFFFF0000
#define BF_PXP_INPUT_FETCH_ACTIVE_SIZE_ULC_CH1_ACTIVE_SIZE_ULC_Y(v) \
        (((v) << 16) & BM_PXP_INPUT_FETCH_ACTIVE_SIZE_ULC_CH1_ACTIVE_SIZE_ULC_Y)
#define BP_PXP_INPUT_FETCH_ACTIVE_SIZE_ULC_CH1_ACTIVE_SIZE_ULC_X      0
#define BM_PXP_INPUT_FETCH_ACTIVE_SIZE_ULC_CH1_ACTIVE_SIZE_ULC_X 0x0000FFFF
#define BF_PXP_INPUT_FETCH_ACTIVE_SIZE_ULC_CH1_ACTIVE_SIZE_ULC_X(v)  \
        (((v) << 0) & BM_PXP_INPUT_FETCH_ACTIVE_SIZE_ULC_CH1_ACTIVE_SIZE_ULC_X)

#define HW_PXP_INPUT_FETCH_ACTIVE_SIZE_LRC_CH1	(0x000004c0)

#define BP_PXP_INPUT_FETCH_ACTIVE_SIZE_LRC_CH1_ACTIVE_SIZE_LRC_Y      16
#define BM_PXP_INPUT_FETCH_ACTIVE_SIZE_LRC_CH1_ACTIVE_SIZE_LRC_Y 0xFFFF0000
#define BF_PXP_INPUT_FETCH_ACTIVE_SIZE_LRC_CH1_ACTIVE_SIZE_LRC_Y(v) \
        (((v) << 16) & BM_PXP_INPUT_FETCH_ACTIVE_SIZE_LRC_CH1_ACTIVE_SIZE_LRC_Y)
#define BP_PXP_INPUT_FETCH_ACTIVE_SIZE_LRC_CH1_ACTIVE_SIZE_LRC_X      0
#define BM_PXP_INPUT_FETCH_ACTIVE_SIZE_LRC_CH1_ACTIVE_SIZE_LRC_X 0x0000FFFF
#define BF_PXP_INPUT_FETCH_ACTIVE_SIZE_LRC_CH1_ACTIVE_SIZE_LRC_X(v)  \
        (((v) << 0) & BM_PXP_INPUT_FETCH_ACTIVE_SIZE_LRC_CH1_ACTIVE_SIZE_LRC_X)

#define HW_PXP_INPUT_FETCH_SIZE_CH0	(0x000004d0)

#define BP_PXP_INPUT_FETCH_SIZE_CH0_INPUT_TOTAL_HEIGHT      16
#define BM_PXP_INPUT_FETCH_SIZE_CH0_INPUT_TOTAL_HEIGHT 0xFFFF0000
#define BF_PXP_INPUT_FETCH_SIZE_CH0_INPUT_TOTAL_HEIGHT(v) \
        (((v) << 16) & BM_PXP_INPUT_FETCH_SIZE_CH0_INPUT_TOTAL_HEIGHT)
#define BP_PXP_INPUT_FETCH_SIZE_CH0_INPUT_TOTAL_WIDTH      0
#define BM_PXP_INPUT_FETCH_SIZE_CH0_INPUT_TOTAL_WIDTH 0x0000FFFF
#define BF_PXP_INPUT_FETCH_SIZE_CH0_INPUT_TOTAL_WIDTH(v)  \
        (((v) << 0) & BM_PXP_INPUT_FETCH_SIZE_CH0_INPUT_TOTAL_WIDTH)

#define HW_PXP_INPUT_FETCH_SIZE_CH1	(0x000004e0)

#define BP_PXP_INPUT_FETCH_SIZE_CH1_INPUT_TOTAL_HEIGHT      16
#define BM_PXP_INPUT_FETCH_SIZE_CH1_INPUT_TOTAL_HEIGHT 0xFFFF0000
#define BF_PXP_INPUT_FETCH_SIZE_CH1_INPUT_TOTAL_HEIGHT(v) \
        (((v) << 16) & BM_PXP_INPUT_FETCH_SIZE_CH1_INPUT_TOTAL_HEIGHT)
#define BP_PXP_INPUT_FETCH_SIZE_CH1_INPUT_TOTAL_WIDTH      0
#define BM_PXP_INPUT_FETCH_SIZE_CH1_INPUT_TOTAL_WIDTH 0x0000FFFF
#define BF_PXP_INPUT_FETCH_SIZE_CH1_INPUT_TOTAL_WIDTH(v)  \
        (((v) << 0) & BM_PXP_INPUT_FETCH_SIZE_CH1_INPUT_TOTAL_WIDTH)

#define HW_PXP_INPUT_FETCH_BACKGROUND_COLOR_CH0	(0x000004f0)

#define BP_PXP_INPUT_FETCH_BACKGROUND_COLOR_CH0_BACKGROUND_COLOR      0
#define BM_PXP_INPUT_FETCH_BACKGROUND_COLOR_CH0_BACKGROUND_COLOR 0xFFFFFFFF
#define BF_PXP_INPUT_FETCH_BACKGROUND_COLOR_CH0_BACKGROUND_COLOR(v)   (v)

#define HW_PXP_INPUT_FETCH_BACKGROUND_COLOR_CH1	(0x00000500)

#define BP_PXP_INPUT_FETCH_BACKGROUND_COLOR_CH1_BACKGROUND_COLOR      0
#define BM_PXP_INPUT_FETCH_BACKGROUND_COLOR_CH1_BACKGROUND_COLOR 0xFFFFFFFF
#define BF_PXP_INPUT_FETCH_BACKGROUND_COLOR_CH1_BACKGROUND_COLOR(v)   (v)

#define HW_PXP_INPUT_FETCH_PITCH	(0x00000510)

#define BP_PXP_INPUT_FETCH_PITCH_CH1_INPUT_PITCH      16
#define BM_PXP_INPUT_FETCH_PITCH_CH1_INPUT_PITCH 0xFFFF0000
#define BF_PXP_INPUT_FETCH_PITCH_CH1_INPUT_PITCH(v) \
        (((v) << 16) & BM_PXP_INPUT_FETCH_PITCH_CH1_INPUT_PITCH)
#define BP_PXP_INPUT_FETCH_PITCH_CH0_INPUT_PITCH      0
#define BM_PXP_INPUT_FETCH_PITCH_CH0_INPUT_PITCH 0x0000FFFF
#define BF_PXP_INPUT_FETCH_PITCH_CH0_INPUT_PITCH(v)  \
        (((v) << 0) & BM_PXP_INPUT_FETCH_PITCH_CH0_INPUT_PITCH)

#define HW_PXP_INPUT_FETCH_SHIFT_CTRL_CH0	(0x00000520)
#define HW_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_SET	(0x00000524)
#define HW_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_CLR	(0x00000528)
#define HW_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_TOG	(0x0000052c)

#define BP_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_RSVD0      13
#define BM_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_RSVD0 0xFFFFE000
#define BF_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_RSVD0(v) \
        (((v) << 13) & BM_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_RSVD0)
#define BM_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_SHIFT_BYPASS 0x00001000
#define BF_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_SHIFT_BYPASS(v)  \
        (((v) << 12) & BM_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_SHIFT_BYPASS)
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_SHIFT_BYPASS__0 0x0
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_SHIFT_BYPASS__1 0x1
#define BM_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_EXPAND_EN 0x00000800
#define BF_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_EXPAND_EN(v)  \
        (((v) << 11) & BM_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_EXPAND_EN)
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_EXPAND_EN__0 0x0
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_EXPAND_EN__1 0x1
#define BP_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_EXPAND_FORMAT      8
#define BM_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_EXPAND_FORMAT 0x00000700
#define BF_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_EXPAND_FORMAT(v)  \
        (((v) << 8) & BM_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_EXPAND_FORMAT)
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_EXPAND_FORMAT__0 0x0
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_EXPAND_FORMAT__1 0x1
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_EXPAND_FORMAT__2 0x2
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_EXPAND_FORMAT__3 0x3
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_EXPAND_FORMAT__4 0x4
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_EXPAND_FORMAT__5 0x5
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_EXPAND_FORMAT__6 0x6
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_EXPAND_FORMAT__7 0x7
#define BP_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_RSVD1      2
#define BM_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_RSVD1 0x000000FC
#define BF_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_RSVD1(v)  \
        (((v) << 2) & BM_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_RSVD1)
#define BP_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_INPUT_ACTIVE_BPP      0
#define BM_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_INPUT_ACTIVE_BPP 0x00000003
#define BF_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_INPUT_ACTIVE_BPP(v)  \
        (((v) << 0) & BM_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_INPUT_ACTIVE_BPP)
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_INPUT_ACTIVE_BPP__0 0x0
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_INPUT_ACTIVE_BPP__1 0x1
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_INPUT_ACTIVE_BPP__2 0x2
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH0_INPUT_ACTIVE_BPP__3 0x3

#define HW_PXP_INPUT_FETCH_SHIFT_CTRL_CH1	(0x00000530)
#define HW_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_SET	(0x00000534)
#define HW_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_CLR	(0x00000538)
#define HW_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_TOG	(0x0000053c)

#define BP_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_RSVD0      13
#define BM_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_RSVD0 0xFFFFE000
#define BF_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_RSVD0(v) \
        (((v) << 13) & BM_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_RSVD0)
#define BM_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_SHIFT_BYPASS 0x00001000
#define BF_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_SHIFT_BYPASS(v)  \
        (((v) << 12) & BM_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_SHIFT_BYPASS)
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_SHIFT_BYPASS__0 0x0
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_SHIFT_BYPASS__1 0x1
#define BM_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_EXPAND_EN 0x00000800
#define BF_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_EXPAND_EN(v)  \
        (((v) << 11) & BM_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_EXPAND_EN)
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_EXPAND_EN__0 0x0
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_EXPAND_EN__1 0x1
#define BP_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_EXPAND_FORMAT      8
#define BM_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_EXPAND_FORMAT 0x00000700
#define BF_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_EXPAND_FORMAT(v)  \
        (((v) << 8) & BM_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_EXPAND_FORMAT)
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_EXPAND_FORMAT__0 0x0
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_EXPAND_FORMAT__1 0x1
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_EXPAND_FORMAT__2 0x2
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_EXPAND_FORMAT__3 0x3
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_EXPAND_FORMAT__4 0x4
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_EXPAND_FORMAT__5 0x5
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_EXPAND_FORMAT__6 0x6
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_EXPAND_FORMAT__7 0x7
#define BP_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_RSVD1      2
#define BM_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_RSVD1 0x000000FC
#define BF_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_RSVD1(v)  \
        (((v) << 2) & BM_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_RSVD1)
#define BP_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_INPUT_ACTIVE_BPP      0
#define BM_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_INPUT_ACTIVE_BPP 0x00000003
#define BF_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_INPUT_ACTIVE_BPP(v)  \
        (((v) << 0) & BM_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_INPUT_ACTIVE_BPP)
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_INPUT_ACTIVE_BPP__0 0x0
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_INPUT_ACTIVE_BPP__1 0x1
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_INPUT_ACTIVE_BPP__2 0x2
#define BV_PXP_INPUT_FETCH_SHIFT_CTRL_CH1_INPUT_ACTIVE_BPP__3 0x3

#define HW_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0	(0x00000540)
#define HW_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_SET	(0x00000544)
#define HW_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_CLR	(0x00000548)
#define HW_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_TOG	(0x0000054c)

#define BP_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_RSVD0      29
#define BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_RSVD0 0xE0000000
#define BF_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_RSVD0(v) \
        (((v) << 29) & BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_RSVD0)
#define BP_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_OFFSET3      24
#define BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_OFFSET3 0x1F000000
#define BF_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_OFFSET3(v)  \
        (((v) << 24) & BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_OFFSET3)
#define BP_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_RSVD1      21
#define BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_RSVD1 0x00E00000
#define BF_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_RSVD1(v)  \
        (((v) << 21) & BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_RSVD1)
#define BP_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_OFFSET2      16
#define BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_OFFSET2 0x001F0000
#define BF_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_OFFSET2(v)  \
        (((v) << 16) & BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_OFFSET2)
#define BP_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_RSVD2      13
#define BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_RSVD2 0x0000E000
#define BF_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_RSVD2(v)  \
        (((v) << 13) & BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_RSVD2)
#define BP_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_OFFSET1      8
#define BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_OFFSET1 0x00001F00
#define BF_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_OFFSET1(v)  \
        (((v) << 8) & BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_OFFSET1)
#define BP_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_RSVD3      5
#define BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_RSVD3 0x000000E0
#define BF_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_RSVD3(v)  \
        (((v) << 5) & BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_RSVD3)
#define BP_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_OFFSET0      0
#define BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_OFFSET0 0x0000001F
#define BF_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_OFFSET0(v)  \
        (((v) << 0) & BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH0_OFFSET0)

#define HW_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1	(0x00000550)
#define HW_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_SET	(0x00000554)
#define HW_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_CLR	(0x00000558)
#define HW_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_TOG	(0x0000055c)

#define BP_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_RSVD0      29
#define BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_RSVD0 0xE0000000
#define BF_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_RSVD0(v) \
        (((v) << 29) & BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_RSVD0)
#define BP_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_OFFSET3      24
#define BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_OFFSET3 0x1F000000
#define BF_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_OFFSET3(v)  \
        (((v) << 24) & BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_OFFSET3)
#define BP_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_RSVD1      21
#define BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_RSVD1 0x00E00000
#define BF_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_RSVD1(v)  \
        (((v) << 21) & BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_RSVD1)
#define BP_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_OFFSET2      16
#define BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_OFFSET2 0x001F0000
#define BF_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_OFFSET2(v)  \
        (((v) << 16) & BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_OFFSET2)
#define BP_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_RSVD2      13
#define BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_RSVD2 0x0000E000
#define BF_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_RSVD2(v)  \
        (((v) << 13) & BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_RSVD2)
#define BP_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_OFFSET1      8
#define BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_OFFSET1 0x00001F00
#define BF_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_OFFSET1(v)  \
        (((v) << 8) & BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_OFFSET1)
#define BP_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_RSVD3      5
#define BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_RSVD3 0x000000E0
#define BF_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_RSVD3(v)  \
        (((v) << 5) & BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_RSVD3)
#define BP_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_OFFSET0      0
#define BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_OFFSET0 0x0000001F
#define BF_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_OFFSET0(v)  \
        (((v) << 0) & BM_PXP_INPUT_FETCH_SHIFT_OFFSET_CH1_OFFSET0)

#define HW_PXP_INPUT_FETCH_SHIFT_WIDTH_CH0	(0x00000560)
#define HW_PXP_INPUT_FETCH_SHIFT_WIDTH_CH0_SET	(0x00000564)
#define HW_PXP_INPUT_FETCH_SHIFT_WIDTH_CH0_CLR	(0x00000568)
#define HW_PXP_INPUT_FETCH_SHIFT_WIDTH_CH0_TOG	(0x0000056c)

#define BP_PXP_INPUT_FETCH_SHIFT_WIDTH_CH0_RSVD0      16
#define BM_PXP_INPUT_FETCH_SHIFT_WIDTH_CH0_RSVD0 0xFFFF0000
#define BF_PXP_INPUT_FETCH_SHIFT_WIDTH_CH0_RSVD0(v) \
        (((v) << 16) & BM_PXP_INPUT_FETCH_SHIFT_WIDTH_CH0_RSVD0)
#define BP_PXP_INPUT_FETCH_SHIFT_WIDTH_CH0_WIDTH3      12
#define BM_PXP_INPUT_FETCH_SHIFT_WIDTH_CH0_WIDTH3 0x0000F000
#define BF_PXP_INPUT_FETCH_SHIFT_WIDTH_CH0_WIDTH3(v)  \
        (((v) << 12) & BM_PXP_INPUT_FETCH_SHIFT_WIDTH_CH0_WIDTH3)
#define BP_PXP_INPUT_FETCH_SHIFT_WIDTH_CH0_WIDTH2      8
#define BM_PXP_INPUT_FETCH_SHIFT_WIDTH_CH0_WIDTH2 0x00000F00
#define BF_PXP_INPUT_FETCH_SHIFT_WIDTH_CH0_WIDTH2(v)  \
        (((v) << 8) & BM_PXP_INPUT_FETCH_SHIFT_WIDTH_CH0_WIDTH2)
#define BP_PXP_INPUT_FETCH_SHIFT_WIDTH_CH0_WIDTH1      4
#define BM_PXP_INPUT_FETCH_SHIFT_WIDTH_CH0_WIDTH1 0x000000F0
#define BF_PXP_INPUT_FETCH_SHIFT_WIDTH_CH0_WIDTH1(v)  \
        (((v) << 4) & BM_PXP_INPUT_FETCH_SHIFT_WIDTH_CH0_WIDTH1)
#define BP_PXP_INPUT_FETCH_SHIFT_WIDTH_CH0_WIDTH0      0
#define BM_PXP_INPUT_FETCH_SHIFT_WIDTH_CH0_WIDTH0 0x0000000F
#define BF_PXP_INPUT_FETCH_SHIFT_WIDTH_CH0_WIDTH0(v)  \
        (((v) << 0) & BM_PXP_INPUT_FETCH_SHIFT_WIDTH_CH0_WIDTH0)

#define HW_PXP_INPUT_FETCH_SHIFT_WIDTH_CH1	(0x00000570)
#define HW_PXP_INPUT_FETCH_SHIFT_WIDTH_CH1_SET	(0x00000574)
#define HW_PXP_INPUT_FETCH_SHIFT_WIDTH_CH1_CLR	(0x00000578)
#define HW_PXP_INPUT_FETCH_SHIFT_WIDTH_CH1_TOG	(0x0000057c)

#define BP_PXP_INPUT_FETCH_SHIFT_WIDTH_CH1_RSVD0      16
#define BM_PXP_INPUT_FETCH_SHIFT_WIDTH_CH1_RSVD0 0xFFFF0000
#define BF_PXP_INPUT_FETCH_SHIFT_WIDTH_CH1_RSVD0(v) \
        (((v) << 16) & BM_PXP_INPUT_FETCH_SHIFT_WIDTH_CH1_RSVD0)
#define BP_PXP_INPUT_FETCH_SHIFT_WIDTH_CH1_WIDTH3      12
#define BM_PXP_INPUT_FETCH_SHIFT_WIDTH_CH1_WIDTH3 0x0000F000
#define BF_PXP_INPUT_FETCH_SHIFT_WIDTH_CH1_WIDTH3(v)  \
        (((v) << 12) & BM_PXP_INPUT_FETCH_SHIFT_WIDTH_CH1_WIDTH3)
#define BP_PXP_INPUT_FETCH_SHIFT_WIDTH_CH1_WIDTH2      8
#define BM_PXP_INPUT_FETCH_SHIFT_WIDTH_CH1_WIDTH2 0x00000F00
#define BF_PXP_INPUT_FETCH_SHIFT_WIDTH_CH1_WIDTH2(v)  \
        (((v) << 8) & BM_PXP_INPUT_FETCH_SHIFT_WIDTH_CH1_WIDTH2)
#define BP_PXP_INPUT_FETCH_SHIFT_WIDTH_CH1_WIDTH1      4
#define BM_PXP_INPUT_FETCH_SHIFT_WIDTH_CH1_WIDTH1 0x000000F0
#define BF_PXP_INPUT_FETCH_SHIFT_WIDTH_CH1_WIDTH1(v)  \
        (((v) << 4) & BM_PXP_INPUT_FETCH_SHIFT_WIDTH_CH1_WIDTH1)
#define BP_PXP_INPUT_FETCH_SHIFT_WIDTH_CH1_WIDTH0      0
#define BM_PXP_INPUT_FETCH_SHIFT_WIDTH_CH1_WIDTH0 0x0000000F
#define BF_PXP_INPUT_FETCH_SHIFT_WIDTH_CH1_WIDTH0(v)  \
        (((v) << 0) & BM_PXP_INPUT_FETCH_SHIFT_WIDTH_CH1_WIDTH0)

#define HW_PXP_INPUT_FETCH_ADDR_0_CH0	(0x00000580)

#define BP_PXP_INPUT_FETCH_ADDR_0_CH0_INPUT_BASE_ADDR0      0
#define BM_PXP_INPUT_FETCH_ADDR_0_CH0_INPUT_BASE_ADDR0 0xFFFFFFFF
#define BF_PXP_INPUT_FETCH_ADDR_0_CH0_INPUT_BASE_ADDR0(v)   (v)

#define HW_PXP_INPUT_FETCH_ADDR_1_CH0	(0x00000590)

#define BP_PXP_INPUT_FETCH_ADDR_1_CH0_INPUT_BASE_ADDR1      0
#define BM_PXP_INPUT_FETCH_ADDR_1_CH0_INPUT_BASE_ADDR1 0xFFFFFFFF
#define BF_PXP_INPUT_FETCH_ADDR_1_CH0_INPUT_BASE_ADDR1(v)   (v)

#define HW_PXP_INPUT_FETCH_ADDR_0_CH1	(0x000005a0)

#define BP_PXP_INPUT_FETCH_ADDR_0_CH1_INPUT_BASE_ADDR0      0
#define BM_PXP_INPUT_FETCH_ADDR_0_CH1_INPUT_BASE_ADDR0 0xFFFFFFFF
#define BF_PXP_INPUT_FETCH_ADDR_0_CH1_INPUT_BASE_ADDR0(v)   (v)

#define HW_PXP_INPUT_FETCH_ADDR_1_CH1	(0x000005b0)

#define BP_PXP_INPUT_FETCH_ADDR_1_CH1_INPUT_BASE_ADDR1      0
#define BM_PXP_INPUT_FETCH_ADDR_1_CH1_INPUT_BASE_ADDR1 0xFFFFFFFF
#define BF_PXP_INPUT_FETCH_ADDR_1_CH1_INPUT_BASE_ADDR1(v)   (v)

#define HW_PXP_INPUT_STORE_CTRL_CH0	(0x000005c0)
#define HW_PXP_INPUT_STORE_CTRL_CH0_SET	(0x000005c4)
#define HW_PXP_INPUT_STORE_CTRL_CH0_CLR	(0x000005c8)
#define HW_PXP_INPUT_STORE_CTRL_CH0_TOG	(0x000005cc)

#define BM_PXP_INPUT_STORE_CTRL_CH0_ARBIT_EN 0x80000000
#define BF_PXP_INPUT_STORE_CTRL_CH0_ARBIT_EN(v) \
        (((v) << 31) & BM_PXP_INPUT_STORE_CTRL_CH0_ARBIT_EN)
#define BV_PXP_INPUT_STORE_CTRL_CH0_ARBIT_EN__0 0x0
#define BV_PXP_INPUT_STORE_CTRL_CH0_ARBIT_EN__1 0x1
#define BP_PXP_INPUT_STORE_CTRL_CH0_RSVD0      25
#define BM_PXP_INPUT_STORE_CTRL_CH0_RSVD0 0x7E000000
#define BF_PXP_INPUT_STORE_CTRL_CH0_RSVD0(v)  \
        (((v) << 25) & BM_PXP_INPUT_STORE_CTRL_CH0_RSVD0)
#define BM_PXP_INPUT_STORE_CTRL_CH0_COMBINE_2CHANNEL 0x01000000
#define BF_PXP_INPUT_STORE_CTRL_CH0_COMBINE_2CHANNEL(v)  \
        (((v) << 24) & BM_PXP_INPUT_STORE_CTRL_CH0_COMBINE_2CHANNEL)
#define BV_PXP_INPUT_STORE_CTRL_CH0_COMBINE_2CHANNEL__0 0x0
#define BV_PXP_INPUT_STORE_CTRL_CH0_COMBINE_2CHANNEL__1 0x1
#define BP_PXP_INPUT_STORE_CTRL_CH0_RSVD1      18
#define BM_PXP_INPUT_STORE_CTRL_CH0_RSVD1 0x00FC0000
#define BF_PXP_INPUT_STORE_CTRL_CH0_RSVD1(v)  \
        (((v) << 18) & BM_PXP_INPUT_STORE_CTRL_CH0_RSVD1)
#define BP_PXP_INPUT_STORE_CTRL_CH0_WR_NUM_BYTES      16
#define BM_PXP_INPUT_STORE_CTRL_CH0_WR_NUM_BYTES 0x00030000
#define BF_PXP_INPUT_STORE_CTRL_CH0_WR_NUM_BYTES(v)  \
        (((v) << 16) & BM_PXP_INPUT_STORE_CTRL_CH0_WR_NUM_BYTES)
#define BV_PXP_INPUT_STORE_CTRL_CH0_WR_NUM_BYTES__8_bytes  0x0
#define BV_PXP_INPUT_STORE_CTRL_CH0_WR_NUM_BYTES__16_bytes 0x1
#define BV_PXP_INPUT_STORE_CTRL_CH0_WR_NUM_BYTES__32_bytes 0x2
#define BV_PXP_INPUT_STORE_CTRL_CH0_WR_NUM_BYTES__64_bytes 0x3
#define BP_PXP_INPUT_STORE_CTRL_CH0_RSVD2      12
#define BM_PXP_INPUT_STORE_CTRL_CH0_RSVD2 0x0000F000
#define BF_PXP_INPUT_STORE_CTRL_CH0_RSVD2(v)  \
        (((v) << 12) & BM_PXP_INPUT_STORE_CTRL_CH0_RSVD2)
#define BM_PXP_INPUT_STORE_CTRL_CH0_FILL_DATA_EN 0x00000800
#define BF_PXP_INPUT_STORE_CTRL_CH0_FILL_DATA_EN(v)  \
        (((v) << 11) & BM_PXP_INPUT_STORE_CTRL_CH0_FILL_DATA_EN)
#define BV_PXP_INPUT_STORE_CTRL_CH0_FILL_DATA_EN__0 0x0
#define BV_PXP_INPUT_STORE_CTRL_CH0_FILL_DATA_EN__1 0x1
#define BM_PXP_INPUT_STORE_CTRL_CH0_PACK_IN_SEL 0x00000400
#define BF_PXP_INPUT_STORE_CTRL_CH0_PACK_IN_SEL(v)  \
        (((v) << 10) & BM_PXP_INPUT_STORE_CTRL_CH0_PACK_IN_SEL)
#define BV_PXP_INPUT_STORE_CTRL_CH0_PACK_IN_SEL__0 0x0
#define BV_PXP_INPUT_STORE_CTRL_CH0_PACK_IN_SEL__1 0x1
#define BM_PXP_INPUT_STORE_CTRL_CH0_STORE_MEMORY_EN 0x00000200
#define BF_PXP_INPUT_STORE_CTRL_CH0_STORE_MEMORY_EN(v)  \
        (((v) << 9) & BM_PXP_INPUT_STORE_CTRL_CH0_STORE_MEMORY_EN)
#define BV_PXP_INPUT_STORE_CTRL_CH0_STORE_MEMORY_EN__0 0x0
#define BV_PXP_INPUT_STORE_CTRL_CH0_STORE_MEMORY_EN__1 0x1
#define BM_PXP_INPUT_STORE_CTRL_CH0_STORE_BYPASS_EN 0x00000100
#define BF_PXP_INPUT_STORE_CTRL_CH0_STORE_BYPASS_EN(v)  \
        (((v) << 8) & BM_PXP_INPUT_STORE_CTRL_CH0_STORE_BYPASS_EN)
#define BV_PXP_INPUT_STORE_CTRL_CH0_STORE_BYPASS_EN__0 0x0
#define BV_PXP_INPUT_STORE_CTRL_CH0_STORE_BYPASS_EN__1 0x1
#define BM_PXP_INPUT_STORE_CTRL_CH0_RSVD3 0x00000080
#define BF_PXP_INPUT_STORE_CTRL_CH0_RSVD3(v)  \
        (((v) << 7) & BM_PXP_INPUT_STORE_CTRL_CH0_RSVD3)
#define BP_PXP_INPUT_STORE_CTRL_CH0_ARRAY_LINE_NUM      5
#define BM_PXP_INPUT_STORE_CTRL_CH0_ARRAY_LINE_NUM 0x00000060
#define BF_PXP_INPUT_STORE_CTRL_CH0_ARRAY_LINE_NUM(v)  \
        (((v) << 5) & BM_PXP_INPUT_STORE_CTRL_CH0_ARRAY_LINE_NUM)
#define BV_PXP_INPUT_STORE_CTRL_CH0_ARRAY_LINE_NUM__0 0x0
#define BV_PXP_INPUT_STORE_CTRL_CH0_ARRAY_LINE_NUM__1 0x1
#define BV_PXP_INPUT_STORE_CTRL_CH0_ARRAY_LINE_NUM__2 0x2
#define BV_PXP_INPUT_STORE_CTRL_CH0_ARRAY_LINE_NUM__3 0x3
#define BM_PXP_INPUT_STORE_CTRL_CH0_ARRAY_EN 0x00000010
#define BF_PXP_INPUT_STORE_CTRL_CH0_ARRAY_EN(v)  \
        (((v) << 4) & BM_PXP_INPUT_STORE_CTRL_CH0_ARRAY_EN)
#define BV_PXP_INPUT_STORE_CTRL_CH0_ARRAY_EN__0 0x0
#define BV_PXP_INPUT_STORE_CTRL_CH0_ARRAY_EN__1 0x1
#define BM_PXP_INPUT_STORE_CTRL_CH0_HANDSHAKE_EN 0x00000008
#define BF_PXP_INPUT_STORE_CTRL_CH0_HANDSHAKE_EN(v)  \
        (((v) << 3) & BM_PXP_INPUT_STORE_CTRL_CH0_HANDSHAKE_EN)
#define BV_PXP_INPUT_STORE_CTRL_CH0_HANDSHAKE_EN__0 0x0
#define BV_PXP_INPUT_STORE_CTRL_CH0_HANDSHAKE_EN__1 0x1
#define BM_PXP_INPUT_STORE_CTRL_CH0_BLOCK_16 0x00000004
#define BF_PXP_INPUT_STORE_CTRL_CH0_BLOCK_16(v)  \
        (((v) << 2) & BM_PXP_INPUT_STORE_CTRL_CH0_BLOCK_16)
#define BV_PXP_INPUT_STORE_CTRL_CH0_BLOCK_16__8x8   0x0
#define BV_PXP_INPUT_STORE_CTRL_CH0_BLOCK_16__16x16 0x1
#define BM_PXP_INPUT_STORE_CTRL_CH0_BLOCK_EN 0x00000002
#define BF_PXP_INPUT_STORE_CTRL_CH0_BLOCK_EN(v)  \
        (((v) << 1) & BM_PXP_INPUT_STORE_CTRL_CH0_BLOCK_EN)
#define BV_PXP_INPUT_STORE_CTRL_CH0_BLOCK_EN__0 0x0
#define BV_PXP_INPUT_STORE_CTRL_CH0_BLOCK_EN__1 0x1
#define BM_PXP_INPUT_STORE_CTRL_CH0_CH_EN 0x00000001
#define BF_PXP_INPUT_STORE_CTRL_CH0_CH_EN(v)  \
        (((v) << 0) & BM_PXP_INPUT_STORE_CTRL_CH0_CH_EN)
#define BV_PXP_INPUT_STORE_CTRL_CH0_CH_EN__0 0x0
#define BV_PXP_INPUT_STORE_CTRL_CH0_CH_EN__1 0x1

#define HW_PXP_INPUT_STORE_CTRL_CH1	(0x000005d0)
#define HW_PXP_INPUT_STORE_CTRL_CH1_SET	(0x000005d4)
#define HW_PXP_INPUT_STORE_CTRL_CH1_CLR	(0x000005d8)
#define HW_PXP_INPUT_STORE_CTRL_CH1_TOG	(0x000005dc)

#define BP_PXP_INPUT_STORE_CTRL_CH1_RSVD0      18
#define BM_PXP_INPUT_STORE_CTRL_CH1_RSVD0 0xFFFC0000
#define BF_PXP_INPUT_STORE_CTRL_CH1_RSVD0(v) \
        (((v) << 18) & BM_PXP_INPUT_STORE_CTRL_CH1_RSVD0)
#define BP_PXP_INPUT_STORE_CTRL_CH1_WR_NUM_BYTES      16
#define BM_PXP_INPUT_STORE_CTRL_CH1_WR_NUM_BYTES 0x00030000
#define BF_PXP_INPUT_STORE_CTRL_CH1_WR_NUM_BYTES(v)  \
        (((v) << 16) & BM_PXP_INPUT_STORE_CTRL_CH1_WR_NUM_BYTES)
#define BV_PXP_INPUT_STORE_CTRL_CH1_WR_NUM_BYTES__8_bytes  0x0
#define BV_PXP_INPUT_STORE_CTRL_CH1_WR_NUM_BYTES__16_bytes 0x1
#define BV_PXP_INPUT_STORE_CTRL_CH1_WR_NUM_BYTES__32_bytes 0x2
#define BV_PXP_INPUT_STORE_CTRL_CH1_WR_NUM_BYTES__64_bytes 0x3
#define BP_PXP_INPUT_STORE_CTRL_CH1_RSVD1      11
#define BM_PXP_INPUT_STORE_CTRL_CH1_RSVD1 0x0000F800
#define BF_PXP_INPUT_STORE_CTRL_CH1_RSVD1(v)  \
        (((v) << 11) & BM_PXP_INPUT_STORE_CTRL_CH1_RSVD1)
#define BM_PXP_INPUT_STORE_CTRL_CH1_PACK_IN_SEL 0x00000400
#define BF_PXP_INPUT_STORE_CTRL_CH1_PACK_IN_SEL(v)  \
        (((v) << 10) & BM_PXP_INPUT_STORE_CTRL_CH1_PACK_IN_SEL)
#define BV_PXP_INPUT_STORE_CTRL_CH1_PACK_IN_SEL__0 0x0
#define BV_PXP_INPUT_STORE_CTRL_CH1_PACK_IN_SEL__1 0x1
#define BM_PXP_INPUT_STORE_CTRL_CH1_STORE_MEMORY_EN 0x00000200
#define BF_PXP_INPUT_STORE_CTRL_CH1_STORE_MEMORY_EN(v)  \
        (((v) << 9) & BM_PXP_INPUT_STORE_CTRL_CH1_STORE_MEMORY_EN)
#define BV_PXP_INPUT_STORE_CTRL_CH1_STORE_MEMORY_EN__0 0x0
#define BV_PXP_INPUT_STORE_CTRL_CH1_STORE_MEMORY_EN__1 0x1
#define BM_PXP_INPUT_STORE_CTRL_CH1_STORE_BYPASS_EN 0x00000100
#define BF_PXP_INPUT_STORE_CTRL_CH1_STORE_BYPASS_EN(v)  \
        (((v) << 8) & BM_PXP_INPUT_STORE_CTRL_CH1_STORE_BYPASS_EN)
#define BV_PXP_INPUT_STORE_CTRL_CH1_STORE_BYPASS_EN__0 0x0
#define BV_PXP_INPUT_STORE_CTRL_CH1_STORE_BYPASS_EN__1 0x1
#define BM_PXP_INPUT_STORE_CTRL_CH1_RSVD3 0x00000080
#define BF_PXP_INPUT_STORE_CTRL_CH1_RSVD3(v)  \
        (((v) << 7) & BM_PXP_INPUT_STORE_CTRL_CH1_RSVD3)
#define BP_PXP_INPUT_STORE_CTRL_CH1_ARRAY_LINE_NUM      5
#define BM_PXP_INPUT_STORE_CTRL_CH1_ARRAY_LINE_NUM 0x00000060
#define BF_PXP_INPUT_STORE_CTRL_CH1_ARRAY_LINE_NUM(v)  \
        (((v) << 5) & BM_PXP_INPUT_STORE_CTRL_CH1_ARRAY_LINE_NUM)
#define BV_PXP_INPUT_STORE_CTRL_CH1_ARRAY_LINE_NUM__0 0x0
#define BV_PXP_INPUT_STORE_CTRL_CH1_ARRAY_LINE_NUM__1 0x1
#define BV_PXP_INPUT_STORE_CTRL_CH1_ARRAY_LINE_NUM__2 0x2
#define BV_PXP_INPUT_STORE_CTRL_CH1_ARRAY_LINE_NUM__3 0x3
#define BM_PXP_INPUT_STORE_CTRL_CH1_ARRAY_EN 0x00000010
#define BF_PXP_INPUT_STORE_CTRL_CH1_ARRAY_EN(v)  \
        (((v) << 4) & BM_PXP_INPUT_STORE_CTRL_CH1_ARRAY_EN)
#define BV_PXP_INPUT_STORE_CTRL_CH1_ARRAY_EN__0 0x0
#define BV_PXP_INPUT_STORE_CTRL_CH1_ARRAY_EN__1 0x1
#define BM_PXP_INPUT_STORE_CTRL_CH1_HANDSHAKE_EN 0x00000008
#define BF_PXP_INPUT_STORE_CTRL_CH1_HANDSHAKE_EN(v)  \
        (((v) << 3) & BM_PXP_INPUT_STORE_CTRL_CH1_HANDSHAKE_EN)
#define BV_PXP_INPUT_STORE_CTRL_CH1_HANDSHAKE_EN__0 0x0
#define BV_PXP_INPUT_STORE_CTRL_CH1_HANDSHAKE_EN__1 0x1
#define BM_PXP_INPUT_STORE_CTRL_CH1_BLOCK_16 0x00000004
#define BF_PXP_INPUT_STORE_CTRL_CH1_BLOCK_16(v)  \
        (((v) << 2) & BM_PXP_INPUT_STORE_CTRL_CH1_BLOCK_16)
#define BV_PXP_INPUT_STORE_CTRL_CH1_BLOCK_16__8x8   0x0
#define BV_PXP_INPUT_STORE_CTRL_CH1_BLOCK_16__16x16 0x1
#define BM_PXP_INPUT_STORE_CTRL_CH1_BLOCK_EN 0x00000002
#define BF_PXP_INPUT_STORE_CTRL_CH1_BLOCK_EN(v)  \
        (((v) << 1) & BM_PXP_INPUT_STORE_CTRL_CH1_BLOCK_EN)
#define BV_PXP_INPUT_STORE_CTRL_CH1_BLOCK_EN__0 0x0
#define BV_PXP_INPUT_STORE_CTRL_CH1_BLOCK_EN__1 0x1
#define BM_PXP_INPUT_STORE_CTRL_CH1_CH_EN 0x00000001
#define BF_PXP_INPUT_STORE_CTRL_CH1_CH_EN(v)  \
        (((v) << 0) & BM_PXP_INPUT_STORE_CTRL_CH1_CH_EN)
#define BV_PXP_INPUT_STORE_CTRL_CH1_CH_EN__0 0x0
#define BV_PXP_INPUT_STORE_CTRL_CH1_CH_EN__1 0x1

#define HW_PXP_INPUT_STORE_STATUS_CH0	(0x000005e0)

#define BP_PXP_INPUT_STORE_STATUS_CH0_STORE_BLOCK_Y      16
#define BM_PXP_INPUT_STORE_STATUS_CH0_STORE_BLOCK_Y 0xFFFF0000
#define BF_PXP_INPUT_STORE_STATUS_CH0_STORE_BLOCK_Y(v) \
        (((v) << 16) & BM_PXP_INPUT_STORE_STATUS_CH0_STORE_BLOCK_Y)
#define BP_PXP_INPUT_STORE_STATUS_CH0_STORE_BLOCK_X      0
#define BM_PXP_INPUT_STORE_STATUS_CH0_STORE_BLOCK_X 0x0000FFFF
#define BF_PXP_INPUT_STORE_STATUS_CH0_STORE_BLOCK_X(v)  \
        (((v) << 0) & BM_PXP_INPUT_STORE_STATUS_CH0_STORE_BLOCK_X)

#define HW_PXP_INPUT_STORE_STATUS_CH1	(0x000005f0)

#define BP_PXP_INPUT_STORE_STATUS_CH1_STORE_BLOCK_Y      16
#define BM_PXP_INPUT_STORE_STATUS_CH1_STORE_BLOCK_Y 0xFFFF0000
#define BF_PXP_INPUT_STORE_STATUS_CH1_STORE_BLOCK_Y(v) \
        (((v) << 16) & BM_PXP_INPUT_STORE_STATUS_CH1_STORE_BLOCK_Y)
#define BP_PXP_INPUT_STORE_STATUS_CH1_STORE_BLOCK_X      0
#define BM_PXP_INPUT_STORE_STATUS_CH1_STORE_BLOCK_X 0x0000FFFF
#define BF_PXP_INPUT_STORE_STATUS_CH1_STORE_BLOCK_X(v)  \
        (((v) << 0) & BM_PXP_INPUT_STORE_STATUS_CH1_STORE_BLOCK_X)

#define HW_PXP_INPUT_STORE_SIZE_CH0	(0x00000600)

#define BP_PXP_INPUT_STORE_SIZE_CH0_OUT_HEIGHT      16
#define BM_PXP_INPUT_STORE_SIZE_CH0_OUT_HEIGHT 0xFFFF0000
#define BF_PXP_INPUT_STORE_SIZE_CH0_OUT_HEIGHT(v) \
        (((v) << 16) & BM_PXP_INPUT_STORE_SIZE_CH0_OUT_HEIGHT)
#define BP_PXP_INPUT_STORE_SIZE_CH0_OUT_WIDTH      0
#define BM_PXP_INPUT_STORE_SIZE_CH0_OUT_WIDTH 0x0000FFFF
#define BF_PXP_INPUT_STORE_SIZE_CH0_OUT_WIDTH(v)  \
        (((v) << 0) & BM_PXP_INPUT_STORE_SIZE_CH0_OUT_WIDTH)

#define HW_PXP_INPUT_STORE_SIZE_CH1	(0x00000610)

#define BP_PXP_INPUT_STORE_SIZE_CH1_OUT_HEIGHT      16
#define BM_PXP_INPUT_STORE_SIZE_CH1_OUT_HEIGHT 0xFFFF0000
#define BF_PXP_INPUT_STORE_SIZE_CH1_OUT_HEIGHT(v) \
        (((v) << 16) & BM_PXP_INPUT_STORE_SIZE_CH1_OUT_HEIGHT)
#define BP_PXP_INPUT_STORE_SIZE_CH1_OUT_WIDTH      0
#define BM_PXP_INPUT_STORE_SIZE_CH1_OUT_WIDTH 0x0000FFFF
#define BF_PXP_INPUT_STORE_SIZE_CH1_OUT_WIDTH(v)  \
        (((v) << 0) & BM_PXP_INPUT_STORE_SIZE_CH1_OUT_WIDTH)

#define HW_PXP_INPUT_STORE_PITCH	(0x00000620)

#define BP_PXP_INPUT_STORE_PITCH_CH1_OUT_PITCH      16
#define BM_PXP_INPUT_STORE_PITCH_CH1_OUT_PITCH 0xFFFF0000
#define BF_PXP_INPUT_STORE_PITCH_CH1_OUT_PITCH(v) \
        (((v) << 16) & BM_PXP_INPUT_STORE_PITCH_CH1_OUT_PITCH)
#define BP_PXP_INPUT_STORE_PITCH_CH0_OUT_PITCH      0
#define BM_PXP_INPUT_STORE_PITCH_CH0_OUT_PITCH 0x0000FFFF
#define BF_PXP_INPUT_STORE_PITCH_CH0_OUT_PITCH(v)  \
        (((v) << 0) & BM_PXP_INPUT_STORE_PITCH_CH0_OUT_PITCH)

#define HW_PXP_INPUT_STORE_SHIFT_CTRL_CH0	(0x00000630)
#define HW_PXP_INPUT_STORE_SHIFT_CTRL_CH0_SET	(0x00000634)
#define HW_PXP_INPUT_STORE_SHIFT_CTRL_CH0_CLR	(0x00000638)
#define HW_PXP_INPUT_STORE_SHIFT_CTRL_CH0_TOG	(0x0000063c)

#define BP_PXP_INPUT_STORE_SHIFT_CTRL_CH0_RSVD0      8
#define BM_PXP_INPUT_STORE_SHIFT_CTRL_CH0_RSVD0 0xFFFFFF00
#define BF_PXP_INPUT_STORE_SHIFT_CTRL_CH0_RSVD0(v) \
        (((v) << 8) & BM_PXP_INPUT_STORE_SHIFT_CTRL_CH0_RSVD0)
#define BM_PXP_INPUT_STORE_SHIFT_CTRL_CH0_SHIFT_BYPASS 0x00000080
#define BF_PXP_INPUT_STORE_SHIFT_CTRL_CH0_SHIFT_BYPASS(v)  \
        (((v) << 7) & BM_PXP_INPUT_STORE_SHIFT_CTRL_CH0_SHIFT_BYPASS)
#define BV_PXP_INPUT_STORE_SHIFT_CTRL_CH0_SHIFT_BYPASS__0 0x0
#define BV_PXP_INPUT_STORE_SHIFT_CTRL_CH0_SHIFT_BYPASS__1 0x1
#define BM_PXP_INPUT_STORE_SHIFT_CTRL_CH0_RSVD1 0x00000040
#define BF_PXP_INPUT_STORE_SHIFT_CTRL_CH0_RSVD1(v)  \
        (((v) << 6) & BM_PXP_INPUT_STORE_SHIFT_CTRL_CH0_RSVD1)
#define BM_PXP_INPUT_STORE_SHIFT_CTRL_CH0_OUT_YUV422_2P_EN 0x00000020
#define BF_PXP_INPUT_STORE_SHIFT_CTRL_CH0_OUT_YUV422_2P_EN(v)  \
        (((v) << 5) & BM_PXP_INPUT_STORE_SHIFT_CTRL_CH0_OUT_YUV422_2P_EN)
#define BV_PXP_INPUT_STORE_SHIFT_CTRL_CH0_OUT_YUV422_2P_EN__0 0x0
#define BV_PXP_INPUT_STORE_SHIFT_CTRL_CH0_OUT_YUV422_2P_EN__1 0x1
#define BM_PXP_INPUT_STORE_SHIFT_CTRL_CH0_OUT_YUV422_1P_EN 0x00000010
#define BF_PXP_INPUT_STORE_SHIFT_CTRL_CH0_OUT_YUV422_1P_EN(v)  \
        (((v) << 4) & BM_PXP_INPUT_STORE_SHIFT_CTRL_CH0_OUT_YUV422_1P_EN)
#define BV_PXP_INPUT_STORE_SHIFT_CTRL_CH0_OUT_YUV422_1P_EN__0 0x0
#define BV_PXP_INPUT_STORE_SHIFT_CTRL_CH0_OUT_YUV422_1P_EN__1 0x1
#define BP_PXP_INPUT_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP      2
#define BM_PXP_INPUT_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP 0x0000000C
#define BF_PXP_INPUT_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP(v)  \
        (((v) << 2) & BM_PXP_INPUT_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP)
#define BV_PXP_INPUT_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP__0 0x0
#define BV_PXP_INPUT_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP__1 0x1
#define BV_PXP_INPUT_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP__2 0x2
#define BV_PXP_INPUT_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP__3 0x3
#define BP_PXP_INPUT_STORE_SHIFT_CTRL_CH0_RSVD2      0
#define BM_PXP_INPUT_STORE_SHIFT_CTRL_CH0_RSVD2 0x00000003
#define BF_PXP_INPUT_STORE_SHIFT_CTRL_CH0_RSVD2(v)  \
        (((v) << 0) & BM_PXP_INPUT_STORE_SHIFT_CTRL_CH0_RSVD2)

#define HW_PXP_INPUT_STORE_SHIFT_CTRL_CH1	(0x00000640)
#define HW_PXP_INPUT_STORE_SHIFT_CTRL_CH1_SET	(0x00000644)
#define HW_PXP_INPUT_STORE_SHIFT_CTRL_CH1_CLR	(0x00000648)
#define HW_PXP_INPUT_STORE_SHIFT_CTRL_CH1_TOG	(0x0000064c)

#define BP_PXP_INPUT_STORE_SHIFT_CTRL_CH1_RSVD0      6
#define BM_PXP_INPUT_STORE_SHIFT_CTRL_CH1_RSVD0 0xFFFFFFC0
#define BF_PXP_INPUT_STORE_SHIFT_CTRL_CH1_RSVD0(v) \
        (((v) << 6) & BM_PXP_INPUT_STORE_SHIFT_CTRL_CH1_RSVD0)
#define BM_PXP_INPUT_STORE_SHIFT_CTRL_CH1_OUT_YUV422_2P_EN 0x00000020
#define BF_PXP_INPUT_STORE_SHIFT_CTRL_CH1_OUT_YUV422_2P_EN(v)  \
        (((v) << 5) & BM_PXP_INPUT_STORE_SHIFT_CTRL_CH1_OUT_YUV422_2P_EN)
#define BV_PXP_INPUT_STORE_SHIFT_CTRL_CH1_OUT_YUV422_2P_EN__0 0x0
#define BV_PXP_INPUT_STORE_SHIFT_CTRL_CH1_OUT_YUV422_2P_EN__1 0x1
#define BM_PXP_INPUT_STORE_SHIFT_CTRL_CH1_OUT_YUV422_1P_EN 0x00000010
#define BF_PXP_INPUT_STORE_SHIFT_CTRL_CH1_OUT_YUV422_1P_EN(v)  \
        (((v) << 4) & BM_PXP_INPUT_STORE_SHIFT_CTRL_CH1_OUT_YUV422_1P_EN)
#define BV_PXP_INPUT_STORE_SHIFT_CTRL_CH1_OUT_YUV422_1P_EN__0 0x0
#define BV_PXP_INPUT_STORE_SHIFT_CTRL_CH1_OUT_YUV422_1P_EN__1 0x1
#define BP_PXP_INPUT_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP      2
#define BM_PXP_INPUT_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP 0x0000000C
#define BF_PXP_INPUT_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP(v)  \
        (((v) << 2) & BM_PXP_INPUT_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP)
#define BV_PXP_INPUT_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP__0 0x0
#define BV_PXP_INPUT_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP__1 0x1
#define BV_PXP_INPUT_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP__2 0x2
#define BV_PXP_INPUT_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP__3 0x3
#define BP_PXP_INPUT_STORE_SHIFT_CTRL_CH1_RSVD2      0
#define BM_PXP_INPUT_STORE_SHIFT_CTRL_CH1_RSVD2 0x00000003
#define BF_PXP_INPUT_STORE_SHIFT_CTRL_CH1_RSVD2(v)  \
        (((v) << 0) & BM_PXP_INPUT_STORE_SHIFT_CTRL_CH1_RSVD2)

#define HW_PXP_INPUT_STORE_ADDR_0_CH0	(0x00000690)

#define BP_PXP_INPUT_STORE_ADDR_0_CH0_OUT_BASE_ADDR0      0
#define BM_PXP_INPUT_STORE_ADDR_0_CH0_OUT_BASE_ADDR0 0xFFFFFFFF
#define BF_PXP_INPUT_STORE_ADDR_0_CH0_OUT_BASE_ADDR0(v)   (v)

#define HW_PXP_INPUT_STORE_ADDR_1_CH0	(0x000006a0)

#define BP_PXP_INPUT_STORE_ADDR_1_CH0_OUT_BASE_ADDR1      0
#define BM_PXP_INPUT_STORE_ADDR_1_CH0_OUT_BASE_ADDR1 0xFFFFFFFF
#define BF_PXP_INPUT_STORE_ADDR_1_CH0_OUT_BASE_ADDR1(v)   (v)

#define HW_PXP_INPUT_STORE_FILL_DATA_CH0	(0x000006b0)

#define BP_PXP_INPUT_STORE_FILL_DATA_CH0_FILL_DATA_CH0      0
#define BM_PXP_INPUT_STORE_FILL_DATA_CH0_FILL_DATA_CH0 0xFFFFFFFF
#define BF_PXP_INPUT_STORE_FILL_DATA_CH0_FILL_DATA_CH0(v)   (v)

#define HW_PXP_INPUT_STORE_ADDR_0_CH1	(0x000006c0)

#define BP_PXP_INPUT_STORE_ADDR_0_CH1_OUT_BASE_ADDR0      0
#define BM_PXP_INPUT_STORE_ADDR_0_CH1_OUT_BASE_ADDR0 0xFFFFFFFF
#define BF_PXP_INPUT_STORE_ADDR_0_CH1_OUT_BASE_ADDR0(v)   (v)

#define HW_PXP_INPUT_STORE_ADDR_1_CH1	(0x000006d0)

#define BP_PXP_INPUT_STORE_ADDR_1_CH1_OUT_BASE_ADDR1      0
#define BM_PXP_INPUT_STORE_ADDR_1_CH1_OUT_BASE_ADDR1 0xFFFFFFFF
#define BF_PXP_INPUT_STORE_ADDR_1_CH1_OUT_BASE_ADDR1(v)   (v)

#define HW_PXP_INPUT_STORE_D_MASK0_H_CH0	(0x000006e0)

#define BP_PXP_INPUT_STORE_D_MASK0_H_CH0_D_MASK0_H_CH0      0
#define BM_PXP_INPUT_STORE_D_MASK0_H_CH0_D_MASK0_H_CH0 0xFFFFFFFF
#define BF_PXP_INPUT_STORE_D_MASK0_H_CH0_D_MASK0_H_CH0(v)   (v)

#define HW_PXP_INPUT_STORE_D_MASK0_L_CH0	(0x000006f0)

#define BP_PXP_INPUT_STORE_D_MASK0_L_CH0_D_MASK0_L_CH0      0
#define BM_PXP_INPUT_STORE_D_MASK0_L_CH0_D_MASK0_L_CH0 0xFFFFFFFF
#define BF_PXP_INPUT_STORE_D_MASK0_L_CH0_D_MASK0_L_CH0(v)   (v)

#define HW_PXP_INPUT_STORE_D_MASK1_H_CH0	(0x00000700)

#define BP_PXP_INPUT_STORE_D_MASK1_H_CH0_D_MASK1_H_CH0      0
#define BM_PXP_INPUT_STORE_D_MASK1_H_CH0_D_MASK1_H_CH0 0xFFFFFFFF
#define BF_PXP_INPUT_STORE_D_MASK1_H_CH0_D_MASK1_H_CH0(v)   (v)

#define HW_PXP_INPUT_STORE_D_MASK1_L_CH0	(0x00000710)

#define BP_PXP_INPUT_STORE_D_MASK1_L_CH0_D_MASK1_L_CH0      0
#define BM_PXP_INPUT_STORE_D_MASK1_L_CH0_D_MASK1_L_CH0 0xFFFFFFFF
#define BF_PXP_INPUT_STORE_D_MASK1_L_CH0_D_MASK1_L_CH0(v)   (v)

#define HW_PXP_INPUT_STORE_D_MASK2_H_CH0	(0x00000720)

#define BP_PXP_INPUT_STORE_D_MASK2_H_CH0_D_MASK2_H_CH0      0
#define BM_PXP_INPUT_STORE_D_MASK2_H_CH0_D_MASK2_H_CH0 0xFFFFFFFF
#define BF_PXP_INPUT_STORE_D_MASK2_H_CH0_D_MASK2_H_CH0(v)   (v)

#define HW_PXP_INPUT_STORE_D_MASK2_L_CH0	(0x00000730)

#define BP_PXP_INPUT_STORE_D_MASK2_L_CH0_D_MASK2_L_CH0      0
#define BM_PXP_INPUT_STORE_D_MASK2_L_CH0_D_MASK2_L_CH0 0xFFFFFFFF
#define BF_PXP_INPUT_STORE_D_MASK2_L_CH0_D_MASK2_L_CH0(v)   (v)

#define HW_PXP_INPUT_STORE_D_MASK3_H_CH0	(0x00000740)

#define BP_PXP_INPUT_STORE_D_MASK3_H_CH0_D_MASK3_H_CH0      0
#define BM_PXP_INPUT_STORE_D_MASK3_H_CH0_D_MASK3_H_CH0 0xFFFFFFFF
#define BF_PXP_INPUT_STORE_D_MASK3_H_CH0_D_MASK3_H_CH0(v)   (v)

#define HW_PXP_INPUT_STORE_D_MASK3_L_CH0	(0x00000750)

#define BP_PXP_INPUT_STORE_D_MASK3_L_CH0_D_MASK3_L_CH0      0
#define BM_PXP_INPUT_STORE_D_MASK3_L_CH0_D_MASK3_L_CH0 0xFFFFFFFF
#define BF_PXP_INPUT_STORE_D_MASK3_L_CH0_D_MASK3_L_CH0(v)   (v)

#define HW_PXP_INPUT_STORE_D_MASK4_H_CH0	(0x00000760)

#define BP_PXP_INPUT_STORE_D_MASK4_H_CH0_D_MASK4_H_CH0      0
#define BM_PXP_INPUT_STORE_D_MASK4_H_CH0_D_MASK4_H_CH0 0xFFFFFFFF
#define BF_PXP_INPUT_STORE_D_MASK4_H_CH0_D_MASK4_H_CH0(v)   (v)

#define HW_PXP_INPUT_STORE_D_MASK4_L_CH0	(0x00000770)

#define BP_PXP_INPUT_STORE_D_MASK4_L_CH0_D_MASK4_L_CH0      0
#define BM_PXP_INPUT_STORE_D_MASK4_L_CH0_D_MASK4_L_CH0 0xFFFFFFFF
#define BF_PXP_INPUT_STORE_D_MASK4_L_CH0_D_MASK4_L_CH0(v)   (v)

#define HW_PXP_INPUT_STORE_D_MASK5_H_CH0	(0x00000780)

#define BP_PXP_INPUT_STORE_D_MASK5_H_CH0_D_MASK5_H_CH0      0
#define BM_PXP_INPUT_STORE_D_MASK5_H_CH0_D_MASK5_H_CH0 0xFFFFFFFF
#define BF_PXP_INPUT_STORE_D_MASK5_H_CH0_D_MASK5_H_CH0(v)   (v)

#define HW_PXP_INPUT_STORE_D_MASK5_L_CH0	(0x00000790)

#define BP_PXP_INPUT_STORE_D_MASK5_L_CH0_D_MASK5_L_CH0      0
#define BM_PXP_INPUT_STORE_D_MASK5_L_CH0_D_MASK5_L_CH0 0xFFFFFFFF
#define BF_PXP_INPUT_STORE_D_MASK5_L_CH0_D_MASK5_L_CH0(v)   (v)

#define HW_PXP_INPUT_STORE_D_MASK6_H_CH0	(0x000007a0)

#define BP_PXP_INPUT_STORE_D_MASK6_H_CH0_D_MASK6_H_CH0      0
#define BM_PXP_INPUT_STORE_D_MASK6_H_CH0_D_MASK6_H_CH0 0xFFFFFFFF
#define BF_PXP_INPUT_STORE_D_MASK6_H_CH0_D_MASK6_H_CH0(v)   (v)

#define HW_PXP_INPUT_STORE_D_MASK6_L_CH0	(0x000007b0)

#define BP_PXP_INPUT_STORE_D_MASK6_L_CH0_D_MASK6_L_CH0      0
#define BM_PXP_INPUT_STORE_D_MASK6_L_CH0_D_MASK6_L_CH0 0xFFFFFFFF
#define BF_PXP_INPUT_STORE_D_MASK6_L_CH0_D_MASK6_L_CH0(v)   (v)

#define HW_PXP_INPUT_STORE_D_MASK7_H_CH0	(0x000007c0)

#define BP_PXP_INPUT_STORE_D_MASK7_H_CH0_D_MASK7_H_CH0      0
#define BM_PXP_INPUT_STORE_D_MASK7_H_CH0_D_MASK7_H_CH0 0xFFFFFFFF
#define BF_PXP_INPUT_STORE_D_MASK7_H_CH0_D_MASK7_H_CH0(v)   (v)

#define HW_PXP_INPUT_STORE_D_MASK7_L_CH0	(0x000007e0)

#define BP_PXP_INPUT_STORE_D_MASK7_L_CH0_D_MASK7_L_CH0      0
#define BM_PXP_INPUT_STORE_D_MASK7_L_CH0_D_MASK7_L_CH0 0xFFFFFFFF
#define BF_PXP_INPUT_STORE_D_MASK7_L_CH0_D_MASK7_L_CH0(v)   (v)

#define HW_PXP_INPUT_STORE_D_SHIFT_L_CH0	(0x000007f0)

#define BM_PXP_INPUT_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG3 0x80000000
#define BF_PXP_INPUT_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG3(v) \
        (((v) << 31) & BM_PXP_INPUT_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG3)
#define BM_PXP_INPUT_STORE_D_SHIFT_L_CH0_RSVD0 0x40000000
#define BF_PXP_INPUT_STORE_D_SHIFT_L_CH0_RSVD0(v)  \
        (((v) << 30) & BM_PXP_INPUT_STORE_D_SHIFT_L_CH0_RSVD0)
#define BP_PXP_INPUT_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH3      24
#define BM_PXP_INPUT_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH3 0x3F000000
#define BF_PXP_INPUT_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH3(v)  \
        (((v) << 24) & BM_PXP_INPUT_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH3)
#define BM_PXP_INPUT_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG2 0x00800000
#define BF_PXP_INPUT_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG2(v)  \
        (((v) << 23) & BM_PXP_INPUT_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG2)
#define BM_PXP_INPUT_STORE_D_SHIFT_L_CH0_RSVD1 0x00400000
#define BF_PXP_INPUT_STORE_D_SHIFT_L_CH0_RSVD1(v)  \
        (((v) << 22) & BM_PXP_INPUT_STORE_D_SHIFT_L_CH0_RSVD1)
#define BP_PXP_INPUT_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH2      16
#define BM_PXP_INPUT_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH2 0x003F0000
#define BF_PXP_INPUT_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH2(v)  \
        (((v) << 16) & BM_PXP_INPUT_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH2)
#define BM_PXP_INPUT_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG1 0x00008000
#define BF_PXP_INPUT_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG1(v)  \
        (((v) << 15) & BM_PXP_INPUT_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG1)
#define BM_PXP_INPUT_STORE_D_SHIFT_L_CH0_RSVD2 0x00004000
#define BF_PXP_INPUT_STORE_D_SHIFT_L_CH0_RSVD2(v)  \
        (((v) << 14) & BM_PXP_INPUT_STORE_D_SHIFT_L_CH0_RSVD2)
#define BP_PXP_INPUT_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH1      8
#define BM_PXP_INPUT_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH1 0x00003F00
#define BF_PXP_INPUT_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH1(v)  \
        (((v) << 8) & BM_PXP_INPUT_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH1)
#define BM_PXP_INPUT_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG0 0x00000080
#define BF_PXP_INPUT_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG0(v)  \
        (((v) << 7) & BM_PXP_INPUT_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG0)
#define BM_PXP_INPUT_STORE_D_SHIFT_L_CH0_RSVD3 0x00000040
#define BF_PXP_INPUT_STORE_D_SHIFT_L_CH0_RSVD3(v)  \
        (((v) << 6) & BM_PXP_INPUT_STORE_D_SHIFT_L_CH0_RSVD3)
#define BP_PXP_INPUT_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH0      0
#define BM_PXP_INPUT_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH0 0x0000003F
#define BF_PXP_INPUT_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH0(v)  \
        (((v) << 0) & BM_PXP_INPUT_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH0)

#define HW_PXP_INPUT_STORE_D_SHIFT_H_CH0	(0x00000800)

#define BM_PXP_INPUT_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG7 0x80000000
#define BF_PXP_INPUT_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG7(v) \
        (((v) << 31) & BM_PXP_INPUT_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG7)
#define BM_PXP_INPUT_STORE_D_SHIFT_H_CH0_RSVD0 0x40000000
#define BF_PXP_INPUT_STORE_D_SHIFT_H_CH0_RSVD0(v)  \
        (((v) << 30) & BM_PXP_INPUT_STORE_D_SHIFT_H_CH0_RSVD0)
#define BP_PXP_INPUT_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH7      24
#define BM_PXP_INPUT_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH7 0x3F000000
#define BF_PXP_INPUT_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH7(v)  \
        (((v) << 24) & BM_PXP_INPUT_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH7)
#define BM_PXP_INPUT_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG6 0x00800000
#define BF_PXP_INPUT_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG6(v)  \
        (((v) << 23) & BM_PXP_INPUT_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG6)
#define BM_PXP_INPUT_STORE_D_SHIFT_H_CH0_RSVD1 0x00400000
#define BF_PXP_INPUT_STORE_D_SHIFT_H_CH0_RSVD1(v)  \
        (((v) << 22) & BM_PXP_INPUT_STORE_D_SHIFT_H_CH0_RSVD1)
#define BP_PXP_INPUT_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH6      16
#define BM_PXP_INPUT_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH6 0x003F0000
#define BF_PXP_INPUT_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH6(v)  \
        (((v) << 16) & BM_PXP_INPUT_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH6)
#define BM_PXP_INPUT_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG5 0x00008000
#define BF_PXP_INPUT_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG5(v)  \
        (((v) << 15) & BM_PXP_INPUT_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG5)
#define BM_PXP_INPUT_STORE_D_SHIFT_H_CH0_RSVD2 0x00004000
#define BF_PXP_INPUT_STORE_D_SHIFT_H_CH0_RSVD2(v)  \
        (((v) << 14) & BM_PXP_INPUT_STORE_D_SHIFT_H_CH0_RSVD2)
#define BP_PXP_INPUT_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH5      8
#define BM_PXP_INPUT_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH5 0x00003F00
#define BF_PXP_INPUT_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH5(v)  \
        (((v) << 8) & BM_PXP_INPUT_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH5)
#define BM_PXP_INPUT_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG4 0x00000080
#define BF_PXP_INPUT_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG4(v)  \
        (((v) << 7) & BM_PXP_INPUT_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG4)
#define BM_PXP_INPUT_STORE_D_SHIFT_H_CH0_RSVD3 0x00000040
#define BF_PXP_INPUT_STORE_D_SHIFT_H_CH0_RSVD3(v)  \
        (((v) << 6) & BM_PXP_INPUT_STORE_D_SHIFT_H_CH0_RSVD3)
#define BP_PXP_INPUT_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH4      0
#define BM_PXP_INPUT_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH4 0x0000003F
#define BF_PXP_INPUT_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH4(v)  \
        (((v) << 0) & BM_PXP_INPUT_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH4)

#define HW_PXP_INPUT_STORE_F_SHIFT_L_CH0	(0x00000810)

#define BM_PXP_INPUT_STORE_F_SHIFT_L_CH0_RSVD0 0x80000000
#define BF_PXP_INPUT_STORE_F_SHIFT_L_CH0_RSVD0(v) \
        (((v) << 31) & BM_PXP_INPUT_STORE_F_SHIFT_L_CH0_RSVD0)
#define BM_PXP_INPUT_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG3 0x40000000
#define BF_PXP_INPUT_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG3(v)  \
        (((v) << 30) & BM_PXP_INPUT_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG3)
#define BP_PXP_INPUT_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH3      24
#define BM_PXP_INPUT_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH3 0x3F000000
#define BF_PXP_INPUT_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH3(v)  \
        (((v) << 24) & BM_PXP_INPUT_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH3)
#define BM_PXP_INPUT_STORE_F_SHIFT_L_CH0_RSVD1 0x00800000
#define BF_PXP_INPUT_STORE_F_SHIFT_L_CH0_RSVD1(v)  \
        (((v) << 23) & BM_PXP_INPUT_STORE_F_SHIFT_L_CH0_RSVD1)
#define BM_PXP_INPUT_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG2 0x00400000
#define BF_PXP_INPUT_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG2(v)  \
        (((v) << 22) & BM_PXP_INPUT_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG2)
#define BP_PXP_INPUT_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH2      16
#define BM_PXP_INPUT_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH2 0x003F0000
#define BF_PXP_INPUT_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH2(v)  \
        (((v) << 16) & BM_PXP_INPUT_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH2)
#define BM_PXP_INPUT_STORE_F_SHIFT_L_CH0_RSVD2 0x00008000
#define BF_PXP_INPUT_STORE_F_SHIFT_L_CH0_RSVD2(v)  \
        (((v) << 15) & BM_PXP_INPUT_STORE_F_SHIFT_L_CH0_RSVD2)
#define BM_PXP_INPUT_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG1 0x00004000
#define BF_PXP_INPUT_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG1(v)  \
        (((v) << 14) & BM_PXP_INPUT_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG1)
#define BP_PXP_INPUT_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH1      8
#define BM_PXP_INPUT_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH1 0x00003F00
#define BF_PXP_INPUT_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH1(v)  \
        (((v) << 8) & BM_PXP_INPUT_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH1)
#define BM_PXP_INPUT_STORE_F_SHIFT_L_CH0_RSVD3 0x00000080
#define BF_PXP_INPUT_STORE_F_SHIFT_L_CH0_RSVD3(v)  \
        (((v) << 7) & BM_PXP_INPUT_STORE_F_SHIFT_L_CH0_RSVD3)
#define BM_PXP_INPUT_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG0 0x00000040
#define BF_PXP_INPUT_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG0(v)  \
        (((v) << 6) & BM_PXP_INPUT_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG0)
#define BP_PXP_INPUT_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH0      0
#define BM_PXP_INPUT_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH0 0x0000003F
#define BF_PXP_INPUT_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH0(v)  \
        (((v) << 0) & BM_PXP_INPUT_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH0)

#define HW_PXP_INPUT_STORE_F_SHIFT_H_CH0	(0x00000820)

#define BM_PXP_INPUT_STORE_F_SHIFT_H_CH0_RSVD0 0x80000000
#define BF_PXP_INPUT_STORE_F_SHIFT_H_CH0_RSVD0(v) \
        (((v) << 31) & BM_PXP_INPUT_STORE_F_SHIFT_H_CH0_RSVD0)
#define BM_PXP_INPUT_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG7 0x40000000
#define BF_PXP_INPUT_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG7(v)  \
        (((v) << 30) & BM_PXP_INPUT_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG7)
#define BP_PXP_INPUT_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH7      24
#define BM_PXP_INPUT_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH7 0x3F000000
#define BF_PXP_INPUT_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH7(v)  \
        (((v) << 24) & BM_PXP_INPUT_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH7)
#define BM_PXP_INPUT_STORE_F_SHIFT_H_CH0_RSVD1 0x00800000
#define BF_PXP_INPUT_STORE_F_SHIFT_H_CH0_RSVD1(v)  \
        (((v) << 23) & BM_PXP_INPUT_STORE_F_SHIFT_H_CH0_RSVD1)
#define BM_PXP_INPUT_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG6 0x00400000
#define BF_PXP_INPUT_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG6(v)  \
        (((v) << 22) & BM_PXP_INPUT_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG6)
#define BP_PXP_INPUT_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH6      16
#define BM_PXP_INPUT_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH6 0x003F0000
#define BF_PXP_INPUT_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH6(v)  \
        (((v) << 16) & BM_PXP_INPUT_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH6)
#define BM_PXP_INPUT_STORE_F_SHIFT_H_CH0_RSVD2 0x00008000
#define BF_PXP_INPUT_STORE_F_SHIFT_H_CH0_RSVD2(v)  \
        (((v) << 15) & BM_PXP_INPUT_STORE_F_SHIFT_H_CH0_RSVD2)
#define BM_PXP_INPUT_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG5 0x00004000
#define BF_PXP_INPUT_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG5(v)  \
        (((v) << 14) & BM_PXP_INPUT_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG5)
#define BP_PXP_INPUT_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH5      8
#define BM_PXP_INPUT_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH5 0x00003F00
#define BF_PXP_INPUT_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH5(v)  \
        (((v) << 8) & BM_PXP_INPUT_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH5)
#define BM_PXP_INPUT_STORE_F_SHIFT_H_CH0_RSVD3 0x00000080
#define BF_PXP_INPUT_STORE_F_SHIFT_H_CH0_RSVD3(v)  \
        (((v) << 7) & BM_PXP_INPUT_STORE_F_SHIFT_H_CH0_RSVD3)
#define BM_PXP_INPUT_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG4 0x00000040
#define BF_PXP_INPUT_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG4(v)  \
        (((v) << 6) & BM_PXP_INPUT_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG4)
#define BP_PXP_INPUT_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH4      0
#define BM_PXP_INPUT_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH4 0x0000003F
#define BF_PXP_INPUT_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH4(v)  \
        (((v) << 0) & BM_PXP_INPUT_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH4)

#define HW_PXP_INPUT_STORE_F_MASK_L_CH0	(0x00000830)

#define BP_PXP_INPUT_STORE_F_MASK_L_CH0_F_MASK3      24
#define BM_PXP_INPUT_STORE_F_MASK_L_CH0_F_MASK3 0xFF000000
#define BF_PXP_INPUT_STORE_F_MASK_L_CH0_F_MASK3(v) \
        (((v) << 24) & BM_PXP_INPUT_STORE_F_MASK_L_CH0_F_MASK3)
#define BP_PXP_INPUT_STORE_F_MASK_L_CH0_F_MASK2      16
#define BM_PXP_INPUT_STORE_F_MASK_L_CH0_F_MASK2 0x00FF0000
#define BF_PXP_INPUT_STORE_F_MASK_L_CH0_F_MASK2(v)  \
        (((v) << 16) & BM_PXP_INPUT_STORE_F_MASK_L_CH0_F_MASK2)
#define BP_PXP_INPUT_STORE_F_MASK_L_CH0_F_MASK1      8
#define BM_PXP_INPUT_STORE_F_MASK_L_CH0_F_MASK1 0x0000FF00
#define BF_PXP_INPUT_STORE_F_MASK_L_CH0_F_MASK1(v)  \
        (((v) << 8) & BM_PXP_INPUT_STORE_F_MASK_L_CH0_F_MASK1)
#define BP_PXP_INPUT_STORE_F_MASK_L_CH0_F_MASK0      0
#define BM_PXP_INPUT_STORE_F_MASK_L_CH0_F_MASK0 0x000000FF
#define BF_PXP_INPUT_STORE_F_MASK_L_CH0_F_MASK0(v)  \
        (((v) << 0) & BM_PXP_INPUT_STORE_F_MASK_L_CH0_F_MASK0)

#define HW_PXP_INPUT_STORE_F_MASK_H_CH0	(0x00000840)

#define BP_PXP_INPUT_STORE_F_MASK_H_CH0_F_MASK7      24
#define BM_PXP_INPUT_STORE_F_MASK_H_CH0_F_MASK7 0xFF000000
#define BF_PXP_INPUT_STORE_F_MASK_H_CH0_F_MASK7(v) \
        (((v) << 24) & BM_PXP_INPUT_STORE_F_MASK_H_CH0_F_MASK7)
#define BP_PXP_INPUT_STORE_F_MASK_H_CH0_F_MASK6      16
#define BM_PXP_INPUT_STORE_F_MASK_H_CH0_F_MASK6 0x00FF0000
#define BF_PXP_INPUT_STORE_F_MASK_H_CH0_F_MASK6(v)  \
        (((v) << 16) & BM_PXP_INPUT_STORE_F_MASK_H_CH0_F_MASK6)
#define BP_PXP_INPUT_STORE_F_MASK_H_CH0_F_MASK5      8
#define BM_PXP_INPUT_STORE_F_MASK_H_CH0_F_MASK5 0x0000FF00
#define BF_PXP_INPUT_STORE_F_MASK_H_CH0_F_MASK5(v)  \
        (((v) << 8) & BM_PXP_INPUT_STORE_F_MASK_H_CH0_F_MASK5)
#define BP_PXP_INPUT_STORE_F_MASK_H_CH0_F_MASK4      0
#define BM_PXP_INPUT_STORE_F_MASK_H_CH0_F_MASK4 0x000000FF
#define BF_PXP_INPUT_STORE_F_MASK_H_CH0_F_MASK4(v)  \
        (((v) << 0) & BM_PXP_INPUT_STORE_F_MASK_H_CH0_F_MASK4)

#define HW_PXP_DITHER_FETCH_CTRL_CH0	(0x00000850)
#define HW_PXP_DITHER_FETCH_CTRL_CH0_SET	(0x00000854)
#define HW_PXP_DITHER_FETCH_CTRL_CH0_CLR	(0x00000858)
#define HW_PXP_DITHER_FETCH_CTRL_CH0_TOG	(0x0000085c)

#define BM_PXP_DITHER_FETCH_CTRL_CH0_ARBIT_EN 0x80000000
#define BF_PXP_DITHER_FETCH_CTRL_CH0_ARBIT_EN(v) \
        (((v) << 31) & BM_PXP_DITHER_FETCH_CTRL_CH0_ARBIT_EN)
#define BV_PXP_DITHER_FETCH_CTRL_CH0_ARBIT_EN__0 0x0
#define BV_PXP_DITHER_FETCH_CTRL_CH0_ARBIT_EN__1 0x1
#define BP_PXP_DITHER_FETCH_CTRL_CH0_RSVD0      26
#define BM_PXP_DITHER_FETCH_CTRL_CH0_RSVD0 0x7C000000
#define BF_PXP_DITHER_FETCH_CTRL_CH0_RSVD0(v)  \
        (((v) << 26) & BM_PXP_DITHER_FETCH_CTRL_CH0_RSVD0)
#define BP_PXP_DITHER_FETCH_CTRL_CH0_HANDSHAKE_SCAN_LINE_NUM      24
#define BM_PXP_DITHER_FETCH_CTRL_CH0_HANDSHAKE_SCAN_LINE_NUM 0x03000000
#define BF_PXP_DITHER_FETCH_CTRL_CH0_HANDSHAKE_SCAN_LINE_NUM(v)  \
        (((v) << 24) & BM_PXP_DITHER_FETCH_CTRL_CH0_HANDSHAKE_SCAN_LINE_NUM)
#define BV_PXP_DITHER_FETCH_CTRL_CH0_HANDSHAKE_SCAN_LINE_NUM__0 0x0
#define BV_PXP_DITHER_FETCH_CTRL_CH0_HANDSHAKE_SCAN_LINE_NUM__1 0x1
#define BV_PXP_DITHER_FETCH_CTRL_CH0_HANDSHAKE_SCAN_LINE_NUM__2 0x2
#define BV_PXP_DITHER_FETCH_CTRL_CH0_HANDSHAKE_SCAN_LINE_NUM__3 0x3
#define BP_PXP_DITHER_FETCH_CTRL_CH0_RSVD1      18
#define BM_PXP_DITHER_FETCH_CTRL_CH0_RSVD1 0x00FC0000
#define BF_PXP_DITHER_FETCH_CTRL_CH0_RSVD1(v)  \
        (((v) << 18) & BM_PXP_DITHER_FETCH_CTRL_CH0_RSVD1)
#define BP_PXP_DITHER_FETCH_CTRL_CH0_RD_NUM_BYTES      16
#define BM_PXP_DITHER_FETCH_CTRL_CH0_RD_NUM_BYTES 0x00030000
#define BF_PXP_DITHER_FETCH_CTRL_CH0_RD_NUM_BYTES(v)  \
        (((v) << 16) & BM_PXP_DITHER_FETCH_CTRL_CH0_RD_NUM_BYTES)
#define BV_PXP_DITHER_FETCH_CTRL_CH0_RD_NUM_BYTES__8_bytes  0x0
#define BV_PXP_DITHER_FETCH_CTRL_CH0_RD_NUM_BYTES__16_bytes 0x1
#define BV_PXP_DITHER_FETCH_CTRL_CH0_RD_NUM_BYTES__32_bytes 0x2
#define BV_PXP_DITHER_FETCH_CTRL_CH0_RD_NUM_BYTES__64_bytes 0x3
#define BP_PXP_DITHER_FETCH_CTRL_CH0_RSVD2      14
#define BM_PXP_DITHER_FETCH_CTRL_CH0_RSVD2 0x0000C000
#define BF_PXP_DITHER_FETCH_CTRL_CH0_RSVD2(v)  \
        (((v) << 14) & BM_PXP_DITHER_FETCH_CTRL_CH0_RSVD2)
#define BP_PXP_DITHER_FETCH_CTRL_CH0_ROTATION_ANGLE      12
#define BM_PXP_DITHER_FETCH_CTRL_CH0_ROTATION_ANGLE 0x00003000
#define BF_PXP_DITHER_FETCH_CTRL_CH0_ROTATION_ANGLE(v)  \
        (((v) << 12) & BM_PXP_DITHER_FETCH_CTRL_CH0_ROTATION_ANGLE)
#define BV_PXP_DITHER_FETCH_CTRL_CH0_ROTATION_ANGLE__ROT_0   0x0
#define BV_PXP_DITHER_FETCH_CTRL_CH0_ROTATION_ANGLE__ROT_90  0x1
#define BV_PXP_DITHER_FETCH_CTRL_CH0_ROTATION_ANGLE__ROT_180 0x2
#define BV_PXP_DITHER_FETCH_CTRL_CH0_ROTATION_ANGLE__ROT_270 0x3
#define BM_PXP_DITHER_FETCH_CTRL_CH0_RSVD3 0x00000800
#define BF_PXP_DITHER_FETCH_CTRL_CH0_RSVD3(v)  \
        (((v) << 11) & BM_PXP_DITHER_FETCH_CTRL_CH0_RSVD3)
#define BM_PXP_DITHER_FETCH_CTRL_CH0_VFLIP 0x00000400
#define BF_PXP_DITHER_FETCH_CTRL_CH0_VFLIP(v)  \
        (((v) << 10) & BM_PXP_DITHER_FETCH_CTRL_CH0_VFLIP)
#define BV_PXP_DITHER_FETCH_CTRL_CH0_VFLIP__0 0x0
#define BV_PXP_DITHER_FETCH_CTRL_CH0_VFLIP__1 0x1
#define BM_PXP_DITHER_FETCH_CTRL_CH0_HFLIP 0x00000200
#define BF_PXP_DITHER_FETCH_CTRL_CH0_HFLIP(v)  \
        (((v) << 9) & BM_PXP_DITHER_FETCH_CTRL_CH0_HFLIP)
#define BV_PXP_DITHER_FETCH_CTRL_CH0_HFLIP__0 0x0
#define BV_PXP_DITHER_FETCH_CTRL_CH0_HFLIP__1 0x1
#define BP_PXP_DITHER_FETCH_CTRL_CH0_RSVD4      6
#define BM_PXP_DITHER_FETCH_CTRL_CH0_RSVD4 0x000001C0
#define BF_PXP_DITHER_FETCH_CTRL_CH0_RSVD4(v)  \
        (((v) << 6) & BM_PXP_DITHER_FETCH_CTRL_CH0_RSVD4)
#define BM_PXP_DITHER_FETCH_CTRL_CH0_HIGH_BYTE 0x00000020
#define BF_PXP_DITHER_FETCH_CTRL_CH0_HIGH_BYTE(v)  \
        (((v) << 5) & BM_PXP_DITHER_FETCH_CTRL_CH0_HIGH_BYTE)
#define BV_PXP_DITHER_FETCH_CTRL_CH0_HIGH_BYTE__0 0x0
#define BV_PXP_DITHER_FETCH_CTRL_CH0_HIGH_BYTE__1 0x1
#define BM_PXP_DITHER_FETCH_CTRL_CH0_BYPASS_PIXEL_EN 0x00000010
#define BF_PXP_DITHER_FETCH_CTRL_CH0_BYPASS_PIXEL_EN(v)  \
        (((v) << 4) & BM_PXP_DITHER_FETCH_CTRL_CH0_BYPASS_PIXEL_EN)
#define BV_PXP_DITHER_FETCH_CTRL_CH0_BYPASS_PIXEL_EN__0 0x0
#define BV_PXP_DITHER_FETCH_CTRL_CH0_BYPASS_PIXEL_EN__1 0x1
#define BM_PXP_DITHER_FETCH_CTRL_CH0_HANDSHAKE_EN 0x00000008
#define BF_PXP_DITHER_FETCH_CTRL_CH0_HANDSHAKE_EN(v)  \
        (((v) << 3) & BM_PXP_DITHER_FETCH_CTRL_CH0_HANDSHAKE_EN)
#define BV_PXP_DITHER_FETCH_CTRL_CH0_HANDSHAKE_EN__0 0x0
#define BV_PXP_DITHER_FETCH_CTRL_CH0_HANDSHAKE_EN__1 0x1
#define BM_PXP_DITHER_FETCH_CTRL_CH0_BLOCK_16 0x00000004
#define BF_PXP_DITHER_FETCH_CTRL_CH0_BLOCK_16(v)  \
        (((v) << 2) & BM_PXP_DITHER_FETCH_CTRL_CH0_BLOCK_16)
#define BV_PXP_DITHER_FETCH_CTRL_CH0_BLOCK_16__8x8   0x0
#define BV_PXP_DITHER_FETCH_CTRL_CH0_BLOCK_16__16x16 0x1
#define BM_PXP_DITHER_FETCH_CTRL_CH0_BLOCK_EN 0x00000002
#define BF_PXP_DITHER_FETCH_CTRL_CH0_BLOCK_EN(v)  \
        (((v) << 1) & BM_PXP_DITHER_FETCH_CTRL_CH0_BLOCK_EN)
#define BV_PXP_DITHER_FETCH_CTRL_CH0_BLOCK_EN__0 0x0
#define BV_PXP_DITHER_FETCH_CTRL_CH0_BLOCK_EN__1 0x1
#define BM_PXP_DITHER_FETCH_CTRL_CH0_CH_EN 0x00000001
#define BF_PXP_DITHER_FETCH_CTRL_CH0_CH_EN(v)  \
        (((v) << 0) & BM_PXP_DITHER_FETCH_CTRL_CH0_CH_EN)
#define BV_PXP_DITHER_FETCH_CTRL_CH0_CH_EN__0 0x0
#define BV_PXP_DITHER_FETCH_CTRL_CH0_CH_EN__1 0x1

#define HW_PXP_DITHER_FETCH_CTRL_CH1	(0x00000860)
#define HW_PXP_DITHER_FETCH_CTRL_CH1_SET	(0x00000864)
#define HW_PXP_DITHER_FETCH_CTRL_CH1_CLR	(0x00000868)
#define HW_PXP_DITHER_FETCH_CTRL_CH1_TOG	(0x0000086c)

#define BP_PXP_DITHER_FETCH_CTRL_CH1_RSVD0      26
#define BM_PXP_DITHER_FETCH_CTRL_CH1_RSVD0 0xFC000000
#define BF_PXP_DITHER_FETCH_CTRL_CH1_RSVD0(v) \
        (((v) << 26) & BM_PXP_DITHER_FETCH_CTRL_CH1_RSVD0)
#define BP_PXP_DITHER_FETCH_CTRL_CH1_HANDSHAKE_SCAN_LINE_NUM      24
#define BM_PXP_DITHER_FETCH_CTRL_CH1_HANDSHAKE_SCAN_LINE_NUM 0x03000000
#define BF_PXP_DITHER_FETCH_CTRL_CH1_HANDSHAKE_SCAN_LINE_NUM(v)  \
        (((v) << 24) & BM_PXP_DITHER_FETCH_CTRL_CH1_HANDSHAKE_SCAN_LINE_NUM)
#define BV_PXP_DITHER_FETCH_CTRL_CH1_HANDSHAKE_SCAN_LINE_NUM__0 0x0
#define BV_PXP_DITHER_FETCH_CTRL_CH1_HANDSHAKE_SCAN_LINE_NUM__1 0x1
#define BV_PXP_DITHER_FETCH_CTRL_CH1_HANDSHAKE_SCAN_LINE_NUM__2 0x2
#define BV_PXP_DITHER_FETCH_CTRL_CH1_HANDSHAKE_SCAN_LINE_NUM__3 0x3
#define BP_PXP_DITHER_FETCH_CTRL_CH1_RSVD1      18
#define BM_PXP_DITHER_FETCH_CTRL_CH1_RSVD1 0x00FC0000
#define BF_PXP_DITHER_FETCH_CTRL_CH1_RSVD1(v)  \
        (((v) << 18) & BM_PXP_DITHER_FETCH_CTRL_CH1_RSVD1)
#define BP_PXP_DITHER_FETCH_CTRL_CH1_RD_NUM_BYTES      16
#define BM_PXP_DITHER_FETCH_CTRL_CH1_RD_NUM_BYTES 0x00030000
#define BF_PXP_DITHER_FETCH_CTRL_CH1_RD_NUM_BYTES(v)  \
        (((v) << 16) & BM_PXP_DITHER_FETCH_CTRL_CH1_RD_NUM_BYTES)
#define BV_PXP_DITHER_FETCH_CTRL_CH1_RD_NUM_BYTES__8_bytes  0x0
#define BV_PXP_DITHER_FETCH_CTRL_CH1_RD_NUM_BYTES__16_bytes 0x1
#define BV_PXP_DITHER_FETCH_CTRL_CH1_RD_NUM_BYTES__32_bytes 0x2
#define BV_PXP_DITHER_FETCH_CTRL_CH1_RD_NUM_BYTES__64_bytes 0x3
#define BP_PXP_DITHER_FETCH_CTRL_CH1_RSVD2      14
#define BM_PXP_DITHER_FETCH_CTRL_CH1_RSVD2 0x0000C000
#define BF_PXP_DITHER_FETCH_CTRL_CH1_RSVD2(v)  \
        (((v) << 14) & BM_PXP_DITHER_FETCH_CTRL_CH1_RSVD2)
#define BP_PXP_DITHER_FETCH_CTRL_CH1_ROTATION_ANGLE      12
#define BM_PXP_DITHER_FETCH_CTRL_CH1_ROTATION_ANGLE 0x00003000
#define BF_PXP_DITHER_FETCH_CTRL_CH1_ROTATION_ANGLE(v)  \
        (((v) << 12) & BM_PXP_DITHER_FETCH_CTRL_CH1_ROTATION_ANGLE)
#define BV_PXP_DITHER_FETCH_CTRL_CH1_ROTATION_ANGLE__ROT_0   0x0
#define BV_PXP_DITHER_FETCH_CTRL_CH1_ROTATION_ANGLE__ROT_90  0x1
#define BV_PXP_DITHER_FETCH_CTRL_CH1_ROTATION_ANGLE__ROT_180 0x2
#define BV_PXP_DITHER_FETCH_CTRL_CH1_ROTATION_ANGLE__ROT_270 0x3
#define BM_PXP_DITHER_FETCH_CTRL_CH1_RSVD3 0x00000800
#define BF_PXP_DITHER_FETCH_CTRL_CH1_RSVD3(v)  \
        (((v) << 11) & BM_PXP_DITHER_FETCH_CTRL_CH1_RSVD3)
#define BM_PXP_DITHER_FETCH_CTRL_CH1_VFLIP 0x00000400
#define BF_PXP_DITHER_FETCH_CTRL_CH1_VFLIP(v)  \
        (((v) << 10) & BM_PXP_DITHER_FETCH_CTRL_CH1_VFLIP)
#define BV_PXP_DITHER_FETCH_CTRL_CH1_VFLIP__0 0x0
#define BV_PXP_DITHER_FETCH_CTRL_CH1_VFLIP__1 0x1
#define BM_PXP_DITHER_FETCH_CTRL_CH1_HFLIP 0x00000200
#define BF_PXP_DITHER_FETCH_CTRL_CH1_HFLIP(v)  \
        (((v) << 9) & BM_PXP_DITHER_FETCH_CTRL_CH1_HFLIP)
#define BV_PXP_DITHER_FETCH_CTRL_CH1_HFLIP__0 0x0
#define BV_PXP_DITHER_FETCH_CTRL_CH1_HFLIP__1 0x1
#define BP_PXP_DITHER_FETCH_CTRL_CH1_RSVD4      5
#define BM_PXP_DITHER_FETCH_CTRL_CH1_RSVD4 0x000001E0
#define BF_PXP_DITHER_FETCH_CTRL_CH1_RSVD4(v)  \
        (((v) << 5) & BM_PXP_DITHER_FETCH_CTRL_CH1_RSVD4)
#define BM_PXP_DITHER_FETCH_CTRL_CH1_BYPASS_PIXEL_EN 0x00000010
#define BF_PXP_DITHER_FETCH_CTRL_CH1_BYPASS_PIXEL_EN(v)  \
        (((v) << 4) & BM_PXP_DITHER_FETCH_CTRL_CH1_BYPASS_PIXEL_EN)
#define BV_PXP_DITHER_FETCH_CTRL_CH1_BYPASS_PIXEL_EN__0 0x0
#define BV_PXP_DITHER_FETCH_CTRL_CH1_BYPASS_PIXEL_EN__1 0x1
#define BM_PXP_DITHER_FETCH_CTRL_CH1_HANDSHAKE_EN 0x00000008
#define BF_PXP_DITHER_FETCH_CTRL_CH1_HANDSHAKE_EN(v)  \
        (((v) << 3) & BM_PXP_DITHER_FETCH_CTRL_CH1_HANDSHAKE_EN)
#define BV_PXP_DITHER_FETCH_CTRL_CH1_HANDSHAKE_EN__0 0x0
#define BV_PXP_DITHER_FETCH_CTRL_CH1_HANDSHAKE_EN__1 0x1
#define BM_PXP_DITHER_FETCH_CTRL_CH1_BLOCK_16 0x00000004
#define BF_PXP_DITHER_FETCH_CTRL_CH1_BLOCK_16(v)  \
        (((v) << 2) & BM_PXP_DITHER_FETCH_CTRL_CH1_BLOCK_16)
#define BV_PXP_DITHER_FETCH_CTRL_CH1_BLOCK_16__8x8   0x0
#define BV_PXP_DITHER_FETCH_CTRL_CH1_BLOCK_16__16x16 0x1
#define BM_PXP_DITHER_FETCH_CTRL_CH1_BLOCK_EN 0x00000002
#define BF_PXP_DITHER_FETCH_CTRL_CH1_BLOCK_EN(v)  \
        (((v) << 1) & BM_PXP_DITHER_FETCH_CTRL_CH1_BLOCK_EN)
#define BV_PXP_DITHER_FETCH_CTRL_CH1_BLOCK_EN__0 0x0
#define BV_PXP_DITHER_FETCH_CTRL_CH1_BLOCK_EN__1 0x1
#define BM_PXP_DITHER_FETCH_CTRL_CH1_CH_EN 0x00000001
#define BF_PXP_DITHER_FETCH_CTRL_CH1_CH_EN(v)  \
        (((v) << 0) & BM_PXP_DITHER_FETCH_CTRL_CH1_CH_EN)
#define BV_PXP_DITHER_FETCH_CTRL_CH1_CH_EN__0 0x0
#define BV_PXP_DITHER_FETCH_CTRL_CH1_CH_EN__1 0x1

#define HW_PXP_DITHER_FETCH_STATUS_CH0	(0x00000870)

#define BP_PXP_DITHER_FETCH_STATUS_CH0_PREFETCH_BLOCK_Y      16
#define BM_PXP_DITHER_FETCH_STATUS_CH0_PREFETCH_BLOCK_Y 0xFFFF0000
#define BF_PXP_DITHER_FETCH_STATUS_CH0_PREFETCH_BLOCK_Y(v) \
        (((v) << 16) & BM_PXP_DITHER_FETCH_STATUS_CH0_PREFETCH_BLOCK_Y)
#define BP_PXP_DITHER_FETCH_STATUS_CH0_PREFETCH_BLOCK_X      0
#define BM_PXP_DITHER_FETCH_STATUS_CH0_PREFETCH_BLOCK_X 0x0000FFFF
#define BF_PXP_DITHER_FETCH_STATUS_CH0_PREFETCH_BLOCK_X(v)  \
        (((v) << 0) & BM_PXP_DITHER_FETCH_STATUS_CH0_PREFETCH_BLOCK_X)

#define HW_PXP_DITHER_FETCH_STATUS_CH1	(0x00000880)

#define BP_PXP_DITHER_FETCH_STATUS_CH1_PREFETCH_BLOCK_Y      16
#define BM_PXP_DITHER_FETCH_STATUS_CH1_PREFETCH_BLOCK_Y 0xFFFF0000
#define BF_PXP_DITHER_FETCH_STATUS_CH1_PREFETCH_BLOCK_Y(v) \
        (((v) << 16) & BM_PXP_DITHER_FETCH_STATUS_CH1_PREFETCH_BLOCK_Y)
#define BP_PXP_DITHER_FETCH_STATUS_CH1_PREFETCH_BLOCK_X      0
#define BM_PXP_DITHER_FETCH_STATUS_CH1_PREFETCH_BLOCK_X 0x0000FFFF
#define BF_PXP_DITHER_FETCH_STATUS_CH1_PREFETCH_BLOCK_X(v)  \
        (((v) << 0) & BM_PXP_DITHER_FETCH_STATUS_CH1_PREFETCH_BLOCK_X)

#define HW_PXP_DITHER_FETCH_ACTIVE_SIZE_ULC_CH0	(0x00000890)

#define BP_PXP_DITHER_FETCH_ACTIVE_SIZE_ULC_CH0_ACTIVE_SIZE_ULC_Y      16
#define BM_PXP_DITHER_FETCH_ACTIVE_SIZE_ULC_CH0_ACTIVE_SIZE_ULC_Y 0xFFFF0000
#define BF_PXP_DITHER_FETCH_ACTIVE_SIZE_ULC_CH0_ACTIVE_SIZE_ULC_Y(v) \
        (((v) << 16) & BM_PXP_DITHER_FETCH_ACTIVE_SIZE_ULC_CH0_ACTIVE_SIZE_ULC_Y)
#define BP_PXP_DITHER_FETCH_ACTIVE_SIZE_ULC_CH0_ACTIVE_SIZE_ULC_X      0
#define BM_PXP_DITHER_FETCH_ACTIVE_SIZE_ULC_CH0_ACTIVE_SIZE_ULC_X 0x0000FFFF
#define BF_PXP_DITHER_FETCH_ACTIVE_SIZE_ULC_CH0_ACTIVE_SIZE_ULC_X(v)  \
        (((v) << 0) & BM_PXP_DITHER_FETCH_ACTIVE_SIZE_ULC_CH0_ACTIVE_SIZE_ULC_X)

#define HW_PXP_DITHER_FETCH_ACTIVE_SIZE_LRC_CH0	(0x000008a0)

#define BP_PXP_DITHER_FETCH_ACTIVE_SIZE_LRC_CH0_ACTIVE_SIZE_LRC_Y      16
#define BM_PXP_DITHER_FETCH_ACTIVE_SIZE_LRC_CH0_ACTIVE_SIZE_LRC_Y 0xFFFF0000
#define BF_PXP_DITHER_FETCH_ACTIVE_SIZE_LRC_CH0_ACTIVE_SIZE_LRC_Y(v) \
        (((v) << 16) & BM_PXP_DITHER_FETCH_ACTIVE_SIZE_LRC_CH0_ACTIVE_SIZE_LRC_Y)
#define BP_PXP_DITHER_FETCH_ACTIVE_SIZE_LRC_CH0_ACTIVE_SIZE_LRC_X      0
#define BM_PXP_DITHER_FETCH_ACTIVE_SIZE_LRC_CH0_ACTIVE_SIZE_LRC_X 0x0000FFFF
#define BF_PXP_DITHER_FETCH_ACTIVE_SIZE_LRC_CH0_ACTIVE_SIZE_LRC_X(v)  \
        (((v) << 0) & BM_PXP_DITHER_FETCH_ACTIVE_SIZE_LRC_CH0_ACTIVE_SIZE_LRC_X)

#define HW_PXP_DITHER_FETCH_ACTIVE_SIZE_ULC_CH1	(0x000008b0)

#define BP_PXP_DITHER_FETCH_ACTIVE_SIZE_ULC_CH1_ACTIVE_SIZE_ULC_Y      16
#define BM_PXP_DITHER_FETCH_ACTIVE_SIZE_ULC_CH1_ACTIVE_SIZE_ULC_Y 0xFFFF0000
#define BF_PXP_DITHER_FETCH_ACTIVE_SIZE_ULC_CH1_ACTIVE_SIZE_ULC_Y(v) \
        (((v) << 16) & BM_PXP_DITHER_FETCH_ACTIVE_SIZE_ULC_CH1_ACTIVE_SIZE_ULC_Y)
#define BP_PXP_DITHER_FETCH_ACTIVE_SIZE_ULC_CH1_ACTIVE_SIZE_ULC_X      0
#define BM_PXP_DITHER_FETCH_ACTIVE_SIZE_ULC_CH1_ACTIVE_SIZE_ULC_X 0x0000FFFF
#define BF_PXP_DITHER_FETCH_ACTIVE_SIZE_ULC_CH1_ACTIVE_SIZE_ULC_X(v)  \
        (((v) << 0) & BM_PXP_DITHER_FETCH_ACTIVE_SIZE_ULC_CH1_ACTIVE_SIZE_ULC_X)

#define HW_PXP_DITHER_FETCH_ACTIVE_SIZE_LRC_CH1	(0x000008c0)

#define BP_PXP_DITHER_FETCH_ACTIVE_SIZE_LRC_CH1_ACTIVE_SIZE_LRC_Y      16
#define BM_PXP_DITHER_FETCH_ACTIVE_SIZE_LRC_CH1_ACTIVE_SIZE_LRC_Y 0xFFFF0000
#define BF_PXP_DITHER_FETCH_ACTIVE_SIZE_LRC_CH1_ACTIVE_SIZE_LRC_Y(v) \
        (((v) << 16) & BM_PXP_DITHER_FETCH_ACTIVE_SIZE_LRC_CH1_ACTIVE_SIZE_LRC_Y)
#define BP_PXP_DITHER_FETCH_ACTIVE_SIZE_LRC_CH1_ACTIVE_SIZE_LRC_X      0
#define BM_PXP_DITHER_FETCH_ACTIVE_SIZE_LRC_CH1_ACTIVE_SIZE_LRC_X 0x0000FFFF
#define BF_PXP_DITHER_FETCH_ACTIVE_SIZE_LRC_CH1_ACTIVE_SIZE_LRC_X(v)  \
        (((v) << 0) & BM_PXP_DITHER_FETCH_ACTIVE_SIZE_LRC_CH1_ACTIVE_SIZE_LRC_X)

#define HW_PXP_DITHER_FETCH_SIZE_CH0	(0x000008d0)

#define BP_PXP_DITHER_FETCH_SIZE_CH0_INPUT_TOTAL_HEIGHT      16
#define BM_PXP_DITHER_FETCH_SIZE_CH0_INPUT_TOTAL_HEIGHT 0xFFFF0000
#define BF_PXP_DITHER_FETCH_SIZE_CH0_INPUT_TOTAL_HEIGHT(v) \
        (((v) << 16) & BM_PXP_DITHER_FETCH_SIZE_CH0_INPUT_TOTAL_HEIGHT)
#define BP_PXP_DITHER_FETCH_SIZE_CH0_INPUT_TOTAL_WIDTH      0
#define BM_PXP_DITHER_FETCH_SIZE_CH0_INPUT_TOTAL_WIDTH 0x0000FFFF
#define BF_PXP_DITHER_FETCH_SIZE_CH0_INPUT_TOTAL_WIDTH(v)  \
        (((v) << 0) & BM_PXP_DITHER_FETCH_SIZE_CH0_INPUT_TOTAL_WIDTH)

#define HW_PXP_DITHER_FETCH_SIZE_CH1	(0x000008e0)

#define BP_PXP_DITHER_FETCH_SIZE_CH1_INPUT_TOTAL_HEIGHT      16
#define BM_PXP_DITHER_FETCH_SIZE_CH1_INPUT_TOTAL_HEIGHT 0xFFFF0000
#define BF_PXP_DITHER_FETCH_SIZE_CH1_INPUT_TOTAL_HEIGHT(v) \
        (((v) << 16) & BM_PXP_DITHER_FETCH_SIZE_CH1_INPUT_TOTAL_HEIGHT)
#define BP_PXP_DITHER_FETCH_SIZE_CH1_INPUT_TOTAL_WIDTH      0
#define BM_PXP_DITHER_FETCH_SIZE_CH1_INPUT_TOTAL_WIDTH 0x0000FFFF
#define BF_PXP_DITHER_FETCH_SIZE_CH1_INPUT_TOTAL_WIDTH(v)  \
        (((v) << 0) & BM_PXP_DITHER_FETCH_SIZE_CH1_INPUT_TOTAL_WIDTH)

#define HW_PXP_DITHER_FETCH_BACKGROUND_COLOR_CH0	(0x000008f0)

#define BP_PXP_DITHER_FETCH_BACKGROUND_COLOR_CH0_BACKGROUND_COLOR      0
#define BM_PXP_DITHER_FETCH_BACKGROUND_COLOR_CH0_BACKGROUND_COLOR 0xFFFFFFFF
#define BF_PXP_DITHER_FETCH_BACKGROUND_COLOR_CH0_BACKGROUND_COLOR(v)   (v)

#define HW_PXP_DITHER_FETCH_BACKGROUND_COLOR_CH1	(0x00000900)

#define BP_PXP_DITHER_FETCH_BACKGROUND_COLOR_CH1_BACKGROUND_COLOR      0
#define BM_PXP_DITHER_FETCH_BACKGROUND_COLOR_CH1_BACKGROUND_COLOR 0xFFFFFFFF
#define BF_PXP_DITHER_FETCH_BACKGROUND_COLOR_CH1_BACKGROUND_COLOR(v)   (v)

#define HW_PXP_DITHER_FETCH_PITCH	(0x00000910)

#define BP_PXP_DITHER_FETCH_PITCH_CH1_INPUT_PITCH      16
#define BM_PXP_DITHER_FETCH_PITCH_CH1_INPUT_PITCH 0xFFFF0000
#define BF_PXP_DITHER_FETCH_PITCH_CH1_INPUT_PITCH(v) \
        (((v) << 16) & BM_PXP_DITHER_FETCH_PITCH_CH1_INPUT_PITCH)
#define BP_PXP_DITHER_FETCH_PITCH_CH0_INPUT_PITCH      0
#define BM_PXP_DITHER_FETCH_PITCH_CH0_INPUT_PITCH 0x0000FFFF
#define BF_PXP_DITHER_FETCH_PITCH_CH0_INPUT_PITCH(v)  \
        (((v) << 0) & BM_PXP_DITHER_FETCH_PITCH_CH0_INPUT_PITCH)

#define HW_PXP_DITHER_FETCH_SHIFT_CTRL_CH0	(0x00000920)
#define HW_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_SET	(0x00000924)
#define HW_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_CLR	(0x00000928)
#define HW_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_TOG	(0x0000092c)

#define BP_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_RSVD0      13
#define BM_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_RSVD0 0xFFFFE000
#define BF_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_RSVD0(v) \
        (((v) << 13) & BM_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_RSVD0)
#define BM_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_SHIFT_BYPASS 0x00001000
#define BF_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_SHIFT_BYPASS(v)  \
        (((v) << 12) & BM_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_SHIFT_BYPASS)
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_SHIFT_BYPASS__0 0x0
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_SHIFT_BYPASS__1 0x1
#define BM_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_EXPAND_EN 0x00000800
#define BF_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_EXPAND_EN(v)  \
        (((v) << 11) & BM_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_EXPAND_EN)
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_EXPAND_EN__0 0x0
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_EXPAND_EN__1 0x1
#define BP_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_EXPAND_FORMAT      8
#define BM_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_EXPAND_FORMAT 0x00000700
#define BF_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_EXPAND_FORMAT(v)  \
        (((v) << 8) & BM_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_EXPAND_FORMAT)
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_EXPAND_FORMAT__0 0x0
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_EXPAND_FORMAT__1 0x1
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_EXPAND_FORMAT__2 0x2
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_EXPAND_FORMAT__3 0x3
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_EXPAND_FORMAT__4 0x4
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_EXPAND_FORMAT__5 0x5
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_EXPAND_FORMAT__6 0x6
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_EXPAND_FORMAT__7 0x7
#define BP_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_RSVD1      2
#define BM_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_RSVD1 0x000000FC
#define BF_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_RSVD1(v)  \
        (((v) << 2) & BM_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_RSVD1)
#define BP_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_INPUT_ACTIVE_BPP      0
#define BM_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_INPUT_ACTIVE_BPP 0x00000003
#define BF_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_INPUT_ACTIVE_BPP(v)  \
        (((v) << 0) & BM_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_INPUT_ACTIVE_BPP)
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_INPUT_ACTIVE_BPP__0 0x0
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_INPUT_ACTIVE_BPP__1 0x1
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_INPUT_ACTIVE_BPP__2 0x2
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH0_INPUT_ACTIVE_BPP__3 0x3

#define HW_PXP_DITHER_FETCH_SHIFT_CTRL_CH1	(0x00000930)
#define HW_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_SET	(0x00000934)
#define HW_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_CLR	(0x00000938)
#define HW_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_TOG	(0x0000093c)

#define BP_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_RSVD0      13
#define BM_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_RSVD0 0xFFFFE000
#define BF_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_RSVD0(v) \
        (((v) << 13) & BM_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_RSVD0)
#define BM_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_SHIFT_BYPASS 0x00001000
#define BF_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_SHIFT_BYPASS(v)  \
        (((v) << 12) & BM_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_SHIFT_BYPASS)
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_SHIFT_BYPASS__0 0x0
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_SHIFT_BYPASS__1 0x1
#define BM_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_EXPAND_EN 0x00000800
#define BF_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_EXPAND_EN(v)  \
        (((v) << 11) & BM_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_EXPAND_EN)
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_EXPAND_EN__0 0x0
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_EXPAND_EN__1 0x1
#define BP_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_EXPAND_FORMAT      8
#define BM_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_EXPAND_FORMAT 0x00000700
#define BF_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_EXPAND_FORMAT(v)  \
        (((v) << 8) & BM_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_EXPAND_FORMAT)
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_EXPAND_FORMAT__0 0x0
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_EXPAND_FORMAT__1 0x1
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_EXPAND_FORMAT__2 0x2
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_EXPAND_FORMAT__3 0x3
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_EXPAND_FORMAT__4 0x4
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_EXPAND_FORMAT__5 0x5
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_EXPAND_FORMAT__6 0x6
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_EXPAND_FORMAT__7 0x7
#define BP_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_RSVD1      2
#define BM_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_RSVD1 0x000000FC
#define BF_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_RSVD1(v)  \
        (((v) << 2) & BM_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_RSVD1)
#define BP_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_INPUT_ACTIVE_BPP      0
#define BM_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_INPUT_ACTIVE_BPP 0x00000003
#define BF_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_INPUT_ACTIVE_BPP(v)  \
        (((v) << 0) & BM_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_INPUT_ACTIVE_BPP)
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_INPUT_ACTIVE_BPP__0 0x0
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_INPUT_ACTIVE_BPP__1 0x1
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_INPUT_ACTIVE_BPP__2 0x2
#define BV_PXP_DITHER_FETCH_SHIFT_CTRL_CH1_INPUT_ACTIVE_BPP__3 0x3

#define HW_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0	(0x00000940)
#define HW_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_SET	(0x00000944)
#define HW_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_CLR	(0x00000948)
#define HW_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_TOG	(0x0000094c)

#define BP_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_RSVD0      29
#define BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_RSVD0 0xE0000000
#define BF_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_RSVD0(v) \
        (((v) << 29) & BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_RSVD0)
#define BP_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_OFFSET3      24
#define BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_OFFSET3 0x1F000000
#define BF_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_OFFSET3(v)  \
        (((v) << 24) & BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_OFFSET3)
#define BP_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_RSVD1      21
#define BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_RSVD1 0x00E00000
#define BF_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_RSVD1(v)  \
        (((v) << 21) & BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_RSVD1)
#define BP_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_OFFSET2      16
#define BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_OFFSET2 0x001F0000
#define BF_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_OFFSET2(v)  \
        (((v) << 16) & BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_OFFSET2)
#define BP_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_RSVD2      13
#define BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_RSVD2 0x0000E000
#define BF_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_RSVD2(v)  \
        (((v) << 13) & BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_RSVD2)
#define BP_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_OFFSET1      8
#define BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_OFFSET1 0x00001F00
#define BF_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_OFFSET1(v)  \
        (((v) << 8) & BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_OFFSET1)
#define BP_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_RSVD3      5
#define BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_RSVD3 0x000000E0
#define BF_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_RSVD3(v)  \
        (((v) << 5) & BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_RSVD3)
#define BP_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_OFFSET0      0
#define BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_OFFSET0 0x0000001F
#define BF_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_OFFSET0(v)  \
        (((v) << 0) & BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH0_OFFSET0)

#define HW_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1	(0x00000950)
#define HW_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_SET	(0x00000954)
#define HW_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_CLR	(0x00000958)
#define HW_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_TOG	(0x0000095c)

#define BP_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_RSVD0      29
#define BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_RSVD0 0xE0000000
#define BF_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_RSVD0(v) \
        (((v) << 29) & BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_RSVD0)
#define BP_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_OFFSET3      24
#define BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_OFFSET3 0x1F000000
#define BF_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_OFFSET3(v)  \
        (((v) << 24) & BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_OFFSET3)
#define BP_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_RSVD1      21
#define BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_RSVD1 0x00E00000
#define BF_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_RSVD1(v)  \
        (((v) << 21) & BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_RSVD1)
#define BP_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_OFFSET2      16
#define BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_OFFSET2 0x001F0000
#define BF_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_OFFSET2(v)  \
        (((v) << 16) & BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_OFFSET2)
#define BP_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_RSVD2      13
#define BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_RSVD2 0x0000E000
#define BF_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_RSVD2(v)  \
        (((v) << 13) & BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_RSVD2)
#define BP_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_OFFSET1      8
#define BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_OFFSET1 0x00001F00
#define BF_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_OFFSET1(v)  \
        (((v) << 8) & BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_OFFSET1)
#define BP_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_RSVD3      5
#define BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_RSVD3 0x000000E0
#define BF_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_RSVD3(v)  \
        (((v) << 5) & BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_RSVD3)
#define BP_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_OFFSET0      0
#define BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_OFFSET0 0x0000001F
#define BF_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_OFFSET0(v)  \
        (((v) << 0) & BM_PXP_DITHER_FETCH_SHIFT_OFFSET_CH1_OFFSET0)

#define HW_PXP_DITHER_FETCH_SHIFT_WIDTH_CH0	(0x00000960)
#define HW_PXP_DITHER_FETCH_SHIFT_WIDTH_CH0_SET	(0x00000964)
#define HW_PXP_DITHER_FETCH_SHIFT_WIDTH_CH0_CLR	(0x00000968)
#define HW_PXP_DITHER_FETCH_SHIFT_WIDTH_CH0_TOG	(0x0000096c)

#define BP_PXP_DITHER_FETCH_SHIFT_WIDTH_CH0_RSVD0      16
#define BM_PXP_DITHER_FETCH_SHIFT_WIDTH_CH0_RSVD0 0xFFFF0000
#define BF_PXP_DITHER_FETCH_SHIFT_WIDTH_CH0_RSVD0(v) \
        (((v) << 16) & BM_PXP_DITHER_FETCH_SHIFT_WIDTH_CH0_RSVD0)
#define BP_PXP_DITHER_FETCH_SHIFT_WIDTH_CH0_WIDTH3      12
#define BM_PXP_DITHER_FETCH_SHIFT_WIDTH_CH0_WIDTH3 0x0000F000
#define BF_PXP_DITHER_FETCH_SHIFT_WIDTH_CH0_WIDTH3(v)  \
        (((v) << 12) & BM_PXP_DITHER_FETCH_SHIFT_WIDTH_CH0_WIDTH3)
#define BP_PXP_DITHER_FETCH_SHIFT_WIDTH_CH0_WIDTH2      8
#define BM_PXP_DITHER_FETCH_SHIFT_WIDTH_CH0_WIDTH2 0x00000F00
#define BF_PXP_DITHER_FETCH_SHIFT_WIDTH_CH0_WIDTH2(v)  \
        (((v) << 8) & BM_PXP_DITHER_FETCH_SHIFT_WIDTH_CH0_WIDTH2)
#define BP_PXP_DITHER_FETCH_SHIFT_WIDTH_CH0_WIDTH1      4
#define BM_PXP_DITHER_FETCH_SHIFT_WIDTH_CH0_WIDTH1 0x000000F0
#define BF_PXP_DITHER_FETCH_SHIFT_WIDTH_CH0_WIDTH1(v)  \
        (((v) << 4) & BM_PXP_DITHER_FETCH_SHIFT_WIDTH_CH0_WIDTH1)
#define BP_PXP_DITHER_FETCH_SHIFT_WIDTH_CH0_WIDTH0      0
#define BM_PXP_DITHER_FETCH_SHIFT_WIDTH_CH0_WIDTH0 0x0000000F
#define BF_PXP_DITHER_FETCH_SHIFT_WIDTH_CH0_WIDTH0(v)  \
        (((v) << 0) & BM_PXP_DITHER_FETCH_SHIFT_WIDTH_CH0_WIDTH0)

#define HW_PXP_DITHER_FETCH_SHIFT_WIDTH_CH1	(0x00000970)
#define HW_PXP_DITHER_FETCH_SHIFT_WIDTH_CH1_SET	(0x00000974)
#define HW_PXP_DITHER_FETCH_SHIFT_WIDTH_CH1_CLR	(0x00000978)
#define HW_PXP_DITHER_FETCH_SHIFT_WIDTH_CH1_TOG	(0x0000097c)

#define BP_PXP_DITHER_FETCH_SHIFT_WIDTH_CH1_RSVD0      16
#define BM_PXP_DITHER_FETCH_SHIFT_WIDTH_CH1_RSVD0 0xFFFF0000
#define BF_PXP_DITHER_FETCH_SHIFT_WIDTH_CH1_RSVD0(v) \
        (((v) << 16) & BM_PXP_DITHER_FETCH_SHIFT_WIDTH_CH1_RSVD0)
#define BP_PXP_DITHER_FETCH_SHIFT_WIDTH_CH1_WIDTH3      12
#define BM_PXP_DITHER_FETCH_SHIFT_WIDTH_CH1_WIDTH3 0x0000F000
#define BF_PXP_DITHER_FETCH_SHIFT_WIDTH_CH1_WIDTH3(v)  \
        (((v) << 12) & BM_PXP_DITHER_FETCH_SHIFT_WIDTH_CH1_WIDTH3)
#define BP_PXP_DITHER_FETCH_SHIFT_WIDTH_CH1_WIDTH2      8
#define BM_PXP_DITHER_FETCH_SHIFT_WIDTH_CH1_WIDTH2 0x00000F00
#define BF_PXP_DITHER_FETCH_SHIFT_WIDTH_CH1_WIDTH2(v)  \
        (((v) << 8) & BM_PXP_DITHER_FETCH_SHIFT_WIDTH_CH1_WIDTH2)
#define BP_PXP_DITHER_FETCH_SHIFT_WIDTH_CH1_WIDTH1      4
#define BM_PXP_DITHER_FETCH_SHIFT_WIDTH_CH1_WIDTH1 0x000000F0
#define BF_PXP_DITHER_FETCH_SHIFT_WIDTH_CH1_WIDTH1(v)  \
        (((v) << 4) & BM_PXP_DITHER_FETCH_SHIFT_WIDTH_CH1_WIDTH1)
#define BP_PXP_DITHER_FETCH_SHIFT_WIDTH_CH1_WIDTH0      0
#define BM_PXP_DITHER_FETCH_SHIFT_WIDTH_CH1_WIDTH0 0x0000000F
#define BF_PXP_DITHER_FETCH_SHIFT_WIDTH_CH1_WIDTH0(v)  \
        (((v) << 0) & BM_PXP_DITHER_FETCH_SHIFT_WIDTH_CH1_WIDTH0)

#define HW_PXP_DITHER_FETCH_ADDR_0_CH0	(0x00000980)

#define BP_PXP_DITHER_FETCH_ADDR_0_CH0_INPUT_BASE_ADDR0      0
#define BM_PXP_DITHER_FETCH_ADDR_0_CH0_INPUT_BASE_ADDR0 0xFFFFFFFF
#define BF_PXP_DITHER_FETCH_ADDR_0_CH0_INPUT_BASE_ADDR0(v)   (v)

#define HW_PXP_DITHER_FETCH_ADDR_1_CH0	(0x00000990)

#define BP_PXP_DITHER_FETCH_ADDR_1_CH0_INPUT_BASE_ADDR1      0
#define BM_PXP_DITHER_FETCH_ADDR_1_CH0_INPUT_BASE_ADDR1 0xFFFFFFFF
#define BF_PXP_DITHER_FETCH_ADDR_1_CH0_INPUT_BASE_ADDR1(v)   (v)

#define HW_PXP_DITHER_FETCH_ADDR_0_CH1	(0x000009a0)

#define BP_PXP_DITHER_FETCH_ADDR_0_CH1_INPUT_BASE_ADDR0      0
#define BM_PXP_DITHER_FETCH_ADDR_0_CH1_INPUT_BASE_ADDR0 0xFFFFFFFF
#define BF_PXP_DITHER_FETCH_ADDR_0_CH1_INPUT_BASE_ADDR0(v)   (v)

#define HW_PXP_DITHER_FETCH_ADDR_1_CH1	(0x000009b0)

#define BP_PXP_DITHER_FETCH_ADDR_1_CH1_INPUT_BASE_ADDR1      0
#define BM_PXP_DITHER_FETCH_ADDR_1_CH1_INPUT_BASE_ADDR1 0xFFFFFFFF
#define BF_PXP_DITHER_FETCH_ADDR_1_CH1_INPUT_BASE_ADDR1(v)   (v)

#define HW_PXP_DITHER_STORE_CTRL_CH0	(0x000009c0)
#define HW_PXP_DITHER_STORE_CTRL_CH0_SET	(0x000009c4)
#define HW_PXP_DITHER_STORE_CTRL_CH0_CLR	(0x000009c8)
#define HW_PXP_DITHER_STORE_CTRL_CH0_TOG	(0x000009cc)

#define BM_PXP_DITHER_STORE_CTRL_CH0_ARBIT_EN 0x80000000
#define BF_PXP_DITHER_STORE_CTRL_CH0_ARBIT_EN(v) \
        (((v) << 31) & BM_PXP_DITHER_STORE_CTRL_CH0_ARBIT_EN)
#define BV_PXP_DITHER_STORE_CTRL_CH0_ARBIT_EN__0 0x0
#define BV_PXP_DITHER_STORE_CTRL_CH0_ARBIT_EN__1 0x1
#define BP_PXP_DITHER_STORE_CTRL_CH0_RSVD0      25
#define BM_PXP_DITHER_STORE_CTRL_CH0_RSVD0 0x7E000000
#define BF_PXP_DITHER_STORE_CTRL_CH0_RSVD0(v)  \
        (((v) << 25) & BM_PXP_DITHER_STORE_CTRL_CH0_RSVD0)
#define BM_PXP_DITHER_STORE_CTRL_CH0_COMBINE_2CHANNEL 0x01000000
#define BF_PXP_DITHER_STORE_CTRL_CH0_COMBINE_2CHANNEL(v)  \
        (((v) << 24) & BM_PXP_DITHER_STORE_CTRL_CH0_COMBINE_2CHANNEL)
#define BV_PXP_DITHER_STORE_CTRL_CH0_COMBINE_2CHANNEL__0 0x0
#define BV_PXP_DITHER_STORE_CTRL_CH0_COMBINE_2CHANNEL__1 0x1
#define BP_PXP_DITHER_STORE_CTRL_CH0_RSVD1      18
#define BM_PXP_DITHER_STORE_CTRL_CH0_RSVD1 0x00FC0000
#define BF_PXP_DITHER_STORE_CTRL_CH0_RSVD1(v)  \
        (((v) << 18) & BM_PXP_DITHER_STORE_CTRL_CH0_RSVD1)
#define BP_PXP_DITHER_STORE_CTRL_CH0_WR_NUM_BYTES      16
#define BM_PXP_DITHER_STORE_CTRL_CH0_WR_NUM_BYTES 0x00030000
#define BF_PXP_DITHER_STORE_CTRL_CH0_WR_NUM_BYTES(v)  \
        (((v) << 16) & BM_PXP_DITHER_STORE_CTRL_CH0_WR_NUM_BYTES)
#define BV_PXP_DITHER_STORE_CTRL_CH0_WR_NUM_BYTES__8_bytes  0x0
#define BV_PXP_DITHER_STORE_CTRL_CH0_WR_NUM_BYTES__16_bytes 0x1
#define BV_PXP_DITHER_STORE_CTRL_CH0_WR_NUM_BYTES__32_bytes 0x2
#define BV_PXP_DITHER_STORE_CTRL_CH0_WR_NUM_BYTES__64_bytes 0x3
#define BP_PXP_DITHER_STORE_CTRL_CH0_RSVD2      12
#define BM_PXP_DITHER_STORE_CTRL_CH0_RSVD2 0x0000F000
#define BF_PXP_DITHER_STORE_CTRL_CH0_RSVD2(v)  \
        (((v) << 12) & BM_PXP_DITHER_STORE_CTRL_CH0_RSVD2)
#define BM_PXP_DITHER_STORE_CTRL_CH0_FILL_DATA_EN 0x00000800
#define BF_PXP_DITHER_STORE_CTRL_CH0_FILL_DATA_EN(v)  \
        (((v) << 11) & BM_PXP_DITHER_STORE_CTRL_CH0_FILL_DATA_EN)
#define BV_PXP_DITHER_STORE_CTRL_CH0_FILL_DATA_EN__0 0x0
#define BV_PXP_DITHER_STORE_CTRL_CH0_FILL_DATA_EN__1 0x1
#define BM_PXP_DITHER_STORE_CTRL_CH0_PACK_IN_SEL 0x00000400
#define BF_PXP_DITHER_STORE_CTRL_CH0_PACK_IN_SEL(v)  \
        (((v) << 10) & BM_PXP_DITHER_STORE_CTRL_CH0_PACK_IN_SEL)
#define BV_PXP_DITHER_STORE_CTRL_CH0_PACK_IN_SEL__0 0x0
#define BV_PXP_DITHER_STORE_CTRL_CH0_PACK_IN_SEL__1 0x1
#define BM_PXP_DITHER_STORE_CTRL_CH0_STORE_MEMORY_EN 0x00000200
#define BF_PXP_DITHER_STORE_CTRL_CH0_STORE_MEMORY_EN(v)  \
        (((v) << 9) & BM_PXP_DITHER_STORE_CTRL_CH0_STORE_MEMORY_EN)
#define BV_PXP_DITHER_STORE_CTRL_CH0_STORE_MEMORY_EN__0 0x0
#define BV_PXP_DITHER_STORE_CTRL_CH0_STORE_MEMORY_EN__1 0x1
#define BM_PXP_DITHER_STORE_CTRL_CH0_STORE_BYPASS_EN 0x00000100
#define BF_PXP_DITHER_STORE_CTRL_CH0_STORE_BYPASS_EN(v)  \
        (((v) << 8) & BM_PXP_DITHER_STORE_CTRL_CH0_STORE_BYPASS_EN)
#define BV_PXP_DITHER_STORE_CTRL_CH0_STORE_BYPASS_EN__0 0x0
#define BV_PXP_DITHER_STORE_CTRL_CH0_STORE_BYPASS_EN__1 0x1
#define BM_PXP_DITHER_STORE_CTRL_CH0_RSVD3 0x00000080
#define BF_PXP_DITHER_STORE_CTRL_CH0_RSVD3(v)  \
        (((v) << 7) & BM_PXP_DITHER_STORE_CTRL_CH0_RSVD3)
#define BP_PXP_DITHER_STORE_CTRL_CH0_ARRAY_LINE_NUM      5
#define BM_PXP_DITHER_STORE_CTRL_CH0_ARRAY_LINE_NUM 0x00000060
#define BF_PXP_DITHER_STORE_CTRL_CH0_ARRAY_LINE_NUM(v)  \
        (((v) << 5) & BM_PXP_DITHER_STORE_CTRL_CH0_ARRAY_LINE_NUM)
#define BV_PXP_DITHER_STORE_CTRL_CH0_ARRAY_LINE_NUM__0 0x0
#define BV_PXP_DITHER_STORE_CTRL_CH0_ARRAY_LINE_NUM__1 0x1
#define BV_PXP_DITHER_STORE_CTRL_CH0_ARRAY_LINE_NUM__2 0x2
#define BV_PXP_DITHER_STORE_CTRL_CH0_ARRAY_LINE_NUM__3 0x3
#define BM_PXP_DITHER_STORE_CTRL_CH0_ARRAY_EN 0x00000010
#define BF_PXP_DITHER_STORE_CTRL_CH0_ARRAY_EN(v)  \
        (((v) << 4) & BM_PXP_DITHER_STORE_CTRL_CH0_ARRAY_EN)
#define BV_PXP_DITHER_STORE_CTRL_CH0_ARRAY_EN__0 0x0
#define BV_PXP_DITHER_STORE_CTRL_CH0_ARRAY_EN__1 0x1
#define BM_PXP_DITHER_STORE_CTRL_CH0_HANDSHAKE_EN 0x00000008
#define BF_PXP_DITHER_STORE_CTRL_CH0_HANDSHAKE_EN(v)  \
        (((v) << 3) & BM_PXP_DITHER_STORE_CTRL_CH0_HANDSHAKE_EN)
#define BV_PXP_DITHER_STORE_CTRL_CH0_HANDSHAKE_EN__0 0x0
#define BV_PXP_DITHER_STORE_CTRL_CH0_HANDSHAKE_EN__1 0x1
#define BM_PXP_DITHER_STORE_CTRL_CH0_BLOCK_16 0x00000004
#define BF_PXP_DITHER_STORE_CTRL_CH0_BLOCK_16(v)  \
        (((v) << 2) & BM_PXP_DITHER_STORE_CTRL_CH0_BLOCK_16)
#define BV_PXP_DITHER_STORE_CTRL_CH0_BLOCK_16__8x8   0x0
#define BV_PXP_DITHER_STORE_CTRL_CH0_BLOCK_16__16x16 0x1
#define BM_PXP_DITHER_STORE_CTRL_CH0_BLOCK_EN 0x00000002
#define BF_PXP_DITHER_STORE_CTRL_CH0_BLOCK_EN(v)  \
        (((v) << 1) & BM_PXP_DITHER_STORE_CTRL_CH0_BLOCK_EN)
#define BV_PXP_DITHER_STORE_CTRL_CH0_BLOCK_EN__0 0x0
#define BV_PXP_DITHER_STORE_CTRL_CH0_BLOCK_EN__1 0x1
#define BM_PXP_DITHER_STORE_CTRL_CH0_CH_EN 0x00000001
#define BF_PXP_DITHER_STORE_CTRL_CH0_CH_EN(v)  \
        (((v) << 0) & BM_PXP_DITHER_STORE_CTRL_CH0_CH_EN)
#define BV_PXP_DITHER_STORE_CTRL_CH0_CH_EN__0 0x0
#define BV_PXP_DITHER_STORE_CTRL_CH0_CH_EN__1 0x1

#define HW_PXP_DITHER_STORE_CTRL_CH1	(0x000009d0)
#define HW_PXP_DITHER_STORE_CTRL_CH1_SET	(0x000009d4)
#define HW_PXP_DITHER_STORE_CTRL_CH1_CLR	(0x000009d8)
#define HW_PXP_DITHER_STORE_CTRL_CH1_TOG	(0x000009dc)

#define BP_PXP_DITHER_STORE_CTRL_CH1_RSVD0      18
#define BM_PXP_DITHER_STORE_CTRL_CH1_RSVD0 0xFFFC0000
#define BF_PXP_DITHER_STORE_CTRL_CH1_RSVD0(v) \
        (((v) << 18) & BM_PXP_DITHER_STORE_CTRL_CH1_RSVD0)
#define BP_PXP_DITHER_STORE_CTRL_CH1_WR_NUM_BYTES      16
#define BM_PXP_DITHER_STORE_CTRL_CH1_WR_NUM_BYTES 0x00030000
#define BF_PXP_DITHER_STORE_CTRL_CH1_WR_NUM_BYTES(v)  \
        (((v) << 16) & BM_PXP_DITHER_STORE_CTRL_CH1_WR_NUM_BYTES)
#define BV_PXP_DITHER_STORE_CTRL_CH1_WR_NUM_BYTES__8_bytes  0x0
#define BV_PXP_DITHER_STORE_CTRL_CH1_WR_NUM_BYTES__16_bytes 0x1
#define BV_PXP_DITHER_STORE_CTRL_CH1_WR_NUM_BYTES__32_bytes 0x2
#define BV_PXP_DITHER_STORE_CTRL_CH1_WR_NUM_BYTES__64_bytes 0x3
#define BP_PXP_DITHER_STORE_CTRL_CH1_RSVD1      11
#define BM_PXP_DITHER_STORE_CTRL_CH1_RSVD1 0x0000F800
#define BF_PXP_DITHER_STORE_CTRL_CH1_RSVD1(v)  \
        (((v) << 11) & BM_PXP_DITHER_STORE_CTRL_CH1_RSVD1)
#define BM_PXP_DITHER_STORE_CTRL_CH1_PACK_IN_SEL 0x00000400
#define BF_PXP_DITHER_STORE_CTRL_CH1_PACK_IN_SEL(v)  \
        (((v) << 10) & BM_PXP_DITHER_STORE_CTRL_CH1_PACK_IN_SEL)
#define BV_PXP_DITHER_STORE_CTRL_CH1_PACK_IN_SEL__0 0x0
#define BV_PXP_DITHER_STORE_CTRL_CH1_PACK_IN_SEL__1 0x1
#define BM_PXP_DITHER_STORE_CTRL_CH1_STORE_MEMORY_EN 0x00000200
#define BF_PXP_DITHER_STORE_CTRL_CH1_STORE_MEMORY_EN(v)  \
        (((v) << 9) & BM_PXP_DITHER_STORE_CTRL_CH1_STORE_MEMORY_EN)
#define BV_PXP_DITHER_STORE_CTRL_CH1_STORE_MEMORY_EN__0 0x0
#define BV_PXP_DITHER_STORE_CTRL_CH1_STORE_MEMORY_EN__1 0x1
#define BM_PXP_DITHER_STORE_CTRL_CH1_STORE_BYPASS_EN 0x00000100
#define BF_PXP_DITHER_STORE_CTRL_CH1_STORE_BYPASS_EN(v)  \
        (((v) << 8) & BM_PXP_DITHER_STORE_CTRL_CH1_STORE_BYPASS_EN)
#define BV_PXP_DITHER_STORE_CTRL_CH1_STORE_BYPASS_EN__0 0x0
#define BV_PXP_DITHER_STORE_CTRL_CH1_STORE_BYPASS_EN__1 0x1
#define BM_PXP_DITHER_STORE_CTRL_CH1_RSVD3 0x00000080
#define BF_PXP_DITHER_STORE_CTRL_CH1_RSVD3(v)  \
        (((v) << 7) & BM_PXP_DITHER_STORE_CTRL_CH1_RSVD3)
#define BP_PXP_DITHER_STORE_CTRL_CH1_ARRAY_LINE_NUM      5
#define BM_PXP_DITHER_STORE_CTRL_CH1_ARRAY_LINE_NUM 0x00000060
#define BF_PXP_DITHER_STORE_CTRL_CH1_ARRAY_LINE_NUM(v)  \
        (((v) << 5) & BM_PXP_DITHER_STORE_CTRL_CH1_ARRAY_LINE_NUM)
#define BV_PXP_DITHER_STORE_CTRL_CH1_ARRAY_LINE_NUM__0 0x0
#define BV_PXP_DITHER_STORE_CTRL_CH1_ARRAY_LINE_NUM__1 0x1
#define BV_PXP_DITHER_STORE_CTRL_CH1_ARRAY_LINE_NUM__2 0x2
#define BV_PXP_DITHER_STORE_CTRL_CH1_ARRAY_LINE_NUM__3 0x3
#define BM_PXP_DITHER_STORE_CTRL_CH1_ARRAY_EN 0x00000010
#define BF_PXP_DITHER_STORE_CTRL_CH1_ARRAY_EN(v)  \
        (((v) << 4) & BM_PXP_DITHER_STORE_CTRL_CH1_ARRAY_EN)
#define BV_PXP_DITHER_STORE_CTRL_CH1_ARRAY_EN__0 0x0
#define BV_PXP_DITHER_STORE_CTRL_CH1_ARRAY_EN__1 0x1
#define BM_PXP_DITHER_STORE_CTRL_CH1_HANDSHAKE_EN 0x00000008
#define BF_PXP_DITHER_STORE_CTRL_CH1_HANDSHAKE_EN(v)  \
        (((v) << 3) & BM_PXP_DITHER_STORE_CTRL_CH1_HANDSHAKE_EN)
#define BV_PXP_DITHER_STORE_CTRL_CH1_HANDSHAKE_EN__0 0x0
#define BV_PXP_DITHER_STORE_CTRL_CH1_HANDSHAKE_EN__1 0x1
#define BM_PXP_DITHER_STORE_CTRL_CH1_BLOCK_16 0x00000004
#define BF_PXP_DITHER_STORE_CTRL_CH1_BLOCK_16(v)  \
        (((v) << 2) & BM_PXP_DITHER_STORE_CTRL_CH1_BLOCK_16)
#define BV_PXP_DITHER_STORE_CTRL_CH1_BLOCK_16__8x8   0x0
#define BV_PXP_DITHER_STORE_CTRL_CH1_BLOCK_16__16x16 0x1
#define BM_PXP_DITHER_STORE_CTRL_CH1_BLOCK_EN 0x00000002
#define BF_PXP_DITHER_STORE_CTRL_CH1_BLOCK_EN(v)  \
        (((v) << 1) & BM_PXP_DITHER_STORE_CTRL_CH1_BLOCK_EN)
#define BV_PXP_DITHER_STORE_CTRL_CH1_BLOCK_EN__0 0x0
#define BV_PXP_DITHER_STORE_CTRL_CH1_BLOCK_EN__1 0x1
#define BM_PXP_DITHER_STORE_CTRL_CH1_CH_EN 0x00000001
#define BF_PXP_DITHER_STORE_CTRL_CH1_CH_EN(v)  \
        (((v) << 0) & BM_PXP_DITHER_STORE_CTRL_CH1_CH_EN)
#define BV_PXP_DITHER_STORE_CTRL_CH1_CH_EN__0 0x0
#define BV_PXP_DITHER_STORE_CTRL_CH1_CH_EN__1 0x1

#define HW_PXP_DITHER_STORE_STATUS_CH0	(0x000009e0)

#define BP_PXP_DITHER_STORE_STATUS_CH0_STORE_BLOCK_Y      16
#define BM_PXP_DITHER_STORE_STATUS_CH0_STORE_BLOCK_Y 0xFFFF0000
#define BF_PXP_DITHER_STORE_STATUS_CH0_STORE_BLOCK_Y(v) \
        (((v) << 16) & BM_PXP_DITHER_STORE_STATUS_CH0_STORE_BLOCK_Y)
#define BP_PXP_DITHER_STORE_STATUS_CH0_STORE_BLOCK_X      0
#define BM_PXP_DITHER_STORE_STATUS_CH0_STORE_BLOCK_X 0x0000FFFF
#define BF_PXP_DITHER_STORE_STATUS_CH0_STORE_BLOCK_X(v)  \
        (((v) << 0) & BM_PXP_DITHER_STORE_STATUS_CH0_STORE_BLOCK_X)

#define HW_PXP_DITHER_STORE_STATUS_CH1	(0x000009f0)

#define BP_PXP_DITHER_STORE_STATUS_CH1_STORE_BLOCK_Y      16
#define BM_PXP_DITHER_STORE_STATUS_CH1_STORE_BLOCK_Y 0xFFFF0000
#define BF_PXP_DITHER_STORE_STATUS_CH1_STORE_BLOCK_Y(v) \
        (((v) << 16) & BM_PXP_DITHER_STORE_STATUS_CH1_STORE_BLOCK_Y)
#define BP_PXP_DITHER_STORE_STATUS_CH1_STORE_BLOCK_X      0
#define BM_PXP_DITHER_STORE_STATUS_CH1_STORE_BLOCK_X 0x0000FFFF
#define BF_PXP_DITHER_STORE_STATUS_CH1_STORE_BLOCK_X(v)  \
        (((v) << 0) & BM_PXP_DITHER_STORE_STATUS_CH1_STORE_BLOCK_X)

#define HW_PXP_DITHER_STORE_SIZE_CH0	(0x00000a00)

#define BP_PXP_DITHER_STORE_SIZE_CH0_OUT_HEIGHT      16
#define BM_PXP_DITHER_STORE_SIZE_CH0_OUT_HEIGHT 0xFFFF0000
#define BF_PXP_DITHER_STORE_SIZE_CH0_OUT_HEIGHT(v) \
        (((v) << 16) & BM_PXP_DITHER_STORE_SIZE_CH0_OUT_HEIGHT)
#define BP_PXP_DITHER_STORE_SIZE_CH0_OUT_WIDTH      0
#define BM_PXP_DITHER_STORE_SIZE_CH0_OUT_WIDTH 0x0000FFFF
#define BF_PXP_DITHER_STORE_SIZE_CH0_OUT_WIDTH(v)  \
        (((v) << 0) & BM_PXP_DITHER_STORE_SIZE_CH0_OUT_WIDTH)

#define HW_PXP_DITHER_STORE_SIZE_CH1	(0x00000a10)

#define BP_PXP_DITHER_STORE_SIZE_CH1_OUT_HEIGHT      16
#define BM_PXP_DITHER_STORE_SIZE_CH1_OUT_HEIGHT 0xFFFF0000
#define BF_PXP_DITHER_STORE_SIZE_CH1_OUT_HEIGHT(v) \
        (((v) << 16) & BM_PXP_DITHER_STORE_SIZE_CH1_OUT_HEIGHT)
#define BP_PXP_DITHER_STORE_SIZE_CH1_OUT_WIDTH      0
#define BM_PXP_DITHER_STORE_SIZE_CH1_OUT_WIDTH 0x0000FFFF
#define BF_PXP_DITHER_STORE_SIZE_CH1_OUT_WIDTH(v)  \
        (((v) << 0) & BM_PXP_DITHER_STORE_SIZE_CH1_OUT_WIDTH)

#define HW_PXP_DITHER_STORE_PITCH	(0x00000a20)

#define BP_PXP_DITHER_STORE_PITCH_CH1_OUT_PITCH      16
#define BM_PXP_DITHER_STORE_PITCH_CH1_OUT_PITCH 0xFFFF0000
#define BF_PXP_DITHER_STORE_PITCH_CH1_OUT_PITCH(v) \
        (((v) << 16) & BM_PXP_DITHER_STORE_PITCH_CH1_OUT_PITCH)
#define BP_PXP_DITHER_STORE_PITCH_CH0_OUT_PITCH      0
#define BM_PXP_DITHER_STORE_PITCH_CH0_OUT_PITCH 0x0000FFFF
#define BF_PXP_DITHER_STORE_PITCH_CH0_OUT_PITCH(v)  \
        (((v) << 0) & BM_PXP_DITHER_STORE_PITCH_CH0_OUT_PITCH)

#define HW_PXP_DITHER_STORE_SHIFT_CTRL_CH0	(0x00000a30)
#define HW_PXP_DITHER_STORE_SHIFT_CTRL_CH0_SET	(0x00000a34)
#define HW_PXP_DITHER_STORE_SHIFT_CTRL_CH0_CLR	(0x00000a38)
#define HW_PXP_DITHER_STORE_SHIFT_CTRL_CH0_TOG	(0x00000a3c)

#define BP_PXP_DITHER_STORE_SHIFT_CTRL_CH0_RSVD0      8
#define BM_PXP_DITHER_STORE_SHIFT_CTRL_CH0_RSVD0 0xFFFFFF00
#define BF_PXP_DITHER_STORE_SHIFT_CTRL_CH0_RSVD0(v) \
        (((v) << 8) & BM_PXP_DITHER_STORE_SHIFT_CTRL_CH0_RSVD0)
#define BM_PXP_DITHER_STORE_SHIFT_CTRL_CH0_SHIFT_BYPASS 0x00000080
#define BF_PXP_DITHER_STORE_SHIFT_CTRL_CH0_SHIFT_BYPASS(v)  \
        (((v) << 7) & BM_PXP_DITHER_STORE_SHIFT_CTRL_CH0_SHIFT_BYPASS)
#define BV_PXP_DITHER_STORE_SHIFT_CTRL_CH0_SHIFT_BYPASS__0 0x0
#define BV_PXP_DITHER_STORE_SHIFT_CTRL_CH0_SHIFT_BYPASS__1 0x1
#define BM_PXP_DITHER_STORE_SHIFT_CTRL_CH0_RSVD1 0x00000040
#define BF_PXP_DITHER_STORE_SHIFT_CTRL_CH0_RSVD1(v)  \
        (((v) << 6) & BM_PXP_DITHER_STORE_SHIFT_CTRL_CH0_RSVD1)
#define BM_PXP_DITHER_STORE_SHIFT_CTRL_CH0_OUT_YUV422_2P_EN 0x00000020
#define BF_PXP_DITHER_STORE_SHIFT_CTRL_CH0_OUT_YUV422_2P_EN(v)  \
        (((v) << 5) & BM_PXP_DITHER_STORE_SHIFT_CTRL_CH0_OUT_YUV422_2P_EN)
#define BV_PXP_DITHER_STORE_SHIFT_CTRL_CH0_OUT_YUV422_2P_EN__0 0x0
#define BV_PXP_DITHER_STORE_SHIFT_CTRL_CH0_OUT_YUV422_2P_EN__1 0x1
#define BM_PXP_DITHER_STORE_SHIFT_CTRL_CH0_OUT_YUV422_1P_EN 0x00000010
#define BF_PXP_DITHER_STORE_SHIFT_CTRL_CH0_OUT_YUV422_1P_EN(v)  \
        (((v) << 4) & BM_PXP_DITHER_STORE_SHIFT_CTRL_CH0_OUT_YUV422_1P_EN)
#define BV_PXP_DITHER_STORE_SHIFT_CTRL_CH0_OUT_YUV422_1P_EN__0 0x0
#define BV_PXP_DITHER_STORE_SHIFT_CTRL_CH0_OUT_YUV422_1P_EN__1 0x1
#define BP_PXP_DITHER_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP      2
#define BM_PXP_DITHER_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP 0x0000000C
#define BF_PXP_DITHER_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP(v)  \
        (((v) << 2) & BM_PXP_DITHER_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP)
#define BV_PXP_DITHER_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP__0 0x0
#define BV_PXP_DITHER_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP__1 0x1
#define BV_PXP_DITHER_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP__2 0x2
#define BV_PXP_DITHER_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP__3 0x3
#define BP_PXP_DITHER_STORE_SHIFT_CTRL_CH0_RSVD2      0
#define BM_PXP_DITHER_STORE_SHIFT_CTRL_CH0_RSVD2 0x00000003
#define BF_PXP_DITHER_STORE_SHIFT_CTRL_CH0_RSVD2(v)  \
        (((v) << 0) & BM_PXP_DITHER_STORE_SHIFT_CTRL_CH0_RSVD2)

#define HW_PXP_DITHER_STORE_SHIFT_CTRL_CH1	(0x00000a40)
#define HW_PXP_DITHER_STORE_SHIFT_CTRL_CH1_SET	(0x00000a44)
#define HW_PXP_DITHER_STORE_SHIFT_CTRL_CH1_CLR	(0x00000a48)
#define HW_PXP_DITHER_STORE_SHIFT_CTRL_CH1_TOG	(0x00000a4c)

#define BP_PXP_DITHER_STORE_SHIFT_CTRL_CH1_RSVD0      6
#define BM_PXP_DITHER_STORE_SHIFT_CTRL_CH1_RSVD0 0xFFFFFFC0
#define BF_PXP_DITHER_STORE_SHIFT_CTRL_CH1_RSVD0(v) \
        (((v) << 6) & BM_PXP_DITHER_STORE_SHIFT_CTRL_CH1_RSVD0)
#define BM_PXP_DITHER_STORE_SHIFT_CTRL_CH1_OUT_YUV422_2P_EN 0x00000020
#define BF_PXP_DITHER_STORE_SHIFT_CTRL_CH1_OUT_YUV422_2P_EN(v)  \
        (((v) << 5) & BM_PXP_DITHER_STORE_SHIFT_CTRL_CH1_OUT_YUV422_2P_EN)
#define BV_PXP_DITHER_STORE_SHIFT_CTRL_CH1_OUT_YUV422_2P_EN__0 0x0
#define BV_PXP_DITHER_STORE_SHIFT_CTRL_CH1_OUT_YUV422_2P_EN__1 0x1
#define BM_PXP_DITHER_STORE_SHIFT_CTRL_CH1_OUT_YUV422_1P_EN 0x00000010
#define BF_PXP_DITHER_STORE_SHIFT_CTRL_CH1_OUT_YUV422_1P_EN(v)  \
        (((v) << 4) & BM_PXP_DITHER_STORE_SHIFT_CTRL_CH1_OUT_YUV422_1P_EN)
#define BV_PXP_DITHER_STORE_SHIFT_CTRL_CH1_OUT_YUV422_1P_EN__0 0x0
#define BV_PXP_DITHER_STORE_SHIFT_CTRL_CH1_OUT_YUV422_1P_EN__1 0x1
#define BP_PXP_DITHER_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP      2
#define BM_PXP_DITHER_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP 0x0000000C
#define BF_PXP_DITHER_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP(v)  \
        (((v) << 2) & BM_PXP_DITHER_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP)
#define BV_PXP_DITHER_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP__0 0x0
#define BV_PXP_DITHER_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP__1 0x1
#define BV_PXP_DITHER_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP__2 0x2
#define BV_PXP_DITHER_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP__3 0x3
#define BP_PXP_DITHER_STORE_SHIFT_CTRL_CH1_RSVD2      0
#define BM_PXP_DITHER_STORE_SHIFT_CTRL_CH1_RSVD2 0x00000003
#define BF_PXP_DITHER_STORE_SHIFT_CTRL_CH1_RSVD2(v)  \
        (((v) << 0) & BM_PXP_DITHER_STORE_SHIFT_CTRL_CH1_RSVD2)

#define HW_PXP_DITHER_STORE_ADDR_0_CH0	(0x00000a90)

#define BP_PXP_DITHER_STORE_ADDR_0_CH0_OUT_BASE_ADDR0      0
#define BM_PXP_DITHER_STORE_ADDR_0_CH0_OUT_BASE_ADDR0 0xFFFFFFFF
#define BF_PXP_DITHER_STORE_ADDR_0_CH0_OUT_BASE_ADDR0(v)   (v)

#define HW_PXP_DITHER_STORE_ADDR_1_CH0	(0x00000aa0)

#define BP_PXP_DITHER_STORE_ADDR_1_CH0_OUT_BASE_ADDR1      0
#define BM_PXP_DITHER_STORE_ADDR_1_CH0_OUT_BASE_ADDR1 0xFFFFFFFF
#define BF_PXP_DITHER_STORE_ADDR_1_CH0_OUT_BASE_ADDR1(v)   (v)

#define HW_PXP_DITHER_STORE_FILL_DATA_CH0	(0x00000ab0)

#define BP_PXP_DITHER_STORE_FILL_DATA_CH0_FILL_DATA_CH0      0
#define BM_PXP_DITHER_STORE_FILL_DATA_CH0_FILL_DATA_CH0 0xFFFFFFFF
#define BF_PXP_DITHER_STORE_FILL_DATA_CH0_FILL_DATA_CH0(v)   (v)

#define HW_PXP_DITHER_STORE_ADDR_0_CH1	(0x00000ac0)

#define BP_PXP_DITHER_STORE_ADDR_0_CH1_OUT_BASE_ADDR0      0
#define BM_PXP_DITHER_STORE_ADDR_0_CH1_OUT_BASE_ADDR0 0xFFFFFFFF
#define BF_PXP_DITHER_STORE_ADDR_0_CH1_OUT_BASE_ADDR0(v)   (v)

#define HW_PXP_DITHER_STORE_ADDR_1_CH1	(0x00000ad0)

#define BP_PXP_DITHER_STORE_ADDR_1_CH1_OUT_BASE_ADDR1      0
#define BM_PXP_DITHER_STORE_ADDR_1_CH1_OUT_BASE_ADDR1 0xFFFFFFFF
#define BF_PXP_DITHER_STORE_ADDR_1_CH1_OUT_BASE_ADDR1(v)   (v)

#define HW_PXP_DITHER_STORE_D_MASK0_H_CH0	(0x00000ae0)

#define BP_PXP_DITHER_STORE_D_MASK0_H_CH0_D_MASK0_H_CH0      0
#define BM_PXP_DITHER_STORE_D_MASK0_H_CH0_D_MASK0_H_CH0 0xFFFFFFFF
#define BF_PXP_DITHER_STORE_D_MASK0_H_CH0_D_MASK0_H_CH0(v)   (v)

#define HW_PXP_DITHER_STORE_D_MASK0_L_CH0	(0x00000af0)

#define BP_PXP_DITHER_STORE_D_MASK0_L_CH0_D_MASK0_L_CH0      0
#define BM_PXP_DITHER_STORE_D_MASK0_L_CH0_D_MASK0_L_CH0 0xFFFFFFFF
#define BF_PXP_DITHER_STORE_D_MASK0_L_CH0_D_MASK0_L_CH0(v)   (v)

#define HW_PXP_DITHER_STORE_D_MASK1_H_CH0	(0x00000b00)

#define BP_PXP_DITHER_STORE_D_MASK1_H_CH0_D_MASK1_H_CH0      0
#define BM_PXP_DITHER_STORE_D_MASK1_H_CH0_D_MASK1_H_CH0 0xFFFFFFFF
#define BF_PXP_DITHER_STORE_D_MASK1_H_CH0_D_MASK1_H_CH0(v)   (v)

#define HW_PXP_DITHER_STORE_D_MASK1_L_CH0	(0x00000b10)

#define BP_PXP_DITHER_STORE_D_MASK1_L_CH0_D_MASK1_L_CH0      0
#define BM_PXP_DITHER_STORE_D_MASK1_L_CH0_D_MASK1_L_CH0 0xFFFFFFFF
#define BF_PXP_DITHER_STORE_D_MASK1_L_CH0_D_MASK1_L_CH0(v)   (v)

#define HW_PXP_DITHER_STORE_D_MASK2_H_CH0	(0x00000b20)

#define BP_PXP_DITHER_STORE_D_MASK2_H_CH0_D_MASK2_H_CH0      0
#define BM_PXP_DITHER_STORE_D_MASK2_H_CH0_D_MASK2_H_CH0 0xFFFFFFFF
#define BF_PXP_DITHER_STORE_D_MASK2_H_CH0_D_MASK2_H_CH0(v)   (v)

#define HW_PXP_DITHER_STORE_D_MASK2_L_CH0	(0x00000b30)

#define BP_PXP_DITHER_STORE_D_MASK2_L_CH0_D_MASK2_L_CH0      0
#define BM_PXP_DITHER_STORE_D_MASK2_L_CH0_D_MASK2_L_CH0 0xFFFFFFFF
#define BF_PXP_DITHER_STORE_D_MASK2_L_CH0_D_MASK2_L_CH0(v)   (v)

#define HW_PXP_DITHER_STORE_D_MASK3_H_CH0	(0x00000b40)

#define BP_PXP_DITHER_STORE_D_MASK3_H_CH0_D_MASK3_H_CH0      0
#define BM_PXP_DITHER_STORE_D_MASK3_H_CH0_D_MASK3_H_CH0 0xFFFFFFFF
#define BF_PXP_DITHER_STORE_D_MASK3_H_CH0_D_MASK3_H_CH0(v)   (v)

#define HW_PXP_DITHER_STORE_D_MASK3_L_CH0	(0x00000b50)

#define BP_PXP_DITHER_STORE_D_MASK3_L_CH0_D_MASK3_L_CH0      0
#define BM_PXP_DITHER_STORE_D_MASK3_L_CH0_D_MASK3_L_CH0 0xFFFFFFFF
#define BF_PXP_DITHER_STORE_D_MASK3_L_CH0_D_MASK3_L_CH0(v)   (v)

#define HW_PXP_DITHER_STORE_D_MASK4_H_CH0	(0x00000b60)

#define BP_PXP_DITHER_STORE_D_MASK4_H_CH0_D_MASK4_H_CH0      0
#define BM_PXP_DITHER_STORE_D_MASK4_H_CH0_D_MASK4_H_CH0 0xFFFFFFFF
#define BF_PXP_DITHER_STORE_D_MASK4_H_CH0_D_MASK4_H_CH0(v)   (v)

#define HW_PXP_DITHER_STORE_D_MASK4_L_CH0	(0x00000b70)

#define BP_PXP_DITHER_STORE_D_MASK4_L_CH0_D_MASK4_L_CH0      0
#define BM_PXP_DITHER_STORE_D_MASK4_L_CH0_D_MASK4_L_CH0 0xFFFFFFFF
#define BF_PXP_DITHER_STORE_D_MASK4_L_CH0_D_MASK4_L_CH0(v)   (v)

#define HW_PXP_DITHER_STORE_D_MASK5_H_CH0	(0x00000b80)

#define BP_PXP_DITHER_STORE_D_MASK5_H_CH0_D_MASK5_H_CH0      0
#define BM_PXP_DITHER_STORE_D_MASK5_H_CH0_D_MASK5_H_CH0 0xFFFFFFFF
#define BF_PXP_DITHER_STORE_D_MASK5_H_CH0_D_MASK5_H_CH0(v)   (v)

#define HW_PXP_DITHER_STORE_D_MASK5_L_CH0	(0x00000b90)

#define BP_PXP_DITHER_STORE_D_MASK5_L_CH0_D_MASK5_L_CH0      0
#define BM_PXP_DITHER_STORE_D_MASK5_L_CH0_D_MASK5_L_CH0 0xFFFFFFFF
#define BF_PXP_DITHER_STORE_D_MASK5_L_CH0_D_MASK5_L_CH0(v)   (v)

#define HW_PXP_DITHER_STORE_D_MASK6_H_CH0	(0x00000ba0)

#define BP_PXP_DITHER_STORE_D_MASK6_H_CH0_D_MASK6_H_CH0      0
#define BM_PXP_DITHER_STORE_D_MASK6_H_CH0_D_MASK6_H_CH0 0xFFFFFFFF
#define BF_PXP_DITHER_STORE_D_MASK6_H_CH0_D_MASK6_H_CH0(v)   (v)

#define HW_PXP_DITHER_STORE_D_MASK6_L_CH0	(0x00000bb0)

#define BP_PXP_DITHER_STORE_D_MASK6_L_CH0_D_MASK6_L_CH0      0
#define BM_PXP_DITHER_STORE_D_MASK6_L_CH0_D_MASK6_L_CH0 0xFFFFFFFF
#define BF_PXP_DITHER_STORE_D_MASK6_L_CH0_D_MASK6_L_CH0(v)   (v)

#define HW_PXP_DITHER_STORE_D_MASK7_H_CH0	(0x00000bc0)

#define BP_PXP_DITHER_STORE_D_MASK7_H_CH0_D_MASK7_H_CH0      0
#define BM_PXP_DITHER_STORE_D_MASK7_H_CH0_D_MASK7_H_CH0 0xFFFFFFFF
#define BF_PXP_DITHER_STORE_D_MASK7_H_CH0_D_MASK7_H_CH0(v)   (v)

#define HW_PXP_DITHER_STORE_D_MASK7_L_CH0	(0x00000bd0)

#define BP_PXP_DITHER_STORE_D_MASK7_L_CH0_D_MASK7_L_CH0      0
#define BM_PXP_DITHER_STORE_D_MASK7_L_CH0_D_MASK7_L_CH0 0xFFFFFFFF
#define BF_PXP_DITHER_STORE_D_MASK7_L_CH0_D_MASK7_L_CH0(v)   (v)

#define HW_PXP_DITHER_STORE_D_SHIFT_L_CH0	(0x00000be0)

#define BM_PXP_DITHER_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG3 0x80000000
#define BF_PXP_DITHER_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG3(v) \
        (((v) << 31) & BM_PXP_DITHER_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG3)
#define BM_PXP_DITHER_STORE_D_SHIFT_L_CH0_RSVD0 0x40000000
#define BF_PXP_DITHER_STORE_D_SHIFT_L_CH0_RSVD0(v)  \
        (((v) << 30) & BM_PXP_DITHER_STORE_D_SHIFT_L_CH0_RSVD0)
#define BP_PXP_DITHER_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH3      24
#define BM_PXP_DITHER_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH3 0x3F000000
#define BF_PXP_DITHER_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH3(v)  \
        (((v) << 24) & BM_PXP_DITHER_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH3)
#define BM_PXP_DITHER_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG2 0x00800000
#define BF_PXP_DITHER_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG2(v)  \
        (((v) << 23) & BM_PXP_DITHER_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG2)
#define BM_PXP_DITHER_STORE_D_SHIFT_L_CH0_RSVD1 0x00400000
#define BF_PXP_DITHER_STORE_D_SHIFT_L_CH0_RSVD1(v)  \
        (((v) << 22) & BM_PXP_DITHER_STORE_D_SHIFT_L_CH0_RSVD1)
#define BP_PXP_DITHER_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH2      16
#define BM_PXP_DITHER_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH2 0x003F0000
#define BF_PXP_DITHER_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH2(v)  \
        (((v) << 16) & BM_PXP_DITHER_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH2)
#define BM_PXP_DITHER_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG1 0x00008000
#define BF_PXP_DITHER_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG1(v)  \
        (((v) << 15) & BM_PXP_DITHER_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG1)
#define BM_PXP_DITHER_STORE_D_SHIFT_L_CH0_RSVD2 0x00004000
#define BF_PXP_DITHER_STORE_D_SHIFT_L_CH0_RSVD2(v)  \
        (((v) << 14) & BM_PXP_DITHER_STORE_D_SHIFT_L_CH0_RSVD2)
#define BP_PXP_DITHER_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH1      8
#define BM_PXP_DITHER_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH1 0x00003F00
#define BF_PXP_DITHER_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH1(v)  \
        (((v) << 8) & BM_PXP_DITHER_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH1)
#define BM_PXP_DITHER_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG0 0x00000080
#define BF_PXP_DITHER_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG0(v)  \
        (((v) << 7) & BM_PXP_DITHER_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG0)
#define BM_PXP_DITHER_STORE_D_SHIFT_L_CH0_RSVD3 0x00000040
#define BF_PXP_DITHER_STORE_D_SHIFT_L_CH0_RSVD3(v)  \
        (((v) << 6) & BM_PXP_DITHER_STORE_D_SHIFT_L_CH0_RSVD3)
#define BP_PXP_DITHER_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH0      0
#define BM_PXP_DITHER_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH0 0x0000003F
#define BF_PXP_DITHER_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH0(v)  \
        (((v) << 0) & BM_PXP_DITHER_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH0)

#define HW_PXP_DITHER_STORE_D_SHIFT_H_CH0	(0x00000bf0)

#define BM_PXP_DITHER_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG7 0x80000000
#define BF_PXP_DITHER_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG7(v) \
        (((v) << 31) & BM_PXP_DITHER_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG7)
#define BM_PXP_DITHER_STORE_D_SHIFT_H_CH0_RSVD0 0x40000000
#define BF_PXP_DITHER_STORE_D_SHIFT_H_CH0_RSVD0(v)  \
        (((v) << 30) & BM_PXP_DITHER_STORE_D_SHIFT_H_CH0_RSVD0)
#define BP_PXP_DITHER_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH7      24
#define BM_PXP_DITHER_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH7 0x3F000000
#define BF_PXP_DITHER_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH7(v)  \
        (((v) << 24) & BM_PXP_DITHER_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH7)
#define BM_PXP_DITHER_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG6 0x00800000
#define BF_PXP_DITHER_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG6(v)  \
        (((v) << 23) & BM_PXP_DITHER_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG6)
#define BM_PXP_DITHER_STORE_D_SHIFT_H_CH0_RSVD1 0x00400000
#define BF_PXP_DITHER_STORE_D_SHIFT_H_CH0_RSVD1(v)  \
        (((v) << 22) & BM_PXP_DITHER_STORE_D_SHIFT_H_CH0_RSVD1)
#define BP_PXP_DITHER_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH6      16
#define BM_PXP_DITHER_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH6 0x003F0000
#define BF_PXP_DITHER_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH6(v)  \
        (((v) << 16) & BM_PXP_DITHER_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH6)
#define BM_PXP_DITHER_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG5 0x00008000
#define BF_PXP_DITHER_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG5(v)  \
        (((v) << 15) & BM_PXP_DITHER_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG5)
#define BM_PXP_DITHER_STORE_D_SHIFT_H_CH0_RSVD2 0x00004000
#define BF_PXP_DITHER_STORE_D_SHIFT_H_CH0_RSVD2(v)  \
        (((v) << 14) & BM_PXP_DITHER_STORE_D_SHIFT_H_CH0_RSVD2)
#define BP_PXP_DITHER_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH5      8
#define BM_PXP_DITHER_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH5 0x00003F00
#define BF_PXP_DITHER_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH5(v)  \
        (((v) << 8) & BM_PXP_DITHER_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH5)
#define BM_PXP_DITHER_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG4 0x00000080
#define BF_PXP_DITHER_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG4(v)  \
        (((v) << 7) & BM_PXP_DITHER_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG4)
#define BM_PXP_DITHER_STORE_D_SHIFT_H_CH0_RSVD3 0x00000040
#define BF_PXP_DITHER_STORE_D_SHIFT_H_CH0_RSVD3(v)  \
        (((v) << 6) & BM_PXP_DITHER_STORE_D_SHIFT_H_CH0_RSVD3)
#define BP_PXP_DITHER_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH4      0
#define BM_PXP_DITHER_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH4 0x0000003F
#define BF_PXP_DITHER_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH4(v)  \
        (((v) << 0) & BM_PXP_DITHER_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH4)

#define HW_PXP_DITHER_STORE_F_SHIFT_L_CH0	(0x00000c00)

#define BM_PXP_DITHER_STORE_F_SHIFT_L_CH0_RSVD0 0x80000000
#define BF_PXP_DITHER_STORE_F_SHIFT_L_CH0_RSVD0(v) \
        (((v) << 31) & BM_PXP_DITHER_STORE_F_SHIFT_L_CH0_RSVD0)
#define BM_PXP_DITHER_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG3 0x40000000
#define BF_PXP_DITHER_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG3(v)  \
        (((v) << 30) & BM_PXP_DITHER_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG3)
#define BP_PXP_DITHER_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH3      24
#define BM_PXP_DITHER_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH3 0x3F000000
#define BF_PXP_DITHER_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH3(v)  \
        (((v) << 24) & BM_PXP_DITHER_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH3)
#define BM_PXP_DITHER_STORE_F_SHIFT_L_CH0_RSVD1 0x00800000
#define BF_PXP_DITHER_STORE_F_SHIFT_L_CH0_RSVD1(v)  \
        (((v) << 23) & BM_PXP_DITHER_STORE_F_SHIFT_L_CH0_RSVD1)
#define BM_PXP_DITHER_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG2 0x00400000
#define BF_PXP_DITHER_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG2(v)  \
        (((v) << 22) & BM_PXP_DITHER_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG2)
#define BP_PXP_DITHER_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH2      16
#define BM_PXP_DITHER_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH2 0x003F0000
#define BF_PXP_DITHER_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH2(v)  \
        (((v) << 16) & BM_PXP_DITHER_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH2)
#define BM_PXP_DITHER_STORE_F_SHIFT_L_CH0_RSVD2 0x00008000
#define BF_PXP_DITHER_STORE_F_SHIFT_L_CH0_RSVD2(v)  \
        (((v) << 15) & BM_PXP_DITHER_STORE_F_SHIFT_L_CH0_RSVD2)
#define BM_PXP_DITHER_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG1 0x00004000
#define BF_PXP_DITHER_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG1(v)  \
        (((v) << 14) & BM_PXP_DITHER_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG1)
#define BP_PXP_DITHER_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH1      8
#define BM_PXP_DITHER_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH1 0x00003F00
#define BF_PXP_DITHER_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH1(v)  \
        (((v) << 8) & BM_PXP_DITHER_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH1)
#define BM_PXP_DITHER_STORE_F_SHIFT_L_CH0_RSVD3 0x00000080
#define BF_PXP_DITHER_STORE_F_SHIFT_L_CH0_RSVD3(v)  \
        (((v) << 7) & BM_PXP_DITHER_STORE_F_SHIFT_L_CH0_RSVD3)
#define BM_PXP_DITHER_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG0 0x00000040
#define BF_PXP_DITHER_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG0(v)  \
        (((v) << 6) & BM_PXP_DITHER_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG0)
#define BP_PXP_DITHER_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH0      0
#define BM_PXP_DITHER_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH0 0x0000003F
#define BF_PXP_DITHER_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH0(v)  \
        (((v) << 0) & BM_PXP_DITHER_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH0)

#define HW_PXP_DITHER_STORE_F_SHIFT_H_CH0	(0x00000c10)

#define BM_PXP_DITHER_STORE_F_SHIFT_H_CH0_RSVD0 0x80000000
#define BF_PXP_DITHER_STORE_F_SHIFT_H_CH0_RSVD0(v) \
        (((v) << 31) & BM_PXP_DITHER_STORE_F_SHIFT_H_CH0_RSVD0)
#define BM_PXP_DITHER_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG7 0x40000000
#define BF_PXP_DITHER_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG7(v)  \
        (((v) << 30) & BM_PXP_DITHER_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG7)
#define BP_PXP_DITHER_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH7      24
#define BM_PXP_DITHER_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH7 0x3F000000
#define BF_PXP_DITHER_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH7(v)  \
        (((v) << 24) & BM_PXP_DITHER_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH7)
#define BM_PXP_DITHER_STORE_F_SHIFT_H_CH0_RSVD1 0x00800000
#define BF_PXP_DITHER_STORE_F_SHIFT_H_CH0_RSVD1(v)  \
        (((v) << 23) & BM_PXP_DITHER_STORE_F_SHIFT_H_CH0_RSVD1)
#define BM_PXP_DITHER_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG6 0x00400000
#define BF_PXP_DITHER_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG6(v)  \
        (((v) << 22) & BM_PXP_DITHER_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG6)
#define BP_PXP_DITHER_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH6      16
#define BM_PXP_DITHER_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH6 0x003F0000
#define BF_PXP_DITHER_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH6(v)  \
        (((v) << 16) & BM_PXP_DITHER_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH6)
#define BM_PXP_DITHER_STORE_F_SHIFT_H_CH0_RSVD2 0x00008000
#define BF_PXP_DITHER_STORE_F_SHIFT_H_CH0_RSVD2(v)  \
        (((v) << 15) & BM_PXP_DITHER_STORE_F_SHIFT_H_CH0_RSVD2)
#define BM_PXP_DITHER_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG5 0x00004000
#define BF_PXP_DITHER_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG5(v)  \
        (((v) << 14) & BM_PXP_DITHER_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG5)
#define BP_PXP_DITHER_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH5      8
#define BM_PXP_DITHER_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH5 0x00003F00
#define BF_PXP_DITHER_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH5(v)  \
        (((v) << 8) & BM_PXP_DITHER_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH5)
#define BM_PXP_DITHER_STORE_F_SHIFT_H_CH0_RSVD3 0x00000080
#define BF_PXP_DITHER_STORE_F_SHIFT_H_CH0_RSVD3(v)  \
        (((v) << 7) & BM_PXP_DITHER_STORE_F_SHIFT_H_CH0_RSVD3)
#define BM_PXP_DITHER_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG4 0x00000040
#define BF_PXP_DITHER_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG4(v)  \
        (((v) << 6) & BM_PXP_DITHER_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG4)
#define BP_PXP_DITHER_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH4      0
#define BM_PXP_DITHER_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH4 0x0000003F
#define BF_PXP_DITHER_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH4(v)  \
        (((v) << 0) & BM_PXP_DITHER_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH4)

#define HW_PXP_DITHER_STORE_F_MASK_L_CH0	(0x00000c20)

#define BP_PXP_DITHER_STORE_F_MASK_L_CH0_F_MASK3      24
#define BM_PXP_DITHER_STORE_F_MASK_L_CH0_F_MASK3 0xFF000000
#define BF_PXP_DITHER_STORE_F_MASK_L_CH0_F_MASK3(v) \
        (((v) << 24) & BM_PXP_DITHER_STORE_F_MASK_L_CH0_F_MASK3)
#define BP_PXP_DITHER_STORE_F_MASK_L_CH0_F_MASK2      16
#define BM_PXP_DITHER_STORE_F_MASK_L_CH0_F_MASK2 0x00FF0000
#define BF_PXP_DITHER_STORE_F_MASK_L_CH0_F_MASK2(v)  \
        (((v) << 16) & BM_PXP_DITHER_STORE_F_MASK_L_CH0_F_MASK2)
#define BP_PXP_DITHER_STORE_F_MASK_L_CH0_F_MASK1      8
#define BM_PXP_DITHER_STORE_F_MASK_L_CH0_F_MASK1 0x0000FF00
#define BF_PXP_DITHER_STORE_F_MASK_L_CH0_F_MASK1(v)  \
        (((v) << 8) & BM_PXP_DITHER_STORE_F_MASK_L_CH0_F_MASK1)
#define BP_PXP_DITHER_STORE_F_MASK_L_CH0_F_MASK0      0
#define BM_PXP_DITHER_STORE_F_MASK_L_CH0_F_MASK0 0x000000FF
#define BF_PXP_DITHER_STORE_F_MASK_L_CH0_F_MASK0(v)  \
        (((v) << 0) & BM_PXP_DITHER_STORE_F_MASK_L_CH0_F_MASK0)

#define HW_PXP_DITHER_STORE_F_MASK_H_CH0	(0x00000c30)

#define BP_PXP_DITHER_STORE_F_MASK_H_CH0_F_MASK7      24
#define BM_PXP_DITHER_STORE_F_MASK_H_CH0_F_MASK7 0xFF000000
#define BF_PXP_DITHER_STORE_F_MASK_H_CH0_F_MASK7(v) \
        (((v) << 24) & BM_PXP_DITHER_STORE_F_MASK_H_CH0_F_MASK7)
#define BP_PXP_DITHER_STORE_F_MASK_H_CH0_F_MASK6      16
#define BM_PXP_DITHER_STORE_F_MASK_H_CH0_F_MASK6 0x00FF0000
#define BF_PXP_DITHER_STORE_F_MASK_H_CH0_F_MASK6(v)  \
        (((v) << 16) & BM_PXP_DITHER_STORE_F_MASK_H_CH0_F_MASK6)
#define BP_PXP_DITHER_STORE_F_MASK_H_CH0_F_MASK5      8
#define BM_PXP_DITHER_STORE_F_MASK_H_CH0_F_MASK5 0x0000FF00
#define BF_PXP_DITHER_STORE_F_MASK_H_CH0_F_MASK5(v)  \
        (((v) << 8) & BM_PXP_DITHER_STORE_F_MASK_H_CH0_F_MASK5)
#define BP_PXP_DITHER_STORE_F_MASK_H_CH0_F_MASK4      0
#define BM_PXP_DITHER_STORE_F_MASK_H_CH0_F_MASK4 0x000000FF
#define BF_PXP_DITHER_STORE_F_MASK_H_CH0_F_MASK4(v)  \
        (((v) << 0) & BM_PXP_DITHER_STORE_F_MASK_H_CH0_F_MASK4)

#define HW_PXP_WFA_FETCH_CTRL	(0x00000c40)
#define HW_PXP_WFA_FETCH_CTRL_SET	(0x00000c44)
#define HW_PXP_WFA_FETCH_CTRL_CLR	(0x00000c48)
#define HW_PXP_WFA_FETCH_CTRL_TOG	(0x00000c4c)

#define BM_PXP_WFA_FETCH_CTRL_BUF2_DONE_IRQ_EN 0x80000000
#define BF_PXP_WFA_FETCH_CTRL_BUF2_DONE_IRQ_EN(v) \
        (((v) << 31) & BM_PXP_WFA_FETCH_CTRL_BUF2_DONE_IRQ_EN)
#define BM_PXP_WFA_FETCH_CTRL_BUF1_DONE_IRQ_EN 0x40000000
#define BF_PXP_WFA_FETCH_CTRL_BUF1_DONE_IRQ_EN(v)  \
        (((v) << 30) & BM_PXP_WFA_FETCH_CTRL_BUF1_DONE_IRQ_EN)
#define BM_PXP_WFA_FETCH_CTRL_BUF2_DONE_IRQ 0x20000000
#define BF_PXP_WFA_FETCH_CTRL_BUF2_DONE_IRQ(v)  \
        (((v) << 29) & BM_PXP_WFA_FETCH_CTRL_BUF2_DONE_IRQ)
#define BM_PXP_WFA_FETCH_CTRL_BUF1_DONE_IRQ 0x10000000
#define BF_PXP_WFA_FETCH_CTRL_BUF1_DONE_IRQ(v)  \
        (((v) << 28) & BM_PXP_WFA_FETCH_CTRL_BUF1_DONE_IRQ)
#define BP_PXP_WFA_FETCH_CTRL_RSVD0      24
#define BM_PXP_WFA_FETCH_CTRL_RSVD0 0x0F000000
#define BF_PXP_WFA_FETCH_CTRL_RSVD0(v)  \
        (((v) << 24) & BM_PXP_WFA_FETCH_CTRL_RSVD0)
#define BP_PXP_WFA_FETCH_CTRL_BF2_LINE_MODE      22
#define BM_PXP_WFA_FETCH_CTRL_BF2_LINE_MODE 0x00C00000
#define BF_PXP_WFA_FETCH_CTRL_BF2_LINE_MODE(v)  \
        (((v) << 22) & BM_PXP_WFA_FETCH_CTRL_BF2_LINE_MODE)
#define BV_PXP_WFA_FETCH_CTRL_BF2_LINE_MODE__0 0x0
#define BV_PXP_WFA_FETCH_CTRL_BF2_LINE_MODE__1 0x1
#define BV_PXP_WFA_FETCH_CTRL_BF2_LINE_MODE__2 0x2
#define BV_PXP_WFA_FETCH_CTRL_BF2_LINE_MODE__3 0x3
#define BP_PXP_WFA_FETCH_CTRL_BF2_BYTES_PP      20
#define BM_PXP_WFA_FETCH_CTRL_BF2_BYTES_PP 0x00300000
#define BF_PXP_WFA_FETCH_CTRL_BF2_BYTES_PP(v)  \
        (((v) << 20) & BM_PXP_WFA_FETCH_CTRL_BF2_BYTES_PP)
#define BP_PXP_WFA_FETCH_CTRL_BF1_LINE_MODE      18
#define BM_PXP_WFA_FETCH_CTRL_BF1_LINE_MODE 0x000C0000
#define BF_PXP_WFA_FETCH_CTRL_BF1_LINE_MODE(v)  \
        (((v) << 18) & BM_PXP_WFA_FETCH_CTRL_BF1_LINE_MODE)
#define BV_PXP_WFA_FETCH_CTRL_BF1_LINE_MODE__0 0x0
#define BV_PXP_WFA_FETCH_CTRL_BF1_LINE_MODE__1 0x1
#define BV_PXP_WFA_FETCH_CTRL_BF1_LINE_MODE__2 0x2
#define BV_PXP_WFA_FETCH_CTRL_BF1_LINE_MODE__3 0x3
#define BP_PXP_WFA_FETCH_CTRL_BF1_BYTES_PP      16
#define BM_PXP_WFA_FETCH_CTRL_BF1_BYTES_PP 0x00030000
#define BF_PXP_WFA_FETCH_CTRL_BF1_BYTES_PP(v)  \
        (((v) << 16) & BM_PXP_WFA_FETCH_CTRL_BF1_BYTES_PP)
#define BP_PXP_WFA_FETCH_CTRL_RSVD1      14
#define BM_PXP_WFA_FETCH_CTRL_RSVD1 0x0000C000
#define BF_PXP_WFA_FETCH_CTRL_RSVD1(v)  \
        (((v) << 14) & BM_PXP_WFA_FETCH_CTRL_RSVD1)
#define BM_PXP_WFA_FETCH_CTRL_BF2_BORDER_MODE 0x00002000
#define BF_PXP_WFA_FETCH_CTRL_BF2_BORDER_MODE(v)  \
        (((v) << 13) & BM_PXP_WFA_FETCH_CTRL_BF2_BORDER_MODE)
#define BV_PXP_WFA_FETCH_CTRL_BF2_BORDER_MODE__0 0x0
#define BV_PXP_WFA_FETCH_CTRL_BF2_BORDER_MODE__1 0x1
#define BM_PXP_WFA_FETCH_CTRL_BF2_BURST_LEN 0x00001000
#define BF_PXP_WFA_FETCH_CTRL_BF2_BURST_LEN(v)  \
        (((v) << 12) & BM_PXP_WFA_FETCH_CTRL_BF2_BURST_LEN)
#define BV_PXP_WFA_FETCH_CTRL_BF2_BURST_LEN__0 0x0
#define BV_PXP_WFA_FETCH_CTRL_BF2_BURST_LEN__1 0x1
#define BM_PXP_WFA_FETCH_CTRL_BF2_BYPASS_MODE 0x00000800
#define BF_PXP_WFA_FETCH_CTRL_BF2_BYPASS_MODE(v)  \
        (((v) << 11) & BM_PXP_WFA_FETCH_CTRL_BF2_BYPASS_MODE)
#define BV_PXP_WFA_FETCH_CTRL_BF2_BYPASS_MODE__0 0x0
#define BV_PXP_WFA_FETCH_CTRL_BF2_BYPASS_MODE__1 0x1
#define BM_PXP_WFA_FETCH_CTRL_BF2_HSK_MODE 0x00000400
#define BF_PXP_WFA_FETCH_CTRL_BF2_HSK_MODE(v)  \
        (((v) << 10) & BM_PXP_WFA_FETCH_CTRL_BF2_HSK_MODE)
#define BV_PXP_WFA_FETCH_CTRL_BF2_HSK_MODE__0 0x0
#define BV_PXP_WFA_FETCH_CTRL_BF2_HSK_MODE__1 0x1
#define BM_PXP_WFA_FETCH_CTRL_BF2_SRAM_IF 0x00000200
#define BF_PXP_WFA_FETCH_CTRL_BF2_SRAM_IF(v)  \
        (((v) << 9) & BM_PXP_WFA_FETCH_CTRL_BF2_SRAM_IF)
#define BV_PXP_WFA_FETCH_CTRL_BF2_SRAM_IF__0 0x0
#define BV_PXP_WFA_FETCH_CTRL_BF2_SRAM_IF__1 0x1
#define BM_PXP_WFA_FETCH_CTRL_BF2_EN 0x00000100
#define BF_PXP_WFA_FETCH_CTRL_BF2_EN(v)  \
        (((v) << 8) & BM_PXP_WFA_FETCH_CTRL_BF2_EN)
#define BV_PXP_WFA_FETCH_CTRL_BF2_EN__0 0x0
#define BV_PXP_WFA_FETCH_CTRL_BF2_EN__1 0x1
#define BP_PXP_WFA_FETCH_CTRL_RSVD2      6
#define BM_PXP_WFA_FETCH_CTRL_RSVD2 0x000000C0
#define BF_PXP_WFA_FETCH_CTRL_RSVD2(v)  \
        (((v) << 6) & BM_PXP_WFA_FETCH_CTRL_RSVD2)
#define BM_PXP_WFA_FETCH_CTRL_BF1_BORDER_MODE 0x00000020
#define BF_PXP_WFA_FETCH_CTRL_BF1_BORDER_MODE(v)  \
        (((v) << 5) & BM_PXP_WFA_FETCH_CTRL_BF1_BORDER_MODE)
#define BV_PXP_WFA_FETCH_CTRL_BF1_BORDER_MODE__0 0x0
#define BV_PXP_WFA_FETCH_CTRL_BF1_BORDER_MODE__1 0x1
#define BM_PXP_WFA_FETCH_CTRL_BF1_BURST_LEN 0x00000010
#define BF_PXP_WFA_FETCH_CTRL_BF1_BURST_LEN(v)  \
        (((v) << 4) & BM_PXP_WFA_FETCH_CTRL_BF1_BURST_LEN)
#define BV_PXP_WFA_FETCH_CTRL_BF1_BURST_LEN__0 0x0
#define BV_PXP_WFA_FETCH_CTRL_BF1_BURST_LEN__1 0x1
#define BM_PXP_WFA_FETCH_CTRL_BF1_BYPASS_MODE 0x00000008
#define BF_PXP_WFA_FETCH_CTRL_BF1_BYPASS_MODE(v)  \
        (((v) << 3) & BM_PXP_WFA_FETCH_CTRL_BF1_BYPASS_MODE)
#define BV_PXP_WFA_FETCH_CTRL_BF1_BYPASS_MODE__0 0x0
#define BV_PXP_WFA_FETCH_CTRL_BF1_BYPASS_MODE__1 0x1
#define BM_PXP_WFA_FETCH_CTRL_BF1_HSK_MODE 0x00000004
#define BF_PXP_WFA_FETCH_CTRL_BF1_HSK_MODE(v)  \
        (((v) << 2) & BM_PXP_WFA_FETCH_CTRL_BF1_HSK_MODE)
#define BV_PXP_WFA_FETCH_CTRL_BF1_HSK_MODE__0 0x0
#define BV_PXP_WFA_FETCH_CTRL_BF1_HSK_MODE__1 0x1
#define BM_PXP_WFA_FETCH_CTRL_BF1_SRAM_IF 0x00000002
#define BF_PXP_WFA_FETCH_CTRL_BF1_SRAM_IF(v)  \
        (((v) << 1) & BM_PXP_WFA_FETCH_CTRL_BF1_SRAM_IF)
#define BV_PXP_WFA_FETCH_CTRL_BF1_SRAM_IF__0 0x0
#define BV_PXP_WFA_FETCH_CTRL_BF1_SRAM_IF__1 0x1
#define BM_PXP_WFA_FETCH_CTRL_BF1_EN 0x00000001
#define BF_PXP_WFA_FETCH_CTRL_BF1_EN(v)  \
        (((v) << 0) & BM_PXP_WFA_FETCH_CTRL_BF1_EN)
#define BV_PXP_WFA_FETCH_CTRL_BF1_EN__0 0x0
#define BV_PXP_WFA_FETCH_CTRL_BF1_EN__1 0x1

#define HW_PXP_WFA_FETCH_BUF1_ADDR	(0x00000c50)

#define BP_PXP_WFA_FETCH_BUF1_ADDR_BUF_ADDR      0
#define BM_PXP_WFA_FETCH_BUF1_ADDR_BUF_ADDR 0xFFFFFFFF
#define BF_PXP_WFA_FETCH_BUF1_ADDR_BUF_ADDR(v)   (v)

#define HW_PXP_WFA_FETCH_BUF1_PITCH	(0x00000c60)

#define BP_PXP_WFA_FETCH_BUF1_PITCH_RSVD      16
#define BM_PXP_WFA_FETCH_BUF1_PITCH_RSVD 0xFFFF0000
#define BF_PXP_WFA_FETCH_BUF1_PITCH_RSVD(v) \
        (((v) << 16) & BM_PXP_WFA_FETCH_BUF1_PITCH_RSVD)
#define BP_PXP_WFA_FETCH_BUF1_PITCH_PITCH      0
#define BM_PXP_WFA_FETCH_BUF1_PITCH_PITCH 0x0000FFFF
#define BF_PXP_WFA_FETCH_BUF1_PITCH_PITCH(v)  \
        (((v) << 0) & BM_PXP_WFA_FETCH_BUF1_PITCH_PITCH)

#define HW_PXP_WFA_FETCH_BUF1_SIZE	(0x00000c70)

#define BP_PXP_WFA_FETCH_BUF1_SIZE_RSVD0      30
#define BM_PXP_WFA_FETCH_BUF1_SIZE_RSVD0 0xC0000000
#define BF_PXP_WFA_FETCH_BUF1_SIZE_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFA_FETCH_BUF1_SIZE_RSVD0)
#define BP_PXP_WFA_FETCH_BUF1_SIZE_BUF_HEIGHT      16
#define BM_PXP_WFA_FETCH_BUF1_SIZE_BUF_HEIGHT 0x3FFF0000
#define BF_PXP_WFA_FETCH_BUF1_SIZE_BUF_HEIGHT(v)  \
        (((v) << 16) & BM_PXP_WFA_FETCH_BUF1_SIZE_BUF_HEIGHT)
#define BP_PXP_WFA_FETCH_BUF1_SIZE_RSVD1      14
#define BM_PXP_WFA_FETCH_BUF1_SIZE_RSVD1 0x0000C000
#define BF_PXP_WFA_FETCH_BUF1_SIZE_RSVD1(v)  \
        (((v) << 14) & BM_PXP_WFA_FETCH_BUF1_SIZE_RSVD1)
#define BP_PXP_WFA_FETCH_BUF1_SIZE_BUF_WIDTH      0
#define BM_PXP_WFA_FETCH_BUF1_SIZE_BUF_WIDTH 0x00003FFF
#define BF_PXP_WFA_FETCH_BUF1_SIZE_BUF_WIDTH(v)  \
        (((v) << 0) & BM_PXP_WFA_FETCH_BUF1_SIZE_BUF_WIDTH)

#define HW_PXP_WFA_FETCH_BUF2_ADDR	(0x00000c80)

#define BP_PXP_WFA_FETCH_BUF2_ADDR_BUF_ADDR      0
#define BM_PXP_WFA_FETCH_BUF2_ADDR_BUF_ADDR 0xFFFFFFFF
#define BF_PXP_WFA_FETCH_BUF2_ADDR_BUF_ADDR(v)   (v)

#define HW_PXP_WFA_FETCH_BUF2_PITCH	(0x00000c90)

#define BP_PXP_WFA_FETCH_BUF2_PITCH_RSVD      16
#define BM_PXP_WFA_FETCH_BUF2_PITCH_RSVD 0xFFFF0000
#define BF_PXP_WFA_FETCH_BUF2_PITCH_RSVD(v) \
        (((v) << 16) & BM_PXP_WFA_FETCH_BUF2_PITCH_RSVD)
#define BP_PXP_WFA_FETCH_BUF2_PITCH_PITCH      0
#define BM_PXP_WFA_FETCH_BUF2_PITCH_PITCH 0x0000FFFF
#define BF_PXP_WFA_FETCH_BUF2_PITCH_PITCH(v)  \
        (((v) << 0) & BM_PXP_WFA_FETCH_BUF2_PITCH_PITCH)

#define HW_PXP_WFA_FETCH_BUF2_SIZE	(0x00000ca0)

#define BP_PXP_WFA_FETCH_BUF2_SIZE_RSVD0      30
#define BM_PXP_WFA_FETCH_BUF2_SIZE_RSVD0 0xC0000000
#define BF_PXP_WFA_FETCH_BUF2_SIZE_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFA_FETCH_BUF2_SIZE_RSVD0)
#define BP_PXP_WFA_FETCH_BUF2_SIZE_BUF_HEIGHT      16
#define BM_PXP_WFA_FETCH_BUF2_SIZE_BUF_HEIGHT 0x3FFF0000
#define BF_PXP_WFA_FETCH_BUF2_SIZE_BUF_HEIGHT(v)  \
        (((v) << 16) & BM_PXP_WFA_FETCH_BUF2_SIZE_BUF_HEIGHT)
#define BP_PXP_WFA_FETCH_BUF2_SIZE_RSVD1      14
#define BM_PXP_WFA_FETCH_BUF2_SIZE_RSVD1 0x0000C000
#define BF_PXP_WFA_FETCH_BUF2_SIZE_RSVD1(v)  \
        (((v) << 14) & BM_PXP_WFA_FETCH_BUF2_SIZE_RSVD1)
#define BP_PXP_WFA_FETCH_BUF2_SIZE_BUF_WIDTH      0
#define BM_PXP_WFA_FETCH_BUF2_SIZE_BUF_WIDTH 0x00003FFF
#define BF_PXP_WFA_FETCH_BUF2_SIZE_BUF_WIDTH(v)  \
        (((v) << 0) & BM_PXP_WFA_FETCH_BUF2_SIZE_BUF_WIDTH)

#define HW_PXP_WFA_ARRAY_PIXEL0_MASK	(0x00000cb0)

#define BP_PXP_WFA_ARRAY_PIXEL0_MASK_RSVD0      30
#define BM_PXP_WFA_ARRAY_PIXEL0_MASK_RSVD0 0xC0000000
#define BF_PXP_WFA_ARRAY_PIXEL0_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFA_ARRAY_PIXEL0_MASK_RSVD0)
#define BP_PXP_WFA_ARRAY_PIXEL0_MASK_BUF_SEL      28
#define BM_PXP_WFA_ARRAY_PIXEL0_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFA_ARRAY_PIXEL0_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFA_ARRAY_PIXEL0_MASK_BUF_SEL)
#define BV_PXP_WFA_ARRAY_PIXEL0_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFA_ARRAY_PIXEL0_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFA_ARRAY_PIXEL0_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFA_ARRAY_PIXEL0_MASK_RSVD1      26
#define BM_PXP_WFA_ARRAY_PIXEL0_MASK_RSVD1 0x0C000000
#define BF_PXP_WFA_ARRAY_PIXEL0_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFA_ARRAY_PIXEL0_MASK_RSVD1)
#define BM_PXP_WFA_ARRAY_PIXEL0_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFA_ARRAY_PIXEL0_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFA_ARRAY_PIXEL0_MASK_SIGN_Y)
#define BV_PXP_WFA_ARRAY_PIXEL0_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFA_ARRAY_PIXEL0_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFA_ARRAY_PIXEL0_MASK_SIGN_X 0x01000000
#define BF_PXP_WFA_ARRAY_PIXEL0_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFA_ARRAY_PIXEL0_MASK_SIGN_X)
#define BV_PXP_WFA_ARRAY_PIXEL0_MASK_SIGN_X__0 0x0
#define BV_PXP_WFA_ARRAY_PIXEL0_MASK_SIGN_X__1 0x1
#define BP_PXP_WFA_ARRAY_PIXEL0_MASK_RSVD2      22
#define BM_PXP_WFA_ARRAY_PIXEL0_MASK_RSVD2 0x00C00000
#define BF_PXP_WFA_ARRAY_PIXEL0_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFA_ARRAY_PIXEL0_MASK_RSVD2)
#define BP_PXP_WFA_ARRAY_PIXEL0_MASK_OFFSET_Y      20
#define BM_PXP_WFA_ARRAY_PIXEL0_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFA_ARRAY_PIXEL0_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFA_ARRAY_PIXEL0_MASK_OFFSET_Y)
#define BP_PXP_WFA_ARRAY_PIXEL0_MASK_RSVD3      18
#define BM_PXP_WFA_ARRAY_PIXEL0_MASK_RSVD3 0x000C0000
#define BF_PXP_WFA_ARRAY_PIXEL0_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFA_ARRAY_PIXEL0_MASK_RSVD3)
#define BP_PXP_WFA_ARRAY_PIXEL0_MASK_OFFSET_X      16
#define BM_PXP_WFA_ARRAY_PIXEL0_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFA_ARRAY_PIXEL0_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFA_ARRAY_PIXEL0_MASK_OFFSET_X)
#define BP_PXP_WFA_ARRAY_PIXEL0_MASK_RSVD4      13
#define BM_PXP_WFA_ARRAY_PIXEL0_MASK_RSVD4 0x0000E000
#define BF_PXP_WFA_ARRAY_PIXEL0_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFA_ARRAY_PIXEL0_MASK_RSVD4)
#define BP_PXP_WFA_ARRAY_PIXEL0_MASK_H_OFS      8
#define BM_PXP_WFA_ARRAY_PIXEL0_MASK_H_OFS 0x00001F00
#define BF_PXP_WFA_ARRAY_PIXEL0_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFA_ARRAY_PIXEL0_MASK_H_OFS)
#define BP_PXP_WFA_ARRAY_PIXEL0_MASK_RSVD5      5
#define BM_PXP_WFA_ARRAY_PIXEL0_MASK_RSVD5 0x000000E0
#define BF_PXP_WFA_ARRAY_PIXEL0_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFA_ARRAY_PIXEL0_MASK_RSVD5)
#define BP_PXP_WFA_ARRAY_PIXEL0_MASK_L_OFS      0
#define BM_PXP_WFA_ARRAY_PIXEL0_MASK_L_OFS 0x0000001F
#define BF_PXP_WFA_ARRAY_PIXEL0_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFA_ARRAY_PIXEL0_MASK_L_OFS)

#define HW_PXP_WFA_ARRAY_PIXEL1_MASK	(0x00000cc0)

#define BP_PXP_WFA_ARRAY_PIXEL1_MASK_RSVD0      30
#define BM_PXP_WFA_ARRAY_PIXEL1_MASK_RSVD0 0xC0000000
#define BF_PXP_WFA_ARRAY_PIXEL1_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFA_ARRAY_PIXEL1_MASK_RSVD0)
#define BP_PXP_WFA_ARRAY_PIXEL1_MASK_BUF_SEL      28
#define BM_PXP_WFA_ARRAY_PIXEL1_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFA_ARRAY_PIXEL1_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFA_ARRAY_PIXEL1_MASK_BUF_SEL)
#define BV_PXP_WFA_ARRAY_PIXEL1_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFA_ARRAY_PIXEL1_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFA_ARRAY_PIXEL1_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFA_ARRAY_PIXEL1_MASK_RSVD1      26
#define BM_PXP_WFA_ARRAY_PIXEL1_MASK_RSVD1 0x0C000000
#define BF_PXP_WFA_ARRAY_PIXEL1_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFA_ARRAY_PIXEL1_MASK_RSVD1)
#define BM_PXP_WFA_ARRAY_PIXEL1_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFA_ARRAY_PIXEL1_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFA_ARRAY_PIXEL1_MASK_SIGN_Y)
#define BV_PXP_WFA_ARRAY_PIXEL1_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFA_ARRAY_PIXEL1_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFA_ARRAY_PIXEL1_MASK_SIGN_X 0x01000000
#define BF_PXP_WFA_ARRAY_PIXEL1_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFA_ARRAY_PIXEL1_MASK_SIGN_X)
#define BV_PXP_WFA_ARRAY_PIXEL1_MASK_SIGN_X__0 0x0
#define BV_PXP_WFA_ARRAY_PIXEL1_MASK_SIGN_X__1 0x1
#define BP_PXP_WFA_ARRAY_PIXEL1_MASK_RSVD2      22
#define BM_PXP_WFA_ARRAY_PIXEL1_MASK_RSVD2 0x00C00000
#define BF_PXP_WFA_ARRAY_PIXEL1_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFA_ARRAY_PIXEL1_MASK_RSVD2)
#define BP_PXP_WFA_ARRAY_PIXEL1_MASK_OFFSET_Y      20
#define BM_PXP_WFA_ARRAY_PIXEL1_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFA_ARRAY_PIXEL1_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFA_ARRAY_PIXEL1_MASK_OFFSET_Y)
#define BP_PXP_WFA_ARRAY_PIXEL1_MASK_RSVD3      18
#define BM_PXP_WFA_ARRAY_PIXEL1_MASK_RSVD3 0x000C0000
#define BF_PXP_WFA_ARRAY_PIXEL1_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFA_ARRAY_PIXEL1_MASK_RSVD3)
#define BP_PXP_WFA_ARRAY_PIXEL1_MASK_OFFSET_X      16
#define BM_PXP_WFA_ARRAY_PIXEL1_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFA_ARRAY_PIXEL1_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFA_ARRAY_PIXEL1_MASK_OFFSET_X)
#define BP_PXP_WFA_ARRAY_PIXEL1_MASK_RSVD4      13
#define BM_PXP_WFA_ARRAY_PIXEL1_MASK_RSVD4 0x0000E000
#define BF_PXP_WFA_ARRAY_PIXEL1_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFA_ARRAY_PIXEL1_MASK_RSVD4)
#define BP_PXP_WFA_ARRAY_PIXEL1_MASK_H_OFS      8
#define BM_PXP_WFA_ARRAY_PIXEL1_MASK_H_OFS 0x00001F00
#define BF_PXP_WFA_ARRAY_PIXEL1_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFA_ARRAY_PIXEL1_MASK_H_OFS)
#define BP_PXP_WFA_ARRAY_PIXEL1_MASK_RSVD5      5
#define BM_PXP_WFA_ARRAY_PIXEL1_MASK_RSVD5 0x000000E0
#define BF_PXP_WFA_ARRAY_PIXEL1_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFA_ARRAY_PIXEL1_MASK_RSVD5)
#define BP_PXP_WFA_ARRAY_PIXEL1_MASK_L_OFS      0
#define BM_PXP_WFA_ARRAY_PIXEL1_MASK_L_OFS 0x0000001F
#define BF_PXP_WFA_ARRAY_PIXEL1_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFA_ARRAY_PIXEL1_MASK_L_OFS)

#define HW_PXP_WFA_ARRAY_PIXEL2_MASK	(0x00000cd0)

#define BP_PXP_WFA_ARRAY_PIXEL2_MASK_RSVD0      30
#define BM_PXP_WFA_ARRAY_PIXEL2_MASK_RSVD0 0xC0000000
#define BF_PXP_WFA_ARRAY_PIXEL2_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFA_ARRAY_PIXEL2_MASK_RSVD0)
#define BP_PXP_WFA_ARRAY_PIXEL2_MASK_BUF_SEL      28
#define BM_PXP_WFA_ARRAY_PIXEL2_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFA_ARRAY_PIXEL2_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFA_ARRAY_PIXEL2_MASK_BUF_SEL)
#define BV_PXP_WFA_ARRAY_PIXEL2_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFA_ARRAY_PIXEL2_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFA_ARRAY_PIXEL2_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFA_ARRAY_PIXEL2_MASK_RSVD1      26
#define BM_PXP_WFA_ARRAY_PIXEL2_MASK_RSVD1 0x0C000000
#define BF_PXP_WFA_ARRAY_PIXEL2_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFA_ARRAY_PIXEL2_MASK_RSVD1)
#define BM_PXP_WFA_ARRAY_PIXEL2_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFA_ARRAY_PIXEL2_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFA_ARRAY_PIXEL2_MASK_SIGN_Y)
#define BV_PXP_WFA_ARRAY_PIXEL2_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFA_ARRAY_PIXEL2_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFA_ARRAY_PIXEL2_MASK_SIGN_X 0x01000000
#define BF_PXP_WFA_ARRAY_PIXEL2_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFA_ARRAY_PIXEL2_MASK_SIGN_X)
#define BV_PXP_WFA_ARRAY_PIXEL2_MASK_SIGN_X__0 0x0
#define BV_PXP_WFA_ARRAY_PIXEL2_MASK_SIGN_X__1 0x1
#define BP_PXP_WFA_ARRAY_PIXEL2_MASK_RSVD2      22
#define BM_PXP_WFA_ARRAY_PIXEL2_MASK_RSVD2 0x00C00000
#define BF_PXP_WFA_ARRAY_PIXEL2_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFA_ARRAY_PIXEL2_MASK_RSVD2)
#define BP_PXP_WFA_ARRAY_PIXEL2_MASK_OFFSET_Y      20
#define BM_PXP_WFA_ARRAY_PIXEL2_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFA_ARRAY_PIXEL2_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFA_ARRAY_PIXEL2_MASK_OFFSET_Y)
#define BP_PXP_WFA_ARRAY_PIXEL2_MASK_RSVD3      18
#define BM_PXP_WFA_ARRAY_PIXEL2_MASK_RSVD3 0x000C0000
#define BF_PXP_WFA_ARRAY_PIXEL2_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFA_ARRAY_PIXEL2_MASK_RSVD3)
#define BP_PXP_WFA_ARRAY_PIXEL2_MASK_OFFSET_X      16
#define BM_PXP_WFA_ARRAY_PIXEL2_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFA_ARRAY_PIXEL2_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFA_ARRAY_PIXEL2_MASK_OFFSET_X)
#define BP_PXP_WFA_ARRAY_PIXEL2_MASK_RSVD4      13
#define BM_PXP_WFA_ARRAY_PIXEL2_MASK_RSVD4 0x0000E000
#define BF_PXP_WFA_ARRAY_PIXEL2_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFA_ARRAY_PIXEL2_MASK_RSVD4)
#define BP_PXP_WFA_ARRAY_PIXEL2_MASK_H_OFS      8
#define BM_PXP_WFA_ARRAY_PIXEL2_MASK_H_OFS 0x00001F00
#define BF_PXP_WFA_ARRAY_PIXEL2_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFA_ARRAY_PIXEL2_MASK_H_OFS)
#define BP_PXP_WFA_ARRAY_PIXEL2_MASK_RSVD5      5
#define BM_PXP_WFA_ARRAY_PIXEL2_MASK_RSVD5 0x000000E0
#define BF_PXP_WFA_ARRAY_PIXEL2_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFA_ARRAY_PIXEL2_MASK_RSVD5)
#define BP_PXP_WFA_ARRAY_PIXEL2_MASK_L_OFS      0
#define BM_PXP_WFA_ARRAY_PIXEL2_MASK_L_OFS 0x0000001F
#define BF_PXP_WFA_ARRAY_PIXEL2_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFA_ARRAY_PIXEL2_MASK_L_OFS)

#define HW_PXP_WFA_ARRAY_PIXEL3_MASK	(0x00000ce0)

#define BP_PXP_WFA_ARRAY_PIXEL3_MASK_RSVD0      30
#define BM_PXP_WFA_ARRAY_PIXEL3_MASK_RSVD0 0xC0000000
#define BF_PXP_WFA_ARRAY_PIXEL3_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFA_ARRAY_PIXEL3_MASK_RSVD0)
#define BP_PXP_WFA_ARRAY_PIXEL3_MASK_BUF_SEL      28
#define BM_PXP_WFA_ARRAY_PIXEL3_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFA_ARRAY_PIXEL3_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFA_ARRAY_PIXEL3_MASK_BUF_SEL)
#define BV_PXP_WFA_ARRAY_PIXEL3_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFA_ARRAY_PIXEL3_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFA_ARRAY_PIXEL3_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFA_ARRAY_PIXEL3_MASK_RSVD1      26
#define BM_PXP_WFA_ARRAY_PIXEL3_MASK_RSVD1 0x0C000000
#define BF_PXP_WFA_ARRAY_PIXEL3_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFA_ARRAY_PIXEL3_MASK_RSVD1)
#define BM_PXP_WFA_ARRAY_PIXEL3_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFA_ARRAY_PIXEL3_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFA_ARRAY_PIXEL3_MASK_SIGN_Y)
#define BV_PXP_WFA_ARRAY_PIXEL3_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFA_ARRAY_PIXEL3_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFA_ARRAY_PIXEL3_MASK_SIGN_X 0x01000000
#define BF_PXP_WFA_ARRAY_PIXEL3_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFA_ARRAY_PIXEL3_MASK_SIGN_X)
#define BV_PXP_WFA_ARRAY_PIXEL3_MASK_SIGN_X__0 0x0
#define BV_PXP_WFA_ARRAY_PIXEL3_MASK_SIGN_X__1 0x1
#define BP_PXP_WFA_ARRAY_PIXEL3_MASK_RSVD2      22
#define BM_PXP_WFA_ARRAY_PIXEL3_MASK_RSVD2 0x00C00000
#define BF_PXP_WFA_ARRAY_PIXEL3_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFA_ARRAY_PIXEL3_MASK_RSVD2)
#define BP_PXP_WFA_ARRAY_PIXEL3_MASK_OFFSET_Y      20
#define BM_PXP_WFA_ARRAY_PIXEL3_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFA_ARRAY_PIXEL3_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFA_ARRAY_PIXEL3_MASK_OFFSET_Y)
#define BP_PXP_WFA_ARRAY_PIXEL3_MASK_RSVD3      18
#define BM_PXP_WFA_ARRAY_PIXEL3_MASK_RSVD3 0x000C0000
#define BF_PXP_WFA_ARRAY_PIXEL3_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFA_ARRAY_PIXEL3_MASK_RSVD3)
#define BP_PXP_WFA_ARRAY_PIXEL3_MASK_OFFSET_X      16
#define BM_PXP_WFA_ARRAY_PIXEL3_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFA_ARRAY_PIXEL3_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFA_ARRAY_PIXEL3_MASK_OFFSET_X)
#define BP_PXP_WFA_ARRAY_PIXEL3_MASK_RSVD4      13
#define BM_PXP_WFA_ARRAY_PIXEL3_MASK_RSVD4 0x0000E000
#define BF_PXP_WFA_ARRAY_PIXEL3_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFA_ARRAY_PIXEL3_MASK_RSVD4)
#define BP_PXP_WFA_ARRAY_PIXEL3_MASK_H_OFS      8
#define BM_PXP_WFA_ARRAY_PIXEL3_MASK_H_OFS 0x00001F00
#define BF_PXP_WFA_ARRAY_PIXEL3_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFA_ARRAY_PIXEL3_MASK_H_OFS)
#define BP_PXP_WFA_ARRAY_PIXEL3_MASK_RSVD5      5
#define BM_PXP_WFA_ARRAY_PIXEL3_MASK_RSVD5 0x000000E0
#define BF_PXP_WFA_ARRAY_PIXEL3_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFA_ARRAY_PIXEL3_MASK_RSVD5)
#define BP_PXP_WFA_ARRAY_PIXEL3_MASK_L_OFS      0
#define BM_PXP_WFA_ARRAY_PIXEL3_MASK_L_OFS 0x0000001F
#define BF_PXP_WFA_ARRAY_PIXEL3_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFA_ARRAY_PIXEL3_MASK_L_OFS)

#define HW_PXP_WFA_ARRAY_PIXEL4_MASK	(0x00000cf0)

#define BP_PXP_WFA_ARRAY_PIXEL4_MASK_RSVD0      30
#define BM_PXP_WFA_ARRAY_PIXEL4_MASK_RSVD0 0xC0000000
#define BF_PXP_WFA_ARRAY_PIXEL4_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFA_ARRAY_PIXEL4_MASK_RSVD0)
#define BP_PXP_WFA_ARRAY_PIXEL4_MASK_BUF_SEL      28
#define BM_PXP_WFA_ARRAY_PIXEL4_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFA_ARRAY_PIXEL4_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFA_ARRAY_PIXEL4_MASK_BUF_SEL)
#define BV_PXP_WFA_ARRAY_PIXEL4_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFA_ARRAY_PIXEL4_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFA_ARRAY_PIXEL4_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFA_ARRAY_PIXEL4_MASK_RSVD1      26
#define BM_PXP_WFA_ARRAY_PIXEL4_MASK_RSVD1 0x0C000000
#define BF_PXP_WFA_ARRAY_PIXEL4_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFA_ARRAY_PIXEL4_MASK_RSVD1)
#define BM_PXP_WFA_ARRAY_PIXEL4_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFA_ARRAY_PIXEL4_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFA_ARRAY_PIXEL4_MASK_SIGN_Y)
#define BV_PXP_WFA_ARRAY_PIXEL4_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFA_ARRAY_PIXEL4_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFA_ARRAY_PIXEL4_MASK_SIGN_X 0x01000000
#define BF_PXP_WFA_ARRAY_PIXEL4_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFA_ARRAY_PIXEL4_MASK_SIGN_X)
#define BV_PXP_WFA_ARRAY_PIXEL4_MASK_SIGN_X__0 0x0
#define BV_PXP_WFA_ARRAY_PIXEL4_MASK_SIGN_X__1 0x1
#define BP_PXP_WFA_ARRAY_PIXEL4_MASK_RSVD2      22
#define BM_PXP_WFA_ARRAY_PIXEL4_MASK_RSVD2 0x00C00000
#define BF_PXP_WFA_ARRAY_PIXEL4_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFA_ARRAY_PIXEL4_MASK_RSVD2)
#define BP_PXP_WFA_ARRAY_PIXEL4_MASK_OFFSET_Y      20
#define BM_PXP_WFA_ARRAY_PIXEL4_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFA_ARRAY_PIXEL4_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFA_ARRAY_PIXEL4_MASK_OFFSET_Y)
#define BP_PXP_WFA_ARRAY_PIXEL4_MASK_RSVD3      18
#define BM_PXP_WFA_ARRAY_PIXEL4_MASK_RSVD3 0x000C0000
#define BF_PXP_WFA_ARRAY_PIXEL4_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFA_ARRAY_PIXEL4_MASK_RSVD3)
#define BP_PXP_WFA_ARRAY_PIXEL4_MASK_OFFSET_X      16
#define BM_PXP_WFA_ARRAY_PIXEL4_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFA_ARRAY_PIXEL4_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFA_ARRAY_PIXEL4_MASK_OFFSET_X)
#define BP_PXP_WFA_ARRAY_PIXEL4_MASK_RSVD4      13
#define BM_PXP_WFA_ARRAY_PIXEL4_MASK_RSVD4 0x0000E000
#define BF_PXP_WFA_ARRAY_PIXEL4_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFA_ARRAY_PIXEL4_MASK_RSVD4)
#define BP_PXP_WFA_ARRAY_PIXEL4_MASK_H_OFS      8
#define BM_PXP_WFA_ARRAY_PIXEL4_MASK_H_OFS 0x00001F00
#define BF_PXP_WFA_ARRAY_PIXEL4_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFA_ARRAY_PIXEL4_MASK_H_OFS)
#define BP_PXP_WFA_ARRAY_PIXEL4_MASK_RSVD5      5
#define BM_PXP_WFA_ARRAY_PIXEL4_MASK_RSVD5 0x000000E0
#define BF_PXP_WFA_ARRAY_PIXEL4_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFA_ARRAY_PIXEL4_MASK_RSVD5)
#define BP_PXP_WFA_ARRAY_PIXEL4_MASK_L_OFS      0
#define BM_PXP_WFA_ARRAY_PIXEL4_MASK_L_OFS 0x0000001F
#define BF_PXP_WFA_ARRAY_PIXEL4_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFA_ARRAY_PIXEL4_MASK_L_OFS)

#define HW_PXP_WFA_ARRAY_PIXEL5_MASK	(0x00000d00)

#define BP_PXP_WFA_ARRAY_PIXEL5_MASK_RSVD0      30
#define BM_PXP_WFA_ARRAY_PIXEL5_MASK_RSVD0 0xC0000000
#define BF_PXP_WFA_ARRAY_PIXEL5_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFA_ARRAY_PIXEL5_MASK_RSVD0)
#define BP_PXP_WFA_ARRAY_PIXEL5_MASK_BUF_SEL      28
#define BM_PXP_WFA_ARRAY_PIXEL5_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFA_ARRAY_PIXEL5_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFA_ARRAY_PIXEL5_MASK_BUF_SEL)
#define BV_PXP_WFA_ARRAY_PIXEL5_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFA_ARRAY_PIXEL5_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFA_ARRAY_PIXEL5_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFA_ARRAY_PIXEL5_MASK_RSVD1      26
#define BM_PXP_WFA_ARRAY_PIXEL5_MASK_RSVD1 0x0C000000
#define BF_PXP_WFA_ARRAY_PIXEL5_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFA_ARRAY_PIXEL5_MASK_RSVD1)
#define BM_PXP_WFA_ARRAY_PIXEL5_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFA_ARRAY_PIXEL5_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFA_ARRAY_PIXEL5_MASK_SIGN_Y)
#define BV_PXP_WFA_ARRAY_PIXEL5_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFA_ARRAY_PIXEL5_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFA_ARRAY_PIXEL5_MASK_SIGN_X 0x01000000
#define BF_PXP_WFA_ARRAY_PIXEL5_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFA_ARRAY_PIXEL5_MASK_SIGN_X)
#define BV_PXP_WFA_ARRAY_PIXEL5_MASK_SIGN_X__0 0x0
#define BV_PXP_WFA_ARRAY_PIXEL5_MASK_SIGN_X__1 0x1
#define BP_PXP_WFA_ARRAY_PIXEL5_MASK_RSVD2      22
#define BM_PXP_WFA_ARRAY_PIXEL5_MASK_RSVD2 0x00C00000
#define BF_PXP_WFA_ARRAY_PIXEL5_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFA_ARRAY_PIXEL5_MASK_RSVD2)
#define BP_PXP_WFA_ARRAY_PIXEL5_MASK_OFFSET_Y      20
#define BM_PXP_WFA_ARRAY_PIXEL5_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFA_ARRAY_PIXEL5_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFA_ARRAY_PIXEL5_MASK_OFFSET_Y)
#define BP_PXP_WFA_ARRAY_PIXEL5_MASK_RSVD3      18
#define BM_PXP_WFA_ARRAY_PIXEL5_MASK_RSVD3 0x000C0000
#define BF_PXP_WFA_ARRAY_PIXEL5_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFA_ARRAY_PIXEL5_MASK_RSVD3)
#define BP_PXP_WFA_ARRAY_PIXEL5_MASK_OFFSET_X      16
#define BM_PXP_WFA_ARRAY_PIXEL5_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFA_ARRAY_PIXEL5_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFA_ARRAY_PIXEL5_MASK_OFFSET_X)
#define BP_PXP_WFA_ARRAY_PIXEL5_MASK_RSVD4      13
#define BM_PXP_WFA_ARRAY_PIXEL5_MASK_RSVD4 0x0000E000
#define BF_PXP_WFA_ARRAY_PIXEL5_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFA_ARRAY_PIXEL5_MASK_RSVD4)
#define BP_PXP_WFA_ARRAY_PIXEL5_MASK_H_OFS      8
#define BM_PXP_WFA_ARRAY_PIXEL5_MASK_H_OFS 0x00001F00
#define BF_PXP_WFA_ARRAY_PIXEL5_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFA_ARRAY_PIXEL5_MASK_H_OFS)
#define BP_PXP_WFA_ARRAY_PIXEL5_MASK_RSVD5      5
#define BM_PXP_WFA_ARRAY_PIXEL5_MASK_RSVD5 0x000000E0
#define BF_PXP_WFA_ARRAY_PIXEL5_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFA_ARRAY_PIXEL5_MASK_RSVD5)
#define BP_PXP_WFA_ARRAY_PIXEL5_MASK_L_OFS      0
#define BM_PXP_WFA_ARRAY_PIXEL5_MASK_L_OFS 0x0000001F
#define BF_PXP_WFA_ARRAY_PIXEL5_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFA_ARRAY_PIXEL5_MASK_L_OFS)

#define HW_PXP_WFA_ARRAY_PIXEL6_MASK	(0x00000d10)

#define BP_PXP_WFA_ARRAY_PIXEL6_MASK_RSVD0      30
#define BM_PXP_WFA_ARRAY_PIXEL6_MASK_RSVD0 0xC0000000
#define BF_PXP_WFA_ARRAY_PIXEL6_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFA_ARRAY_PIXEL6_MASK_RSVD0)
#define BP_PXP_WFA_ARRAY_PIXEL6_MASK_BUF_SEL      28
#define BM_PXP_WFA_ARRAY_PIXEL6_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFA_ARRAY_PIXEL6_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFA_ARRAY_PIXEL6_MASK_BUF_SEL)
#define BV_PXP_WFA_ARRAY_PIXEL6_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFA_ARRAY_PIXEL6_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFA_ARRAY_PIXEL6_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFA_ARRAY_PIXEL6_MASK_RSVD1      26
#define BM_PXP_WFA_ARRAY_PIXEL6_MASK_RSVD1 0x0C000000
#define BF_PXP_WFA_ARRAY_PIXEL6_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFA_ARRAY_PIXEL6_MASK_RSVD1)
#define BM_PXP_WFA_ARRAY_PIXEL6_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFA_ARRAY_PIXEL6_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFA_ARRAY_PIXEL6_MASK_SIGN_Y)
#define BV_PXP_WFA_ARRAY_PIXEL6_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFA_ARRAY_PIXEL6_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFA_ARRAY_PIXEL6_MASK_SIGN_X 0x01000000
#define BF_PXP_WFA_ARRAY_PIXEL6_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFA_ARRAY_PIXEL6_MASK_SIGN_X)
#define BV_PXP_WFA_ARRAY_PIXEL6_MASK_SIGN_X__0 0x0
#define BV_PXP_WFA_ARRAY_PIXEL6_MASK_SIGN_X__1 0x1
#define BP_PXP_WFA_ARRAY_PIXEL6_MASK_RSVD2      22
#define BM_PXP_WFA_ARRAY_PIXEL6_MASK_RSVD2 0x00C00000
#define BF_PXP_WFA_ARRAY_PIXEL6_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFA_ARRAY_PIXEL6_MASK_RSVD2)
#define BP_PXP_WFA_ARRAY_PIXEL6_MASK_OFFSET_Y      20
#define BM_PXP_WFA_ARRAY_PIXEL6_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFA_ARRAY_PIXEL6_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFA_ARRAY_PIXEL6_MASK_OFFSET_Y)
#define BP_PXP_WFA_ARRAY_PIXEL6_MASK_RSVD3      18
#define BM_PXP_WFA_ARRAY_PIXEL6_MASK_RSVD3 0x000C0000
#define BF_PXP_WFA_ARRAY_PIXEL6_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFA_ARRAY_PIXEL6_MASK_RSVD3)
#define BP_PXP_WFA_ARRAY_PIXEL6_MASK_OFFSET_X      16
#define BM_PXP_WFA_ARRAY_PIXEL6_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFA_ARRAY_PIXEL6_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFA_ARRAY_PIXEL6_MASK_OFFSET_X)
#define BP_PXP_WFA_ARRAY_PIXEL6_MASK_RSVD4      13
#define BM_PXP_WFA_ARRAY_PIXEL6_MASK_RSVD4 0x0000E000
#define BF_PXP_WFA_ARRAY_PIXEL6_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFA_ARRAY_PIXEL6_MASK_RSVD4)
#define BP_PXP_WFA_ARRAY_PIXEL6_MASK_H_OFS      8
#define BM_PXP_WFA_ARRAY_PIXEL6_MASK_H_OFS 0x00001F00
#define BF_PXP_WFA_ARRAY_PIXEL6_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFA_ARRAY_PIXEL6_MASK_H_OFS)
#define BP_PXP_WFA_ARRAY_PIXEL6_MASK_RSVD5      5
#define BM_PXP_WFA_ARRAY_PIXEL6_MASK_RSVD5 0x000000E0
#define BF_PXP_WFA_ARRAY_PIXEL6_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFA_ARRAY_PIXEL6_MASK_RSVD5)
#define BP_PXP_WFA_ARRAY_PIXEL6_MASK_L_OFS      0
#define BM_PXP_WFA_ARRAY_PIXEL6_MASK_L_OFS 0x0000001F
#define BF_PXP_WFA_ARRAY_PIXEL6_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFA_ARRAY_PIXEL6_MASK_L_OFS)

#define HW_PXP_WFA_ARRAY_PIXEL7_MASK	(0x00000d20)

#define BP_PXP_WFA_ARRAY_PIXEL7_MASK_RSVD0      30
#define BM_PXP_WFA_ARRAY_PIXEL7_MASK_RSVD0 0xC0000000
#define BF_PXP_WFA_ARRAY_PIXEL7_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFA_ARRAY_PIXEL7_MASK_RSVD0)
#define BP_PXP_WFA_ARRAY_PIXEL7_MASK_BUF_SEL      28
#define BM_PXP_WFA_ARRAY_PIXEL7_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFA_ARRAY_PIXEL7_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFA_ARRAY_PIXEL7_MASK_BUF_SEL)
#define BV_PXP_WFA_ARRAY_PIXEL7_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFA_ARRAY_PIXEL7_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFA_ARRAY_PIXEL7_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFA_ARRAY_PIXEL7_MASK_RSVD1      26
#define BM_PXP_WFA_ARRAY_PIXEL7_MASK_RSVD1 0x0C000000
#define BF_PXP_WFA_ARRAY_PIXEL7_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFA_ARRAY_PIXEL7_MASK_RSVD1)
#define BM_PXP_WFA_ARRAY_PIXEL7_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFA_ARRAY_PIXEL7_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFA_ARRAY_PIXEL7_MASK_SIGN_Y)
#define BV_PXP_WFA_ARRAY_PIXEL7_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFA_ARRAY_PIXEL7_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFA_ARRAY_PIXEL7_MASK_SIGN_X 0x01000000
#define BF_PXP_WFA_ARRAY_PIXEL7_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFA_ARRAY_PIXEL7_MASK_SIGN_X)
#define BV_PXP_WFA_ARRAY_PIXEL7_MASK_SIGN_X__0 0x0
#define BV_PXP_WFA_ARRAY_PIXEL7_MASK_SIGN_X__1 0x1
#define BP_PXP_WFA_ARRAY_PIXEL7_MASK_RSVD2      22
#define BM_PXP_WFA_ARRAY_PIXEL7_MASK_RSVD2 0x00C00000
#define BF_PXP_WFA_ARRAY_PIXEL7_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFA_ARRAY_PIXEL7_MASK_RSVD2)
#define BP_PXP_WFA_ARRAY_PIXEL7_MASK_OFFSET_Y      20
#define BM_PXP_WFA_ARRAY_PIXEL7_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFA_ARRAY_PIXEL7_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFA_ARRAY_PIXEL7_MASK_OFFSET_Y)
#define BP_PXP_WFA_ARRAY_PIXEL7_MASK_RSVD3      18
#define BM_PXP_WFA_ARRAY_PIXEL7_MASK_RSVD3 0x000C0000
#define BF_PXP_WFA_ARRAY_PIXEL7_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFA_ARRAY_PIXEL7_MASK_RSVD3)
#define BP_PXP_WFA_ARRAY_PIXEL7_MASK_OFFSET_X      16
#define BM_PXP_WFA_ARRAY_PIXEL7_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFA_ARRAY_PIXEL7_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFA_ARRAY_PIXEL7_MASK_OFFSET_X)
#define BP_PXP_WFA_ARRAY_PIXEL7_MASK_RSVD4      13
#define BM_PXP_WFA_ARRAY_PIXEL7_MASK_RSVD4 0x0000E000
#define BF_PXP_WFA_ARRAY_PIXEL7_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFA_ARRAY_PIXEL7_MASK_RSVD4)
#define BP_PXP_WFA_ARRAY_PIXEL7_MASK_H_OFS      8
#define BM_PXP_WFA_ARRAY_PIXEL7_MASK_H_OFS 0x00001F00
#define BF_PXP_WFA_ARRAY_PIXEL7_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFA_ARRAY_PIXEL7_MASK_H_OFS)
#define BP_PXP_WFA_ARRAY_PIXEL7_MASK_RSVD5      5
#define BM_PXP_WFA_ARRAY_PIXEL7_MASK_RSVD5 0x000000E0
#define BF_PXP_WFA_ARRAY_PIXEL7_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFA_ARRAY_PIXEL7_MASK_RSVD5)
#define BP_PXP_WFA_ARRAY_PIXEL7_MASK_L_OFS      0
#define BM_PXP_WFA_ARRAY_PIXEL7_MASK_L_OFS 0x0000001F
#define BF_PXP_WFA_ARRAY_PIXEL7_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFA_ARRAY_PIXEL7_MASK_L_OFS)

#define HW_PXP_WFA_ARRAY_FLAG0_MASK	(0x00000d30)

#define BP_PXP_WFA_ARRAY_FLAG0_MASK_RSVD0      30
#define BM_PXP_WFA_ARRAY_FLAG0_MASK_RSVD0 0xC0000000
#define BF_PXP_WFA_ARRAY_FLAG0_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFA_ARRAY_FLAG0_MASK_RSVD0)
#define BP_PXP_WFA_ARRAY_FLAG0_MASK_BUF_SEL      28
#define BM_PXP_WFA_ARRAY_FLAG0_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFA_ARRAY_FLAG0_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFA_ARRAY_FLAG0_MASK_BUF_SEL)
#define BV_PXP_WFA_ARRAY_FLAG0_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG0_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFA_ARRAY_FLAG0_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFA_ARRAY_FLAG0_MASK_RSVD1      26
#define BM_PXP_WFA_ARRAY_FLAG0_MASK_RSVD1 0x0C000000
#define BF_PXP_WFA_ARRAY_FLAG0_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFA_ARRAY_FLAG0_MASK_RSVD1)
#define BM_PXP_WFA_ARRAY_FLAG0_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFA_ARRAY_FLAG0_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFA_ARRAY_FLAG0_MASK_SIGN_Y)
#define BV_PXP_WFA_ARRAY_FLAG0_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG0_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFA_ARRAY_FLAG0_MASK_SIGN_X 0x01000000
#define BF_PXP_WFA_ARRAY_FLAG0_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFA_ARRAY_FLAG0_MASK_SIGN_X)
#define BV_PXP_WFA_ARRAY_FLAG0_MASK_SIGN_X__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG0_MASK_SIGN_X__1 0x1
#define BP_PXP_WFA_ARRAY_FLAG0_MASK_RSVD2      22
#define BM_PXP_WFA_ARRAY_FLAG0_MASK_RSVD2 0x00C00000
#define BF_PXP_WFA_ARRAY_FLAG0_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFA_ARRAY_FLAG0_MASK_RSVD2)
#define BP_PXP_WFA_ARRAY_FLAG0_MASK_OFFSET_Y      20
#define BM_PXP_WFA_ARRAY_FLAG0_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFA_ARRAY_FLAG0_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFA_ARRAY_FLAG0_MASK_OFFSET_Y)
#define BP_PXP_WFA_ARRAY_FLAG0_MASK_RSVD3      18
#define BM_PXP_WFA_ARRAY_FLAG0_MASK_RSVD3 0x000C0000
#define BF_PXP_WFA_ARRAY_FLAG0_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFA_ARRAY_FLAG0_MASK_RSVD3)
#define BP_PXP_WFA_ARRAY_FLAG0_MASK_OFFSET_X      16
#define BM_PXP_WFA_ARRAY_FLAG0_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFA_ARRAY_FLAG0_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFA_ARRAY_FLAG0_MASK_OFFSET_X)
#define BP_PXP_WFA_ARRAY_FLAG0_MASK_RSVD4      13
#define BM_PXP_WFA_ARRAY_FLAG0_MASK_RSVD4 0x0000E000
#define BF_PXP_WFA_ARRAY_FLAG0_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFA_ARRAY_FLAG0_MASK_RSVD4)
#define BP_PXP_WFA_ARRAY_FLAG0_MASK_H_OFS      8
#define BM_PXP_WFA_ARRAY_FLAG0_MASK_H_OFS 0x00001F00
#define BF_PXP_WFA_ARRAY_FLAG0_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFA_ARRAY_FLAG0_MASK_H_OFS)
#define BP_PXP_WFA_ARRAY_FLAG0_MASK_RSVD5      5
#define BM_PXP_WFA_ARRAY_FLAG0_MASK_RSVD5 0x000000E0
#define BF_PXP_WFA_ARRAY_FLAG0_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFA_ARRAY_FLAG0_MASK_RSVD5)
#define BP_PXP_WFA_ARRAY_FLAG0_MASK_L_OFS      0
#define BM_PXP_WFA_ARRAY_FLAG0_MASK_L_OFS 0x0000001F
#define BF_PXP_WFA_ARRAY_FLAG0_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFA_ARRAY_FLAG0_MASK_L_OFS)

#define HW_PXP_WFA_ARRAY_FLAG1_MASK	(0x00000d40)

#define BP_PXP_WFA_ARRAY_FLAG1_MASK_RSVD0      30
#define BM_PXP_WFA_ARRAY_FLAG1_MASK_RSVD0 0xC0000000
#define BF_PXP_WFA_ARRAY_FLAG1_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFA_ARRAY_FLAG1_MASK_RSVD0)
#define BP_PXP_WFA_ARRAY_FLAG1_MASK_BUF_SEL      28
#define BM_PXP_WFA_ARRAY_FLAG1_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFA_ARRAY_FLAG1_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFA_ARRAY_FLAG1_MASK_BUF_SEL)
#define BV_PXP_WFA_ARRAY_FLAG1_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG1_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFA_ARRAY_FLAG1_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFA_ARRAY_FLAG1_MASK_RSVD1      26
#define BM_PXP_WFA_ARRAY_FLAG1_MASK_RSVD1 0x0C000000
#define BF_PXP_WFA_ARRAY_FLAG1_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFA_ARRAY_FLAG1_MASK_RSVD1)
#define BM_PXP_WFA_ARRAY_FLAG1_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFA_ARRAY_FLAG1_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFA_ARRAY_FLAG1_MASK_SIGN_Y)
#define BV_PXP_WFA_ARRAY_FLAG1_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG1_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFA_ARRAY_FLAG1_MASK_SIGN_X 0x01000000
#define BF_PXP_WFA_ARRAY_FLAG1_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFA_ARRAY_FLAG1_MASK_SIGN_X)
#define BV_PXP_WFA_ARRAY_FLAG1_MASK_SIGN_X__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG1_MASK_SIGN_X__1 0x1
#define BP_PXP_WFA_ARRAY_FLAG1_MASK_RSVD2      22
#define BM_PXP_WFA_ARRAY_FLAG1_MASK_RSVD2 0x00C00000
#define BF_PXP_WFA_ARRAY_FLAG1_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFA_ARRAY_FLAG1_MASK_RSVD2)
#define BP_PXP_WFA_ARRAY_FLAG1_MASK_OFFSET_Y      20
#define BM_PXP_WFA_ARRAY_FLAG1_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFA_ARRAY_FLAG1_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFA_ARRAY_FLAG1_MASK_OFFSET_Y)
#define BP_PXP_WFA_ARRAY_FLAG1_MASK_RSVD3      18
#define BM_PXP_WFA_ARRAY_FLAG1_MASK_RSVD3 0x000C0000
#define BF_PXP_WFA_ARRAY_FLAG1_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFA_ARRAY_FLAG1_MASK_RSVD3)
#define BP_PXP_WFA_ARRAY_FLAG1_MASK_OFFSET_X      16
#define BM_PXP_WFA_ARRAY_FLAG1_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFA_ARRAY_FLAG1_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFA_ARRAY_FLAG1_MASK_OFFSET_X)
#define BP_PXP_WFA_ARRAY_FLAG1_MASK_RSVD4      13
#define BM_PXP_WFA_ARRAY_FLAG1_MASK_RSVD4 0x0000E000
#define BF_PXP_WFA_ARRAY_FLAG1_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFA_ARRAY_FLAG1_MASK_RSVD4)
#define BP_PXP_WFA_ARRAY_FLAG1_MASK_H_OFS      8
#define BM_PXP_WFA_ARRAY_FLAG1_MASK_H_OFS 0x00001F00
#define BF_PXP_WFA_ARRAY_FLAG1_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFA_ARRAY_FLAG1_MASK_H_OFS)
#define BP_PXP_WFA_ARRAY_FLAG1_MASK_RSVD5      5
#define BM_PXP_WFA_ARRAY_FLAG1_MASK_RSVD5 0x000000E0
#define BF_PXP_WFA_ARRAY_FLAG1_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFA_ARRAY_FLAG1_MASK_RSVD5)
#define BP_PXP_WFA_ARRAY_FLAG1_MASK_L_OFS      0
#define BM_PXP_WFA_ARRAY_FLAG1_MASK_L_OFS 0x0000001F
#define BF_PXP_WFA_ARRAY_FLAG1_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFA_ARRAY_FLAG1_MASK_L_OFS)

#define HW_PXP_WFA_ARRAY_FLAG2_MASK	(0x00000d50)

#define BP_PXP_WFA_ARRAY_FLAG2_MASK_RSVD0      30
#define BM_PXP_WFA_ARRAY_FLAG2_MASK_RSVD0 0xC0000000
#define BF_PXP_WFA_ARRAY_FLAG2_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFA_ARRAY_FLAG2_MASK_RSVD0)
#define BP_PXP_WFA_ARRAY_FLAG2_MASK_BUF_SEL      28
#define BM_PXP_WFA_ARRAY_FLAG2_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFA_ARRAY_FLAG2_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFA_ARRAY_FLAG2_MASK_BUF_SEL)
#define BV_PXP_WFA_ARRAY_FLAG2_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG2_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFA_ARRAY_FLAG2_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFA_ARRAY_FLAG2_MASK_RSVD1      26
#define BM_PXP_WFA_ARRAY_FLAG2_MASK_RSVD1 0x0C000000
#define BF_PXP_WFA_ARRAY_FLAG2_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFA_ARRAY_FLAG2_MASK_RSVD1)
#define BM_PXP_WFA_ARRAY_FLAG2_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFA_ARRAY_FLAG2_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFA_ARRAY_FLAG2_MASK_SIGN_Y)
#define BV_PXP_WFA_ARRAY_FLAG2_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG2_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFA_ARRAY_FLAG2_MASK_SIGN_X 0x01000000
#define BF_PXP_WFA_ARRAY_FLAG2_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFA_ARRAY_FLAG2_MASK_SIGN_X)
#define BV_PXP_WFA_ARRAY_FLAG2_MASK_SIGN_X__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG2_MASK_SIGN_X__1 0x1
#define BP_PXP_WFA_ARRAY_FLAG2_MASK_RSVD2      22
#define BM_PXP_WFA_ARRAY_FLAG2_MASK_RSVD2 0x00C00000
#define BF_PXP_WFA_ARRAY_FLAG2_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFA_ARRAY_FLAG2_MASK_RSVD2)
#define BP_PXP_WFA_ARRAY_FLAG2_MASK_OFFSET_Y      20
#define BM_PXP_WFA_ARRAY_FLAG2_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFA_ARRAY_FLAG2_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFA_ARRAY_FLAG2_MASK_OFFSET_Y)
#define BP_PXP_WFA_ARRAY_FLAG2_MASK_RSVD3      18
#define BM_PXP_WFA_ARRAY_FLAG2_MASK_RSVD3 0x000C0000
#define BF_PXP_WFA_ARRAY_FLAG2_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFA_ARRAY_FLAG2_MASK_RSVD3)
#define BP_PXP_WFA_ARRAY_FLAG2_MASK_OFFSET_X      16
#define BM_PXP_WFA_ARRAY_FLAG2_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFA_ARRAY_FLAG2_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFA_ARRAY_FLAG2_MASK_OFFSET_X)
#define BP_PXP_WFA_ARRAY_FLAG2_MASK_RSVD4      13
#define BM_PXP_WFA_ARRAY_FLAG2_MASK_RSVD4 0x0000E000
#define BF_PXP_WFA_ARRAY_FLAG2_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFA_ARRAY_FLAG2_MASK_RSVD4)
#define BP_PXP_WFA_ARRAY_FLAG2_MASK_H_OFS      8
#define BM_PXP_WFA_ARRAY_FLAG2_MASK_H_OFS 0x00001F00
#define BF_PXP_WFA_ARRAY_FLAG2_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFA_ARRAY_FLAG2_MASK_H_OFS)
#define BP_PXP_WFA_ARRAY_FLAG2_MASK_RSVD5      5
#define BM_PXP_WFA_ARRAY_FLAG2_MASK_RSVD5 0x000000E0
#define BF_PXP_WFA_ARRAY_FLAG2_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFA_ARRAY_FLAG2_MASK_RSVD5)
#define BP_PXP_WFA_ARRAY_FLAG2_MASK_L_OFS      0
#define BM_PXP_WFA_ARRAY_FLAG2_MASK_L_OFS 0x0000001F
#define BF_PXP_WFA_ARRAY_FLAG2_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFA_ARRAY_FLAG2_MASK_L_OFS)

#define HW_PXP_WFA_ARRAY_FLAG3_MASK	(0x00000d60)

#define BP_PXP_WFA_ARRAY_FLAG3_MASK_RSVD0      30
#define BM_PXP_WFA_ARRAY_FLAG3_MASK_RSVD0 0xC0000000
#define BF_PXP_WFA_ARRAY_FLAG3_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFA_ARRAY_FLAG3_MASK_RSVD0)
#define BP_PXP_WFA_ARRAY_FLAG3_MASK_BUF_SEL      28
#define BM_PXP_WFA_ARRAY_FLAG3_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFA_ARRAY_FLAG3_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFA_ARRAY_FLAG3_MASK_BUF_SEL)
#define BV_PXP_WFA_ARRAY_FLAG3_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG3_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFA_ARRAY_FLAG3_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFA_ARRAY_FLAG3_MASK_RSVD1      26
#define BM_PXP_WFA_ARRAY_FLAG3_MASK_RSVD1 0x0C000000
#define BF_PXP_WFA_ARRAY_FLAG3_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFA_ARRAY_FLAG3_MASK_RSVD1)
#define BM_PXP_WFA_ARRAY_FLAG3_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFA_ARRAY_FLAG3_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFA_ARRAY_FLAG3_MASK_SIGN_Y)
#define BV_PXP_WFA_ARRAY_FLAG3_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG3_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFA_ARRAY_FLAG3_MASK_SIGN_X 0x01000000
#define BF_PXP_WFA_ARRAY_FLAG3_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFA_ARRAY_FLAG3_MASK_SIGN_X)
#define BV_PXP_WFA_ARRAY_FLAG3_MASK_SIGN_X__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG3_MASK_SIGN_X__1 0x1
#define BP_PXP_WFA_ARRAY_FLAG3_MASK_RSVD2      22
#define BM_PXP_WFA_ARRAY_FLAG3_MASK_RSVD2 0x00C00000
#define BF_PXP_WFA_ARRAY_FLAG3_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFA_ARRAY_FLAG3_MASK_RSVD2)
#define BP_PXP_WFA_ARRAY_FLAG3_MASK_OFFSET_Y      20
#define BM_PXP_WFA_ARRAY_FLAG3_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFA_ARRAY_FLAG3_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFA_ARRAY_FLAG3_MASK_OFFSET_Y)
#define BP_PXP_WFA_ARRAY_FLAG3_MASK_RSVD3      18
#define BM_PXP_WFA_ARRAY_FLAG3_MASK_RSVD3 0x000C0000
#define BF_PXP_WFA_ARRAY_FLAG3_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFA_ARRAY_FLAG3_MASK_RSVD3)
#define BP_PXP_WFA_ARRAY_FLAG3_MASK_OFFSET_X      16
#define BM_PXP_WFA_ARRAY_FLAG3_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFA_ARRAY_FLAG3_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFA_ARRAY_FLAG3_MASK_OFFSET_X)
#define BP_PXP_WFA_ARRAY_FLAG3_MASK_RSVD4      13
#define BM_PXP_WFA_ARRAY_FLAG3_MASK_RSVD4 0x0000E000
#define BF_PXP_WFA_ARRAY_FLAG3_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFA_ARRAY_FLAG3_MASK_RSVD4)
#define BP_PXP_WFA_ARRAY_FLAG3_MASK_H_OFS      8
#define BM_PXP_WFA_ARRAY_FLAG3_MASK_H_OFS 0x00001F00
#define BF_PXP_WFA_ARRAY_FLAG3_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFA_ARRAY_FLAG3_MASK_H_OFS)
#define BP_PXP_WFA_ARRAY_FLAG3_MASK_RSVD5      5
#define BM_PXP_WFA_ARRAY_FLAG3_MASK_RSVD5 0x000000E0
#define BF_PXP_WFA_ARRAY_FLAG3_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFA_ARRAY_FLAG3_MASK_RSVD5)
#define BP_PXP_WFA_ARRAY_FLAG3_MASK_L_OFS      0
#define BM_PXP_WFA_ARRAY_FLAG3_MASK_L_OFS 0x0000001F
#define BF_PXP_WFA_ARRAY_FLAG3_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFA_ARRAY_FLAG3_MASK_L_OFS)

#define HW_PXP_WFA_ARRAY_FLAG4_MASK	(0x00000d70)

#define BP_PXP_WFA_ARRAY_FLAG4_MASK_RSVD0      30
#define BM_PXP_WFA_ARRAY_FLAG4_MASK_RSVD0 0xC0000000
#define BF_PXP_WFA_ARRAY_FLAG4_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFA_ARRAY_FLAG4_MASK_RSVD0)
#define BP_PXP_WFA_ARRAY_FLAG4_MASK_BUF_SEL      28
#define BM_PXP_WFA_ARRAY_FLAG4_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFA_ARRAY_FLAG4_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFA_ARRAY_FLAG4_MASK_BUF_SEL)
#define BV_PXP_WFA_ARRAY_FLAG4_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG4_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFA_ARRAY_FLAG4_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFA_ARRAY_FLAG4_MASK_RSVD1      26
#define BM_PXP_WFA_ARRAY_FLAG4_MASK_RSVD1 0x0C000000
#define BF_PXP_WFA_ARRAY_FLAG4_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFA_ARRAY_FLAG4_MASK_RSVD1)
#define BM_PXP_WFA_ARRAY_FLAG4_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFA_ARRAY_FLAG4_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFA_ARRAY_FLAG4_MASK_SIGN_Y)
#define BV_PXP_WFA_ARRAY_FLAG4_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG4_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFA_ARRAY_FLAG4_MASK_SIGN_X 0x01000000
#define BF_PXP_WFA_ARRAY_FLAG4_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFA_ARRAY_FLAG4_MASK_SIGN_X)
#define BV_PXP_WFA_ARRAY_FLAG4_MASK_SIGN_X__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG4_MASK_SIGN_X__1 0x1
#define BP_PXP_WFA_ARRAY_FLAG4_MASK_RSVD2      22
#define BM_PXP_WFA_ARRAY_FLAG4_MASK_RSVD2 0x00C00000
#define BF_PXP_WFA_ARRAY_FLAG4_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFA_ARRAY_FLAG4_MASK_RSVD2)
#define BP_PXP_WFA_ARRAY_FLAG4_MASK_OFFSET_Y      20
#define BM_PXP_WFA_ARRAY_FLAG4_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFA_ARRAY_FLAG4_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFA_ARRAY_FLAG4_MASK_OFFSET_Y)
#define BP_PXP_WFA_ARRAY_FLAG4_MASK_RSVD3      18
#define BM_PXP_WFA_ARRAY_FLAG4_MASK_RSVD3 0x000C0000
#define BF_PXP_WFA_ARRAY_FLAG4_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFA_ARRAY_FLAG4_MASK_RSVD3)
#define BP_PXP_WFA_ARRAY_FLAG4_MASK_OFFSET_X      16
#define BM_PXP_WFA_ARRAY_FLAG4_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFA_ARRAY_FLAG4_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFA_ARRAY_FLAG4_MASK_OFFSET_X)
#define BP_PXP_WFA_ARRAY_FLAG4_MASK_RSVD4      13
#define BM_PXP_WFA_ARRAY_FLAG4_MASK_RSVD4 0x0000E000
#define BF_PXP_WFA_ARRAY_FLAG4_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFA_ARRAY_FLAG4_MASK_RSVD4)
#define BP_PXP_WFA_ARRAY_FLAG4_MASK_H_OFS      8
#define BM_PXP_WFA_ARRAY_FLAG4_MASK_H_OFS 0x00001F00
#define BF_PXP_WFA_ARRAY_FLAG4_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFA_ARRAY_FLAG4_MASK_H_OFS)
#define BP_PXP_WFA_ARRAY_FLAG4_MASK_RSVD5      5
#define BM_PXP_WFA_ARRAY_FLAG4_MASK_RSVD5 0x000000E0
#define BF_PXP_WFA_ARRAY_FLAG4_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFA_ARRAY_FLAG4_MASK_RSVD5)
#define BP_PXP_WFA_ARRAY_FLAG4_MASK_L_OFS      0
#define BM_PXP_WFA_ARRAY_FLAG4_MASK_L_OFS 0x0000001F
#define BF_PXP_WFA_ARRAY_FLAG4_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFA_ARRAY_FLAG4_MASK_L_OFS)

#define HW_PXP_WFA_ARRAY_FLAG5_MASK	(0x00000d80)

#define BP_PXP_WFA_ARRAY_FLAG5_MASK_RSVD0      30
#define BM_PXP_WFA_ARRAY_FLAG5_MASK_RSVD0 0xC0000000
#define BF_PXP_WFA_ARRAY_FLAG5_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFA_ARRAY_FLAG5_MASK_RSVD0)
#define BP_PXP_WFA_ARRAY_FLAG5_MASK_BUF_SEL      28
#define BM_PXP_WFA_ARRAY_FLAG5_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFA_ARRAY_FLAG5_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFA_ARRAY_FLAG5_MASK_BUF_SEL)
#define BV_PXP_WFA_ARRAY_FLAG5_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG5_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFA_ARRAY_FLAG5_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFA_ARRAY_FLAG5_MASK_RSVD1      26
#define BM_PXP_WFA_ARRAY_FLAG5_MASK_RSVD1 0x0C000000
#define BF_PXP_WFA_ARRAY_FLAG5_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFA_ARRAY_FLAG5_MASK_RSVD1)
#define BM_PXP_WFA_ARRAY_FLAG5_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFA_ARRAY_FLAG5_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFA_ARRAY_FLAG5_MASK_SIGN_Y)
#define BV_PXP_WFA_ARRAY_FLAG5_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG5_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFA_ARRAY_FLAG5_MASK_SIGN_X 0x01000000
#define BF_PXP_WFA_ARRAY_FLAG5_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFA_ARRAY_FLAG5_MASK_SIGN_X)
#define BV_PXP_WFA_ARRAY_FLAG5_MASK_SIGN_X__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG5_MASK_SIGN_X__1 0x1
#define BP_PXP_WFA_ARRAY_FLAG5_MASK_RSVD2      22
#define BM_PXP_WFA_ARRAY_FLAG5_MASK_RSVD2 0x00C00000
#define BF_PXP_WFA_ARRAY_FLAG5_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFA_ARRAY_FLAG5_MASK_RSVD2)
#define BP_PXP_WFA_ARRAY_FLAG5_MASK_OFFSET_Y      20
#define BM_PXP_WFA_ARRAY_FLAG5_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFA_ARRAY_FLAG5_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFA_ARRAY_FLAG5_MASK_OFFSET_Y)
#define BP_PXP_WFA_ARRAY_FLAG5_MASK_RSVD3      18
#define BM_PXP_WFA_ARRAY_FLAG5_MASK_RSVD3 0x000C0000
#define BF_PXP_WFA_ARRAY_FLAG5_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFA_ARRAY_FLAG5_MASK_RSVD3)
#define BP_PXP_WFA_ARRAY_FLAG5_MASK_OFFSET_X      16
#define BM_PXP_WFA_ARRAY_FLAG5_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFA_ARRAY_FLAG5_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFA_ARRAY_FLAG5_MASK_OFFSET_X)
#define BP_PXP_WFA_ARRAY_FLAG5_MASK_RSVD4      13
#define BM_PXP_WFA_ARRAY_FLAG5_MASK_RSVD4 0x0000E000
#define BF_PXP_WFA_ARRAY_FLAG5_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFA_ARRAY_FLAG5_MASK_RSVD4)
#define BP_PXP_WFA_ARRAY_FLAG5_MASK_H_OFS      8
#define BM_PXP_WFA_ARRAY_FLAG5_MASK_H_OFS 0x00001F00
#define BF_PXP_WFA_ARRAY_FLAG5_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFA_ARRAY_FLAG5_MASK_H_OFS)
#define BP_PXP_WFA_ARRAY_FLAG5_MASK_RSVD5      5
#define BM_PXP_WFA_ARRAY_FLAG5_MASK_RSVD5 0x000000E0
#define BF_PXP_WFA_ARRAY_FLAG5_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFA_ARRAY_FLAG5_MASK_RSVD5)
#define BP_PXP_WFA_ARRAY_FLAG5_MASK_L_OFS      0
#define BM_PXP_WFA_ARRAY_FLAG5_MASK_L_OFS 0x0000001F
#define BF_PXP_WFA_ARRAY_FLAG5_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFA_ARRAY_FLAG5_MASK_L_OFS)

#define HW_PXP_WFA_ARRAY_FLAG6_MASK	(0x00000d90)

#define BP_PXP_WFA_ARRAY_FLAG6_MASK_RSVD0      30
#define BM_PXP_WFA_ARRAY_FLAG6_MASK_RSVD0 0xC0000000
#define BF_PXP_WFA_ARRAY_FLAG6_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFA_ARRAY_FLAG6_MASK_RSVD0)
#define BP_PXP_WFA_ARRAY_FLAG6_MASK_BUF_SEL      28
#define BM_PXP_WFA_ARRAY_FLAG6_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFA_ARRAY_FLAG6_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFA_ARRAY_FLAG6_MASK_BUF_SEL)
#define BV_PXP_WFA_ARRAY_FLAG6_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG6_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFA_ARRAY_FLAG6_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFA_ARRAY_FLAG6_MASK_RSVD1      26
#define BM_PXP_WFA_ARRAY_FLAG6_MASK_RSVD1 0x0C000000
#define BF_PXP_WFA_ARRAY_FLAG6_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFA_ARRAY_FLAG6_MASK_RSVD1)
#define BM_PXP_WFA_ARRAY_FLAG6_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFA_ARRAY_FLAG6_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFA_ARRAY_FLAG6_MASK_SIGN_Y)
#define BV_PXP_WFA_ARRAY_FLAG6_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG6_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFA_ARRAY_FLAG6_MASK_SIGN_X 0x01000000
#define BF_PXP_WFA_ARRAY_FLAG6_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFA_ARRAY_FLAG6_MASK_SIGN_X)
#define BV_PXP_WFA_ARRAY_FLAG6_MASK_SIGN_X__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG6_MASK_SIGN_X__1 0x1
#define BP_PXP_WFA_ARRAY_FLAG6_MASK_RSVD2      22
#define BM_PXP_WFA_ARRAY_FLAG6_MASK_RSVD2 0x00C00000
#define BF_PXP_WFA_ARRAY_FLAG6_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFA_ARRAY_FLAG6_MASK_RSVD2)
#define BP_PXP_WFA_ARRAY_FLAG6_MASK_OFFSET_Y      20
#define BM_PXP_WFA_ARRAY_FLAG6_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFA_ARRAY_FLAG6_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFA_ARRAY_FLAG6_MASK_OFFSET_Y)
#define BP_PXP_WFA_ARRAY_FLAG6_MASK_RSVD3      18
#define BM_PXP_WFA_ARRAY_FLAG6_MASK_RSVD3 0x000C0000
#define BF_PXP_WFA_ARRAY_FLAG6_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFA_ARRAY_FLAG6_MASK_RSVD3)
#define BP_PXP_WFA_ARRAY_FLAG6_MASK_OFFSET_X      16
#define BM_PXP_WFA_ARRAY_FLAG6_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFA_ARRAY_FLAG6_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFA_ARRAY_FLAG6_MASK_OFFSET_X)
#define BP_PXP_WFA_ARRAY_FLAG6_MASK_RSVD4      13
#define BM_PXP_WFA_ARRAY_FLAG6_MASK_RSVD4 0x0000E000
#define BF_PXP_WFA_ARRAY_FLAG6_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFA_ARRAY_FLAG6_MASK_RSVD4)
#define BP_PXP_WFA_ARRAY_FLAG6_MASK_H_OFS      8
#define BM_PXP_WFA_ARRAY_FLAG6_MASK_H_OFS 0x00001F00
#define BF_PXP_WFA_ARRAY_FLAG6_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFA_ARRAY_FLAG6_MASK_H_OFS)
#define BP_PXP_WFA_ARRAY_FLAG6_MASK_RSVD5      5
#define BM_PXP_WFA_ARRAY_FLAG6_MASK_RSVD5 0x000000E0
#define BF_PXP_WFA_ARRAY_FLAG6_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFA_ARRAY_FLAG6_MASK_RSVD5)
#define BP_PXP_WFA_ARRAY_FLAG6_MASK_L_OFS      0
#define BM_PXP_WFA_ARRAY_FLAG6_MASK_L_OFS 0x0000001F
#define BF_PXP_WFA_ARRAY_FLAG6_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFA_ARRAY_FLAG6_MASK_L_OFS)

#define HW_PXP_WFA_ARRAY_FLAG7_MASK	(0x00000da0)

#define BP_PXP_WFA_ARRAY_FLAG7_MASK_RSVD0      30
#define BM_PXP_WFA_ARRAY_FLAG7_MASK_RSVD0 0xC0000000
#define BF_PXP_WFA_ARRAY_FLAG7_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFA_ARRAY_FLAG7_MASK_RSVD0)
#define BP_PXP_WFA_ARRAY_FLAG7_MASK_BUF_SEL      28
#define BM_PXP_WFA_ARRAY_FLAG7_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFA_ARRAY_FLAG7_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFA_ARRAY_FLAG7_MASK_BUF_SEL)
#define BV_PXP_WFA_ARRAY_FLAG7_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG7_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFA_ARRAY_FLAG7_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFA_ARRAY_FLAG7_MASK_RSVD1      26
#define BM_PXP_WFA_ARRAY_FLAG7_MASK_RSVD1 0x0C000000
#define BF_PXP_WFA_ARRAY_FLAG7_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFA_ARRAY_FLAG7_MASK_RSVD1)
#define BM_PXP_WFA_ARRAY_FLAG7_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFA_ARRAY_FLAG7_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFA_ARRAY_FLAG7_MASK_SIGN_Y)
#define BV_PXP_WFA_ARRAY_FLAG7_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG7_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFA_ARRAY_FLAG7_MASK_SIGN_X 0x01000000
#define BF_PXP_WFA_ARRAY_FLAG7_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFA_ARRAY_FLAG7_MASK_SIGN_X)
#define BV_PXP_WFA_ARRAY_FLAG7_MASK_SIGN_X__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG7_MASK_SIGN_X__1 0x1
#define BP_PXP_WFA_ARRAY_FLAG7_MASK_RSVD2      22
#define BM_PXP_WFA_ARRAY_FLAG7_MASK_RSVD2 0x00C00000
#define BF_PXP_WFA_ARRAY_FLAG7_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFA_ARRAY_FLAG7_MASK_RSVD2)
#define BP_PXP_WFA_ARRAY_FLAG7_MASK_OFFSET_Y      20
#define BM_PXP_WFA_ARRAY_FLAG7_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFA_ARRAY_FLAG7_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFA_ARRAY_FLAG7_MASK_OFFSET_Y)
#define BP_PXP_WFA_ARRAY_FLAG7_MASK_RSVD3      18
#define BM_PXP_WFA_ARRAY_FLAG7_MASK_RSVD3 0x000C0000
#define BF_PXP_WFA_ARRAY_FLAG7_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFA_ARRAY_FLAG7_MASK_RSVD3)
#define BP_PXP_WFA_ARRAY_FLAG7_MASK_OFFSET_X      16
#define BM_PXP_WFA_ARRAY_FLAG7_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFA_ARRAY_FLAG7_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFA_ARRAY_FLAG7_MASK_OFFSET_X)
#define BP_PXP_WFA_ARRAY_FLAG7_MASK_RSVD4      13
#define BM_PXP_WFA_ARRAY_FLAG7_MASK_RSVD4 0x0000E000
#define BF_PXP_WFA_ARRAY_FLAG7_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFA_ARRAY_FLAG7_MASK_RSVD4)
#define BP_PXP_WFA_ARRAY_FLAG7_MASK_H_OFS      8
#define BM_PXP_WFA_ARRAY_FLAG7_MASK_H_OFS 0x00001F00
#define BF_PXP_WFA_ARRAY_FLAG7_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFA_ARRAY_FLAG7_MASK_H_OFS)
#define BP_PXP_WFA_ARRAY_FLAG7_MASK_RSVD5      5
#define BM_PXP_WFA_ARRAY_FLAG7_MASK_RSVD5 0x000000E0
#define BF_PXP_WFA_ARRAY_FLAG7_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFA_ARRAY_FLAG7_MASK_RSVD5)
#define BP_PXP_WFA_ARRAY_FLAG7_MASK_L_OFS      0
#define BM_PXP_WFA_ARRAY_FLAG7_MASK_L_OFS 0x0000001F
#define BF_PXP_WFA_ARRAY_FLAG7_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFA_ARRAY_FLAG7_MASK_L_OFS)

#define HW_PXP_WFA_FETCH_BUF1_CORD	(0x00000db0)

#define BP_PXP_WFA_FETCH_BUF1_CORD_RSVD0      30
#define BM_PXP_WFA_FETCH_BUF1_CORD_RSVD0 0xC0000000
#define BF_PXP_WFA_FETCH_BUF1_CORD_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFA_FETCH_BUF1_CORD_RSVD0)
#define BP_PXP_WFA_FETCH_BUF1_CORD_YCORD      16
#define BM_PXP_WFA_FETCH_BUF1_CORD_YCORD 0x3FFF0000
#define BF_PXP_WFA_FETCH_BUF1_CORD_YCORD(v)  \
        (((v) << 16) & BM_PXP_WFA_FETCH_BUF1_CORD_YCORD)
#define BP_PXP_WFA_FETCH_BUF1_CORD_RSVD1      14
#define BM_PXP_WFA_FETCH_BUF1_CORD_RSVD1 0x0000C000
#define BF_PXP_WFA_FETCH_BUF1_CORD_RSVD1(v)  \
        (((v) << 14) & BM_PXP_WFA_FETCH_BUF1_CORD_RSVD1)
#define BP_PXP_WFA_FETCH_BUF1_CORD_XCORD      0
#define BM_PXP_WFA_FETCH_BUF1_CORD_XCORD 0x00003FFF
#define BF_PXP_WFA_FETCH_BUF1_CORD_XCORD(v)  \
        (((v) << 0) & BM_PXP_WFA_FETCH_BUF1_CORD_XCORD)

#define HW_PXP_WFA_FETCH_BUF2_CORD	(0x00000dc0)

#define BP_PXP_WFA_FETCH_BUF2_CORD_RSVD0      30
#define BM_PXP_WFA_FETCH_BUF2_CORD_RSVD0 0xC0000000
#define BF_PXP_WFA_FETCH_BUF2_CORD_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFA_FETCH_BUF2_CORD_RSVD0)
#define BP_PXP_WFA_FETCH_BUF2_CORD_YCORD      16
#define BM_PXP_WFA_FETCH_BUF2_CORD_YCORD 0x3FFF0000
#define BF_PXP_WFA_FETCH_BUF2_CORD_YCORD(v)  \
        (((v) << 16) & BM_PXP_WFA_FETCH_BUF2_CORD_YCORD)
#define BP_PXP_WFA_FETCH_BUF2_CORD_RSVD1      14
#define BM_PXP_WFA_FETCH_BUF2_CORD_RSVD1 0x0000C000
#define BF_PXP_WFA_FETCH_BUF2_CORD_RSVD1(v)  \
        (((v) << 14) & BM_PXP_WFA_FETCH_BUF2_CORD_RSVD1)
#define BP_PXP_WFA_FETCH_BUF2_CORD_XCORD      0
#define BM_PXP_WFA_FETCH_BUF2_CORD_XCORD 0x00003FFF
#define BF_PXP_WFA_FETCH_BUF2_CORD_XCORD(v)  \
        (((v) << 0) & BM_PXP_WFA_FETCH_BUF2_CORD_XCORD)

#define HW_PXP_WFA_ARRAY_FLAG8_MASK	(0x00000dd0)

#define BP_PXP_WFA_ARRAY_FLAG8_MASK_RSVD0      30
#define BM_PXP_WFA_ARRAY_FLAG8_MASK_RSVD0 0xC0000000
#define BF_PXP_WFA_ARRAY_FLAG8_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFA_ARRAY_FLAG8_MASK_RSVD0)
#define BP_PXP_WFA_ARRAY_FLAG8_MASK_BUF_SEL      28
#define BM_PXP_WFA_ARRAY_FLAG8_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFA_ARRAY_FLAG8_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFA_ARRAY_FLAG8_MASK_BUF_SEL)
#define BV_PXP_WFA_ARRAY_FLAG8_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG8_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFA_ARRAY_FLAG8_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFA_ARRAY_FLAG8_MASK_RSVD1      26
#define BM_PXP_WFA_ARRAY_FLAG8_MASK_RSVD1 0x0C000000
#define BF_PXP_WFA_ARRAY_FLAG8_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFA_ARRAY_FLAG8_MASK_RSVD1)
#define BM_PXP_WFA_ARRAY_FLAG8_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFA_ARRAY_FLAG8_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFA_ARRAY_FLAG8_MASK_SIGN_Y)
#define BV_PXP_WFA_ARRAY_FLAG8_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG8_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFA_ARRAY_FLAG8_MASK_SIGN_X 0x01000000
#define BF_PXP_WFA_ARRAY_FLAG8_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFA_ARRAY_FLAG8_MASK_SIGN_X)
#define BV_PXP_WFA_ARRAY_FLAG8_MASK_SIGN_X__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG8_MASK_SIGN_X__1 0x1
#define BP_PXP_WFA_ARRAY_FLAG8_MASK_RSVD2      22
#define BM_PXP_WFA_ARRAY_FLAG8_MASK_RSVD2 0x00C00000
#define BF_PXP_WFA_ARRAY_FLAG8_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFA_ARRAY_FLAG8_MASK_RSVD2)
#define BP_PXP_WFA_ARRAY_FLAG8_MASK_OFFSET_Y      20
#define BM_PXP_WFA_ARRAY_FLAG8_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFA_ARRAY_FLAG8_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFA_ARRAY_FLAG8_MASK_OFFSET_Y)
#define BP_PXP_WFA_ARRAY_FLAG8_MASK_RSVD3      18
#define BM_PXP_WFA_ARRAY_FLAG8_MASK_RSVD3 0x000C0000
#define BF_PXP_WFA_ARRAY_FLAG8_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFA_ARRAY_FLAG8_MASK_RSVD3)
#define BP_PXP_WFA_ARRAY_FLAG8_MASK_OFFSET_X      16
#define BM_PXP_WFA_ARRAY_FLAG8_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFA_ARRAY_FLAG8_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFA_ARRAY_FLAG8_MASK_OFFSET_X)
#define BP_PXP_WFA_ARRAY_FLAG8_MASK_RSVD4      13
#define BM_PXP_WFA_ARRAY_FLAG8_MASK_RSVD4 0x0000E000
#define BF_PXP_WFA_ARRAY_FLAG8_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFA_ARRAY_FLAG8_MASK_RSVD4)
#define BP_PXP_WFA_ARRAY_FLAG8_MASK_H_OFS      8
#define BM_PXP_WFA_ARRAY_FLAG8_MASK_H_OFS 0x00001F00
#define BF_PXP_WFA_ARRAY_FLAG8_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFA_ARRAY_FLAG8_MASK_H_OFS)
#define BP_PXP_WFA_ARRAY_FLAG8_MASK_RSVD5      5
#define BM_PXP_WFA_ARRAY_FLAG8_MASK_RSVD5 0x000000E0
#define BF_PXP_WFA_ARRAY_FLAG8_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFA_ARRAY_FLAG8_MASK_RSVD5)
#define BP_PXP_WFA_ARRAY_FLAG8_MASK_L_OFS      0
#define BM_PXP_WFA_ARRAY_FLAG8_MASK_L_OFS 0x0000001F
#define BF_PXP_WFA_ARRAY_FLAG8_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFA_ARRAY_FLAG8_MASK_L_OFS)

#define HW_PXP_WFA_ARRAY_FLAG9_MASK	(0x00000de0)

#define BP_PXP_WFA_ARRAY_FLAG9_MASK_RSVD0      30
#define BM_PXP_WFA_ARRAY_FLAG9_MASK_RSVD0 0xC0000000
#define BF_PXP_WFA_ARRAY_FLAG9_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFA_ARRAY_FLAG9_MASK_RSVD0)
#define BP_PXP_WFA_ARRAY_FLAG9_MASK_BUF_SEL      28
#define BM_PXP_WFA_ARRAY_FLAG9_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFA_ARRAY_FLAG9_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFA_ARRAY_FLAG9_MASK_BUF_SEL)
#define BV_PXP_WFA_ARRAY_FLAG9_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG9_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFA_ARRAY_FLAG9_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFA_ARRAY_FLAG9_MASK_RSVD1      26
#define BM_PXP_WFA_ARRAY_FLAG9_MASK_RSVD1 0x0C000000
#define BF_PXP_WFA_ARRAY_FLAG9_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFA_ARRAY_FLAG9_MASK_RSVD1)
#define BM_PXP_WFA_ARRAY_FLAG9_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFA_ARRAY_FLAG9_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFA_ARRAY_FLAG9_MASK_SIGN_Y)
#define BV_PXP_WFA_ARRAY_FLAG9_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG9_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFA_ARRAY_FLAG9_MASK_SIGN_X 0x01000000
#define BF_PXP_WFA_ARRAY_FLAG9_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFA_ARRAY_FLAG9_MASK_SIGN_X)
#define BV_PXP_WFA_ARRAY_FLAG9_MASK_SIGN_X__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG9_MASK_SIGN_X__1 0x1
#define BP_PXP_WFA_ARRAY_FLAG9_MASK_RSVD2      22
#define BM_PXP_WFA_ARRAY_FLAG9_MASK_RSVD2 0x00C00000
#define BF_PXP_WFA_ARRAY_FLAG9_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFA_ARRAY_FLAG9_MASK_RSVD2)
#define BP_PXP_WFA_ARRAY_FLAG9_MASK_OFFSET_Y      20
#define BM_PXP_WFA_ARRAY_FLAG9_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFA_ARRAY_FLAG9_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFA_ARRAY_FLAG9_MASK_OFFSET_Y)
#define BP_PXP_WFA_ARRAY_FLAG9_MASK_RSVD3      18
#define BM_PXP_WFA_ARRAY_FLAG9_MASK_RSVD3 0x000C0000
#define BF_PXP_WFA_ARRAY_FLAG9_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFA_ARRAY_FLAG9_MASK_RSVD3)
#define BP_PXP_WFA_ARRAY_FLAG9_MASK_OFFSET_X      16
#define BM_PXP_WFA_ARRAY_FLAG9_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFA_ARRAY_FLAG9_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFA_ARRAY_FLAG9_MASK_OFFSET_X)
#define BP_PXP_WFA_ARRAY_FLAG9_MASK_RSVD4      13
#define BM_PXP_WFA_ARRAY_FLAG9_MASK_RSVD4 0x0000E000
#define BF_PXP_WFA_ARRAY_FLAG9_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFA_ARRAY_FLAG9_MASK_RSVD4)
#define BP_PXP_WFA_ARRAY_FLAG9_MASK_H_OFS      8
#define BM_PXP_WFA_ARRAY_FLAG9_MASK_H_OFS 0x00001F00
#define BF_PXP_WFA_ARRAY_FLAG9_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFA_ARRAY_FLAG9_MASK_H_OFS)
#define BP_PXP_WFA_ARRAY_FLAG9_MASK_RSVD5      5
#define BM_PXP_WFA_ARRAY_FLAG9_MASK_RSVD5 0x000000E0
#define BF_PXP_WFA_ARRAY_FLAG9_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFA_ARRAY_FLAG9_MASK_RSVD5)
#define BP_PXP_WFA_ARRAY_FLAG9_MASK_L_OFS      0
#define BM_PXP_WFA_ARRAY_FLAG9_MASK_L_OFS 0x0000001F
#define BF_PXP_WFA_ARRAY_FLAG9_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFA_ARRAY_FLAG9_MASK_L_OFS)

#define HW_PXP_WFA_ARRAY_FLAG10_MASK	(0x00000df0)

#define BP_PXP_WFA_ARRAY_FLAG10_MASK_RSVD0      30
#define BM_PXP_WFA_ARRAY_FLAG10_MASK_RSVD0 0xC0000000
#define BF_PXP_WFA_ARRAY_FLAG10_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFA_ARRAY_FLAG10_MASK_RSVD0)
#define BP_PXP_WFA_ARRAY_FLAG10_MASK_BUF_SEL      28
#define BM_PXP_WFA_ARRAY_FLAG10_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFA_ARRAY_FLAG10_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFA_ARRAY_FLAG10_MASK_BUF_SEL)
#define BV_PXP_WFA_ARRAY_FLAG10_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG10_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFA_ARRAY_FLAG10_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFA_ARRAY_FLAG10_MASK_RSVD1      26
#define BM_PXP_WFA_ARRAY_FLAG10_MASK_RSVD1 0x0C000000
#define BF_PXP_WFA_ARRAY_FLAG10_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFA_ARRAY_FLAG10_MASK_RSVD1)
#define BM_PXP_WFA_ARRAY_FLAG10_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFA_ARRAY_FLAG10_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFA_ARRAY_FLAG10_MASK_SIGN_Y)
#define BV_PXP_WFA_ARRAY_FLAG10_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG10_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFA_ARRAY_FLAG10_MASK_SIGN_X 0x01000000
#define BF_PXP_WFA_ARRAY_FLAG10_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFA_ARRAY_FLAG10_MASK_SIGN_X)
#define BV_PXP_WFA_ARRAY_FLAG10_MASK_SIGN_X__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG10_MASK_SIGN_X__1 0x1
#define BP_PXP_WFA_ARRAY_FLAG10_MASK_RSVD2      22
#define BM_PXP_WFA_ARRAY_FLAG10_MASK_RSVD2 0x00C00000
#define BF_PXP_WFA_ARRAY_FLAG10_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFA_ARRAY_FLAG10_MASK_RSVD2)
#define BP_PXP_WFA_ARRAY_FLAG10_MASK_OFFSET_Y      20
#define BM_PXP_WFA_ARRAY_FLAG10_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFA_ARRAY_FLAG10_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFA_ARRAY_FLAG10_MASK_OFFSET_Y)
#define BP_PXP_WFA_ARRAY_FLAG10_MASK_RSVD3      18
#define BM_PXP_WFA_ARRAY_FLAG10_MASK_RSVD3 0x000C0000
#define BF_PXP_WFA_ARRAY_FLAG10_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFA_ARRAY_FLAG10_MASK_RSVD3)
#define BP_PXP_WFA_ARRAY_FLAG10_MASK_OFFSET_X      16
#define BM_PXP_WFA_ARRAY_FLAG10_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFA_ARRAY_FLAG10_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFA_ARRAY_FLAG10_MASK_OFFSET_X)
#define BP_PXP_WFA_ARRAY_FLAG10_MASK_RSVD4      13
#define BM_PXP_WFA_ARRAY_FLAG10_MASK_RSVD4 0x0000E000
#define BF_PXP_WFA_ARRAY_FLAG10_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFA_ARRAY_FLAG10_MASK_RSVD4)
#define BP_PXP_WFA_ARRAY_FLAG10_MASK_H_OFS      8
#define BM_PXP_WFA_ARRAY_FLAG10_MASK_H_OFS 0x00001F00
#define BF_PXP_WFA_ARRAY_FLAG10_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFA_ARRAY_FLAG10_MASK_H_OFS)
#define BP_PXP_WFA_ARRAY_FLAG10_MASK_RSVD5      5
#define BM_PXP_WFA_ARRAY_FLAG10_MASK_RSVD5 0x000000E0
#define BF_PXP_WFA_ARRAY_FLAG10_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFA_ARRAY_FLAG10_MASK_RSVD5)
#define BP_PXP_WFA_ARRAY_FLAG10_MASK_L_OFS      0
#define BM_PXP_WFA_ARRAY_FLAG10_MASK_L_OFS 0x0000001F
#define BF_PXP_WFA_ARRAY_FLAG10_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFA_ARRAY_FLAG10_MASK_L_OFS)

#define HW_PXP_WFA_ARRAY_FLAG11_MASK	(0x00000e00)

#define BP_PXP_WFA_ARRAY_FLAG11_MASK_RSVD0      30
#define BM_PXP_WFA_ARRAY_FLAG11_MASK_RSVD0 0xC0000000
#define BF_PXP_WFA_ARRAY_FLAG11_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFA_ARRAY_FLAG11_MASK_RSVD0)
#define BP_PXP_WFA_ARRAY_FLAG11_MASK_BUF_SEL      28
#define BM_PXP_WFA_ARRAY_FLAG11_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFA_ARRAY_FLAG11_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFA_ARRAY_FLAG11_MASK_BUF_SEL)
#define BV_PXP_WFA_ARRAY_FLAG11_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG11_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFA_ARRAY_FLAG11_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFA_ARRAY_FLAG11_MASK_RSVD1      26
#define BM_PXP_WFA_ARRAY_FLAG11_MASK_RSVD1 0x0C000000
#define BF_PXP_WFA_ARRAY_FLAG11_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFA_ARRAY_FLAG11_MASK_RSVD1)
#define BM_PXP_WFA_ARRAY_FLAG11_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFA_ARRAY_FLAG11_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFA_ARRAY_FLAG11_MASK_SIGN_Y)
#define BV_PXP_WFA_ARRAY_FLAG11_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG11_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFA_ARRAY_FLAG11_MASK_SIGN_X 0x01000000
#define BF_PXP_WFA_ARRAY_FLAG11_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFA_ARRAY_FLAG11_MASK_SIGN_X)
#define BV_PXP_WFA_ARRAY_FLAG11_MASK_SIGN_X__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG11_MASK_SIGN_X__1 0x1
#define BP_PXP_WFA_ARRAY_FLAG11_MASK_RSVD2      22
#define BM_PXP_WFA_ARRAY_FLAG11_MASK_RSVD2 0x00C00000
#define BF_PXP_WFA_ARRAY_FLAG11_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFA_ARRAY_FLAG11_MASK_RSVD2)
#define BP_PXP_WFA_ARRAY_FLAG11_MASK_OFFSET_Y      20
#define BM_PXP_WFA_ARRAY_FLAG11_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFA_ARRAY_FLAG11_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFA_ARRAY_FLAG11_MASK_OFFSET_Y)
#define BP_PXP_WFA_ARRAY_FLAG11_MASK_RSVD3      18
#define BM_PXP_WFA_ARRAY_FLAG11_MASK_RSVD3 0x000C0000
#define BF_PXP_WFA_ARRAY_FLAG11_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFA_ARRAY_FLAG11_MASK_RSVD3)
#define BP_PXP_WFA_ARRAY_FLAG11_MASK_OFFSET_X      16
#define BM_PXP_WFA_ARRAY_FLAG11_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFA_ARRAY_FLAG11_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFA_ARRAY_FLAG11_MASK_OFFSET_X)
#define BP_PXP_WFA_ARRAY_FLAG11_MASK_RSVD4      13
#define BM_PXP_WFA_ARRAY_FLAG11_MASK_RSVD4 0x0000E000
#define BF_PXP_WFA_ARRAY_FLAG11_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFA_ARRAY_FLAG11_MASK_RSVD4)
#define BP_PXP_WFA_ARRAY_FLAG11_MASK_H_OFS      8
#define BM_PXP_WFA_ARRAY_FLAG11_MASK_H_OFS 0x00001F00
#define BF_PXP_WFA_ARRAY_FLAG11_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFA_ARRAY_FLAG11_MASK_H_OFS)
#define BP_PXP_WFA_ARRAY_FLAG11_MASK_RSVD5      5
#define BM_PXP_WFA_ARRAY_FLAG11_MASK_RSVD5 0x000000E0
#define BF_PXP_WFA_ARRAY_FLAG11_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFA_ARRAY_FLAG11_MASK_RSVD5)
#define BP_PXP_WFA_ARRAY_FLAG11_MASK_L_OFS      0
#define BM_PXP_WFA_ARRAY_FLAG11_MASK_L_OFS 0x0000001F
#define BF_PXP_WFA_ARRAY_FLAG11_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFA_ARRAY_FLAG11_MASK_L_OFS)

#define HW_PXP_WFA_ARRAY_FLAG12_MASK	(0x00000e10)

#define BP_PXP_WFA_ARRAY_FLAG12_MASK_RSVD0      30
#define BM_PXP_WFA_ARRAY_FLAG12_MASK_RSVD0 0xC0000000
#define BF_PXP_WFA_ARRAY_FLAG12_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFA_ARRAY_FLAG12_MASK_RSVD0)
#define BP_PXP_WFA_ARRAY_FLAG12_MASK_BUF_SEL      28
#define BM_PXP_WFA_ARRAY_FLAG12_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFA_ARRAY_FLAG12_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFA_ARRAY_FLAG12_MASK_BUF_SEL)
#define BV_PXP_WFA_ARRAY_FLAG12_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG12_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFA_ARRAY_FLAG12_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFA_ARRAY_FLAG12_MASK_RSVD1      26
#define BM_PXP_WFA_ARRAY_FLAG12_MASK_RSVD1 0x0C000000
#define BF_PXP_WFA_ARRAY_FLAG12_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFA_ARRAY_FLAG12_MASK_RSVD1)
#define BM_PXP_WFA_ARRAY_FLAG12_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFA_ARRAY_FLAG12_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFA_ARRAY_FLAG12_MASK_SIGN_Y)
#define BV_PXP_WFA_ARRAY_FLAG12_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG12_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFA_ARRAY_FLAG12_MASK_SIGN_X 0x01000000
#define BF_PXP_WFA_ARRAY_FLAG12_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFA_ARRAY_FLAG12_MASK_SIGN_X)
#define BV_PXP_WFA_ARRAY_FLAG12_MASK_SIGN_X__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG12_MASK_SIGN_X__1 0x1
#define BP_PXP_WFA_ARRAY_FLAG12_MASK_RSVD2      22
#define BM_PXP_WFA_ARRAY_FLAG12_MASK_RSVD2 0x00C00000
#define BF_PXP_WFA_ARRAY_FLAG12_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFA_ARRAY_FLAG12_MASK_RSVD2)
#define BP_PXP_WFA_ARRAY_FLAG12_MASK_OFFSET_Y      20
#define BM_PXP_WFA_ARRAY_FLAG12_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFA_ARRAY_FLAG12_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFA_ARRAY_FLAG12_MASK_OFFSET_Y)
#define BP_PXP_WFA_ARRAY_FLAG12_MASK_RSVD3      18
#define BM_PXP_WFA_ARRAY_FLAG12_MASK_RSVD3 0x000C0000
#define BF_PXP_WFA_ARRAY_FLAG12_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFA_ARRAY_FLAG12_MASK_RSVD3)
#define BP_PXP_WFA_ARRAY_FLAG12_MASK_OFFSET_X      16
#define BM_PXP_WFA_ARRAY_FLAG12_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFA_ARRAY_FLAG12_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFA_ARRAY_FLAG12_MASK_OFFSET_X)
#define BP_PXP_WFA_ARRAY_FLAG12_MASK_RSVD4      13
#define BM_PXP_WFA_ARRAY_FLAG12_MASK_RSVD4 0x0000E000
#define BF_PXP_WFA_ARRAY_FLAG12_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFA_ARRAY_FLAG12_MASK_RSVD4)
#define BP_PXP_WFA_ARRAY_FLAG12_MASK_H_OFS      8
#define BM_PXP_WFA_ARRAY_FLAG12_MASK_H_OFS 0x00001F00
#define BF_PXP_WFA_ARRAY_FLAG12_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFA_ARRAY_FLAG12_MASK_H_OFS)
#define BP_PXP_WFA_ARRAY_FLAG12_MASK_RSVD5      5
#define BM_PXP_WFA_ARRAY_FLAG12_MASK_RSVD5 0x000000E0
#define BF_PXP_WFA_ARRAY_FLAG12_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFA_ARRAY_FLAG12_MASK_RSVD5)
#define BP_PXP_WFA_ARRAY_FLAG12_MASK_L_OFS      0
#define BM_PXP_WFA_ARRAY_FLAG12_MASK_L_OFS 0x0000001F
#define BF_PXP_WFA_ARRAY_FLAG12_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFA_ARRAY_FLAG12_MASK_L_OFS)

#define HW_PXP_WFA_ARRAY_FLAG13_MASK	(0x00000e20)

#define BP_PXP_WFA_ARRAY_FLAG13_MASK_RSVD0      30
#define BM_PXP_WFA_ARRAY_FLAG13_MASK_RSVD0 0xC0000000
#define BF_PXP_WFA_ARRAY_FLAG13_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFA_ARRAY_FLAG13_MASK_RSVD0)
#define BP_PXP_WFA_ARRAY_FLAG13_MASK_BUF_SEL      28
#define BM_PXP_WFA_ARRAY_FLAG13_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFA_ARRAY_FLAG13_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFA_ARRAY_FLAG13_MASK_BUF_SEL)
#define BV_PXP_WFA_ARRAY_FLAG13_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG13_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFA_ARRAY_FLAG13_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFA_ARRAY_FLAG13_MASK_RSVD1      26
#define BM_PXP_WFA_ARRAY_FLAG13_MASK_RSVD1 0x0C000000
#define BF_PXP_WFA_ARRAY_FLAG13_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFA_ARRAY_FLAG13_MASK_RSVD1)
#define BM_PXP_WFA_ARRAY_FLAG13_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFA_ARRAY_FLAG13_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFA_ARRAY_FLAG13_MASK_SIGN_Y)
#define BV_PXP_WFA_ARRAY_FLAG13_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG13_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFA_ARRAY_FLAG13_MASK_SIGN_X 0x01000000
#define BF_PXP_WFA_ARRAY_FLAG13_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFA_ARRAY_FLAG13_MASK_SIGN_X)
#define BV_PXP_WFA_ARRAY_FLAG13_MASK_SIGN_X__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG13_MASK_SIGN_X__1 0x1
#define BP_PXP_WFA_ARRAY_FLAG13_MASK_RSVD2      22
#define BM_PXP_WFA_ARRAY_FLAG13_MASK_RSVD2 0x00C00000
#define BF_PXP_WFA_ARRAY_FLAG13_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFA_ARRAY_FLAG13_MASK_RSVD2)
#define BP_PXP_WFA_ARRAY_FLAG13_MASK_OFFSET_Y      20
#define BM_PXP_WFA_ARRAY_FLAG13_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFA_ARRAY_FLAG13_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFA_ARRAY_FLAG13_MASK_OFFSET_Y)
#define BP_PXP_WFA_ARRAY_FLAG13_MASK_RSVD3      18
#define BM_PXP_WFA_ARRAY_FLAG13_MASK_RSVD3 0x000C0000
#define BF_PXP_WFA_ARRAY_FLAG13_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFA_ARRAY_FLAG13_MASK_RSVD3)
#define BP_PXP_WFA_ARRAY_FLAG13_MASK_OFFSET_X      16
#define BM_PXP_WFA_ARRAY_FLAG13_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFA_ARRAY_FLAG13_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFA_ARRAY_FLAG13_MASK_OFFSET_X)
#define BP_PXP_WFA_ARRAY_FLAG13_MASK_RSVD4      13
#define BM_PXP_WFA_ARRAY_FLAG13_MASK_RSVD4 0x0000E000
#define BF_PXP_WFA_ARRAY_FLAG13_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFA_ARRAY_FLAG13_MASK_RSVD4)
#define BP_PXP_WFA_ARRAY_FLAG13_MASK_H_OFS      8
#define BM_PXP_WFA_ARRAY_FLAG13_MASK_H_OFS 0x00001F00
#define BF_PXP_WFA_ARRAY_FLAG13_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFA_ARRAY_FLAG13_MASK_H_OFS)
#define BP_PXP_WFA_ARRAY_FLAG13_MASK_RSVD5      5
#define BM_PXP_WFA_ARRAY_FLAG13_MASK_RSVD5 0x000000E0
#define BF_PXP_WFA_ARRAY_FLAG13_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFA_ARRAY_FLAG13_MASK_RSVD5)
#define BP_PXP_WFA_ARRAY_FLAG13_MASK_L_OFS      0
#define BM_PXP_WFA_ARRAY_FLAG13_MASK_L_OFS 0x0000001F
#define BF_PXP_WFA_ARRAY_FLAG13_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFA_ARRAY_FLAG13_MASK_L_OFS)

#define HW_PXP_WFA_ARRAY_FLAG14_MASK	(0x00000e30)

#define BP_PXP_WFA_ARRAY_FLAG14_MASK_RSVD0      30
#define BM_PXP_WFA_ARRAY_FLAG14_MASK_RSVD0 0xC0000000
#define BF_PXP_WFA_ARRAY_FLAG14_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFA_ARRAY_FLAG14_MASK_RSVD0)
#define BP_PXP_WFA_ARRAY_FLAG14_MASK_BUF_SEL      28
#define BM_PXP_WFA_ARRAY_FLAG14_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFA_ARRAY_FLAG14_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFA_ARRAY_FLAG14_MASK_BUF_SEL)
#define BV_PXP_WFA_ARRAY_FLAG14_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG14_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFA_ARRAY_FLAG14_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFA_ARRAY_FLAG14_MASK_RSVD1      26
#define BM_PXP_WFA_ARRAY_FLAG14_MASK_RSVD1 0x0C000000
#define BF_PXP_WFA_ARRAY_FLAG14_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFA_ARRAY_FLAG14_MASK_RSVD1)
#define BM_PXP_WFA_ARRAY_FLAG14_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFA_ARRAY_FLAG14_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFA_ARRAY_FLAG14_MASK_SIGN_Y)
#define BV_PXP_WFA_ARRAY_FLAG14_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG14_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFA_ARRAY_FLAG14_MASK_SIGN_X 0x01000000
#define BF_PXP_WFA_ARRAY_FLAG14_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFA_ARRAY_FLAG14_MASK_SIGN_X)
#define BV_PXP_WFA_ARRAY_FLAG14_MASK_SIGN_X__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG14_MASK_SIGN_X__1 0x1
#define BP_PXP_WFA_ARRAY_FLAG14_MASK_RSVD2      22
#define BM_PXP_WFA_ARRAY_FLAG14_MASK_RSVD2 0x00C00000
#define BF_PXP_WFA_ARRAY_FLAG14_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFA_ARRAY_FLAG14_MASK_RSVD2)
#define BP_PXP_WFA_ARRAY_FLAG14_MASK_OFFSET_Y      20
#define BM_PXP_WFA_ARRAY_FLAG14_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFA_ARRAY_FLAG14_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFA_ARRAY_FLAG14_MASK_OFFSET_Y)
#define BP_PXP_WFA_ARRAY_FLAG14_MASK_RSVD3      18
#define BM_PXP_WFA_ARRAY_FLAG14_MASK_RSVD3 0x000C0000
#define BF_PXP_WFA_ARRAY_FLAG14_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFA_ARRAY_FLAG14_MASK_RSVD3)
#define BP_PXP_WFA_ARRAY_FLAG14_MASK_OFFSET_X      16
#define BM_PXP_WFA_ARRAY_FLAG14_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFA_ARRAY_FLAG14_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFA_ARRAY_FLAG14_MASK_OFFSET_X)
#define BP_PXP_WFA_ARRAY_FLAG14_MASK_RSVD4      13
#define BM_PXP_WFA_ARRAY_FLAG14_MASK_RSVD4 0x0000E000
#define BF_PXP_WFA_ARRAY_FLAG14_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFA_ARRAY_FLAG14_MASK_RSVD4)
#define BP_PXP_WFA_ARRAY_FLAG14_MASK_H_OFS      8
#define BM_PXP_WFA_ARRAY_FLAG14_MASK_H_OFS 0x00001F00
#define BF_PXP_WFA_ARRAY_FLAG14_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFA_ARRAY_FLAG14_MASK_H_OFS)
#define BP_PXP_WFA_ARRAY_FLAG14_MASK_RSVD5      5
#define BM_PXP_WFA_ARRAY_FLAG14_MASK_RSVD5 0x000000E0
#define BF_PXP_WFA_ARRAY_FLAG14_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFA_ARRAY_FLAG14_MASK_RSVD5)
#define BP_PXP_WFA_ARRAY_FLAG14_MASK_L_OFS      0
#define BM_PXP_WFA_ARRAY_FLAG14_MASK_L_OFS 0x0000001F
#define BF_PXP_WFA_ARRAY_FLAG14_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFA_ARRAY_FLAG14_MASK_L_OFS)

#define HW_PXP_WFA_ARRAY_FLAG15_MASK	(0x00000e40)

#define BP_PXP_WFA_ARRAY_FLAG15_MASK_RSVD0      30
#define BM_PXP_WFA_ARRAY_FLAG15_MASK_RSVD0 0xC0000000
#define BF_PXP_WFA_ARRAY_FLAG15_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFA_ARRAY_FLAG15_MASK_RSVD0)
#define BP_PXP_WFA_ARRAY_FLAG15_MASK_BUF_SEL      28
#define BM_PXP_WFA_ARRAY_FLAG15_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFA_ARRAY_FLAG15_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFA_ARRAY_FLAG15_MASK_BUF_SEL)
#define BV_PXP_WFA_ARRAY_FLAG15_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG15_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFA_ARRAY_FLAG15_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFA_ARRAY_FLAG15_MASK_RSVD1      26
#define BM_PXP_WFA_ARRAY_FLAG15_MASK_RSVD1 0x0C000000
#define BF_PXP_WFA_ARRAY_FLAG15_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFA_ARRAY_FLAG15_MASK_RSVD1)
#define BM_PXP_WFA_ARRAY_FLAG15_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFA_ARRAY_FLAG15_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFA_ARRAY_FLAG15_MASK_SIGN_Y)
#define BV_PXP_WFA_ARRAY_FLAG15_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG15_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFA_ARRAY_FLAG15_MASK_SIGN_X 0x01000000
#define BF_PXP_WFA_ARRAY_FLAG15_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFA_ARRAY_FLAG15_MASK_SIGN_X)
#define BV_PXP_WFA_ARRAY_FLAG15_MASK_SIGN_X__0 0x0
#define BV_PXP_WFA_ARRAY_FLAG15_MASK_SIGN_X__1 0x1
#define BP_PXP_WFA_ARRAY_FLAG15_MASK_RSVD2      22
#define BM_PXP_WFA_ARRAY_FLAG15_MASK_RSVD2 0x00C00000
#define BF_PXP_WFA_ARRAY_FLAG15_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFA_ARRAY_FLAG15_MASK_RSVD2)
#define BP_PXP_WFA_ARRAY_FLAG15_MASK_OFFSET_Y      20
#define BM_PXP_WFA_ARRAY_FLAG15_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFA_ARRAY_FLAG15_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFA_ARRAY_FLAG15_MASK_OFFSET_Y)
#define BP_PXP_WFA_ARRAY_FLAG15_MASK_RSVD3      18
#define BM_PXP_WFA_ARRAY_FLAG15_MASK_RSVD3 0x000C0000
#define BF_PXP_WFA_ARRAY_FLAG15_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFA_ARRAY_FLAG15_MASK_RSVD3)
#define BP_PXP_WFA_ARRAY_FLAG15_MASK_OFFSET_X      16
#define BM_PXP_WFA_ARRAY_FLAG15_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFA_ARRAY_FLAG15_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFA_ARRAY_FLAG15_MASK_OFFSET_X)
#define BP_PXP_WFA_ARRAY_FLAG15_MASK_RSVD4      13
#define BM_PXP_WFA_ARRAY_FLAG15_MASK_RSVD4 0x0000E000
#define BF_PXP_WFA_ARRAY_FLAG15_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFA_ARRAY_FLAG15_MASK_RSVD4)
#define BP_PXP_WFA_ARRAY_FLAG15_MASK_H_OFS      8
#define BM_PXP_WFA_ARRAY_FLAG15_MASK_H_OFS 0x00001F00
#define BF_PXP_WFA_ARRAY_FLAG15_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFA_ARRAY_FLAG15_MASK_H_OFS)
#define BP_PXP_WFA_ARRAY_FLAG15_MASK_RSVD5      5
#define BM_PXP_WFA_ARRAY_FLAG15_MASK_RSVD5 0x000000E0
#define BF_PXP_WFA_ARRAY_FLAG15_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFA_ARRAY_FLAG15_MASK_RSVD5)
#define BP_PXP_WFA_ARRAY_FLAG15_MASK_L_OFS      0
#define BM_PXP_WFA_ARRAY_FLAG15_MASK_L_OFS 0x0000001F
#define BF_PXP_WFA_ARRAY_FLAG15_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFA_ARRAY_FLAG15_MASK_L_OFS)

#define HW_PXP_WFA_ARRAY_REG0	(0x00000e50)

#define BP_PXP_WFA_ARRAY_REG0_SW_PIXLE3      24
#define BM_PXP_WFA_ARRAY_REG0_SW_PIXLE3 0xFF000000
#define BF_PXP_WFA_ARRAY_REG0_SW_PIXLE3(v) \
        (((v) << 24) & BM_PXP_WFA_ARRAY_REG0_SW_PIXLE3)
#define BP_PXP_WFA_ARRAY_REG0_SW_PIXLE2      16
#define BM_PXP_WFA_ARRAY_REG0_SW_PIXLE2 0x00FF0000
#define BF_PXP_WFA_ARRAY_REG0_SW_PIXLE2(v)  \
        (((v) << 16) & BM_PXP_WFA_ARRAY_REG0_SW_PIXLE2)
#define BP_PXP_WFA_ARRAY_REG0_SW_PIXLE1      8
#define BM_PXP_WFA_ARRAY_REG0_SW_PIXLE1 0x0000FF00
#define BF_PXP_WFA_ARRAY_REG0_SW_PIXLE1(v)  \
        (((v) << 8) & BM_PXP_WFA_ARRAY_REG0_SW_PIXLE1)
#define BP_PXP_WFA_ARRAY_REG0_SW_PIXLE0      0
#define BM_PXP_WFA_ARRAY_REG0_SW_PIXLE0 0x000000FF
#define BF_PXP_WFA_ARRAY_REG0_SW_PIXLE0(v)  \
        (((v) << 0) & BM_PXP_WFA_ARRAY_REG0_SW_PIXLE0)

#define HW_PXP_WFA_ARRAY_REG1	(0x00000e60)

#define BP_PXP_WFA_ARRAY_REG1_SW_PIXLE7      24
#define BM_PXP_WFA_ARRAY_REG1_SW_PIXLE7 0xFF000000
#define BF_PXP_WFA_ARRAY_REG1_SW_PIXLE7(v) \
        (((v) << 24) & BM_PXP_WFA_ARRAY_REG1_SW_PIXLE7)
#define BP_PXP_WFA_ARRAY_REG1_SW_PIXLE6      16
#define BM_PXP_WFA_ARRAY_REG1_SW_PIXLE6 0x00FF0000
#define BF_PXP_WFA_ARRAY_REG1_SW_PIXLE6(v)  \
        (((v) << 16) & BM_PXP_WFA_ARRAY_REG1_SW_PIXLE6)
#define BP_PXP_WFA_ARRAY_REG1_SW_PIXLE5      8
#define BM_PXP_WFA_ARRAY_REG1_SW_PIXLE5 0x0000FF00
#define BF_PXP_WFA_ARRAY_REG1_SW_PIXLE5(v)  \
        (((v) << 8) & BM_PXP_WFA_ARRAY_REG1_SW_PIXLE5)
#define BP_PXP_WFA_ARRAY_REG1_SW_PIXLE4      0
#define BM_PXP_WFA_ARRAY_REG1_SW_PIXLE4 0x000000FF
#define BF_PXP_WFA_ARRAY_REG1_SW_PIXLE4(v)  \
        (((v) << 0) & BM_PXP_WFA_ARRAY_REG1_SW_PIXLE4)

#define HW_PXP_WFA_ARRAY_REG2	(0x00000e70)

#define BP_PXP_WFA_ARRAY_REG2_RSVD0      16
#define BM_PXP_WFA_ARRAY_REG2_RSVD0 0xFFFF0000
#define BF_PXP_WFA_ARRAY_REG2_RSVD0(v) \
        (((v) << 16) & BM_PXP_WFA_ARRAY_REG2_RSVD0)
#define BM_PXP_WFA_ARRAY_REG2_SW_FLAG15 0x00008000
#define BF_PXP_WFA_ARRAY_REG2_SW_FLAG15(v)  \
        (((v) << 15) & BM_PXP_WFA_ARRAY_REG2_SW_FLAG15)
#define BM_PXP_WFA_ARRAY_REG2_SW_FLAG14 0x00004000
#define BF_PXP_WFA_ARRAY_REG2_SW_FLAG14(v)  \
        (((v) << 14) & BM_PXP_WFA_ARRAY_REG2_SW_FLAG14)
#define BM_PXP_WFA_ARRAY_REG2_SW_FLAG13 0x00002000
#define BF_PXP_WFA_ARRAY_REG2_SW_FLAG13(v)  \
        (((v) << 13) & BM_PXP_WFA_ARRAY_REG2_SW_FLAG13)
#define BM_PXP_WFA_ARRAY_REG2_SW_FLAG12 0x00001000
#define BF_PXP_WFA_ARRAY_REG2_SW_FLAG12(v)  \
        (((v) << 12) & BM_PXP_WFA_ARRAY_REG2_SW_FLAG12)
#define BM_PXP_WFA_ARRAY_REG2_SW_FLAG11 0x00000800
#define BF_PXP_WFA_ARRAY_REG2_SW_FLAG11(v)  \
        (((v) << 11) & BM_PXP_WFA_ARRAY_REG2_SW_FLAG11)
#define BM_PXP_WFA_ARRAY_REG2_SW_FLAG10 0x00000400
#define BF_PXP_WFA_ARRAY_REG2_SW_FLAG10(v)  \
        (((v) << 10) & BM_PXP_WFA_ARRAY_REG2_SW_FLAG10)
#define BM_PXP_WFA_ARRAY_REG2_SW_FLAG9 0x00000200
#define BF_PXP_WFA_ARRAY_REG2_SW_FLAG9(v)  \
        (((v) << 9) & BM_PXP_WFA_ARRAY_REG2_SW_FLAG9)
#define BM_PXP_WFA_ARRAY_REG2_SW_FLAG8 0x00000100
#define BF_PXP_WFA_ARRAY_REG2_SW_FLAG8(v)  \
        (((v) << 8) & BM_PXP_WFA_ARRAY_REG2_SW_FLAG8)
#define BM_PXP_WFA_ARRAY_REG2_SW_FLAG7 0x00000080
#define BF_PXP_WFA_ARRAY_REG2_SW_FLAG7(v)  \
        (((v) << 7) & BM_PXP_WFA_ARRAY_REG2_SW_FLAG7)
#define BM_PXP_WFA_ARRAY_REG2_SW_FLAG6 0x00000040
#define BF_PXP_WFA_ARRAY_REG2_SW_FLAG6(v)  \
        (((v) << 6) & BM_PXP_WFA_ARRAY_REG2_SW_FLAG6)
#define BM_PXP_WFA_ARRAY_REG2_SW_FLAG5 0x00000020
#define BF_PXP_WFA_ARRAY_REG2_SW_FLAG5(v)  \
        (((v) << 5) & BM_PXP_WFA_ARRAY_REG2_SW_FLAG5)
#define BM_PXP_WFA_ARRAY_REG2_SW_FLAG4 0x00000010
#define BF_PXP_WFA_ARRAY_REG2_SW_FLAG4(v)  \
        (((v) << 4) & BM_PXP_WFA_ARRAY_REG2_SW_FLAG4)
#define BM_PXP_WFA_ARRAY_REG2_SW_FLAG3 0x00000008
#define BF_PXP_WFA_ARRAY_REG2_SW_FLAG3(v)  \
        (((v) << 3) & BM_PXP_WFA_ARRAY_REG2_SW_FLAG3)
#define BM_PXP_WFA_ARRAY_REG2_SW_FLAG2 0x00000004
#define BF_PXP_WFA_ARRAY_REG2_SW_FLAG2(v)  \
        (((v) << 2) & BM_PXP_WFA_ARRAY_REG2_SW_FLAG2)
#define BM_PXP_WFA_ARRAY_REG2_SW_FLAG1 0x00000002
#define BF_PXP_WFA_ARRAY_REG2_SW_FLAG1(v)  \
        (((v) << 1) & BM_PXP_WFA_ARRAY_REG2_SW_FLAG1)
#define BM_PXP_WFA_ARRAY_REG2_SW_FLAG0 0x00000001
#define BF_PXP_WFA_ARRAY_REG2_SW_FLAG0(v)  \
        (((v) << 0) & BM_PXP_WFA_ARRAY_REG2_SW_FLAG0)

#define HW_PXP_WFE_A_STORE_CTRL_CH0	(0x00000e80)
#define HW_PXP_WFE_A_STORE_CTRL_CH0_SET	(0x00000e84)
#define HW_PXP_WFE_A_STORE_CTRL_CH0_CLR	(0x00000e88)
#define HW_PXP_WFE_A_STORE_CTRL_CH0_TOG	(0x00000e8c)

#define BM_PXP_WFE_A_STORE_CTRL_CH0_ARBIT_EN 0x80000000
#define BF_PXP_WFE_A_STORE_CTRL_CH0_ARBIT_EN(v) \
        (((v) << 31) & BM_PXP_WFE_A_STORE_CTRL_CH0_ARBIT_EN)
#define BV_PXP_WFE_A_STORE_CTRL_CH0_ARBIT_EN__0 0x0
#define BV_PXP_WFE_A_STORE_CTRL_CH0_ARBIT_EN__1 0x1
#define BP_PXP_WFE_A_STORE_CTRL_CH0_RSVD0      25
#define BM_PXP_WFE_A_STORE_CTRL_CH0_RSVD0 0x7E000000
#define BF_PXP_WFE_A_STORE_CTRL_CH0_RSVD0(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STORE_CTRL_CH0_RSVD0)
#define BM_PXP_WFE_A_STORE_CTRL_CH0_COMBINE_2CHANNEL 0x01000000
#define BF_PXP_WFE_A_STORE_CTRL_CH0_COMBINE_2CHANNEL(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STORE_CTRL_CH0_COMBINE_2CHANNEL)
#define BV_PXP_WFE_A_STORE_CTRL_CH0_COMBINE_2CHANNEL__0 0x0
#define BV_PXP_WFE_A_STORE_CTRL_CH0_COMBINE_2CHANNEL__1 0x1
#define BP_PXP_WFE_A_STORE_CTRL_CH0_RSVD1      18
#define BM_PXP_WFE_A_STORE_CTRL_CH0_RSVD1 0x00FC0000
#define BF_PXP_WFE_A_STORE_CTRL_CH0_RSVD1(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STORE_CTRL_CH0_RSVD1)
#define BP_PXP_WFE_A_STORE_CTRL_CH0_WR_NUM_BYTES      16
#define BM_PXP_WFE_A_STORE_CTRL_CH0_WR_NUM_BYTES 0x00030000
#define BF_PXP_WFE_A_STORE_CTRL_CH0_WR_NUM_BYTES(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STORE_CTRL_CH0_WR_NUM_BYTES)
#define BV_PXP_WFE_A_STORE_CTRL_CH0_WR_NUM_BYTES__8_bytes  0x0
#define BV_PXP_WFE_A_STORE_CTRL_CH0_WR_NUM_BYTES__16_bytes 0x1
#define BV_PXP_WFE_A_STORE_CTRL_CH0_WR_NUM_BYTES__32_bytes 0x2
#define BV_PXP_WFE_A_STORE_CTRL_CH0_WR_NUM_BYTES__64_bytes 0x3
#define BP_PXP_WFE_A_STORE_CTRL_CH0_RSVD2      12
#define BM_PXP_WFE_A_STORE_CTRL_CH0_RSVD2 0x0000F000
#define BF_PXP_WFE_A_STORE_CTRL_CH0_RSVD2(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STORE_CTRL_CH0_RSVD2)
#define BM_PXP_WFE_A_STORE_CTRL_CH0_FILL_DATA_EN 0x00000800
#define BF_PXP_WFE_A_STORE_CTRL_CH0_FILL_DATA_EN(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STORE_CTRL_CH0_FILL_DATA_EN)
#define BV_PXP_WFE_A_STORE_CTRL_CH0_FILL_DATA_EN__0 0x0
#define BV_PXP_WFE_A_STORE_CTRL_CH0_FILL_DATA_EN__1 0x1
#define BM_PXP_WFE_A_STORE_CTRL_CH0_PACK_IN_SEL 0x00000400
#define BF_PXP_WFE_A_STORE_CTRL_CH0_PACK_IN_SEL(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STORE_CTRL_CH0_PACK_IN_SEL)
#define BV_PXP_WFE_A_STORE_CTRL_CH0_PACK_IN_SEL__0 0x0
#define BV_PXP_WFE_A_STORE_CTRL_CH0_PACK_IN_SEL__1 0x1
#define BM_PXP_WFE_A_STORE_CTRL_CH0_STORE_MEMORY_EN 0x00000200
#define BF_PXP_WFE_A_STORE_CTRL_CH0_STORE_MEMORY_EN(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STORE_CTRL_CH0_STORE_MEMORY_EN)
#define BV_PXP_WFE_A_STORE_CTRL_CH0_STORE_MEMORY_EN__0 0x0
#define BV_PXP_WFE_A_STORE_CTRL_CH0_STORE_MEMORY_EN__1 0x1
#define BM_PXP_WFE_A_STORE_CTRL_CH0_STORE_BYPASS_EN 0x00000100
#define BF_PXP_WFE_A_STORE_CTRL_CH0_STORE_BYPASS_EN(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STORE_CTRL_CH0_STORE_BYPASS_EN)
#define BV_PXP_WFE_A_STORE_CTRL_CH0_STORE_BYPASS_EN__0 0x0
#define BV_PXP_WFE_A_STORE_CTRL_CH0_STORE_BYPASS_EN__1 0x1
#define BM_PXP_WFE_A_STORE_CTRL_CH0_RSVD3 0x00000080
#define BF_PXP_WFE_A_STORE_CTRL_CH0_RSVD3(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STORE_CTRL_CH0_RSVD3)
#define BP_PXP_WFE_A_STORE_CTRL_CH0_ARRAY_LINE_NUM      5
#define BM_PXP_WFE_A_STORE_CTRL_CH0_ARRAY_LINE_NUM 0x00000060
#define BF_PXP_WFE_A_STORE_CTRL_CH0_ARRAY_LINE_NUM(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STORE_CTRL_CH0_ARRAY_LINE_NUM)
#define BV_PXP_WFE_A_STORE_CTRL_CH0_ARRAY_LINE_NUM__0 0x0
#define BV_PXP_WFE_A_STORE_CTRL_CH0_ARRAY_LINE_NUM__1 0x1
#define BV_PXP_WFE_A_STORE_CTRL_CH0_ARRAY_LINE_NUM__2 0x2
#define BV_PXP_WFE_A_STORE_CTRL_CH0_ARRAY_LINE_NUM__3 0x3
#define BM_PXP_WFE_A_STORE_CTRL_CH0_ARRAY_EN 0x00000010
#define BF_PXP_WFE_A_STORE_CTRL_CH0_ARRAY_EN(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STORE_CTRL_CH0_ARRAY_EN)
#define BV_PXP_WFE_A_STORE_CTRL_CH0_ARRAY_EN__0 0x0
#define BV_PXP_WFE_A_STORE_CTRL_CH0_ARRAY_EN__1 0x1
#define BM_PXP_WFE_A_STORE_CTRL_CH0_HANDSHAKE_EN 0x00000008
#define BF_PXP_WFE_A_STORE_CTRL_CH0_HANDSHAKE_EN(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STORE_CTRL_CH0_HANDSHAKE_EN)
#define BV_PXP_WFE_A_STORE_CTRL_CH0_HANDSHAKE_EN__0 0x0
#define BV_PXP_WFE_A_STORE_CTRL_CH0_HANDSHAKE_EN__1 0x1
#define BM_PXP_WFE_A_STORE_CTRL_CH0_BLOCK_16 0x00000004
#define BF_PXP_WFE_A_STORE_CTRL_CH0_BLOCK_16(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STORE_CTRL_CH0_BLOCK_16)
#define BV_PXP_WFE_A_STORE_CTRL_CH0_BLOCK_16__8x8   0x0
#define BV_PXP_WFE_A_STORE_CTRL_CH0_BLOCK_16__16x16 0x1
#define BM_PXP_WFE_A_STORE_CTRL_CH0_BLOCK_EN 0x00000002
#define BF_PXP_WFE_A_STORE_CTRL_CH0_BLOCK_EN(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STORE_CTRL_CH0_BLOCK_EN)
#define BV_PXP_WFE_A_STORE_CTRL_CH0_BLOCK_EN__0 0x0
#define BV_PXP_WFE_A_STORE_CTRL_CH0_BLOCK_EN__1 0x1
#define BM_PXP_WFE_A_STORE_CTRL_CH0_CH_EN 0x00000001
#define BF_PXP_WFE_A_STORE_CTRL_CH0_CH_EN(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STORE_CTRL_CH0_CH_EN)
#define BV_PXP_WFE_A_STORE_CTRL_CH0_CH_EN__0 0x0
#define BV_PXP_WFE_A_STORE_CTRL_CH0_CH_EN__1 0x1

#define HW_PXP_WFE_A_STORE_CTRL_CH1	(0x00000e90)
#define HW_PXP_WFE_A_STORE_CTRL_CH1_SET	(0x00000e94)
#define HW_PXP_WFE_A_STORE_CTRL_CH1_CLR	(0x00000e98)
#define HW_PXP_WFE_A_STORE_CTRL_CH1_TOG	(0x00000e9c)

#define BP_PXP_WFE_A_STORE_CTRL_CH1_RSVD0      18
#define BM_PXP_WFE_A_STORE_CTRL_CH1_RSVD0 0xFFFC0000
#define BF_PXP_WFE_A_STORE_CTRL_CH1_RSVD0(v) \
        (((v) << 18) & BM_PXP_WFE_A_STORE_CTRL_CH1_RSVD0)
#define BP_PXP_WFE_A_STORE_CTRL_CH1_WR_NUM_BYTES      16
#define BM_PXP_WFE_A_STORE_CTRL_CH1_WR_NUM_BYTES 0x00030000
#define BF_PXP_WFE_A_STORE_CTRL_CH1_WR_NUM_BYTES(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STORE_CTRL_CH1_WR_NUM_BYTES)
#define BV_PXP_WFE_A_STORE_CTRL_CH1_WR_NUM_BYTES__8_bytes  0x0
#define BV_PXP_WFE_A_STORE_CTRL_CH1_WR_NUM_BYTES__16_bytes 0x1
#define BV_PXP_WFE_A_STORE_CTRL_CH1_WR_NUM_BYTES__32_bytes 0x2
#define BV_PXP_WFE_A_STORE_CTRL_CH1_WR_NUM_BYTES__64_bytes 0x3
#define BP_PXP_WFE_A_STORE_CTRL_CH1_RSVD1      11
#define BM_PXP_WFE_A_STORE_CTRL_CH1_RSVD1 0x0000F800
#define BF_PXP_WFE_A_STORE_CTRL_CH1_RSVD1(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STORE_CTRL_CH1_RSVD1)
#define BM_PXP_WFE_A_STORE_CTRL_CH1_PACK_IN_SEL 0x00000400
#define BF_PXP_WFE_A_STORE_CTRL_CH1_PACK_IN_SEL(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STORE_CTRL_CH1_PACK_IN_SEL)
#define BV_PXP_WFE_A_STORE_CTRL_CH1_PACK_IN_SEL__0 0x0
#define BV_PXP_WFE_A_STORE_CTRL_CH1_PACK_IN_SEL__1 0x1
#define BM_PXP_WFE_A_STORE_CTRL_CH1_STORE_MEMORY_EN 0x00000200
#define BF_PXP_WFE_A_STORE_CTRL_CH1_STORE_MEMORY_EN(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STORE_CTRL_CH1_STORE_MEMORY_EN)
#define BV_PXP_WFE_A_STORE_CTRL_CH1_STORE_MEMORY_EN__0 0x0
#define BV_PXP_WFE_A_STORE_CTRL_CH1_STORE_MEMORY_EN__1 0x1
#define BM_PXP_WFE_A_STORE_CTRL_CH1_STORE_BYPASS_EN 0x00000100
#define BF_PXP_WFE_A_STORE_CTRL_CH1_STORE_BYPASS_EN(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STORE_CTRL_CH1_STORE_BYPASS_EN)
#define BV_PXP_WFE_A_STORE_CTRL_CH1_STORE_BYPASS_EN__0 0x0
#define BV_PXP_WFE_A_STORE_CTRL_CH1_STORE_BYPASS_EN__1 0x1
#define BM_PXP_WFE_A_STORE_CTRL_CH1_RSVD3 0x00000080
#define BF_PXP_WFE_A_STORE_CTRL_CH1_RSVD3(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STORE_CTRL_CH1_RSVD3)
#define BP_PXP_WFE_A_STORE_CTRL_CH1_ARRAY_LINE_NUM      5
#define BM_PXP_WFE_A_STORE_CTRL_CH1_ARRAY_LINE_NUM 0x00000060
#define BF_PXP_WFE_A_STORE_CTRL_CH1_ARRAY_LINE_NUM(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STORE_CTRL_CH1_ARRAY_LINE_NUM)
#define BV_PXP_WFE_A_STORE_CTRL_CH1_ARRAY_LINE_NUM__0 0x0
#define BV_PXP_WFE_A_STORE_CTRL_CH1_ARRAY_LINE_NUM__1 0x1
#define BV_PXP_WFE_A_STORE_CTRL_CH1_ARRAY_LINE_NUM__2 0x2
#define BV_PXP_WFE_A_STORE_CTRL_CH1_ARRAY_LINE_NUM__3 0x3
#define BM_PXP_WFE_A_STORE_CTRL_CH1_ARRAY_EN 0x00000010
#define BF_PXP_WFE_A_STORE_CTRL_CH1_ARRAY_EN(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STORE_CTRL_CH1_ARRAY_EN)
#define BV_PXP_WFE_A_STORE_CTRL_CH1_ARRAY_EN__0 0x0
#define BV_PXP_WFE_A_STORE_CTRL_CH1_ARRAY_EN__1 0x1
#define BM_PXP_WFE_A_STORE_CTRL_CH1_HANDSHAKE_EN 0x00000008
#define BF_PXP_WFE_A_STORE_CTRL_CH1_HANDSHAKE_EN(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STORE_CTRL_CH1_HANDSHAKE_EN)
#define BV_PXP_WFE_A_STORE_CTRL_CH1_HANDSHAKE_EN__0 0x0
#define BV_PXP_WFE_A_STORE_CTRL_CH1_HANDSHAKE_EN__1 0x1
#define BM_PXP_WFE_A_STORE_CTRL_CH1_BLOCK_16 0x00000004
#define BF_PXP_WFE_A_STORE_CTRL_CH1_BLOCK_16(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STORE_CTRL_CH1_BLOCK_16)
#define BV_PXP_WFE_A_STORE_CTRL_CH1_BLOCK_16__8x8   0x0
#define BV_PXP_WFE_A_STORE_CTRL_CH1_BLOCK_16__16x16 0x1
#define BM_PXP_WFE_A_STORE_CTRL_CH1_BLOCK_EN 0x00000002
#define BF_PXP_WFE_A_STORE_CTRL_CH1_BLOCK_EN(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STORE_CTRL_CH1_BLOCK_EN)
#define BV_PXP_WFE_A_STORE_CTRL_CH1_BLOCK_EN__0 0x0
#define BV_PXP_WFE_A_STORE_CTRL_CH1_BLOCK_EN__1 0x1
#define BM_PXP_WFE_A_STORE_CTRL_CH1_CH_EN 0x00000001
#define BF_PXP_WFE_A_STORE_CTRL_CH1_CH_EN(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STORE_CTRL_CH1_CH_EN)
#define BV_PXP_WFE_A_STORE_CTRL_CH1_CH_EN__0 0x0
#define BV_PXP_WFE_A_STORE_CTRL_CH1_CH_EN__1 0x1

#define HW_PXP_WFE_A_STORE_STATUS_CH0	(0x00000ea0)

#define BP_PXP_WFE_A_STORE_STATUS_CH0_STORE_BLOCK_Y      16
#define BM_PXP_WFE_A_STORE_STATUS_CH0_STORE_BLOCK_Y 0xFFFF0000
#define BF_PXP_WFE_A_STORE_STATUS_CH0_STORE_BLOCK_Y(v) \
        (((v) << 16) & BM_PXP_WFE_A_STORE_STATUS_CH0_STORE_BLOCK_Y)
#define BP_PXP_WFE_A_STORE_STATUS_CH0_STORE_BLOCK_X      0
#define BM_PXP_WFE_A_STORE_STATUS_CH0_STORE_BLOCK_X 0x0000FFFF
#define BF_PXP_WFE_A_STORE_STATUS_CH0_STORE_BLOCK_X(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STORE_STATUS_CH0_STORE_BLOCK_X)

#define HW_PXP_WFE_A_STORE_STATUS_CH1	(0x00000eb0)

#define BP_PXP_WFE_A_STORE_STATUS_CH1_STORE_BLOCK_Y      16
#define BM_PXP_WFE_A_STORE_STATUS_CH1_STORE_BLOCK_Y 0xFFFF0000
#define BF_PXP_WFE_A_STORE_STATUS_CH1_STORE_BLOCK_Y(v) \
        (((v) << 16) & BM_PXP_WFE_A_STORE_STATUS_CH1_STORE_BLOCK_Y)
#define BP_PXP_WFE_A_STORE_STATUS_CH1_STORE_BLOCK_X      0
#define BM_PXP_WFE_A_STORE_STATUS_CH1_STORE_BLOCK_X 0x0000FFFF
#define BF_PXP_WFE_A_STORE_STATUS_CH1_STORE_BLOCK_X(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STORE_STATUS_CH1_STORE_BLOCK_X)

#define HW_PXP_WFE_A_STORE_SIZE_CH0	(0x00000ec0)

#define BP_PXP_WFE_A_STORE_SIZE_CH0_OUT_HEIGHT      16
#define BM_PXP_WFE_A_STORE_SIZE_CH0_OUT_HEIGHT 0xFFFF0000
#define BF_PXP_WFE_A_STORE_SIZE_CH0_OUT_HEIGHT(v) \
        (((v) << 16) & BM_PXP_WFE_A_STORE_SIZE_CH0_OUT_HEIGHT)
#define BP_PXP_WFE_A_STORE_SIZE_CH0_OUT_WIDTH      0
#define BM_PXP_WFE_A_STORE_SIZE_CH0_OUT_WIDTH 0x0000FFFF
#define BF_PXP_WFE_A_STORE_SIZE_CH0_OUT_WIDTH(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STORE_SIZE_CH0_OUT_WIDTH)

#define HW_PXP_WFE_A_STORE_SIZE_CH1	(0x00000ed0)

#define BP_PXP_WFE_A_STORE_SIZE_CH1_OUT_HEIGHT      16
#define BM_PXP_WFE_A_STORE_SIZE_CH1_OUT_HEIGHT 0xFFFF0000
#define BF_PXP_WFE_A_STORE_SIZE_CH1_OUT_HEIGHT(v) \
        (((v) << 16) & BM_PXP_WFE_A_STORE_SIZE_CH1_OUT_HEIGHT)
#define BP_PXP_WFE_A_STORE_SIZE_CH1_OUT_WIDTH      0
#define BM_PXP_WFE_A_STORE_SIZE_CH1_OUT_WIDTH 0x0000FFFF
#define BF_PXP_WFE_A_STORE_SIZE_CH1_OUT_WIDTH(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STORE_SIZE_CH1_OUT_WIDTH)

#define HW_PXP_WFE_A_STORE_PITCH	(0x00000ee0)

#define BP_PXP_WFE_A_STORE_PITCH_CH1_OUT_PITCH      16
#define BM_PXP_WFE_A_STORE_PITCH_CH1_OUT_PITCH 0xFFFF0000
#define BF_PXP_WFE_A_STORE_PITCH_CH1_OUT_PITCH(v) \
        (((v) << 16) & BM_PXP_WFE_A_STORE_PITCH_CH1_OUT_PITCH)
#define BP_PXP_WFE_A_STORE_PITCH_CH0_OUT_PITCH      0
#define BM_PXP_WFE_A_STORE_PITCH_CH0_OUT_PITCH 0x0000FFFF
#define BF_PXP_WFE_A_STORE_PITCH_CH0_OUT_PITCH(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STORE_PITCH_CH0_OUT_PITCH)

#define HW_PXP_WFE_A_STORE_SHIFT_CTRL_CH0	(0x00000ef0)
#define HW_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_SET	(0x00000ef4)
#define HW_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_CLR	(0x00000ef8)
#define HW_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_TOG	(0x00000efc)

#define BP_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_RSVD0      8
#define BM_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_RSVD0 0xFFFFFF00
#define BF_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_RSVD0(v) \
        (((v) << 8) & BM_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_RSVD0)
#define BM_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_SHIFT_BYPASS 0x00000080
#define BF_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_SHIFT_BYPASS(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_SHIFT_BYPASS)
#define BV_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_SHIFT_BYPASS__0 0x0
#define BV_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_SHIFT_BYPASS__1 0x1
#define BM_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_RSVD1 0x00000040
#define BF_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_RSVD1(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_RSVD1)
#define BM_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_OUT_YUV422_2P_EN 0x00000020
#define BF_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_OUT_YUV422_2P_EN(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_OUT_YUV422_2P_EN)
#define BV_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_OUT_YUV422_2P_EN__0 0x0
#define BV_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_OUT_YUV422_2P_EN__1 0x1
#define BM_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_OUT_YUV422_1P_EN 0x00000010
#define BF_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_OUT_YUV422_1P_EN(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_OUT_YUV422_1P_EN)
#define BV_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_OUT_YUV422_1P_EN__0 0x0
#define BV_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_OUT_YUV422_1P_EN__1 0x1
#define BP_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP      2
#define BM_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP 0x0000000C
#define BF_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP)
#define BV_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP__0 0x0
#define BV_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP__1 0x1
#define BV_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP__2 0x2
#define BV_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP__3 0x3
#define BP_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_RSVD2      0
#define BM_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_RSVD2 0x00000003
#define BF_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_RSVD2(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STORE_SHIFT_CTRL_CH0_RSVD2)

#define HW_PXP_WFE_A_STORE_SHIFT_CTRL_CH1	(0x00000f00)
#define HW_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_SET	(0x00000f04)
#define HW_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_CLR	(0x00000f08)
#define HW_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_TOG	(0x00000f0c)

#define BP_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_RSVD0      6
#define BM_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_RSVD0 0xFFFFFFC0
#define BF_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_RSVD0(v) \
        (((v) << 6) & BM_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_RSVD0)
#define BM_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_OUT_YUV422_2P_EN 0x00000020
#define BF_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_OUT_YUV422_2P_EN(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_OUT_YUV422_2P_EN)
#define BV_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_OUT_YUV422_2P_EN__0 0x0
#define BV_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_OUT_YUV422_2P_EN__1 0x1
#define BM_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_OUT_YUV422_1P_EN 0x00000010
#define BF_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_OUT_YUV422_1P_EN(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_OUT_YUV422_1P_EN)
#define BV_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_OUT_YUV422_1P_EN__0 0x0
#define BV_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_OUT_YUV422_1P_EN__1 0x1
#define BP_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP      2
#define BM_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP 0x0000000C
#define BF_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP)
#define BV_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP__0 0x0
#define BV_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP__1 0x1
#define BV_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP__2 0x2
#define BV_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP__3 0x3
#define BP_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_RSVD2      0
#define BM_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_RSVD2 0x00000003
#define BF_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_RSVD2(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STORE_SHIFT_CTRL_CH1_RSVD2)

#define HW_PXP_WFE_A_STORE_ADDR_0_CH0	(0x00000f50)

#define BP_PXP_WFE_A_STORE_ADDR_0_CH0_OUT_BASE_ADDR0      0
#define BM_PXP_WFE_A_STORE_ADDR_0_CH0_OUT_BASE_ADDR0 0xFFFFFFFF
#define BF_PXP_WFE_A_STORE_ADDR_0_CH0_OUT_BASE_ADDR0(v)   (v)

#define HW_PXP_WFE_A_STORE_ADDR_1_CH0	(0x00000f60)

#define BP_PXP_WFE_A_STORE_ADDR_1_CH0_OUT_BASE_ADDR1      0
#define BM_PXP_WFE_A_STORE_ADDR_1_CH0_OUT_BASE_ADDR1 0xFFFFFFFF
#define BF_PXP_WFE_A_STORE_ADDR_1_CH0_OUT_BASE_ADDR1(v)   (v)

#define HW_PXP_WFE_A_STORE_FILL_DATA_CH0	(0x00000f70)

#define BP_PXP_WFE_A_STORE_FILL_DATA_CH0_FILL_DATA_CH0      0
#define BM_PXP_WFE_A_STORE_FILL_DATA_CH0_FILL_DATA_CH0 0xFFFFFFFF
#define BF_PXP_WFE_A_STORE_FILL_DATA_CH0_FILL_DATA_CH0(v)   (v)

#define HW_PXP_WFE_A_STORE_ADDR_0_CH1	(0x00000f80)

#define BP_PXP_WFE_A_STORE_ADDR_0_CH1_OUT_BASE_ADDR0      0
#define BM_PXP_WFE_A_STORE_ADDR_0_CH1_OUT_BASE_ADDR0 0xFFFFFFFF
#define BF_PXP_WFE_A_STORE_ADDR_0_CH1_OUT_BASE_ADDR0(v)   (v)

#define HW_PXP_WFE_A_STORE_ADDR_1_CH1	(0x00000f90)

#define BP_PXP_WFE_A_STORE_ADDR_1_CH1_OUT_BASE_ADDR1      0
#define BM_PXP_WFE_A_STORE_ADDR_1_CH1_OUT_BASE_ADDR1 0xFFFFFFFF
#define BF_PXP_WFE_A_STORE_ADDR_1_CH1_OUT_BASE_ADDR1(v)   (v)

#define HW_PXP_WFE_A_STORE_D_MASK0_H_CH0	(0x00000fa0)

#define BP_PXP_WFE_A_STORE_D_MASK0_H_CH0_D_MASK0_H_CH0      0
#define BM_PXP_WFE_A_STORE_D_MASK0_H_CH0_D_MASK0_H_CH0 0xFFFFFFFF
#define BF_PXP_WFE_A_STORE_D_MASK0_H_CH0_D_MASK0_H_CH0(v)   (v)

#define HW_PXP_WFE_A_STORE_D_MASK0_L_CH0	(0x00000fb0)

#define BP_PXP_WFE_A_STORE_D_MASK0_L_CH0_D_MASK0_L_CH0      0
#define BM_PXP_WFE_A_STORE_D_MASK0_L_CH0_D_MASK0_L_CH0 0xFFFFFFFF
#define BF_PXP_WFE_A_STORE_D_MASK0_L_CH0_D_MASK0_L_CH0(v)   (v)

#define HW_PXP_WFE_A_STORE_D_MASK1_H_CH0	(0x00000fc0)

#define BP_PXP_WFE_A_STORE_D_MASK1_H_CH0_D_MASK1_H_CH0      0
#define BM_PXP_WFE_A_STORE_D_MASK1_H_CH0_D_MASK1_H_CH0 0xFFFFFFFF
#define BF_PXP_WFE_A_STORE_D_MASK1_H_CH0_D_MASK1_H_CH0(v)   (v)

#define HW_PXP_WFE_A_STORE_D_MASK1_L_CH0	(0x00000fd0)

#define BP_PXP_WFE_A_STORE_D_MASK1_L_CH0_D_MASK1_L_CH0      0
#define BM_PXP_WFE_A_STORE_D_MASK1_L_CH0_D_MASK1_L_CH0 0xFFFFFFFF
#define BF_PXP_WFE_A_STORE_D_MASK1_L_CH0_D_MASK1_L_CH0(v)   (v)

#define HW_PXP_WFE_A_STORE_D_MASK2_H_CH0	(0x00000fe0)

#define BP_PXP_WFE_A_STORE_D_MASK2_H_CH0_D_MASK2_H_CH0      0
#define BM_PXP_WFE_A_STORE_D_MASK2_H_CH0_D_MASK2_H_CH0 0xFFFFFFFF
#define BF_PXP_WFE_A_STORE_D_MASK2_H_CH0_D_MASK2_H_CH0(v)   (v)

#define HW_PXP_WFE_A_STORE_D_MASK2_L_CH0	(0x00000ff0)

#define BP_PXP_WFE_A_STORE_D_MASK2_L_CH0_D_MASK2_L_CH0      0
#define BM_PXP_WFE_A_STORE_D_MASK2_L_CH0_D_MASK2_L_CH0 0xFFFFFFFF
#define BF_PXP_WFE_A_STORE_D_MASK2_L_CH0_D_MASK2_L_CH0(v)   (v)

#define HW_PXP_WFE_A_STORE_D_MASK3_H_CH0	(0x00001000)

#define BP_PXP_WFE_A_STORE_D_MASK3_H_CH0_D_MASK3_H_CH0      0
#define BM_PXP_WFE_A_STORE_D_MASK3_H_CH0_D_MASK3_H_CH0 0xFFFFFFFF
#define BF_PXP_WFE_A_STORE_D_MASK3_H_CH0_D_MASK3_H_CH0(v)   (v)

#define HW_PXP_WFE_A_STORE_D_MASK3_L_CH0	(0x00001010)

#define BP_PXP_WFE_A_STORE_D_MASK3_L_CH0_D_MASK3_L_CH0      0
#define BM_PXP_WFE_A_STORE_D_MASK3_L_CH0_D_MASK3_L_CH0 0xFFFFFFFF
#define BF_PXP_WFE_A_STORE_D_MASK3_L_CH0_D_MASK3_L_CH0(v)   (v)

#define HW_PXP_WFE_A_STORE_D_MASK4_H_CH0	(0x00001020)

#define BP_PXP_WFE_A_STORE_D_MASK4_H_CH0_D_MASK4_H_CH0      0
#define BM_PXP_WFE_A_STORE_D_MASK4_H_CH0_D_MASK4_H_CH0 0xFFFFFFFF
#define BF_PXP_WFE_A_STORE_D_MASK4_H_CH0_D_MASK4_H_CH0(v)   (v)

#define HW_PXP_WFE_A_STORE_D_MASK4_L_CH0	(0x00001030)

#define BP_PXP_WFE_A_STORE_D_MASK4_L_CH0_D_MASK4_L_CH0      0
#define BM_PXP_WFE_A_STORE_D_MASK4_L_CH0_D_MASK4_L_CH0 0xFFFFFFFF
#define BF_PXP_WFE_A_STORE_D_MASK4_L_CH0_D_MASK4_L_CH0(v)   (v)

#define HW_PXP_WFE_A_STORE_D_MASK5_H_CH0	(0x00001040)

#define BP_PXP_WFE_A_STORE_D_MASK5_H_CH0_D_MASK5_H_CH0      0
#define BM_PXP_WFE_A_STORE_D_MASK5_H_CH0_D_MASK5_H_CH0 0xFFFFFFFF
#define BF_PXP_WFE_A_STORE_D_MASK5_H_CH0_D_MASK5_H_CH0(v)   (v)

#define HW_PXP_WFE_A_STORE_D_MASK5_L_CH0	(0x00001050)

#define BP_PXP_WFE_A_STORE_D_MASK5_L_CH0_D_MASK5_L_CH0      0
#define BM_PXP_WFE_A_STORE_D_MASK5_L_CH0_D_MASK5_L_CH0 0xFFFFFFFF
#define BF_PXP_WFE_A_STORE_D_MASK5_L_CH0_D_MASK5_L_CH0(v)   (v)

#define HW_PXP_WFE_A_STORE_D_MASK6_H_CH0	(0x00001060)

#define BP_PXP_WFE_A_STORE_D_MASK6_H_CH0_D_MASK6_H_CH0      0
#define BM_PXP_WFE_A_STORE_D_MASK6_H_CH0_D_MASK6_H_CH0 0xFFFFFFFF
#define BF_PXP_WFE_A_STORE_D_MASK6_H_CH0_D_MASK6_H_CH0(v)   (v)

#define HW_PXP_WFE_A_STORE_D_MASK6_L_CH0	(0x00001070)

#define BP_PXP_WFE_A_STORE_D_MASK6_L_CH0_D_MASK6_L_CH0      0
#define BM_PXP_WFE_A_STORE_D_MASK6_L_CH0_D_MASK6_L_CH0 0xFFFFFFFF
#define BF_PXP_WFE_A_STORE_D_MASK6_L_CH0_D_MASK6_L_CH0(v)   (v)

#define HW_PXP_WFE_A_STORE_D_MASK7_H_CH0	(0x00001080)

#define BP_PXP_WFE_A_STORE_D_MASK7_H_CH0_D_MASK7_H_CH0      0
#define BM_PXP_WFE_A_STORE_D_MASK7_H_CH0_D_MASK7_H_CH0 0xFFFFFFFF
#define BF_PXP_WFE_A_STORE_D_MASK7_H_CH0_D_MASK7_H_CH0(v)   (v)

#define HW_PXP_WFE_A_STORE_D_MASK7_L_CH0	(0x00001090)

#define BP_PXP_WFE_A_STORE_D_MASK7_L_CH0_D_MASK7_L_CH0      0
#define BM_PXP_WFE_A_STORE_D_MASK7_L_CH0_D_MASK7_L_CH0 0xFFFFFFFF
#define BF_PXP_WFE_A_STORE_D_MASK7_L_CH0_D_MASK7_L_CH0(v)   (v)

#define HW_PXP_WFE_A_STORE_D_SHIFT_L_CH0	(0x000010a0)

#define BM_PXP_WFE_A_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG3 0x80000000
#define BF_PXP_WFE_A_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG3(v) \
        (((v) << 31) & BM_PXP_WFE_A_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG3)
#define BM_PXP_WFE_A_STORE_D_SHIFT_L_CH0_RSVD0 0x40000000
#define BF_PXP_WFE_A_STORE_D_SHIFT_L_CH0_RSVD0(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STORE_D_SHIFT_L_CH0_RSVD0)
#define BP_PXP_WFE_A_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH3      24
#define BM_PXP_WFE_A_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH3 0x3F000000
#define BF_PXP_WFE_A_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH3(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH3)
#define BM_PXP_WFE_A_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG2 0x00800000
#define BF_PXP_WFE_A_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG2(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG2)
#define BM_PXP_WFE_A_STORE_D_SHIFT_L_CH0_RSVD1 0x00400000
#define BF_PXP_WFE_A_STORE_D_SHIFT_L_CH0_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STORE_D_SHIFT_L_CH0_RSVD1)
#define BP_PXP_WFE_A_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH2      16
#define BM_PXP_WFE_A_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH2 0x003F0000
#define BF_PXP_WFE_A_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH2(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH2)
#define BM_PXP_WFE_A_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG1 0x00008000
#define BF_PXP_WFE_A_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG1(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG1)
#define BM_PXP_WFE_A_STORE_D_SHIFT_L_CH0_RSVD2 0x00004000
#define BF_PXP_WFE_A_STORE_D_SHIFT_L_CH0_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STORE_D_SHIFT_L_CH0_RSVD2)
#define BP_PXP_WFE_A_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH1      8
#define BM_PXP_WFE_A_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH1 0x00003F00
#define BF_PXP_WFE_A_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH1(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH1)
#define BM_PXP_WFE_A_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG0 0x00000080
#define BF_PXP_WFE_A_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG0(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG0)
#define BM_PXP_WFE_A_STORE_D_SHIFT_L_CH0_RSVD3 0x00000040
#define BF_PXP_WFE_A_STORE_D_SHIFT_L_CH0_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STORE_D_SHIFT_L_CH0_RSVD3)
#define BP_PXP_WFE_A_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH0      0
#define BM_PXP_WFE_A_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH0 0x0000003F
#define BF_PXP_WFE_A_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH0(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH0)

#define HW_PXP_WFE_A_STORE_D_SHIFT_H_CH0	(0x000010b0)

#define BM_PXP_WFE_A_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG7 0x80000000
#define BF_PXP_WFE_A_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG7(v) \
        (((v) << 31) & BM_PXP_WFE_A_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG7)
#define BM_PXP_WFE_A_STORE_D_SHIFT_H_CH0_RSVD0 0x40000000
#define BF_PXP_WFE_A_STORE_D_SHIFT_H_CH0_RSVD0(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STORE_D_SHIFT_H_CH0_RSVD0)
#define BP_PXP_WFE_A_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH7      24
#define BM_PXP_WFE_A_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH7 0x3F000000
#define BF_PXP_WFE_A_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH7(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH7)
#define BM_PXP_WFE_A_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG6 0x00800000
#define BF_PXP_WFE_A_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG6(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG6)
#define BM_PXP_WFE_A_STORE_D_SHIFT_H_CH0_RSVD1 0x00400000
#define BF_PXP_WFE_A_STORE_D_SHIFT_H_CH0_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STORE_D_SHIFT_H_CH0_RSVD1)
#define BP_PXP_WFE_A_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH6      16
#define BM_PXP_WFE_A_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH6 0x003F0000
#define BF_PXP_WFE_A_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH6(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH6)
#define BM_PXP_WFE_A_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG5 0x00008000
#define BF_PXP_WFE_A_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG5(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG5)
#define BM_PXP_WFE_A_STORE_D_SHIFT_H_CH0_RSVD2 0x00004000
#define BF_PXP_WFE_A_STORE_D_SHIFT_H_CH0_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STORE_D_SHIFT_H_CH0_RSVD2)
#define BP_PXP_WFE_A_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH5      8
#define BM_PXP_WFE_A_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH5 0x00003F00
#define BF_PXP_WFE_A_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH5(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH5)
#define BM_PXP_WFE_A_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG4 0x00000080
#define BF_PXP_WFE_A_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG4(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG4)
#define BM_PXP_WFE_A_STORE_D_SHIFT_H_CH0_RSVD3 0x00000040
#define BF_PXP_WFE_A_STORE_D_SHIFT_H_CH0_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STORE_D_SHIFT_H_CH0_RSVD3)
#define BP_PXP_WFE_A_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH4      0
#define BM_PXP_WFE_A_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH4 0x0000003F
#define BF_PXP_WFE_A_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH4(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH4)

#define HW_PXP_WFE_A_STORE_F_SHIFT_L_CH0	(0x000010c0)

#define BM_PXP_WFE_A_STORE_F_SHIFT_L_CH0_RSVD0 0x80000000
#define BF_PXP_WFE_A_STORE_F_SHIFT_L_CH0_RSVD0(v) \
        (((v) << 31) & BM_PXP_WFE_A_STORE_F_SHIFT_L_CH0_RSVD0)
#define BM_PXP_WFE_A_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG3 0x40000000
#define BF_PXP_WFE_A_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG3(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG3)
#define BP_PXP_WFE_A_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH3      24
#define BM_PXP_WFE_A_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH3 0x3F000000
#define BF_PXP_WFE_A_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH3(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH3)
#define BM_PXP_WFE_A_STORE_F_SHIFT_L_CH0_RSVD1 0x00800000
#define BF_PXP_WFE_A_STORE_F_SHIFT_L_CH0_RSVD1(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STORE_F_SHIFT_L_CH0_RSVD1)
#define BM_PXP_WFE_A_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG2 0x00400000
#define BF_PXP_WFE_A_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG2(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG2)
#define BP_PXP_WFE_A_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH2      16
#define BM_PXP_WFE_A_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH2 0x003F0000
#define BF_PXP_WFE_A_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH2(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH2)
#define BM_PXP_WFE_A_STORE_F_SHIFT_L_CH0_RSVD2 0x00008000
#define BF_PXP_WFE_A_STORE_F_SHIFT_L_CH0_RSVD2(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STORE_F_SHIFT_L_CH0_RSVD2)
#define BM_PXP_WFE_A_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG1 0x00004000
#define BF_PXP_WFE_A_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG1(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG1)
#define BP_PXP_WFE_A_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH1      8
#define BM_PXP_WFE_A_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH1 0x00003F00
#define BF_PXP_WFE_A_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH1(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH1)
#define BM_PXP_WFE_A_STORE_F_SHIFT_L_CH0_RSVD3 0x00000080
#define BF_PXP_WFE_A_STORE_F_SHIFT_L_CH0_RSVD3(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STORE_F_SHIFT_L_CH0_RSVD3)
#define BM_PXP_WFE_A_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG0 0x00000040
#define BF_PXP_WFE_A_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG0(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG0)
#define BP_PXP_WFE_A_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH0      0
#define BM_PXP_WFE_A_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH0 0x0000003F
#define BF_PXP_WFE_A_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH0(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH0)

#define HW_PXP_WFE_A_STORE_F_SHIFT_H_CH0	(0x000010d0)

#define BM_PXP_WFE_A_STORE_F_SHIFT_H_CH0_RSVD0 0x80000000
#define BF_PXP_WFE_A_STORE_F_SHIFT_H_CH0_RSVD0(v) \
        (((v) << 31) & BM_PXP_WFE_A_STORE_F_SHIFT_H_CH0_RSVD0)
#define BM_PXP_WFE_A_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG7 0x40000000
#define BF_PXP_WFE_A_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG7(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG7)
#define BP_PXP_WFE_A_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH7      24
#define BM_PXP_WFE_A_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH7 0x3F000000
#define BF_PXP_WFE_A_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH7(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH7)
#define BM_PXP_WFE_A_STORE_F_SHIFT_H_CH0_RSVD1 0x00800000
#define BF_PXP_WFE_A_STORE_F_SHIFT_H_CH0_RSVD1(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STORE_F_SHIFT_H_CH0_RSVD1)
#define BM_PXP_WFE_A_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG6 0x00400000
#define BF_PXP_WFE_A_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG6(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG6)
#define BP_PXP_WFE_A_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH6      16
#define BM_PXP_WFE_A_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH6 0x003F0000
#define BF_PXP_WFE_A_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH6(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH6)
#define BM_PXP_WFE_A_STORE_F_SHIFT_H_CH0_RSVD2 0x00008000
#define BF_PXP_WFE_A_STORE_F_SHIFT_H_CH0_RSVD2(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STORE_F_SHIFT_H_CH0_RSVD2)
#define BM_PXP_WFE_A_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG5 0x00004000
#define BF_PXP_WFE_A_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG5(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG5)
#define BP_PXP_WFE_A_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH5      8
#define BM_PXP_WFE_A_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH5 0x00003F00
#define BF_PXP_WFE_A_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH5(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH5)
#define BM_PXP_WFE_A_STORE_F_SHIFT_H_CH0_RSVD3 0x00000080
#define BF_PXP_WFE_A_STORE_F_SHIFT_H_CH0_RSVD3(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STORE_F_SHIFT_H_CH0_RSVD3)
#define BM_PXP_WFE_A_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG4 0x00000040
#define BF_PXP_WFE_A_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG4(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG4)
#define BP_PXP_WFE_A_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH4      0
#define BM_PXP_WFE_A_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH4 0x0000003F
#define BF_PXP_WFE_A_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH4(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH4)

#define HW_PXP_WFE_A_STORE_F_MASK_L_CH0	(0x000010e0)

#define BP_PXP_WFE_A_STORE_F_MASK_L_CH0_F_MASK3      24
#define BM_PXP_WFE_A_STORE_F_MASK_L_CH0_F_MASK3 0xFF000000
#define BF_PXP_WFE_A_STORE_F_MASK_L_CH0_F_MASK3(v) \
        (((v) << 24) & BM_PXP_WFE_A_STORE_F_MASK_L_CH0_F_MASK3)
#define BP_PXP_WFE_A_STORE_F_MASK_L_CH0_F_MASK2      16
#define BM_PXP_WFE_A_STORE_F_MASK_L_CH0_F_MASK2 0x00FF0000
#define BF_PXP_WFE_A_STORE_F_MASK_L_CH0_F_MASK2(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STORE_F_MASK_L_CH0_F_MASK2)
#define BP_PXP_WFE_A_STORE_F_MASK_L_CH0_F_MASK1      8
#define BM_PXP_WFE_A_STORE_F_MASK_L_CH0_F_MASK1 0x0000FF00
#define BF_PXP_WFE_A_STORE_F_MASK_L_CH0_F_MASK1(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STORE_F_MASK_L_CH0_F_MASK1)
#define BP_PXP_WFE_A_STORE_F_MASK_L_CH0_F_MASK0      0
#define BM_PXP_WFE_A_STORE_F_MASK_L_CH0_F_MASK0 0x000000FF
#define BF_PXP_WFE_A_STORE_F_MASK_L_CH0_F_MASK0(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STORE_F_MASK_L_CH0_F_MASK0)

#define HW_PXP_WFE_A_STORE_F_MASK_H_CH0	(0x000010f0)

#define BP_PXP_WFE_A_STORE_F_MASK_H_CH0_F_MASK7      24
#define BM_PXP_WFE_A_STORE_F_MASK_H_CH0_F_MASK7 0xFF000000
#define BF_PXP_WFE_A_STORE_F_MASK_H_CH0_F_MASK7(v) \
        (((v) << 24) & BM_PXP_WFE_A_STORE_F_MASK_H_CH0_F_MASK7)
#define BP_PXP_WFE_A_STORE_F_MASK_H_CH0_F_MASK6      16
#define BM_PXP_WFE_A_STORE_F_MASK_H_CH0_F_MASK6 0x00FF0000
#define BF_PXP_WFE_A_STORE_F_MASK_H_CH0_F_MASK6(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STORE_F_MASK_H_CH0_F_MASK6)
#define BP_PXP_WFE_A_STORE_F_MASK_H_CH0_F_MASK5      8
#define BM_PXP_WFE_A_STORE_F_MASK_H_CH0_F_MASK5 0x0000FF00
#define BF_PXP_WFE_A_STORE_F_MASK_H_CH0_F_MASK5(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STORE_F_MASK_H_CH0_F_MASK5)
#define BP_PXP_WFE_A_STORE_F_MASK_H_CH0_F_MASK4      0
#define BM_PXP_WFE_A_STORE_F_MASK_H_CH0_F_MASK4 0x000000FF
#define BF_PXP_WFE_A_STORE_F_MASK_H_CH0_F_MASK4(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STORE_F_MASK_H_CH0_F_MASK4)

#define HW_PXP_WFB_FETCH_CTRL	(0x00001100)
#define HW_PXP_WFB_FETCH_CTRL_SET	(0x00001104)
#define HW_PXP_WFB_FETCH_CTRL_CLR	(0x00001108)
#define HW_PXP_WFB_FETCH_CTRL_TOG	(0x0000110c)

#define BM_PXP_WFB_FETCH_CTRL_BUF2_DONE_IRQ_EN 0x80000000
#define BF_PXP_WFB_FETCH_CTRL_BUF2_DONE_IRQ_EN(v) \
        (((v) << 31) & BM_PXP_WFB_FETCH_CTRL_BUF2_DONE_IRQ_EN)
#define BM_PXP_WFB_FETCH_CTRL_BUF1_DONE_IRQ_EN 0x40000000
#define BF_PXP_WFB_FETCH_CTRL_BUF1_DONE_IRQ_EN(v)  \
        (((v) << 30) & BM_PXP_WFB_FETCH_CTRL_BUF1_DONE_IRQ_EN)
#define BM_PXP_WFB_FETCH_CTRL_BUF2_DONE_IRQ 0x20000000
#define BF_PXP_WFB_FETCH_CTRL_BUF2_DONE_IRQ(v)  \
        (((v) << 29) & BM_PXP_WFB_FETCH_CTRL_BUF2_DONE_IRQ)
#define BM_PXP_WFB_FETCH_CTRL_BUF1_DONE_IRQ 0x10000000
#define BF_PXP_WFB_FETCH_CTRL_BUF1_DONE_IRQ(v)  \
        (((v) << 28) & BM_PXP_WFB_FETCH_CTRL_BUF1_DONE_IRQ)
#define BP_PXP_WFB_FETCH_CTRL_RSVD0      24
#define BM_PXP_WFB_FETCH_CTRL_RSVD0 0x0F000000
#define BF_PXP_WFB_FETCH_CTRL_RSVD0(v)  \
        (((v) << 24) & BM_PXP_WFB_FETCH_CTRL_RSVD0)
#define BP_PXP_WFB_FETCH_CTRL_BF2_LINE_MODE      22
#define BM_PXP_WFB_FETCH_CTRL_BF2_LINE_MODE 0x00C00000
#define BF_PXP_WFB_FETCH_CTRL_BF2_LINE_MODE(v)  \
        (((v) << 22) & BM_PXP_WFB_FETCH_CTRL_BF2_LINE_MODE)
#define BV_PXP_WFB_FETCH_CTRL_BF2_LINE_MODE__0 0x0
#define BV_PXP_WFB_FETCH_CTRL_BF2_LINE_MODE__1 0x1
#define BV_PXP_WFB_FETCH_CTRL_BF2_LINE_MODE__2 0x2
#define BV_PXP_WFB_FETCH_CTRL_BF2_LINE_MODE__3 0x3
#define BP_PXP_WFB_FETCH_CTRL_BF2_BYTES_PP      20
#define BM_PXP_WFB_FETCH_CTRL_BF2_BYTES_PP 0x00300000
#define BF_PXP_WFB_FETCH_CTRL_BF2_BYTES_PP(v)  \
        (((v) << 20) & BM_PXP_WFB_FETCH_CTRL_BF2_BYTES_PP)
#define BP_PXP_WFB_FETCH_CTRL_BF1_LINE_MODE      18
#define BM_PXP_WFB_FETCH_CTRL_BF1_LINE_MODE 0x000C0000
#define BF_PXP_WFB_FETCH_CTRL_BF1_LINE_MODE(v)  \
        (((v) << 18) & BM_PXP_WFB_FETCH_CTRL_BF1_LINE_MODE)
#define BV_PXP_WFB_FETCH_CTRL_BF1_LINE_MODE__0 0x0
#define BV_PXP_WFB_FETCH_CTRL_BF1_LINE_MODE__1 0x1
#define BV_PXP_WFB_FETCH_CTRL_BF1_LINE_MODE__2 0x2
#define BV_PXP_WFB_FETCH_CTRL_BF1_LINE_MODE__3 0x3
#define BP_PXP_WFB_FETCH_CTRL_BF1_BYTES_PP      16
#define BM_PXP_WFB_FETCH_CTRL_BF1_BYTES_PP 0x00030000
#define BF_PXP_WFB_FETCH_CTRL_BF1_BYTES_PP(v)  \
        (((v) << 16) & BM_PXP_WFB_FETCH_CTRL_BF1_BYTES_PP)
#define BP_PXP_WFB_FETCH_CTRL_RSVD1      14
#define BM_PXP_WFB_FETCH_CTRL_RSVD1 0x0000C000
#define BF_PXP_WFB_FETCH_CTRL_RSVD1(v)  \
        (((v) << 14) & BM_PXP_WFB_FETCH_CTRL_RSVD1)
#define BM_PXP_WFB_FETCH_CTRL_BF2_BORDER_MODE 0x00002000
#define BF_PXP_WFB_FETCH_CTRL_BF2_BORDER_MODE(v)  \
        (((v) << 13) & BM_PXP_WFB_FETCH_CTRL_BF2_BORDER_MODE)
#define BV_PXP_WFB_FETCH_CTRL_BF2_BORDER_MODE__0 0x0
#define BV_PXP_WFB_FETCH_CTRL_BF2_BORDER_MODE__1 0x1
#define BM_PXP_WFB_FETCH_CTRL_BF2_BURST_LEN 0x00001000
#define BF_PXP_WFB_FETCH_CTRL_BF2_BURST_LEN(v)  \
        (((v) << 12) & BM_PXP_WFB_FETCH_CTRL_BF2_BURST_LEN)
#define BV_PXP_WFB_FETCH_CTRL_BF2_BURST_LEN__0 0x0
#define BV_PXP_WFB_FETCH_CTRL_BF2_BURST_LEN__1 0x1
#define BM_PXP_WFB_FETCH_CTRL_BF2_BYPASS_MODE 0x00000800
#define BF_PXP_WFB_FETCH_CTRL_BF2_BYPASS_MODE(v)  \
        (((v) << 11) & BM_PXP_WFB_FETCH_CTRL_BF2_BYPASS_MODE)
#define BV_PXP_WFB_FETCH_CTRL_BF2_BYPASS_MODE__0 0x0
#define BV_PXP_WFB_FETCH_CTRL_BF2_BYPASS_MODE__1 0x1
#define BM_PXP_WFB_FETCH_CTRL_BF2_HSK_MODE 0x00000400
#define BF_PXP_WFB_FETCH_CTRL_BF2_HSK_MODE(v)  \
        (((v) << 10) & BM_PXP_WFB_FETCH_CTRL_BF2_HSK_MODE)
#define BV_PXP_WFB_FETCH_CTRL_BF2_HSK_MODE__0 0x0
#define BV_PXP_WFB_FETCH_CTRL_BF2_HSK_MODE__1 0x1
#define BM_PXP_WFB_FETCH_CTRL_BF2_SRAM_IF 0x00000200
#define BF_PXP_WFB_FETCH_CTRL_BF2_SRAM_IF(v)  \
        (((v) << 9) & BM_PXP_WFB_FETCH_CTRL_BF2_SRAM_IF)
#define BV_PXP_WFB_FETCH_CTRL_BF2_SRAM_IF__0 0x0
#define BV_PXP_WFB_FETCH_CTRL_BF2_SRAM_IF__1 0x1
#define BM_PXP_WFB_FETCH_CTRL_BF2_EN 0x00000100
#define BF_PXP_WFB_FETCH_CTRL_BF2_EN(v)  \
        (((v) << 8) & BM_PXP_WFB_FETCH_CTRL_BF2_EN)
#define BV_PXP_WFB_FETCH_CTRL_BF2_EN__0 0x0
#define BV_PXP_WFB_FETCH_CTRL_BF2_EN__1 0x1
#define BP_PXP_WFB_FETCH_CTRL_RSVD2      6
#define BM_PXP_WFB_FETCH_CTRL_RSVD2 0x000000C0
#define BF_PXP_WFB_FETCH_CTRL_RSVD2(v)  \
        (((v) << 6) & BM_PXP_WFB_FETCH_CTRL_RSVD2)
#define BM_PXP_WFB_FETCH_CTRL_BF1_BORDER_MODE 0x00000020
#define BF_PXP_WFB_FETCH_CTRL_BF1_BORDER_MODE(v)  \
        (((v) << 5) & BM_PXP_WFB_FETCH_CTRL_BF1_BORDER_MODE)
#define BV_PXP_WFB_FETCH_CTRL_BF1_BORDER_MODE__0 0x0
#define BV_PXP_WFB_FETCH_CTRL_BF1_BORDER_MODE__1 0x1
#define BM_PXP_WFB_FETCH_CTRL_BF1_BURST_LEN 0x00000010
#define BF_PXP_WFB_FETCH_CTRL_BF1_BURST_LEN(v)  \
        (((v) << 4) & BM_PXP_WFB_FETCH_CTRL_BF1_BURST_LEN)
#define BV_PXP_WFB_FETCH_CTRL_BF1_BURST_LEN__0 0x0
#define BV_PXP_WFB_FETCH_CTRL_BF1_BURST_LEN__1 0x1
#define BM_PXP_WFB_FETCH_CTRL_BF1_BYPASS_MODE 0x00000008
#define BF_PXP_WFB_FETCH_CTRL_BF1_BYPASS_MODE(v)  \
        (((v) << 3) & BM_PXP_WFB_FETCH_CTRL_BF1_BYPASS_MODE)
#define BV_PXP_WFB_FETCH_CTRL_BF1_BYPASS_MODE__0 0x0
#define BV_PXP_WFB_FETCH_CTRL_BF1_BYPASS_MODE__1 0x1
#define BM_PXP_WFB_FETCH_CTRL_BF1_HSK_MODE 0x00000004
#define BF_PXP_WFB_FETCH_CTRL_BF1_HSK_MODE(v)  \
        (((v) << 2) & BM_PXP_WFB_FETCH_CTRL_BF1_HSK_MODE)
#define BV_PXP_WFB_FETCH_CTRL_BF1_HSK_MODE__0 0x0
#define BV_PXP_WFB_FETCH_CTRL_BF1_HSK_MODE__1 0x1
#define BM_PXP_WFB_FETCH_CTRL_BF1_SRAM_IF 0x00000002
#define BF_PXP_WFB_FETCH_CTRL_BF1_SRAM_IF(v)  \
        (((v) << 1) & BM_PXP_WFB_FETCH_CTRL_BF1_SRAM_IF)
#define BV_PXP_WFB_FETCH_CTRL_BF1_SRAM_IF__0 0x0
#define BV_PXP_WFB_FETCH_CTRL_BF1_SRAM_IF__1 0x1
#define BM_PXP_WFB_FETCH_CTRL_BF1_EN 0x00000001
#define BF_PXP_WFB_FETCH_CTRL_BF1_EN(v)  \
        (((v) << 0) & BM_PXP_WFB_FETCH_CTRL_BF1_EN)
#define BV_PXP_WFB_FETCH_CTRL_BF1_EN__0 0x0
#define BV_PXP_WFB_FETCH_CTRL_BF1_EN__1 0x1

#define HW_PXP_WFB_FETCH_BUF1_ADDR	(0x00001110)

#define BP_PXP_WFB_FETCH_BUF1_ADDR_BUF_ADDR      0
#define BM_PXP_WFB_FETCH_BUF1_ADDR_BUF_ADDR 0xFFFFFFFF
#define BF_PXP_WFB_FETCH_BUF1_ADDR_BUF_ADDR(v)   (v)

#define HW_PXP_WFB_FETCH_BUF1_PITCH	(0x00001120)

#define BP_PXP_WFB_FETCH_BUF1_PITCH_RSVD      16
#define BM_PXP_WFB_FETCH_BUF1_PITCH_RSVD 0xFFFF0000
#define BF_PXP_WFB_FETCH_BUF1_PITCH_RSVD(v) \
        (((v) << 16) & BM_PXP_WFB_FETCH_BUF1_PITCH_RSVD)
#define BP_PXP_WFB_FETCH_BUF1_PITCH_PITCH      0
#define BM_PXP_WFB_FETCH_BUF1_PITCH_PITCH 0x0000FFFF
#define BF_PXP_WFB_FETCH_BUF1_PITCH_PITCH(v)  \
        (((v) << 0) & BM_PXP_WFB_FETCH_BUF1_PITCH_PITCH)

#define HW_PXP_WFB_FETCH_BUF1_SIZE	(0x00001130)

#define BP_PXP_WFB_FETCH_BUF1_SIZE_BUF_HEIGHT      16
#define BM_PXP_WFB_FETCH_BUF1_SIZE_BUF_HEIGHT 0xFFFF0000
#define BF_PXP_WFB_FETCH_BUF1_SIZE_BUF_HEIGHT(v) \
        (((v) << 16) & BM_PXP_WFB_FETCH_BUF1_SIZE_BUF_HEIGHT)
#define BP_PXP_WFB_FETCH_BUF1_SIZE_BUF_WIDTH      0
#define BM_PXP_WFB_FETCH_BUF1_SIZE_BUF_WIDTH 0x0000FFFF
#define BF_PXP_WFB_FETCH_BUF1_SIZE_BUF_WIDTH(v)  \
        (((v) << 0) & BM_PXP_WFB_FETCH_BUF1_SIZE_BUF_WIDTH)

#define HW_PXP_WFB_FETCH_BUF2_ADDR	(0x00001140)

#define BP_PXP_WFB_FETCH_BUF2_ADDR_BUF_ADDR      0
#define BM_PXP_WFB_FETCH_BUF2_ADDR_BUF_ADDR 0xFFFFFFFF
#define BF_PXP_WFB_FETCH_BUF2_ADDR_BUF_ADDR(v)   (v)

#define HW_PXP_WFB_FETCH_BUF2_PITCH	(0x00001150)

#define BP_PXP_WFB_FETCH_BUF2_PITCH_RSVD      16
#define BM_PXP_WFB_FETCH_BUF2_PITCH_RSVD 0xFFFF0000
#define BF_PXP_WFB_FETCH_BUF2_PITCH_RSVD(v) \
        (((v) << 16) & BM_PXP_WFB_FETCH_BUF2_PITCH_RSVD)
#define BP_PXP_WFB_FETCH_BUF2_PITCH_PITCH      0
#define BM_PXP_WFB_FETCH_BUF2_PITCH_PITCH 0x0000FFFF
#define BF_PXP_WFB_FETCH_BUF2_PITCH_PITCH(v)  \
        (((v) << 0) & BM_PXP_WFB_FETCH_BUF2_PITCH_PITCH)

#define HW_PXP_WFB_FETCH_BUF2_SIZE	(0x00001160)

#define BP_PXP_WFB_FETCH_BUF2_SIZE_BUF_HEIGHT      16
#define BM_PXP_WFB_FETCH_BUF2_SIZE_BUF_HEIGHT 0xFFFF0000
#define BF_PXP_WFB_FETCH_BUF2_SIZE_BUF_HEIGHT(v) \
        (((v) << 16) & BM_PXP_WFB_FETCH_BUF2_SIZE_BUF_HEIGHT)
#define BP_PXP_WFB_FETCH_BUF2_SIZE_BUF_WIDTH      0
#define BM_PXP_WFB_FETCH_BUF2_SIZE_BUF_WIDTH 0x0000FFFF
#define BF_PXP_WFB_FETCH_BUF2_SIZE_BUF_WIDTH(v)  \
        (((v) << 0) & BM_PXP_WFB_FETCH_BUF2_SIZE_BUF_WIDTH)

#define HW_PXP_WFB_ARRAY_PIXEL0_MASK	(0x00001170)

#define BP_PXP_WFB_ARRAY_PIXEL0_MASK_RSVD0      30
#define BM_PXP_WFB_ARRAY_PIXEL0_MASK_RSVD0 0xC0000000
#define BF_PXP_WFB_ARRAY_PIXEL0_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFB_ARRAY_PIXEL0_MASK_RSVD0)
#define BP_PXP_WFB_ARRAY_PIXEL0_MASK_BUF_SEL      28
#define BM_PXP_WFB_ARRAY_PIXEL0_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFB_ARRAY_PIXEL0_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFB_ARRAY_PIXEL0_MASK_BUF_SEL)
#define BV_PXP_WFB_ARRAY_PIXEL0_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFB_ARRAY_PIXEL0_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFB_ARRAY_PIXEL0_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFB_ARRAY_PIXEL0_MASK_RSVD1      26
#define BM_PXP_WFB_ARRAY_PIXEL0_MASK_RSVD1 0x0C000000
#define BF_PXP_WFB_ARRAY_PIXEL0_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFB_ARRAY_PIXEL0_MASK_RSVD1)
#define BM_PXP_WFB_ARRAY_PIXEL0_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFB_ARRAY_PIXEL0_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFB_ARRAY_PIXEL0_MASK_SIGN_Y)
#define BV_PXP_WFB_ARRAY_PIXEL0_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFB_ARRAY_PIXEL0_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFB_ARRAY_PIXEL0_MASK_SIGN_X 0x01000000
#define BF_PXP_WFB_ARRAY_PIXEL0_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFB_ARRAY_PIXEL0_MASK_SIGN_X)
#define BV_PXP_WFB_ARRAY_PIXEL0_MASK_SIGN_X__0 0x0
#define BV_PXP_WFB_ARRAY_PIXEL0_MASK_SIGN_X__1 0x1
#define BP_PXP_WFB_ARRAY_PIXEL0_MASK_RSVD2      22
#define BM_PXP_WFB_ARRAY_PIXEL0_MASK_RSVD2 0x00C00000
#define BF_PXP_WFB_ARRAY_PIXEL0_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFB_ARRAY_PIXEL0_MASK_RSVD2)
#define BP_PXP_WFB_ARRAY_PIXEL0_MASK_OFFSET_Y      20
#define BM_PXP_WFB_ARRAY_PIXEL0_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFB_ARRAY_PIXEL0_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFB_ARRAY_PIXEL0_MASK_OFFSET_Y)
#define BP_PXP_WFB_ARRAY_PIXEL0_MASK_RSVD3      18
#define BM_PXP_WFB_ARRAY_PIXEL0_MASK_RSVD3 0x000C0000
#define BF_PXP_WFB_ARRAY_PIXEL0_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFB_ARRAY_PIXEL0_MASK_RSVD3)
#define BP_PXP_WFB_ARRAY_PIXEL0_MASK_OFFSET_X      16
#define BM_PXP_WFB_ARRAY_PIXEL0_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFB_ARRAY_PIXEL0_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFB_ARRAY_PIXEL0_MASK_OFFSET_X)
#define BP_PXP_WFB_ARRAY_PIXEL0_MASK_RSVD4      13
#define BM_PXP_WFB_ARRAY_PIXEL0_MASK_RSVD4 0x0000E000
#define BF_PXP_WFB_ARRAY_PIXEL0_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFB_ARRAY_PIXEL0_MASK_RSVD4)
#define BP_PXP_WFB_ARRAY_PIXEL0_MASK_H_OFS      8
#define BM_PXP_WFB_ARRAY_PIXEL0_MASK_H_OFS 0x00001F00
#define BF_PXP_WFB_ARRAY_PIXEL0_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFB_ARRAY_PIXEL0_MASK_H_OFS)
#define BP_PXP_WFB_ARRAY_PIXEL0_MASK_RSVD5      5
#define BM_PXP_WFB_ARRAY_PIXEL0_MASK_RSVD5 0x000000E0
#define BF_PXP_WFB_ARRAY_PIXEL0_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFB_ARRAY_PIXEL0_MASK_RSVD5)
#define BP_PXP_WFB_ARRAY_PIXEL0_MASK_L_OFS      0
#define BM_PXP_WFB_ARRAY_PIXEL0_MASK_L_OFS 0x0000001F
#define BF_PXP_WFB_ARRAY_PIXEL0_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFB_ARRAY_PIXEL0_MASK_L_OFS)

#define HW_PXP_WFB_ARRAY_PIXEL1_MASK	(0x00001180)

#define BP_PXP_WFB_ARRAY_PIXEL1_MASK_RSVD0      30
#define BM_PXP_WFB_ARRAY_PIXEL1_MASK_RSVD0 0xC0000000
#define BF_PXP_WFB_ARRAY_PIXEL1_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFB_ARRAY_PIXEL1_MASK_RSVD0)
#define BP_PXP_WFB_ARRAY_PIXEL1_MASK_BUF_SEL      28
#define BM_PXP_WFB_ARRAY_PIXEL1_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFB_ARRAY_PIXEL1_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFB_ARRAY_PIXEL1_MASK_BUF_SEL)
#define BV_PXP_WFB_ARRAY_PIXEL1_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFB_ARRAY_PIXEL1_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFB_ARRAY_PIXEL1_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFB_ARRAY_PIXEL1_MASK_RSVD1      26
#define BM_PXP_WFB_ARRAY_PIXEL1_MASK_RSVD1 0x0C000000
#define BF_PXP_WFB_ARRAY_PIXEL1_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFB_ARRAY_PIXEL1_MASK_RSVD1)
#define BM_PXP_WFB_ARRAY_PIXEL1_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFB_ARRAY_PIXEL1_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFB_ARRAY_PIXEL1_MASK_SIGN_Y)
#define BV_PXP_WFB_ARRAY_PIXEL1_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFB_ARRAY_PIXEL1_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFB_ARRAY_PIXEL1_MASK_SIGN_X 0x01000000
#define BF_PXP_WFB_ARRAY_PIXEL1_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFB_ARRAY_PIXEL1_MASK_SIGN_X)
#define BV_PXP_WFB_ARRAY_PIXEL1_MASK_SIGN_X__0 0x0
#define BV_PXP_WFB_ARRAY_PIXEL1_MASK_SIGN_X__1 0x1
#define BP_PXP_WFB_ARRAY_PIXEL1_MASK_RSVD2      22
#define BM_PXP_WFB_ARRAY_PIXEL1_MASK_RSVD2 0x00C00000
#define BF_PXP_WFB_ARRAY_PIXEL1_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFB_ARRAY_PIXEL1_MASK_RSVD2)
#define BP_PXP_WFB_ARRAY_PIXEL1_MASK_OFFSET_Y      20
#define BM_PXP_WFB_ARRAY_PIXEL1_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFB_ARRAY_PIXEL1_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFB_ARRAY_PIXEL1_MASK_OFFSET_Y)
#define BP_PXP_WFB_ARRAY_PIXEL1_MASK_RSVD3      18
#define BM_PXP_WFB_ARRAY_PIXEL1_MASK_RSVD3 0x000C0000
#define BF_PXP_WFB_ARRAY_PIXEL1_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFB_ARRAY_PIXEL1_MASK_RSVD3)
#define BP_PXP_WFB_ARRAY_PIXEL1_MASK_OFFSET_X      16
#define BM_PXP_WFB_ARRAY_PIXEL1_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFB_ARRAY_PIXEL1_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFB_ARRAY_PIXEL1_MASK_OFFSET_X)
#define BP_PXP_WFB_ARRAY_PIXEL1_MASK_RSVD4      13
#define BM_PXP_WFB_ARRAY_PIXEL1_MASK_RSVD4 0x0000E000
#define BF_PXP_WFB_ARRAY_PIXEL1_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFB_ARRAY_PIXEL1_MASK_RSVD4)
#define BP_PXP_WFB_ARRAY_PIXEL1_MASK_H_OFS      8
#define BM_PXP_WFB_ARRAY_PIXEL1_MASK_H_OFS 0x00001F00
#define BF_PXP_WFB_ARRAY_PIXEL1_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFB_ARRAY_PIXEL1_MASK_H_OFS)
#define BP_PXP_WFB_ARRAY_PIXEL1_MASK_RSVD5      5
#define BM_PXP_WFB_ARRAY_PIXEL1_MASK_RSVD5 0x000000E0
#define BF_PXP_WFB_ARRAY_PIXEL1_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFB_ARRAY_PIXEL1_MASK_RSVD5)
#define BP_PXP_WFB_ARRAY_PIXEL1_MASK_L_OFS      0
#define BM_PXP_WFB_ARRAY_PIXEL1_MASK_L_OFS 0x0000001F
#define BF_PXP_WFB_ARRAY_PIXEL1_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFB_ARRAY_PIXEL1_MASK_L_OFS)

#define HW_PXP_WFB_ARRAY_PIXEL2_MASK	(0x00001190)

#define BP_PXP_WFB_ARRAY_PIXEL2_MASK_RSVD0      30
#define BM_PXP_WFB_ARRAY_PIXEL2_MASK_RSVD0 0xC0000000
#define BF_PXP_WFB_ARRAY_PIXEL2_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFB_ARRAY_PIXEL2_MASK_RSVD0)
#define BP_PXP_WFB_ARRAY_PIXEL2_MASK_BUF_SEL      28
#define BM_PXP_WFB_ARRAY_PIXEL2_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFB_ARRAY_PIXEL2_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFB_ARRAY_PIXEL2_MASK_BUF_SEL)
#define BV_PXP_WFB_ARRAY_PIXEL2_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFB_ARRAY_PIXEL2_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFB_ARRAY_PIXEL2_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFB_ARRAY_PIXEL2_MASK_RSVD1      26
#define BM_PXP_WFB_ARRAY_PIXEL2_MASK_RSVD1 0x0C000000
#define BF_PXP_WFB_ARRAY_PIXEL2_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFB_ARRAY_PIXEL2_MASK_RSVD1)
#define BM_PXP_WFB_ARRAY_PIXEL2_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFB_ARRAY_PIXEL2_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFB_ARRAY_PIXEL2_MASK_SIGN_Y)
#define BV_PXP_WFB_ARRAY_PIXEL2_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFB_ARRAY_PIXEL2_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFB_ARRAY_PIXEL2_MASK_SIGN_X 0x01000000
#define BF_PXP_WFB_ARRAY_PIXEL2_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFB_ARRAY_PIXEL2_MASK_SIGN_X)
#define BV_PXP_WFB_ARRAY_PIXEL2_MASK_SIGN_X__0 0x0
#define BV_PXP_WFB_ARRAY_PIXEL2_MASK_SIGN_X__1 0x1
#define BP_PXP_WFB_ARRAY_PIXEL2_MASK_RSVD2      22
#define BM_PXP_WFB_ARRAY_PIXEL2_MASK_RSVD2 0x00C00000
#define BF_PXP_WFB_ARRAY_PIXEL2_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFB_ARRAY_PIXEL2_MASK_RSVD2)
#define BP_PXP_WFB_ARRAY_PIXEL2_MASK_OFFSET_Y      20
#define BM_PXP_WFB_ARRAY_PIXEL2_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFB_ARRAY_PIXEL2_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFB_ARRAY_PIXEL2_MASK_OFFSET_Y)
#define BP_PXP_WFB_ARRAY_PIXEL2_MASK_RSVD3      18
#define BM_PXP_WFB_ARRAY_PIXEL2_MASK_RSVD3 0x000C0000
#define BF_PXP_WFB_ARRAY_PIXEL2_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFB_ARRAY_PIXEL2_MASK_RSVD3)
#define BP_PXP_WFB_ARRAY_PIXEL2_MASK_OFFSET_X      16
#define BM_PXP_WFB_ARRAY_PIXEL2_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFB_ARRAY_PIXEL2_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFB_ARRAY_PIXEL2_MASK_OFFSET_X)
#define BP_PXP_WFB_ARRAY_PIXEL2_MASK_RSVD4      13
#define BM_PXP_WFB_ARRAY_PIXEL2_MASK_RSVD4 0x0000E000
#define BF_PXP_WFB_ARRAY_PIXEL2_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFB_ARRAY_PIXEL2_MASK_RSVD4)
#define BP_PXP_WFB_ARRAY_PIXEL2_MASK_H_OFS      8
#define BM_PXP_WFB_ARRAY_PIXEL2_MASK_H_OFS 0x00001F00
#define BF_PXP_WFB_ARRAY_PIXEL2_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFB_ARRAY_PIXEL2_MASK_H_OFS)
#define BP_PXP_WFB_ARRAY_PIXEL2_MASK_RSVD5      5
#define BM_PXP_WFB_ARRAY_PIXEL2_MASK_RSVD5 0x000000E0
#define BF_PXP_WFB_ARRAY_PIXEL2_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFB_ARRAY_PIXEL2_MASK_RSVD5)
#define BP_PXP_WFB_ARRAY_PIXEL2_MASK_L_OFS      0
#define BM_PXP_WFB_ARRAY_PIXEL2_MASK_L_OFS 0x0000001F
#define BF_PXP_WFB_ARRAY_PIXEL2_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFB_ARRAY_PIXEL2_MASK_L_OFS)

#define HW_PXP_WFB_ARRAY_PIXEL3_MASK	(0x000011a0)

#define BP_PXP_WFB_ARRAY_PIXEL3_MASK_RSVD0      30
#define BM_PXP_WFB_ARRAY_PIXEL3_MASK_RSVD0 0xC0000000
#define BF_PXP_WFB_ARRAY_PIXEL3_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFB_ARRAY_PIXEL3_MASK_RSVD0)
#define BP_PXP_WFB_ARRAY_PIXEL3_MASK_BUF_SEL      28
#define BM_PXP_WFB_ARRAY_PIXEL3_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFB_ARRAY_PIXEL3_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFB_ARRAY_PIXEL3_MASK_BUF_SEL)
#define BV_PXP_WFB_ARRAY_PIXEL3_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFB_ARRAY_PIXEL3_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFB_ARRAY_PIXEL3_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFB_ARRAY_PIXEL3_MASK_RSVD1      26
#define BM_PXP_WFB_ARRAY_PIXEL3_MASK_RSVD1 0x0C000000
#define BF_PXP_WFB_ARRAY_PIXEL3_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFB_ARRAY_PIXEL3_MASK_RSVD1)
#define BM_PXP_WFB_ARRAY_PIXEL3_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFB_ARRAY_PIXEL3_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFB_ARRAY_PIXEL3_MASK_SIGN_Y)
#define BV_PXP_WFB_ARRAY_PIXEL3_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFB_ARRAY_PIXEL3_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFB_ARRAY_PIXEL3_MASK_SIGN_X 0x01000000
#define BF_PXP_WFB_ARRAY_PIXEL3_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFB_ARRAY_PIXEL3_MASK_SIGN_X)
#define BV_PXP_WFB_ARRAY_PIXEL3_MASK_SIGN_X__0 0x0
#define BV_PXP_WFB_ARRAY_PIXEL3_MASK_SIGN_X__1 0x1
#define BP_PXP_WFB_ARRAY_PIXEL3_MASK_RSVD2      22
#define BM_PXP_WFB_ARRAY_PIXEL3_MASK_RSVD2 0x00C00000
#define BF_PXP_WFB_ARRAY_PIXEL3_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFB_ARRAY_PIXEL3_MASK_RSVD2)
#define BP_PXP_WFB_ARRAY_PIXEL3_MASK_OFFSET_Y      20
#define BM_PXP_WFB_ARRAY_PIXEL3_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFB_ARRAY_PIXEL3_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFB_ARRAY_PIXEL3_MASK_OFFSET_Y)
#define BP_PXP_WFB_ARRAY_PIXEL3_MASK_RSVD3      18
#define BM_PXP_WFB_ARRAY_PIXEL3_MASK_RSVD3 0x000C0000
#define BF_PXP_WFB_ARRAY_PIXEL3_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFB_ARRAY_PIXEL3_MASK_RSVD3)
#define BP_PXP_WFB_ARRAY_PIXEL3_MASK_OFFSET_X      16
#define BM_PXP_WFB_ARRAY_PIXEL3_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFB_ARRAY_PIXEL3_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFB_ARRAY_PIXEL3_MASK_OFFSET_X)
#define BP_PXP_WFB_ARRAY_PIXEL3_MASK_RSVD4      13
#define BM_PXP_WFB_ARRAY_PIXEL3_MASK_RSVD4 0x0000E000
#define BF_PXP_WFB_ARRAY_PIXEL3_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFB_ARRAY_PIXEL3_MASK_RSVD4)
#define BP_PXP_WFB_ARRAY_PIXEL3_MASK_H_OFS      8
#define BM_PXP_WFB_ARRAY_PIXEL3_MASK_H_OFS 0x00001F00
#define BF_PXP_WFB_ARRAY_PIXEL3_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFB_ARRAY_PIXEL3_MASK_H_OFS)
#define BP_PXP_WFB_ARRAY_PIXEL3_MASK_RSVD5      5
#define BM_PXP_WFB_ARRAY_PIXEL3_MASK_RSVD5 0x000000E0
#define BF_PXP_WFB_ARRAY_PIXEL3_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFB_ARRAY_PIXEL3_MASK_RSVD5)
#define BP_PXP_WFB_ARRAY_PIXEL3_MASK_L_OFS      0
#define BM_PXP_WFB_ARRAY_PIXEL3_MASK_L_OFS 0x0000001F
#define BF_PXP_WFB_ARRAY_PIXEL3_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFB_ARRAY_PIXEL3_MASK_L_OFS)

#define HW_PXP_WFB_ARRAY_PIXEL4_MASK	(0x000011b0)

#define BP_PXP_WFB_ARRAY_PIXEL4_MASK_RSVD0      30
#define BM_PXP_WFB_ARRAY_PIXEL4_MASK_RSVD0 0xC0000000
#define BF_PXP_WFB_ARRAY_PIXEL4_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFB_ARRAY_PIXEL4_MASK_RSVD0)
#define BP_PXP_WFB_ARRAY_PIXEL4_MASK_BUF_SEL      28
#define BM_PXP_WFB_ARRAY_PIXEL4_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFB_ARRAY_PIXEL4_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFB_ARRAY_PIXEL4_MASK_BUF_SEL)
#define BV_PXP_WFB_ARRAY_PIXEL4_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFB_ARRAY_PIXEL4_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFB_ARRAY_PIXEL4_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFB_ARRAY_PIXEL4_MASK_RSVD1      26
#define BM_PXP_WFB_ARRAY_PIXEL4_MASK_RSVD1 0x0C000000
#define BF_PXP_WFB_ARRAY_PIXEL4_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFB_ARRAY_PIXEL4_MASK_RSVD1)
#define BM_PXP_WFB_ARRAY_PIXEL4_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFB_ARRAY_PIXEL4_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFB_ARRAY_PIXEL4_MASK_SIGN_Y)
#define BV_PXP_WFB_ARRAY_PIXEL4_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFB_ARRAY_PIXEL4_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFB_ARRAY_PIXEL4_MASK_SIGN_X 0x01000000
#define BF_PXP_WFB_ARRAY_PIXEL4_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFB_ARRAY_PIXEL4_MASK_SIGN_X)
#define BV_PXP_WFB_ARRAY_PIXEL4_MASK_SIGN_X__0 0x0
#define BV_PXP_WFB_ARRAY_PIXEL4_MASK_SIGN_X__1 0x1
#define BP_PXP_WFB_ARRAY_PIXEL4_MASK_RSVD2      22
#define BM_PXP_WFB_ARRAY_PIXEL4_MASK_RSVD2 0x00C00000
#define BF_PXP_WFB_ARRAY_PIXEL4_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFB_ARRAY_PIXEL4_MASK_RSVD2)
#define BP_PXP_WFB_ARRAY_PIXEL4_MASK_OFFSET_Y      20
#define BM_PXP_WFB_ARRAY_PIXEL4_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFB_ARRAY_PIXEL4_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFB_ARRAY_PIXEL4_MASK_OFFSET_Y)
#define BP_PXP_WFB_ARRAY_PIXEL4_MASK_RSVD3      18
#define BM_PXP_WFB_ARRAY_PIXEL4_MASK_RSVD3 0x000C0000
#define BF_PXP_WFB_ARRAY_PIXEL4_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFB_ARRAY_PIXEL4_MASK_RSVD3)
#define BP_PXP_WFB_ARRAY_PIXEL4_MASK_OFFSET_X      16
#define BM_PXP_WFB_ARRAY_PIXEL4_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFB_ARRAY_PIXEL4_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFB_ARRAY_PIXEL4_MASK_OFFSET_X)
#define BP_PXP_WFB_ARRAY_PIXEL4_MASK_RSVD4      13
#define BM_PXP_WFB_ARRAY_PIXEL4_MASK_RSVD4 0x0000E000
#define BF_PXP_WFB_ARRAY_PIXEL4_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFB_ARRAY_PIXEL4_MASK_RSVD4)
#define BP_PXP_WFB_ARRAY_PIXEL4_MASK_H_OFS      8
#define BM_PXP_WFB_ARRAY_PIXEL4_MASK_H_OFS 0x00001F00
#define BF_PXP_WFB_ARRAY_PIXEL4_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFB_ARRAY_PIXEL4_MASK_H_OFS)
#define BP_PXP_WFB_ARRAY_PIXEL4_MASK_RSVD5      5
#define BM_PXP_WFB_ARRAY_PIXEL4_MASK_RSVD5 0x000000E0
#define BF_PXP_WFB_ARRAY_PIXEL4_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFB_ARRAY_PIXEL4_MASK_RSVD5)
#define BP_PXP_WFB_ARRAY_PIXEL4_MASK_L_OFS      0
#define BM_PXP_WFB_ARRAY_PIXEL4_MASK_L_OFS 0x0000001F
#define BF_PXP_WFB_ARRAY_PIXEL4_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFB_ARRAY_PIXEL4_MASK_L_OFS)

#define HW_PXP_WFB_ARRAY_PIXEL5_MASK	(0x000011c0)

#define BP_PXP_WFB_ARRAY_PIXEL5_MASK_RSVD0      30
#define BM_PXP_WFB_ARRAY_PIXEL5_MASK_RSVD0 0xC0000000
#define BF_PXP_WFB_ARRAY_PIXEL5_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFB_ARRAY_PIXEL5_MASK_RSVD0)
#define BP_PXP_WFB_ARRAY_PIXEL5_MASK_BUF_SEL      28
#define BM_PXP_WFB_ARRAY_PIXEL5_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFB_ARRAY_PIXEL5_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFB_ARRAY_PIXEL5_MASK_BUF_SEL)
#define BV_PXP_WFB_ARRAY_PIXEL5_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFB_ARRAY_PIXEL5_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFB_ARRAY_PIXEL5_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFB_ARRAY_PIXEL5_MASK_RSVD1      26
#define BM_PXP_WFB_ARRAY_PIXEL5_MASK_RSVD1 0x0C000000
#define BF_PXP_WFB_ARRAY_PIXEL5_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFB_ARRAY_PIXEL5_MASK_RSVD1)
#define BM_PXP_WFB_ARRAY_PIXEL5_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFB_ARRAY_PIXEL5_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFB_ARRAY_PIXEL5_MASK_SIGN_Y)
#define BV_PXP_WFB_ARRAY_PIXEL5_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFB_ARRAY_PIXEL5_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFB_ARRAY_PIXEL5_MASK_SIGN_X 0x01000000
#define BF_PXP_WFB_ARRAY_PIXEL5_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFB_ARRAY_PIXEL5_MASK_SIGN_X)
#define BV_PXP_WFB_ARRAY_PIXEL5_MASK_SIGN_X__0 0x0
#define BV_PXP_WFB_ARRAY_PIXEL5_MASK_SIGN_X__1 0x1
#define BP_PXP_WFB_ARRAY_PIXEL5_MASK_RSVD2      22
#define BM_PXP_WFB_ARRAY_PIXEL5_MASK_RSVD2 0x00C00000
#define BF_PXP_WFB_ARRAY_PIXEL5_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFB_ARRAY_PIXEL5_MASK_RSVD2)
#define BP_PXP_WFB_ARRAY_PIXEL5_MASK_OFFSET_Y      20
#define BM_PXP_WFB_ARRAY_PIXEL5_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFB_ARRAY_PIXEL5_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFB_ARRAY_PIXEL5_MASK_OFFSET_Y)
#define BP_PXP_WFB_ARRAY_PIXEL5_MASK_RSVD3      18
#define BM_PXP_WFB_ARRAY_PIXEL5_MASK_RSVD3 0x000C0000
#define BF_PXP_WFB_ARRAY_PIXEL5_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFB_ARRAY_PIXEL5_MASK_RSVD3)
#define BP_PXP_WFB_ARRAY_PIXEL5_MASK_OFFSET_X      16
#define BM_PXP_WFB_ARRAY_PIXEL5_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFB_ARRAY_PIXEL5_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFB_ARRAY_PIXEL5_MASK_OFFSET_X)
#define BP_PXP_WFB_ARRAY_PIXEL5_MASK_RSVD4      13
#define BM_PXP_WFB_ARRAY_PIXEL5_MASK_RSVD4 0x0000E000
#define BF_PXP_WFB_ARRAY_PIXEL5_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFB_ARRAY_PIXEL5_MASK_RSVD4)
#define BP_PXP_WFB_ARRAY_PIXEL5_MASK_H_OFS      8
#define BM_PXP_WFB_ARRAY_PIXEL5_MASK_H_OFS 0x00001F00
#define BF_PXP_WFB_ARRAY_PIXEL5_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFB_ARRAY_PIXEL5_MASK_H_OFS)
#define BP_PXP_WFB_ARRAY_PIXEL5_MASK_RSVD5      5
#define BM_PXP_WFB_ARRAY_PIXEL5_MASK_RSVD5 0x000000E0
#define BF_PXP_WFB_ARRAY_PIXEL5_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFB_ARRAY_PIXEL5_MASK_RSVD5)
#define BP_PXP_WFB_ARRAY_PIXEL5_MASK_L_OFS      0
#define BM_PXP_WFB_ARRAY_PIXEL5_MASK_L_OFS 0x0000001F
#define BF_PXP_WFB_ARRAY_PIXEL5_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFB_ARRAY_PIXEL5_MASK_L_OFS)

#define HW_PXP_WFB_ARRAY_PIXEL6_MASK	(0x000011d0)

#define BP_PXP_WFB_ARRAY_PIXEL6_MASK_RSVD0      30
#define BM_PXP_WFB_ARRAY_PIXEL6_MASK_RSVD0 0xC0000000
#define BF_PXP_WFB_ARRAY_PIXEL6_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFB_ARRAY_PIXEL6_MASK_RSVD0)
#define BP_PXP_WFB_ARRAY_PIXEL6_MASK_BUF_SEL      28
#define BM_PXP_WFB_ARRAY_PIXEL6_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFB_ARRAY_PIXEL6_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFB_ARRAY_PIXEL6_MASK_BUF_SEL)
#define BV_PXP_WFB_ARRAY_PIXEL6_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFB_ARRAY_PIXEL6_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFB_ARRAY_PIXEL6_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFB_ARRAY_PIXEL6_MASK_RSVD1      26
#define BM_PXP_WFB_ARRAY_PIXEL6_MASK_RSVD1 0x0C000000
#define BF_PXP_WFB_ARRAY_PIXEL6_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFB_ARRAY_PIXEL6_MASK_RSVD1)
#define BM_PXP_WFB_ARRAY_PIXEL6_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFB_ARRAY_PIXEL6_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFB_ARRAY_PIXEL6_MASK_SIGN_Y)
#define BV_PXP_WFB_ARRAY_PIXEL6_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFB_ARRAY_PIXEL6_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFB_ARRAY_PIXEL6_MASK_SIGN_X 0x01000000
#define BF_PXP_WFB_ARRAY_PIXEL6_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFB_ARRAY_PIXEL6_MASK_SIGN_X)
#define BV_PXP_WFB_ARRAY_PIXEL6_MASK_SIGN_X__0 0x0
#define BV_PXP_WFB_ARRAY_PIXEL6_MASK_SIGN_X__1 0x1
#define BP_PXP_WFB_ARRAY_PIXEL6_MASK_RSVD2      22
#define BM_PXP_WFB_ARRAY_PIXEL6_MASK_RSVD2 0x00C00000
#define BF_PXP_WFB_ARRAY_PIXEL6_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFB_ARRAY_PIXEL6_MASK_RSVD2)
#define BP_PXP_WFB_ARRAY_PIXEL6_MASK_OFFSET_Y      20
#define BM_PXP_WFB_ARRAY_PIXEL6_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFB_ARRAY_PIXEL6_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFB_ARRAY_PIXEL6_MASK_OFFSET_Y)
#define BP_PXP_WFB_ARRAY_PIXEL6_MASK_RSVD3      18
#define BM_PXP_WFB_ARRAY_PIXEL6_MASK_RSVD3 0x000C0000
#define BF_PXP_WFB_ARRAY_PIXEL6_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFB_ARRAY_PIXEL6_MASK_RSVD3)
#define BP_PXP_WFB_ARRAY_PIXEL6_MASK_OFFSET_X      16
#define BM_PXP_WFB_ARRAY_PIXEL6_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFB_ARRAY_PIXEL6_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFB_ARRAY_PIXEL6_MASK_OFFSET_X)
#define BP_PXP_WFB_ARRAY_PIXEL6_MASK_RSVD4      13
#define BM_PXP_WFB_ARRAY_PIXEL6_MASK_RSVD4 0x0000E000
#define BF_PXP_WFB_ARRAY_PIXEL6_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFB_ARRAY_PIXEL6_MASK_RSVD4)
#define BP_PXP_WFB_ARRAY_PIXEL6_MASK_H_OFS      8
#define BM_PXP_WFB_ARRAY_PIXEL6_MASK_H_OFS 0x00001F00
#define BF_PXP_WFB_ARRAY_PIXEL6_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFB_ARRAY_PIXEL6_MASK_H_OFS)
#define BP_PXP_WFB_ARRAY_PIXEL6_MASK_RSVD5      5
#define BM_PXP_WFB_ARRAY_PIXEL6_MASK_RSVD5 0x000000E0
#define BF_PXP_WFB_ARRAY_PIXEL6_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFB_ARRAY_PIXEL6_MASK_RSVD5)
#define BP_PXP_WFB_ARRAY_PIXEL6_MASK_L_OFS      0
#define BM_PXP_WFB_ARRAY_PIXEL6_MASK_L_OFS 0x0000001F
#define BF_PXP_WFB_ARRAY_PIXEL6_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFB_ARRAY_PIXEL6_MASK_L_OFS)

#define HW_PXP_WFB_ARRAY_PIXEL7_MASK	(0x000011e0)

#define BP_PXP_WFB_ARRAY_PIXEL7_MASK_RSVD0      30
#define BM_PXP_WFB_ARRAY_PIXEL7_MASK_RSVD0 0xC0000000
#define BF_PXP_WFB_ARRAY_PIXEL7_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFB_ARRAY_PIXEL7_MASK_RSVD0)
#define BP_PXP_WFB_ARRAY_PIXEL7_MASK_BUF_SEL      28
#define BM_PXP_WFB_ARRAY_PIXEL7_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFB_ARRAY_PIXEL7_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFB_ARRAY_PIXEL7_MASK_BUF_SEL)
#define BV_PXP_WFB_ARRAY_PIXEL7_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFB_ARRAY_PIXEL7_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFB_ARRAY_PIXEL7_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFB_ARRAY_PIXEL7_MASK_RSVD1      26
#define BM_PXP_WFB_ARRAY_PIXEL7_MASK_RSVD1 0x0C000000
#define BF_PXP_WFB_ARRAY_PIXEL7_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFB_ARRAY_PIXEL7_MASK_RSVD1)
#define BM_PXP_WFB_ARRAY_PIXEL7_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFB_ARRAY_PIXEL7_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFB_ARRAY_PIXEL7_MASK_SIGN_Y)
#define BV_PXP_WFB_ARRAY_PIXEL7_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFB_ARRAY_PIXEL7_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFB_ARRAY_PIXEL7_MASK_SIGN_X 0x01000000
#define BF_PXP_WFB_ARRAY_PIXEL7_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFB_ARRAY_PIXEL7_MASK_SIGN_X)
#define BV_PXP_WFB_ARRAY_PIXEL7_MASK_SIGN_X__0 0x0
#define BV_PXP_WFB_ARRAY_PIXEL7_MASK_SIGN_X__1 0x1
#define BP_PXP_WFB_ARRAY_PIXEL7_MASK_RSVD2      22
#define BM_PXP_WFB_ARRAY_PIXEL7_MASK_RSVD2 0x00C00000
#define BF_PXP_WFB_ARRAY_PIXEL7_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFB_ARRAY_PIXEL7_MASK_RSVD2)
#define BP_PXP_WFB_ARRAY_PIXEL7_MASK_OFFSET_Y      20
#define BM_PXP_WFB_ARRAY_PIXEL7_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFB_ARRAY_PIXEL7_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFB_ARRAY_PIXEL7_MASK_OFFSET_Y)
#define BP_PXP_WFB_ARRAY_PIXEL7_MASK_RSVD3      18
#define BM_PXP_WFB_ARRAY_PIXEL7_MASK_RSVD3 0x000C0000
#define BF_PXP_WFB_ARRAY_PIXEL7_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFB_ARRAY_PIXEL7_MASK_RSVD3)
#define BP_PXP_WFB_ARRAY_PIXEL7_MASK_OFFSET_X      16
#define BM_PXP_WFB_ARRAY_PIXEL7_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFB_ARRAY_PIXEL7_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFB_ARRAY_PIXEL7_MASK_OFFSET_X)
#define BP_PXP_WFB_ARRAY_PIXEL7_MASK_RSVD4      13
#define BM_PXP_WFB_ARRAY_PIXEL7_MASK_RSVD4 0x0000E000
#define BF_PXP_WFB_ARRAY_PIXEL7_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFB_ARRAY_PIXEL7_MASK_RSVD4)
#define BP_PXP_WFB_ARRAY_PIXEL7_MASK_H_OFS      8
#define BM_PXP_WFB_ARRAY_PIXEL7_MASK_H_OFS 0x00001F00
#define BF_PXP_WFB_ARRAY_PIXEL7_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFB_ARRAY_PIXEL7_MASK_H_OFS)
#define BP_PXP_WFB_ARRAY_PIXEL7_MASK_RSVD5      5
#define BM_PXP_WFB_ARRAY_PIXEL7_MASK_RSVD5 0x000000E0
#define BF_PXP_WFB_ARRAY_PIXEL7_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFB_ARRAY_PIXEL7_MASK_RSVD5)
#define BP_PXP_WFB_ARRAY_PIXEL7_MASK_L_OFS      0
#define BM_PXP_WFB_ARRAY_PIXEL7_MASK_L_OFS 0x0000001F
#define BF_PXP_WFB_ARRAY_PIXEL7_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFB_ARRAY_PIXEL7_MASK_L_OFS)

#define HW_PXP_WFB_ARRAY_FLAG0_MASK	(0x000011f0)

#define BP_PXP_WFB_ARRAY_FLAG0_MASK_RSVD0      30
#define BM_PXP_WFB_ARRAY_FLAG0_MASK_RSVD0 0xC0000000
#define BF_PXP_WFB_ARRAY_FLAG0_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFB_ARRAY_FLAG0_MASK_RSVD0)
#define BP_PXP_WFB_ARRAY_FLAG0_MASK_BUF_SEL      28
#define BM_PXP_WFB_ARRAY_FLAG0_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFB_ARRAY_FLAG0_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFB_ARRAY_FLAG0_MASK_BUF_SEL)
#define BV_PXP_WFB_ARRAY_FLAG0_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG0_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFB_ARRAY_FLAG0_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFB_ARRAY_FLAG0_MASK_RSVD1      26
#define BM_PXP_WFB_ARRAY_FLAG0_MASK_RSVD1 0x0C000000
#define BF_PXP_WFB_ARRAY_FLAG0_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFB_ARRAY_FLAG0_MASK_RSVD1)
#define BM_PXP_WFB_ARRAY_FLAG0_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFB_ARRAY_FLAG0_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFB_ARRAY_FLAG0_MASK_SIGN_Y)
#define BV_PXP_WFB_ARRAY_FLAG0_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG0_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFB_ARRAY_FLAG0_MASK_SIGN_X 0x01000000
#define BF_PXP_WFB_ARRAY_FLAG0_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFB_ARRAY_FLAG0_MASK_SIGN_X)
#define BV_PXP_WFB_ARRAY_FLAG0_MASK_SIGN_X__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG0_MASK_SIGN_X__1 0x1
#define BP_PXP_WFB_ARRAY_FLAG0_MASK_RSVD2      22
#define BM_PXP_WFB_ARRAY_FLAG0_MASK_RSVD2 0x00C00000
#define BF_PXP_WFB_ARRAY_FLAG0_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFB_ARRAY_FLAG0_MASK_RSVD2)
#define BP_PXP_WFB_ARRAY_FLAG0_MASK_OFFSET_Y      20
#define BM_PXP_WFB_ARRAY_FLAG0_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFB_ARRAY_FLAG0_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFB_ARRAY_FLAG0_MASK_OFFSET_Y)
#define BP_PXP_WFB_ARRAY_FLAG0_MASK_RSVD3      18
#define BM_PXP_WFB_ARRAY_FLAG0_MASK_RSVD3 0x000C0000
#define BF_PXP_WFB_ARRAY_FLAG0_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFB_ARRAY_FLAG0_MASK_RSVD3)
#define BP_PXP_WFB_ARRAY_FLAG0_MASK_OFFSET_X      16
#define BM_PXP_WFB_ARRAY_FLAG0_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFB_ARRAY_FLAG0_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFB_ARRAY_FLAG0_MASK_OFFSET_X)
#define BP_PXP_WFB_ARRAY_FLAG0_MASK_RSVD4      13
#define BM_PXP_WFB_ARRAY_FLAG0_MASK_RSVD4 0x0000E000
#define BF_PXP_WFB_ARRAY_FLAG0_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFB_ARRAY_FLAG0_MASK_RSVD4)
#define BP_PXP_WFB_ARRAY_FLAG0_MASK_H_OFS      8
#define BM_PXP_WFB_ARRAY_FLAG0_MASK_H_OFS 0x00001F00
#define BF_PXP_WFB_ARRAY_FLAG0_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFB_ARRAY_FLAG0_MASK_H_OFS)
#define BP_PXP_WFB_ARRAY_FLAG0_MASK_RSVD5      5
#define BM_PXP_WFB_ARRAY_FLAG0_MASK_RSVD5 0x000000E0
#define BF_PXP_WFB_ARRAY_FLAG0_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFB_ARRAY_FLAG0_MASK_RSVD5)
#define BP_PXP_WFB_ARRAY_FLAG0_MASK_L_OFS      0
#define BM_PXP_WFB_ARRAY_FLAG0_MASK_L_OFS 0x0000001F
#define BF_PXP_WFB_ARRAY_FLAG0_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFB_ARRAY_FLAG0_MASK_L_OFS)

#define HW_PXP_WFB_ARRAY_FLAG1_MASK	(0x00001200)

#define BP_PXP_WFB_ARRAY_FLAG1_MASK_RSVD0      30
#define BM_PXP_WFB_ARRAY_FLAG1_MASK_RSVD0 0xC0000000
#define BF_PXP_WFB_ARRAY_FLAG1_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFB_ARRAY_FLAG1_MASK_RSVD0)
#define BP_PXP_WFB_ARRAY_FLAG1_MASK_BUF_SEL      28
#define BM_PXP_WFB_ARRAY_FLAG1_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFB_ARRAY_FLAG1_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFB_ARRAY_FLAG1_MASK_BUF_SEL)
#define BV_PXP_WFB_ARRAY_FLAG1_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG1_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFB_ARRAY_FLAG1_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFB_ARRAY_FLAG1_MASK_RSVD1      26
#define BM_PXP_WFB_ARRAY_FLAG1_MASK_RSVD1 0x0C000000
#define BF_PXP_WFB_ARRAY_FLAG1_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFB_ARRAY_FLAG1_MASK_RSVD1)
#define BM_PXP_WFB_ARRAY_FLAG1_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFB_ARRAY_FLAG1_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFB_ARRAY_FLAG1_MASK_SIGN_Y)
#define BV_PXP_WFB_ARRAY_FLAG1_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG1_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFB_ARRAY_FLAG1_MASK_SIGN_X 0x01000000
#define BF_PXP_WFB_ARRAY_FLAG1_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFB_ARRAY_FLAG1_MASK_SIGN_X)
#define BV_PXP_WFB_ARRAY_FLAG1_MASK_SIGN_X__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG1_MASK_SIGN_X__1 0x1
#define BP_PXP_WFB_ARRAY_FLAG1_MASK_RSVD2      22
#define BM_PXP_WFB_ARRAY_FLAG1_MASK_RSVD2 0x00C00000
#define BF_PXP_WFB_ARRAY_FLAG1_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFB_ARRAY_FLAG1_MASK_RSVD2)
#define BP_PXP_WFB_ARRAY_FLAG1_MASK_OFFSET_Y      20
#define BM_PXP_WFB_ARRAY_FLAG1_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFB_ARRAY_FLAG1_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFB_ARRAY_FLAG1_MASK_OFFSET_Y)
#define BP_PXP_WFB_ARRAY_FLAG1_MASK_RSVD3      18
#define BM_PXP_WFB_ARRAY_FLAG1_MASK_RSVD3 0x000C0000
#define BF_PXP_WFB_ARRAY_FLAG1_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFB_ARRAY_FLAG1_MASK_RSVD3)
#define BP_PXP_WFB_ARRAY_FLAG1_MASK_OFFSET_X      16
#define BM_PXP_WFB_ARRAY_FLAG1_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFB_ARRAY_FLAG1_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFB_ARRAY_FLAG1_MASK_OFFSET_X)
#define BP_PXP_WFB_ARRAY_FLAG1_MASK_RSVD4      13
#define BM_PXP_WFB_ARRAY_FLAG1_MASK_RSVD4 0x0000E000
#define BF_PXP_WFB_ARRAY_FLAG1_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFB_ARRAY_FLAG1_MASK_RSVD4)
#define BP_PXP_WFB_ARRAY_FLAG1_MASK_H_OFS      8
#define BM_PXP_WFB_ARRAY_FLAG1_MASK_H_OFS 0x00001F00
#define BF_PXP_WFB_ARRAY_FLAG1_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFB_ARRAY_FLAG1_MASK_H_OFS)
#define BP_PXP_WFB_ARRAY_FLAG1_MASK_RSVD5      5
#define BM_PXP_WFB_ARRAY_FLAG1_MASK_RSVD5 0x000000E0
#define BF_PXP_WFB_ARRAY_FLAG1_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFB_ARRAY_FLAG1_MASK_RSVD5)
#define BP_PXP_WFB_ARRAY_FLAG1_MASK_L_OFS      0
#define BM_PXP_WFB_ARRAY_FLAG1_MASK_L_OFS 0x0000001F
#define BF_PXP_WFB_ARRAY_FLAG1_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFB_ARRAY_FLAG1_MASK_L_OFS)

#define HW_PXP_WFB_ARRAY_FLAG2_MASK	(0x00001210)

#define BP_PXP_WFB_ARRAY_FLAG2_MASK_RSVD0      30
#define BM_PXP_WFB_ARRAY_FLAG2_MASK_RSVD0 0xC0000000
#define BF_PXP_WFB_ARRAY_FLAG2_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFB_ARRAY_FLAG2_MASK_RSVD0)
#define BP_PXP_WFB_ARRAY_FLAG2_MASK_BUF_SEL      28
#define BM_PXP_WFB_ARRAY_FLAG2_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFB_ARRAY_FLAG2_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFB_ARRAY_FLAG2_MASK_BUF_SEL)
#define BV_PXP_WFB_ARRAY_FLAG2_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG2_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFB_ARRAY_FLAG2_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFB_ARRAY_FLAG2_MASK_RSVD1      26
#define BM_PXP_WFB_ARRAY_FLAG2_MASK_RSVD1 0x0C000000
#define BF_PXP_WFB_ARRAY_FLAG2_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFB_ARRAY_FLAG2_MASK_RSVD1)
#define BM_PXP_WFB_ARRAY_FLAG2_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFB_ARRAY_FLAG2_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFB_ARRAY_FLAG2_MASK_SIGN_Y)
#define BV_PXP_WFB_ARRAY_FLAG2_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG2_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFB_ARRAY_FLAG2_MASK_SIGN_X 0x01000000
#define BF_PXP_WFB_ARRAY_FLAG2_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFB_ARRAY_FLAG2_MASK_SIGN_X)
#define BV_PXP_WFB_ARRAY_FLAG2_MASK_SIGN_X__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG2_MASK_SIGN_X__1 0x1
#define BP_PXP_WFB_ARRAY_FLAG2_MASK_RSVD2      22
#define BM_PXP_WFB_ARRAY_FLAG2_MASK_RSVD2 0x00C00000
#define BF_PXP_WFB_ARRAY_FLAG2_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFB_ARRAY_FLAG2_MASK_RSVD2)
#define BP_PXP_WFB_ARRAY_FLAG2_MASK_OFFSET_Y      20
#define BM_PXP_WFB_ARRAY_FLAG2_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFB_ARRAY_FLAG2_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFB_ARRAY_FLAG2_MASK_OFFSET_Y)
#define BP_PXP_WFB_ARRAY_FLAG2_MASK_RSVD3      18
#define BM_PXP_WFB_ARRAY_FLAG2_MASK_RSVD3 0x000C0000
#define BF_PXP_WFB_ARRAY_FLAG2_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFB_ARRAY_FLAG2_MASK_RSVD3)
#define BP_PXP_WFB_ARRAY_FLAG2_MASK_OFFSET_X      16
#define BM_PXP_WFB_ARRAY_FLAG2_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFB_ARRAY_FLAG2_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFB_ARRAY_FLAG2_MASK_OFFSET_X)
#define BP_PXP_WFB_ARRAY_FLAG2_MASK_RSVD4      13
#define BM_PXP_WFB_ARRAY_FLAG2_MASK_RSVD4 0x0000E000
#define BF_PXP_WFB_ARRAY_FLAG2_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFB_ARRAY_FLAG2_MASK_RSVD4)
#define BP_PXP_WFB_ARRAY_FLAG2_MASK_H_OFS      8
#define BM_PXP_WFB_ARRAY_FLAG2_MASK_H_OFS 0x00001F00
#define BF_PXP_WFB_ARRAY_FLAG2_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFB_ARRAY_FLAG2_MASK_H_OFS)
#define BP_PXP_WFB_ARRAY_FLAG2_MASK_RSVD5      5
#define BM_PXP_WFB_ARRAY_FLAG2_MASK_RSVD5 0x000000E0
#define BF_PXP_WFB_ARRAY_FLAG2_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFB_ARRAY_FLAG2_MASK_RSVD5)
#define BP_PXP_WFB_ARRAY_FLAG2_MASK_L_OFS      0
#define BM_PXP_WFB_ARRAY_FLAG2_MASK_L_OFS 0x0000001F
#define BF_PXP_WFB_ARRAY_FLAG2_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFB_ARRAY_FLAG2_MASK_L_OFS)

#define HW_PXP_WFB_ARRAY_FLAG3_MASK	(0x00001220)

#define BP_PXP_WFB_ARRAY_FLAG3_MASK_RSVD0      30
#define BM_PXP_WFB_ARRAY_FLAG3_MASK_RSVD0 0xC0000000
#define BF_PXP_WFB_ARRAY_FLAG3_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFB_ARRAY_FLAG3_MASK_RSVD0)
#define BP_PXP_WFB_ARRAY_FLAG3_MASK_BUF_SEL      28
#define BM_PXP_WFB_ARRAY_FLAG3_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFB_ARRAY_FLAG3_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFB_ARRAY_FLAG3_MASK_BUF_SEL)
#define BV_PXP_WFB_ARRAY_FLAG3_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG3_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFB_ARRAY_FLAG3_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFB_ARRAY_FLAG3_MASK_RSVD1      26
#define BM_PXP_WFB_ARRAY_FLAG3_MASK_RSVD1 0x0C000000
#define BF_PXP_WFB_ARRAY_FLAG3_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFB_ARRAY_FLAG3_MASK_RSVD1)
#define BM_PXP_WFB_ARRAY_FLAG3_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFB_ARRAY_FLAG3_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFB_ARRAY_FLAG3_MASK_SIGN_Y)
#define BV_PXP_WFB_ARRAY_FLAG3_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG3_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFB_ARRAY_FLAG3_MASK_SIGN_X 0x01000000
#define BF_PXP_WFB_ARRAY_FLAG3_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFB_ARRAY_FLAG3_MASK_SIGN_X)
#define BV_PXP_WFB_ARRAY_FLAG3_MASK_SIGN_X__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG3_MASK_SIGN_X__1 0x1
#define BP_PXP_WFB_ARRAY_FLAG3_MASK_RSVD2      22
#define BM_PXP_WFB_ARRAY_FLAG3_MASK_RSVD2 0x00C00000
#define BF_PXP_WFB_ARRAY_FLAG3_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFB_ARRAY_FLAG3_MASK_RSVD2)
#define BP_PXP_WFB_ARRAY_FLAG3_MASK_OFFSET_Y      20
#define BM_PXP_WFB_ARRAY_FLAG3_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFB_ARRAY_FLAG3_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFB_ARRAY_FLAG3_MASK_OFFSET_Y)
#define BP_PXP_WFB_ARRAY_FLAG3_MASK_RSVD3      18
#define BM_PXP_WFB_ARRAY_FLAG3_MASK_RSVD3 0x000C0000
#define BF_PXP_WFB_ARRAY_FLAG3_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFB_ARRAY_FLAG3_MASK_RSVD3)
#define BP_PXP_WFB_ARRAY_FLAG3_MASK_OFFSET_X      16
#define BM_PXP_WFB_ARRAY_FLAG3_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFB_ARRAY_FLAG3_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFB_ARRAY_FLAG3_MASK_OFFSET_X)
#define BP_PXP_WFB_ARRAY_FLAG3_MASK_RSVD4      13
#define BM_PXP_WFB_ARRAY_FLAG3_MASK_RSVD4 0x0000E000
#define BF_PXP_WFB_ARRAY_FLAG3_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFB_ARRAY_FLAG3_MASK_RSVD4)
#define BP_PXP_WFB_ARRAY_FLAG3_MASK_H_OFS      8
#define BM_PXP_WFB_ARRAY_FLAG3_MASK_H_OFS 0x00001F00
#define BF_PXP_WFB_ARRAY_FLAG3_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFB_ARRAY_FLAG3_MASK_H_OFS)
#define BP_PXP_WFB_ARRAY_FLAG3_MASK_RSVD5      5
#define BM_PXP_WFB_ARRAY_FLAG3_MASK_RSVD5 0x000000E0
#define BF_PXP_WFB_ARRAY_FLAG3_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFB_ARRAY_FLAG3_MASK_RSVD5)
#define BP_PXP_WFB_ARRAY_FLAG3_MASK_L_OFS      0
#define BM_PXP_WFB_ARRAY_FLAG3_MASK_L_OFS 0x0000001F
#define BF_PXP_WFB_ARRAY_FLAG3_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFB_ARRAY_FLAG3_MASK_L_OFS)

#define HW_PXP_WFB_ARRAY_FLAG4_MASK	(0x00001230)

#define BP_PXP_WFB_ARRAY_FLAG4_MASK_RSVD0      30
#define BM_PXP_WFB_ARRAY_FLAG4_MASK_RSVD0 0xC0000000
#define BF_PXP_WFB_ARRAY_FLAG4_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFB_ARRAY_FLAG4_MASK_RSVD0)
#define BP_PXP_WFB_ARRAY_FLAG4_MASK_BUF_SEL      28
#define BM_PXP_WFB_ARRAY_FLAG4_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFB_ARRAY_FLAG4_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFB_ARRAY_FLAG4_MASK_BUF_SEL)
#define BV_PXP_WFB_ARRAY_FLAG4_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG4_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFB_ARRAY_FLAG4_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFB_ARRAY_FLAG4_MASK_RSVD1      26
#define BM_PXP_WFB_ARRAY_FLAG4_MASK_RSVD1 0x0C000000
#define BF_PXP_WFB_ARRAY_FLAG4_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFB_ARRAY_FLAG4_MASK_RSVD1)
#define BM_PXP_WFB_ARRAY_FLAG4_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFB_ARRAY_FLAG4_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFB_ARRAY_FLAG4_MASK_SIGN_Y)
#define BV_PXP_WFB_ARRAY_FLAG4_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG4_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFB_ARRAY_FLAG4_MASK_SIGN_X 0x01000000
#define BF_PXP_WFB_ARRAY_FLAG4_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFB_ARRAY_FLAG4_MASK_SIGN_X)
#define BV_PXP_WFB_ARRAY_FLAG4_MASK_SIGN_X__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG4_MASK_SIGN_X__1 0x1
#define BP_PXP_WFB_ARRAY_FLAG4_MASK_RSVD2      22
#define BM_PXP_WFB_ARRAY_FLAG4_MASK_RSVD2 0x00C00000
#define BF_PXP_WFB_ARRAY_FLAG4_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFB_ARRAY_FLAG4_MASK_RSVD2)
#define BP_PXP_WFB_ARRAY_FLAG4_MASK_OFFSET_Y      20
#define BM_PXP_WFB_ARRAY_FLAG4_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFB_ARRAY_FLAG4_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFB_ARRAY_FLAG4_MASK_OFFSET_Y)
#define BP_PXP_WFB_ARRAY_FLAG4_MASK_RSVD3      18
#define BM_PXP_WFB_ARRAY_FLAG4_MASK_RSVD3 0x000C0000
#define BF_PXP_WFB_ARRAY_FLAG4_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFB_ARRAY_FLAG4_MASK_RSVD3)
#define BP_PXP_WFB_ARRAY_FLAG4_MASK_OFFSET_X      16
#define BM_PXP_WFB_ARRAY_FLAG4_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFB_ARRAY_FLAG4_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFB_ARRAY_FLAG4_MASK_OFFSET_X)
#define BP_PXP_WFB_ARRAY_FLAG4_MASK_RSVD4      13
#define BM_PXP_WFB_ARRAY_FLAG4_MASK_RSVD4 0x0000E000
#define BF_PXP_WFB_ARRAY_FLAG4_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFB_ARRAY_FLAG4_MASK_RSVD4)
#define BP_PXP_WFB_ARRAY_FLAG4_MASK_H_OFS      8
#define BM_PXP_WFB_ARRAY_FLAG4_MASK_H_OFS 0x00001F00
#define BF_PXP_WFB_ARRAY_FLAG4_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFB_ARRAY_FLAG4_MASK_H_OFS)
#define BP_PXP_WFB_ARRAY_FLAG4_MASK_RSVD5      5
#define BM_PXP_WFB_ARRAY_FLAG4_MASK_RSVD5 0x000000E0
#define BF_PXP_WFB_ARRAY_FLAG4_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFB_ARRAY_FLAG4_MASK_RSVD5)
#define BP_PXP_WFB_ARRAY_FLAG4_MASK_L_OFS      0
#define BM_PXP_WFB_ARRAY_FLAG4_MASK_L_OFS 0x0000001F
#define BF_PXP_WFB_ARRAY_FLAG4_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFB_ARRAY_FLAG4_MASK_L_OFS)

#define HW_PXP_WFB_ARRAY_FLAG5_MASK	(0x00001240)

#define BP_PXP_WFB_ARRAY_FLAG5_MASK_RSVD0      30
#define BM_PXP_WFB_ARRAY_FLAG5_MASK_RSVD0 0xC0000000
#define BF_PXP_WFB_ARRAY_FLAG5_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFB_ARRAY_FLAG5_MASK_RSVD0)
#define BP_PXP_WFB_ARRAY_FLAG5_MASK_BUF_SEL      28
#define BM_PXP_WFB_ARRAY_FLAG5_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFB_ARRAY_FLAG5_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFB_ARRAY_FLAG5_MASK_BUF_SEL)
#define BV_PXP_WFB_ARRAY_FLAG5_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG5_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFB_ARRAY_FLAG5_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFB_ARRAY_FLAG5_MASK_RSVD1      26
#define BM_PXP_WFB_ARRAY_FLAG5_MASK_RSVD1 0x0C000000
#define BF_PXP_WFB_ARRAY_FLAG5_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFB_ARRAY_FLAG5_MASK_RSVD1)
#define BM_PXP_WFB_ARRAY_FLAG5_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFB_ARRAY_FLAG5_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFB_ARRAY_FLAG5_MASK_SIGN_Y)
#define BV_PXP_WFB_ARRAY_FLAG5_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG5_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFB_ARRAY_FLAG5_MASK_SIGN_X 0x01000000
#define BF_PXP_WFB_ARRAY_FLAG5_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFB_ARRAY_FLAG5_MASK_SIGN_X)
#define BV_PXP_WFB_ARRAY_FLAG5_MASK_SIGN_X__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG5_MASK_SIGN_X__1 0x1
#define BP_PXP_WFB_ARRAY_FLAG5_MASK_RSVD2      22
#define BM_PXP_WFB_ARRAY_FLAG5_MASK_RSVD2 0x00C00000
#define BF_PXP_WFB_ARRAY_FLAG5_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFB_ARRAY_FLAG5_MASK_RSVD2)
#define BP_PXP_WFB_ARRAY_FLAG5_MASK_OFFSET_Y      20
#define BM_PXP_WFB_ARRAY_FLAG5_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFB_ARRAY_FLAG5_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFB_ARRAY_FLAG5_MASK_OFFSET_Y)
#define BP_PXP_WFB_ARRAY_FLAG5_MASK_RSVD3      18
#define BM_PXP_WFB_ARRAY_FLAG5_MASK_RSVD3 0x000C0000
#define BF_PXP_WFB_ARRAY_FLAG5_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFB_ARRAY_FLAG5_MASK_RSVD3)
#define BP_PXP_WFB_ARRAY_FLAG5_MASK_OFFSET_X      16
#define BM_PXP_WFB_ARRAY_FLAG5_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFB_ARRAY_FLAG5_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFB_ARRAY_FLAG5_MASK_OFFSET_X)
#define BP_PXP_WFB_ARRAY_FLAG5_MASK_RSVD4      13
#define BM_PXP_WFB_ARRAY_FLAG5_MASK_RSVD4 0x0000E000
#define BF_PXP_WFB_ARRAY_FLAG5_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFB_ARRAY_FLAG5_MASK_RSVD4)
#define BP_PXP_WFB_ARRAY_FLAG5_MASK_H_OFS      8
#define BM_PXP_WFB_ARRAY_FLAG5_MASK_H_OFS 0x00001F00
#define BF_PXP_WFB_ARRAY_FLAG5_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFB_ARRAY_FLAG5_MASK_H_OFS)
#define BP_PXP_WFB_ARRAY_FLAG5_MASK_RSVD5      5
#define BM_PXP_WFB_ARRAY_FLAG5_MASK_RSVD5 0x000000E0
#define BF_PXP_WFB_ARRAY_FLAG5_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFB_ARRAY_FLAG5_MASK_RSVD5)
#define BP_PXP_WFB_ARRAY_FLAG5_MASK_L_OFS      0
#define BM_PXP_WFB_ARRAY_FLAG5_MASK_L_OFS 0x0000001F
#define BF_PXP_WFB_ARRAY_FLAG5_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFB_ARRAY_FLAG5_MASK_L_OFS)

#define HW_PXP_WFB_ARRAY_FLAG6_MASK	(0x00001250)

#define BP_PXP_WFB_ARRAY_FLAG6_MASK_RSVD0      30
#define BM_PXP_WFB_ARRAY_FLAG6_MASK_RSVD0 0xC0000000
#define BF_PXP_WFB_ARRAY_FLAG6_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFB_ARRAY_FLAG6_MASK_RSVD0)
#define BP_PXP_WFB_ARRAY_FLAG6_MASK_BUF_SEL      28
#define BM_PXP_WFB_ARRAY_FLAG6_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFB_ARRAY_FLAG6_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFB_ARRAY_FLAG6_MASK_BUF_SEL)
#define BV_PXP_WFB_ARRAY_FLAG6_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG6_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFB_ARRAY_FLAG6_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFB_ARRAY_FLAG6_MASK_RSVD1      26
#define BM_PXP_WFB_ARRAY_FLAG6_MASK_RSVD1 0x0C000000
#define BF_PXP_WFB_ARRAY_FLAG6_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFB_ARRAY_FLAG6_MASK_RSVD1)
#define BM_PXP_WFB_ARRAY_FLAG6_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFB_ARRAY_FLAG6_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFB_ARRAY_FLAG6_MASK_SIGN_Y)
#define BV_PXP_WFB_ARRAY_FLAG6_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG6_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFB_ARRAY_FLAG6_MASK_SIGN_X 0x01000000
#define BF_PXP_WFB_ARRAY_FLAG6_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFB_ARRAY_FLAG6_MASK_SIGN_X)
#define BV_PXP_WFB_ARRAY_FLAG6_MASK_SIGN_X__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG6_MASK_SIGN_X__1 0x1
#define BP_PXP_WFB_ARRAY_FLAG6_MASK_RSVD2      22
#define BM_PXP_WFB_ARRAY_FLAG6_MASK_RSVD2 0x00C00000
#define BF_PXP_WFB_ARRAY_FLAG6_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFB_ARRAY_FLAG6_MASK_RSVD2)
#define BP_PXP_WFB_ARRAY_FLAG6_MASK_OFFSET_Y      20
#define BM_PXP_WFB_ARRAY_FLAG6_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFB_ARRAY_FLAG6_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFB_ARRAY_FLAG6_MASK_OFFSET_Y)
#define BP_PXP_WFB_ARRAY_FLAG6_MASK_RSVD3      18
#define BM_PXP_WFB_ARRAY_FLAG6_MASK_RSVD3 0x000C0000
#define BF_PXP_WFB_ARRAY_FLAG6_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFB_ARRAY_FLAG6_MASK_RSVD3)
#define BP_PXP_WFB_ARRAY_FLAG6_MASK_OFFSET_X      16
#define BM_PXP_WFB_ARRAY_FLAG6_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFB_ARRAY_FLAG6_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFB_ARRAY_FLAG6_MASK_OFFSET_X)
#define BP_PXP_WFB_ARRAY_FLAG6_MASK_RSVD4      13
#define BM_PXP_WFB_ARRAY_FLAG6_MASK_RSVD4 0x0000E000
#define BF_PXP_WFB_ARRAY_FLAG6_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFB_ARRAY_FLAG6_MASK_RSVD4)
#define BP_PXP_WFB_ARRAY_FLAG6_MASK_H_OFS      8
#define BM_PXP_WFB_ARRAY_FLAG6_MASK_H_OFS 0x00001F00
#define BF_PXP_WFB_ARRAY_FLAG6_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFB_ARRAY_FLAG6_MASK_H_OFS)
#define BP_PXP_WFB_ARRAY_FLAG6_MASK_RSVD5      5
#define BM_PXP_WFB_ARRAY_FLAG6_MASK_RSVD5 0x000000E0
#define BF_PXP_WFB_ARRAY_FLAG6_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFB_ARRAY_FLAG6_MASK_RSVD5)
#define BP_PXP_WFB_ARRAY_FLAG6_MASK_L_OFS      0
#define BM_PXP_WFB_ARRAY_FLAG6_MASK_L_OFS 0x0000001F
#define BF_PXP_WFB_ARRAY_FLAG6_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFB_ARRAY_FLAG6_MASK_L_OFS)

#define HW_PXP_WFB_ARRAY_FLAG7_MASK	(0x00001260)

#define BP_PXP_WFB_ARRAY_FLAG7_MASK_RSVD0      30
#define BM_PXP_WFB_ARRAY_FLAG7_MASK_RSVD0 0xC0000000
#define BF_PXP_WFB_ARRAY_FLAG7_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFB_ARRAY_FLAG7_MASK_RSVD0)
#define BP_PXP_WFB_ARRAY_FLAG7_MASK_BUF_SEL      28
#define BM_PXP_WFB_ARRAY_FLAG7_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFB_ARRAY_FLAG7_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFB_ARRAY_FLAG7_MASK_BUF_SEL)
#define BV_PXP_WFB_ARRAY_FLAG7_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG7_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFB_ARRAY_FLAG7_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFB_ARRAY_FLAG7_MASK_RSVD1      26
#define BM_PXP_WFB_ARRAY_FLAG7_MASK_RSVD1 0x0C000000
#define BF_PXP_WFB_ARRAY_FLAG7_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFB_ARRAY_FLAG7_MASK_RSVD1)
#define BM_PXP_WFB_ARRAY_FLAG7_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFB_ARRAY_FLAG7_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFB_ARRAY_FLAG7_MASK_SIGN_Y)
#define BV_PXP_WFB_ARRAY_FLAG7_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG7_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFB_ARRAY_FLAG7_MASK_SIGN_X 0x01000000
#define BF_PXP_WFB_ARRAY_FLAG7_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFB_ARRAY_FLAG7_MASK_SIGN_X)
#define BV_PXP_WFB_ARRAY_FLAG7_MASK_SIGN_X__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG7_MASK_SIGN_X__1 0x1
#define BP_PXP_WFB_ARRAY_FLAG7_MASK_RSVD2      22
#define BM_PXP_WFB_ARRAY_FLAG7_MASK_RSVD2 0x00C00000
#define BF_PXP_WFB_ARRAY_FLAG7_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFB_ARRAY_FLAG7_MASK_RSVD2)
#define BP_PXP_WFB_ARRAY_FLAG7_MASK_OFFSET_Y      20
#define BM_PXP_WFB_ARRAY_FLAG7_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFB_ARRAY_FLAG7_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFB_ARRAY_FLAG7_MASK_OFFSET_Y)
#define BP_PXP_WFB_ARRAY_FLAG7_MASK_RSVD3      18
#define BM_PXP_WFB_ARRAY_FLAG7_MASK_RSVD3 0x000C0000
#define BF_PXP_WFB_ARRAY_FLAG7_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFB_ARRAY_FLAG7_MASK_RSVD3)
#define BP_PXP_WFB_ARRAY_FLAG7_MASK_OFFSET_X      16
#define BM_PXP_WFB_ARRAY_FLAG7_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFB_ARRAY_FLAG7_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFB_ARRAY_FLAG7_MASK_OFFSET_X)
#define BP_PXP_WFB_ARRAY_FLAG7_MASK_RSVD4      13
#define BM_PXP_WFB_ARRAY_FLAG7_MASK_RSVD4 0x0000E000
#define BF_PXP_WFB_ARRAY_FLAG7_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFB_ARRAY_FLAG7_MASK_RSVD4)
#define BP_PXP_WFB_ARRAY_FLAG7_MASK_H_OFS      8
#define BM_PXP_WFB_ARRAY_FLAG7_MASK_H_OFS 0x00001F00
#define BF_PXP_WFB_ARRAY_FLAG7_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFB_ARRAY_FLAG7_MASK_H_OFS)
#define BP_PXP_WFB_ARRAY_FLAG7_MASK_RSVD5      5
#define BM_PXP_WFB_ARRAY_FLAG7_MASK_RSVD5 0x000000E0
#define BF_PXP_WFB_ARRAY_FLAG7_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFB_ARRAY_FLAG7_MASK_RSVD5)
#define BP_PXP_WFB_ARRAY_FLAG7_MASK_L_OFS      0
#define BM_PXP_WFB_ARRAY_FLAG7_MASK_L_OFS 0x0000001F
#define BF_PXP_WFB_ARRAY_FLAG7_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFB_ARRAY_FLAG7_MASK_L_OFS)

#define HW_PXP_WFB_FETCH_BUF1_CORD	(0x00001270)

#define BP_PXP_WFB_FETCH_BUF1_CORD_RSVD0      30
#define BM_PXP_WFB_FETCH_BUF1_CORD_RSVD0 0xC0000000
#define BF_PXP_WFB_FETCH_BUF1_CORD_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFB_FETCH_BUF1_CORD_RSVD0)
#define BP_PXP_WFB_FETCH_BUF1_CORD_YCORD      16
#define BM_PXP_WFB_FETCH_BUF1_CORD_YCORD 0x3FFF0000
#define BF_PXP_WFB_FETCH_BUF1_CORD_YCORD(v)  \
        (((v) << 16) & BM_PXP_WFB_FETCH_BUF1_CORD_YCORD)
#define BP_PXP_WFB_FETCH_BUF1_CORD_RSVD1      14
#define BM_PXP_WFB_FETCH_BUF1_CORD_RSVD1 0x0000C000
#define BF_PXP_WFB_FETCH_BUF1_CORD_RSVD1(v)  \
        (((v) << 14) & BM_PXP_WFB_FETCH_BUF1_CORD_RSVD1)
#define BP_PXP_WFB_FETCH_BUF1_CORD_XCORD      0
#define BM_PXP_WFB_FETCH_BUF1_CORD_XCORD 0x00003FFF
#define BF_PXP_WFB_FETCH_BUF1_CORD_XCORD(v)  \
        (((v) << 0) & BM_PXP_WFB_FETCH_BUF1_CORD_XCORD)

#define HW_PXP_WFB_FETCH_BUF2_CORD	(0x00001280)

#define BP_PXP_WFB_FETCH_BUF2_CORD_RSVD0      30
#define BM_PXP_WFB_FETCH_BUF2_CORD_RSVD0 0xC0000000
#define BF_PXP_WFB_FETCH_BUF2_CORD_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFB_FETCH_BUF2_CORD_RSVD0)
#define BP_PXP_WFB_FETCH_BUF2_CORD_YCORD      16
#define BM_PXP_WFB_FETCH_BUF2_CORD_YCORD 0x3FFF0000
#define BF_PXP_WFB_FETCH_BUF2_CORD_YCORD(v)  \
        (((v) << 16) & BM_PXP_WFB_FETCH_BUF2_CORD_YCORD)
#define BP_PXP_WFB_FETCH_BUF2_CORD_RSVD1      14
#define BM_PXP_WFB_FETCH_BUF2_CORD_RSVD1 0x0000C000
#define BF_PXP_WFB_FETCH_BUF2_CORD_RSVD1(v)  \
        (((v) << 14) & BM_PXP_WFB_FETCH_BUF2_CORD_RSVD1)
#define BP_PXP_WFB_FETCH_BUF2_CORD_XCORD      0
#define BM_PXP_WFB_FETCH_BUF2_CORD_XCORD 0x00003FFF
#define BF_PXP_WFB_FETCH_BUF2_CORD_XCORD(v)  \
        (((v) << 0) & BM_PXP_WFB_FETCH_BUF2_CORD_XCORD)

#define HW_PXP_WFB_ARRAY_FLAG8_MASK	(0x00001290)

#define BP_PXP_WFB_ARRAY_FLAG8_MASK_RSVD0      30
#define BM_PXP_WFB_ARRAY_FLAG8_MASK_RSVD0 0xC0000000
#define BF_PXP_WFB_ARRAY_FLAG8_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFB_ARRAY_FLAG8_MASK_RSVD0)
#define BP_PXP_WFB_ARRAY_FLAG8_MASK_BUF_SEL      28
#define BM_PXP_WFB_ARRAY_FLAG8_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFB_ARRAY_FLAG8_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFB_ARRAY_FLAG8_MASK_BUF_SEL)
#define BV_PXP_WFB_ARRAY_FLAG8_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG8_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFB_ARRAY_FLAG8_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFB_ARRAY_FLAG8_MASK_RSVD1      26
#define BM_PXP_WFB_ARRAY_FLAG8_MASK_RSVD1 0x0C000000
#define BF_PXP_WFB_ARRAY_FLAG8_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFB_ARRAY_FLAG8_MASK_RSVD1)
#define BM_PXP_WFB_ARRAY_FLAG8_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFB_ARRAY_FLAG8_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFB_ARRAY_FLAG8_MASK_SIGN_Y)
#define BV_PXP_WFB_ARRAY_FLAG8_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG8_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFB_ARRAY_FLAG8_MASK_SIGN_X 0x01000000
#define BF_PXP_WFB_ARRAY_FLAG8_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFB_ARRAY_FLAG8_MASK_SIGN_X)
#define BV_PXP_WFB_ARRAY_FLAG8_MASK_SIGN_X__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG8_MASK_SIGN_X__1 0x1
#define BP_PXP_WFB_ARRAY_FLAG8_MASK_RSVD2      22
#define BM_PXP_WFB_ARRAY_FLAG8_MASK_RSVD2 0x00C00000
#define BF_PXP_WFB_ARRAY_FLAG8_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFB_ARRAY_FLAG8_MASK_RSVD2)
#define BP_PXP_WFB_ARRAY_FLAG8_MASK_OFFSET_Y      20
#define BM_PXP_WFB_ARRAY_FLAG8_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFB_ARRAY_FLAG8_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFB_ARRAY_FLAG8_MASK_OFFSET_Y)
#define BP_PXP_WFB_ARRAY_FLAG8_MASK_RSVD3      18
#define BM_PXP_WFB_ARRAY_FLAG8_MASK_RSVD3 0x000C0000
#define BF_PXP_WFB_ARRAY_FLAG8_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFB_ARRAY_FLAG8_MASK_RSVD3)
#define BP_PXP_WFB_ARRAY_FLAG8_MASK_OFFSET_X      16
#define BM_PXP_WFB_ARRAY_FLAG8_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFB_ARRAY_FLAG8_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFB_ARRAY_FLAG8_MASK_OFFSET_X)
#define BP_PXP_WFB_ARRAY_FLAG8_MASK_RSVD4      13
#define BM_PXP_WFB_ARRAY_FLAG8_MASK_RSVD4 0x0000E000
#define BF_PXP_WFB_ARRAY_FLAG8_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFB_ARRAY_FLAG8_MASK_RSVD4)
#define BP_PXP_WFB_ARRAY_FLAG8_MASK_H_OFS      8
#define BM_PXP_WFB_ARRAY_FLAG8_MASK_H_OFS 0x00001F00
#define BF_PXP_WFB_ARRAY_FLAG8_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFB_ARRAY_FLAG8_MASK_H_OFS)
#define BP_PXP_WFB_ARRAY_FLAG8_MASK_RSVD5      5
#define BM_PXP_WFB_ARRAY_FLAG8_MASK_RSVD5 0x000000E0
#define BF_PXP_WFB_ARRAY_FLAG8_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFB_ARRAY_FLAG8_MASK_RSVD5)
#define BP_PXP_WFB_ARRAY_FLAG8_MASK_L_OFS      0
#define BM_PXP_WFB_ARRAY_FLAG8_MASK_L_OFS 0x0000001F
#define BF_PXP_WFB_ARRAY_FLAG8_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFB_ARRAY_FLAG8_MASK_L_OFS)

#define HW_PXP_WFB_ARRAY_FLAG9_MASK	(0x000012a0)

#define BP_PXP_WFB_ARRAY_FLAG9_MASK_RSVD0      30
#define BM_PXP_WFB_ARRAY_FLAG9_MASK_RSVD0 0xC0000000
#define BF_PXP_WFB_ARRAY_FLAG9_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFB_ARRAY_FLAG9_MASK_RSVD0)
#define BP_PXP_WFB_ARRAY_FLAG9_MASK_BUF_SEL      28
#define BM_PXP_WFB_ARRAY_FLAG9_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFB_ARRAY_FLAG9_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFB_ARRAY_FLAG9_MASK_BUF_SEL)
#define BV_PXP_WFB_ARRAY_FLAG9_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG9_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFB_ARRAY_FLAG9_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFB_ARRAY_FLAG9_MASK_RSVD1      26
#define BM_PXP_WFB_ARRAY_FLAG9_MASK_RSVD1 0x0C000000
#define BF_PXP_WFB_ARRAY_FLAG9_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFB_ARRAY_FLAG9_MASK_RSVD1)
#define BM_PXP_WFB_ARRAY_FLAG9_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFB_ARRAY_FLAG9_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFB_ARRAY_FLAG9_MASK_SIGN_Y)
#define BV_PXP_WFB_ARRAY_FLAG9_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG9_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFB_ARRAY_FLAG9_MASK_SIGN_X 0x01000000
#define BF_PXP_WFB_ARRAY_FLAG9_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFB_ARRAY_FLAG9_MASK_SIGN_X)
#define BV_PXP_WFB_ARRAY_FLAG9_MASK_SIGN_X__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG9_MASK_SIGN_X__1 0x1
#define BP_PXP_WFB_ARRAY_FLAG9_MASK_RSVD2      22
#define BM_PXP_WFB_ARRAY_FLAG9_MASK_RSVD2 0x00C00000
#define BF_PXP_WFB_ARRAY_FLAG9_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFB_ARRAY_FLAG9_MASK_RSVD2)
#define BP_PXP_WFB_ARRAY_FLAG9_MASK_OFFSET_Y      20
#define BM_PXP_WFB_ARRAY_FLAG9_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFB_ARRAY_FLAG9_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFB_ARRAY_FLAG9_MASK_OFFSET_Y)
#define BP_PXP_WFB_ARRAY_FLAG9_MASK_RSVD3      18
#define BM_PXP_WFB_ARRAY_FLAG9_MASK_RSVD3 0x000C0000
#define BF_PXP_WFB_ARRAY_FLAG9_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFB_ARRAY_FLAG9_MASK_RSVD3)
#define BP_PXP_WFB_ARRAY_FLAG9_MASK_OFFSET_X      16
#define BM_PXP_WFB_ARRAY_FLAG9_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFB_ARRAY_FLAG9_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFB_ARRAY_FLAG9_MASK_OFFSET_X)
#define BP_PXP_WFB_ARRAY_FLAG9_MASK_RSVD4      13
#define BM_PXP_WFB_ARRAY_FLAG9_MASK_RSVD4 0x0000E000
#define BF_PXP_WFB_ARRAY_FLAG9_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFB_ARRAY_FLAG9_MASK_RSVD4)
#define BP_PXP_WFB_ARRAY_FLAG9_MASK_H_OFS      8
#define BM_PXP_WFB_ARRAY_FLAG9_MASK_H_OFS 0x00001F00
#define BF_PXP_WFB_ARRAY_FLAG9_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFB_ARRAY_FLAG9_MASK_H_OFS)
#define BP_PXP_WFB_ARRAY_FLAG9_MASK_RSVD5      5
#define BM_PXP_WFB_ARRAY_FLAG9_MASK_RSVD5 0x000000E0
#define BF_PXP_WFB_ARRAY_FLAG9_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFB_ARRAY_FLAG9_MASK_RSVD5)
#define BP_PXP_WFB_ARRAY_FLAG9_MASK_L_OFS      0
#define BM_PXP_WFB_ARRAY_FLAG9_MASK_L_OFS 0x0000001F
#define BF_PXP_WFB_ARRAY_FLAG9_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFB_ARRAY_FLAG9_MASK_L_OFS)

#define HW_PXP_WFB_ARRAY_FLAG10_MASK	(0x000012b0)

#define BP_PXP_WFB_ARRAY_FLAG10_MASK_RSVD0      30
#define BM_PXP_WFB_ARRAY_FLAG10_MASK_RSVD0 0xC0000000
#define BF_PXP_WFB_ARRAY_FLAG10_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFB_ARRAY_FLAG10_MASK_RSVD0)
#define BP_PXP_WFB_ARRAY_FLAG10_MASK_BUF_SEL      28
#define BM_PXP_WFB_ARRAY_FLAG10_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFB_ARRAY_FLAG10_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFB_ARRAY_FLAG10_MASK_BUF_SEL)
#define BV_PXP_WFB_ARRAY_FLAG10_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG10_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFB_ARRAY_FLAG10_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFB_ARRAY_FLAG10_MASK_RSVD1      26
#define BM_PXP_WFB_ARRAY_FLAG10_MASK_RSVD1 0x0C000000
#define BF_PXP_WFB_ARRAY_FLAG10_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFB_ARRAY_FLAG10_MASK_RSVD1)
#define BM_PXP_WFB_ARRAY_FLAG10_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFB_ARRAY_FLAG10_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFB_ARRAY_FLAG10_MASK_SIGN_Y)
#define BV_PXP_WFB_ARRAY_FLAG10_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG10_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFB_ARRAY_FLAG10_MASK_SIGN_X 0x01000000
#define BF_PXP_WFB_ARRAY_FLAG10_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFB_ARRAY_FLAG10_MASK_SIGN_X)
#define BV_PXP_WFB_ARRAY_FLAG10_MASK_SIGN_X__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG10_MASK_SIGN_X__1 0x1
#define BP_PXP_WFB_ARRAY_FLAG10_MASK_RSVD2      22
#define BM_PXP_WFB_ARRAY_FLAG10_MASK_RSVD2 0x00C00000
#define BF_PXP_WFB_ARRAY_FLAG10_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFB_ARRAY_FLAG10_MASK_RSVD2)
#define BP_PXP_WFB_ARRAY_FLAG10_MASK_OFFSET_Y      20
#define BM_PXP_WFB_ARRAY_FLAG10_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFB_ARRAY_FLAG10_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFB_ARRAY_FLAG10_MASK_OFFSET_Y)
#define BP_PXP_WFB_ARRAY_FLAG10_MASK_RSVD3      18
#define BM_PXP_WFB_ARRAY_FLAG10_MASK_RSVD3 0x000C0000
#define BF_PXP_WFB_ARRAY_FLAG10_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFB_ARRAY_FLAG10_MASK_RSVD3)
#define BP_PXP_WFB_ARRAY_FLAG10_MASK_OFFSET_X      16
#define BM_PXP_WFB_ARRAY_FLAG10_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFB_ARRAY_FLAG10_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFB_ARRAY_FLAG10_MASK_OFFSET_X)
#define BP_PXP_WFB_ARRAY_FLAG10_MASK_RSVD4      13
#define BM_PXP_WFB_ARRAY_FLAG10_MASK_RSVD4 0x0000E000
#define BF_PXP_WFB_ARRAY_FLAG10_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFB_ARRAY_FLAG10_MASK_RSVD4)
#define BP_PXP_WFB_ARRAY_FLAG10_MASK_H_OFS      8
#define BM_PXP_WFB_ARRAY_FLAG10_MASK_H_OFS 0x00001F00
#define BF_PXP_WFB_ARRAY_FLAG10_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFB_ARRAY_FLAG10_MASK_H_OFS)
#define BP_PXP_WFB_ARRAY_FLAG10_MASK_RSVD5      5
#define BM_PXP_WFB_ARRAY_FLAG10_MASK_RSVD5 0x000000E0
#define BF_PXP_WFB_ARRAY_FLAG10_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFB_ARRAY_FLAG10_MASK_RSVD5)
#define BP_PXP_WFB_ARRAY_FLAG10_MASK_L_OFS      0
#define BM_PXP_WFB_ARRAY_FLAG10_MASK_L_OFS 0x0000001F
#define BF_PXP_WFB_ARRAY_FLAG10_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFB_ARRAY_FLAG10_MASK_L_OFS)

#define HW_PXP_WFB_ARRAY_FLAG11_MASK	(0x000012c0)

#define BP_PXP_WFB_ARRAY_FLAG11_MASK_RSVD0      30
#define BM_PXP_WFB_ARRAY_FLAG11_MASK_RSVD0 0xC0000000
#define BF_PXP_WFB_ARRAY_FLAG11_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFB_ARRAY_FLAG11_MASK_RSVD0)
#define BP_PXP_WFB_ARRAY_FLAG11_MASK_BUF_SEL      28
#define BM_PXP_WFB_ARRAY_FLAG11_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFB_ARRAY_FLAG11_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFB_ARRAY_FLAG11_MASK_BUF_SEL)
#define BV_PXP_WFB_ARRAY_FLAG11_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG11_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFB_ARRAY_FLAG11_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFB_ARRAY_FLAG11_MASK_RSVD1      26
#define BM_PXP_WFB_ARRAY_FLAG11_MASK_RSVD1 0x0C000000
#define BF_PXP_WFB_ARRAY_FLAG11_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFB_ARRAY_FLAG11_MASK_RSVD1)
#define BM_PXP_WFB_ARRAY_FLAG11_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFB_ARRAY_FLAG11_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFB_ARRAY_FLAG11_MASK_SIGN_Y)
#define BV_PXP_WFB_ARRAY_FLAG11_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG11_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFB_ARRAY_FLAG11_MASK_SIGN_X 0x01000000
#define BF_PXP_WFB_ARRAY_FLAG11_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFB_ARRAY_FLAG11_MASK_SIGN_X)
#define BV_PXP_WFB_ARRAY_FLAG11_MASK_SIGN_X__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG11_MASK_SIGN_X__1 0x1
#define BP_PXP_WFB_ARRAY_FLAG11_MASK_RSVD2      22
#define BM_PXP_WFB_ARRAY_FLAG11_MASK_RSVD2 0x00C00000
#define BF_PXP_WFB_ARRAY_FLAG11_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFB_ARRAY_FLAG11_MASK_RSVD2)
#define BP_PXP_WFB_ARRAY_FLAG11_MASK_OFFSET_Y      20
#define BM_PXP_WFB_ARRAY_FLAG11_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFB_ARRAY_FLAG11_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFB_ARRAY_FLAG11_MASK_OFFSET_Y)
#define BP_PXP_WFB_ARRAY_FLAG11_MASK_RSVD3      18
#define BM_PXP_WFB_ARRAY_FLAG11_MASK_RSVD3 0x000C0000
#define BF_PXP_WFB_ARRAY_FLAG11_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFB_ARRAY_FLAG11_MASK_RSVD3)
#define BP_PXP_WFB_ARRAY_FLAG11_MASK_OFFSET_X      16
#define BM_PXP_WFB_ARRAY_FLAG11_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFB_ARRAY_FLAG11_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFB_ARRAY_FLAG11_MASK_OFFSET_X)
#define BP_PXP_WFB_ARRAY_FLAG11_MASK_RSVD4      13
#define BM_PXP_WFB_ARRAY_FLAG11_MASK_RSVD4 0x0000E000
#define BF_PXP_WFB_ARRAY_FLAG11_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFB_ARRAY_FLAG11_MASK_RSVD4)
#define BP_PXP_WFB_ARRAY_FLAG11_MASK_H_OFS      8
#define BM_PXP_WFB_ARRAY_FLAG11_MASK_H_OFS 0x00001F00
#define BF_PXP_WFB_ARRAY_FLAG11_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFB_ARRAY_FLAG11_MASK_H_OFS)
#define BP_PXP_WFB_ARRAY_FLAG11_MASK_RSVD5      5
#define BM_PXP_WFB_ARRAY_FLAG11_MASK_RSVD5 0x000000E0
#define BF_PXP_WFB_ARRAY_FLAG11_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFB_ARRAY_FLAG11_MASK_RSVD5)
#define BP_PXP_WFB_ARRAY_FLAG11_MASK_L_OFS      0
#define BM_PXP_WFB_ARRAY_FLAG11_MASK_L_OFS 0x0000001F
#define BF_PXP_WFB_ARRAY_FLAG11_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFB_ARRAY_FLAG11_MASK_L_OFS)

#define HW_PXP_WFB_ARRAY_FLAG12_MASK	(0x000012d0)

#define BP_PXP_WFB_ARRAY_FLAG12_MASK_RSVD0      30
#define BM_PXP_WFB_ARRAY_FLAG12_MASK_RSVD0 0xC0000000
#define BF_PXP_WFB_ARRAY_FLAG12_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFB_ARRAY_FLAG12_MASK_RSVD0)
#define BP_PXP_WFB_ARRAY_FLAG12_MASK_BUF_SEL      28
#define BM_PXP_WFB_ARRAY_FLAG12_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFB_ARRAY_FLAG12_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFB_ARRAY_FLAG12_MASK_BUF_SEL)
#define BV_PXP_WFB_ARRAY_FLAG12_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG12_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFB_ARRAY_FLAG12_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFB_ARRAY_FLAG12_MASK_RSVD1      26
#define BM_PXP_WFB_ARRAY_FLAG12_MASK_RSVD1 0x0C000000
#define BF_PXP_WFB_ARRAY_FLAG12_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFB_ARRAY_FLAG12_MASK_RSVD1)
#define BM_PXP_WFB_ARRAY_FLAG12_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFB_ARRAY_FLAG12_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFB_ARRAY_FLAG12_MASK_SIGN_Y)
#define BV_PXP_WFB_ARRAY_FLAG12_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG12_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFB_ARRAY_FLAG12_MASK_SIGN_X 0x01000000
#define BF_PXP_WFB_ARRAY_FLAG12_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFB_ARRAY_FLAG12_MASK_SIGN_X)
#define BV_PXP_WFB_ARRAY_FLAG12_MASK_SIGN_X__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG12_MASK_SIGN_X__1 0x1
#define BP_PXP_WFB_ARRAY_FLAG12_MASK_RSVD2      22
#define BM_PXP_WFB_ARRAY_FLAG12_MASK_RSVD2 0x00C00000
#define BF_PXP_WFB_ARRAY_FLAG12_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFB_ARRAY_FLAG12_MASK_RSVD2)
#define BP_PXP_WFB_ARRAY_FLAG12_MASK_OFFSET_Y      20
#define BM_PXP_WFB_ARRAY_FLAG12_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFB_ARRAY_FLAG12_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFB_ARRAY_FLAG12_MASK_OFFSET_Y)
#define BP_PXP_WFB_ARRAY_FLAG12_MASK_RSVD3      18
#define BM_PXP_WFB_ARRAY_FLAG12_MASK_RSVD3 0x000C0000
#define BF_PXP_WFB_ARRAY_FLAG12_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFB_ARRAY_FLAG12_MASK_RSVD3)
#define BP_PXP_WFB_ARRAY_FLAG12_MASK_OFFSET_X      16
#define BM_PXP_WFB_ARRAY_FLAG12_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFB_ARRAY_FLAG12_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFB_ARRAY_FLAG12_MASK_OFFSET_X)
#define BP_PXP_WFB_ARRAY_FLAG12_MASK_RSVD4      13
#define BM_PXP_WFB_ARRAY_FLAG12_MASK_RSVD4 0x0000E000
#define BF_PXP_WFB_ARRAY_FLAG12_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFB_ARRAY_FLAG12_MASK_RSVD4)
#define BP_PXP_WFB_ARRAY_FLAG12_MASK_H_OFS      8
#define BM_PXP_WFB_ARRAY_FLAG12_MASK_H_OFS 0x00001F00
#define BF_PXP_WFB_ARRAY_FLAG12_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFB_ARRAY_FLAG12_MASK_H_OFS)
#define BP_PXP_WFB_ARRAY_FLAG12_MASK_RSVD5      5
#define BM_PXP_WFB_ARRAY_FLAG12_MASK_RSVD5 0x000000E0
#define BF_PXP_WFB_ARRAY_FLAG12_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFB_ARRAY_FLAG12_MASK_RSVD5)
#define BP_PXP_WFB_ARRAY_FLAG12_MASK_L_OFS      0
#define BM_PXP_WFB_ARRAY_FLAG12_MASK_L_OFS 0x0000001F
#define BF_PXP_WFB_ARRAY_FLAG12_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFB_ARRAY_FLAG12_MASK_L_OFS)

#define HW_PXP_WFB_ARRAY_FLAG13_MASK	(0x000012e0)

#define BP_PXP_WFB_ARRAY_FLAG13_MASK_RSVD0      30
#define BM_PXP_WFB_ARRAY_FLAG13_MASK_RSVD0 0xC0000000
#define BF_PXP_WFB_ARRAY_FLAG13_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFB_ARRAY_FLAG13_MASK_RSVD0)
#define BP_PXP_WFB_ARRAY_FLAG13_MASK_BUF_SEL      28
#define BM_PXP_WFB_ARRAY_FLAG13_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFB_ARRAY_FLAG13_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFB_ARRAY_FLAG13_MASK_BUF_SEL)
#define BV_PXP_WFB_ARRAY_FLAG13_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG13_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFB_ARRAY_FLAG13_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFB_ARRAY_FLAG13_MASK_RSVD1      26
#define BM_PXP_WFB_ARRAY_FLAG13_MASK_RSVD1 0x0C000000
#define BF_PXP_WFB_ARRAY_FLAG13_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFB_ARRAY_FLAG13_MASK_RSVD1)
#define BM_PXP_WFB_ARRAY_FLAG13_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFB_ARRAY_FLAG13_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFB_ARRAY_FLAG13_MASK_SIGN_Y)
#define BV_PXP_WFB_ARRAY_FLAG13_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG13_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFB_ARRAY_FLAG13_MASK_SIGN_X 0x01000000
#define BF_PXP_WFB_ARRAY_FLAG13_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFB_ARRAY_FLAG13_MASK_SIGN_X)
#define BV_PXP_WFB_ARRAY_FLAG13_MASK_SIGN_X__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG13_MASK_SIGN_X__1 0x1
#define BP_PXP_WFB_ARRAY_FLAG13_MASK_RSVD2      22
#define BM_PXP_WFB_ARRAY_FLAG13_MASK_RSVD2 0x00C00000
#define BF_PXP_WFB_ARRAY_FLAG13_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFB_ARRAY_FLAG13_MASK_RSVD2)
#define BP_PXP_WFB_ARRAY_FLAG13_MASK_OFFSET_Y      20
#define BM_PXP_WFB_ARRAY_FLAG13_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFB_ARRAY_FLAG13_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFB_ARRAY_FLAG13_MASK_OFFSET_Y)
#define BP_PXP_WFB_ARRAY_FLAG13_MASK_RSVD3      18
#define BM_PXP_WFB_ARRAY_FLAG13_MASK_RSVD3 0x000C0000
#define BF_PXP_WFB_ARRAY_FLAG13_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFB_ARRAY_FLAG13_MASK_RSVD3)
#define BP_PXP_WFB_ARRAY_FLAG13_MASK_OFFSET_X      16
#define BM_PXP_WFB_ARRAY_FLAG13_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFB_ARRAY_FLAG13_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFB_ARRAY_FLAG13_MASK_OFFSET_X)
#define BP_PXP_WFB_ARRAY_FLAG13_MASK_RSVD4      13
#define BM_PXP_WFB_ARRAY_FLAG13_MASK_RSVD4 0x0000E000
#define BF_PXP_WFB_ARRAY_FLAG13_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFB_ARRAY_FLAG13_MASK_RSVD4)
#define BP_PXP_WFB_ARRAY_FLAG13_MASK_H_OFS      8
#define BM_PXP_WFB_ARRAY_FLAG13_MASK_H_OFS 0x00001F00
#define BF_PXP_WFB_ARRAY_FLAG13_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFB_ARRAY_FLAG13_MASK_H_OFS)
#define BP_PXP_WFB_ARRAY_FLAG13_MASK_RSVD5      5
#define BM_PXP_WFB_ARRAY_FLAG13_MASK_RSVD5 0x000000E0
#define BF_PXP_WFB_ARRAY_FLAG13_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFB_ARRAY_FLAG13_MASK_RSVD5)
#define BP_PXP_WFB_ARRAY_FLAG13_MASK_L_OFS      0
#define BM_PXP_WFB_ARRAY_FLAG13_MASK_L_OFS 0x0000001F
#define BF_PXP_WFB_ARRAY_FLAG13_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFB_ARRAY_FLAG13_MASK_L_OFS)

#define HW_PXP_WFB_ARRAY_FLAG14_MASK	(0x000012f0)

#define BP_PXP_WFB_ARRAY_FLAG14_MASK_RSVD0      30
#define BM_PXP_WFB_ARRAY_FLAG14_MASK_RSVD0 0xC0000000
#define BF_PXP_WFB_ARRAY_FLAG14_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFB_ARRAY_FLAG14_MASK_RSVD0)
#define BP_PXP_WFB_ARRAY_FLAG14_MASK_BUF_SEL      28
#define BM_PXP_WFB_ARRAY_FLAG14_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFB_ARRAY_FLAG14_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFB_ARRAY_FLAG14_MASK_BUF_SEL)
#define BV_PXP_WFB_ARRAY_FLAG14_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG14_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFB_ARRAY_FLAG14_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFB_ARRAY_FLAG14_MASK_RSVD1      26
#define BM_PXP_WFB_ARRAY_FLAG14_MASK_RSVD1 0x0C000000
#define BF_PXP_WFB_ARRAY_FLAG14_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFB_ARRAY_FLAG14_MASK_RSVD1)
#define BM_PXP_WFB_ARRAY_FLAG14_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFB_ARRAY_FLAG14_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFB_ARRAY_FLAG14_MASK_SIGN_Y)
#define BV_PXP_WFB_ARRAY_FLAG14_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG14_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFB_ARRAY_FLAG14_MASK_SIGN_X 0x01000000
#define BF_PXP_WFB_ARRAY_FLAG14_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFB_ARRAY_FLAG14_MASK_SIGN_X)
#define BV_PXP_WFB_ARRAY_FLAG14_MASK_SIGN_X__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG14_MASK_SIGN_X__1 0x1
#define BP_PXP_WFB_ARRAY_FLAG14_MASK_RSVD2      22
#define BM_PXP_WFB_ARRAY_FLAG14_MASK_RSVD2 0x00C00000
#define BF_PXP_WFB_ARRAY_FLAG14_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFB_ARRAY_FLAG14_MASK_RSVD2)
#define BP_PXP_WFB_ARRAY_FLAG14_MASK_OFFSET_Y      20
#define BM_PXP_WFB_ARRAY_FLAG14_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFB_ARRAY_FLAG14_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFB_ARRAY_FLAG14_MASK_OFFSET_Y)
#define BP_PXP_WFB_ARRAY_FLAG14_MASK_RSVD3      18
#define BM_PXP_WFB_ARRAY_FLAG14_MASK_RSVD3 0x000C0000
#define BF_PXP_WFB_ARRAY_FLAG14_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFB_ARRAY_FLAG14_MASK_RSVD3)
#define BP_PXP_WFB_ARRAY_FLAG14_MASK_OFFSET_X      16
#define BM_PXP_WFB_ARRAY_FLAG14_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFB_ARRAY_FLAG14_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFB_ARRAY_FLAG14_MASK_OFFSET_X)
#define BP_PXP_WFB_ARRAY_FLAG14_MASK_RSVD4      13
#define BM_PXP_WFB_ARRAY_FLAG14_MASK_RSVD4 0x0000E000
#define BF_PXP_WFB_ARRAY_FLAG14_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFB_ARRAY_FLAG14_MASK_RSVD4)
#define BP_PXP_WFB_ARRAY_FLAG14_MASK_H_OFS      8
#define BM_PXP_WFB_ARRAY_FLAG14_MASK_H_OFS 0x00001F00
#define BF_PXP_WFB_ARRAY_FLAG14_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFB_ARRAY_FLAG14_MASK_H_OFS)
#define BP_PXP_WFB_ARRAY_FLAG14_MASK_RSVD5      5
#define BM_PXP_WFB_ARRAY_FLAG14_MASK_RSVD5 0x000000E0
#define BF_PXP_WFB_ARRAY_FLAG14_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFB_ARRAY_FLAG14_MASK_RSVD5)
#define BP_PXP_WFB_ARRAY_FLAG14_MASK_L_OFS      0
#define BM_PXP_WFB_ARRAY_FLAG14_MASK_L_OFS 0x0000001F
#define BF_PXP_WFB_ARRAY_FLAG14_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFB_ARRAY_FLAG14_MASK_L_OFS)

#define HW_PXP_WFB_ARRAY_FLAG15_MASK	(0x00001300)

#define BP_PXP_WFB_ARRAY_FLAG15_MASK_RSVD0      30
#define BM_PXP_WFB_ARRAY_FLAG15_MASK_RSVD0 0xC0000000
#define BF_PXP_WFB_ARRAY_FLAG15_MASK_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFB_ARRAY_FLAG15_MASK_RSVD0)
#define BP_PXP_WFB_ARRAY_FLAG15_MASK_BUF_SEL      28
#define BM_PXP_WFB_ARRAY_FLAG15_MASK_BUF_SEL 0x30000000
#define BF_PXP_WFB_ARRAY_FLAG15_MASK_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_WFB_ARRAY_FLAG15_MASK_BUF_SEL)
#define BV_PXP_WFB_ARRAY_FLAG15_MASK_BUF_SEL__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG15_MASK_BUF_SEL__1 0x1
#define BV_PXP_WFB_ARRAY_FLAG15_MASK_BUF_SEL__2 0x2
#define BP_PXP_WFB_ARRAY_FLAG15_MASK_RSVD1      26
#define BM_PXP_WFB_ARRAY_FLAG15_MASK_RSVD1 0x0C000000
#define BF_PXP_WFB_ARRAY_FLAG15_MASK_RSVD1(v)  \
        (((v) << 26) & BM_PXP_WFB_ARRAY_FLAG15_MASK_RSVD1)
#define BM_PXP_WFB_ARRAY_FLAG15_MASK_SIGN_Y 0x02000000
#define BF_PXP_WFB_ARRAY_FLAG15_MASK_SIGN_Y(v)  \
        (((v) << 25) & BM_PXP_WFB_ARRAY_FLAG15_MASK_SIGN_Y)
#define BV_PXP_WFB_ARRAY_FLAG15_MASK_SIGN_Y__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG15_MASK_SIGN_Y__1 0x1
#define BM_PXP_WFB_ARRAY_FLAG15_MASK_SIGN_X 0x01000000
#define BF_PXP_WFB_ARRAY_FLAG15_MASK_SIGN_X(v)  \
        (((v) << 24) & BM_PXP_WFB_ARRAY_FLAG15_MASK_SIGN_X)
#define BV_PXP_WFB_ARRAY_FLAG15_MASK_SIGN_X__0 0x0
#define BV_PXP_WFB_ARRAY_FLAG15_MASK_SIGN_X__1 0x1
#define BP_PXP_WFB_ARRAY_FLAG15_MASK_RSVD2      22
#define BM_PXP_WFB_ARRAY_FLAG15_MASK_RSVD2 0x00C00000
#define BF_PXP_WFB_ARRAY_FLAG15_MASK_RSVD2(v)  \
        (((v) << 22) & BM_PXP_WFB_ARRAY_FLAG15_MASK_RSVD2)
#define BP_PXP_WFB_ARRAY_FLAG15_MASK_OFFSET_Y      20
#define BM_PXP_WFB_ARRAY_FLAG15_MASK_OFFSET_Y 0x00300000
#define BF_PXP_WFB_ARRAY_FLAG15_MASK_OFFSET_Y(v)  \
        (((v) << 20) & BM_PXP_WFB_ARRAY_FLAG15_MASK_OFFSET_Y)
#define BP_PXP_WFB_ARRAY_FLAG15_MASK_RSVD3      18
#define BM_PXP_WFB_ARRAY_FLAG15_MASK_RSVD3 0x000C0000
#define BF_PXP_WFB_ARRAY_FLAG15_MASK_RSVD3(v)  \
        (((v) << 18) & BM_PXP_WFB_ARRAY_FLAG15_MASK_RSVD3)
#define BP_PXP_WFB_ARRAY_FLAG15_MASK_OFFSET_X      16
#define BM_PXP_WFB_ARRAY_FLAG15_MASK_OFFSET_X 0x00030000
#define BF_PXP_WFB_ARRAY_FLAG15_MASK_OFFSET_X(v)  \
        (((v) << 16) & BM_PXP_WFB_ARRAY_FLAG15_MASK_OFFSET_X)
#define BP_PXP_WFB_ARRAY_FLAG15_MASK_RSVD4      13
#define BM_PXP_WFB_ARRAY_FLAG15_MASK_RSVD4 0x0000E000
#define BF_PXP_WFB_ARRAY_FLAG15_MASK_RSVD4(v)  \
        (((v) << 13) & BM_PXP_WFB_ARRAY_FLAG15_MASK_RSVD4)
#define BP_PXP_WFB_ARRAY_FLAG15_MASK_H_OFS      8
#define BM_PXP_WFB_ARRAY_FLAG15_MASK_H_OFS 0x00001F00
#define BF_PXP_WFB_ARRAY_FLAG15_MASK_H_OFS(v)  \
        (((v) << 8) & BM_PXP_WFB_ARRAY_FLAG15_MASK_H_OFS)
#define BP_PXP_WFB_ARRAY_FLAG15_MASK_RSVD5      5
#define BM_PXP_WFB_ARRAY_FLAG15_MASK_RSVD5 0x000000E0
#define BF_PXP_WFB_ARRAY_FLAG15_MASK_RSVD5(v)  \
        (((v) << 5) & BM_PXP_WFB_ARRAY_FLAG15_MASK_RSVD5)
#define BP_PXP_WFB_ARRAY_FLAG15_MASK_L_OFS      0
#define BM_PXP_WFB_ARRAY_FLAG15_MASK_L_OFS 0x0000001F
#define BF_PXP_WFB_ARRAY_FLAG15_MASK_L_OFS(v)  \
        (((v) << 0) & BM_PXP_WFB_ARRAY_FLAG15_MASK_L_OFS)

#define HW_PXP_WFB_ARRAY_REG0	(0x00001310)

#define BP_PXP_WFB_ARRAY_REG0_SW_PIXLE3      24
#define BM_PXP_WFB_ARRAY_REG0_SW_PIXLE3 0xFF000000
#define BF_PXP_WFB_ARRAY_REG0_SW_PIXLE3(v) \
        (((v) << 24) & BM_PXP_WFB_ARRAY_REG0_SW_PIXLE3)
#define BP_PXP_WFB_ARRAY_REG0_SW_PIXLE2      16
#define BM_PXP_WFB_ARRAY_REG0_SW_PIXLE2 0x00FF0000
#define BF_PXP_WFB_ARRAY_REG0_SW_PIXLE2(v)  \
        (((v) << 16) & BM_PXP_WFB_ARRAY_REG0_SW_PIXLE2)
#define BP_PXP_WFB_ARRAY_REG0_SW_PIXLE1      8
#define BM_PXP_WFB_ARRAY_REG0_SW_PIXLE1 0x0000FF00
#define BF_PXP_WFB_ARRAY_REG0_SW_PIXLE1(v)  \
        (((v) << 8) & BM_PXP_WFB_ARRAY_REG0_SW_PIXLE1)
#define BP_PXP_WFB_ARRAY_REG0_SW_PIXLE0      0
#define BM_PXP_WFB_ARRAY_REG0_SW_PIXLE0 0x000000FF
#define BF_PXP_WFB_ARRAY_REG0_SW_PIXLE0(v)  \
        (((v) << 0) & BM_PXP_WFB_ARRAY_REG0_SW_PIXLE0)

#define HW_PXP_WFB_ARRAY_REG1	(0x00001320)

#define BP_PXP_WFB_ARRAY_REG1_SW_PIXLE7      24
#define BM_PXP_WFB_ARRAY_REG1_SW_PIXLE7 0xFF000000
#define BF_PXP_WFB_ARRAY_REG1_SW_PIXLE7(v) \
        (((v) << 24) & BM_PXP_WFB_ARRAY_REG1_SW_PIXLE7)
#define BP_PXP_WFB_ARRAY_REG1_SW_PIXLE6      16
#define BM_PXP_WFB_ARRAY_REG1_SW_PIXLE6 0x00FF0000
#define BF_PXP_WFB_ARRAY_REG1_SW_PIXLE6(v)  \
        (((v) << 16) & BM_PXP_WFB_ARRAY_REG1_SW_PIXLE6)
#define BP_PXP_WFB_ARRAY_REG1_SW_PIXLE5      8
#define BM_PXP_WFB_ARRAY_REG1_SW_PIXLE5 0x0000FF00
#define BF_PXP_WFB_ARRAY_REG1_SW_PIXLE5(v)  \
        (((v) << 8) & BM_PXP_WFB_ARRAY_REG1_SW_PIXLE5)
#define BP_PXP_WFB_ARRAY_REG1_SW_PIXLE4      0
#define BM_PXP_WFB_ARRAY_REG1_SW_PIXLE4 0x000000FF
#define BF_PXP_WFB_ARRAY_REG1_SW_PIXLE4(v)  \
        (((v) << 0) & BM_PXP_WFB_ARRAY_REG1_SW_PIXLE4)

#define HW_PXP_WFB_ARRAY_REG2	(0x00001330)

#define BP_PXP_WFB_ARRAY_REG2_RSVD0      16
#define BM_PXP_WFB_ARRAY_REG2_RSVD0 0xFFFF0000
#define BF_PXP_WFB_ARRAY_REG2_RSVD0(v) \
        (((v) << 16) & BM_PXP_WFB_ARRAY_REG2_RSVD0)
#define BM_PXP_WFB_ARRAY_REG2_SW_FLAG15 0x00008000
#define BF_PXP_WFB_ARRAY_REG2_SW_FLAG15(v)  \
        (((v) << 15) & BM_PXP_WFB_ARRAY_REG2_SW_FLAG15)
#define BM_PXP_WFB_ARRAY_REG2_SW_FLAG14 0x00004000
#define BF_PXP_WFB_ARRAY_REG2_SW_FLAG14(v)  \
        (((v) << 14) & BM_PXP_WFB_ARRAY_REG2_SW_FLAG14)
#define BM_PXP_WFB_ARRAY_REG2_SW_FLAG13 0x00002000
#define BF_PXP_WFB_ARRAY_REG2_SW_FLAG13(v)  \
        (((v) << 13) & BM_PXP_WFB_ARRAY_REG2_SW_FLAG13)
#define BM_PXP_WFB_ARRAY_REG2_SW_FLAG12 0x00001000
#define BF_PXP_WFB_ARRAY_REG2_SW_FLAG12(v)  \
        (((v) << 12) & BM_PXP_WFB_ARRAY_REG2_SW_FLAG12)
#define BM_PXP_WFB_ARRAY_REG2_SW_FLAG11 0x00000800
#define BF_PXP_WFB_ARRAY_REG2_SW_FLAG11(v)  \
        (((v) << 11) & BM_PXP_WFB_ARRAY_REG2_SW_FLAG11)
#define BM_PXP_WFB_ARRAY_REG2_SW_FLAG10 0x00000400
#define BF_PXP_WFB_ARRAY_REG2_SW_FLAG10(v)  \
        (((v) << 10) & BM_PXP_WFB_ARRAY_REG2_SW_FLAG10)
#define BM_PXP_WFB_ARRAY_REG2_SW_FLAG9 0x00000200
#define BF_PXP_WFB_ARRAY_REG2_SW_FLAG9(v)  \
        (((v) << 9) & BM_PXP_WFB_ARRAY_REG2_SW_FLAG9)
#define BM_PXP_WFB_ARRAY_REG2_SW_FLAG8 0x00000100
#define BF_PXP_WFB_ARRAY_REG2_SW_FLAG8(v)  \
        (((v) << 8) & BM_PXP_WFB_ARRAY_REG2_SW_FLAG8)
#define BM_PXP_WFB_ARRAY_REG2_SW_FLAG7 0x00000080
#define BF_PXP_WFB_ARRAY_REG2_SW_FLAG7(v)  \
        (((v) << 7) & BM_PXP_WFB_ARRAY_REG2_SW_FLAG7)
#define BM_PXP_WFB_ARRAY_REG2_SW_FLAG6 0x00000040
#define BF_PXP_WFB_ARRAY_REG2_SW_FLAG6(v)  \
        (((v) << 6) & BM_PXP_WFB_ARRAY_REG2_SW_FLAG6)
#define BM_PXP_WFB_ARRAY_REG2_SW_FLAG5 0x00000020
#define BF_PXP_WFB_ARRAY_REG2_SW_FLAG5(v)  \
        (((v) << 5) & BM_PXP_WFB_ARRAY_REG2_SW_FLAG5)
#define BM_PXP_WFB_ARRAY_REG2_SW_FLAG4 0x00000010
#define BF_PXP_WFB_ARRAY_REG2_SW_FLAG4(v)  \
        (((v) << 4) & BM_PXP_WFB_ARRAY_REG2_SW_FLAG4)
#define BM_PXP_WFB_ARRAY_REG2_SW_FLAG3 0x00000008
#define BF_PXP_WFB_ARRAY_REG2_SW_FLAG3(v)  \
        (((v) << 3) & BM_PXP_WFB_ARRAY_REG2_SW_FLAG3)
#define BM_PXP_WFB_ARRAY_REG2_SW_FLAG2 0x00000004
#define BF_PXP_WFB_ARRAY_REG2_SW_FLAG2(v)  \
        (((v) << 2) & BM_PXP_WFB_ARRAY_REG2_SW_FLAG2)
#define BM_PXP_WFB_ARRAY_REG2_SW_FLAG1 0x00000002
#define BF_PXP_WFB_ARRAY_REG2_SW_FLAG1(v)  \
        (((v) << 1) & BM_PXP_WFB_ARRAY_REG2_SW_FLAG1)
#define BM_PXP_WFB_ARRAY_REG2_SW_FLAG0 0x00000001
#define BF_PXP_WFB_ARRAY_REG2_SW_FLAG0(v)  \
        (((v) << 0) & BM_PXP_WFB_ARRAY_REG2_SW_FLAG0)

#define HW_PXP_WFE_B_STORE_CTRL_CH0	(0x00001340)
#define HW_PXP_WFE_B_STORE_CTRL_CH0_SET	(0x00001344)
#define HW_PXP_WFE_B_STORE_CTRL_CH0_CLR	(0x00001348)
#define HW_PXP_WFE_B_STORE_CTRL_CH0_TOG	(0x0000134c)

#define BM_PXP_WFE_B_STORE_CTRL_CH0_ARBIT_EN 0x80000000
#define BF_PXP_WFE_B_STORE_CTRL_CH0_ARBIT_EN(v) \
        (((v) << 31) & BM_PXP_WFE_B_STORE_CTRL_CH0_ARBIT_EN)
#define BV_PXP_WFE_B_STORE_CTRL_CH0_ARBIT_EN__0 0x0
#define BV_PXP_WFE_B_STORE_CTRL_CH0_ARBIT_EN__1 0x1
#define BP_PXP_WFE_B_STORE_CTRL_CH0_RSVD0      25
#define BM_PXP_WFE_B_STORE_CTRL_CH0_RSVD0 0x7E000000
#define BF_PXP_WFE_B_STORE_CTRL_CH0_RSVD0(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STORE_CTRL_CH0_RSVD0)
#define BM_PXP_WFE_B_STORE_CTRL_CH0_COMBINE_2CHANNEL 0x01000000
#define BF_PXP_WFE_B_STORE_CTRL_CH0_COMBINE_2CHANNEL(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STORE_CTRL_CH0_COMBINE_2CHANNEL)
#define BV_PXP_WFE_B_STORE_CTRL_CH0_COMBINE_2CHANNEL__0 0x0
#define BV_PXP_WFE_B_STORE_CTRL_CH0_COMBINE_2CHANNEL__1 0x1
#define BP_PXP_WFE_B_STORE_CTRL_CH0_RSVD1      18
#define BM_PXP_WFE_B_STORE_CTRL_CH0_RSVD1 0x00FC0000
#define BF_PXP_WFE_B_STORE_CTRL_CH0_RSVD1(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STORE_CTRL_CH0_RSVD1)
#define BP_PXP_WFE_B_STORE_CTRL_CH0_WR_NUM_BYTES      16
#define BM_PXP_WFE_B_STORE_CTRL_CH0_WR_NUM_BYTES 0x00030000
#define BF_PXP_WFE_B_STORE_CTRL_CH0_WR_NUM_BYTES(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STORE_CTRL_CH0_WR_NUM_BYTES)
#define BV_PXP_WFE_B_STORE_CTRL_CH0_WR_NUM_BYTES__8_bytes  0x0
#define BV_PXP_WFE_B_STORE_CTRL_CH0_WR_NUM_BYTES__16_bytes 0x1
#define BV_PXP_WFE_B_STORE_CTRL_CH0_WR_NUM_BYTES__32_bytes 0x2
#define BV_PXP_WFE_B_STORE_CTRL_CH0_WR_NUM_BYTES__64_bytes 0x3
#define BP_PXP_WFE_B_STORE_CTRL_CH0_RSVD2      12
#define BM_PXP_WFE_B_STORE_CTRL_CH0_RSVD2 0x0000F000
#define BF_PXP_WFE_B_STORE_CTRL_CH0_RSVD2(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STORE_CTRL_CH0_RSVD2)
#define BM_PXP_WFE_B_STORE_CTRL_CH0_FILL_DATA_EN 0x00000800
#define BF_PXP_WFE_B_STORE_CTRL_CH0_FILL_DATA_EN(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STORE_CTRL_CH0_FILL_DATA_EN)
#define BV_PXP_WFE_B_STORE_CTRL_CH0_FILL_DATA_EN__0 0x0
#define BV_PXP_WFE_B_STORE_CTRL_CH0_FILL_DATA_EN__1 0x1
#define BM_PXP_WFE_B_STORE_CTRL_CH0_PACK_IN_SEL 0x00000400
#define BF_PXP_WFE_B_STORE_CTRL_CH0_PACK_IN_SEL(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STORE_CTRL_CH0_PACK_IN_SEL)
#define BV_PXP_WFE_B_STORE_CTRL_CH0_PACK_IN_SEL__0 0x0
#define BV_PXP_WFE_B_STORE_CTRL_CH0_PACK_IN_SEL__1 0x1
#define BM_PXP_WFE_B_STORE_CTRL_CH0_STORE_MEMORY_EN 0x00000200
#define BF_PXP_WFE_B_STORE_CTRL_CH0_STORE_MEMORY_EN(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STORE_CTRL_CH0_STORE_MEMORY_EN)
#define BV_PXP_WFE_B_STORE_CTRL_CH0_STORE_MEMORY_EN__0 0x0
#define BV_PXP_WFE_B_STORE_CTRL_CH0_STORE_MEMORY_EN__1 0x1
#define BM_PXP_WFE_B_STORE_CTRL_CH0_STORE_BYPASS_EN 0x00000100
#define BF_PXP_WFE_B_STORE_CTRL_CH0_STORE_BYPASS_EN(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STORE_CTRL_CH0_STORE_BYPASS_EN)
#define BV_PXP_WFE_B_STORE_CTRL_CH0_STORE_BYPASS_EN__0 0x0
#define BV_PXP_WFE_B_STORE_CTRL_CH0_STORE_BYPASS_EN__1 0x1
#define BM_PXP_WFE_B_STORE_CTRL_CH0_RSVD3 0x00000080
#define BF_PXP_WFE_B_STORE_CTRL_CH0_RSVD3(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STORE_CTRL_CH0_RSVD3)
#define BP_PXP_WFE_B_STORE_CTRL_CH0_ARRAY_LINE_NUM      5
#define BM_PXP_WFE_B_STORE_CTRL_CH0_ARRAY_LINE_NUM 0x00000060
#define BF_PXP_WFE_B_STORE_CTRL_CH0_ARRAY_LINE_NUM(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STORE_CTRL_CH0_ARRAY_LINE_NUM)
#define BV_PXP_WFE_B_STORE_CTRL_CH0_ARRAY_LINE_NUM__0 0x0
#define BV_PXP_WFE_B_STORE_CTRL_CH0_ARRAY_LINE_NUM__1 0x1
#define BV_PXP_WFE_B_STORE_CTRL_CH0_ARRAY_LINE_NUM__2 0x2
#define BV_PXP_WFE_B_STORE_CTRL_CH0_ARRAY_LINE_NUM__3 0x3
#define BM_PXP_WFE_B_STORE_CTRL_CH0_ARRAY_EN 0x00000010
#define BF_PXP_WFE_B_STORE_CTRL_CH0_ARRAY_EN(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STORE_CTRL_CH0_ARRAY_EN)
#define BV_PXP_WFE_B_STORE_CTRL_CH0_ARRAY_EN__0 0x0
#define BV_PXP_WFE_B_STORE_CTRL_CH0_ARRAY_EN__1 0x1
#define BM_PXP_WFE_B_STORE_CTRL_CH0_HANDSHAKE_EN 0x00000008
#define BF_PXP_WFE_B_STORE_CTRL_CH0_HANDSHAKE_EN(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STORE_CTRL_CH0_HANDSHAKE_EN)
#define BV_PXP_WFE_B_STORE_CTRL_CH0_HANDSHAKE_EN__0 0x0
#define BV_PXP_WFE_B_STORE_CTRL_CH0_HANDSHAKE_EN__1 0x1
#define BM_PXP_WFE_B_STORE_CTRL_CH0_BLOCK_16 0x00000004
#define BF_PXP_WFE_B_STORE_CTRL_CH0_BLOCK_16(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STORE_CTRL_CH0_BLOCK_16)
#define BV_PXP_WFE_B_STORE_CTRL_CH0_BLOCK_16__8x8   0x0
#define BV_PXP_WFE_B_STORE_CTRL_CH0_BLOCK_16__16x16 0x1
#define BM_PXP_WFE_B_STORE_CTRL_CH0_BLOCK_EN 0x00000002
#define BF_PXP_WFE_B_STORE_CTRL_CH0_BLOCK_EN(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STORE_CTRL_CH0_BLOCK_EN)
#define BV_PXP_WFE_B_STORE_CTRL_CH0_BLOCK_EN__0 0x0
#define BV_PXP_WFE_B_STORE_CTRL_CH0_BLOCK_EN__1 0x1
#define BM_PXP_WFE_B_STORE_CTRL_CH0_CH_EN 0x00000001
#define BF_PXP_WFE_B_STORE_CTRL_CH0_CH_EN(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STORE_CTRL_CH0_CH_EN)
#define BV_PXP_WFE_B_STORE_CTRL_CH0_CH_EN__0 0x0
#define BV_PXP_WFE_B_STORE_CTRL_CH0_CH_EN__1 0x1

#define HW_PXP_WFE_B_STORE_CTRL_CH1	(0x00001350)
#define HW_PXP_WFE_B_STORE_CTRL_CH1_SET	(0x00001354)
#define HW_PXP_WFE_B_STORE_CTRL_CH1_CLR	(0x00001358)
#define HW_PXP_WFE_B_STORE_CTRL_CH1_TOG	(0x0000135c)

#define BP_PXP_WFE_B_STORE_CTRL_CH1_RSVD0      18
#define BM_PXP_WFE_B_STORE_CTRL_CH1_RSVD0 0xFFFC0000
#define BF_PXP_WFE_B_STORE_CTRL_CH1_RSVD0(v) \
        (((v) << 18) & BM_PXP_WFE_B_STORE_CTRL_CH1_RSVD0)
#define BP_PXP_WFE_B_STORE_CTRL_CH1_WR_NUM_BYTES      16
#define BM_PXP_WFE_B_STORE_CTRL_CH1_WR_NUM_BYTES 0x00030000
#define BF_PXP_WFE_B_STORE_CTRL_CH1_WR_NUM_BYTES(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STORE_CTRL_CH1_WR_NUM_BYTES)
#define BV_PXP_WFE_B_STORE_CTRL_CH1_WR_NUM_BYTES__8_bytes  0x0
#define BV_PXP_WFE_B_STORE_CTRL_CH1_WR_NUM_BYTES__16_bytes 0x1
#define BV_PXP_WFE_B_STORE_CTRL_CH1_WR_NUM_BYTES__32_bytes 0x2
#define BV_PXP_WFE_B_STORE_CTRL_CH1_WR_NUM_BYTES__64_bytes 0x3
#define BP_PXP_WFE_B_STORE_CTRL_CH1_RSVD1      11
#define BM_PXP_WFE_B_STORE_CTRL_CH1_RSVD1 0x0000F800
#define BF_PXP_WFE_B_STORE_CTRL_CH1_RSVD1(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STORE_CTRL_CH1_RSVD1)
#define BM_PXP_WFE_B_STORE_CTRL_CH1_PACK_IN_SEL 0x00000400
#define BF_PXP_WFE_B_STORE_CTRL_CH1_PACK_IN_SEL(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STORE_CTRL_CH1_PACK_IN_SEL)
#define BV_PXP_WFE_B_STORE_CTRL_CH1_PACK_IN_SEL__0 0x0
#define BV_PXP_WFE_B_STORE_CTRL_CH1_PACK_IN_SEL__1 0x1
#define BM_PXP_WFE_B_STORE_CTRL_CH1_STORE_MEMORY_EN 0x00000200
#define BF_PXP_WFE_B_STORE_CTRL_CH1_STORE_MEMORY_EN(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STORE_CTRL_CH1_STORE_MEMORY_EN)
#define BV_PXP_WFE_B_STORE_CTRL_CH1_STORE_MEMORY_EN__0 0x0
#define BV_PXP_WFE_B_STORE_CTRL_CH1_STORE_MEMORY_EN__1 0x1
#define BM_PXP_WFE_B_STORE_CTRL_CH1_STORE_BYPASS_EN 0x00000100
#define BF_PXP_WFE_B_STORE_CTRL_CH1_STORE_BYPASS_EN(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STORE_CTRL_CH1_STORE_BYPASS_EN)
#define BV_PXP_WFE_B_STORE_CTRL_CH1_STORE_BYPASS_EN__0 0x0
#define BV_PXP_WFE_B_STORE_CTRL_CH1_STORE_BYPASS_EN__1 0x1
#define BM_PXP_WFE_B_STORE_CTRL_CH1_RSVD3 0x00000080
#define BF_PXP_WFE_B_STORE_CTRL_CH1_RSVD3(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STORE_CTRL_CH1_RSVD3)
#define BP_PXP_WFE_B_STORE_CTRL_CH1_ARRAY_LINE_NUM      5
#define BM_PXP_WFE_B_STORE_CTRL_CH1_ARRAY_LINE_NUM 0x00000060
#define BF_PXP_WFE_B_STORE_CTRL_CH1_ARRAY_LINE_NUM(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STORE_CTRL_CH1_ARRAY_LINE_NUM)
#define BV_PXP_WFE_B_STORE_CTRL_CH1_ARRAY_LINE_NUM__0 0x0
#define BV_PXP_WFE_B_STORE_CTRL_CH1_ARRAY_LINE_NUM__1 0x1
#define BV_PXP_WFE_B_STORE_CTRL_CH1_ARRAY_LINE_NUM__2 0x2
#define BV_PXP_WFE_B_STORE_CTRL_CH1_ARRAY_LINE_NUM__3 0x3
#define BM_PXP_WFE_B_STORE_CTRL_CH1_ARRAY_EN 0x00000010
#define BF_PXP_WFE_B_STORE_CTRL_CH1_ARRAY_EN(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STORE_CTRL_CH1_ARRAY_EN)
#define BV_PXP_WFE_B_STORE_CTRL_CH1_ARRAY_EN__0 0x0
#define BV_PXP_WFE_B_STORE_CTRL_CH1_ARRAY_EN__1 0x1
#define BM_PXP_WFE_B_STORE_CTRL_CH1_HANDSHAKE_EN 0x00000008
#define BF_PXP_WFE_B_STORE_CTRL_CH1_HANDSHAKE_EN(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STORE_CTRL_CH1_HANDSHAKE_EN)
#define BV_PXP_WFE_B_STORE_CTRL_CH1_HANDSHAKE_EN__0 0x0
#define BV_PXP_WFE_B_STORE_CTRL_CH1_HANDSHAKE_EN__1 0x1
#define BM_PXP_WFE_B_STORE_CTRL_CH1_BLOCK_16 0x00000004
#define BF_PXP_WFE_B_STORE_CTRL_CH1_BLOCK_16(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STORE_CTRL_CH1_BLOCK_16)
#define BV_PXP_WFE_B_STORE_CTRL_CH1_BLOCK_16__8x8   0x0
#define BV_PXP_WFE_B_STORE_CTRL_CH1_BLOCK_16__16x16 0x1
#define BM_PXP_WFE_B_STORE_CTRL_CH1_BLOCK_EN 0x00000002
#define BF_PXP_WFE_B_STORE_CTRL_CH1_BLOCK_EN(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STORE_CTRL_CH1_BLOCK_EN)
#define BV_PXP_WFE_B_STORE_CTRL_CH1_BLOCK_EN__0 0x0
#define BV_PXP_WFE_B_STORE_CTRL_CH1_BLOCK_EN__1 0x1
#define BM_PXP_WFE_B_STORE_CTRL_CH1_CH_EN 0x00000001
#define BF_PXP_WFE_B_STORE_CTRL_CH1_CH_EN(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STORE_CTRL_CH1_CH_EN)
#define BV_PXP_WFE_B_STORE_CTRL_CH1_CH_EN__0 0x0
#define BV_PXP_WFE_B_STORE_CTRL_CH1_CH_EN__1 0x1

#define HW_PXP_WFE_B_STORE_STATUS_CH0	(0x00001360)

#define BP_PXP_WFE_B_STORE_STATUS_CH0_STORE_BLOCK_Y      16
#define BM_PXP_WFE_B_STORE_STATUS_CH0_STORE_BLOCK_Y 0xFFFF0000
#define BF_PXP_WFE_B_STORE_STATUS_CH0_STORE_BLOCK_Y(v) \
        (((v) << 16) & BM_PXP_WFE_B_STORE_STATUS_CH0_STORE_BLOCK_Y)
#define BP_PXP_WFE_B_STORE_STATUS_CH0_STORE_BLOCK_X      0
#define BM_PXP_WFE_B_STORE_STATUS_CH0_STORE_BLOCK_X 0x0000FFFF
#define BF_PXP_WFE_B_STORE_STATUS_CH0_STORE_BLOCK_X(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STORE_STATUS_CH0_STORE_BLOCK_X)

#define HW_PXP_WFE_B_STORE_STATUS_CH1	(0x00001370)

#define BP_PXP_WFE_B_STORE_STATUS_CH1_STORE_BLOCK_Y      16
#define BM_PXP_WFE_B_STORE_STATUS_CH1_STORE_BLOCK_Y 0xFFFF0000
#define BF_PXP_WFE_B_STORE_STATUS_CH1_STORE_BLOCK_Y(v) \
        (((v) << 16) & BM_PXP_WFE_B_STORE_STATUS_CH1_STORE_BLOCK_Y)
#define BP_PXP_WFE_B_STORE_STATUS_CH1_STORE_BLOCK_X      0
#define BM_PXP_WFE_B_STORE_STATUS_CH1_STORE_BLOCK_X 0x0000FFFF
#define BF_PXP_WFE_B_STORE_STATUS_CH1_STORE_BLOCK_X(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STORE_STATUS_CH1_STORE_BLOCK_X)

#define HW_PXP_WFE_B_STORE_SIZE_CH0	(0x00001380)

#define BP_PXP_WFE_B_STORE_SIZE_CH0_OUT_HEIGHT      16
#define BM_PXP_WFE_B_STORE_SIZE_CH0_OUT_HEIGHT 0xFFFF0000
#define BF_PXP_WFE_B_STORE_SIZE_CH0_OUT_HEIGHT(v) \
        (((v) << 16) & BM_PXP_WFE_B_STORE_SIZE_CH0_OUT_HEIGHT)
#define BP_PXP_WFE_B_STORE_SIZE_CH0_OUT_WIDTH      0
#define BM_PXP_WFE_B_STORE_SIZE_CH0_OUT_WIDTH 0x0000FFFF
#define BF_PXP_WFE_B_STORE_SIZE_CH0_OUT_WIDTH(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STORE_SIZE_CH0_OUT_WIDTH)

#define HW_PXP_WFE_B_STORE_SIZE_CH1	(0x00001390)

#define BP_PXP_WFE_B_STORE_SIZE_CH1_OUT_HEIGHT      16
#define BM_PXP_WFE_B_STORE_SIZE_CH1_OUT_HEIGHT 0xFFFF0000
#define BF_PXP_WFE_B_STORE_SIZE_CH1_OUT_HEIGHT(v) \
        (((v) << 16) & BM_PXP_WFE_B_STORE_SIZE_CH1_OUT_HEIGHT)
#define BP_PXP_WFE_B_STORE_SIZE_CH1_OUT_WIDTH      0
#define BM_PXP_WFE_B_STORE_SIZE_CH1_OUT_WIDTH 0x0000FFFF
#define BF_PXP_WFE_B_STORE_SIZE_CH1_OUT_WIDTH(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STORE_SIZE_CH1_OUT_WIDTH)

#define HW_PXP_WFE_B_STORE_PITCH	(0x000013a0)

#define BP_PXP_WFE_B_STORE_PITCH_CH1_OUT_PITCH      16
#define BM_PXP_WFE_B_STORE_PITCH_CH1_OUT_PITCH 0xFFFF0000
#define BF_PXP_WFE_B_STORE_PITCH_CH1_OUT_PITCH(v) \
        (((v) << 16) & BM_PXP_WFE_B_STORE_PITCH_CH1_OUT_PITCH)
#define BP_PXP_WFE_B_STORE_PITCH_CH0_OUT_PITCH      0
#define BM_PXP_WFE_B_STORE_PITCH_CH0_OUT_PITCH 0x0000FFFF
#define BF_PXP_WFE_B_STORE_PITCH_CH0_OUT_PITCH(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STORE_PITCH_CH0_OUT_PITCH)

#define HW_PXP_WFE_B_STORE_SHIFT_CTRL_CH0	(0x000013b0)
#define HW_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_SET	(0x000013b4)
#define HW_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_CLR	(0x000013b8)
#define HW_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_TOG	(0x000013bc)

#define BP_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_RSVD0      8
#define BM_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_RSVD0 0xFFFFFF00
#define BF_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_RSVD0(v) \
        (((v) << 8) & BM_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_RSVD0)
#define BM_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_SHIFT_BYPASS 0x00000080
#define BF_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_SHIFT_BYPASS(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_SHIFT_BYPASS)
#define BV_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_SHIFT_BYPASS__0 0x0
#define BV_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_SHIFT_BYPASS__1 0x1
#define BM_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_RSVD1 0x00000040
#define BF_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_RSVD1(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_RSVD1)
#define BM_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_OUT_YUV422_2P_EN 0x00000020
#define BF_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_OUT_YUV422_2P_EN(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_OUT_YUV422_2P_EN)
#define BV_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_OUT_YUV422_2P_EN__0 0x0
#define BV_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_OUT_YUV422_2P_EN__1 0x1
#define BM_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_OUT_YUV422_1P_EN 0x00000010
#define BF_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_OUT_YUV422_1P_EN(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_OUT_YUV422_1P_EN)
#define BV_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_OUT_YUV422_1P_EN__0 0x0
#define BV_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_OUT_YUV422_1P_EN__1 0x1
#define BP_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP      2
#define BM_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP 0x0000000C
#define BF_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP)
#define BV_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP__0 0x0
#define BV_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP__1 0x1
#define BV_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP__2 0x2
#define BV_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_OUTPUT_ACTIVE_BPP__3 0x3
#define BP_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_RSVD2      0
#define BM_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_RSVD2 0x00000003
#define BF_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_RSVD2(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STORE_SHIFT_CTRL_CH0_RSVD2)

#define HW_PXP_WFE_B_STORE_SHIFT_CTRL_CH1	(0x000013c0)
#define HW_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_SET	(0x000013c4)
#define HW_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_CLR	(0x000013c8)
#define HW_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_TOG	(0x000013cc)

#define BP_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_RSVD0      6
#define BM_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_RSVD0 0xFFFFFFC0
#define BF_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_RSVD0(v) \
        (((v) << 6) & BM_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_RSVD0)
#define BM_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_OUT_YUV422_2P_EN 0x00000020
#define BF_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_OUT_YUV422_2P_EN(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_OUT_YUV422_2P_EN)
#define BV_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_OUT_YUV422_2P_EN__0 0x0
#define BV_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_OUT_YUV422_2P_EN__1 0x1
#define BM_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_OUT_YUV422_1P_EN 0x00000010
#define BF_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_OUT_YUV422_1P_EN(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_OUT_YUV422_1P_EN)
#define BV_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_OUT_YUV422_1P_EN__0 0x0
#define BV_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_OUT_YUV422_1P_EN__1 0x1
#define BP_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP      2
#define BM_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP 0x0000000C
#define BF_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP)
#define BV_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP__0 0x0
#define BV_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP__1 0x1
#define BV_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP__2 0x2
#define BV_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_OUTPUT_ACTIVE_BPP__3 0x3
#define BP_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_RSVD2      0
#define BM_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_RSVD2 0x00000003
#define BF_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_RSVD2(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STORE_SHIFT_CTRL_CH1_RSVD2)

#define HW_PXP_WFE_B_STORE_ADDR_0_CH0	(0x00001410)

#define BP_PXP_WFE_B_STORE_ADDR_0_CH0_OUT_BASE_ADDR0      0
#define BM_PXP_WFE_B_STORE_ADDR_0_CH0_OUT_BASE_ADDR0 0xFFFFFFFF
#define BF_PXP_WFE_B_STORE_ADDR_0_CH0_OUT_BASE_ADDR0(v)   (v)

#define HW_PXP_WFE_B_STORE_ADDR_1_CH0	(0x00001420)

#define BP_PXP_WFE_B_STORE_ADDR_1_CH0_OUT_BASE_ADDR1      0
#define BM_PXP_WFE_B_STORE_ADDR_1_CH0_OUT_BASE_ADDR1 0xFFFFFFFF
#define BF_PXP_WFE_B_STORE_ADDR_1_CH0_OUT_BASE_ADDR1(v)   (v)

#define HW_PXP_WFE_B_STORE_FILL_DATA_CH0	(0x00001430)

#define BP_PXP_WFE_B_STORE_FILL_DATA_CH0_FILL_DATA_CH0      0
#define BM_PXP_WFE_B_STORE_FILL_DATA_CH0_FILL_DATA_CH0 0xFFFFFFFF
#define BF_PXP_WFE_B_STORE_FILL_DATA_CH0_FILL_DATA_CH0(v)   (v)

#define HW_PXP_WFE_B_STORE_ADDR_0_CH1	(0x00001440)

#define BP_PXP_WFE_B_STORE_ADDR_0_CH1_OUT_BASE_ADDR0      0
#define BM_PXP_WFE_B_STORE_ADDR_0_CH1_OUT_BASE_ADDR0 0xFFFFFFFF
#define BF_PXP_WFE_B_STORE_ADDR_0_CH1_OUT_BASE_ADDR0(v)   (v)

#define HW_PXP_WFE_B_STORE_ADDR_1_CH1	(0x00001450)

#define BP_PXP_WFE_B_STORE_ADDR_1_CH1_OUT_BASE_ADDR1      0
#define BM_PXP_WFE_B_STORE_ADDR_1_CH1_OUT_BASE_ADDR1 0xFFFFFFFF
#define BF_PXP_WFE_B_STORE_ADDR_1_CH1_OUT_BASE_ADDR1(v)   (v)

#define HW_PXP_WFE_B_STORE_D_MASK0_H_CH0	(0x00001460)

#define BP_PXP_WFE_B_STORE_D_MASK0_H_CH0_D_MASK0_H_CH0      0
#define BM_PXP_WFE_B_STORE_D_MASK0_H_CH0_D_MASK0_H_CH0 0xFFFFFFFF
#define BF_PXP_WFE_B_STORE_D_MASK0_H_CH0_D_MASK0_H_CH0(v)   (v)

#define HW_PXP_WFE_B_STORE_D_MASK0_L_CH0	(0x00001470)

#define BP_PXP_WFE_B_STORE_D_MASK0_L_CH0_D_MASK0_L_CH0      0
#define BM_PXP_WFE_B_STORE_D_MASK0_L_CH0_D_MASK0_L_CH0 0xFFFFFFFF
#define BF_PXP_WFE_B_STORE_D_MASK0_L_CH0_D_MASK0_L_CH0(v)   (v)

#define HW_PXP_WFE_B_STORE_D_MASK1_H_CH0	(0x00001480)

#define BP_PXP_WFE_B_STORE_D_MASK1_H_CH0_D_MASK1_H_CH0      0
#define BM_PXP_WFE_B_STORE_D_MASK1_H_CH0_D_MASK1_H_CH0 0xFFFFFFFF
#define BF_PXP_WFE_B_STORE_D_MASK1_H_CH0_D_MASK1_H_CH0(v)   (v)

#define HW_PXP_WFE_B_STORE_D_MASK1_L_CH0	(0x00001490)

#define BP_PXP_WFE_B_STORE_D_MASK1_L_CH0_D_MASK1_L_CH0      0
#define BM_PXP_WFE_B_STORE_D_MASK1_L_CH0_D_MASK1_L_CH0 0xFFFFFFFF
#define BF_PXP_WFE_B_STORE_D_MASK1_L_CH0_D_MASK1_L_CH0(v)   (v)

#define HW_PXP_WFE_B_STORE_D_MASK2_H_CH0	(0x000014a0)

#define BP_PXP_WFE_B_STORE_D_MASK2_H_CH0_D_MASK2_H_CH0      0
#define BM_PXP_WFE_B_STORE_D_MASK2_H_CH0_D_MASK2_H_CH0 0xFFFFFFFF
#define BF_PXP_WFE_B_STORE_D_MASK2_H_CH0_D_MASK2_H_CH0(v)   (v)

#define HW_PXP_WFE_B_STORE_D_MASK2_L_CH0	(0x000014b0)

#define BP_PXP_WFE_B_STORE_D_MASK2_L_CH0_D_MASK2_L_CH0      0
#define BM_PXP_WFE_B_STORE_D_MASK2_L_CH0_D_MASK2_L_CH0 0xFFFFFFFF
#define BF_PXP_WFE_B_STORE_D_MASK2_L_CH0_D_MASK2_L_CH0(v)   (v)

#define HW_PXP_WFE_B_STORE_D_MASK3_H_CH0	(0x000014c0)

#define BP_PXP_WFE_B_STORE_D_MASK3_H_CH0_D_MASK3_H_CH0      0
#define BM_PXP_WFE_B_STORE_D_MASK3_H_CH0_D_MASK3_H_CH0 0xFFFFFFFF
#define BF_PXP_WFE_B_STORE_D_MASK3_H_CH0_D_MASK3_H_CH0(v)   (v)

#define HW_PXP_WFE_B_STORE_D_MASK3_L_CH0	(0x000014d0)

#define BP_PXP_WFE_B_STORE_D_MASK3_L_CH0_D_MASK3_L_CH0      0
#define BM_PXP_WFE_B_STORE_D_MASK3_L_CH0_D_MASK3_L_CH0 0xFFFFFFFF
#define BF_PXP_WFE_B_STORE_D_MASK3_L_CH0_D_MASK3_L_CH0(v)   (v)

#define HW_PXP_WFE_B_STORE_D_MASK4_H_CH0	(0x000014e0)

#define BP_PXP_WFE_B_STORE_D_MASK4_H_CH0_D_MASK4_H_CH0      0
#define BM_PXP_WFE_B_STORE_D_MASK4_H_CH0_D_MASK4_H_CH0 0xFFFFFFFF
#define BF_PXP_WFE_B_STORE_D_MASK4_H_CH0_D_MASK4_H_CH0(v)   (v)

#define HW_PXP_WFE_B_STORE_D_MASK4_L_CH0	(0x000014f0)

#define BP_PXP_WFE_B_STORE_D_MASK4_L_CH0_D_MASK4_L_CH0      0
#define BM_PXP_WFE_B_STORE_D_MASK4_L_CH0_D_MASK4_L_CH0 0xFFFFFFFF
#define BF_PXP_WFE_B_STORE_D_MASK4_L_CH0_D_MASK4_L_CH0(v)   (v)

#define HW_PXP_WFE_B_STORE_D_MASK5_H_CH0	(0x00001500)

#define BP_PXP_WFE_B_STORE_D_MASK5_H_CH0_D_MASK5_H_CH0      0
#define BM_PXP_WFE_B_STORE_D_MASK5_H_CH0_D_MASK5_H_CH0 0xFFFFFFFF
#define BF_PXP_WFE_B_STORE_D_MASK5_H_CH0_D_MASK5_H_CH0(v)   (v)

#define HW_PXP_WFE_B_STORE_D_MASK5_L_CH0	(0x00001510)

#define BP_PXP_WFE_B_STORE_D_MASK5_L_CH0_D_MASK5_L_CH0      0
#define BM_PXP_WFE_B_STORE_D_MASK5_L_CH0_D_MASK5_L_CH0 0xFFFFFFFF
#define BF_PXP_WFE_B_STORE_D_MASK5_L_CH0_D_MASK5_L_CH0(v)   (v)

#define HW_PXP_WFE_B_STORE_D_MASK6_H_CH0	(0x00001520)

#define BP_PXP_WFE_B_STORE_D_MASK6_H_CH0_D_MASK6_H_CH0      0
#define BM_PXP_WFE_B_STORE_D_MASK6_H_CH0_D_MASK6_H_CH0 0xFFFFFFFF
#define BF_PXP_WFE_B_STORE_D_MASK6_H_CH0_D_MASK6_H_CH0(v)   (v)

#define HW_PXP_WFE_B_STORE_D_MASK6_L_CH0	(0x00001530)

#define BP_PXP_WFE_B_STORE_D_MASK6_L_CH0_D_MASK6_L_CH0      0
#define BM_PXP_WFE_B_STORE_D_MASK6_L_CH0_D_MASK6_L_CH0 0xFFFFFFFF
#define BF_PXP_WFE_B_STORE_D_MASK6_L_CH0_D_MASK6_L_CH0(v)   (v)

#define HW_PXP_WFE_B_STORE_D_MASK7_H_CH0	(0x00001540)

#define BP_PXP_WFE_B_STORE_D_MASK7_H_CH0_D_MASK7_H_CH0      0
#define BM_PXP_WFE_B_STORE_D_MASK7_H_CH0_D_MASK7_H_CH0 0xFFFFFFFF
#define BF_PXP_WFE_B_STORE_D_MASK7_H_CH0_D_MASK7_H_CH0(v)   (v)

#define HW_PXP_WFE_B_STORE_D_MASK7_L_CH0	(0x00001550)

#define BP_PXP_WFE_B_STORE_D_MASK7_L_CH0_D_MASK7_L_CH0      0
#define BM_PXP_WFE_B_STORE_D_MASK7_L_CH0_D_MASK7_L_CH0 0xFFFFFFFF
#define BF_PXP_WFE_B_STORE_D_MASK7_L_CH0_D_MASK7_L_CH0(v)   (v)

#define HW_PXP_WFE_B_STORE_D_SHIFT_L_CH0	(0x00001560)

#define BM_PXP_WFE_B_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG3 0x80000000
#define BF_PXP_WFE_B_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG3(v) \
        (((v) << 31) & BM_PXP_WFE_B_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG3)
#define BM_PXP_WFE_B_STORE_D_SHIFT_L_CH0_RSVD0 0x40000000
#define BF_PXP_WFE_B_STORE_D_SHIFT_L_CH0_RSVD0(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STORE_D_SHIFT_L_CH0_RSVD0)
#define BP_PXP_WFE_B_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH3      24
#define BM_PXP_WFE_B_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH3 0x3F000000
#define BF_PXP_WFE_B_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH3(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH3)
#define BM_PXP_WFE_B_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG2 0x00800000
#define BF_PXP_WFE_B_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG2(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG2)
#define BM_PXP_WFE_B_STORE_D_SHIFT_L_CH0_RSVD1 0x00400000
#define BF_PXP_WFE_B_STORE_D_SHIFT_L_CH0_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STORE_D_SHIFT_L_CH0_RSVD1)
#define BP_PXP_WFE_B_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH2      16
#define BM_PXP_WFE_B_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH2 0x003F0000
#define BF_PXP_WFE_B_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH2(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH2)
#define BM_PXP_WFE_B_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG1 0x00008000
#define BF_PXP_WFE_B_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG1(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG1)
#define BM_PXP_WFE_B_STORE_D_SHIFT_L_CH0_RSVD2 0x00004000
#define BF_PXP_WFE_B_STORE_D_SHIFT_L_CH0_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STORE_D_SHIFT_L_CH0_RSVD2)
#define BP_PXP_WFE_B_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH1      8
#define BM_PXP_WFE_B_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH1 0x00003F00
#define BF_PXP_WFE_B_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH1(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH1)
#define BM_PXP_WFE_B_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG0 0x00000080
#define BF_PXP_WFE_B_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG0(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STORE_D_SHIFT_L_CH0_D_SHIFT_FLAG0)
#define BM_PXP_WFE_B_STORE_D_SHIFT_L_CH0_RSVD3 0x00000040
#define BF_PXP_WFE_B_STORE_D_SHIFT_L_CH0_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STORE_D_SHIFT_L_CH0_RSVD3)
#define BP_PXP_WFE_B_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH0      0
#define BM_PXP_WFE_B_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH0 0x0000003F
#define BF_PXP_WFE_B_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH0(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STORE_D_SHIFT_L_CH0_D_SHIFT_WIDTH0)

#define HW_PXP_WFE_B_STORE_D_SHIFT_H_CH0	(0x00001570)

#define BM_PXP_WFE_B_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG7 0x80000000
#define BF_PXP_WFE_B_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG7(v) \
        (((v) << 31) & BM_PXP_WFE_B_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG7)
#define BM_PXP_WFE_B_STORE_D_SHIFT_H_CH0_RSVD0 0x40000000
#define BF_PXP_WFE_B_STORE_D_SHIFT_H_CH0_RSVD0(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STORE_D_SHIFT_H_CH0_RSVD0)
#define BP_PXP_WFE_B_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH7      24
#define BM_PXP_WFE_B_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH7 0x3F000000
#define BF_PXP_WFE_B_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH7(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH7)
#define BM_PXP_WFE_B_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG6 0x00800000
#define BF_PXP_WFE_B_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG6(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG6)
#define BM_PXP_WFE_B_STORE_D_SHIFT_H_CH0_RSVD1 0x00400000
#define BF_PXP_WFE_B_STORE_D_SHIFT_H_CH0_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STORE_D_SHIFT_H_CH0_RSVD1)
#define BP_PXP_WFE_B_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH6      16
#define BM_PXP_WFE_B_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH6 0x003F0000
#define BF_PXP_WFE_B_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH6(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH6)
#define BM_PXP_WFE_B_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG5 0x00008000
#define BF_PXP_WFE_B_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG5(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG5)
#define BM_PXP_WFE_B_STORE_D_SHIFT_H_CH0_RSVD2 0x00004000
#define BF_PXP_WFE_B_STORE_D_SHIFT_H_CH0_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STORE_D_SHIFT_H_CH0_RSVD2)
#define BP_PXP_WFE_B_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH5      8
#define BM_PXP_WFE_B_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH5 0x00003F00
#define BF_PXP_WFE_B_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH5(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH5)
#define BM_PXP_WFE_B_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG4 0x00000080
#define BF_PXP_WFE_B_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG4(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STORE_D_SHIFT_H_CH0_D_SHIFT_FLAG4)
#define BM_PXP_WFE_B_STORE_D_SHIFT_H_CH0_RSVD3 0x00000040
#define BF_PXP_WFE_B_STORE_D_SHIFT_H_CH0_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STORE_D_SHIFT_H_CH0_RSVD3)
#define BP_PXP_WFE_B_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH4      0
#define BM_PXP_WFE_B_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH4 0x0000003F
#define BF_PXP_WFE_B_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH4(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STORE_D_SHIFT_H_CH0_D_SHIFT_WIDTH4)

#define HW_PXP_WFE_B_STORE_F_SHIFT_L_CH0	(0x00001580)

#define BM_PXP_WFE_B_STORE_F_SHIFT_L_CH0_RSVD0 0x80000000
#define BF_PXP_WFE_B_STORE_F_SHIFT_L_CH0_RSVD0(v) \
        (((v) << 31) & BM_PXP_WFE_B_STORE_F_SHIFT_L_CH0_RSVD0)
#define BM_PXP_WFE_B_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG3 0x40000000
#define BF_PXP_WFE_B_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG3(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG3)
#define BP_PXP_WFE_B_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH3      24
#define BM_PXP_WFE_B_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH3 0x3F000000
#define BF_PXP_WFE_B_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH3(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH3)
#define BM_PXP_WFE_B_STORE_F_SHIFT_L_CH0_RSVD1 0x00800000
#define BF_PXP_WFE_B_STORE_F_SHIFT_L_CH0_RSVD1(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STORE_F_SHIFT_L_CH0_RSVD1)
#define BM_PXP_WFE_B_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG2 0x00400000
#define BF_PXP_WFE_B_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG2(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG2)
#define BP_PXP_WFE_B_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH2      16
#define BM_PXP_WFE_B_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH2 0x003F0000
#define BF_PXP_WFE_B_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH2(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH2)
#define BM_PXP_WFE_B_STORE_F_SHIFT_L_CH0_RSVD2 0x00008000
#define BF_PXP_WFE_B_STORE_F_SHIFT_L_CH0_RSVD2(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STORE_F_SHIFT_L_CH0_RSVD2)
#define BM_PXP_WFE_B_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG1 0x00004000
#define BF_PXP_WFE_B_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG1(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG1)
#define BP_PXP_WFE_B_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH1      8
#define BM_PXP_WFE_B_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH1 0x00003F00
#define BF_PXP_WFE_B_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH1(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH1)
#define BM_PXP_WFE_B_STORE_F_SHIFT_L_CH0_RSVD3 0x00000080
#define BF_PXP_WFE_B_STORE_F_SHIFT_L_CH0_RSVD3(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STORE_F_SHIFT_L_CH0_RSVD3)
#define BM_PXP_WFE_B_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG0 0x00000040
#define BF_PXP_WFE_B_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG0(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STORE_F_SHIFT_L_CH0_F_SHIFT_FLAG0)
#define BP_PXP_WFE_B_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH0      0
#define BM_PXP_WFE_B_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH0 0x0000003F
#define BF_PXP_WFE_B_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH0(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STORE_F_SHIFT_L_CH0_F_SHIFT_WIDTH0)

#define HW_PXP_WFE_B_STORE_F_SHIFT_H_CH0	(0x00001590)

#define BM_PXP_WFE_B_STORE_F_SHIFT_H_CH0_RSVD0 0x80000000
#define BF_PXP_WFE_B_STORE_F_SHIFT_H_CH0_RSVD0(v) \
        (((v) << 31) & BM_PXP_WFE_B_STORE_F_SHIFT_H_CH0_RSVD0)
#define BM_PXP_WFE_B_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG7 0x40000000
#define BF_PXP_WFE_B_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG7(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG7)
#define BP_PXP_WFE_B_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH7      24
#define BM_PXP_WFE_B_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH7 0x3F000000
#define BF_PXP_WFE_B_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH7(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH7)
#define BM_PXP_WFE_B_STORE_F_SHIFT_H_CH0_RSVD1 0x00800000
#define BF_PXP_WFE_B_STORE_F_SHIFT_H_CH0_RSVD1(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STORE_F_SHIFT_H_CH0_RSVD1)
#define BM_PXP_WFE_B_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG6 0x00400000
#define BF_PXP_WFE_B_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG6(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG6)
#define BP_PXP_WFE_B_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH6      16
#define BM_PXP_WFE_B_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH6 0x003F0000
#define BF_PXP_WFE_B_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH6(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH6)
#define BM_PXP_WFE_B_STORE_F_SHIFT_H_CH0_RSVD2 0x00008000
#define BF_PXP_WFE_B_STORE_F_SHIFT_H_CH0_RSVD2(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STORE_F_SHIFT_H_CH0_RSVD2)
#define BM_PXP_WFE_B_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG5 0x00004000
#define BF_PXP_WFE_B_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG5(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG5)
#define BP_PXP_WFE_B_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH5      8
#define BM_PXP_WFE_B_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH5 0x00003F00
#define BF_PXP_WFE_B_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH5(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH5)
#define BM_PXP_WFE_B_STORE_F_SHIFT_H_CH0_RSVD3 0x00000080
#define BF_PXP_WFE_B_STORE_F_SHIFT_H_CH0_RSVD3(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STORE_F_SHIFT_H_CH0_RSVD3)
#define BM_PXP_WFE_B_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG4 0x00000040
#define BF_PXP_WFE_B_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG4(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STORE_F_SHIFT_H_CH0_F_SHIFT_FLAG4)
#define BP_PXP_WFE_B_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH4      0
#define BM_PXP_WFE_B_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH4 0x0000003F
#define BF_PXP_WFE_B_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH4(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STORE_F_SHIFT_H_CH0_F_SHIFT_WIDTH4)

#define HW_PXP_WFE_B_STORE_F_MASK_L_CH0	(0x000015a0)

#define BP_PXP_WFE_B_STORE_F_MASK_L_CH0_F_MASK3      24
#define BM_PXP_WFE_B_STORE_F_MASK_L_CH0_F_MASK3 0xFF000000
#define BF_PXP_WFE_B_STORE_F_MASK_L_CH0_F_MASK3(v) \
        (((v) << 24) & BM_PXP_WFE_B_STORE_F_MASK_L_CH0_F_MASK3)
#define BP_PXP_WFE_B_STORE_F_MASK_L_CH0_F_MASK2      16
#define BM_PXP_WFE_B_STORE_F_MASK_L_CH0_F_MASK2 0x00FF0000
#define BF_PXP_WFE_B_STORE_F_MASK_L_CH0_F_MASK2(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STORE_F_MASK_L_CH0_F_MASK2)
#define BP_PXP_WFE_B_STORE_F_MASK_L_CH0_F_MASK1      8
#define BM_PXP_WFE_B_STORE_F_MASK_L_CH0_F_MASK1 0x0000FF00
#define BF_PXP_WFE_B_STORE_F_MASK_L_CH0_F_MASK1(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STORE_F_MASK_L_CH0_F_MASK1)
#define BP_PXP_WFE_B_STORE_F_MASK_L_CH0_F_MASK0      0
#define BM_PXP_WFE_B_STORE_F_MASK_L_CH0_F_MASK0 0x000000FF
#define BF_PXP_WFE_B_STORE_F_MASK_L_CH0_F_MASK0(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STORE_F_MASK_L_CH0_F_MASK0)

#define HW_PXP_WFE_B_STORE_F_MASK_H_CH0	(0x000015b0)

#define BP_PXP_WFE_B_STORE_F_MASK_H_CH0_F_MASK7      24
#define BM_PXP_WFE_B_STORE_F_MASK_H_CH0_F_MASK7 0xFF000000
#define BF_PXP_WFE_B_STORE_F_MASK_H_CH0_F_MASK7(v) \
        (((v) << 24) & BM_PXP_WFE_B_STORE_F_MASK_H_CH0_F_MASK7)
#define BP_PXP_WFE_B_STORE_F_MASK_H_CH0_F_MASK6      16
#define BM_PXP_WFE_B_STORE_F_MASK_H_CH0_F_MASK6 0x00FF0000
#define BF_PXP_WFE_B_STORE_F_MASK_H_CH0_F_MASK6(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STORE_F_MASK_H_CH0_F_MASK6)
#define BP_PXP_WFE_B_STORE_F_MASK_H_CH0_F_MASK5      8
#define BM_PXP_WFE_B_STORE_F_MASK_H_CH0_F_MASK5 0x0000FF00
#define BF_PXP_WFE_B_STORE_F_MASK_H_CH0_F_MASK5(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STORE_F_MASK_H_CH0_F_MASK5)
#define BP_PXP_WFE_B_STORE_F_MASK_H_CH0_F_MASK4      0
#define BM_PXP_WFE_B_STORE_F_MASK_H_CH0_F_MASK4 0x000000FF
#define BF_PXP_WFE_B_STORE_F_MASK_H_CH0_F_MASK4(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STORE_F_MASK_H_CH0_F_MASK4)

#define HW_PXP_FETCH_WFE_A_DEBUG	(0x000015c0)

#define BP_PXP_FETCH_WFE_A_DEBUG_RSVD      29
#define BM_PXP_FETCH_WFE_A_DEBUG_RSVD 0xE0000000
#define BF_PXP_FETCH_WFE_A_DEBUG_RSVD(v) \
        (((v) << 29) & BM_PXP_FETCH_WFE_A_DEBUG_RSVD)
#define BM_PXP_FETCH_WFE_A_DEBUG_BUF_SEL 0x10000000
#define BF_PXP_FETCH_WFE_A_DEBUG_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_FETCH_WFE_A_DEBUG_BUF_SEL)
#define BV_PXP_FETCH_WFE_A_DEBUG_BUF_SEL__BF0 0x0
#define BV_PXP_FETCH_WFE_A_DEBUG_BUF_SEL__BF1 0x1
#define BP_PXP_FETCH_WFE_A_DEBUG_ITEM_SEL      24
#define BM_PXP_FETCH_WFE_A_DEBUG_ITEM_SEL 0x0F000000
#define BF_PXP_FETCH_WFE_A_DEBUG_ITEM_SEL(v)  \
        (((v) << 24) & BM_PXP_FETCH_WFE_A_DEBUG_ITEM_SEL)
#define BP_PXP_FETCH_WFE_A_DEBUG_DEBUG_VALUE      0
#define BM_PXP_FETCH_WFE_A_DEBUG_DEBUG_VALUE 0x00FFFFFF
#define BF_PXP_FETCH_WFE_A_DEBUG_DEBUG_VALUE(v)  \
        (((v) << 0) & BM_PXP_FETCH_WFE_A_DEBUG_DEBUG_VALUE)

#define HW_PXP_FETCH_WFE_B_DEBUG	(0x000015d0)

#define BP_PXP_FETCH_WFE_B_DEBUG_RSVD      29
#define BM_PXP_FETCH_WFE_B_DEBUG_RSVD 0xE0000000
#define BF_PXP_FETCH_WFE_B_DEBUG_RSVD(v) \
        (((v) << 29) & BM_PXP_FETCH_WFE_B_DEBUG_RSVD)
#define BM_PXP_FETCH_WFE_B_DEBUG_BUF_SEL 0x10000000
#define BF_PXP_FETCH_WFE_B_DEBUG_BUF_SEL(v)  \
        (((v) << 28) & BM_PXP_FETCH_WFE_B_DEBUG_BUF_SEL)
#define BV_PXP_FETCH_WFE_B_DEBUG_BUF_SEL__BF0 0x0
#define BV_PXP_FETCH_WFE_B_DEBUG_BUF_SEL__BF1 0x1
#define BP_PXP_FETCH_WFE_B_DEBUG_ITEM_SEL      24
#define BM_PXP_FETCH_WFE_B_DEBUG_ITEM_SEL 0x0F000000
#define BF_PXP_FETCH_WFE_B_DEBUG_ITEM_SEL(v)  \
        (((v) << 24) & BM_PXP_FETCH_WFE_B_DEBUG_ITEM_SEL)
#define BP_PXP_FETCH_WFE_B_DEBUG_DEBUG_VALUE      0
#define BM_PXP_FETCH_WFE_B_DEBUG_DEBUG_VALUE 0x00FFFFFF
#define BF_PXP_FETCH_WFE_B_DEBUG_DEBUG_VALUE(v)  \
        (((v) << 0) & BM_PXP_FETCH_WFE_B_DEBUG_DEBUG_VALUE)

#define HW_PXP_DITHER_CTRL	(0x00001670)
#define HW_PXP_DITHER_CTRL_SET	(0x00001674)
#define HW_PXP_DITHER_CTRL_CLR	(0x00001678)
#define HW_PXP_DITHER_CTRL_TOG	(0x0000167c)

#define BM_PXP_DITHER_CTRL_BUSY0 0x80000000
#define BF_PXP_DITHER_CTRL_BUSY0(v) \
        (((v) << 31) & BM_PXP_DITHER_CTRL_BUSY0)
#define BM_PXP_DITHER_CTRL_BUSY1 0x40000000
#define BF_PXP_DITHER_CTRL_BUSY1(v)  \
        (((v) << 30) & BM_PXP_DITHER_CTRL_BUSY1)
#define BM_PXP_DITHER_CTRL_BUSY2 0x20000000
#define BF_PXP_DITHER_CTRL_BUSY2(v)  \
        (((v) << 29) & BM_PXP_DITHER_CTRL_BUSY2)
#define BP_PXP_DITHER_CTRL_RSVD0      25
#define BM_PXP_DITHER_CTRL_RSVD0 0x1E000000
#define BF_PXP_DITHER_CTRL_RSVD0(v)  \
        (((v) << 25) & BM_PXP_DITHER_CTRL_RSVD0)
#define BM_PXP_DITHER_CTRL_ORDERED_ROUND_MODE 0x01000000
#define BF_PXP_DITHER_CTRL_ORDERED_ROUND_MODE(v)  \
        (((v) << 24) & BM_PXP_DITHER_CTRL_ORDERED_ROUND_MODE)
#define BV_PXP_DITHER_CTRL_ORDERED_ROUND_MODE__0 0x0
#define BV_PXP_DITHER_CTRL_ORDERED_ROUND_MODE__1 0x1
#define BM_PXP_DITHER_CTRL_FINAL_LUT_ENABLE 0x00800000
#define BF_PXP_DITHER_CTRL_FINAL_LUT_ENABLE(v)  \
        (((v) << 23) & BM_PXP_DITHER_CTRL_FINAL_LUT_ENABLE)
#define BV_PXP_DITHER_CTRL_FINAL_LUT_ENABLE__Disabled 0x0
#define BV_PXP_DITHER_CTRL_FINAL_LUT_ENABLE__Enabled  0x1
#define BP_PXP_DITHER_CTRL_IDX_MATRIX2_SIZE      21
#define BM_PXP_DITHER_CTRL_IDX_MATRIX2_SIZE 0x00600000
#define BF_PXP_DITHER_CTRL_IDX_MATRIX2_SIZE(v)  \
        (((v) << 21) & BM_PXP_DITHER_CTRL_IDX_MATRIX2_SIZE)
#define BV_PXP_DITHER_CTRL_IDX_MATRIX2_SIZE__0 0x0
#define BV_PXP_DITHER_CTRL_IDX_MATRIX2_SIZE__1 0x1
#define BV_PXP_DITHER_CTRL_IDX_MATRIX2_SIZE__2 0x2
#define BV_PXP_DITHER_CTRL_IDX_MATRIX2_SIZE__3 0x3
#define BP_PXP_DITHER_CTRL_IDX_MATRIX1_SIZE      19
#define BM_PXP_DITHER_CTRL_IDX_MATRIX1_SIZE 0x00180000
#define BF_PXP_DITHER_CTRL_IDX_MATRIX1_SIZE(v)  \
        (((v) << 19) & BM_PXP_DITHER_CTRL_IDX_MATRIX1_SIZE)
#define BV_PXP_DITHER_CTRL_IDX_MATRIX1_SIZE__0 0x0
#define BV_PXP_DITHER_CTRL_IDX_MATRIX1_SIZE__1 0x1
#define BV_PXP_DITHER_CTRL_IDX_MATRIX1_SIZE__2 0x2
#define BV_PXP_DITHER_CTRL_IDX_MATRIX1_SIZE__3 0x3
#define BP_PXP_DITHER_CTRL_IDX_MATRIX0_SIZE      17
#define BM_PXP_DITHER_CTRL_IDX_MATRIX0_SIZE 0x00060000
#define BF_PXP_DITHER_CTRL_IDX_MATRIX0_SIZE(v)  \
        (((v) << 17) & BM_PXP_DITHER_CTRL_IDX_MATRIX0_SIZE)
#define BV_PXP_DITHER_CTRL_IDX_MATRIX0_SIZE__0 0x0
#define BV_PXP_DITHER_CTRL_IDX_MATRIX0_SIZE__1 0x1
#define BV_PXP_DITHER_CTRL_IDX_MATRIX0_SIZE__2 0x2
#define BV_PXP_DITHER_CTRL_IDX_MATRIX0_SIZE__3 0x3
#define BP_PXP_DITHER_CTRL_LUT_MODE      15
#define BM_PXP_DITHER_CTRL_LUT_MODE 0x00018000
#define BF_PXP_DITHER_CTRL_LUT_MODE(v)  \
        (((v) << 15) & BM_PXP_DITHER_CTRL_LUT_MODE)
#define BV_PXP_DITHER_CTRL_LUT_MODE__0 0x0
#define BV_PXP_DITHER_CTRL_LUT_MODE__1 0x1
#define BV_PXP_DITHER_CTRL_LUT_MODE__2 0x2
#define BV_PXP_DITHER_CTRL_LUT_MODE__3 0x3
#define BP_PXP_DITHER_CTRL_NUM_QUANT_BIT      12
#define BM_PXP_DITHER_CTRL_NUM_QUANT_BIT 0x00007000
#define BF_PXP_DITHER_CTRL_NUM_QUANT_BIT(v)  \
        (((v) << 12) & BM_PXP_DITHER_CTRL_NUM_QUANT_BIT)
#define BV_PXP_DITHER_CTRL_NUM_QUANT_BIT__0 0x0
#define BV_PXP_DITHER_CTRL_NUM_QUANT_BIT__1 0x1
#define BV_PXP_DITHER_CTRL_NUM_QUANT_BIT__2 0x2
#define BV_PXP_DITHER_CTRL_NUM_QUANT_BIT__3 0x3
#define BV_PXP_DITHER_CTRL_NUM_QUANT_BIT__4 0x4
#define BV_PXP_DITHER_CTRL_NUM_QUANT_BIT__5 0x5
#define BV_PXP_DITHER_CTRL_NUM_QUANT_BIT__6 0x6
#define BV_PXP_DITHER_CTRL_NUM_QUANT_BIT__7 0x7
#define BP_PXP_DITHER_CTRL_DITHER_MODE2      9
#define BM_PXP_DITHER_CTRL_DITHER_MODE2 0x00000E00
#define BF_PXP_DITHER_CTRL_DITHER_MODE2(v)  \
        (((v) << 9) & BM_PXP_DITHER_CTRL_DITHER_MODE2)
#define BV_PXP_DITHER_CTRL_DITHER_MODE2__0 0x0
#define BV_PXP_DITHER_CTRL_DITHER_MODE2__1 0x1
#define BV_PXP_DITHER_CTRL_DITHER_MODE2__2 0x2
#define BV_PXP_DITHER_CTRL_DITHER_MODE2__3 0x3
#define BV_PXP_DITHER_CTRL_DITHER_MODE2__4 0x4
#define BV_PXP_DITHER_CTRL_DITHER_MODE2__5 0x5
#define BV_PXP_DITHER_CTRL_DITHER_MODE2__6 0x6
#define BV_PXP_DITHER_CTRL_DITHER_MODE2__7 0x7
#define BP_PXP_DITHER_CTRL_DITHER_MODE1      6
#define BM_PXP_DITHER_CTRL_DITHER_MODE1 0x000001C0
#define BF_PXP_DITHER_CTRL_DITHER_MODE1(v)  \
        (((v) << 6) & BM_PXP_DITHER_CTRL_DITHER_MODE1)
#define BV_PXP_DITHER_CTRL_DITHER_MODE1__0 0x0
#define BV_PXP_DITHER_CTRL_DITHER_MODE1__1 0x1
#define BV_PXP_DITHER_CTRL_DITHER_MODE1__2 0x2
#define BV_PXP_DITHER_CTRL_DITHER_MODE1__3 0x3
#define BV_PXP_DITHER_CTRL_DITHER_MODE1__4 0x4
#define BV_PXP_DITHER_CTRL_DITHER_MODE1__5 0x5
#define BV_PXP_DITHER_CTRL_DITHER_MODE1__6 0x6
#define BV_PXP_DITHER_CTRL_DITHER_MODE1__7 0x7
#define BP_PXP_DITHER_CTRL_DITHER_MODE0      3
#define BM_PXP_DITHER_CTRL_DITHER_MODE0 0x00000038
#define BF_PXP_DITHER_CTRL_DITHER_MODE0(v)  \
        (((v) << 3) & BM_PXP_DITHER_CTRL_DITHER_MODE0)
#define BV_PXP_DITHER_CTRL_DITHER_MODE0__0 0x0
#define BV_PXP_DITHER_CTRL_DITHER_MODE0__1 0x1
#define BV_PXP_DITHER_CTRL_DITHER_MODE0__2 0x2
#define BV_PXP_DITHER_CTRL_DITHER_MODE0__3 0x3
#define BV_PXP_DITHER_CTRL_DITHER_MODE0__4 0x4
#define BV_PXP_DITHER_CTRL_DITHER_MODE0__5 0x5
#define BV_PXP_DITHER_CTRL_DITHER_MODE0__6 0x6
#define BV_PXP_DITHER_CTRL_DITHER_MODE0__7 0x7
#define BM_PXP_DITHER_CTRL_ENABLE2 0x00000004
#define BF_PXP_DITHER_CTRL_ENABLE2(v)  \
        (((v) << 2) & BM_PXP_DITHER_CTRL_ENABLE2)
#define BV_PXP_DITHER_CTRL_ENABLE2__Disabled 0x0
#define BV_PXP_DITHER_CTRL_ENABLE2__Enabled  0x1
#define BM_PXP_DITHER_CTRL_ENABLE1 0x00000002
#define BF_PXP_DITHER_CTRL_ENABLE1(v)  \
        (((v) << 1) & BM_PXP_DITHER_CTRL_ENABLE1)
#define BV_PXP_DITHER_CTRL_ENABLE1__Disabled 0x0
#define BV_PXP_DITHER_CTRL_ENABLE1__Enabled  0x1
#define BM_PXP_DITHER_CTRL_ENABLE0 0x00000001
#define BF_PXP_DITHER_CTRL_ENABLE0(v)  \
        (((v) << 0) & BM_PXP_DITHER_CTRL_ENABLE0)
#define BV_PXP_DITHER_CTRL_ENABLE0__Disabled 0x0
#define BV_PXP_DITHER_CTRL_ENABLE0__Enabled  0x1

#define HW_PXP_DITHER_FINAL_LUT_DATA0	(0x00001680)
#define HW_PXP_DITHER_FINAL_LUT_DATA0_SET	(0x00001684)
#define HW_PXP_DITHER_FINAL_LUT_DATA0_CLR	(0x00001688)
#define HW_PXP_DITHER_FINAL_LUT_DATA0_TOG	(0x0000168c)

#define BP_PXP_DITHER_FINAL_LUT_DATA0_DATA3      24
#define BM_PXP_DITHER_FINAL_LUT_DATA0_DATA3 0xFF000000
#define BF_PXP_DITHER_FINAL_LUT_DATA0_DATA3(v) \
        (((v) << 24) & BM_PXP_DITHER_FINAL_LUT_DATA0_DATA3)
#define BP_PXP_DITHER_FINAL_LUT_DATA0_DATA2      16
#define BM_PXP_DITHER_FINAL_LUT_DATA0_DATA2 0x00FF0000
#define BF_PXP_DITHER_FINAL_LUT_DATA0_DATA2(v)  \
        (((v) << 16) & BM_PXP_DITHER_FINAL_LUT_DATA0_DATA2)
#define BP_PXP_DITHER_FINAL_LUT_DATA0_DATA1      8
#define BM_PXP_DITHER_FINAL_LUT_DATA0_DATA1 0x0000FF00
#define BF_PXP_DITHER_FINAL_LUT_DATA0_DATA1(v)  \
        (((v) << 8) & BM_PXP_DITHER_FINAL_LUT_DATA0_DATA1)
#define BP_PXP_DITHER_FINAL_LUT_DATA0_DATA0      0
#define BM_PXP_DITHER_FINAL_LUT_DATA0_DATA0 0x000000FF
#define BF_PXP_DITHER_FINAL_LUT_DATA0_DATA0(v)  \
        (((v) << 0) & BM_PXP_DITHER_FINAL_LUT_DATA0_DATA0)

#define HW_PXP_DITHER_FINAL_LUT_DATA1	(0x00001690)
#define HW_PXP_DITHER_FINAL_LUT_DATA1_SET	(0x00001694)
#define HW_PXP_DITHER_FINAL_LUT_DATA1_CLR	(0x00001698)
#define HW_PXP_DITHER_FINAL_LUT_DATA1_TOG	(0x0000169c)

#define BP_PXP_DITHER_FINAL_LUT_DATA1_DATA7      24
#define BM_PXP_DITHER_FINAL_LUT_DATA1_DATA7 0xFF000000
#define BF_PXP_DITHER_FINAL_LUT_DATA1_DATA7(v) \
        (((v) << 24) & BM_PXP_DITHER_FINAL_LUT_DATA1_DATA7)
#define BP_PXP_DITHER_FINAL_LUT_DATA1_DATA6      16
#define BM_PXP_DITHER_FINAL_LUT_DATA1_DATA6 0x00FF0000
#define BF_PXP_DITHER_FINAL_LUT_DATA1_DATA6(v)  \
        (((v) << 16) & BM_PXP_DITHER_FINAL_LUT_DATA1_DATA6)
#define BP_PXP_DITHER_FINAL_LUT_DATA1_DATA5      8
#define BM_PXP_DITHER_FINAL_LUT_DATA1_DATA5 0x0000FF00
#define BF_PXP_DITHER_FINAL_LUT_DATA1_DATA5(v)  \
        (((v) << 8) & BM_PXP_DITHER_FINAL_LUT_DATA1_DATA5)
#define BP_PXP_DITHER_FINAL_LUT_DATA1_DATA4      0
#define BM_PXP_DITHER_FINAL_LUT_DATA1_DATA4 0x000000FF
#define BF_PXP_DITHER_FINAL_LUT_DATA1_DATA4(v)  \
        (((v) << 0) & BM_PXP_DITHER_FINAL_LUT_DATA1_DATA4)

#define HW_PXP_DITHER_FINAL_LUT_DATA2	(0x000016a0)
#define HW_PXP_DITHER_FINAL_LUT_DATA2_SET	(0x000016a4)
#define HW_PXP_DITHER_FINAL_LUT_DATA2_CLR	(0x000016a8)
#define HW_PXP_DITHER_FINAL_LUT_DATA2_TOG	(0x000016ac)

#define BP_PXP_DITHER_FINAL_LUT_DATA2_DATA11      24
#define BM_PXP_DITHER_FINAL_LUT_DATA2_DATA11 0xFF000000
#define BF_PXP_DITHER_FINAL_LUT_DATA2_DATA11(v) \
        (((v) << 24) & BM_PXP_DITHER_FINAL_LUT_DATA2_DATA11)
#define BP_PXP_DITHER_FINAL_LUT_DATA2_DATA10      16
#define BM_PXP_DITHER_FINAL_LUT_DATA2_DATA10 0x00FF0000
#define BF_PXP_DITHER_FINAL_LUT_DATA2_DATA10(v)  \
        (((v) << 16) & BM_PXP_DITHER_FINAL_LUT_DATA2_DATA10)
#define BP_PXP_DITHER_FINAL_LUT_DATA2_DATA9      8
#define BM_PXP_DITHER_FINAL_LUT_DATA2_DATA9 0x0000FF00
#define BF_PXP_DITHER_FINAL_LUT_DATA2_DATA9(v)  \
        (((v) << 8) & BM_PXP_DITHER_FINAL_LUT_DATA2_DATA9)
#define BP_PXP_DITHER_FINAL_LUT_DATA2_DATA8      0
#define BM_PXP_DITHER_FINAL_LUT_DATA2_DATA8 0x000000FF
#define BF_PXP_DITHER_FINAL_LUT_DATA2_DATA8(v)  \
        (((v) << 0) & BM_PXP_DITHER_FINAL_LUT_DATA2_DATA8)

#define HW_PXP_DITHER_FINAL_LUT_DATA3	(0x000016b0)
#define HW_PXP_DITHER_FINAL_LUT_DATA3_SET	(0x000016b4)
#define HW_PXP_DITHER_FINAL_LUT_DATA3_CLR	(0x000016b8)
#define HW_PXP_DITHER_FINAL_LUT_DATA3_TOG	(0x000016bc)

#define BP_PXP_DITHER_FINAL_LUT_DATA3_DATA15      24
#define BM_PXP_DITHER_FINAL_LUT_DATA3_DATA15 0xFF000000
#define BF_PXP_DITHER_FINAL_LUT_DATA3_DATA15(v) \
        (((v) << 24) & BM_PXP_DITHER_FINAL_LUT_DATA3_DATA15)
#define BP_PXP_DITHER_FINAL_LUT_DATA3_DATA14      16
#define BM_PXP_DITHER_FINAL_LUT_DATA3_DATA14 0x00FF0000
#define BF_PXP_DITHER_FINAL_LUT_DATA3_DATA14(v)  \
        (((v) << 16) & BM_PXP_DITHER_FINAL_LUT_DATA3_DATA14)
#define BP_PXP_DITHER_FINAL_LUT_DATA3_DATA13      8
#define BM_PXP_DITHER_FINAL_LUT_DATA3_DATA13 0x0000FF00
#define BF_PXP_DITHER_FINAL_LUT_DATA3_DATA13(v)  \
        (((v) << 8) & BM_PXP_DITHER_FINAL_LUT_DATA3_DATA13)
#define BP_PXP_DITHER_FINAL_LUT_DATA3_DATA12      0
#define BM_PXP_DITHER_FINAL_LUT_DATA3_DATA12 0x000000FF
#define BF_PXP_DITHER_FINAL_LUT_DATA3_DATA12(v)  \
        (((v) << 0) & BM_PXP_DITHER_FINAL_LUT_DATA3_DATA12)

#define HW_PXP_WFE_A_CTRL	(0x000016c0)
#define HW_PXP_WFE_A_CTRL_SET	(0x000016c4)
#define HW_PXP_WFE_A_CTRL_CLR	(0x000016c8)
#define HW_PXP_WFE_A_CTRL_TOG	(0x000016cc)

#define BM_PXP_WFE_A_CTRL_DONE 0x80000000
#define BF_PXP_WFE_A_CTRL_DONE(v) \
        (((v) << 31) & BM_PXP_WFE_A_CTRL_DONE)
#define BP_PXP_WFE_A_CTRL_RSVD0      3
#define BM_PXP_WFE_A_CTRL_RSVD0 0x7FFFFFF8
#define BF_PXP_WFE_A_CTRL_RSVD0(v)  \
        (((v) << 3) & BM_PXP_WFE_A_CTRL_RSVD0)
#define BM_PXP_WFE_A_CTRL_SW_RESET 0x00000004
#define BF_PXP_WFE_A_CTRL_SW_RESET(v)  \
        (((v) << 2) & BM_PXP_WFE_A_CTRL_SW_RESET)
#define BM_PXP_WFE_A_CTRL_RSVD1 0x00000002
#define BF_PXP_WFE_A_CTRL_RSVD1(v)  \
        (((v) << 1) & BM_PXP_WFE_A_CTRL_RSVD1)
#define BM_PXP_WFE_A_CTRL_ENABLE 0x00000001
#define BF_PXP_WFE_A_CTRL_ENABLE(v)  \
        (((v) << 0) & BM_PXP_WFE_A_CTRL_ENABLE)
#define BV_PXP_WFE_A_CTRL_ENABLE__0 0x0
#define BV_PXP_WFE_A_CTRL_ENABLE__1 0x1

#define HW_PXP_WFE_A_DIMENSIONS	(0x000016d0)

#define BP_PXP_WFE_A_DIMENSIONS_RSVD0      28
#define BM_PXP_WFE_A_DIMENSIONS_RSVD0 0xF0000000
#define BF_PXP_WFE_A_DIMENSIONS_RSVD0(v) \
        (((v) << 28) & BM_PXP_WFE_A_DIMENSIONS_RSVD0)
#define BP_PXP_WFE_A_DIMENSIONS_HEIGHT      16
#define BM_PXP_WFE_A_DIMENSIONS_HEIGHT 0x0FFF0000
#define BF_PXP_WFE_A_DIMENSIONS_HEIGHT(v)  \
        (((v) << 16) & BM_PXP_WFE_A_DIMENSIONS_HEIGHT)
#define BP_PXP_WFE_A_DIMENSIONS_RSVD1      12
#define BM_PXP_WFE_A_DIMENSIONS_RSVD1 0x0000F000
#define BF_PXP_WFE_A_DIMENSIONS_RSVD1(v)  \
        (((v) << 12) & BM_PXP_WFE_A_DIMENSIONS_RSVD1)
#define BP_PXP_WFE_A_DIMENSIONS_WIDTH      0
#define BM_PXP_WFE_A_DIMENSIONS_WIDTH 0x00000FFF
#define BF_PXP_WFE_A_DIMENSIONS_WIDTH(v)  \
        (((v) << 0) & BM_PXP_WFE_A_DIMENSIONS_WIDTH)

#define HW_PXP_WFE_A_OFFSET	(0x000016e0)

#define BP_PXP_WFE_A_OFFSET_RSVD0      28
#define BM_PXP_WFE_A_OFFSET_RSVD0 0xF0000000
#define BF_PXP_WFE_A_OFFSET_RSVD0(v) \
        (((v) << 28) & BM_PXP_WFE_A_OFFSET_RSVD0)
#define BP_PXP_WFE_A_OFFSET_Y_OFFSET      16
#define BM_PXP_WFE_A_OFFSET_Y_OFFSET 0x0FFF0000
#define BF_PXP_WFE_A_OFFSET_Y_OFFSET(v)  \
        (((v) << 16) & BM_PXP_WFE_A_OFFSET_Y_OFFSET)
#define BP_PXP_WFE_A_OFFSET_RSVD1      12
#define BM_PXP_WFE_A_OFFSET_RSVD1 0x0000F000
#define BF_PXP_WFE_A_OFFSET_RSVD1(v)  \
        (((v) << 12) & BM_PXP_WFE_A_OFFSET_RSVD1)
#define BP_PXP_WFE_A_OFFSET_X_OFFSET      0
#define BM_PXP_WFE_A_OFFSET_X_OFFSET 0x00000FFF
#define BF_PXP_WFE_A_OFFSET_X_OFFSET(v)  \
        (((v) << 0) & BM_PXP_WFE_A_OFFSET_X_OFFSET)

#define HW_PXP_WFE_A_SW_DATA_REGS	(0x000016f0)

#define BP_PXP_WFE_A_SW_DATA_REGS_VAL3      24
#define BM_PXP_WFE_A_SW_DATA_REGS_VAL3 0xFF000000
#define BF_PXP_WFE_A_SW_DATA_REGS_VAL3(v) \
        (((v) << 24) & BM_PXP_WFE_A_SW_DATA_REGS_VAL3)
#define BP_PXP_WFE_A_SW_DATA_REGS_VAL2      16
#define BM_PXP_WFE_A_SW_DATA_REGS_VAL2 0x00FF0000
#define BF_PXP_WFE_A_SW_DATA_REGS_VAL2(v)  \
        (((v) << 16) & BM_PXP_WFE_A_SW_DATA_REGS_VAL2)
#define BP_PXP_WFE_A_SW_DATA_REGS_VAL1      8
#define BM_PXP_WFE_A_SW_DATA_REGS_VAL1 0x0000FF00
#define BF_PXP_WFE_A_SW_DATA_REGS_VAL1(v)  \
        (((v) << 8) & BM_PXP_WFE_A_SW_DATA_REGS_VAL1)
#define BP_PXP_WFE_A_SW_DATA_REGS_VAL0      0
#define BM_PXP_WFE_A_SW_DATA_REGS_VAL0 0x000000FF
#define BF_PXP_WFE_A_SW_DATA_REGS_VAL0(v)  \
        (((v) << 0) & BM_PXP_WFE_A_SW_DATA_REGS_VAL0)

#define HW_PXP_WFE_A_SW_FLAG_REGS	(0x00001700)

#define BP_PXP_WFE_A_SW_FLAG_REGS_RSVD      4
#define BM_PXP_WFE_A_SW_FLAG_REGS_RSVD 0xFFFFFFF0
#define BF_PXP_WFE_A_SW_FLAG_REGS_RSVD(v) \
        (((v) << 4) & BM_PXP_WFE_A_SW_FLAG_REGS_RSVD)
#define BM_PXP_WFE_A_SW_FLAG_REGS_VAL3 0x00000008
#define BF_PXP_WFE_A_SW_FLAG_REGS_VAL3(v)  \
        (((v) << 3) & BM_PXP_WFE_A_SW_FLAG_REGS_VAL3)
#define BM_PXP_WFE_A_SW_FLAG_REGS_VAL2 0x00000004
#define BF_PXP_WFE_A_SW_FLAG_REGS_VAL2(v)  \
        (((v) << 2) & BM_PXP_WFE_A_SW_FLAG_REGS_VAL2)
#define BM_PXP_WFE_A_SW_FLAG_REGS_VAL1 0x00000002
#define BF_PXP_WFE_A_SW_FLAG_REGS_VAL1(v)  \
        (((v) << 1) & BM_PXP_WFE_A_SW_FLAG_REGS_VAL1)
#define BM_PXP_WFE_A_SW_FLAG_REGS_VAL0 0x00000001
#define BF_PXP_WFE_A_SW_FLAG_REGS_VAL0(v)  \
        (((v) << 0) & BM_PXP_WFE_A_SW_FLAG_REGS_VAL0)

#define HW_PXP_WFE_A_STAGE1_MUX0	(0x00001710)
#define HW_PXP_WFE_A_STAGE1_MUX0_SET	(0x00001714)
#define HW_PXP_WFE_A_STAGE1_MUX0_CLR	(0x00001718)
#define HW_PXP_WFE_A_STAGE1_MUX0_TOG	(0x0000171c)

#define BP_PXP_WFE_A_STAGE1_MUX0_RSVD0      30
#define BM_PXP_WFE_A_STAGE1_MUX0_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STAGE1_MUX0_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STAGE1_MUX0_RSVD0)
#define BP_PXP_WFE_A_STAGE1_MUX0_MUX3      24
#define BM_PXP_WFE_A_STAGE1_MUX0_MUX3 0x3F000000
#define BF_PXP_WFE_A_STAGE1_MUX0_MUX3(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STAGE1_MUX0_MUX3)
#define BP_PXP_WFE_A_STAGE1_MUX0_RSVD1      22
#define BM_PXP_WFE_A_STAGE1_MUX0_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STAGE1_MUX0_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STAGE1_MUX0_RSVD1)
#define BP_PXP_WFE_A_STAGE1_MUX0_MUX2      16
#define BM_PXP_WFE_A_STAGE1_MUX0_MUX2 0x003F0000
#define BF_PXP_WFE_A_STAGE1_MUX0_MUX2(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STAGE1_MUX0_MUX2)
#define BP_PXP_WFE_A_STAGE1_MUX0_RSVD2      14
#define BM_PXP_WFE_A_STAGE1_MUX0_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STAGE1_MUX0_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STAGE1_MUX0_RSVD2)
#define BP_PXP_WFE_A_STAGE1_MUX0_MUX1      8
#define BM_PXP_WFE_A_STAGE1_MUX0_MUX1 0x00003F00
#define BF_PXP_WFE_A_STAGE1_MUX0_MUX1(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STAGE1_MUX0_MUX1)
#define BP_PXP_WFE_A_STAGE1_MUX0_RSVD3      6
#define BM_PXP_WFE_A_STAGE1_MUX0_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STAGE1_MUX0_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STAGE1_MUX0_RSVD3)
#define BP_PXP_WFE_A_STAGE1_MUX0_MUX0      0
#define BM_PXP_WFE_A_STAGE1_MUX0_MUX0 0x0000003F
#define BF_PXP_WFE_A_STAGE1_MUX0_MUX0(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STAGE1_MUX0_MUX0)

#define HW_PXP_WFE_A_STAGE1_MUX1	(0x00001720)
#define HW_PXP_WFE_A_STAGE1_MUX1_SET	(0x00001724)
#define HW_PXP_WFE_A_STAGE1_MUX1_CLR	(0x00001728)
#define HW_PXP_WFE_A_STAGE1_MUX1_TOG	(0x0000172c)

#define BP_PXP_WFE_A_STAGE1_MUX1_RSVD0      30
#define BM_PXP_WFE_A_STAGE1_MUX1_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STAGE1_MUX1_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STAGE1_MUX1_RSVD0)
#define BP_PXP_WFE_A_STAGE1_MUX1_MUX7      24
#define BM_PXP_WFE_A_STAGE1_MUX1_MUX7 0x3F000000
#define BF_PXP_WFE_A_STAGE1_MUX1_MUX7(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STAGE1_MUX1_MUX7)
#define BV_PXP_WFE_A_STAGE1_MUX1_MUX7__INC        0x0
#define BV_PXP_WFE_A_STAGE1_MUX1_MUX7__DEC        0x1
#define BV_PXP_WFE_A_STAGE1_MUX1_MUX7__ADD        0x2
#define BV_PXP_WFE_A_STAGE1_MUX1_MUX7__MINUS      0x3
#define BV_PXP_WFE_A_STAGE1_MUX1_MUX7__AND        0x4
#define BV_PXP_WFE_A_STAGE1_MUX1_MUX7__OR         0x5
#define BV_PXP_WFE_A_STAGE1_MUX1_MUX7__XOR        0x6
#define BV_PXP_WFE_A_STAGE1_MUX1_MUX7__SHIFTLEFT  0x7
#define BV_PXP_WFE_A_STAGE1_MUX1_MUX7__SHIFTRIGHT 0x8
#define BV_PXP_WFE_A_STAGE1_MUX1_MUX7__BIT_AND    0x9
#define BV_PXP_WFE_A_STAGE1_MUX1_MUX7__BIT_OR     0xa
#define BV_PXP_WFE_A_STAGE1_MUX1_MUX7__BIT_CMP    0xb
#define BV_PXP_WFE_A_STAGE1_MUX1_MUX7__NOP        0xc
#define BP_PXP_WFE_A_STAGE1_MUX1_RSVD1      22
#define BM_PXP_WFE_A_STAGE1_MUX1_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STAGE1_MUX1_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STAGE1_MUX1_RSVD1)
#define BP_PXP_WFE_A_STAGE1_MUX1_MUX6      16
#define BM_PXP_WFE_A_STAGE1_MUX1_MUX6 0x003F0000
#define BF_PXP_WFE_A_STAGE1_MUX1_MUX6(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STAGE1_MUX1_MUX6)
#define BP_PXP_WFE_A_STAGE1_MUX1_RSVD2      14
#define BM_PXP_WFE_A_STAGE1_MUX1_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STAGE1_MUX1_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STAGE1_MUX1_RSVD2)
#define BP_PXP_WFE_A_STAGE1_MUX1_MUX5      8
#define BM_PXP_WFE_A_STAGE1_MUX1_MUX5 0x00003F00
#define BF_PXP_WFE_A_STAGE1_MUX1_MUX5(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STAGE1_MUX1_MUX5)
#define BP_PXP_WFE_A_STAGE1_MUX1_RSVD3      6
#define BM_PXP_WFE_A_STAGE1_MUX1_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STAGE1_MUX1_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STAGE1_MUX1_RSVD3)
#define BP_PXP_WFE_A_STAGE1_MUX1_MUX4      0
#define BM_PXP_WFE_A_STAGE1_MUX1_MUX4 0x0000003F
#define BF_PXP_WFE_A_STAGE1_MUX1_MUX4(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STAGE1_MUX1_MUX4)
#define BV_PXP_WFE_A_STAGE1_MUX1_MUX4__INC        0x0
#define BV_PXP_WFE_A_STAGE1_MUX1_MUX4__DEC        0x1
#define BV_PXP_WFE_A_STAGE1_MUX1_MUX4__ADD        0x2
#define BV_PXP_WFE_A_STAGE1_MUX1_MUX4__MINUS      0x3
#define BV_PXP_WFE_A_STAGE1_MUX1_MUX4__AND        0x4
#define BV_PXP_WFE_A_STAGE1_MUX1_MUX4__OR         0x5
#define BV_PXP_WFE_A_STAGE1_MUX1_MUX4__XOR        0x6
#define BV_PXP_WFE_A_STAGE1_MUX1_MUX4__SHIFTLEFT  0x7
#define BV_PXP_WFE_A_STAGE1_MUX1_MUX4__SHIFTRIGHT 0x8
#define BV_PXP_WFE_A_STAGE1_MUX1_MUX4__BIT_AND    0x9
#define BV_PXP_WFE_A_STAGE1_MUX1_MUX4__BIT_OR     0xa
#define BV_PXP_WFE_A_STAGE1_MUX1_MUX4__BIT_CMP    0xb
#define BV_PXP_WFE_A_STAGE1_MUX1_MUX4__NOP        0xc

#define HW_PXP_WFE_A_STAGE1_MUX2	(0x00001730)
#define HW_PXP_WFE_A_STAGE1_MUX2_SET	(0x00001734)
#define HW_PXP_WFE_A_STAGE1_MUX2_CLR	(0x00001738)
#define HW_PXP_WFE_A_STAGE1_MUX2_TOG	(0x0000173c)

#define BP_PXP_WFE_A_STAGE1_MUX2_RSVD0      30
#define BM_PXP_WFE_A_STAGE1_MUX2_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STAGE1_MUX2_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STAGE1_MUX2_RSVD0)
#define BP_PXP_WFE_A_STAGE1_MUX2_MUX11      24
#define BM_PXP_WFE_A_STAGE1_MUX2_MUX11 0x3F000000
#define BF_PXP_WFE_A_STAGE1_MUX2_MUX11(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STAGE1_MUX2_MUX11)
#define BP_PXP_WFE_A_STAGE1_MUX2_RSVD1      22
#define BM_PXP_WFE_A_STAGE1_MUX2_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STAGE1_MUX2_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STAGE1_MUX2_RSVD1)
#define BP_PXP_WFE_A_STAGE1_MUX2_MUX10      16
#define BM_PXP_WFE_A_STAGE1_MUX2_MUX10 0x003F0000
#define BF_PXP_WFE_A_STAGE1_MUX2_MUX10(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STAGE1_MUX2_MUX10)
#define BP_PXP_WFE_A_STAGE1_MUX2_RSVD2      14
#define BM_PXP_WFE_A_STAGE1_MUX2_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STAGE1_MUX2_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STAGE1_MUX2_RSVD2)
#define BP_PXP_WFE_A_STAGE1_MUX2_MUX9      8
#define BM_PXP_WFE_A_STAGE1_MUX2_MUX9 0x00003F00
#define BF_PXP_WFE_A_STAGE1_MUX2_MUX9(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STAGE1_MUX2_MUX9)
#define BP_PXP_WFE_A_STAGE1_MUX2_RSVD3      6
#define BM_PXP_WFE_A_STAGE1_MUX2_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STAGE1_MUX2_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STAGE1_MUX2_RSVD3)
#define BP_PXP_WFE_A_STAGE1_MUX2_MUX8      0
#define BM_PXP_WFE_A_STAGE1_MUX2_MUX8 0x0000003F
#define BF_PXP_WFE_A_STAGE1_MUX2_MUX8(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STAGE1_MUX2_MUX8)

#define HW_PXP_WFE_A_STAGE1_MUX3	(0x00001740)
#define HW_PXP_WFE_A_STAGE1_MUX3_SET	(0x00001744)
#define HW_PXP_WFE_A_STAGE1_MUX3_CLR	(0x00001748)
#define HW_PXP_WFE_A_STAGE1_MUX3_TOG	(0x0000174c)

#define BP_PXP_WFE_A_STAGE1_MUX3_RSVD0      30
#define BM_PXP_WFE_A_STAGE1_MUX3_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STAGE1_MUX3_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STAGE1_MUX3_RSVD0)
#define BP_PXP_WFE_A_STAGE1_MUX3_MUX15      24
#define BM_PXP_WFE_A_STAGE1_MUX3_MUX15 0x3F000000
#define BF_PXP_WFE_A_STAGE1_MUX3_MUX15(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STAGE1_MUX3_MUX15)
#define BP_PXP_WFE_A_STAGE1_MUX3_RSVD1      22
#define BM_PXP_WFE_A_STAGE1_MUX3_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STAGE1_MUX3_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STAGE1_MUX3_RSVD1)
#define BP_PXP_WFE_A_STAGE1_MUX3_MUX14      16
#define BM_PXP_WFE_A_STAGE1_MUX3_MUX14 0x003F0000
#define BF_PXP_WFE_A_STAGE1_MUX3_MUX14(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STAGE1_MUX3_MUX14)
#define BP_PXP_WFE_A_STAGE1_MUX3_RSVD2      14
#define BM_PXP_WFE_A_STAGE1_MUX3_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STAGE1_MUX3_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STAGE1_MUX3_RSVD2)
#define BP_PXP_WFE_A_STAGE1_MUX3_MUX13      8
#define BM_PXP_WFE_A_STAGE1_MUX3_MUX13 0x00003F00
#define BF_PXP_WFE_A_STAGE1_MUX3_MUX13(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STAGE1_MUX3_MUX13)
#define BP_PXP_WFE_A_STAGE1_MUX3_RSVD3      6
#define BM_PXP_WFE_A_STAGE1_MUX3_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STAGE1_MUX3_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STAGE1_MUX3_RSVD3)
#define BP_PXP_WFE_A_STAGE1_MUX3_MUX12      0
#define BM_PXP_WFE_A_STAGE1_MUX3_MUX12 0x0000003F
#define BF_PXP_WFE_A_STAGE1_MUX3_MUX12(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STAGE1_MUX3_MUX12)

#define HW_PXP_WFE_A_STAGE1_MUX4	(0x00001750)
#define HW_PXP_WFE_A_STAGE1_MUX4_SET	(0x00001754)
#define HW_PXP_WFE_A_STAGE1_MUX4_CLR	(0x00001758)
#define HW_PXP_WFE_A_STAGE1_MUX4_TOG	(0x0000175c)

#define BP_PXP_WFE_A_STAGE1_MUX4_RSVD0      24
#define BM_PXP_WFE_A_STAGE1_MUX4_RSVD0 0xFF000000
#define BF_PXP_WFE_A_STAGE1_MUX4_RSVD0(v) \
        (((v) << 24) & BM_PXP_WFE_A_STAGE1_MUX4_RSVD0)
#define BP_PXP_WFE_A_STAGE1_MUX4_RSVD1      16
#define BM_PXP_WFE_A_STAGE1_MUX4_RSVD1 0x00FF0000
#define BF_PXP_WFE_A_STAGE1_MUX4_RSVD1(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STAGE1_MUX4_RSVD1)
#define BP_PXP_WFE_A_STAGE1_MUX4_RSVD2      14
#define BM_PXP_WFE_A_STAGE1_MUX4_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STAGE1_MUX4_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STAGE1_MUX4_RSVD2)
#define BP_PXP_WFE_A_STAGE1_MUX4_MUX17      8
#define BM_PXP_WFE_A_STAGE1_MUX4_MUX17 0x00003F00
#define BF_PXP_WFE_A_STAGE1_MUX4_MUX17(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STAGE1_MUX4_MUX17)
#define BP_PXP_WFE_A_STAGE1_MUX4_RSVD3      6
#define BM_PXP_WFE_A_STAGE1_MUX4_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STAGE1_MUX4_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STAGE1_MUX4_RSVD3)
#define BP_PXP_WFE_A_STAGE1_MUX4_MUX16      0
#define BM_PXP_WFE_A_STAGE1_MUX4_MUX16 0x0000003F
#define BF_PXP_WFE_A_STAGE1_MUX4_MUX16(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STAGE1_MUX4_MUX16)

#define HW_PXP_WFE_A_STAGE2_MUX0	(0x00001760)
#define HW_PXP_WFE_A_STAGE2_MUX0_SET	(0x00001764)
#define HW_PXP_WFE_A_STAGE2_MUX0_CLR	(0x00001768)
#define HW_PXP_WFE_A_STAGE2_MUX0_TOG	(0x0000176c)

#define BP_PXP_WFE_A_STAGE2_MUX0_RSVD0      30
#define BM_PXP_WFE_A_STAGE2_MUX0_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STAGE2_MUX0_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STAGE2_MUX0_RSVD0)
#define BP_PXP_WFE_A_STAGE2_MUX0_MUX3      24
#define BM_PXP_WFE_A_STAGE2_MUX0_MUX3 0x3F000000
#define BF_PXP_WFE_A_STAGE2_MUX0_MUX3(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STAGE2_MUX0_MUX3)
#define BP_PXP_WFE_A_STAGE2_MUX0_RSVD1      22
#define BM_PXP_WFE_A_STAGE2_MUX0_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STAGE2_MUX0_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STAGE2_MUX0_RSVD1)
#define BP_PXP_WFE_A_STAGE2_MUX0_MUX2      16
#define BM_PXP_WFE_A_STAGE2_MUX0_MUX2 0x003F0000
#define BF_PXP_WFE_A_STAGE2_MUX0_MUX2(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STAGE2_MUX0_MUX2)
#define BP_PXP_WFE_A_STAGE2_MUX0_RSVD2      14
#define BM_PXP_WFE_A_STAGE2_MUX0_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STAGE2_MUX0_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STAGE2_MUX0_RSVD2)
#define BP_PXP_WFE_A_STAGE2_MUX0_MUX1      8
#define BM_PXP_WFE_A_STAGE2_MUX0_MUX1 0x00003F00
#define BF_PXP_WFE_A_STAGE2_MUX0_MUX1(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STAGE2_MUX0_MUX1)
#define BP_PXP_WFE_A_STAGE2_MUX0_RSVD3      6
#define BM_PXP_WFE_A_STAGE2_MUX0_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STAGE2_MUX0_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STAGE2_MUX0_RSVD3)
#define BP_PXP_WFE_A_STAGE2_MUX0_MUX0      0
#define BM_PXP_WFE_A_STAGE2_MUX0_MUX0 0x0000003F
#define BF_PXP_WFE_A_STAGE2_MUX0_MUX0(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STAGE2_MUX0_MUX0)

#define HW_PXP_WFE_A_STAGE2_MUX1	(0x00001770)
#define HW_PXP_WFE_A_STAGE2_MUX1_SET	(0x00001774)
#define HW_PXP_WFE_A_STAGE2_MUX1_CLR	(0x00001778)
#define HW_PXP_WFE_A_STAGE2_MUX1_TOG	(0x0000177c)

#define BP_PXP_WFE_A_STAGE2_MUX1_RSVD0      30
#define BM_PXP_WFE_A_STAGE2_MUX1_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STAGE2_MUX1_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STAGE2_MUX1_RSVD0)
#define BP_PXP_WFE_A_STAGE2_MUX1_MUX7      24
#define BM_PXP_WFE_A_STAGE2_MUX1_MUX7 0x3F000000
#define BF_PXP_WFE_A_STAGE2_MUX1_MUX7(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STAGE2_MUX1_MUX7)
#define BP_PXP_WFE_A_STAGE2_MUX1_RSVD1      22
#define BM_PXP_WFE_A_STAGE2_MUX1_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STAGE2_MUX1_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STAGE2_MUX1_RSVD1)
#define BP_PXP_WFE_A_STAGE2_MUX1_MUX6      16
#define BM_PXP_WFE_A_STAGE2_MUX1_MUX6 0x003F0000
#define BF_PXP_WFE_A_STAGE2_MUX1_MUX6(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STAGE2_MUX1_MUX6)
#define BP_PXP_WFE_A_STAGE2_MUX1_RSVD2      14
#define BM_PXP_WFE_A_STAGE2_MUX1_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STAGE2_MUX1_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STAGE2_MUX1_RSVD2)
#define BP_PXP_WFE_A_STAGE2_MUX1_MUX5      8
#define BM_PXP_WFE_A_STAGE2_MUX1_MUX5 0x00003F00
#define BF_PXP_WFE_A_STAGE2_MUX1_MUX5(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STAGE2_MUX1_MUX5)
#define BP_PXP_WFE_A_STAGE2_MUX1_RSVD3      6
#define BM_PXP_WFE_A_STAGE2_MUX1_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STAGE2_MUX1_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STAGE2_MUX1_RSVD3)
#define BP_PXP_WFE_A_STAGE2_MUX1_MUX4      0
#define BM_PXP_WFE_A_STAGE2_MUX1_MUX4 0x0000003F
#define BF_PXP_WFE_A_STAGE2_MUX1_MUX4(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STAGE2_MUX1_MUX4)

#define HW_PXP_WFE_A_STAGE2_MUX2	(0x00001780)
#define HW_PXP_WFE_A_STAGE2_MUX2_SET	(0x00001784)
#define HW_PXP_WFE_A_STAGE2_MUX2_CLR	(0x00001788)
#define HW_PXP_WFE_A_STAGE2_MUX2_TOG	(0x0000178c)

#define BP_PXP_WFE_A_STAGE2_MUX2_RSVD0      30
#define BM_PXP_WFE_A_STAGE2_MUX2_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STAGE2_MUX2_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STAGE2_MUX2_RSVD0)
#define BP_PXP_WFE_A_STAGE2_MUX2_MUX11      24
#define BM_PXP_WFE_A_STAGE2_MUX2_MUX11 0x3F000000
#define BF_PXP_WFE_A_STAGE2_MUX2_MUX11(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STAGE2_MUX2_MUX11)
#define BP_PXP_WFE_A_STAGE2_MUX2_RSVD1      22
#define BM_PXP_WFE_A_STAGE2_MUX2_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STAGE2_MUX2_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STAGE2_MUX2_RSVD1)
#define BP_PXP_WFE_A_STAGE2_MUX2_MUX10      16
#define BM_PXP_WFE_A_STAGE2_MUX2_MUX10 0x003F0000
#define BF_PXP_WFE_A_STAGE2_MUX2_MUX10(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STAGE2_MUX2_MUX10)
#define BP_PXP_WFE_A_STAGE2_MUX2_RSVD2      14
#define BM_PXP_WFE_A_STAGE2_MUX2_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STAGE2_MUX2_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STAGE2_MUX2_RSVD2)
#define BP_PXP_WFE_A_STAGE2_MUX2_MUX9      8
#define BM_PXP_WFE_A_STAGE2_MUX2_MUX9 0x00003F00
#define BF_PXP_WFE_A_STAGE2_MUX2_MUX9(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STAGE2_MUX2_MUX9)
#define BP_PXP_WFE_A_STAGE2_MUX2_RSVD3      6
#define BM_PXP_WFE_A_STAGE2_MUX2_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STAGE2_MUX2_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STAGE2_MUX2_RSVD3)
#define BP_PXP_WFE_A_STAGE2_MUX2_MUX8      0
#define BM_PXP_WFE_A_STAGE2_MUX2_MUX8 0x0000003F
#define BF_PXP_WFE_A_STAGE2_MUX2_MUX8(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STAGE2_MUX2_MUX8)

#define HW_PXP_WFE_A_STAGE2_MUX3	(0x00001790)
#define HW_PXP_WFE_A_STAGE2_MUX3_SET	(0x00001794)
#define HW_PXP_WFE_A_STAGE2_MUX3_CLR	(0x00001798)
#define HW_PXP_WFE_A_STAGE2_MUX3_TOG	(0x0000179c)

#define BP_PXP_WFE_A_STAGE2_MUX3_RSVD0      30
#define BM_PXP_WFE_A_STAGE2_MUX3_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STAGE2_MUX3_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STAGE2_MUX3_RSVD0)
#define BP_PXP_WFE_A_STAGE2_MUX3_MUX15      24
#define BM_PXP_WFE_A_STAGE2_MUX3_MUX15 0x3F000000
#define BF_PXP_WFE_A_STAGE2_MUX3_MUX15(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STAGE2_MUX3_MUX15)
#define BP_PXP_WFE_A_STAGE2_MUX3_RSVD1      22
#define BM_PXP_WFE_A_STAGE2_MUX3_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STAGE2_MUX3_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STAGE2_MUX3_RSVD1)
#define BP_PXP_WFE_A_STAGE2_MUX3_MUX14      16
#define BM_PXP_WFE_A_STAGE2_MUX3_MUX14 0x003F0000
#define BF_PXP_WFE_A_STAGE2_MUX3_MUX14(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STAGE2_MUX3_MUX14)
#define BP_PXP_WFE_A_STAGE2_MUX3_RSVD2      14
#define BM_PXP_WFE_A_STAGE2_MUX3_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STAGE2_MUX3_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STAGE2_MUX3_RSVD2)
#define BP_PXP_WFE_A_STAGE2_MUX3_MUX13      8
#define BM_PXP_WFE_A_STAGE2_MUX3_MUX13 0x00003F00
#define BF_PXP_WFE_A_STAGE2_MUX3_MUX13(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STAGE2_MUX3_MUX13)
#define BP_PXP_WFE_A_STAGE2_MUX3_RSVD3      6
#define BM_PXP_WFE_A_STAGE2_MUX3_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STAGE2_MUX3_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STAGE2_MUX3_RSVD3)
#define BP_PXP_WFE_A_STAGE2_MUX3_MUX12      0
#define BM_PXP_WFE_A_STAGE2_MUX3_MUX12 0x0000003F
#define BF_PXP_WFE_A_STAGE2_MUX3_MUX12(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STAGE2_MUX3_MUX12)

#define HW_PXP_WFE_A_STAGE2_MUX4	(0x000017a0)
#define HW_PXP_WFE_A_STAGE2_MUX4_SET	(0x000017a4)
#define HW_PXP_WFE_A_STAGE2_MUX4_CLR	(0x000017a8)
#define HW_PXP_WFE_A_STAGE2_MUX4_TOG	(0x000017ac)

#define BP_PXP_WFE_A_STAGE2_MUX4_RSVD0      30
#define BM_PXP_WFE_A_STAGE2_MUX4_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STAGE2_MUX4_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STAGE2_MUX4_RSVD0)
#define BP_PXP_WFE_A_STAGE2_MUX4_MUX19      24
#define BM_PXP_WFE_A_STAGE2_MUX4_MUX19 0x3F000000
#define BF_PXP_WFE_A_STAGE2_MUX4_MUX19(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STAGE2_MUX4_MUX19)
#define BP_PXP_WFE_A_STAGE2_MUX4_RSVD1      22
#define BM_PXP_WFE_A_STAGE2_MUX4_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STAGE2_MUX4_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STAGE2_MUX4_RSVD1)
#define BP_PXP_WFE_A_STAGE2_MUX4_MUX18      16
#define BM_PXP_WFE_A_STAGE2_MUX4_MUX18 0x003F0000
#define BF_PXP_WFE_A_STAGE2_MUX4_MUX18(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STAGE2_MUX4_MUX18)
#define BP_PXP_WFE_A_STAGE2_MUX4_RSVD2      14
#define BM_PXP_WFE_A_STAGE2_MUX4_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STAGE2_MUX4_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STAGE2_MUX4_RSVD2)
#define BP_PXP_WFE_A_STAGE2_MUX4_MUX17      8
#define BM_PXP_WFE_A_STAGE2_MUX4_MUX17 0x00003F00
#define BF_PXP_WFE_A_STAGE2_MUX4_MUX17(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STAGE2_MUX4_MUX17)
#define BP_PXP_WFE_A_STAGE2_MUX4_RSVD3      6
#define BM_PXP_WFE_A_STAGE2_MUX4_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STAGE2_MUX4_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STAGE2_MUX4_RSVD3)
#define BP_PXP_WFE_A_STAGE2_MUX4_MUX16      0
#define BM_PXP_WFE_A_STAGE2_MUX4_MUX16 0x0000003F
#define BF_PXP_WFE_A_STAGE2_MUX4_MUX16(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STAGE2_MUX4_MUX16)

#define HW_PXP_WFE_A_STAGE2_MUX5	(0x000017b0)
#define HW_PXP_WFE_A_STAGE2_MUX5_SET	(0x000017b4)
#define HW_PXP_WFE_A_STAGE2_MUX5_CLR	(0x000017b8)
#define HW_PXP_WFE_A_STAGE2_MUX5_TOG	(0x000017bc)

#define BP_PXP_WFE_A_STAGE2_MUX5_RSVD0      30
#define BM_PXP_WFE_A_STAGE2_MUX5_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STAGE2_MUX5_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STAGE2_MUX5_RSVD0)
#define BP_PXP_WFE_A_STAGE2_MUX5_MUX23      24
#define BM_PXP_WFE_A_STAGE2_MUX5_MUX23 0x3F000000
#define BF_PXP_WFE_A_STAGE2_MUX5_MUX23(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STAGE2_MUX5_MUX23)
#define BP_PXP_WFE_A_STAGE2_MUX5_RSVD1      22
#define BM_PXP_WFE_A_STAGE2_MUX5_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STAGE2_MUX5_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STAGE2_MUX5_RSVD1)
#define BP_PXP_WFE_A_STAGE2_MUX5_MUX22      16
#define BM_PXP_WFE_A_STAGE2_MUX5_MUX22 0x003F0000
#define BF_PXP_WFE_A_STAGE2_MUX5_MUX22(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STAGE2_MUX5_MUX22)
#define BP_PXP_WFE_A_STAGE2_MUX5_RSVD2      14
#define BM_PXP_WFE_A_STAGE2_MUX5_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STAGE2_MUX5_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STAGE2_MUX5_RSVD2)
#define BP_PXP_WFE_A_STAGE2_MUX5_MUX21      8
#define BM_PXP_WFE_A_STAGE2_MUX5_MUX21 0x00003F00
#define BF_PXP_WFE_A_STAGE2_MUX5_MUX21(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STAGE2_MUX5_MUX21)
#define BP_PXP_WFE_A_STAGE2_MUX5_RSVD3      6
#define BM_PXP_WFE_A_STAGE2_MUX5_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STAGE2_MUX5_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STAGE2_MUX5_RSVD3)
#define BP_PXP_WFE_A_STAGE2_MUX5_MUX20      0
#define BM_PXP_WFE_A_STAGE2_MUX5_MUX20 0x0000003F
#define BF_PXP_WFE_A_STAGE2_MUX5_MUX20(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STAGE2_MUX5_MUX20)

#define HW_PXP_WFE_A_STAGE2_MUX6	(0x000017c0)
#define HW_PXP_WFE_A_STAGE2_MUX6_SET	(0x000017c4)
#define HW_PXP_WFE_A_STAGE2_MUX6_CLR	(0x000017c8)
#define HW_PXP_WFE_A_STAGE2_MUX6_TOG	(0x000017cc)

#define BP_PXP_WFE_A_STAGE2_MUX6_RSVD0      30
#define BM_PXP_WFE_A_STAGE2_MUX6_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STAGE2_MUX6_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STAGE2_MUX6_RSVD0)
#define BP_PXP_WFE_A_STAGE2_MUX6_MUX27      24
#define BM_PXP_WFE_A_STAGE2_MUX6_MUX27 0x3F000000
#define BF_PXP_WFE_A_STAGE2_MUX6_MUX27(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STAGE2_MUX6_MUX27)
#define BP_PXP_WFE_A_STAGE2_MUX6_RSVD1      22
#define BM_PXP_WFE_A_STAGE2_MUX6_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STAGE2_MUX6_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STAGE2_MUX6_RSVD1)
#define BP_PXP_WFE_A_STAGE2_MUX6_MUX26      16
#define BM_PXP_WFE_A_STAGE2_MUX6_MUX26 0x003F0000
#define BF_PXP_WFE_A_STAGE2_MUX6_MUX26(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STAGE2_MUX6_MUX26)
#define BP_PXP_WFE_A_STAGE2_MUX6_RSVD2      14
#define BM_PXP_WFE_A_STAGE2_MUX6_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STAGE2_MUX6_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STAGE2_MUX6_RSVD2)
#define BP_PXP_WFE_A_STAGE2_MUX6_MUX25      8
#define BM_PXP_WFE_A_STAGE2_MUX6_MUX25 0x00003F00
#define BF_PXP_WFE_A_STAGE2_MUX6_MUX25(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STAGE2_MUX6_MUX25)
#define BP_PXP_WFE_A_STAGE2_MUX6_RSVD3      6
#define BM_PXP_WFE_A_STAGE2_MUX6_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STAGE2_MUX6_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STAGE2_MUX6_RSVD3)
#define BP_PXP_WFE_A_STAGE2_MUX6_MUX24      0
#define BM_PXP_WFE_A_STAGE2_MUX6_MUX24 0x0000003F
#define BF_PXP_WFE_A_STAGE2_MUX6_MUX24(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STAGE2_MUX6_MUX24)

#define HW_PXP_WFE_A_STAGE2_MUX7	(0x000017d0)
#define HW_PXP_WFE_A_STAGE2_MUX7_SET	(0x000017d4)
#define HW_PXP_WFE_A_STAGE2_MUX7_CLR	(0x000017d8)
#define HW_PXP_WFE_A_STAGE2_MUX7_TOG	(0x000017dc)

#define BP_PXP_WFE_A_STAGE2_MUX7_RSVD0      30
#define BM_PXP_WFE_A_STAGE2_MUX7_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STAGE2_MUX7_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STAGE2_MUX7_RSVD0)
#define BP_PXP_WFE_A_STAGE2_MUX7_MUX31      24
#define BM_PXP_WFE_A_STAGE2_MUX7_MUX31 0x3F000000
#define BF_PXP_WFE_A_STAGE2_MUX7_MUX31(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STAGE2_MUX7_MUX31)
#define BP_PXP_WFE_A_STAGE2_MUX7_RSVD1      22
#define BM_PXP_WFE_A_STAGE2_MUX7_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STAGE2_MUX7_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STAGE2_MUX7_RSVD1)
#define BP_PXP_WFE_A_STAGE2_MUX7_MUX30      16
#define BM_PXP_WFE_A_STAGE2_MUX7_MUX30 0x003F0000
#define BF_PXP_WFE_A_STAGE2_MUX7_MUX30(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STAGE2_MUX7_MUX30)
#define BP_PXP_WFE_A_STAGE2_MUX7_RSVD2      14
#define BM_PXP_WFE_A_STAGE2_MUX7_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STAGE2_MUX7_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STAGE2_MUX7_RSVD2)
#define BP_PXP_WFE_A_STAGE2_MUX7_MUX29      8
#define BM_PXP_WFE_A_STAGE2_MUX7_MUX29 0x00003F00
#define BF_PXP_WFE_A_STAGE2_MUX7_MUX29(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STAGE2_MUX7_MUX29)
#define BP_PXP_WFE_A_STAGE2_MUX7_RSVD3      6
#define BM_PXP_WFE_A_STAGE2_MUX7_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STAGE2_MUX7_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STAGE2_MUX7_RSVD3)
#define BP_PXP_WFE_A_STAGE2_MUX7_MUX28      0
#define BM_PXP_WFE_A_STAGE2_MUX7_MUX28 0x0000003F
#define BF_PXP_WFE_A_STAGE2_MUX7_MUX28(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STAGE2_MUX7_MUX28)

#define HW_PXP_WFE_A_STAGE2_MUX8	(0x000017e0)
#define HW_PXP_WFE_A_STAGE2_MUX8_SET	(0x000017e4)
#define HW_PXP_WFE_A_STAGE2_MUX8_CLR	(0x000017e8)
#define HW_PXP_WFE_A_STAGE2_MUX8_TOG	(0x000017ec)

#define BP_PXP_WFE_A_STAGE2_MUX8_RSVD0      30
#define BM_PXP_WFE_A_STAGE2_MUX8_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STAGE2_MUX8_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STAGE2_MUX8_RSVD0)
#define BP_PXP_WFE_A_STAGE2_MUX8_MUX35      24
#define BM_PXP_WFE_A_STAGE2_MUX8_MUX35 0x3F000000
#define BF_PXP_WFE_A_STAGE2_MUX8_MUX35(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STAGE2_MUX8_MUX35)
#define BP_PXP_WFE_A_STAGE2_MUX8_RSVD1      22
#define BM_PXP_WFE_A_STAGE2_MUX8_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STAGE2_MUX8_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STAGE2_MUX8_RSVD1)
#define BP_PXP_WFE_A_STAGE2_MUX8_MUX34      16
#define BM_PXP_WFE_A_STAGE2_MUX8_MUX34 0x003F0000
#define BF_PXP_WFE_A_STAGE2_MUX8_MUX34(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STAGE2_MUX8_MUX34)
#define BP_PXP_WFE_A_STAGE2_MUX8_RSVD2      14
#define BM_PXP_WFE_A_STAGE2_MUX8_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STAGE2_MUX8_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STAGE2_MUX8_RSVD2)
#define BP_PXP_WFE_A_STAGE2_MUX8_MUX33      8
#define BM_PXP_WFE_A_STAGE2_MUX8_MUX33 0x00003F00
#define BF_PXP_WFE_A_STAGE2_MUX8_MUX33(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STAGE2_MUX8_MUX33)
#define BP_PXP_WFE_A_STAGE2_MUX8_RSVD3      6
#define BM_PXP_WFE_A_STAGE2_MUX8_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STAGE2_MUX8_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STAGE2_MUX8_RSVD3)
#define BP_PXP_WFE_A_STAGE2_MUX8_MUX32      0
#define BM_PXP_WFE_A_STAGE2_MUX8_MUX32 0x0000003F
#define BF_PXP_WFE_A_STAGE2_MUX8_MUX32(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STAGE2_MUX8_MUX32)

#define HW_PXP_WFE_A_STAGE2_MUX9	(0x000017f0)
#define HW_PXP_WFE_A_STAGE2_MUX9_SET	(0x000017f4)
#define HW_PXP_WFE_A_STAGE2_MUX9_CLR	(0x000017f8)
#define HW_PXP_WFE_A_STAGE2_MUX9_TOG	(0x000017fc)

#define BP_PXP_WFE_A_STAGE2_MUX9_RSVD0      30
#define BM_PXP_WFE_A_STAGE2_MUX9_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STAGE2_MUX9_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STAGE2_MUX9_RSVD0)
#define BP_PXP_WFE_A_STAGE2_MUX9_MUX39      24
#define BM_PXP_WFE_A_STAGE2_MUX9_MUX39 0x3F000000
#define BF_PXP_WFE_A_STAGE2_MUX9_MUX39(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STAGE2_MUX9_MUX39)
#define BP_PXP_WFE_A_STAGE2_MUX9_RSVD1      22
#define BM_PXP_WFE_A_STAGE2_MUX9_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STAGE2_MUX9_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STAGE2_MUX9_RSVD1)
#define BP_PXP_WFE_A_STAGE2_MUX9_MUX38      16
#define BM_PXP_WFE_A_STAGE2_MUX9_MUX38 0x003F0000
#define BF_PXP_WFE_A_STAGE2_MUX9_MUX38(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STAGE2_MUX9_MUX38)
#define BP_PXP_WFE_A_STAGE2_MUX9_RSVD2      14
#define BM_PXP_WFE_A_STAGE2_MUX9_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STAGE2_MUX9_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STAGE2_MUX9_RSVD2)
#define BP_PXP_WFE_A_STAGE2_MUX9_MUX37      8
#define BM_PXP_WFE_A_STAGE2_MUX9_MUX37 0x00003F00
#define BF_PXP_WFE_A_STAGE2_MUX9_MUX37(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STAGE2_MUX9_MUX37)
#define BP_PXP_WFE_A_STAGE2_MUX9_RSVD3      6
#define BM_PXP_WFE_A_STAGE2_MUX9_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STAGE2_MUX9_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STAGE2_MUX9_RSVD3)
#define BP_PXP_WFE_A_STAGE2_MUX9_MUX36      0
#define BM_PXP_WFE_A_STAGE2_MUX9_MUX36 0x0000003F
#define BF_PXP_WFE_A_STAGE2_MUX9_MUX36(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STAGE2_MUX9_MUX36)

#define HW_PXP_WFE_A_STAGE2_MUX10	(0x00001800)
#define HW_PXP_WFE_A_STAGE2_MUX10_SET	(0x00001804)
#define HW_PXP_WFE_A_STAGE2_MUX10_CLR	(0x00001808)
#define HW_PXP_WFE_A_STAGE2_MUX10_TOG	(0x0000180c)

#define BP_PXP_WFE_A_STAGE2_MUX10_RSVD0      30
#define BM_PXP_WFE_A_STAGE2_MUX10_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STAGE2_MUX10_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STAGE2_MUX10_RSVD0)
#define BP_PXP_WFE_A_STAGE2_MUX10_MUX43      24
#define BM_PXP_WFE_A_STAGE2_MUX10_MUX43 0x3F000000
#define BF_PXP_WFE_A_STAGE2_MUX10_MUX43(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STAGE2_MUX10_MUX43)
#define BV_PXP_WFE_A_STAGE2_MUX10_MUX43__INC        0x0
#define BV_PXP_WFE_A_STAGE2_MUX10_MUX43__DEC        0x1
#define BV_PXP_WFE_A_STAGE2_MUX10_MUX43__ADD        0x2
#define BV_PXP_WFE_A_STAGE2_MUX10_MUX43__MINUS      0x3
#define BV_PXP_WFE_A_STAGE2_MUX10_MUX43__AND        0x4
#define BV_PXP_WFE_A_STAGE2_MUX10_MUX43__OR         0x5
#define BV_PXP_WFE_A_STAGE2_MUX10_MUX43__XOR        0x6
#define BV_PXP_WFE_A_STAGE2_MUX10_MUX43__SHIFTLEFT  0x7
#define BV_PXP_WFE_A_STAGE2_MUX10_MUX43__SHIFTRIGHT 0x8
#define BV_PXP_WFE_A_STAGE2_MUX10_MUX43__BIT_AND    0x9
#define BV_PXP_WFE_A_STAGE2_MUX10_MUX43__BIT_OR     0xa
#define BV_PXP_WFE_A_STAGE2_MUX10_MUX43__BIT_CMP    0xb
#define BV_PXP_WFE_A_STAGE2_MUX10_MUX43__NOP        0xc
#define BP_PXP_WFE_A_STAGE2_MUX10_RSVD1      22
#define BM_PXP_WFE_A_STAGE2_MUX10_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STAGE2_MUX10_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STAGE2_MUX10_RSVD1)
#define BP_PXP_WFE_A_STAGE2_MUX10_MUX42      16
#define BM_PXP_WFE_A_STAGE2_MUX10_MUX42 0x003F0000
#define BF_PXP_WFE_A_STAGE2_MUX10_MUX42(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STAGE2_MUX10_MUX42)
#define BP_PXP_WFE_A_STAGE2_MUX10_RSVD2      14
#define BM_PXP_WFE_A_STAGE2_MUX10_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STAGE2_MUX10_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STAGE2_MUX10_RSVD2)
#define BP_PXP_WFE_A_STAGE2_MUX10_MUX41      8
#define BM_PXP_WFE_A_STAGE2_MUX10_MUX41 0x00003F00
#define BF_PXP_WFE_A_STAGE2_MUX10_MUX41(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STAGE2_MUX10_MUX41)
#define BP_PXP_WFE_A_STAGE2_MUX10_RSVD3      6
#define BM_PXP_WFE_A_STAGE2_MUX10_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STAGE2_MUX10_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STAGE2_MUX10_RSVD3)
#define BP_PXP_WFE_A_STAGE2_MUX10_MUX40      0
#define BM_PXP_WFE_A_STAGE2_MUX10_MUX40 0x0000003F
#define BF_PXP_WFE_A_STAGE2_MUX10_MUX40(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STAGE2_MUX10_MUX40)
#define BV_PXP_WFE_A_STAGE2_MUX10_MUX40__INC        0x0
#define BV_PXP_WFE_A_STAGE2_MUX10_MUX40__DEC        0x1
#define BV_PXP_WFE_A_STAGE2_MUX10_MUX40__ADD        0x2
#define BV_PXP_WFE_A_STAGE2_MUX10_MUX40__MINUS      0x3
#define BV_PXP_WFE_A_STAGE2_MUX10_MUX40__AND        0x4
#define BV_PXP_WFE_A_STAGE2_MUX10_MUX40__OR         0x5
#define BV_PXP_WFE_A_STAGE2_MUX10_MUX40__XOR        0x6
#define BV_PXP_WFE_A_STAGE2_MUX10_MUX40__SHIFTLEFT  0x7
#define BV_PXP_WFE_A_STAGE2_MUX10_MUX40__SHIFTRIGHT 0x8
#define BV_PXP_WFE_A_STAGE2_MUX10_MUX40__BIT_AND    0x9
#define BV_PXP_WFE_A_STAGE2_MUX10_MUX40__BIT_OR     0xa
#define BV_PXP_WFE_A_STAGE2_MUX10_MUX40__BIT_CMP    0xb
#define BV_PXP_WFE_A_STAGE2_MUX10_MUX40__NOP        0xc

#define HW_PXP_WFE_A_STAGE2_MUX11	(0x00001810)
#define HW_PXP_WFE_A_STAGE2_MUX11_SET	(0x00001814)
#define HW_PXP_WFE_A_STAGE2_MUX11_CLR	(0x00001818)
#define HW_PXP_WFE_A_STAGE2_MUX11_TOG	(0x0000181c)

#define BP_PXP_WFE_A_STAGE2_MUX11_RSVD0      30
#define BM_PXP_WFE_A_STAGE2_MUX11_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STAGE2_MUX11_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STAGE2_MUX11_RSVD0)
#define BP_PXP_WFE_A_STAGE2_MUX11_MUX47      24
#define BM_PXP_WFE_A_STAGE2_MUX11_MUX47 0x3F000000
#define BF_PXP_WFE_A_STAGE2_MUX11_MUX47(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STAGE2_MUX11_MUX47)
#define BP_PXP_WFE_A_STAGE2_MUX11_RSVD1      22
#define BM_PXP_WFE_A_STAGE2_MUX11_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STAGE2_MUX11_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STAGE2_MUX11_RSVD1)
#define BP_PXP_WFE_A_STAGE2_MUX11_MUX46      16
#define BM_PXP_WFE_A_STAGE2_MUX11_MUX46 0x003F0000
#define BF_PXP_WFE_A_STAGE2_MUX11_MUX46(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STAGE2_MUX11_MUX46)
#define BP_PXP_WFE_A_STAGE2_MUX11_RSVD2      14
#define BM_PXP_WFE_A_STAGE2_MUX11_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STAGE2_MUX11_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STAGE2_MUX11_RSVD2)
#define BP_PXP_WFE_A_STAGE2_MUX11_MUX45      8
#define BM_PXP_WFE_A_STAGE2_MUX11_MUX45 0x00003F00
#define BF_PXP_WFE_A_STAGE2_MUX11_MUX45(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STAGE2_MUX11_MUX45)
#define BP_PXP_WFE_A_STAGE2_MUX11_RSVD3      6
#define BM_PXP_WFE_A_STAGE2_MUX11_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STAGE2_MUX11_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STAGE2_MUX11_RSVD3)
#define BP_PXP_WFE_A_STAGE2_MUX11_MUX44      0
#define BM_PXP_WFE_A_STAGE2_MUX11_MUX44 0x0000003F
#define BF_PXP_WFE_A_STAGE2_MUX11_MUX44(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STAGE2_MUX11_MUX44)

#define HW_PXP_WFE_A_STAGE2_MUX12	(0x00001820)
#define HW_PXP_WFE_A_STAGE2_MUX12_SET	(0x00001824)
#define HW_PXP_WFE_A_STAGE2_MUX12_CLR	(0x00001828)
#define HW_PXP_WFE_A_STAGE2_MUX12_TOG	(0x0000182c)

#define BP_PXP_WFE_A_STAGE2_MUX12_RSVD0      14
#define BM_PXP_WFE_A_STAGE2_MUX12_RSVD0 0xFFFFC000
#define BF_PXP_WFE_A_STAGE2_MUX12_RSVD0(v) \
        (((v) << 14) & BM_PXP_WFE_A_STAGE2_MUX12_RSVD0)
#define BP_PXP_WFE_A_STAGE2_MUX12_MUX49      8
#define BM_PXP_WFE_A_STAGE2_MUX12_MUX49 0x00003F00
#define BF_PXP_WFE_A_STAGE2_MUX12_MUX49(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STAGE2_MUX12_MUX49)
#define BP_PXP_WFE_A_STAGE2_MUX12_RSVD3      6
#define BM_PXP_WFE_A_STAGE2_MUX12_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STAGE2_MUX12_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STAGE2_MUX12_RSVD3)
#define BP_PXP_WFE_A_STAGE2_MUX12_MUX48      0
#define BM_PXP_WFE_A_STAGE2_MUX12_MUX48 0x0000003F
#define BF_PXP_WFE_A_STAGE2_MUX12_MUX48(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STAGE2_MUX12_MUX48)

#define HW_PXP_WFE_A_STAGE3_MUX0	(0x00001830)
#define HW_PXP_WFE_A_STAGE3_MUX0_SET	(0x00001834)
#define HW_PXP_WFE_A_STAGE3_MUX0_CLR	(0x00001838)
#define HW_PXP_WFE_A_STAGE3_MUX0_TOG	(0x0000183c)

#define BP_PXP_WFE_A_STAGE3_MUX0_RSVD0      30
#define BM_PXP_WFE_A_STAGE3_MUX0_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STAGE3_MUX0_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STAGE3_MUX0_RSVD0)
#define BP_PXP_WFE_A_STAGE3_MUX0_MUX3      24
#define BM_PXP_WFE_A_STAGE3_MUX0_MUX3 0x3F000000
#define BF_PXP_WFE_A_STAGE3_MUX0_MUX3(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STAGE3_MUX0_MUX3)
#define BP_PXP_WFE_A_STAGE3_MUX0_RSVD1      22
#define BM_PXP_WFE_A_STAGE3_MUX0_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STAGE3_MUX0_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STAGE3_MUX0_RSVD1)
#define BP_PXP_WFE_A_STAGE3_MUX0_MUX2      16
#define BM_PXP_WFE_A_STAGE3_MUX0_MUX2 0x003F0000
#define BF_PXP_WFE_A_STAGE3_MUX0_MUX2(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STAGE3_MUX0_MUX2)
#define BP_PXP_WFE_A_STAGE3_MUX0_RSVD2      14
#define BM_PXP_WFE_A_STAGE3_MUX0_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STAGE3_MUX0_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STAGE3_MUX0_RSVD2)
#define BP_PXP_WFE_A_STAGE3_MUX0_MUX1      8
#define BM_PXP_WFE_A_STAGE3_MUX0_MUX1 0x00003F00
#define BF_PXP_WFE_A_STAGE3_MUX0_MUX1(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STAGE3_MUX0_MUX1)
#define BP_PXP_WFE_A_STAGE3_MUX0_RSVD3      6
#define BM_PXP_WFE_A_STAGE3_MUX0_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STAGE3_MUX0_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STAGE3_MUX0_RSVD3)
#define BP_PXP_WFE_A_STAGE3_MUX0_MUX0      0
#define BM_PXP_WFE_A_STAGE3_MUX0_MUX0 0x0000003F
#define BF_PXP_WFE_A_STAGE3_MUX0_MUX0(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STAGE3_MUX0_MUX0)

#define HW_PXP_WFE_A_STAGE3_MUX1	(0x00001840)
#define HW_PXP_WFE_A_STAGE3_MUX1_SET	(0x00001844)
#define HW_PXP_WFE_A_STAGE3_MUX1_CLR	(0x00001848)
#define HW_PXP_WFE_A_STAGE3_MUX1_TOG	(0x0000184c)

#define BP_PXP_WFE_A_STAGE3_MUX1_RSVD0      30
#define BM_PXP_WFE_A_STAGE3_MUX1_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STAGE3_MUX1_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STAGE3_MUX1_RSVD0)
#define BP_PXP_WFE_A_STAGE3_MUX1_MUX7      24
#define BM_PXP_WFE_A_STAGE3_MUX1_MUX7 0x3F000000
#define BF_PXP_WFE_A_STAGE3_MUX1_MUX7(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STAGE3_MUX1_MUX7)
#define BP_PXP_WFE_A_STAGE3_MUX1_RSVD1      22
#define BM_PXP_WFE_A_STAGE3_MUX1_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STAGE3_MUX1_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STAGE3_MUX1_RSVD1)
#define BP_PXP_WFE_A_STAGE3_MUX1_MUX6      16
#define BM_PXP_WFE_A_STAGE3_MUX1_MUX6 0x003F0000
#define BF_PXP_WFE_A_STAGE3_MUX1_MUX6(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STAGE3_MUX1_MUX6)
#define BP_PXP_WFE_A_STAGE3_MUX1_RSVD2      14
#define BM_PXP_WFE_A_STAGE3_MUX1_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STAGE3_MUX1_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STAGE3_MUX1_RSVD2)
#define BP_PXP_WFE_A_STAGE3_MUX1_MUX5      8
#define BM_PXP_WFE_A_STAGE3_MUX1_MUX5 0x00003F00
#define BF_PXP_WFE_A_STAGE3_MUX1_MUX5(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STAGE3_MUX1_MUX5)
#define BP_PXP_WFE_A_STAGE3_MUX1_RSVD3      6
#define BM_PXP_WFE_A_STAGE3_MUX1_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STAGE3_MUX1_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STAGE3_MUX1_RSVD3)
#define BP_PXP_WFE_A_STAGE3_MUX1_MUX4      0
#define BM_PXP_WFE_A_STAGE3_MUX1_MUX4 0x0000003F
#define BF_PXP_WFE_A_STAGE3_MUX1_MUX4(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STAGE3_MUX1_MUX4)

#define HW_PXP_WFE_A_STAGE3_MUX2	(0x00001850)
#define HW_PXP_WFE_A_STAGE3_MUX2_SET	(0x00001854)
#define HW_PXP_WFE_A_STAGE3_MUX2_CLR	(0x00001858)
#define HW_PXP_WFE_A_STAGE3_MUX2_TOG	(0x0000185c)

#define BP_PXP_WFE_A_STAGE3_MUX2_RSVD0      30
#define BM_PXP_WFE_A_STAGE3_MUX2_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STAGE3_MUX2_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STAGE3_MUX2_RSVD0)
#define BP_PXP_WFE_A_STAGE3_MUX2_MUX11      24
#define BM_PXP_WFE_A_STAGE3_MUX2_MUX11 0x3F000000
#define BF_PXP_WFE_A_STAGE3_MUX2_MUX11(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STAGE3_MUX2_MUX11)
#define BP_PXP_WFE_A_STAGE3_MUX2_RSVD1      22
#define BM_PXP_WFE_A_STAGE3_MUX2_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STAGE3_MUX2_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STAGE3_MUX2_RSVD1)
#define BP_PXP_WFE_A_STAGE3_MUX2_MUX10      16
#define BM_PXP_WFE_A_STAGE3_MUX2_MUX10 0x003F0000
#define BF_PXP_WFE_A_STAGE3_MUX2_MUX10(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STAGE3_MUX2_MUX10)
#define BP_PXP_WFE_A_STAGE3_MUX2_RSVD2      14
#define BM_PXP_WFE_A_STAGE3_MUX2_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STAGE3_MUX2_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STAGE3_MUX2_RSVD2)
#define BP_PXP_WFE_A_STAGE3_MUX2_MUX9      8
#define BM_PXP_WFE_A_STAGE3_MUX2_MUX9 0x00003F00
#define BF_PXP_WFE_A_STAGE3_MUX2_MUX9(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STAGE3_MUX2_MUX9)
#define BP_PXP_WFE_A_STAGE3_MUX2_RSVD3      6
#define BM_PXP_WFE_A_STAGE3_MUX2_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STAGE3_MUX2_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STAGE3_MUX2_RSVD3)
#define BP_PXP_WFE_A_STAGE3_MUX2_MUX8      0
#define BM_PXP_WFE_A_STAGE3_MUX2_MUX8 0x0000003F
#define BF_PXP_WFE_A_STAGE3_MUX2_MUX8(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STAGE3_MUX2_MUX8)

#define HW_PXP_WFE_A_STAGE3_MUX3	(0x00001860)
#define HW_PXP_WFE_A_STAGE3_MUX3_SET	(0x00001864)
#define HW_PXP_WFE_A_STAGE3_MUX3_CLR	(0x00001868)
#define HW_PXP_WFE_A_STAGE3_MUX3_TOG	(0x0000186c)

#define BP_PXP_WFE_A_STAGE3_MUX3_RSVD0      30
#define BM_PXP_WFE_A_STAGE3_MUX3_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STAGE3_MUX3_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STAGE3_MUX3_RSVD0)
#define BP_PXP_WFE_A_STAGE3_MUX3_MUX15      24
#define BM_PXP_WFE_A_STAGE3_MUX3_MUX15 0x3F000000
#define BF_PXP_WFE_A_STAGE3_MUX3_MUX15(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STAGE3_MUX3_MUX15)
#define BP_PXP_WFE_A_STAGE3_MUX3_RSVD1      22
#define BM_PXP_WFE_A_STAGE3_MUX3_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STAGE3_MUX3_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STAGE3_MUX3_RSVD1)
#define BP_PXP_WFE_A_STAGE3_MUX3_MUX14      16
#define BM_PXP_WFE_A_STAGE3_MUX3_MUX14 0x003F0000
#define BF_PXP_WFE_A_STAGE3_MUX3_MUX14(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STAGE3_MUX3_MUX14)
#define BP_PXP_WFE_A_STAGE3_MUX3_RSVD2      14
#define BM_PXP_WFE_A_STAGE3_MUX3_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STAGE3_MUX3_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STAGE3_MUX3_RSVD2)
#define BP_PXP_WFE_A_STAGE3_MUX3_MUX13      8
#define BM_PXP_WFE_A_STAGE3_MUX3_MUX13 0x00003F00
#define BF_PXP_WFE_A_STAGE3_MUX3_MUX13(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STAGE3_MUX3_MUX13)
#define BP_PXP_WFE_A_STAGE3_MUX3_RSVD3      6
#define BM_PXP_WFE_A_STAGE3_MUX3_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STAGE3_MUX3_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STAGE3_MUX3_RSVD3)
#define BP_PXP_WFE_A_STAGE3_MUX3_MUX12      0
#define BM_PXP_WFE_A_STAGE3_MUX3_MUX12 0x0000003F
#define BF_PXP_WFE_A_STAGE3_MUX3_MUX12(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STAGE3_MUX3_MUX12)

#define HW_PXP_WFE_A_STG1_8X1_OUT0_0	(0x00001870)

#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT31 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT31(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT31)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT30 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT30(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT30)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT29 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT29(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT29)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT28 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT28(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT28)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT27 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT27(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT27)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT26 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT26(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT26)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT25 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT25(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT25)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT24 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT24(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT24)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT23 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT23(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT23)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT22 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT22(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT22)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT21 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT21(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT21)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT20 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT20(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT20)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT19 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT19(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT19)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT18 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT18(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT18)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT17 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT17(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT17)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT16 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT16(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT16)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT15 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT15(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT15)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT14 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT14(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT14)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT13 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT13(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT13)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT12 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT12(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT12)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT11 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT11(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT11)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT10 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT10(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT10)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT9 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT9(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT9)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT8 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT8(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT8)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT7 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT7(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT7)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT6 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT6(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT6)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT5 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT5(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT5)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT4 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT4(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT4)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT3 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT3(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT3)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT2 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT2(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT2)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT1 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT1(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT1)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT0 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT0(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT0_0_LUTOUT0)

#define HW_PXP_WFE_A_STG1_8X1_OUT0_1	(0x00001880)

#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT63 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT63(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT63)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT62 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT62(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT62)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT61 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT61(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT61)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT60 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT60(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT60)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT59 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT59(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT59)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT58 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT58(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT58)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT57 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT57(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT57)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT56 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT56(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT56)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT55 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT55(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT55)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT54 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT54(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT54)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT53 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT53(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT53)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT52 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT52(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT52)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT51 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT51(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT51)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT50 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT50(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT50)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT49 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT49(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT49)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT48 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT48(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT48)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT47 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT47(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT47)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT46 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT46(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT46)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT45 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT45(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT45)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT44 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT44(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT44)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT43 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT43(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT43)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT42 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT42(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT42)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT41 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT41(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT41)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT40 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT40(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT40)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT39 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT39(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT39)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT38 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT38(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT38)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT37 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT37(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT37)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT36 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT36(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT36)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT35 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT35(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT35)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT34 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT34(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT34)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT33 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT33(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT33)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT32 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT32(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT0_1_LUTOUT32)

#define HW_PXP_WFE_A_STG1_8X1_OUT0_2	(0x00001890)

#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT95 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT95(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT95)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT94 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT94(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT94)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT93 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT93(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT93)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT92 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT92(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT92)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT91 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT91(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT91)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT90 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT90(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT90)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT89 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT89(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT89)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT88 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT88(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT88)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT87 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT87(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT87)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT86 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT86(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT86)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT85 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT85(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT85)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT84 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT84(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT84)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT83 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT83(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT83)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT82 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT82(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT82)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT81 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT81(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT81)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT80 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT80(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT80)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT79 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT79(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT79)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT78 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT78(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT78)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT77 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT77(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT77)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT76 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT76(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT76)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT75 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT75(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT75)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT74 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT74(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT74)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT73 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT73(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT73)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT72 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT72(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT72)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT71 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT71(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT71)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT70 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT70(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT70)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT69 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT69(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT69)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT68 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT68(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT68)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT67 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT67(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT67)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT66 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT66(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT66)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT65 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT65(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT65)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT64 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT64(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT0_2_LUTOUT64)

#define HW_PXP_WFE_A_STG1_8X1_OUT0_3	(0x000018a0)

#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT127 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT127(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT127)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT126 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT126(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT126)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT125 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT125(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT125)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT124 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT124(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT124)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT123 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT123(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT123)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT122 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT122(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT122)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT121 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT121(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT121)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT120 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT120(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT120)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT119 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT119(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT119)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT118 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT118(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT118)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT117 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT117(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT117)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT116 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT116(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT116)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT115 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT115(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT115)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT114 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT114(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT114)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT113 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT113(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT113)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT112 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT112(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT112)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT111 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT111(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT111)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT110 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT110(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT110)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT109 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT109(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT109)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT108 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT108(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT108)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT107 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT107(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT107)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT106 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT106(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT106)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT105 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT105(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT105)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT104 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT104(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT104)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT103 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT103(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT103)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT102 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT102(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT102)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT101 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT101(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT101)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT100 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT100(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT100)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT99 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT99(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT99)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT98 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT98(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT98)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT97 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT97(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT97)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT96 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT96(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT0_3_LUTOUT96)

#define HW_PXP_WFE_A_STG1_8X1_OUT0_4	(0x000018b0)

#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT159 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT159(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT159)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT158 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT158(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT158)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT157 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT157(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT157)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT156 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT156(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT156)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT155 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT155(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT155)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT154 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT154(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT154)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT153 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT153(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT153)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT152 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT152(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT152)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT151 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT151(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT151)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT150 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT150(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT150)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT149 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT149(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT149)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT148 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT148(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT148)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT147 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT147(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT147)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT146 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT146(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT146)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT145 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT145(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT145)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT144 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT144(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT144)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT143 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT143(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT143)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT142 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT142(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT142)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT141 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT141(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT141)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT140 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT140(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT140)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT139 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT139(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT139)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT138 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT138(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT138)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT137 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT137(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT137)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT136 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT136(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT136)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT135 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT135(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT135)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT134 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT134(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT134)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT133 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT133(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT133)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT132 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT132(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT132)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT131 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT131(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT131)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT130 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT130(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT130)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT129 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT129(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT129)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT128 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT128(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT0_4_LUTOUT128)

#define HW_PXP_WFE_A_STG1_8X1_OUT0_5	(0x000018c0)

#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT191 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT191(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT191)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT190 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT190(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT190)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT189 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT189(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT189)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT188 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT188(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT188)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT187 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT187(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT187)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT186 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT186(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT186)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT185 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT185(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT185)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT184 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT184(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT184)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT183 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT183(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT183)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT182 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT182(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT182)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT181 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT181(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT181)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT180 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT180(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT180)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT179 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT179(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT179)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT178 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT178(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT178)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT177 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT177(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT177)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT176 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT176(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT176)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT175 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT175(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT175)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT174 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT174(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT174)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT173 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT173(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT173)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT172 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT172(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT172)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT171 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT171(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT171)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT170 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT170(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT170)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT169 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT169(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT169)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT168 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT168(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT168)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT167 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT167(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT167)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT166 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT166(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT166)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT165 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT165(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT165)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT164 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT164(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT164)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT163 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT163(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT163)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT162 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT162(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT162)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT161 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT161(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT161)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT160 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT160(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT0_5_LUTOUT160)

#define HW_PXP_WFE_A_STG1_8X1_OUT0_6	(0x000018d0)

#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT223 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT223(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT223)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT222 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT222(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT222)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT221 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT221(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT221)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT220 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT220(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT220)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT219 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT219(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT219)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT218 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT218(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT218)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT217 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT217(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT217)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT216 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT216(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT216)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT215 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT215(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT215)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT214 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT214(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT214)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT213 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT213(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT213)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT212 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT212(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT212)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT211 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT211(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT211)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT210 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT210(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT210)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT209 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT209(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT209)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT208 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT208(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT208)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT207 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT207(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT207)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT206 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT206(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT206)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT205 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT205(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT205)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT204 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT204(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT204)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT203 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT203(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT203)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT202 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT202(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT202)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT201 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT201(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT201)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT200 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT200(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT200)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT199 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT199(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT199)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT198 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT198(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT198)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT197 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT197(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT197)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT196 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT196(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT196)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT195 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT195(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT195)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT194 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT194(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT194)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT193 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT193(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT193)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT192 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT192(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT0_6_LUTOUT192)

#define HW_PXP_WFE_A_STG1_8X1_OUT0_7	(0x000018e0)

#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT255 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT255(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT255)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT254 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT254(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT254)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT253 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT253(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT253)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT252 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT252(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT252)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT251 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT251(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT251)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT250 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT250(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT250)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT249 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT249(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT249)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT248 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT248(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT248)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT247 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT247(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT247)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT246 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT246(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT246)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT245 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT245(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT245)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT244 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT244(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT244)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT243 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT243(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT243)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT242 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT242(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT242)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT241 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT241(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT241)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT240 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT240(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT240)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT239 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT239(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT239)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT238 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT238(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT238)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT237 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT237(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT237)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT236 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT236(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT236)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT235 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT235(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT235)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT234 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT234(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT234)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT233 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT233(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT233)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT232 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT232(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT232)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT231 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT231(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT231)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT230 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT230(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT230)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT229 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT229(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT229)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT228 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT228(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT228)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT227 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT227(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT227)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT226 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT226(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT226)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT225 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT225(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT225)
#define BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT224 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT224(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT0_7_LUTOUT224)

#define HW_PXP_WFE_A_STG1_8X1_OUT1_0	(0x000018f0)

#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT31 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT31(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT31)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT30 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT30(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT30)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT29 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT29(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT29)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT28 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT28(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT28)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT27 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT27(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT27)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT26 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT26(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT26)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT25 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT25(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT25)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT24 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT24(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT24)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT23 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT23(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT23)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT22 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT22(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT22)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT21 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT21(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT21)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT20 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT20(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT20)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT19 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT19(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT19)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT18 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT18(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT18)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT17 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT17(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT17)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT16 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT16(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT16)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT15 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT15(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT15)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT14 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT14(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT14)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT13 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT13(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT13)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT12 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT12(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT12)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT11 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT11(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT11)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT10 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT10(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT10)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT9 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT9(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT9)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT8 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT8(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT8)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT7 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT7(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT7)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT6 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT6(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT6)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT5 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT5(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT5)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT4 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT4(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT4)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT3 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT3(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT3)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT2 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT2(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT2)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT1 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT1(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT1)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT0 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT0(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT1_0_LUTOUT0)

#define HW_PXP_WFE_A_STG1_8X1_OUT1_1	(0x00001900)

#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT63 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT63(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT63)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT62 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT62(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT62)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT61 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT61(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT61)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT60 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT60(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT60)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT59 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT59(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT59)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT58 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT58(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT58)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT57 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT57(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT57)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT56 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT56(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT56)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT55 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT55(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT55)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT54 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT54(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT54)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT53 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT53(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT53)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT52 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT52(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT52)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT51 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT51(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT51)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT50 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT50(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT50)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT49 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT49(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT49)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT48 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT48(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT48)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT47 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT47(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT47)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT46 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT46(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT46)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT45 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT45(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT45)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT44 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT44(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT44)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT43 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT43(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT43)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT42 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT42(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT42)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT41 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT41(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT41)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT40 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT40(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT40)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT39 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT39(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT39)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT38 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT38(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT38)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT37 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT37(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT37)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT36 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT36(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT36)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT35 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT35(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT35)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT34 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT34(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT34)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT33 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT33(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT33)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT32 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT32(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT1_1_LUTOUT32)

#define HW_PXP_WFE_A_STG1_8X1_OUT1_2	(0x00001910)

#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT95 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT95(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT95)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT94 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT94(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT94)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT93 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT93(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT93)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT92 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT92(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT92)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT91 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT91(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT91)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT90 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT90(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT90)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT89 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT89(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT89)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT88 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT88(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT88)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT87 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT87(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT87)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT86 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT86(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT86)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT85 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT85(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT85)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT84 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT84(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT84)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT83 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT83(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT83)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT82 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT82(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT82)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT81 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT81(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT81)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT80 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT80(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT80)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT79 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT79(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT79)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT78 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT78(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT78)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT77 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT77(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT77)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT76 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT76(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT76)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT75 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT75(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT75)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT74 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT74(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT74)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT73 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT73(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT73)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT72 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT72(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT72)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT71 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT71(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT71)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT70 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT70(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT70)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT69 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT69(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT69)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT68 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT68(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT68)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT67 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT67(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT67)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT66 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT66(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT66)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT65 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT65(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT65)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT64 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT64(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT1_2_LUTOUT64)

#define HW_PXP_WFE_A_STG1_8X1_OUT1_3	(0x00001920)

#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT127 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT127(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT127)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT126 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT126(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT126)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT125 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT125(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT125)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT124 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT124(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT124)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT123 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT123(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT123)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT122 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT122(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT122)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT121 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT121(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT121)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT120 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT120(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT120)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT119 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT119(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT119)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT118 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT118(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT118)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT117 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT117(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT117)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT116 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT116(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT116)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT115 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT115(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT115)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT114 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT114(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT114)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT113 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT113(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT113)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT112 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT112(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT112)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT111 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT111(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT111)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT110 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT110(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT110)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT109 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT109(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT109)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT108 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT108(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT108)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT107 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT107(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT107)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT106 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT106(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT106)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT105 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT105(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT105)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT104 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT104(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT104)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT103 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT103(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT103)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT102 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT102(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT102)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT101 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT101(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT101)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT100 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT100(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT100)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT99 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT99(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT99)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT98 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT98(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT98)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT97 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT97(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT97)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT96 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT96(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT1_3_LUTOUT96)

#define HW_PXP_WFE_A_STG1_8X1_OUT1_4	(0x00001930)

#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT159 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT159(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT159)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT158 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT158(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT158)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT157 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT157(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT157)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT156 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT156(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT156)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT155 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT155(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT155)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT154 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT154(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT154)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT153 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT153(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT153)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT152 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT152(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT152)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT151 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT151(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT151)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT150 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT150(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT150)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT149 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT149(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT149)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT148 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT148(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT148)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT147 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT147(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT147)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT146 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT146(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT146)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT145 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT145(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT145)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT144 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT144(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT144)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT143 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT143(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT143)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT142 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT142(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT142)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT141 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT141(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT141)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT140 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT140(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT140)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT139 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT139(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT139)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT138 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT138(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT138)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT137 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT137(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT137)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT136 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT136(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT136)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT135 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT135(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT135)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT134 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT134(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT134)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT133 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT133(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT133)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT132 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT132(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT132)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT131 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT131(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT131)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT130 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT130(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT130)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT129 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT129(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT129)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT128 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT128(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT1_4_LUTOUT128)

#define HW_PXP_WFE_A_STG1_8X1_OUT1_5	(0x00001940)

#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT191 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT191(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT191)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT190 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT190(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT190)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT189 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT189(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT189)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT188 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT188(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT188)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT187 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT187(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT187)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT186 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT186(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT186)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT185 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT185(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT185)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT184 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT184(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT184)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT183 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT183(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT183)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT182 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT182(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT182)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT181 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT181(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT181)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT180 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT180(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT180)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT179 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT179(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT179)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT178 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT178(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT178)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT177 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT177(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT177)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT176 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT176(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT176)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT175 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT175(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT175)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT174 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT174(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT174)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT173 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT173(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT173)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT172 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT172(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT172)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT171 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT171(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT171)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT170 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT170(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT170)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT169 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT169(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT169)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT168 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT168(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT168)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT167 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT167(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT167)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT166 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT166(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT166)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT165 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT165(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT165)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT164 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT164(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT164)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT163 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT163(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT163)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT162 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT162(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT162)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT161 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT161(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT161)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT160 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT160(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT1_5_LUTOUT160)

#define HW_PXP_WFE_A_STG1_8X1_OUT1_6	(0x00001950)

#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT223 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT223(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT223)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT222 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT222(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT222)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT221 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT221(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT221)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT220 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT220(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT220)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT219 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT219(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT219)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT218 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT218(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT218)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT217 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT217(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT217)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT216 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT216(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT216)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT215 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT215(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT215)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT214 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT214(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT214)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT213 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT213(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT213)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT212 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT212(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT212)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT211 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT211(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT211)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT210 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT210(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT210)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT209 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT209(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT209)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT208 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT208(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT208)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT207 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT207(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT207)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT206 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT206(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT206)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT205 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT205(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT205)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT204 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT204(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT204)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT203 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT203(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT203)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT202 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT202(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT202)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT201 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT201(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT201)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT200 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT200(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT200)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT199 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT199(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT199)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT198 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT198(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT198)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT197 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT197(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT197)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT196 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT196(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT196)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT195 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT195(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT195)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT194 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT194(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT194)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT193 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT193(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT193)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT192 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT192(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT1_6_LUTOUT192)

#define HW_PXP_WFE_A_STG1_8X1_OUT1_7	(0x00001960)

#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT255 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT255(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT255)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT254 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT254(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT254)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT253 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT253(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT253)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT252 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT252(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT252)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT251 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT251(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT251)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT250 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT250(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT250)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT249 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT249(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT249)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT248 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT248(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT248)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT247 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT247(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT247)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT246 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT246(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT246)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT245 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT245(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT245)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT244 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT244(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT244)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT243 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT243(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT243)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT242 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT242(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT242)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT241 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT241(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT241)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT240 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT240(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT240)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT239 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT239(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT239)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT238 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT238(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT238)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT237 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT237(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT237)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT236 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT236(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT236)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT235 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT235(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT235)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT234 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT234(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT234)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT233 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT233(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT233)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT232 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT232(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT232)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT231 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT231(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT231)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT230 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT230(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT230)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT229 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT229(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT229)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT228 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT228(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT228)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT227 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT227(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT227)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT226 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT226(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT226)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT225 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT225(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT225)
#define BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT224 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT224(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT1_7_LUTOUT224)

#define HW_PXP_WFE_A_STG1_8X1_OUT2_0	(0x00001970)

#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT31 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT31(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT31)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT30 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT30(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT30)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT29 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT29(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT29)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT28 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT28(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT28)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT27 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT27(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT27)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT26 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT26(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT26)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT25 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT25(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT25)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT24 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT24(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT24)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT23 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT23(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT23)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT22 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT22(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT22)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT21 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT21(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT21)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT20 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT20(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT20)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT19 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT19(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT19)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT18 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT18(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT18)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT17 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT17(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT17)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT16 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT16(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT16)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT15 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT15(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT15)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT14 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT14(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT14)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT13 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT13(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT13)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT12 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT12(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT12)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT11 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT11(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT11)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT10 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT10(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT10)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT9 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT9(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT9)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT8 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT8(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT8)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT7 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT7(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT7)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT6 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT6(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT6)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT5 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT5(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT5)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT4 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT4(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT4)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT3 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT3(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT3)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT2 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT2(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT2)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT1 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT1(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT1)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT0 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT0(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT2_0_LUTOUT0)

#define HW_PXP_WFE_A_STG1_8X1_OUT2_1	(0x00001980)

#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT63 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT63(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT63)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT62 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT62(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT62)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT61 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT61(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT61)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT60 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT60(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT60)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT59 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT59(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT59)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT58 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT58(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT58)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT57 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT57(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT57)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT56 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT56(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT56)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT55 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT55(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT55)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT54 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT54(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT54)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT53 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT53(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT53)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT52 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT52(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT52)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT51 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT51(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT51)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT50 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT50(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT50)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT49 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT49(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT49)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT48 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT48(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT48)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT47 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT47(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT47)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT46 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT46(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT46)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT45 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT45(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT45)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT44 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT44(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT44)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT43 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT43(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT43)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT42 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT42(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT42)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT41 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT41(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT41)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT40 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT40(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT40)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT39 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT39(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT39)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT38 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT38(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT38)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT37 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT37(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT37)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT36 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT36(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT36)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT35 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT35(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT35)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT34 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT34(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT34)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT33 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT33(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT33)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT32 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT32(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT2_1_LUTOUT32)

#define HW_PXP_WFE_A_STG1_8X1_OUT2_2	(0x00001990)

#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT95 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT95(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT95)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT94 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT94(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT94)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT93 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT93(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT93)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT92 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT92(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT92)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT91 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT91(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT91)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT90 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT90(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT90)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT89 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT89(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT89)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT88 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT88(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT88)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT87 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT87(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT87)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT86 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT86(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT86)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT85 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT85(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT85)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT84 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT84(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT84)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT83 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT83(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT83)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT82 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT82(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT82)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT81 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT81(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT81)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT80 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT80(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT80)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT79 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT79(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT79)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT78 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT78(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT78)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT77 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT77(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT77)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT76 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT76(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT76)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT75 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT75(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT75)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT74 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT74(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT74)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT73 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT73(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT73)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT72 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT72(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT72)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT71 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT71(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT71)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT70 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT70(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT70)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT69 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT69(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT69)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT68 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT68(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT68)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT67 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT67(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT67)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT66 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT66(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT66)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT65 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT65(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT65)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT64 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT64(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT2_2_LUTOUT64)

#define HW_PXP_WFE_A_STG1_8X1_OUT2_3	(0x000019a0)

#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT127 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT127(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT127)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT126 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT126(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT126)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT125 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT125(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT125)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT124 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT124(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT124)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT123 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT123(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT123)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT122 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT122(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT122)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT121 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT121(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT121)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT120 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT120(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT120)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT119 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT119(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT119)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT118 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT118(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT118)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT117 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT117(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT117)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT116 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT116(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT116)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT115 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT115(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT115)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT114 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT114(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT114)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT113 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT113(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT113)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT112 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT112(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT112)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT111 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT111(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT111)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT110 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT110(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT110)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT109 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT109(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT109)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT108 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT108(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT108)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT107 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT107(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT107)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT106 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT106(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT106)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT105 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT105(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT105)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT104 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT104(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT104)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT103 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT103(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT103)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT102 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT102(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT102)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT101 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT101(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT101)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT100 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT100(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT100)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT99 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT99(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT99)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT98 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT98(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT98)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT97 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT97(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT97)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT96 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT96(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT2_3_LUTOUT96)

#define HW_PXP_WFE_A_STG1_8X1_OUT2_4	(0x000019b0)

#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT159 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT159(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT159)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT158 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT158(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT158)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT157 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT157(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT157)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT156 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT156(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT156)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT155 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT155(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT155)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT154 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT154(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT154)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT153 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT153(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT153)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT152 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT152(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT152)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT151 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT151(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT151)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT150 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT150(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT150)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT149 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT149(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT149)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT148 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT148(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT148)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT147 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT147(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT147)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT146 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT146(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT146)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT145 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT145(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT145)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT144 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT144(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT144)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT143 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT143(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT143)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT142 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT142(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT142)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT141 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT141(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT141)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT140 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT140(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT140)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT139 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT139(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT139)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT138 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT138(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT138)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT137 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT137(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT137)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT136 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT136(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT136)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT135 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT135(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT135)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT134 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT134(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT134)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT133 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT133(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT133)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT132 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT132(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT132)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT131 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT131(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT131)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT130 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT130(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT130)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT129 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT129(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT129)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT128 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT128(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT2_4_LUTOUT128)

#define HW_PXP_WFE_A_STG1_8X1_OUT2_5	(0x000019c0)

#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT191 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT191(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT191)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT190 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT190(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT190)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT189 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT189(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT189)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT188 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT188(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT188)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT187 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT187(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT187)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT186 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT186(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT186)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT185 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT185(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT185)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT184 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT184(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT184)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT183 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT183(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT183)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT182 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT182(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT182)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT181 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT181(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT181)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT180 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT180(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT180)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT179 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT179(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT179)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT178 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT178(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT178)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT177 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT177(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT177)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT176 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT176(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT176)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT175 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT175(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT175)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT174 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT174(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT174)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT173 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT173(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT173)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT172 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT172(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT172)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT171 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT171(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT171)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT170 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT170(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT170)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT169 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT169(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT169)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT168 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT168(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT168)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT167 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT167(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT167)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT166 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT166(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT166)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT165 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT165(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT165)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT164 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT164(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT164)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT163 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT163(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT163)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT162 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT162(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT162)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT161 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT161(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT161)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT160 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT160(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT2_5_LUTOUT160)

#define HW_PXP_WFE_A_STG1_8X1_OUT2_6	(0x000019d0)

#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT223 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT223(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT223)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT222 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT222(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT222)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT221 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT221(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT221)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT220 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT220(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT220)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT219 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT219(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT219)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT218 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT218(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT218)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT217 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT217(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT217)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT216 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT216(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT216)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT215 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT215(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT215)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT214 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT214(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT214)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT213 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT213(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT213)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT212 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT212(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT212)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT211 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT211(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT211)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT210 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT210(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT210)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT209 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT209(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT209)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT208 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT208(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT208)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT207 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT207(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT207)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT206 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT206(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT206)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT205 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT205(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT205)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT204 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT204(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT204)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT203 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT203(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT203)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT202 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT202(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT202)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT201 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT201(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT201)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT200 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT200(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT200)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT199 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT199(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT199)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT198 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT198(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT198)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT197 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT197(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT197)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT196 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT196(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT196)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT195 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT195(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT195)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT194 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT194(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT194)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT193 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT193(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT193)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT192 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT192(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT2_6_LUTOUT192)

#define HW_PXP_WFE_A_STG1_8X1_OUT2_7	(0x000019e0)

#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT255 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT255(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT255)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT254 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT254(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT254)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT253 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT253(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT253)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT252 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT252(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT252)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT251 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT251(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT251)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT250 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT250(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT250)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT249 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT249(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT249)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT248 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT248(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT248)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT247 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT247(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT247)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT246 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT246(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT246)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT245 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT245(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT245)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT244 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT244(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT244)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT243 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT243(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT243)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT242 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT242(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT242)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT241 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT241(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT241)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT240 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT240(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT240)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT239 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT239(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT239)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT238 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT238(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT238)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT237 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT237(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT237)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT236 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT236(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT236)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT235 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT235(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT235)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT234 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT234(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT234)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT233 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT233(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT233)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT232 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT232(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT232)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT231 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT231(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT231)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT230 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT230(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT230)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT229 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT229(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT229)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT228 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT228(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT228)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT227 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT227(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT227)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT226 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT226(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT226)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT225 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT225(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT225)
#define BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT224 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT224(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT2_7_LUTOUT224)

#define HW_PXP_WFE_A_STG1_8X1_OUT3_0	(0x000019f0)

#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT31 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT31(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT31)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT30 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT30(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT30)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT29 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT29(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT29)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT28 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT28(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT28)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT27 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT27(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT27)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT26 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT26(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT26)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT25 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT25(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT25)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT24 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT24(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT24)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT23 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT23(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT23)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT22 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT22(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT22)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT21 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT21(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT21)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT20 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT20(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT20)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT19 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT19(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT19)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT18 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT18(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT18)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT17 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT17(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT17)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT16 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT16(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT16)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT15 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT15(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT15)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT14 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT14(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT14)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT13 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT13(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT13)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT12 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT12(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT12)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT11 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT11(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT11)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT10 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT10(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT10)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT9 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT9(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT9)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT8 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT8(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT8)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT7 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT7(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT7)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT6 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT6(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT6)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT5 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT5(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT5)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT4 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT4(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT4)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT3 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT3(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT3)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT2 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT2(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT2)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT1 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT1(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT1)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT0 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT0(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT3_0_LUTOUT0)

#define HW_PXP_WFE_A_STG1_8X1_OUT3_1	(0x00001a00)

#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT63 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT63(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT63)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT62 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT62(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT62)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT61 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT61(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT61)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT60 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT60(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT60)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT59 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT59(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT59)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT58 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT58(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT58)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT57 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT57(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT57)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT56 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT56(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT56)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT55 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT55(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT55)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT54 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT54(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT54)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT53 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT53(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT53)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT52 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT52(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT52)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT51 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT51(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT51)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT50 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT50(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT50)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT49 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT49(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT49)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT48 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT48(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT48)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT47 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT47(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT47)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT46 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT46(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT46)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT45 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT45(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT45)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT44 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT44(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT44)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT43 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT43(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT43)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT42 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT42(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT42)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT41 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT41(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT41)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT40 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT40(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT40)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT39 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT39(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT39)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT38 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT38(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT38)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT37 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT37(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT37)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT36 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT36(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT36)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT35 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT35(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT35)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT34 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT34(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT34)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT33 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT33(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT33)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT32 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT32(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT3_1_LUTOUT32)

#define HW_PXP_WFE_A_STG1_8X1_OUT3_2	(0x00001a10)

#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT95 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT95(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT95)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT94 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT94(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT94)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT93 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT93(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT93)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT92 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT92(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT92)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT91 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT91(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT91)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT90 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT90(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT90)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT89 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT89(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT89)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT88 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT88(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT88)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT87 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT87(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT87)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT86 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT86(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT86)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT85 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT85(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT85)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT84 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT84(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT84)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT83 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT83(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT83)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT82 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT82(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT82)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT81 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT81(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT81)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT80 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT80(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT80)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT79 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT79(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT79)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT78 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT78(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT78)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT77 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT77(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT77)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT76 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT76(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT76)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT75 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT75(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT75)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT74 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT74(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT74)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT73 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT73(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT73)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT72 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT72(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT72)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT71 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT71(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT71)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT70 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT70(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT70)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT69 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT69(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT69)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT68 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT68(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT68)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT67 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT67(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT67)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT66 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT66(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT66)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT65 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT65(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT65)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT64 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT64(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT3_2_LUTOUT64)

#define HW_PXP_WFE_A_STG1_8X1_OUT3_3	(0x00001a20)

#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT127 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT127(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT127)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT126 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT126(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT126)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT125 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT125(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT125)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT124 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT124(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT124)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT123 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT123(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT123)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT122 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT122(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT122)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT121 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT121(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT121)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT120 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT120(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT120)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT119 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT119(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT119)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT118 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT118(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT118)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT117 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT117(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT117)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT116 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT116(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT116)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT115 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT115(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT115)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT114 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT114(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT114)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT113 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT113(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT113)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT112 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT112(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT112)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT111 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT111(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT111)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT110 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT110(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT110)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT109 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT109(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT109)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT108 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT108(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT108)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT107 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT107(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT107)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT106 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT106(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT106)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT105 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT105(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT105)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT104 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT104(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT104)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT103 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT103(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT103)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT102 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT102(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT102)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT101 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT101(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT101)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT100 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT100(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT100)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT99 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT99(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT99)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT98 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT98(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT98)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT97 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT97(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT97)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT96 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT96(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT3_3_LUTOUT96)

#define HW_PXP_WFE_A_STG1_8X1_OUT3_4	(0x00001a30)

#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT159 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT159(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT159)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT158 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT158(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT158)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT157 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT157(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT157)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT156 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT156(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT156)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT155 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT155(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT155)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT154 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT154(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT154)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT153 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT153(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT153)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT152 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT152(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT152)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT151 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT151(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT151)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT150 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT150(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT150)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT149 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT149(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT149)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT148 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT148(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT148)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT147 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT147(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT147)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT146 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT146(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT146)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT145 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT145(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT145)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT144 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT144(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT144)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT143 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT143(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT143)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT142 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT142(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT142)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT141 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT141(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT141)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT140 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT140(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT140)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT139 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT139(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT139)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT138 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT138(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT138)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT137 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT137(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT137)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT136 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT136(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT136)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT135 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT135(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT135)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT134 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT134(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT134)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT133 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT133(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT133)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT132 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT132(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT132)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT131 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT131(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT131)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT130 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT130(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT130)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT129 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT129(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT129)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT128 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT128(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT3_4_LUTOUT128)

#define HW_PXP_WFE_A_STG1_8X1_OUT3_5	(0x00001a40)

#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT191 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT191(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT191)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT190 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT190(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT190)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT189 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT189(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT189)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT188 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT188(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT188)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT187 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT187(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT187)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT186 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT186(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT186)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT185 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT185(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT185)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT184 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT184(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT184)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT183 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT183(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT183)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT182 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT182(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT182)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT181 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT181(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT181)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT180 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT180(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT180)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT179 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT179(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT179)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT178 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT178(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT178)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT177 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT177(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT177)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT176 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT176(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT176)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT175 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT175(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT175)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT174 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT174(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT174)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT173 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT173(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT173)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT172 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT172(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT172)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT171 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT171(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT171)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT170 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT170(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT170)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT169 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT169(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT169)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT168 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT168(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT168)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT167 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT167(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT167)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT166 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT166(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT166)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT165 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT165(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT165)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT164 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT164(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT164)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT163 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT163(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT163)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT162 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT162(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT162)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT161 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT161(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT161)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT160 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT160(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT3_5_LUTOUT160)

#define HW_PXP_WFE_A_STG1_8X1_OUT3_6	(0x00001a50)

#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT223 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT223(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT223)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT222 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT222(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT222)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT221 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT221(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT221)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT220 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT220(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT220)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT219 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT219(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT219)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT218 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT218(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT218)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT217 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT217(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT217)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT216 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT216(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT216)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT215 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT215(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT215)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT214 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT214(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT214)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT213 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT213(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT213)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT212 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT212(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT212)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT211 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT211(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT211)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT210 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT210(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT210)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT209 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT209(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT209)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT208 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT208(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT208)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT207 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT207(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT207)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT206 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT206(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT206)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT205 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT205(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT205)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT204 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT204(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT204)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT203 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT203(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT203)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT202 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT202(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT202)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT201 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT201(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT201)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT200 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT200(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT200)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT199 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT199(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT199)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT198 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT198(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT198)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT197 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT197(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT197)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT196 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT196(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT196)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT195 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT195(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT195)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT194 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT194(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT194)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT193 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT193(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT193)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT192 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT192(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT3_6_LUTOUT192)

#define HW_PXP_WFE_A_STG1_8X1_OUT3_7	(0x00001a60)

#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT255 0x80000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT255(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT255)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT254 0x40000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT254(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT254)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT253 0x20000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT253(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT253)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT252 0x10000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT252(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT252)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT251 0x08000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT251(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT251)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT250 0x04000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT250(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT250)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT249 0x02000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT249(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT249)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT248 0x01000000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT248(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT248)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT247 0x00800000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT247(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT247)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT246 0x00400000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT246(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT246)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT245 0x00200000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT245(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT245)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT244 0x00100000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT244(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT244)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT243 0x00080000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT243(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT243)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT242 0x00040000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT242(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT242)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT241 0x00020000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT241(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT241)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT240 0x00010000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT240(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT240)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT239 0x00008000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT239(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT239)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT238 0x00004000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT238(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT238)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT237 0x00002000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT237(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT237)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT236 0x00001000
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT236(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT236)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT235 0x00000800
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT235(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT235)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT234 0x00000400
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT234(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT234)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT233 0x00000200
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT233(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT233)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT232 0x00000100
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT232(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT232)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT231 0x00000080
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT231(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT231)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT230 0x00000040
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT230(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT230)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT229 0x00000020
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT229(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT229)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT228 0x00000010
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT228(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT228)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT227 0x00000008
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT227(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT227)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT226 0x00000004
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT226(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT226)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT225 0x00000002
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT225(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT225)
#define BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT224 0x00000001
#define BF_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT224(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG1_8X1_OUT3_7_LUTOUT224)

#define HW_PXP_WFE_A_STG2_5X6_OUT0_0	(0x00001a70)

#define BP_PXP_WFE_A_STG2_5X6_OUT0_0_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT0_0_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_0_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT0_0_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_0_LUTOUT3      24
#define BM_PXP_WFE_A_STG2_5X6_OUT0_0_LUTOUT3 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_0_LUTOUT3(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT0_0_LUTOUT3)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_0_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT0_0_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_0_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT0_0_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_0_LUTOUT2      16
#define BM_PXP_WFE_A_STG2_5X6_OUT0_0_LUTOUT2 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_0_LUTOUT2(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT0_0_LUTOUT2)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_0_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT0_0_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_0_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT0_0_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_0_LUTOUT1      8
#define BM_PXP_WFE_A_STG2_5X6_OUT0_0_LUTOUT1 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT0_0_LUTOUT1(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT0_0_LUTOUT1)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_0_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT0_0_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT0_0_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT0_0_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_0_LUTOUT0      0
#define BM_PXP_WFE_A_STG2_5X6_OUT0_0_LUTOUT0 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT0_0_LUTOUT0(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT0_0_LUTOUT0)

#define HW_PXP_WFE_A_STG2_5X6_OUT0_1	(0x00001a80)

#define BP_PXP_WFE_A_STG2_5X6_OUT0_1_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT0_1_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_1_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT0_1_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_1_LUTOUT7      24
#define BM_PXP_WFE_A_STG2_5X6_OUT0_1_LUTOUT7 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_1_LUTOUT7(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT0_1_LUTOUT7)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_1_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT0_1_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_1_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT0_1_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_1_LUTOUT6      16
#define BM_PXP_WFE_A_STG2_5X6_OUT0_1_LUTOUT6 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_1_LUTOUT6(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT0_1_LUTOUT6)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_1_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT0_1_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_1_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT0_1_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_1_LUTOUT5      8
#define BM_PXP_WFE_A_STG2_5X6_OUT0_1_LUTOUT5 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT0_1_LUTOUT5(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT0_1_LUTOUT5)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_1_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT0_1_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT0_1_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT0_1_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_1_LUTOUT4      0
#define BM_PXP_WFE_A_STG2_5X6_OUT0_1_LUTOUT4 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT0_1_LUTOUT4(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT0_1_LUTOUT4)

#define HW_PXP_WFE_A_STG2_5X6_OUT0_2	(0x00001a90)

#define BP_PXP_WFE_A_STG2_5X6_OUT0_2_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT0_2_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_2_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT0_2_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_2_LUTOUT11      24
#define BM_PXP_WFE_A_STG2_5X6_OUT0_2_LUTOUT11 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_2_LUTOUT11(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT0_2_LUTOUT11)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_2_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT0_2_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_2_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT0_2_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_2_LUTOUT10      16
#define BM_PXP_WFE_A_STG2_5X6_OUT0_2_LUTOUT10 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_2_LUTOUT10(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT0_2_LUTOUT10)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_2_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT0_2_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_2_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT0_2_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_2_LUTOUT9      8
#define BM_PXP_WFE_A_STG2_5X6_OUT0_2_LUTOUT9 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT0_2_LUTOUT9(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT0_2_LUTOUT9)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_2_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT0_2_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT0_2_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT0_2_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_2_LUTOUT8      0
#define BM_PXP_WFE_A_STG2_5X6_OUT0_2_LUTOUT8 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT0_2_LUTOUT8(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT0_2_LUTOUT8)

#define HW_PXP_WFE_A_STG2_5X6_OUT0_3	(0x00001aa0)

#define BP_PXP_WFE_A_STG2_5X6_OUT0_3_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT0_3_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_3_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT0_3_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_3_LUTOUT15      24
#define BM_PXP_WFE_A_STG2_5X6_OUT0_3_LUTOUT15 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_3_LUTOUT15(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT0_3_LUTOUT15)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_3_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT0_3_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_3_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT0_3_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_3_LUTOUT14      16
#define BM_PXP_WFE_A_STG2_5X6_OUT0_3_LUTOUT14 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_3_LUTOUT14(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT0_3_LUTOUT14)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_3_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT0_3_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_3_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT0_3_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_3_LUTOUT13      8
#define BM_PXP_WFE_A_STG2_5X6_OUT0_3_LUTOUT13 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT0_3_LUTOUT13(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT0_3_LUTOUT13)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_3_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT0_3_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT0_3_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT0_3_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_3_LUTOUT12      0
#define BM_PXP_WFE_A_STG2_5X6_OUT0_3_LUTOUT12 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT0_3_LUTOUT12(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT0_3_LUTOUT12)

#define HW_PXP_WFE_A_STG2_5X6_OUT0_4	(0x00001ab0)

#define BP_PXP_WFE_A_STG2_5X6_OUT0_4_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT0_4_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_4_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT0_4_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_4_LUTOUT19      24
#define BM_PXP_WFE_A_STG2_5X6_OUT0_4_LUTOUT19 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_4_LUTOUT19(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT0_4_LUTOUT19)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_4_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT0_4_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_4_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT0_4_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_4_LUTOUT18      16
#define BM_PXP_WFE_A_STG2_5X6_OUT0_4_LUTOUT18 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_4_LUTOUT18(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT0_4_LUTOUT18)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_4_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT0_4_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_4_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT0_4_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_4_LUTOUT17      8
#define BM_PXP_WFE_A_STG2_5X6_OUT0_4_LUTOUT17 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT0_4_LUTOUT17(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT0_4_LUTOUT17)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_4_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT0_4_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT0_4_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT0_4_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_4_LUTOUT16      0
#define BM_PXP_WFE_A_STG2_5X6_OUT0_4_LUTOUT16 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT0_4_LUTOUT16(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT0_4_LUTOUT16)

#define HW_PXP_WFE_A_STG2_5X6_OUT0_5	(0x00001ac0)

#define BP_PXP_WFE_A_STG2_5X6_OUT0_5_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT0_5_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_5_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT0_5_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_5_LUTOUT23      24
#define BM_PXP_WFE_A_STG2_5X6_OUT0_5_LUTOUT23 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_5_LUTOUT23(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT0_5_LUTOUT23)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_5_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT0_5_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_5_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT0_5_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_5_LUTOUT22      16
#define BM_PXP_WFE_A_STG2_5X6_OUT0_5_LUTOUT22 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_5_LUTOUT22(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT0_5_LUTOUT22)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_5_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT0_5_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_5_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT0_5_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_5_LUTOUT21      8
#define BM_PXP_WFE_A_STG2_5X6_OUT0_5_LUTOUT21 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT0_5_LUTOUT21(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT0_5_LUTOUT21)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_5_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT0_5_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT0_5_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT0_5_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_5_LUTOUT20      0
#define BM_PXP_WFE_A_STG2_5X6_OUT0_5_LUTOUT20 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT0_5_LUTOUT20(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT0_5_LUTOUT20)

#define HW_PXP_WFE_A_STG2_5X6_OUT0_6	(0x00001ad0)

#define BP_PXP_WFE_A_STG2_5X6_OUT0_6_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT0_6_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_6_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT0_6_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_6_LUTOUT27      24
#define BM_PXP_WFE_A_STG2_5X6_OUT0_6_LUTOUT27 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_6_LUTOUT27(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT0_6_LUTOUT27)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_6_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT0_6_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_6_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT0_6_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_6_LUTOUT26      16
#define BM_PXP_WFE_A_STG2_5X6_OUT0_6_LUTOUT26 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_6_LUTOUT26(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT0_6_LUTOUT26)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_6_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT0_6_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_6_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT0_6_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_6_LUTOUT25      8
#define BM_PXP_WFE_A_STG2_5X6_OUT0_6_LUTOUT25 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT0_6_LUTOUT25(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT0_6_LUTOUT25)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_6_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT0_6_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT0_6_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT0_6_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_6_LUTOUT24      0
#define BM_PXP_WFE_A_STG2_5X6_OUT0_6_LUTOUT24 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT0_6_LUTOUT24(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT0_6_LUTOUT24)

#define HW_PXP_WFE_A_STG2_5X6_OUT0_7	(0x00001ae0)

#define BP_PXP_WFE_A_STG2_5X6_OUT0_7_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT0_7_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_7_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT0_7_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_7_LUTOUT31      24
#define BM_PXP_WFE_A_STG2_5X6_OUT0_7_LUTOUT31 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_7_LUTOUT31(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT0_7_LUTOUT31)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_7_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT0_7_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_7_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT0_7_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_7_LUTOUT30      16
#define BM_PXP_WFE_A_STG2_5X6_OUT0_7_LUTOUT30 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_7_LUTOUT30(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT0_7_LUTOUT30)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_7_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT0_7_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT0_7_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT0_7_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_7_LUTOUT29      8
#define BM_PXP_WFE_A_STG2_5X6_OUT0_7_LUTOUT29 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT0_7_LUTOUT29(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT0_7_LUTOUT29)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_7_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT0_7_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT0_7_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT0_7_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT0_7_LUTOUT28      0
#define BM_PXP_WFE_A_STG2_5X6_OUT0_7_LUTOUT28 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT0_7_LUTOUT28(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT0_7_LUTOUT28)

#define HW_PXP_WFE_A_STG2_5X6_OUT1_0	(0x00001af0)

#define BP_PXP_WFE_A_STG2_5X6_OUT1_0_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT1_0_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_0_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT1_0_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_0_LUTOUT3      24
#define BM_PXP_WFE_A_STG2_5X6_OUT1_0_LUTOUT3 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_0_LUTOUT3(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT1_0_LUTOUT3)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_0_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT1_0_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_0_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT1_0_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_0_LUTOUT2      16
#define BM_PXP_WFE_A_STG2_5X6_OUT1_0_LUTOUT2 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_0_LUTOUT2(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT1_0_LUTOUT2)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_0_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT1_0_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_0_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT1_0_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_0_LUTOUT1      8
#define BM_PXP_WFE_A_STG2_5X6_OUT1_0_LUTOUT1 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT1_0_LUTOUT1(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT1_0_LUTOUT1)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_0_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT1_0_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT1_0_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT1_0_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_0_LUTOUT0      0
#define BM_PXP_WFE_A_STG2_5X6_OUT1_0_LUTOUT0 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT1_0_LUTOUT0(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT1_0_LUTOUT0)

#define HW_PXP_WFE_A_STG2_5X6_OUT1_1	(0x00001b00)

#define BP_PXP_WFE_A_STG2_5X6_OUT1_1_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT1_1_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_1_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT1_1_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_1_LUTOUT7      24
#define BM_PXP_WFE_A_STG2_5X6_OUT1_1_LUTOUT7 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_1_LUTOUT7(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT1_1_LUTOUT7)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_1_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT1_1_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_1_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT1_1_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_1_LUTOUT6      16
#define BM_PXP_WFE_A_STG2_5X6_OUT1_1_LUTOUT6 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_1_LUTOUT6(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT1_1_LUTOUT6)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_1_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT1_1_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_1_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT1_1_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_1_LUTOUT5      8
#define BM_PXP_WFE_A_STG2_5X6_OUT1_1_LUTOUT5 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT1_1_LUTOUT5(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT1_1_LUTOUT5)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_1_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT1_1_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT1_1_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT1_1_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_1_LUTOUT4      0
#define BM_PXP_WFE_A_STG2_5X6_OUT1_1_LUTOUT4 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT1_1_LUTOUT4(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT1_1_LUTOUT4)

#define HW_PXP_WFE_A_STG2_5X6_OUT1_2	(0x00001b10)

#define BP_PXP_WFE_A_STG2_5X6_OUT1_2_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT1_2_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_2_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT1_2_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_2_LUTOUT11      24
#define BM_PXP_WFE_A_STG2_5X6_OUT1_2_LUTOUT11 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_2_LUTOUT11(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT1_2_LUTOUT11)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_2_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT1_2_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_2_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT1_2_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_2_LUTOUT10      16
#define BM_PXP_WFE_A_STG2_5X6_OUT1_2_LUTOUT10 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_2_LUTOUT10(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT1_2_LUTOUT10)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_2_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT1_2_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_2_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT1_2_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_2_LUTOUT9      8
#define BM_PXP_WFE_A_STG2_5X6_OUT1_2_LUTOUT9 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT1_2_LUTOUT9(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT1_2_LUTOUT9)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_2_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT1_2_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT1_2_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT1_2_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_2_LUTOUT8      0
#define BM_PXP_WFE_A_STG2_5X6_OUT1_2_LUTOUT8 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT1_2_LUTOUT8(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT1_2_LUTOUT8)

#define HW_PXP_WFE_A_STG2_5X6_OUT1_3	(0x00001b20)

#define BP_PXP_WFE_A_STG2_5X6_OUT1_3_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT1_3_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_3_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT1_3_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_3_LUTOUT15      24
#define BM_PXP_WFE_A_STG2_5X6_OUT1_3_LUTOUT15 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_3_LUTOUT15(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT1_3_LUTOUT15)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_3_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT1_3_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_3_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT1_3_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_3_LUTOUT14      16
#define BM_PXP_WFE_A_STG2_5X6_OUT1_3_LUTOUT14 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_3_LUTOUT14(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT1_3_LUTOUT14)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_3_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT1_3_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_3_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT1_3_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_3_LUTOUT13      8
#define BM_PXP_WFE_A_STG2_5X6_OUT1_3_LUTOUT13 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT1_3_LUTOUT13(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT1_3_LUTOUT13)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_3_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT1_3_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT1_3_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT1_3_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_3_LUTOUT12      0
#define BM_PXP_WFE_A_STG2_5X6_OUT1_3_LUTOUT12 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT1_3_LUTOUT12(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT1_3_LUTOUT12)

#define HW_PXP_WFE_A_STG2_5X6_OUT1_4	(0x00001b30)

#define BP_PXP_WFE_A_STG2_5X6_OUT1_4_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT1_4_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_4_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT1_4_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_4_LUTOUT19      24
#define BM_PXP_WFE_A_STG2_5X6_OUT1_4_LUTOUT19 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_4_LUTOUT19(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT1_4_LUTOUT19)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_4_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT1_4_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_4_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT1_4_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_4_LUTOUT18      16
#define BM_PXP_WFE_A_STG2_5X6_OUT1_4_LUTOUT18 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_4_LUTOUT18(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT1_4_LUTOUT18)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_4_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT1_4_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_4_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT1_4_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_4_LUTOUT17      8
#define BM_PXP_WFE_A_STG2_5X6_OUT1_4_LUTOUT17 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT1_4_LUTOUT17(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT1_4_LUTOUT17)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_4_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT1_4_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT1_4_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT1_4_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_4_LUTOUT16      0
#define BM_PXP_WFE_A_STG2_5X6_OUT1_4_LUTOUT16 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT1_4_LUTOUT16(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT1_4_LUTOUT16)

#define HW_PXP_WFE_A_STG2_5X6_OUT1_5	(0x00001b40)

#define BP_PXP_WFE_A_STG2_5X6_OUT1_5_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT1_5_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_5_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT1_5_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_5_LUTOUT23      24
#define BM_PXP_WFE_A_STG2_5X6_OUT1_5_LUTOUT23 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_5_LUTOUT23(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT1_5_LUTOUT23)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_5_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT1_5_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_5_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT1_5_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_5_LUTOUT22      16
#define BM_PXP_WFE_A_STG2_5X6_OUT1_5_LUTOUT22 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_5_LUTOUT22(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT1_5_LUTOUT22)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_5_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT1_5_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_5_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT1_5_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_5_LUTOUT21      8
#define BM_PXP_WFE_A_STG2_5X6_OUT1_5_LUTOUT21 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT1_5_LUTOUT21(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT1_5_LUTOUT21)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_5_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT1_5_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT1_5_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT1_5_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_5_LUTOUT20      0
#define BM_PXP_WFE_A_STG2_5X6_OUT1_5_LUTOUT20 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT1_5_LUTOUT20(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT1_5_LUTOUT20)

#define HW_PXP_WFE_A_STG2_5X6_OUT1_6	(0x00001b50)

#define BP_PXP_WFE_A_STG2_5X6_OUT1_6_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT1_6_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_6_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT1_6_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_6_LUTOUT27      24
#define BM_PXP_WFE_A_STG2_5X6_OUT1_6_LUTOUT27 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_6_LUTOUT27(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT1_6_LUTOUT27)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_6_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT1_6_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_6_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT1_6_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_6_LUTOUT26      16
#define BM_PXP_WFE_A_STG2_5X6_OUT1_6_LUTOUT26 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_6_LUTOUT26(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT1_6_LUTOUT26)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_6_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT1_6_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_6_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT1_6_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_6_LUTOUT25      8
#define BM_PXP_WFE_A_STG2_5X6_OUT1_6_LUTOUT25 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT1_6_LUTOUT25(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT1_6_LUTOUT25)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_6_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT1_6_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT1_6_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT1_6_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_6_LUTOUT24      0
#define BM_PXP_WFE_A_STG2_5X6_OUT1_6_LUTOUT24 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT1_6_LUTOUT24(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT1_6_LUTOUT24)

#define HW_PXP_WFE_A_STG2_5X6_OUT1_7	(0x00001b60)

#define BP_PXP_WFE_A_STG2_5X6_OUT1_7_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT1_7_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_7_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT1_7_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_7_LUTOUT31      24
#define BM_PXP_WFE_A_STG2_5X6_OUT1_7_LUTOUT31 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_7_LUTOUT31(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT1_7_LUTOUT31)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_7_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT1_7_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_7_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT1_7_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_7_LUTOUT30      16
#define BM_PXP_WFE_A_STG2_5X6_OUT1_7_LUTOUT30 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_7_LUTOUT30(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT1_7_LUTOUT30)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_7_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT1_7_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT1_7_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT1_7_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_7_LUTOUT29      8
#define BM_PXP_WFE_A_STG2_5X6_OUT1_7_LUTOUT29 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT1_7_LUTOUT29(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT1_7_LUTOUT29)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_7_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT1_7_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT1_7_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT1_7_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT1_7_LUTOUT28      0
#define BM_PXP_WFE_A_STG2_5X6_OUT1_7_LUTOUT28 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT1_7_LUTOUT28(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT1_7_LUTOUT28)

#define HW_PXP_WFE_A_STG2_5X6_OUT2_0	(0x00001b70)

#define BP_PXP_WFE_A_STG2_5X6_OUT2_0_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT2_0_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_0_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT2_0_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_0_LUTOUT3      24
#define BM_PXP_WFE_A_STG2_5X6_OUT2_0_LUTOUT3 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_0_LUTOUT3(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT2_0_LUTOUT3)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_0_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT2_0_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_0_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT2_0_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_0_LUTOUT2      16
#define BM_PXP_WFE_A_STG2_5X6_OUT2_0_LUTOUT2 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_0_LUTOUT2(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT2_0_LUTOUT2)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_0_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT2_0_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_0_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT2_0_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_0_LUTOUT1      8
#define BM_PXP_WFE_A_STG2_5X6_OUT2_0_LUTOUT1 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT2_0_LUTOUT1(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT2_0_LUTOUT1)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_0_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT2_0_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT2_0_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT2_0_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_0_LUTOUT0      0
#define BM_PXP_WFE_A_STG2_5X6_OUT2_0_LUTOUT0 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT2_0_LUTOUT0(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT2_0_LUTOUT0)

#define HW_PXP_WFE_A_STG2_5X6_OUT2_1	(0x00001b80)

#define BP_PXP_WFE_A_STG2_5X6_OUT2_1_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT2_1_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_1_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT2_1_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_1_LUTOUT7      24
#define BM_PXP_WFE_A_STG2_5X6_OUT2_1_LUTOUT7 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_1_LUTOUT7(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT2_1_LUTOUT7)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_1_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT2_1_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_1_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT2_1_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_1_LUTOUT6      16
#define BM_PXP_WFE_A_STG2_5X6_OUT2_1_LUTOUT6 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_1_LUTOUT6(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT2_1_LUTOUT6)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_1_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT2_1_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_1_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT2_1_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_1_LUTOUT5      8
#define BM_PXP_WFE_A_STG2_5X6_OUT2_1_LUTOUT5 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT2_1_LUTOUT5(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT2_1_LUTOUT5)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_1_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT2_1_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT2_1_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT2_1_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_1_LUTOUT4      0
#define BM_PXP_WFE_A_STG2_5X6_OUT2_1_LUTOUT4 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT2_1_LUTOUT4(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT2_1_LUTOUT4)

#define HW_PXP_WFE_A_STG2_5X6_OUT2_2	(0x00001b90)

#define BP_PXP_WFE_A_STG2_5X6_OUT2_2_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT2_2_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_2_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT2_2_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_2_LUTOUT11      24
#define BM_PXP_WFE_A_STG2_5X6_OUT2_2_LUTOUT11 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_2_LUTOUT11(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT2_2_LUTOUT11)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_2_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT2_2_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_2_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT2_2_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_2_LUTOUT10      16
#define BM_PXP_WFE_A_STG2_5X6_OUT2_2_LUTOUT10 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_2_LUTOUT10(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT2_2_LUTOUT10)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_2_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT2_2_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_2_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT2_2_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_2_LUTOUT9      8
#define BM_PXP_WFE_A_STG2_5X6_OUT2_2_LUTOUT9 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT2_2_LUTOUT9(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT2_2_LUTOUT9)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_2_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT2_2_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT2_2_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT2_2_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_2_LUTOUT8      0
#define BM_PXP_WFE_A_STG2_5X6_OUT2_2_LUTOUT8 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT2_2_LUTOUT8(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT2_2_LUTOUT8)

#define HW_PXP_WFE_A_STG2_5X6_OUT2_3	(0x00001ba0)

#define BP_PXP_WFE_A_STG2_5X6_OUT2_3_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT2_3_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_3_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT2_3_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_3_LUTOUT15      24
#define BM_PXP_WFE_A_STG2_5X6_OUT2_3_LUTOUT15 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_3_LUTOUT15(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT2_3_LUTOUT15)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_3_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT2_3_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_3_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT2_3_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_3_LUTOUT14      16
#define BM_PXP_WFE_A_STG2_5X6_OUT2_3_LUTOUT14 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_3_LUTOUT14(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT2_3_LUTOUT14)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_3_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT2_3_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_3_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT2_3_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_3_LUTOUT13      8
#define BM_PXP_WFE_A_STG2_5X6_OUT2_3_LUTOUT13 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT2_3_LUTOUT13(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT2_3_LUTOUT13)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_3_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT2_3_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT2_3_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT2_3_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_3_LUTOUT12      0
#define BM_PXP_WFE_A_STG2_5X6_OUT2_3_LUTOUT12 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT2_3_LUTOUT12(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT2_3_LUTOUT12)

#define HW_PXP_WFE_A_STG2_5X6_OUT2_4	(0x00001bb0)

#define BP_PXP_WFE_A_STG2_5X6_OUT2_4_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT2_4_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_4_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT2_4_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_4_LUTOUT19      24
#define BM_PXP_WFE_A_STG2_5X6_OUT2_4_LUTOUT19 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_4_LUTOUT19(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT2_4_LUTOUT19)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_4_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT2_4_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_4_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT2_4_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_4_LUTOUT18      16
#define BM_PXP_WFE_A_STG2_5X6_OUT2_4_LUTOUT18 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_4_LUTOUT18(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT2_4_LUTOUT18)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_4_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT2_4_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_4_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT2_4_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_4_LUTOUT17      8
#define BM_PXP_WFE_A_STG2_5X6_OUT2_4_LUTOUT17 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT2_4_LUTOUT17(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT2_4_LUTOUT17)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_4_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT2_4_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT2_4_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT2_4_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_4_LUTOUT16      0
#define BM_PXP_WFE_A_STG2_5X6_OUT2_4_LUTOUT16 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT2_4_LUTOUT16(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT2_4_LUTOUT16)

#define HW_PXP_WFE_A_STG2_5X6_OUT2_5	(0x00001bc0)

#define BP_PXP_WFE_A_STG2_5X6_OUT2_5_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT2_5_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_5_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT2_5_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_5_LUTOUT23      24
#define BM_PXP_WFE_A_STG2_5X6_OUT2_5_LUTOUT23 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_5_LUTOUT23(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT2_5_LUTOUT23)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_5_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT2_5_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_5_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT2_5_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_5_LUTOUT22      16
#define BM_PXP_WFE_A_STG2_5X6_OUT2_5_LUTOUT22 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_5_LUTOUT22(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT2_5_LUTOUT22)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_5_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT2_5_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_5_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT2_5_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_5_LUTOUT21      8
#define BM_PXP_WFE_A_STG2_5X6_OUT2_5_LUTOUT21 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT2_5_LUTOUT21(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT2_5_LUTOUT21)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_5_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT2_5_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT2_5_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT2_5_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_5_LUTOUT20      0
#define BM_PXP_WFE_A_STG2_5X6_OUT2_5_LUTOUT20 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT2_5_LUTOUT20(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT2_5_LUTOUT20)

#define HW_PXP_WFE_A_STG2_5X6_OUT2_6	(0x00001bd0)

#define BP_PXP_WFE_A_STG2_5X6_OUT2_6_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT2_6_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_6_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT2_6_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_6_LUTOUT27      24
#define BM_PXP_WFE_A_STG2_5X6_OUT2_6_LUTOUT27 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_6_LUTOUT27(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT2_6_LUTOUT27)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_6_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT2_6_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_6_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT2_6_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_6_LUTOUT26      16
#define BM_PXP_WFE_A_STG2_5X6_OUT2_6_LUTOUT26 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_6_LUTOUT26(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT2_6_LUTOUT26)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_6_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT2_6_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_6_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT2_6_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_6_LUTOUT25      8
#define BM_PXP_WFE_A_STG2_5X6_OUT2_6_LUTOUT25 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT2_6_LUTOUT25(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT2_6_LUTOUT25)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_6_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT2_6_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT2_6_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT2_6_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_6_LUTOUT24      0
#define BM_PXP_WFE_A_STG2_5X6_OUT2_6_LUTOUT24 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT2_6_LUTOUT24(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT2_6_LUTOUT24)

#define HW_PXP_WFE_A_STG2_5X6_OUT2_7	(0x00001be0)

#define BP_PXP_WFE_A_STG2_5X6_OUT2_7_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT2_7_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_7_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT2_7_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_7_LUTOUT31      24
#define BM_PXP_WFE_A_STG2_5X6_OUT2_7_LUTOUT31 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_7_LUTOUT31(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT2_7_LUTOUT31)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_7_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT2_7_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_7_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT2_7_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_7_LUTOUT30      16
#define BM_PXP_WFE_A_STG2_5X6_OUT2_7_LUTOUT30 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_7_LUTOUT30(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT2_7_LUTOUT30)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_7_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT2_7_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT2_7_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT2_7_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_7_LUTOUT29      8
#define BM_PXP_WFE_A_STG2_5X6_OUT2_7_LUTOUT29 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT2_7_LUTOUT29(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT2_7_LUTOUT29)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_7_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT2_7_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT2_7_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT2_7_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT2_7_LUTOUT28      0
#define BM_PXP_WFE_A_STG2_5X6_OUT2_7_LUTOUT28 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT2_7_LUTOUT28(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT2_7_LUTOUT28)

#define HW_PXP_WFE_A_STG2_5X6_OUT3_0	(0x00001bf0)

#define BP_PXP_WFE_A_STG2_5X6_OUT3_0_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT3_0_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_0_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT3_0_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_0_LUTOUT3      24
#define BM_PXP_WFE_A_STG2_5X6_OUT3_0_LUTOUT3 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_0_LUTOUT3(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT3_0_LUTOUT3)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_0_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT3_0_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_0_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT3_0_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_0_LUTOUT2      16
#define BM_PXP_WFE_A_STG2_5X6_OUT3_0_LUTOUT2 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_0_LUTOUT2(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT3_0_LUTOUT2)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_0_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT3_0_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_0_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT3_0_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_0_LUTOUT1      8
#define BM_PXP_WFE_A_STG2_5X6_OUT3_0_LUTOUT1 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT3_0_LUTOUT1(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT3_0_LUTOUT1)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_0_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT3_0_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT3_0_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT3_0_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_0_LUTOUT0      0
#define BM_PXP_WFE_A_STG2_5X6_OUT3_0_LUTOUT0 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT3_0_LUTOUT0(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT3_0_LUTOUT0)

#define HW_PXP_WFE_A_STG2_5X6_OUT3_1	(0x00001c00)

#define BP_PXP_WFE_A_STG2_5X6_OUT3_1_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT3_1_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_1_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT3_1_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_1_LUTOUT7      24
#define BM_PXP_WFE_A_STG2_5X6_OUT3_1_LUTOUT7 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_1_LUTOUT7(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT3_1_LUTOUT7)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_1_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT3_1_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_1_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT3_1_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_1_LUTOUT6      16
#define BM_PXP_WFE_A_STG2_5X6_OUT3_1_LUTOUT6 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_1_LUTOUT6(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT3_1_LUTOUT6)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_1_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT3_1_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_1_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT3_1_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_1_LUTOUT5      8
#define BM_PXP_WFE_A_STG2_5X6_OUT3_1_LUTOUT5 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT3_1_LUTOUT5(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT3_1_LUTOUT5)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_1_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT3_1_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT3_1_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT3_1_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_1_LUTOUT4      0
#define BM_PXP_WFE_A_STG2_5X6_OUT3_1_LUTOUT4 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT3_1_LUTOUT4(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT3_1_LUTOUT4)

#define HW_PXP_WFE_A_STG2_5X6_OUT3_2	(0x00001c10)

#define BP_PXP_WFE_A_STG2_5X6_OUT3_2_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT3_2_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_2_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT3_2_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_2_LUTOUT11      24
#define BM_PXP_WFE_A_STG2_5X6_OUT3_2_LUTOUT11 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_2_LUTOUT11(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT3_2_LUTOUT11)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_2_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT3_2_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_2_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT3_2_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_2_LUTOUT10      16
#define BM_PXP_WFE_A_STG2_5X6_OUT3_2_LUTOUT10 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_2_LUTOUT10(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT3_2_LUTOUT10)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_2_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT3_2_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_2_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT3_2_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_2_LUTOUT9      8
#define BM_PXP_WFE_A_STG2_5X6_OUT3_2_LUTOUT9 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT3_2_LUTOUT9(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT3_2_LUTOUT9)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_2_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT3_2_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT3_2_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT3_2_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_2_LUTOUT8      0
#define BM_PXP_WFE_A_STG2_5X6_OUT3_2_LUTOUT8 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT3_2_LUTOUT8(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT3_2_LUTOUT8)

#define HW_PXP_WFE_A_STG2_5X6_OUT3_3	(0x00001c20)

#define BP_PXP_WFE_A_STG2_5X6_OUT3_3_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT3_3_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_3_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT3_3_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_3_LUTOUT15      24
#define BM_PXP_WFE_A_STG2_5X6_OUT3_3_LUTOUT15 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_3_LUTOUT15(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT3_3_LUTOUT15)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_3_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT3_3_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_3_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT3_3_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_3_LUTOUT14      16
#define BM_PXP_WFE_A_STG2_5X6_OUT3_3_LUTOUT14 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_3_LUTOUT14(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT3_3_LUTOUT14)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_3_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT3_3_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_3_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT3_3_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_3_LUTOUT13      8
#define BM_PXP_WFE_A_STG2_5X6_OUT3_3_LUTOUT13 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT3_3_LUTOUT13(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT3_3_LUTOUT13)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_3_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT3_3_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT3_3_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT3_3_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_3_LUTOUT12      0
#define BM_PXP_WFE_A_STG2_5X6_OUT3_3_LUTOUT12 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT3_3_LUTOUT12(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT3_3_LUTOUT12)

#define HW_PXP_WFE_A_STG2_5X6_OUT3_4	(0x00001c30)

#define BP_PXP_WFE_A_STG2_5X6_OUT3_4_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT3_4_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_4_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT3_4_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_4_LUTOUT19      24
#define BM_PXP_WFE_A_STG2_5X6_OUT3_4_LUTOUT19 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_4_LUTOUT19(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT3_4_LUTOUT19)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_4_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT3_4_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_4_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT3_4_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_4_LUTOUT18      16
#define BM_PXP_WFE_A_STG2_5X6_OUT3_4_LUTOUT18 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_4_LUTOUT18(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT3_4_LUTOUT18)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_4_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT3_4_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_4_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT3_4_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_4_LUTOUT17      8
#define BM_PXP_WFE_A_STG2_5X6_OUT3_4_LUTOUT17 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT3_4_LUTOUT17(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT3_4_LUTOUT17)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_4_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT3_4_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT3_4_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT3_4_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_4_LUTOUT16      0
#define BM_PXP_WFE_A_STG2_5X6_OUT3_4_LUTOUT16 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT3_4_LUTOUT16(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT3_4_LUTOUT16)

#define HW_PXP_WFE_A_STG2_5X6_OUT3_5	(0x00001c40)

#define BP_PXP_WFE_A_STG2_5X6_OUT3_5_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT3_5_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_5_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT3_5_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_5_LUTOUT23      24
#define BM_PXP_WFE_A_STG2_5X6_OUT3_5_LUTOUT23 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_5_LUTOUT23(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT3_5_LUTOUT23)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_5_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT3_5_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_5_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT3_5_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_5_LUTOUT22      16
#define BM_PXP_WFE_A_STG2_5X6_OUT3_5_LUTOUT22 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_5_LUTOUT22(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT3_5_LUTOUT22)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_5_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT3_5_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_5_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT3_5_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_5_LUTOUT21      8
#define BM_PXP_WFE_A_STG2_5X6_OUT3_5_LUTOUT21 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT3_5_LUTOUT21(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT3_5_LUTOUT21)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_5_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT3_5_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT3_5_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT3_5_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_5_LUTOUT20      0
#define BM_PXP_WFE_A_STG2_5X6_OUT3_5_LUTOUT20 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT3_5_LUTOUT20(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT3_5_LUTOUT20)

#define HW_PXP_WFE_A_STG2_5X6_OUT3_6	(0x00001c50)

#define BP_PXP_WFE_A_STG2_5X6_OUT3_6_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT3_6_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_6_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT3_6_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_6_LUTOUT27      24
#define BM_PXP_WFE_A_STG2_5X6_OUT3_6_LUTOUT27 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_6_LUTOUT27(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT3_6_LUTOUT27)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_6_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT3_6_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_6_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT3_6_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_6_LUTOUT26      16
#define BM_PXP_WFE_A_STG2_5X6_OUT3_6_LUTOUT26 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_6_LUTOUT26(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT3_6_LUTOUT26)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_6_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT3_6_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_6_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT3_6_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_6_LUTOUT25      8
#define BM_PXP_WFE_A_STG2_5X6_OUT3_6_LUTOUT25 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT3_6_LUTOUT25(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT3_6_LUTOUT25)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_6_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT3_6_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT3_6_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT3_6_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_6_LUTOUT24      0
#define BM_PXP_WFE_A_STG2_5X6_OUT3_6_LUTOUT24 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT3_6_LUTOUT24(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT3_6_LUTOUT24)

#define HW_PXP_WFE_A_STG2_5X6_OUT3_7	(0x00001c60)

#define BP_PXP_WFE_A_STG2_5X6_OUT3_7_RSVD0      30
#define BM_PXP_WFE_A_STG2_5X6_OUT3_7_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_7_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X6_OUT3_7_RSVD0)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_7_LUTOUT31      24
#define BM_PXP_WFE_A_STG2_5X6_OUT3_7_LUTOUT31 0x3F000000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_7_LUTOUT31(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X6_OUT3_7_LUTOUT31)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_7_RSVD1      22
#define BM_PXP_WFE_A_STG2_5X6_OUT3_7_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_7_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X6_OUT3_7_RSVD1)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_7_LUTOUT30      16
#define BM_PXP_WFE_A_STG2_5X6_OUT3_7_LUTOUT30 0x003F0000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_7_LUTOUT30(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X6_OUT3_7_LUTOUT30)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_7_RSVD2      14
#define BM_PXP_WFE_A_STG2_5X6_OUT3_7_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STG2_5X6_OUT3_7_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X6_OUT3_7_RSVD2)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_7_LUTOUT29      8
#define BM_PXP_WFE_A_STG2_5X6_OUT3_7_LUTOUT29 0x00003F00
#define BF_PXP_WFE_A_STG2_5X6_OUT3_7_LUTOUT29(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X6_OUT3_7_LUTOUT29)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_7_RSVD3      6
#define BM_PXP_WFE_A_STG2_5X6_OUT3_7_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STG2_5X6_OUT3_7_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X6_OUT3_7_RSVD3)
#define BP_PXP_WFE_A_STG2_5X6_OUT3_7_LUTOUT28      0
#define BM_PXP_WFE_A_STG2_5X6_OUT3_7_LUTOUT28 0x0000003F
#define BF_PXP_WFE_A_STG2_5X6_OUT3_7_LUTOUT28(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X6_OUT3_7_LUTOUT28)

#define HW_PXP_WFE_A_STAGE2_5X6_MASKS_0	(0x00001c70)

#define BP_PXP_WFE_A_STAGE2_5X6_MASKS_0_RSVD0      29
#define BM_PXP_WFE_A_STAGE2_5X6_MASKS_0_RSVD0 0xE0000000
#define BF_PXP_WFE_A_STAGE2_5X6_MASKS_0_RSVD0(v) \
        (((v) << 29) & BM_PXP_WFE_A_STAGE2_5X6_MASKS_0_RSVD0)
#define BP_PXP_WFE_A_STAGE2_5X6_MASKS_0_MASK3      24
#define BM_PXP_WFE_A_STAGE2_5X6_MASKS_0_MASK3 0x1F000000
#define BF_PXP_WFE_A_STAGE2_5X6_MASKS_0_MASK3(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STAGE2_5X6_MASKS_0_MASK3)
#define BP_PXP_WFE_A_STAGE2_5X6_MASKS_0_RSVD1      21
#define BM_PXP_WFE_A_STAGE2_5X6_MASKS_0_RSVD1 0x00E00000
#define BF_PXP_WFE_A_STAGE2_5X6_MASKS_0_RSVD1(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STAGE2_5X6_MASKS_0_RSVD1)
#define BP_PXP_WFE_A_STAGE2_5X6_MASKS_0_MASK2      16
#define BM_PXP_WFE_A_STAGE2_5X6_MASKS_0_MASK2 0x001F0000
#define BF_PXP_WFE_A_STAGE2_5X6_MASKS_0_MASK2(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STAGE2_5X6_MASKS_0_MASK2)
#define BP_PXP_WFE_A_STAGE2_5X6_MASKS_0_RSVD2      13
#define BM_PXP_WFE_A_STAGE2_5X6_MASKS_0_RSVD2 0x0000E000
#define BF_PXP_WFE_A_STAGE2_5X6_MASKS_0_RSVD2(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STAGE2_5X6_MASKS_0_RSVD2)
#define BP_PXP_WFE_A_STAGE2_5X6_MASKS_0_MASK1      8
#define BM_PXP_WFE_A_STAGE2_5X6_MASKS_0_MASK1 0x00001F00
#define BF_PXP_WFE_A_STAGE2_5X6_MASKS_0_MASK1(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STAGE2_5X6_MASKS_0_MASK1)
#define BP_PXP_WFE_A_STAGE2_5X6_MASKS_0_RSVD3      5
#define BM_PXP_WFE_A_STAGE2_5X6_MASKS_0_RSVD3 0x000000E0
#define BF_PXP_WFE_A_STAGE2_5X6_MASKS_0_RSVD3(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STAGE2_5X6_MASKS_0_RSVD3)
#define BP_PXP_WFE_A_STAGE2_5X6_MASKS_0_MASK0      0
#define BM_PXP_WFE_A_STAGE2_5X6_MASKS_0_MASK0 0x0000001F
#define BF_PXP_WFE_A_STAGE2_5X6_MASKS_0_MASK0(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STAGE2_5X6_MASKS_0_MASK0)

#define HW_PXP_WFE_A_STAGE2_5X6_ADDR_0	(0x00001c80)

#define BP_PXP_WFE_A_STAGE2_5X6_ADDR_0_RSVD0      30
#define BM_PXP_WFE_A_STAGE2_5X6_ADDR_0_RSVD0 0xC0000000
#define BF_PXP_WFE_A_STAGE2_5X6_ADDR_0_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_A_STAGE2_5X6_ADDR_0_RSVD0)
#define BP_PXP_WFE_A_STAGE2_5X6_ADDR_0_MUXADDR3      24
#define BM_PXP_WFE_A_STAGE2_5X6_ADDR_0_MUXADDR3 0x3F000000
#define BF_PXP_WFE_A_STAGE2_5X6_ADDR_0_MUXADDR3(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STAGE2_5X6_ADDR_0_MUXADDR3)
#define BP_PXP_WFE_A_STAGE2_5X6_ADDR_0_RSVD1      22
#define BM_PXP_WFE_A_STAGE2_5X6_ADDR_0_RSVD1 0x00C00000
#define BF_PXP_WFE_A_STAGE2_5X6_ADDR_0_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STAGE2_5X6_ADDR_0_RSVD1)
#define BP_PXP_WFE_A_STAGE2_5X6_ADDR_0_MUXADDR2      16
#define BM_PXP_WFE_A_STAGE2_5X6_ADDR_0_MUXADDR2 0x003F0000
#define BF_PXP_WFE_A_STAGE2_5X6_ADDR_0_MUXADDR2(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STAGE2_5X6_ADDR_0_MUXADDR2)
#define BP_PXP_WFE_A_STAGE2_5X6_ADDR_0_RSVD2      14
#define BM_PXP_WFE_A_STAGE2_5X6_ADDR_0_RSVD2 0x0000C000
#define BF_PXP_WFE_A_STAGE2_5X6_ADDR_0_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STAGE2_5X6_ADDR_0_RSVD2)
#define BP_PXP_WFE_A_STAGE2_5X6_ADDR_0_MUXADDR1      8
#define BM_PXP_WFE_A_STAGE2_5X6_ADDR_0_MUXADDR1 0x00003F00
#define BF_PXP_WFE_A_STAGE2_5X6_ADDR_0_MUXADDR1(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STAGE2_5X6_ADDR_0_MUXADDR1)
#define BP_PXP_WFE_A_STAGE2_5X6_ADDR_0_RSVD3      6
#define BM_PXP_WFE_A_STAGE2_5X6_ADDR_0_RSVD3 0x000000C0
#define BF_PXP_WFE_A_STAGE2_5X6_ADDR_0_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STAGE2_5X6_ADDR_0_RSVD3)
#define BP_PXP_WFE_A_STAGE2_5X6_ADDR_0_MUXADDR0      0
#define BM_PXP_WFE_A_STAGE2_5X6_ADDR_0_MUXADDR0 0x0000003F
#define BF_PXP_WFE_A_STAGE2_5X6_ADDR_0_MUXADDR0(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STAGE2_5X6_ADDR_0_MUXADDR0)

#define HW_PXP_WFE_A_STG2_5X1_OUT0	(0x00001c90)

#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT31 0x80000000
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT31(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT31)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT30 0x40000000
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT30(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT30)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT29 0x20000000
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT29(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT29)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT28 0x10000000
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT28(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT28)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT27 0x08000000
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT27(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT27)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT26 0x04000000
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT26(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT26)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT25 0x02000000
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT25(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT25)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT24 0x01000000
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT24(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT24)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT23 0x00800000
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT23(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT23)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT22 0x00400000
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT22(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT22)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT21 0x00200000
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT21(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT21)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT20 0x00100000
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT20(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT20)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT19 0x00080000
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT19(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT19)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT18 0x00040000
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT18(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT18)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT17 0x00020000
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT17(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT17)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT16 0x00010000
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT16(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT16)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT15 0x00008000
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT15(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT15)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT14 0x00004000
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT14(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT14)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT13 0x00002000
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT13(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT13)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT12 0x00001000
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT12(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT12)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT11 0x00000800
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT11(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT11)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT10 0x00000400
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT10(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT10)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT9 0x00000200
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT9(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT9)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT8 0x00000100
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT8(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT8)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT7 0x00000080
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT7(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT7)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT6 0x00000040
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT6(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT6)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT5 0x00000020
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT5(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT5)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT4 0x00000010
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT4(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT4)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT3 0x00000008
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT3(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT3)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT2 0x00000004
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT2(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT2)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT1 0x00000002
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT1(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT1)
#define BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT0 0x00000001
#define BF_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT0(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X1_OUT0_LUTOUT0)

#define HW_PXP_WFE_A_STG2_5X1_OUT1	(0x00001ca0)

#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT31 0x80000000
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT31(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT31)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT30 0x40000000
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT30(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT30)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT29 0x20000000
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT29(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT29)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT28 0x10000000
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT28(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT28)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT27 0x08000000
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT27(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT27)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT26 0x04000000
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT26(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT26)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT25 0x02000000
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT25(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT25)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT24 0x01000000
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT24(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT24)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT23 0x00800000
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT23(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT23)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT22 0x00400000
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT22(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT22)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT21 0x00200000
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT21(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT21)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT20 0x00100000
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT20(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT20)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT19 0x00080000
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT19(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT19)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT18 0x00040000
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT18(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT18)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT17 0x00020000
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT17(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT17)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT16 0x00010000
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT16(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT16)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT15 0x00008000
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT15(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT15)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT14 0x00004000
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT14(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT14)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT13 0x00002000
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT13(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT13)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT12 0x00001000
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT12(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT12)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT11 0x00000800
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT11(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT11)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT10 0x00000400
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT10(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT10)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT9 0x00000200
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT9(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT9)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT8 0x00000100
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT8(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT8)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT7 0x00000080
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT7(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT7)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT6 0x00000040
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT6(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT6)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT5 0x00000020
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT5(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT5)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT4 0x00000010
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT4(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT4)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT3 0x00000008
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT3(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT3)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT2 0x00000004
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT2(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT2)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT1 0x00000002
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT1(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT1)
#define BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT0 0x00000001
#define BF_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT0(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X1_OUT1_LUTOUT0)

#define HW_PXP_WFE_A_STG2_5X1_OUT2	(0x00001cb0)

#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT31 0x80000000
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT31(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT31)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT30 0x40000000
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT30(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT30)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT29 0x20000000
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT29(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT29)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT28 0x10000000
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT28(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT28)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT27 0x08000000
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT27(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT27)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT26 0x04000000
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT26(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT26)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT25 0x02000000
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT25(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT25)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT24 0x01000000
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT24(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT24)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT23 0x00800000
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT23(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT23)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT22 0x00400000
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT22(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT22)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT21 0x00200000
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT21(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT21)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT20 0x00100000
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT20(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT20)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT19 0x00080000
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT19(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT19)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT18 0x00040000
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT18(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT18)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT17 0x00020000
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT17(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT17)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT16 0x00010000
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT16(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT16)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT15 0x00008000
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT15(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT15)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT14 0x00004000
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT14(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT14)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT13 0x00002000
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT13(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT13)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT12 0x00001000
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT12(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT12)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT11 0x00000800
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT11(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT11)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT10 0x00000400
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT10(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT10)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT9 0x00000200
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT9(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT9)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT8 0x00000100
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT8(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT8)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT7 0x00000080
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT7(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT7)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT6 0x00000040
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT6(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT6)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT5 0x00000020
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT5(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT5)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT4 0x00000010
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT4(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT4)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT3 0x00000008
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT3(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT3)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT2 0x00000004
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT2(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT2)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT1 0x00000002
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT1(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT1)
#define BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT0 0x00000001
#define BF_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT0(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X1_OUT2_LUTOUT0)

#define HW_PXP_WFE_A_STG2_5X1_OUT3	(0x00001cc0)

#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT31 0x80000000
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT31(v) \
        (((v) << 31) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT31)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT30 0x40000000
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT30(v)  \
        (((v) << 30) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT30)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT29 0x20000000
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT29(v)  \
        (((v) << 29) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT29)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT28 0x10000000
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT28(v)  \
        (((v) << 28) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT28)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT27 0x08000000
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT27(v)  \
        (((v) << 27) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT27)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT26 0x04000000
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT26(v)  \
        (((v) << 26) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT26)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT25 0x02000000
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT25(v)  \
        (((v) << 25) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT25)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT24 0x01000000
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT24(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT24)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT23 0x00800000
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT23(v)  \
        (((v) << 23) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT23)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT22 0x00400000
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT22(v)  \
        (((v) << 22) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT22)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT21 0x00200000
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT21(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT21)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT20 0x00100000
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT20(v)  \
        (((v) << 20) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT20)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT19 0x00080000
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT19(v)  \
        (((v) << 19) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT19)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT18 0x00040000
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT18(v)  \
        (((v) << 18) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT18)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT17 0x00020000
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT17(v)  \
        (((v) << 17) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT17)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT16 0x00010000
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT16(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT16)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT15 0x00008000
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT15(v)  \
        (((v) << 15) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT15)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT14 0x00004000
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT14(v)  \
        (((v) << 14) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT14)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT13 0x00002000
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT13(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT13)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT12 0x00001000
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT12(v)  \
        (((v) << 12) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT12)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT11 0x00000800
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT11(v)  \
        (((v) << 11) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT11)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT10 0x00000400
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT10(v)  \
        (((v) << 10) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT10)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT9 0x00000200
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT9(v)  \
        (((v) << 9) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT9)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT8 0x00000100
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT8(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT8)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT7 0x00000080
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT7(v)  \
        (((v) << 7) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT7)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT6 0x00000040
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT6(v)  \
        (((v) << 6) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT6)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT5 0x00000020
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT5(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT5)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT4 0x00000010
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT4(v)  \
        (((v) << 4) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT4)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT3 0x00000008
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT3(v)  \
        (((v) << 3) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT3)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT2 0x00000004
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT2(v)  \
        (((v) << 2) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT2)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT1 0x00000002
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT1(v)  \
        (((v) << 1) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT1)
#define BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT0 0x00000001
#define BF_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT0(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X1_OUT3_LUTOUT0)

#define HW_PXP_WFE_A_STG2_5X1_MASKS	(0x00001cd0)

#define BP_PXP_WFE_A_STG2_5X1_MASKS_RSVD3      29
#define BM_PXP_WFE_A_STG2_5X1_MASKS_RSVD3 0xE0000000
#define BF_PXP_WFE_A_STG2_5X1_MASKS_RSVD3(v) \
        (((v) << 29) & BM_PXP_WFE_A_STG2_5X1_MASKS_RSVD3)
#define BP_PXP_WFE_A_STG2_5X1_MASKS_MASK3      24
#define BM_PXP_WFE_A_STG2_5X1_MASKS_MASK3 0x1F000000
#define BF_PXP_WFE_A_STG2_5X1_MASKS_MASK3(v)  \
        (((v) << 24) & BM_PXP_WFE_A_STG2_5X1_MASKS_MASK3)
#define BP_PXP_WFE_A_STG2_5X1_MASKS_RSVD2      21
#define BM_PXP_WFE_A_STG2_5X1_MASKS_RSVD2 0x00E00000
#define BF_PXP_WFE_A_STG2_5X1_MASKS_RSVD2(v)  \
        (((v) << 21) & BM_PXP_WFE_A_STG2_5X1_MASKS_RSVD2)
#define BP_PXP_WFE_A_STG2_5X1_MASKS_MASK2      16
#define BM_PXP_WFE_A_STG2_5X1_MASKS_MASK2 0x001F0000
#define BF_PXP_WFE_A_STG2_5X1_MASKS_MASK2(v)  \
        (((v) << 16) & BM_PXP_WFE_A_STG2_5X1_MASKS_MASK2)
#define BP_PXP_WFE_A_STG2_5X1_MASKS_RSVD1      13
#define BM_PXP_WFE_A_STG2_5X1_MASKS_RSVD1 0x0000E000
#define BF_PXP_WFE_A_STG2_5X1_MASKS_RSVD1(v)  \
        (((v) << 13) & BM_PXP_WFE_A_STG2_5X1_MASKS_RSVD1)
#define BP_PXP_WFE_A_STG2_5X1_MASKS_MASK1      8
#define BM_PXP_WFE_A_STG2_5X1_MASKS_MASK1 0x00001F00
#define BF_PXP_WFE_A_STG2_5X1_MASKS_MASK1(v)  \
        (((v) << 8) & BM_PXP_WFE_A_STG2_5X1_MASKS_MASK1)
#define BP_PXP_WFE_A_STG2_5X1_MASKS_RSVD0      5
#define BM_PXP_WFE_A_STG2_5X1_MASKS_RSVD0 0x000000E0
#define BF_PXP_WFE_A_STG2_5X1_MASKS_RSVD0(v)  \
        (((v) << 5) & BM_PXP_WFE_A_STG2_5X1_MASKS_RSVD0)
#define BP_PXP_WFE_A_STG2_5X1_MASKS_MASK0      0
#define BM_PXP_WFE_A_STG2_5X1_MASKS_MASK0 0x0000001F
#define BF_PXP_WFE_A_STG2_5X1_MASKS_MASK0(v)  \
        (((v) << 0) & BM_PXP_WFE_A_STG2_5X1_MASKS_MASK0)

#define HW_PXP_WFE_B_CTRL	(0x00001d00)
#define HW_PXP_WFE_B_CTRL_SET	(0x00001d04)
#define HW_PXP_WFE_B_CTRL_CLR	(0x00001d08)
#define HW_PXP_WFE_B_CTRL_TOG	(0x00001d0c)

#define BM_PXP_WFE_B_CTRL_DONE 0x80000000
#define BF_PXP_WFE_B_CTRL_DONE(v) \
        (((v) << 31) & BM_PXP_WFE_B_CTRL_DONE)
#define BP_PXP_WFE_B_CTRL_RSVD0      3
#define BM_PXP_WFE_B_CTRL_RSVD0 0x7FFFFFF8
#define BF_PXP_WFE_B_CTRL_RSVD0(v)  \
        (((v) << 3) & BM_PXP_WFE_B_CTRL_RSVD0)
#define BM_PXP_WFE_B_CTRL_SW_RESET 0x00000004
#define BF_PXP_WFE_B_CTRL_SW_RESET(v)  \
        (((v) << 2) & BM_PXP_WFE_B_CTRL_SW_RESET)
#define BM_PXP_WFE_B_CTRL_RSVD1 0x00000002
#define BF_PXP_WFE_B_CTRL_RSVD1(v)  \
        (((v) << 1) & BM_PXP_WFE_B_CTRL_RSVD1)
#define BM_PXP_WFE_B_CTRL_ENABLE 0x00000001
#define BF_PXP_WFE_B_CTRL_ENABLE(v)  \
        (((v) << 0) & BM_PXP_WFE_B_CTRL_ENABLE)
#define BV_PXP_WFE_B_CTRL_ENABLE__0 0x0
#define BV_PXP_WFE_B_CTRL_ENABLE__1 0x1

#define HW_PXP_WFE_B_DIMENSIONS	(0x00001d10)

#define BP_PXP_WFE_B_DIMENSIONS_RSVD0      28
#define BM_PXP_WFE_B_DIMENSIONS_RSVD0 0xF0000000
#define BF_PXP_WFE_B_DIMENSIONS_RSVD0(v) \
        (((v) << 28) & BM_PXP_WFE_B_DIMENSIONS_RSVD0)
#define BP_PXP_WFE_B_DIMENSIONS_HEIGHT      16
#define BM_PXP_WFE_B_DIMENSIONS_HEIGHT 0x0FFF0000
#define BF_PXP_WFE_B_DIMENSIONS_HEIGHT(v)  \
        (((v) << 16) & BM_PXP_WFE_B_DIMENSIONS_HEIGHT)
#define BP_PXP_WFE_B_DIMENSIONS_RSVD1      12
#define BM_PXP_WFE_B_DIMENSIONS_RSVD1 0x0000F000
#define BF_PXP_WFE_B_DIMENSIONS_RSVD1(v)  \
        (((v) << 12) & BM_PXP_WFE_B_DIMENSIONS_RSVD1)
#define BP_PXP_WFE_B_DIMENSIONS_WIDTH      0
#define BM_PXP_WFE_B_DIMENSIONS_WIDTH 0x00000FFF
#define BF_PXP_WFE_B_DIMENSIONS_WIDTH(v)  \
        (((v) << 0) & BM_PXP_WFE_B_DIMENSIONS_WIDTH)

#define HW_PXP_WFE_B_OFFSET	(0x00001d20)

#define BP_PXP_WFE_B_OFFSET_RSVD0      28
#define BM_PXP_WFE_B_OFFSET_RSVD0 0xF0000000
#define BF_PXP_WFE_B_OFFSET_RSVD0(v) \
        (((v) << 28) & BM_PXP_WFE_B_OFFSET_RSVD0)
#define BP_PXP_WFE_B_OFFSET_Y_OFFSET      16
#define BM_PXP_WFE_B_OFFSET_Y_OFFSET 0x0FFF0000
#define BF_PXP_WFE_B_OFFSET_Y_OFFSET(v)  \
        (((v) << 16) & BM_PXP_WFE_B_OFFSET_Y_OFFSET)
#define BP_PXP_WFE_B_OFFSET_RSVD1      12
#define BM_PXP_WFE_B_OFFSET_RSVD1 0x0000F000
#define BF_PXP_WFE_B_OFFSET_RSVD1(v)  \
        (((v) << 12) & BM_PXP_WFE_B_OFFSET_RSVD1)
#define BP_PXP_WFE_B_OFFSET_X_OFFSET      0
#define BM_PXP_WFE_B_OFFSET_X_OFFSET 0x00000FFF
#define BF_PXP_WFE_B_OFFSET_X_OFFSET(v)  \
        (((v) << 0) & BM_PXP_WFE_B_OFFSET_X_OFFSET)

#define HW_PXP_WFE_B_SW_DATA_REGS	(0x00001d30)

#define BP_PXP_WFE_B_SW_DATA_REGS_VAL3      24
#define BM_PXP_WFE_B_SW_DATA_REGS_VAL3 0xFF000000
#define BF_PXP_WFE_B_SW_DATA_REGS_VAL3(v) \
        (((v) << 24) & BM_PXP_WFE_B_SW_DATA_REGS_VAL3)
#define BP_PXP_WFE_B_SW_DATA_REGS_VAL2      16
#define BM_PXP_WFE_B_SW_DATA_REGS_VAL2 0x00FF0000
#define BF_PXP_WFE_B_SW_DATA_REGS_VAL2(v)  \
        (((v) << 16) & BM_PXP_WFE_B_SW_DATA_REGS_VAL2)
#define BP_PXP_WFE_B_SW_DATA_REGS_VAL1      8
#define BM_PXP_WFE_B_SW_DATA_REGS_VAL1 0x0000FF00
#define BF_PXP_WFE_B_SW_DATA_REGS_VAL1(v)  \
        (((v) << 8) & BM_PXP_WFE_B_SW_DATA_REGS_VAL1)
#define BP_PXP_WFE_B_SW_DATA_REGS_VAL0      0
#define BM_PXP_WFE_B_SW_DATA_REGS_VAL0 0x000000FF
#define BF_PXP_WFE_B_SW_DATA_REGS_VAL0(v)  \
        (((v) << 0) & BM_PXP_WFE_B_SW_DATA_REGS_VAL0)

#define HW_PXP_WFE_B_SW_FLAG_REGS	(0x00001d40)

#define BP_PXP_WFE_B_SW_FLAG_REGS_RSVD      4
#define BM_PXP_WFE_B_SW_FLAG_REGS_RSVD 0xFFFFFFF0
#define BF_PXP_WFE_B_SW_FLAG_REGS_RSVD(v) \
        (((v) << 4) & BM_PXP_WFE_B_SW_FLAG_REGS_RSVD)
#define BM_PXP_WFE_B_SW_FLAG_REGS_VAL3 0x00000008
#define BF_PXP_WFE_B_SW_FLAG_REGS_VAL3(v)  \
        (((v) << 3) & BM_PXP_WFE_B_SW_FLAG_REGS_VAL3)
#define BM_PXP_WFE_B_SW_FLAG_REGS_VAL2 0x00000004
#define BF_PXP_WFE_B_SW_FLAG_REGS_VAL2(v)  \
        (((v) << 2) & BM_PXP_WFE_B_SW_FLAG_REGS_VAL2)
#define BM_PXP_WFE_B_SW_FLAG_REGS_VAL1 0x00000002
#define BF_PXP_WFE_B_SW_FLAG_REGS_VAL1(v)  \
        (((v) << 1) & BM_PXP_WFE_B_SW_FLAG_REGS_VAL1)
#define BM_PXP_WFE_B_SW_FLAG_REGS_VAL0 0x00000001
#define BF_PXP_WFE_B_SW_FLAG_REGS_VAL0(v)  \
        (((v) << 0) & BM_PXP_WFE_B_SW_FLAG_REGS_VAL0)

#define HW_PXP_WFE_B_STAGE1_MUX0	(0x00001d50)
#define HW_PXP_WFE_B_STAGE1_MUX0_SET	(0x00001d54)
#define HW_PXP_WFE_B_STAGE1_MUX0_CLR	(0x00001d58)
#define HW_PXP_WFE_B_STAGE1_MUX0_TOG	(0x00001d5c)

#define BP_PXP_WFE_B_STAGE1_MUX0_RSVD0      30
#define BM_PXP_WFE_B_STAGE1_MUX0_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE1_MUX0_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE1_MUX0_RSVD0)
#define BP_PXP_WFE_B_STAGE1_MUX0_MUX3      24
#define BM_PXP_WFE_B_STAGE1_MUX0_MUX3 0x3F000000
#define BF_PXP_WFE_B_STAGE1_MUX0_MUX3(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE1_MUX0_MUX3)
#define BP_PXP_WFE_B_STAGE1_MUX0_RSVD1      22
#define BM_PXP_WFE_B_STAGE1_MUX0_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE1_MUX0_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE1_MUX0_RSVD1)
#define BP_PXP_WFE_B_STAGE1_MUX0_MUX2      16
#define BM_PXP_WFE_B_STAGE1_MUX0_MUX2 0x003F0000
#define BF_PXP_WFE_B_STAGE1_MUX0_MUX2(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE1_MUX0_MUX2)
#define BP_PXP_WFE_B_STAGE1_MUX0_RSVD2      14
#define BM_PXP_WFE_B_STAGE1_MUX0_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE1_MUX0_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE1_MUX0_RSVD2)
#define BP_PXP_WFE_B_STAGE1_MUX0_MUX1      8
#define BM_PXP_WFE_B_STAGE1_MUX0_MUX1 0x00003F00
#define BF_PXP_WFE_B_STAGE1_MUX0_MUX1(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE1_MUX0_MUX1)
#define BP_PXP_WFE_B_STAGE1_MUX0_RSVD3      6
#define BM_PXP_WFE_B_STAGE1_MUX0_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE1_MUX0_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE1_MUX0_RSVD3)
#define BP_PXP_WFE_B_STAGE1_MUX0_MUX0      0
#define BM_PXP_WFE_B_STAGE1_MUX0_MUX0 0x0000003F
#define BF_PXP_WFE_B_STAGE1_MUX0_MUX0(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE1_MUX0_MUX0)

#define HW_PXP_WFE_B_STAGE1_MUX1	(0x00001d60)
#define HW_PXP_WFE_B_STAGE1_MUX1_SET	(0x00001d64)
#define HW_PXP_WFE_B_STAGE1_MUX1_CLR	(0x00001d68)
#define HW_PXP_WFE_B_STAGE1_MUX1_TOG	(0x00001d6c)

#define BP_PXP_WFE_B_STAGE1_MUX1_RSVD0      30
#define BM_PXP_WFE_B_STAGE1_MUX1_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE1_MUX1_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE1_MUX1_RSVD0)
#define BP_PXP_WFE_B_STAGE1_MUX1_MUX7      24
#define BM_PXP_WFE_B_STAGE1_MUX1_MUX7 0x3F000000
#define BF_PXP_WFE_B_STAGE1_MUX1_MUX7(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE1_MUX1_MUX7)
#define BP_PXP_WFE_B_STAGE1_MUX1_RSVD1      22
#define BM_PXP_WFE_B_STAGE1_MUX1_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE1_MUX1_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE1_MUX1_RSVD1)
#define BP_PXP_WFE_B_STAGE1_MUX1_MUX6      16
#define BM_PXP_WFE_B_STAGE1_MUX1_MUX6 0x003F0000
#define BF_PXP_WFE_B_STAGE1_MUX1_MUX6(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE1_MUX1_MUX6)
#define BP_PXP_WFE_B_STAGE1_MUX1_RSVD2      14
#define BM_PXP_WFE_B_STAGE1_MUX1_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE1_MUX1_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE1_MUX1_RSVD2)
#define BP_PXP_WFE_B_STAGE1_MUX1_MUX5      8
#define BM_PXP_WFE_B_STAGE1_MUX1_MUX5 0x00003F00
#define BF_PXP_WFE_B_STAGE1_MUX1_MUX5(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE1_MUX1_MUX5)
#define BP_PXP_WFE_B_STAGE1_MUX1_RSVD3      6
#define BM_PXP_WFE_B_STAGE1_MUX1_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE1_MUX1_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE1_MUX1_RSVD3)
#define BP_PXP_WFE_B_STAGE1_MUX1_MUX4      0
#define BM_PXP_WFE_B_STAGE1_MUX1_MUX4 0x0000003F
#define BF_PXP_WFE_B_STAGE1_MUX1_MUX4(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE1_MUX1_MUX4)

#define HW_PXP_WFE_B_STAGE1_MUX2	(0x00001d70)
#define HW_PXP_WFE_B_STAGE1_MUX2_SET	(0x00001d74)
#define HW_PXP_WFE_B_STAGE1_MUX2_CLR	(0x00001d78)
#define HW_PXP_WFE_B_STAGE1_MUX2_TOG	(0x00001d7c)

#define BP_PXP_WFE_B_STAGE1_MUX2_RSVD0      30
#define BM_PXP_WFE_B_STAGE1_MUX2_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE1_MUX2_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE1_MUX2_RSVD0)
#define BP_PXP_WFE_B_STAGE1_MUX2_MUX11      24
#define BM_PXP_WFE_B_STAGE1_MUX2_MUX11 0x3F000000
#define BF_PXP_WFE_B_STAGE1_MUX2_MUX11(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE1_MUX2_MUX11)
#define BP_PXP_WFE_B_STAGE1_MUX2_RSVD1      22
#define BM_PXP_WFE_B_STAGE1_MUX2_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE1_MUX2_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE1_MUX2_RSVD1)
#define BP_PXP_WFE_B_STAGE1_MUX2_MUX10      16
#define BM_PXP_WFE_B_STAGE1_MUX2_MUX10 0x003F0000
#define BF_PXP_WFE_B_STAGE1_MUX2_MUX10(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE1_MUX2_MUX10)
#define BP_PXP_WFE_B_STAGE1_MUX2_RSVD2      14
#define BM_PXP_WFE_B_STAGE1_MUX2_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE1_MUX2_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE1_MUX2_RSVD2)
#define BP_PXP_WFE_B_STAGE1_MUX2_MUX9      8
#define BM_PXP_WFE_B_STAGE1_MUX2_MUX9 0x00003F00
#define BF_PXP_WFE_B_STAGE1_MUX2_MUX9(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE1_MUX2_MUX9)
#define BP_PXP_WFE_B_STAGE1_MUX2_RSVD3      6
#define BM_PXP_WFE_B_STAGE1_MUX2_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE1_MUX2_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE1_MUX2_RSVD3)
#define BP_PXP_WFE_B_STAGE1_MUX2_MUX8      0
#define BM_PXP_WFE_B_STAGE1_MUX2_MUX8 0x0000003F
#define BF_PXP_WFE_B_STAGE1_MUX2_MUX8(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE1_MUX2_MUX8)

#define HW_PXP_WFE_B_STAGE1_MUX3	(0x00001d80)
#define HW_PXP_WFE_B_STAGE1_MUX3_SET	(0x00001d84)
#define HW_PXP_WFE_B_STAGE1_MUX3_CLR	(0x00001d88)
#define HW_PXP_WFE_B_STAGE1_MUX3_TOG	(0x00001d8c)

#define BP_PXP_WFE_B_STAGE1_MUX3_RSVD0      30
#define BM_PXP_WFE_B_STAGE1_MUX3_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE1_MUX3_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE1_MUX3_RSVD0)
#define BP_PXP_WFE_B_STAGE1_MUX3_MUX15      24
#define BM_PXP_WFE_B_STAGE1_MUX3_MUX15 0x3F000000
#define BF_PXP_WFE_B_STAGE1_MUX3_MUX15(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE1_MUX3_MUX15)
#define BP_PXP_WFE_B_STAGE1_MUX3_RSVD1      22
#define BM_PXP_WFE_B_STAGE1_MUX3_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE1_MUX3_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE1_MUX3_RSVD1)
#define BP_PXP_WFE_B_STAGE1_MUX3_MUX14      16
#define BM_PXP_WFE_B_STAGE1_MUX3_MUX14 0x003F0000
#define BF_PXP_WFE_B_STAGE1_MUX3_MUX14(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE1_MUX3_MUX14)
#define BP_PXP_WFE_B_STAGE1_MUX3_RSVD2      14
#define BM_PXP_WFE_B_STAGE1_MUX3_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE1_MUX3_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE1_MUX3_RSVD2)
#define BP_PXP_WFE_B_STAGE1_MUX3_MUX13      8
#define BM_PXP_WFE_B_STAGE1_MUX3_MUX13 0x00003F00
#define BF_PXP_WFE_B_STAGE1_MUX3_MUX13(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE1_MUX3_MUX13)
#define BP_PXP_WFE_B_STAGE1_MUX3_RSVD3      6
#define BM_PXP_WFE_B_STAGE1_MUX3_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE1_MUX3_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE1_MUX3_RSVD3)
#define BP_PXP_WFE_B_STAGE1_MUX3_MUX12      0
#define BM_PXP_WFE_B_STAGE1_MUX3_MUX12 0x0000003F
#define BF_PXP_WFE_B_STAGE1_MUX3_MUX12(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE1_MUX3_MUX12)

#define HW_PXP_WFE_B_STAGE1_MUX4	(0x00001d90)
#define HW_PXP_WFE_B_STAGE1_MUX4_SET	(0x00001d94)
#define HW_PXP_WFE_B_STAGE1_MUX4_CLR	(0x00001d98)
#define HW_PXP_WFE_B_STAGE1_MUX4_TOG	(0x00001d9c)

#define BP_PXP_WFE_B_STAGE1_MUX4_RSVD0      30
#define BM_PXP_WFE_B_STAGE1_MUX4_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE1_MUX4_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE1_MUX4_RSVD0)
#define BP_PXP_WFE_B_STAGE1_MUX4_MUX19      24
#define BM_PXP_WFE_B_STAGE1_MUX4_MUX19 0x3F000000
#define BF_PXP_WFE_B_STAGE1_MUX4_MUX19(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE1_MUX4_MUX19)
#define BP_PXP_WFE_B_STAGE1_MUX4_RSVD1      22
#define BM_PXP_WFE_B_STAGE1_MUX4_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE1_MUX4_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE1_MUX4_RSVD1)
#define BP_PXP_WFE_B_STAGE1_MUX4_MUX18      16
#define BM_PXP_WFE_B_STAGE1_MUX4_MUX18 0x003F0000
#define BF_PXP_WFE_B_STAGE1_MUX4_MUX18(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE1_MUX4_MUX18)
#define BP_PXP_WFE_B_STAGE1_MUX4_RSVD2      14
#define BM_PXP_WFE_B_STAGE1_MUX4_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE1_MUX4_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE1_MUX4_RSVD2)
#define BP_PXP_WFE_B_STAGE1_MUX4_MUX17      8
#define BM_PXP_WFE_B_STAGE1_MUX4_MUX17 0x00003F00
#define BF_PXP_WFE_B_STAGE1_MUX4_MUX17(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE1_MUX4_MUX17)
#define BP_PXP_WFE_B_STAGE1_MUX4_RSVD3      6
#define BM_PXP_WFE_B_STAGE1_MUX4_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE1_MUX4_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE1_MUX4_RSVD3)
#define BP_PXP_WFE_B_STAGE1_MUX4_MUX16      0
#define BM_PXP_WFE_B_STAGE1_MUX4_MUX16 0x0000003F
#define BF_PXP_WFE_B_STAGE1_MUX4_MUX16(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE1_MUX4_MUX16)

#define HW_PXP_WFE_B_STAGE1_MUX5	(0x00001da0)
#define HW_PXP_WFE_B_STAGE1_MUX5_SET	(0x00001da4)
#define HW_PXP_WFE_B_STAGE1_MUX5_CLR	(0x00001da8)
#define HW_PXP_WFE_B_STAGE1_MUX5_TOG	(0x00001dac)

#define BP_PXP_WFE_B_STAGE1_MUX5_RSVD0      30
#define BM_PXP_WFE_B_STAGE1_MUX5_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE1_MUX5_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE1_MUX5_RSVD0)
#define BP_PXP_WFE_B_STAGE1_MUX5_MUX23      24
#define BM_PXP_WFE_B_STAGE1_MUX5_MUX23 0x3F000000
#define BF_PXP_WFE_B_STAGE1_MUX5_MUX23(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE1_MUX5_MUX23)
#define BP_PXP_WFE_B_STAGE1_MUX5_RSVD1      22
#define BM_PXP_WFE_B_STAGE1_MUX5_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE1_MUX5_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE1_MUX5_RSVD1)
#define BP_PXP_WFE_B_STAGE1_MUX5_MUX22      16
#define BM_PXP_WFE_B_STAGE1_MUX5_MUX22 0x003F0000
#define BF_PXP_WFE_B_STAGE1_MUX5_MUX22(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE1_MUX5_MUX22)
#define BP_PXP_WFE_B_STAGE1_MUX5_RSVD2      14
#define BM_PXP_WFE_B_STAGE1_MUX5_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE1_MUX5_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE1_MUX5_RSVD2)
#define BP_PXP_WFE_B_STAGE1_MUX5_MUX21      8
#define BM_PXP_WFE_B_STAGE1_MUX5_MUX21 0x00003F00
#define BF_PXP_WFE_B_STAGE1_MUX5_MUX21(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE1_MUX5_MUX21)
#define BP_PXP_WFE_B_STAGE1_MUX5_RSVD3      6
#define BM_PXP_WFE_B_STAGE1_MUX5_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE1_MUX5_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE1_MUX5_RSVD3)
#define BP_PXP_WFE_B_STAGE1_MUX5_MUX20      0
#define BM_PXP_WFE_B_STAGE1_MUX5_MUX20 0x0000003F
#define BF_PXP_WFE_B_STAGE1_MUX5_MUX20(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE1_MUX5_MUX20)
#define BV_PXP_WFE_B_STAGE1_MUX5_MUX20__INC        0x0
#define BV_PXP_WFE_B_STAGE1_MUX5_MUX20__DEC        0x1
#define BV_PXP_WFE_B_STAGE1_MUX5_MUX20__ADD        0x2
#define BV_PXP_WFE_B_STAGE1_MUX5_MUX20__MINUS      0x3
#define BV_PXP_WFE_B_STAGE1_MUX5_MUX20__AND        0x4
#define BV_PXP_WFE_B_STAGE1_MUX5_MUX20__OR         0x5
#define BV_PXP_WFE_B_STAGE1_MUX5_MUX20__XOR        0x6
#define BV_PXP_WFE_B_STAGE1_MUX5_MUX20__SHIFTLEFT  0x7
#define BV_PXP_WFE_B_STAGE1_MUX5_MUX20__SHIFTRIGHT 0x8
#define BV_PXP_WFE_B_STAGE1_MUX5_MUX20__BIT_AND    0x9
#define BV_PXP_WFE_B_STAGE1_MUX5_MUX20__BIT_OR     0xa
#define BV_PXP_WFE_B_STAGE1_MUX5_MUX20__BIT_CMP    0xb
#define BV_PXP_WFE_B_STAGE1_MUX5_MUX20__NOP        0xc

#define HW_PXP_WFE_B_STAGE1_MUX6	(0x00001db0)
#define HW_PXP_WFE_B_STAGE1_MUX6_SET	(0x00001db4)
#define HW_PXP_WFE_B_STAGE1_MUX6_CLR	(0x00001db8)
#define HW_PXP_WFE_B_STAGE1_MUX6_TOG	(0x00001dbc)

#define BP_PXP_WFE_B_STAGE1_MUX6_RSVD0      30
#define BM_PXP_WFE_B_STAGE1_MUX6_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE1_MUX6_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE1_MUX6_RSVD0)
#define BP_PXP_WFE_B_STAGE1_MUX6_MUX27      24
#define BM_PXP_WFE_B_STAGE1_MUX6_MUX27 0x3F000000
#define BF_PXP_WFE_B_STAGE1_MUX6_MUX27(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE1_MUX6_MUX27)
#define BP_PXP_WFE_B_STAGE1_MUX6_RSVD1      22
#define BM_PXP_WFE_B_STAGE1_MUX6_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE1_MUX6_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE1_MUX6_RSVD1)
#define BP_PXP_WFE_B_STAGE1_MUX6_MUX26      16
#define BM_PXP_WFE_B_STAGE1_MUX6_MUX26 0x003F0000
#define BF_PXP_WFE_B_STAGE1_MUX6_MUX26(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE1_MUX6_MUX26)
#define BP_PXP_WFE_B_STAGE1_MUX6_RSVD2      14
#define BM_PXP_WFE_B_STAGE1_MUX6_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE1_MUX6_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE1_MUX6_RSVD2)
#define BP_PXP_WFE_B_STAGE1_MUX6_MUX25      8
#define BM_PXP_WFE_B_STAGE1_MUX6_MUX25 0x00003F00
#define BF_PXP_WFE_B_STAGE1_MUX6_MUX25(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE1_MUX6_MUX25)
#define BP_PXP_WFE_B_STAGE1_MUX6_RSVD3      6
#define BM_PXP_WFE_B_STAGE1_MUX6_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE1_MUX6_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE1_MUX6_RSVD3)
#define BP_PXP_WFE_B_STAGE1_MUX6_MUX24      0
#define BM_PXP_WFE_B_STAGE1_MUX6_MUX24 0x0000003F
#define BF_PXP_WFE_B_STAGE1_MUX6_MUX24(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE1_MUX6_MUX24)

#define HW_PXP_WFE_B_STAGE1_MUX7	(0x00001dc0)
#define HW_PXP_WFE_B_STAGE1_MUX7_SET	(0x00001dc4)
#define HW_PXP_WFE_B_STAGE1_MUX7_CLR	(0x00001dc8)
#define HW_PXP_WFE_B_STAGE1_MUX7_TOG	(0x00001dcc)

#define BP_PXP_WFE_B_STAGE1_MUX7_RSVD0      30
#define BM_PXP_WFE_B_STAGE1_MUX7_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE1_MUX7_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE1_MUX7_RSVD0)
#define BP_PXP_WFE_B_STAGE1_MUX7_MUX31      24
#define BM_PXP_WFE_B_STAGE1_MUX7_MUX31 0x3F000000
#define BF_PXP_WFE_B_STAGE1_MUX7_MUX31(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE1_MUX7_MUX31)
#define BP_PXP_WFE_B_STAGE1_MUX7_RSVD1      22
#define BM_PXP_WFE_B_STAGE1_MUX7_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE1_MUX7_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE1_MUX7_RSVD1)
#define BP_PXP_WFE_B_STAGE1_MUX7_MUX30      16
#define BM_PXP_WFE_B_STAGE1_MUX7_MUX30 0x003F0000
#define BF_PXP_WFE_B_STAGE1_MUX7_MUX30(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE1_MUX7_MUX30)
#define BP_PXP_WFE_B_STAGE1_MUX7_RSVD2      14
#define BM_PXP_WFE_B_STAGE1_MUX7_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE1_MUX7_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE1_MUX7_RSVD2)
#define BP_PXP_WFE_B_STAGE1_MUX7_MUX29      8
#define BM_PXP_WFE_B_STAGE1_MUX7_MUX29 0x00003F00
#define BF_PXP_WFE_B_STAGE1_MUX7_MUX29(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE1_MUX7_MUX29)
#define BP_PXP_WFE_B_STAGE1_MUX7_RSVD3      6
#define BM_PXP_WFE_B_STAGE1_MUX7_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE1_MUX7_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE1_MUX7_RSVD3)
#define BP_PXP_WFE_B_STAGE1_MUX7_MUX28      0
#define BM_PXP_WFE_B_STAGE1_MUX7_MUX28 0x0000003F
#define BF_PXP_WFE_B_STAGE1_MUX7_MUX28(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE1_MUX7_MUX28)

#define HW_PXP_WFE_B_STAGE1_MUX8	(0x00001dd0)
#define HW_PXP_WFE_B_STAGE1_MUX8_SET	(0x00001dd4)
#define HW_PXP_WFE_B_STAGE1_MUX8_CLR	(0x00001dd8)
#define HW_PXP_WFE_B_STAGE1_MUX8_TOG	(0x00001ddc)

#define BP_PXP_WFE_B_STAGE1_MUX8_RSVD0      6
#define BM_PXP_WFE_B_STAGE1_MUX8_RSVD0 0xFFFFFFC0
#define BF_PXP_WFE_B_STAGE1_MUX8_RSVD0(v) \
        (((v) << 6) & BM_PXP_WFE_B_STAGE1_MUX8_RSVD0)
#define BP_PXP_WFE_B_STAGE1_MUX8_MUX32      0
#define BM_PXP_WFE_B_STAGE1_MUX8_MUX32 0x0000003F
#define BF_PXP_WFE_B_STAGE1_MUX8_MUX32(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE1_MUX8_MUX32)

#define HW_PXP_WFE_B_STAGE2_MUX0	(0x00001de0)
#define HW_PXP_WFE_B_STAGE2_MUX0_SET	(0x00001de4)
#define HW_PXP_WFE_B_STAGE2_MUX0_CLR	(0x00001de8)
#define HW_PXP_WFE_B_STAGE2_MUX0_TOG	(0x00001dec)

#define BP_PXP_WFE_B_STAGE2_MUX0_RSVD0      30
#define BM_PXP_WFE_B_STAGE2_MUX0_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE2_MUX0_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE2_MUX0_RSVD0)
#define BP_PXP_WFE_B_STAGE2_MUX0_MUX3      24
#define BM_PXP_WFE_B_STAGE2_MUX0_MUX3 0x3F000000
#define BF_PXP_WFE_B_STAGE2_MUX0_MUX3(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE2_MUX0_MUX3)
#define BP_PXP_WFE_B_STAGE2_MUX0_RSVD1      22
#define BM_PXP_WFE_B_STAGE2_MUX0_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE2_MUX0_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE2_MUX0_RSVD1)
#define BP_PXP_WFE_B_STAGE2_MUX0_MUX2      16
#define BM_PXP_WFE_B_STAGE2_MUX0_MUX2 0x003F0000
#define BF_PXP_WFE_B_STAGE2_MUX0_MUX2(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE2_MUX0_MUX2)
#define BP_PXP_WFE_B_STAGE2_MUX0_RSVD2      14
#define BM_PXP_WFE_B_STAGE2_MUX0_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE2_MUX0_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE2_MUX0_RSVD2)
#define BP_PXP_WFE_B_STAGE2_MUX0_MUX1      8
#define BM_PXP_WFE_B_STAGE2_MUX0_MUX1 0x00003F00
#define BF_PXP_WFE_B_STAGE2_MUX0_MUX1(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE2_MUX0_MUX1)
#define BP_PXP_WFE_B_STAGE2_MUX0_RSVD3      6
#define BM_PXP_WFE_B_STAGE2_MUX0_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE2_MUX0_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE2_MUX0_RSVD3)
#define BP_PXP_WFE_B_STAGE2_MUX0_MUX0      0
#define BM_PXP_WFE_B_STAGE2_MUX0_MUX0 0x0000003F
#define BF_PXP_WFE_B_STAGE2_MUX0_MUX0(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE2_MUX0_MUX0)

#define HW_PXP_WFE_B_STAGE2_MUX1	(0x00001df0)
#define HW_PXP_WFE_B_STAGE2_MUX1_SET	(0x00001df4)
#define HW_PXP_WFE_B_STAGE2_MUX1_CLR	(0x00001df8)
#define HW_PXP_WFE_B_STAGE2_MUX1_TOG	(0x00001dfc)

#define BP_PXP_WFE_B_STAGE2_MUX1_RSVD0      30
#define BM_PXP_WFE_B_STAGE2_MUX1_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE2_MUX1_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE2_MUX1_RSVD0)
#define BP_PXP_WFE_B_STAGE2_MUX1_MUX7      24
#define BM_PXP_WFE_B_STAGE2_MUX1_MUX7 0x3F000000
#define BF_PXP_WFE_B_STAGE2_MUX1_MUX7(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE2_MUX1_MUX7)
#define BP_PXP_WFE_B_STAGE2_MUX1_RSVD1      22
#define BM_PXP_WFE_B_STAGE2_MUX1_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE2_MUX1_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE2_MUX1_RSVD1)
#define BP_PXP_WFE_B_STAGE2_MUX1_MUX6      16
#define BM_PXP_WFE_B_STAGE2_MUX1_MUX6 0x003F0000
#define BF_PXP_WFE_B_STAGE2_MUX1_MUX6(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE2_MUX1_MUX6)
#define BP_PXP_WFE_B_STAGE2_MUX1_RSVD2      14
#define BM_PXP_WFE_B_STAGE2_MUX1_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE2_MUX1_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE2_MUX1_RSVD2)
#define BP_PXP_WFE_B_STAGE2_MUX1_MUX5      8
#define BM_PXP_WFE_B_STAGE2_MUX1_MUX5 0x00003F00
#define BF_PXP_WFE_B_STAGE2_MUX1_MUX5(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE2_MUX1_MUX5)
#define BP_PXP_WFE_B_STAGE2_MUX1_RSVD3      6
#define BM_PXP_WFE_B_STAGE2_MUX1_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE2_MUX1_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE2_MUX1_RSVD3)
#define BP_PXP_WFE_B_STAGE2_MUX1_MUX4      0
#define BM_PXP_WFE_B_STAGE2_MUX1_MUX4 0x0000003F
#define BF_PXP_WFE_B_STAGE2_MUX1_MUX4(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE2_MUX1_MUX4)

#define HW_PXP_WFE_B_STAGE2_MUX2	(0x00001e00)
#define HW_PXP_WFE_B_STAGE2_MUX2_SET	(0x00001e04)
#define HW_PXP_WFE_B_STAGE2_MUX2_CLR	(0x00001e08)
#define HW_PXP_WFE_B_STAGE2_MUX2_TOG	(0x00001e0c)

#define BP_PXP_WFE_B_STAGE2_MUX2_RSVD0      30
#define BM_PXP_WFE_B_STAGE2_MUX2_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE2_MUX2_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE2_MUX2_RSVD0)
#define BP_PXP_WFE_B_STAGE2_MUX2_MUX11      24
#define BM_PXP_WFE_B_STAGE2_MUX2_MUX11 0x3F000000
#define BF_PXP_WFE_B_STAGE2_MUX2_MUX11(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE2_MUX2_MUX11)
#define BP_PXP_WFE_B_STAGE2_MUX2_RSVD1      22
#define BM_PXP_WFE_B_STAGE2_MUX2_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE2_MUX2_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE2_MUX2_RSVD1)
#define BP_PXP_WFE_B_STAGE2_MUX2_MUX10      16
#define BM_PXP_WFE_B_STAGE2_MUX2_MUX10 0x003F0000
#define BF_PXP_WFE_B_STAGE2_MUX2_MUX10(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE2_MUX2_MUX10)
#define BP_PXP_WFE_B_STAGE2_MUX2_RSVD2      14
#define BM_PXP_WFE_B_STAGE2_MUX2_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE2_MUX2_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE2_MUX2_RSVD2)
#define BP_PXP_WFE_B_STAGE2_MUX2_MUX9      8
#define BM_PXP_WFE_B_STAGE2_MUX2_MUX9 0x00003F00
#define BF_PXP_WFE_B_STAGE2_MUX2_MUX9(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE2_MUX2_MUX9)
#define BP_PXP_WFE_B_STAGE2_MUX2_RSVD3      6
#define BM_PXP_WFE_B_STAGE2_MUX2_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE2_MUX2_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE2_MUX2_RSVD3)
#define BP_PXP_WFE_B_STAGE2_MUX2_MUX8      0
#define BM_PXP_WFE_B_STAGE2_MUX2_MUX8 0x0000003F
#define BF_PXP_WFE_B_STAGE2_MUX2_MUX8(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE2_MUX2_MUX8)

#define HW_PXP_WFE_B_STAGE2_MUX3	(0x00001e10)
#define HW_PXP_WFE_B_STAGE2_MUX3_SET	(0x00001e14)
#define HW_PXP_WFE_B_STAGE2_MUX3_CLR	(0x00001e18)
#define HW_PXP_WFE_B_STAGE2_MUX3_TOG	(0x00001e1c)

#define BP_PXP_WFE_B_STAGE2_MUX3_RSVD0      30
#define BM_PXP_WFE_B_STAGE2_MUX3_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE2_MUX3_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE2_MUX3_RSVD0)
#define BP_PXP_WFE_B_STAGE2_MUX3_MUX15      24
#define BM_PXP_WFE_B_STAGE2_MUX3_MUX15 0x3F000000
#define BF_PXP_WFE_B_STAGE2_MUX3_MUX15(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE2_MUX3_MUX15)
#define BP_PXP_WFE_B_STAGE2_MUX3_RSVD1      22
#define BM_PXP_WFE_B_STAGE2_MUX3_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE2_MUX3_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE2_MUX3_RSVD1)
#define BP_PXP_WFE_B_STAGE2_MUX3_MUX14      16
#define BM_PXP_WFE_B_STAGE2_MUX3_MUX14 0x003F0000
#define BF_PXP_WFE_B_STAGE2_MUX3_MUX14(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE2_MUX3_MUX14)
#define BP_PXP_WFE_B_STAGE2_MUX3_RSVD2      14
#define BM_PXP_WFE_B_STAGE2_MUX3_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE2_MUX3_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE2_MUX3_RSVD2)
#define BP_PXP_WFE_B_STAGE2_MUX3_MUX13      8
#define BM_PXP_WFE_B_STAGE2_MUX3_MUX13 0x00003F00
#define BF_PXP_WFE_B_STAGE2_MUX3_MUX13(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE2_MUX3_MUX13)
#define BP_PXP_WFE_B_STAGE2_MUX3_RSVD3      6
#define BM_PXP_WFE_B_STAGE2_MUX3_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE2_MUX3_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE2_MUX3_RSVD3)
#define BP_PXP_WFE_B_STAGE2_MUX3_MUX12      0
#define BM_PXP_WFE_B_STAGE2_MUX3_MUX12 0x0000003F
#define BF_PXP_WFE_B_STAGE2_MUX3_MUX12(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE2_MUX3_MUX12)

#define HW_PXP_WFE_B_STAGE2_MUX4	(0x00001e20)
#define HW_PXP_WFE_B_STAGE2_MUX4_SET	(0x00001e24)
#define HW_PXP_WFE_B_STAGE2_MUX4_CLR	(0x00001e28)
#define HW_PXP_WFE_B_STAGE2_MUX4_TOG	(0x00001e2c)

#define BP_PXP_WFE_B_STAGE2_MUX4_RSVD0      30
#define BM_PXP_WFE_B_STAGE2_MUX4_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE2_MUX4_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE2_MUX4_RSVD0)
#define BP_PXP_WFE_B_STAGE2_MUX4_MUX19      24
#define BM_PXP_WFE_B_STAGE2_MUX4_MUX19 0x3F000000
#define BF_PXP_WFE_B_STAGE2_MUX4_MUX19(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE2_MUX4_MUX19)
#define BP_PXP_WFE_B_STAGE2_MUX4_RSVD1      22
#define BM_PXP_WFE_B_STAGE2_MUX4_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE2_MUX4_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE2_MUX4_RSVD1)
#define BP_PXP_WFE_B_STAGE2_MUX4_MUX18      16
#define BM_PXP_WFE_B_STAGE2_MUX4_MUX18 0x003F0000
#define BF_PXP_WFE_B_STAGE2_MUX4_MUX18(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE2_MUX4_MUX18)
#define BP_PXP_WFE_B_STAGE2_MUX4_RSVD2      14
#define BM_PXP_WFE_B_STAGE2_MUX4_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE2_MUX4_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE2_MUX4_RSVD2)
#define BP_PXP_WFE_B_STAGE2_MUX4_MUX17      8
#define BM_PXP_WFE_B_STAGE2_MUX4_MUX17 0x00003F00
#define BF_PXP_WFE_B_STAGE2_MUX4_MUX17(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE2_MUX4_MUX17)
#define BP_PXP_WFE_B_STAGE2_MUX4_RSVD3      6
#define BM_PXP_WFE_B_STAGE2_MUX4_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE2_MUX4_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE2_MUX4_RSVD3)
#define BP_PXP_WFE_B_STAGE2_MUX4_MUX16      0
#define BM_PXP_WFE_B_STAGE2_MUX4_MUX16 0x0000003F
#define BF_PXP_WFE_B_STAGE2_MUX4_MUX16(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE2_MUX4_MUX16)

#define HW_PXP_WFE_B_STAGE2_MUX5	(0x00001e30)
#define HW_PXP_WFE_B_STAGE2_MUX5_SET	(0x00001e34)
#define HW_PXP_WFE_B_STAGE2_MUX5_CLR	(0x00001e38)
#define HW_PXP_WFE_B_STAGE2_MUX5_TOG	(0x00001e3c)

#define BP_PXP_WFE_B_STAGE2_MUX5_RSVD0      30
#define BM_PXP_WFE_B_STAGE2_MUX5_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE2_MUX5_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE2_MUX5_RSVD0)
#define BP_PXP_WFE_B_STAGE2_MUX5_MUX23      24
#define BM_PXP_WFE_B_STAGE2_MUX5_MUX23 0x3F000000
#define BF_PXP_WFE_B_STAGE2_MUX5_MUX23(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE2_MUX5_MUX23)
#define BP_PXP_WFE_B_STAGE2_MUX5_RSVD1      22
#define BM_PXP_WFE_B_STAGE2_MUX5_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE2_MUX5_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE2_MUX5_RSVD1)
#define BP_PXP_WFE_B_STAGE2_MUX5_MUX22      16
#define BM_PXP_WFE_B_STAGE2_MUX5_MUX22 0x003F0000
#define BF_PXP_WFE_B_STAGE2_MUX5_MUX22(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE2_MUX5_MUX22)
#define BP_PXP_WFE_B_STAGE2_MUX5_RSVD2      14
#define BM_PXP_WFE_B_STAGE2_MUX5_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE2_MUX5_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE2_MUX5_RSVD2)
#define BP_PXP_WFE_B_STAGE2_MUX5_MUX21      8
#define BM_PXP_WFE_B_STAGE2_MUX5_MUX21 0x00003F00
#define BF_PXP_WFE_B_STAGE2_MUX5_MUX21(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE2_MUX5_MUX21)
#define BP_PXP_WFE_B_STAGE2_MUX5_RSVD3      6
#define BM_PXP_WFE_B_STAGE2_MUX5_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE2_MUX5_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE2_MUX5_RSVD3)
#define BP_PXP_WFE_B_STAGE2_MUX5_MUX20      0
#define BM_PXP_WFE_B_STAGE2_MUX5_MUX20 0x0000003F
#define BF_PXP_WFE_B_STAGE2_MUX5_MUX20(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE2_MUX5_MUX20)

#define HW_PXP_WFE_B_STAGE2_MUX6	(0x00001e40)
#define HW_PXP_WFE_B_STAGE2_MUX6_SET	(0x00001e44)
#define HW_PXP_WFE_B_STAGE2_MUX6_CLR	(0x00001e48)
#define HW_PXP_WFE_B_STAGE2_MUX6_TOG	(0x00001e4c)

#define BP_PXP_WFE_B_STAGE2_MUX6_RSVD0      30
#define BM_PXP_WFE_B_STAGE2_MUX6_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE2_MUX6_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE2_MUX6_RSVD0)
#define BP_PXP_WFE_B_STAGE2_MUX6_MUX27      24
#define BM_PXP_WFE_B_STAGE2_MUX6_MUX27 0x3F000000
#define BF_PXP_WFE_B_STAGE2_MUX6_MUX27(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE2_MUX6_MUX27)
#define BP_PXP_WFE_B_STAGE2_MUX6_RSVD1      22
#define BM_PXP_WFE_B_STAGE2_MUX6_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE2_MUX6_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE2_MUX6_RSVD1)
#define BP_PXP_WFE_B_STAGE2_MUX6_MUX26      16
#define BM_PXP_WFE_B_STAGE2_MUX6_MUX26 0x003F0000
#define BF_PXP_WFE_B_STAGE2_MUX6_MUX26(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE2_MUX6_MUX26)
#define BP_PXP_WFE_B_STAGE2_MUX6_RSVD2      14
#define BM_PXP_WFE_B_STAGE2_MUX6_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE2_MUX6_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE2_MUX6_RSVD2)
#define BP_PXP_WFE_B_STAGE2_MUX6_MUX25      8
#define BM_PXP_WFE_B_STAGE2_MUX6_MUX25 0x00003F00
#define BF_PXP_WFE_B_STAGE2_MUX6_MUX25(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE2_MUX6_MUX25)
#define BP_PXP_WFE_B_STAGE2_MUX6_RSVD3      6
#define BM_PXP_WFE_B_STAGE2_MUX6_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE2_MUX6_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE2_MUX6_RSVD3)
#define BP_PXP_WFE_B_STAGE2_MUX6_MUX24      0
#define BM_PXP_WFE_B_STAGE2_MUX6_MUX24 0x0000003F
#define BF_PXP_WFE_B_STAGE2_MUX6_MUX24(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE2_MUX6_MUX24)

#define HW_PXP_WFE_B_STAGE2_MUX7	(0x00001e50)
#define HW_PXP_WFE_B_STAGE2_MUX7_SET	(0x00001e54)
#define HW_PXP_WFE_B_STAGE2_MUX7_CLR	(0x00001e58)
#define HW_PXP_WFE_B_STAGE2_MUX7_TOG	(0x00001e5c)

#define BP_PXP_WFE_B_STAGE2_MUX7_RSVD0      30
#define BM_PXP_WFE_B_STAGE2_MUX7_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE2_MUX7_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE2_MUX7_RSVD0)
#define BP_PXP_WFE_B_STAGE2_MUX7_MUX31      24
#define BM_PXP_WFE_B_STAGE2_MUX7_MUX31 0x3F000000
#define BF_PXP_WFE_B_STAGE2_MUX7_MUX31(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE2_MUX7_MUX31)
#define BP_PXP_WFE_B_STAGE2_MUX7_RSVD1      22
#define BM_PXP_WFE_B_STAGE2_MUX7_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE2_MUX7_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE2_MUX7_RSVD1)
#define BP_PXP_WFE_B_STAGE2_MUX7_MUX30      16
#define BM_PXP_WFE_B_STAGE2_MUX7_MUX30 0x003F0000
#define BF_PXP_WFE_B_STAGE2_MUX7_MUX30(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE2_MUX7_MUX30)
#define BP_PXP_WFE_B_STAGE2_MUX7_RSVD2      14
#define BM_PXP_WFE_B_STAGE2_MUX7_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE2_MUX7_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE2_MUX7_RSVD2)
#define BP_PXP_WFE_B_STAGE2_MUX7_MUX29      8
#define BM_PXP_WFE_B_STAGE2_MUX7_MUX29 0x00003F00
#define BF_PXP_WFE_B_STAGE2_MUX7_MUX29(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE2_MUX7_MUX29)
#define BP_PXP_WFE_B_STAGE2_MUX7_RSVD3      6
#define BM_PXP_WFE_B_STAGE2_MUX7_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE2_MUX7_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE2_MUX7_RSVD3)
#define BP_PXP_WFE_B_STAGE2_MUX7_MUX28      0
#define BM_PXP_WFE_B_STAGE2_MUX7_MUX28 0x0000003F
#define BF_PXP_WFE_B_STAGE2_MUX7_MUX28(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE2_MUX7_MUX28)

#define HW_PXP_WFE_B_STAGE2_MUX8	(0x00001e60)
#define HW_PXP_WFE_B_STAGE2_MUX8_SET	(0x00001e64)
#define HW_PXP_WFE_B_STAGE2_MUX8_CLR	(0x00001e68)
#define HW_PXP_WFE_B_STAGE2_MUX8_TOG	(0x00001e6c)

#define BP_PXP_WFE_B_STAGE2_MUX8_RSVD0      30
#define BM_PXP_WFE_B_STAGE2_MUX8_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE2_MUX8_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE2_MUX8_RSVD0)
#define BP_PXP_WFE_B_STAGE2_MUX8_MUX35      24
#define BM_PXP_WFE_B_STAGE2_MUX8_MUX35 0x3F000000
#define BF_PXP_WFE_B_STAGE2_MUX8_MUX35(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE2_MUX8_MUX35)
#define BP_PXP_WFE_B_STAGE2_MUX8_RSVD1      22
#define BM_PXP_WFE_B_STAGE2_MUX8_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE2_MUX8_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE2_MUX8_RSVD1)
#define BP_PXP_WFE_B_STAGE2_MUX8_MUX34      16
#define BM_PXP_WFE_B_STAGE2_MUX8_MUX34 0x003F0000
#define BF_PXP_WFE_B_STAGE2_MUX8_MUX34(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE2_MUX8_MUX34)
#define BP_PXP_WFE_B_STAGE2_MUX8_RSVD2      14
#define BM_PXP_WFE_B_STAGE2_MUX8_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE2_MUX8_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE2_MUX8_RSVD2)
#define BP_PXP_WFE_B_STAGE2_MUX8_MUX33      8
#define BM_PXP_WFE_B_STAGE2_MUX8_MUX33 0x00003F00
#define BF_PXP_WFE_B_STAGE2_MUX8_MUX33(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE2_MUX8_MUX33)
#define BP_PXP_WFE_B_STAGE2_MUX8_RSVD3      6
#define BM_PXP_WFE_B_STAGE2_MUX8_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE2_MUX8_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE2_MUX8_RSVD3)
#define BP_PXP_WFE_B_STAGE2_MUX8_MUX32      0
#define BM_PXP_WFE_B_STAGE2_MUX8_MUX32 0x0000003F
#define BF_PXP_WFE_B_STAGE2_MUX8_MUX32(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE2_MUX8_MUX32)

#define HW_PXP_WFE_B_STAGE2_MUX9	(0x00001e70)
#define HW_PXP_WFE_B_STAGE2_MUX9_SET	(0x00001e74)
#define HW_PXP_WFE_B_STAGE2_MUX9_CLR	(0x00001e78)
#define HW_PXP_WFE_B_STAGE2_MUX9_TOG	(0x00001e7c)

#define BP_PXP_WFE_B_STAGE2_MUX9_RSVD0      30
#define BM_PXP_WFE_B_STAGE2_MUX9_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE2_MUX9_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE2_MUX9_RSVD0)
#define BP_PXP_WFE_B_STAGE2_MUX9_MUX39      24
#define BM_PXP_WFE_B_STAGE2_MUX9_MUX39 0x3F000000
#define BF_PXP_WFE_B_STAGE2_MUX9_MUX39(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE2_MUX9_MUX39)
#define BP_PXP_WFE_B_STAGE2_MUX9_RSVD1      22
#define BM_PXP_WFE_B_STAGE2_MUX9_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE2_MUX9_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE2_MUX9_RSVD1)
#define BP_PXP_WFE_B_STAGE2_MUX9_MUX38      16
#define BM_PXP_WFE_B_STAGE2_MUX9_MUX38 0x003F0000
#define BF_PXP_WFE_B_STAGE2_MUX9_MUX38(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE2_MUX9_MUX38)
#define BP_PXP_WFE_B_STAGE2_MUX9_RSVD2      14
#define BM_PXP_WFE_B_STAGE2_MUX9_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE2_MUX9_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE2_MUX9_RSVD2)
#define BP_PXP_WFE_B_STAGE2_MUX9_MUX37      8
#define BM_PXP_WFE_B_STAGE2_MUX9_MUX37 0x00003F00
#define BF_PXP_WFE_B_STAGE2_MUX9_MUX37(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE2_MUX9_MUX37)
#define BP_PXP_WFE_B_STAGE2_MUX9_RSVD3      6
#define BM_PXP_WFE_B_STAGE2_MUX9_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE2_MUX9_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE2_MUX9_RSVD3)
#define BP_PXP_WFE_B_STAGE2_MUX9_MUX36      0
#define BM_PXP_WFE_B_STAGE2_MUX9_MUX36 0x0000003F
#define BF_PXP_WFE_B_STAGE2_MUX9_MUX36(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE2_MUX9_MUX36)

#define HW_PXP_WFE_B_STAGE2_MUX10	(0x00001e80)
#define HW_PXP_WFE_B_STAGE2_MUX10_SET	(0x00001e84)
#define HW_PXP_WFE_B_STAGE2_MUX10_CLR	(0x00001e88)
#define HW_PXP_WFE_B_STAGE2_MUX10_TOG	(0x00001e8c)

#define BP_PXP_WFE_B_STAGE2_MUX10_RSVD0      30
#define BM_PXP_WFE_B_STAGE2_MUX10_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE2_MUX10_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE2_MUX10_RSVD0)
#define BP_PXP_WFE_B_STAGE2_MUX10_MUX43      24
#define BM_PXP_WFE_B_STAGE2_MUX10_MUX43 0x3F000000
#define BF_PXP_WFE_B_STAGE2_MUX10_MUX43(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE2_MUX10_MUX43)
#define BP_PXP_WFE_B_STAGE2_MUX10_RSVD1      22
#define BM_PXP_WFE_B_STAGE2_MUX10_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE2_MUX10_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE2_MUX10_RSVD1)
#define BP_PXP_WFE_B_STAGE2_MUX10_MUX42      16
#define BM_PXP_WFE_B_STAGE2_MUX10_MUX42 0x003F0000
#define BF_PXP_WFE_B_STAGE2_MUX10_MUX42(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE2_MUX10_MUX42)
#define BP_PXP_WFE_B_STAGE2_MUX10_RSVD2      14
#define BM_PXP_WFE_B_STAGE2_MUX10_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE2_MUX10_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE2_MUX10_RSVD2)
#define BP_PXP_WFE_B_STAGE2_MUX10_MUX41      8
#define BM_PXP_WFE_B_STAGE2_MUX10_MUX41 0x00003F00
#define BF_PXP_WFE_B_STAGE2_MUX10_MUX41(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE2_MUX10_MUX41)
#define BP_PXP_WFE_B_STAGE2_MUX10_RSVD3      6
#define BM_PXP_WFE_B_STAGE2_MUX10_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE2_MUX10_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE2_MUX10_RSVD3)
#define BP_PXP_WFE_B_STAGE2_MUX10_MUX40      0
#define BM_PXP_WFE_B_STAGE2_MUX10_MUX40 0x0000003F
#define BF_PXP_WFE_B_STAGE2_MUX10_MUX40(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE2_MUX10_MUX40)
#define BV_PXP_WFE_B_STAGE2_MUX10_MUX40__INC        0x0
#define BV_PXP_WFE_B_STAGE2_MUX10_MUX40__DEC        0x1
#define BV_PXP_WFE_B_STAGE2_MUX10_MUX40__ADD        0x2
#define BV_PXP_WFE_B_STAGE2_MUX10_MUX40__MINUS      0x3
#define BV_PXP_WFE_B_STAGE2_MUX10_MUX40__AND        0x4
#define BV_PXP_WFE_B_STAGE2_MUX10_MUX40__OR         0x5
#define BV_PXP_WFE_B_STAGE2_MUX10_MUX40__XOR        0x6
#define BV_PXP_WFE_B_STAGE2_MUX10_MUX40__SHIFTLEFT  0x7
#define BV_PXP_WFE_B_STAGE2_MUX10_MUX40__SHIFTRIGHT 0x8
#define BV_PXP_WFE_B_STAGE2_MUX10_MUX40__BIT_AND    0x9
#define BV_PXP_WFE_B_STAGE2_MUX10_MUX40__BIT_OR     0xa
#define BV_PXP_WFE_B_STAGE2_MUX10_MUX40__BIT_CMP    0xb
#define BV_PXP_WFE_B_STAGE2_MUX10_MUX40__NOP        0xc

#define HW_PXP_WFE_B_STAGE2_MUX11	(0x00001e90)
#define HW_PXP_WFE_B_STAGE2_MUX11_SET	(0x00001e94)
#define HW_PXP_WFE_B_STAGE2_MUX11_CLR	(0x00001e98)
#define HW_PXP_WFE_B_STAGE2_MUX11_TOG	(0x00001e9c)

#define BP_PXP_WFE_B_STAGE2_MUX11_RSVD0      30
#define BM_PXP_WFE_B_STAGE2_MUX11_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE2_MUX11_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE2_MUX11_RSVD0)
#define BP_PXP_WFE_B_STAGE2_MUX11_MUX47      24
#define BM_PXP_WFE_B_STAGE2_MUX11_MUX47 0x3F000000
#define BF_PXP_WFE_B_STAGE2_MUX11_MUX47(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE2_MUX11_MUX47)
#define BP_PXP_WFE_B_STAGE2_MUX11_RSVD1      22
#define BM_PXP_WFE_B_STAGE2_MUX11_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE2_MUX11_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE2_MUX11_RSVD1)
#define BP_PXP_WFE_B_STAGE2_MUX11_MUX46      16
#define BM_PXP_WFE_B_STAGE2_MUX11_MUX46 0x003F0000
#define BF_PXP_WFE_B_STAGE2_MUX11_MUX46(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE2_MUX11_MUX46)
#define BP_PXP_WFE_B_STAGE2_MUX11_RSVD2      14
#define BM_PXP_WFE_B_STAGE2_MUX11_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE2_MUX11_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE2_MUX11_RSVD2)
#define BP_PXP_WFE_B_STAGE2_MUX11_MUX45      8
#define BM_PXP_WFE_B_STAGE2_MUX11_MUX45 0x00003F00
#define BF_PXP_WFE_B_STAGE2_MUX11_MUX45(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE2_MUX11_MUX45)
#define BP_PXP_WFE_B_STAGE2_MUX11_RSVD3      6
#define BM_PXP_WFE_B_STAGE2_MUX11_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE2_MUX11_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE2_MUX11_RSVD3)
#define BP_PXP_WFE_B_STAGE2_MUX11_MUX44      0
#define BM_PXP_WFE_B_STAGE2_MUX11_MUX44 0x0000003F
#define BF_PXP_WFE_B_STAGE2_MUX11_MUX44(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE2_MUX11_MUX44)

#define HW_PXP_WFE_B_STAGE2_MUX12	(0x00001ea0)
#define HW_PXP_WFE_B_STAGE2_MUX12_SET	(0x00001ea4)
#define HW_PXP_WFE_B_STAGE2_MUX12_CLR	(0x00001ea8)
#define HW_PXP_WFE_B_STAGE2_MUX12_TOG	(0x00001eac)

#define BP_PXP_WFE_B_STAGE2_MUX12_RSVD0      6
#define BM_PXP_WFE_B_STAGE2_MUX12_RSVD0 0xFFFFFFC0
#define BF_PXP_WFE_B_STAGE2_MUX12_RSVD0(v) \
        (((v) << 6) & BM_PXP_WFE_B_STAGE2_MUX12_RSVD0)
#define BP_PXP_WFE_B_STAGE2_MUX12_MUX48      0
#define BM_PXP_WFE_B_STAGE2_MUX12_MUX48 0x0000003F
#define BF_PXP_WFE_B_STAGE2_MUX12_MUX48(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE2_MUX12_MUX48)

#define HW_PXP_WFE_B_STAGE3_MUX0	(0x00001eb0)
#define HW_PXP_WFE_B_STAGE3_MUX0_SET	(0x00001eb4)
#define HW_PXP_WFE_B_STAGE3_MUX0_CLR	(0x00001eb8)
#define HW_PXP_WFE_B_STAGE3_MUX0_TOG	(0x00001ebc)

#define BP_PXP_WFE_B_STAGE3_MUX0_RSVD0      30
#define BM_PXP_WFE_B_STAGE3_MUX0_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE3_MUX0_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE3_MUX0_RSVD0)
#define BP_PXP_WFE_B_STAGE3_MUX0_MUX3      24
#define BM_PXP_WFE_B_STAGE3_MUX0_MUX3 0x3F000000
#define BF_PXP_WFE_B_STAGE3_MUX0_MUX3(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE3_MUX0_MUX3)
#define BP_PXP_WFE_B_STAGE3_MUX0_RSVD1      22
#define BM_PXP_WFE_B_STAGE3_MUX0_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE3_MUX0_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE3_MUX0_RSVD1)
#define BP_PXP_WFE_B_STAGE3_MUX0_MUX2      16
#define BM_PXP_WFE_B_STAGE3_MUX0_MUX2 0x003F0000
#define BF_PXP_WFE_B_STAGE3_MUX0_MUX2(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE3_MUX0_MUX2)
#define BP_PXP_WFE_B_STAGE3_MUX0_RSVD2      14
#define BM_PXP_WFE_B_STAGE3_MUX0_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE3_MUX0_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE3_MUX0_RSVD2)
#define BP_PXP_WFE_B_STAGE3_MUX0_MUX1      8
#define BM_PXP_WFE_B_STAGE3_MUX0_MUX1 0x00003F00
#define BF_PXP_WFE_B_STAGE3_MUX0_MUX1(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE3_MUX0_MUX1)
#define BP_PXP_WFE_B_STAGE3_MUX0_RSVD3      6
#define BM_PXP_WFE_B_STAGE3_MUX0_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE3_MUX0_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE3_MUX0_RSVD3)
#define BP_PXP_WFE_B_STAGE3_MUX0_MUX0      0
#define BM_PXP_WFE_B_STAGE3_MUX0_MUX0 0x0000003F
#define BF_PXP_WFE_B_STAGE3_MUX0_MUX0(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE3_MUX0_MUX0)

#define HW_PXP_WFE_B_STAGE3_MUX1	(0x00001ec0)
#define HW_PXP_WFE_B_STAGE3_MUX1_SET	(0x00001ec4)
#define HW_PXP_WFE_B_STAGE3_MUX1_CLR	(0x00001ec8)
#define HW_PXP_WFE_B_STAGE3_MUX1_TOG	(0x00001ecc)

#define BP_PXP_WFE_B_STAGE3_MUX1_RSVD0      30
#define BM_PXP_WFE_B_STAGE3_MUX1_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE3_MUX1_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE3_MUX1_RSVD0)
#define BP_PXP_WFE_B_STAGE3_MUX1_MUX7      24
#define BM_PXP_WFE_B_STAGE3_MUX1_MUX7 0x3F000000
#define BF_PXP_WFE_B_STAGE3_MUX1_MUX7(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE3_MUX1_MUX7)
#define BP_PXP_WFE_B_STAGE3_MUX1_RSVD1      22
#define BM_PXP_WFE_B_STAGE3_MUX1_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE3_MUX1_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE3_MUX1_RSVD1)
#define BP_PXP_WFE_B_STAGE3_MUX1_MUX6      16
#define BM_PXP_WFE_B_STAGE3_MUX1_MUX6 0x003F0000
#define BF_PXP_WFE_B_STAGE3_MUX1_MUX6(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE3_MUX1_MUX6)
#define BP_PXP_WFE_B_STAGE3_MUX1_RSVD2      14
#define BM_PXP_WFE_B_STAGE3_MUX1_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE3_MUX1_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE3_MUX1_RSVD2)
#define BP_PXP_WFE_B_STAGE3_MUX1_MUX5      8
#define BM_PXP_WFE_B_STAGE3_MUX1_MUX5 0x00003F00
#define BF_PXP_WFE_B_STAGE3_MUX1_MUX5(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE3_MUX1_MUX5)
#define BP_PXP_WFE_B_STAGE3_MUX1_RSVD3      6
#define BM_PXP_WFE_B_STAGE3_MUX1_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE3_MUX1_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE3_MUX1_RSVD3)
#define BP_PXP_WFE_B_STAGE3_MUX1_MUX4      0
#define BM_PXP_WFE_B_STAGE3_MUX1_MUX4 0x0000003F
#define BF_PXP_WFE_B_STAGE3_MUX1_MUX4(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE3_MUX1_MUX4)

#define HW_PXP_WFE_B_STAGE3_MUX2	(0x00001ed0)
#define HW_PXP_WFE_B_STAGE3_MUX2_SET	(0x00001ed4)
#define HW_PXP_WFE_B_STAGE3_MUX2_CLR	(0x00001ed8)
#define HW_PXP_WFE_B_STAGE3_MUX2_TOG	(0x00001edc)

#define BP_PXP_WFE_B_STAGE3_MUX2_RSVD0      30
#define BM_PXP_WFE_B_STAGE3_MUX2_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE3_MUX2_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE3_MUX2_RSVD0)
#define BP_PXP_WFE_B_STAGE3_MUX2_MUX11      24
#define BM_PXP_WFE_B_STAGE3_MUX2_MUX11 0x3F000000
#define BF_PXP_WFE_B_STAGE3_MUX2_MUX11(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE3_MUX2_MUX11)
#define BP_PXP_WFE_B_STAGE3_MUX2_RSVD1      22
#define BM_PXP_WFE_B_STAGE3_MUX2_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE3_MUX2_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE3_MUX2_RSVD1)
#define BP_PXP_WFE_B_STAGE3_MUX2_MUX10      16
#define BM_PXP_WFE_B_STAGE3_MUX2_MUX10 0x003F0000
#define BF_PXP_WFE_B_STAGE3_MUX2_MUX10(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE3_MUX2_MUX10)
#define BP_PXP_WFE_B_STAGE3_MUX2_RSVD2      14
#define BM_PXP_WFE_B_STAGE3_MUX2_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE3_MUX2_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE3_MUX2_RSVD2)
#define BP_PXP_WFE_B_STAGE3_MUX2_MUX9      8
#define BM_PXP_WFE_B_STAGE3_MUX2_MUX9 0x00003F00
#define BF_PXP_WFE_B_STAGE3_MUX2_MUX9(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE3_MUX2_MUX9)
#define BP_PXP_WFE_B_STAGE3_MUX2_RSVD3      6
#define BM_PXP_WFE_B_STAGE3_MUX2_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE3_MUX2_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE3_MUX2_RSVD3)
#define BP_PXP_WFE_B_STAGE3_MUX2_MUX8      0
#define BM_PXP_WFE_B_STAGE3_MUX2_MUX8 0x0000003F
#define BF_PXP_WFE_B_STAGE3_MUX2_MUX8(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE3_MUX2_MUX8)

#define HW_PXP_WFE_B_STAGE3_MUX3	(0x00001ee0)
#define HW_PXP_WFE_B_STAGE3_MUX3_SET	(0x00001ee4)
#define HW_PXP_WFE_B_STAGE3_MUX3_CLR	(0x00001ee8)
#define HW_PXP_WFE_B_STAGE3_MUX3_TOG	(0x00001eec)

#define BP_PXP_WFE_B_STAGE3_MUX3_RSVD0      30
#define BM_PXP_WFE_B_STAGE3_MUX3_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE3_MUX3_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE3_MUX3_RSVD0)
#define BP_PXP_WFE_B_STAGE3_MUX3_MUX15      24
#define BM_PXP_WFE_B_STAGE3_MUX3_MUX15 0x3F000000
#define BF_PXP_WFE_B_STAGE3_MUX3_MUX15(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE3_MUX3_MUX15)
#define BP_PXP_WFE_B_STAGE3_MUX3_RSVD1      22
#define BM_PXP_WFE_B_STAGE3_MUX3_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE3_MUX3_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE3_MUX3_RSVD1)
#define BP_PXP_WFE_B_STAGE3_MUX3_MUX14      16
#define BM_PXP_WFE_B_STAGE3_MUX3_MUX14 0x003F0000
#define BF_PXP_WFE_B_STAGE3_MUX3_MUX14(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE3_MUX3_MUX14)
#define BP_PXP_WFE_B_STAGE3_MUX3_RSVD2      14
#define BM_PXP_WFE_B_STAGE3_MUX3_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE3_MUX3_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE3_MUX3_RSVD2)
#define BP_PXP_WFE_B_STAGE3_MUX3_MUX13      8
#define BM_PXP_WFE_B_STAGE3_MUX3_MUX13 0x00003F00
#define BF_PXP_WFE_B_STAGE3_MUX3_MUX13(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE3_MUX3_MUX13)
#define BP_PXP_WFE_B_STAGE3_MUX3_RSVD3      6
#define BM_PXP_WFE_B_STAGE3_MUX3_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE3_MUX3_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE3_MUX3_RSVD3)
#define BP_PXP_WFE_B_STAGE3_MUX3_MUX12      0
#define BM_PXP_WFE_B_STAGE3_MUX3_MUX12 0x0000003F
#define BF_PXP_WFE_B_STAGE3_MUX3_MUX12(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE3_MUX3_MUX12)

#define HW_PXP_WFE_B_STAGE3_MUX4	(0x00001ef0)
#define HW_PXP_WFE_B_STAGE3_MUX4_SET	(0x00001ef4)
#define HW_PXP_WFE_B_STAGE3_MUX4_CLR	(0x00001ef8)
#define HW_PXP_WFE_B_STAGE3_MUX4_TOG	(0x00001efc)

#define BP_PXP_WFE_B_STAGE3_MUX4_RSVD0      30
#define BM_PXP_WFE_B_STAGE3_MUX4_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE3_MUX4_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE3_MUX4_RSVD0)
#define BP_PXP_WFE_B_STAGE3_MUX4_MUX19      24
#define BM_PXP_WFE_B_STAGE3_MUX4_MUX19 0x3F000000
#define BF_PXP_WFE_B_STAGE3_MUX4_MUX19(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE3_MUX4_MUX19)
#define BP_PXP_WFE_B_STAGE3_MUX4_RSVD1      22
#define BM_PXP_WFE_B_STAGE3_MUX4_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE3_MUX4_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE3_MUX4_RSVD1)
#define BP_PXP_WFE_B_STAGE3_MUX4_MUX18      16
#define BM_PXP_WFE_B_STAGE3_MUX4_MUX18 0x003F0000
#define BF_PXP_WFE_B_STAGE3_MUX4_MUX18(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE3_MUX4_MUX18)
#define BP_PXP_WFE_B_STAGE3_MUX4_RSVD2      14
#define BM_PXP_WFE_B_STAGE3_MUX4_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE3_MUX4_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE3_MUX4_RSVD2)
#define BP_PXP_WFE_B_STAGE3_MUX4_MUX17      8
#define BM_PXP_WFE_B_STAGE3_MUX4_MUX17 0x00003F00
#define BF_PXP_WFE_B_STAGE3_MUX4_MUX17(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE3_MUX4_MUX17)
#define BP_PXP_WFE_B_STAGE3_MUX4_RSVD3      6
#define BM_PXP_WFE_B_STAGE3_MUX4_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE3_MUX4_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE3_MUX4_RSVD3)
#define BP_PXP_WFE_B_STAGE3_MUX4_MUX16      0
#define BM_PXP_WFE_B_STAGE3_MUX4_MUX16 0x0000003F
#define BF_PXP_WFE_B_STAGE3_MUX4_MUX16(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE3_MUX4_MUX16)

#define HW_PXP_WFE_B_STAGE3_MUX5	(0x00001f00)
#define HW_PXP_WFE_B_STAGE3_MUX5_SET	(0x00001f04)
#define HW_PXP_WFE_B_STAGE3_MUX5_CLR	(0x00001f08)
#define HW_PXP_WFE_B_STAGE3_MUX5_TOG	(0x00001f0c)

#define BP_PXP_WFE_B_STAGE3_MUX5_RSVD0      30
#define BM_PXP_WFE_B_STAGE3_MUX5_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE3_MUX5_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE3_MUX5_RSVD0)
#define BP_PXP_WFE_B_STAGE3_MUX5_MUX23      24
#define BM_PXP_WFE_B_STAGE3_MUX5_MUX23 0x3F000000
#define BF_PXP_WFE_B_STAGE3_MUX5_MUX23(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE3_MUX5_MUX23)
#define BP_PXP_WFE_B_STAGE3_MUX5_RSVD1      22
#define BM_PXP_WFE_B_STAGE3_MUX5_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE3_MUX5_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE3_MUX5_RSVD1)
#define BP_PXP_WFE_B_STAGE3_MUX5_MUX22      16
#define BM_PXP_WFE_B_STAGE3_MUX5_MUX22 0x003F0000
#define BF_PXP_WFE_B_STAGE3_MUX5_MUX22(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE3_MUX5_MUX22)
#define BP_PXP_WFE_B_STAGE3_MUX5_RSVD2      14
#define BM_PXP_WFE_B_STAGE3_MUX5_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE3_MUX5_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE3_MUX5_RSVD2)
#define BP_PXP_WFE_B_STAGE3_MUX5_MUX21      8
#define BM_PXP_WFE_B_STAGE3_MUX5_MUX21 0x00003F00
#define BF_PXP_WFE_B_STAGE3_MUX5_MUX21(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE3_MUX5_MUX21)
#define BP_PXP_WFE_B_STAGE3_MUX5_RSVD3      6
#define BM_PXP_WFE_B_STAGE3_MUX5_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE3_MUX5_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE3_MUX5_RSVD3)
#define BP_PXP_WFE_B_STAGE3_MUX5_MUX20      0
#define BM_PXP_WFE_B_STAGE3_MUX5_MUX20 0x0000003F
#define BF_PXP_WFE_B_STAGE3_MUX5_MUX20(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE3_MUX5_MUX20)

#define HW_PXP_WFE_B_STAGE3_MUX6	(0x00001f10)
#define HW_PXP_WFE_B_STAGE3_MUX6_SET	(0x00001f14)
#define HW_PXP_WFE_B_STAGE3_MUX6_CLR	(0x00001f18)
#define HW_PXP_WFE_B_STAGE3_MUX6_TOG	(0x00001f1c)

#define BP_PXP_WFE_B_STAGE3_MUX6_RSVD0      30
#define BM_PXP_WFE_B_STAGE3_MUX6_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE3_MUX6_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE3_MUX6_RSVD0)
#define BP_PXP_WFE_B_STAGE3_MUX6_MUX27      24
#define BM_PXP_WFE_B_STAGE3_MUX6_MUX27 0x3F000000
#define BF_PXP_WFE_B_STAGE3_MUX6_MUX27(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE3_MUX6_MUX27)
#define BP_PXP_WFE_B_STAGE3_MUX6_RSVD1      22
#define BM_PXP_WFE_B_STAGE3_MUX6_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE3_MUX6_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE3_MUX6_RSVD1)
#define BP_PXP_WFE_B_STAGE3_MUX6_MUX26      16
#define BM_PXP_WFE_B_STAGE3_MUX6_MUX26 0x003F0000
#define BF_PXP_WFE_B_STAGE3_MUX6_MUX26(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE3_MUX6_MUX26)
#define BP_PXP_WFE_B_STAGE3_MUX6_RSVD2      14
#define BM_PXP_WFE_B_STAGE3_MUX6_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE3_MUX6_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE3_MUX6_RSVD2)
#define BP_PXP_WFE_B_STAGE3_MUX6_MUX25      8
#define BM_PXP_WFE_B_STAGE3_MUX6_MUX25 0x00003F00
#define BF_PXP_WFE_B_STAGE3_MUX6_MUX25(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE3_MUX6_MUX25)
#define BP_PXP_WFE_B_STAGE3_MUX6_RSVD3      6
#define BM_PXP_WFE_B_STAGE3_MUX6_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE3_MUX6_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE3_MUX6_RSVD3)
#define BP_PXP_WFE_B_STAGE3_MUX6_MUX24      0
#define BM_PXP_WFE_B_STAGE3_MUX6_MUX24 0x0000003F
#define BF_PXP_WFE_B_STAGE3_MUX6_MUX24(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE3_MUX6_MUX24)

#define HW_PXP_WFE_B_STAGE3_MUX7	(0x00001f20)
#define HW_PXP_WFE_B_STAGE3_MUX7_SET	(0x00001f24)
#define HW_PXP_WFE_B_STAGE3_MUX7_CLR	(0x00001f28)
#define HW_PXP_WFE_B_STAGE3_MUX7_TOG	(0x00001f2c)

#define BP_PXP_WFE_B_STAGE3_MUX7_RSVD0      30
#define BM_PXP_WFE_B_STAGE3_MUX7_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE3_MUX7_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE3_MUX7_RSVD0)
#define BP_PXP_WFE_B_STAGE3_MUX7_MUX31      24
#define BM_PXP_WFE_B_STAGE3_MUX7_MUX31 0x3F000000
#define BF_PXP_WFE_B_STAGE3_MUX7_MUX31(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE3_MUX7_MUX31)
#define BP_PXP_WFE_B_STAGE3_MUX7_RSVD1      22
#define BM_PXP_WFE_B_STAGE3_MUX7_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE3_MUX7_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE3_MUX7_RSVD1)
#define BP_PXP_WFE_B_STAGE3_MUX7_MUX30      16
#define BM_PXP_WFE_B_STAGE3_MUX7_MUX30 0x003F0000
#define BF_PXP_WFE_B_STAGE3_MUX7_MUX30(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE3_MUX7_MUX30)
#define BP_PXP_WFE_B_STAGE3_MUX7_RSVD2      14
#define BM_PXP_WFE_B_STAGE3_MUX7_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE3_MUX7_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE3_MUX7_RSVD2)
#define BP_PXP_WFE_B_STAGE3_MUX7_MUX29      8
#define BM_PXP_WFE_B_STAGE3_MUX7_MUX29 0x00003F00
#define BF_PXP_WFE_B_STAGE3_MUX7_MUX29(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE3_MUX7_MUX29)
#define BP_PXP_WFE_B_STAGE3_MUX7_RSVD3      6
#define BM_PXP_WFE_B_STAGE3_MUX7_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE3_MUX7_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE3_MUX7_RSVD3)
#define BP_PXP_WFE_B_STAGE3_MUX7_MUX28      0
#define BM_PXP_WFE_B_STAGE3_MUX7_MUX28 0x0000003F
#define BF_PXP_WFE_B_STAGE3_MUX7_MUX28(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE3_MUX7_MUX28)

#define HW_PXP_WFE_B_STAGE3_MUX8	(0x00001f30)
#define HW_PXP_WFE_B_STAGE3_MUX8_SET	(0x00001f34)
#define HW_PXP_WFE_B_STAGE3_MUX8_CLR	(0x00001f38)
#define HW_PXP_WFE_B_STAGE3_MUX8_TOG	(0x00001f3c)

#define BP_PXP_WFE_B_STAGE3_MUX8_RSVD0      30
#define BM_PXP_WFE_B_STAGE3_MUX8_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE3_MUX8_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE3_MUX8_RSVD0)
#define BP_PXP_WFE_B_STAGE3_MUX8_MUX35      24
#define BM_PXP_WFE_B_STAGE3_MUX8_MUX35 0x3F000000
#define BF_PXP_WFE_B_STAGE3_MUX8_MUX35(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE3_MUX8_MUX35)
#define BP_PXP_WFE_B_STAGE3_MUX8_RSVD1      22
#define BM_PXP_WFE_B_STAGE3_MUX8_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE3_MUX8_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE3_MUX8_RSVD1)
#define BP_PXP_WFE_B_STAGE3_MUX8_MUX34      16
#define BM_PXP_WFE_B_STAGE3_MUX8_MUX34 0x003F0000
#define BF_PXP_WFE_B_STAGE3_MUX8_MUX34(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE3_MUX8_MUX34)
#define BP_PXP_WFE_B_STAGE3_MUX8_RSVD2      14
#define BM_PXP_WFE_B_STAGE3_MUX8_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE3_MUX8_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE3_MUX8_RSVD2)
#define BP_PXP_WFE_B_STAGE3_MUX8_MUX33      8
#define BM_PXP_WFE_B_STAGE3_MUX8_MUX33 0x00003F00
#define BF_PXP_WFE_B_STAGE3_MUX8_MUX33(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE3_MUX8_MUX33)
#define BP_PXP_WFE_B_STAGE3_MUX8_RSVD3      6
#define BM_PXP_WFE_B_STAGE3_MUX8_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE3_MUX8_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE3_MUX8_RSVD3)
#define BP_PXP_WFE_B_STAGE3_MUX8_MUX32      0
#define BM_PXP_WFE_B_STAGE3_MUX8_MUX32 0x0000003F
#define BF_PXP_WFE_B_STAGE3_MUX8_MUX32(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE3_MUX8_MUX32)

#define HW_PXP_WFE_B_STAGE3_MUX9	(0x00001f40)
#define HW_PXP_WFE_B_STAGE3_MUX9_SET	(0x00001f44)
#define HW_PXP_WFE_B_STAGE3_MUX9_CLR	(0x00001f48)
#define HW_PXP_WFE_B_STAGE3_MUX9_TOG	(0x00001f4c)

#define BP_PXP_WFE_B_STAGE3_MUX9_RSVD0      30
#define BM_PXP_WFE_B_STAGE3_MUX9_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE3_MUX9_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE3_MUX9_RSVD0)
#define BP_PXP_WFE_B_STAGE3_MUX9_MUX39      24
#define BM_PXP_WFE_B_STAGE3_MUX9_MUX39 0x3F000000
#define BF_PXP_WFE_B_STAGE3_MUX9_MUX39(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE3_MUX9_MUX39)
#define BP_PXP_WFE_B_STAGE3_MUX9_RSVD1      22
#define BM_PXP_WFE_B_STAGE3_MUX9_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE3_MUX9_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE3_MUX9_RSVD1)
#define BP_PXP_WFE_B_STAGE3_MUX9_MUX38      16
#define BM_PXP_WFE_B_STAGE3_MUX9_MUX38 0x003F0000
#define BF_PXP_WFE_B_STAGE3_MUX9_MUX38(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE3_MUX9_MUX38)
#define BP_PXP_WFE_B_STAGE3_MUX9_RSVD2      14
#define BM_PXP_WFE_B_STAGE3_MUX9_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE3_MUX9_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE3_MUX9_RSVD2)
#define BP_PXP_WFE_B_STAGE3_MUX9_MUX37      8
#define BM_PXP_WFE_B_STAGE3_MUX9_MUX37 0x00003F00
#define BF_PXP_WFE_B_STAGE3_MUX9_MUX37(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE3_MUX9_MUX37)
#define BP_PXP_WFE_B_STAGE3_MUX9_RSVD3      6
#define BM_PXP_WFE_B_STAGE3_MUX9_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE3_MUX9_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE3_MUX9_RSVD3)
#define BP_PXP_WFE_B_STAGE3_MUX9_MUX36      0
#define BM_PXP_WFE_B_STAGE3_MUX9_MUX36 0x0000003F
#define BF_PXP_WFE_B_STAGE3_MUX9_MUX36(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE3_MUX9_MUX36)

#define HW_PXP_WFE_B_STAGE3_MUX10	(0x00001f50)
#define HW_PXP_WFE_B_STAGE3_MUX10_SET	(0x00001f54)
#define HW_PXP_WFE_B_STAGE3_MUX10_CLR	(0x00001f58)
#define HW_PXP_WFE_B_STAGE3_MUX10_TOG	(0x00001f5c)

#define BP_PXP_WFE_B_STAGE3_MUX10_RSVD0      30
#define BM_PXP_WFE_B_STAGE3_MUX10_RSVD0 0xC0000000
#define BF_PXP_WFE_B_STAGE3_MUX10_RSVD0(v) \
        (((v) << 30) & BM_PXP_WFE_B_STAGE3_MUX10_RSVD0)
#define BP_PXP_WFE_B_STAGE3_MUX10_MUX43      24
#define BM_PXP_WFE_B_STAGE3_MUX10_MUX43 0x3F000000
#define BF_PXP_WFE_B_STAGE3_MUX10_MUX43(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STAGE3_MUX10_MUX43)
#define BP_PXP_WFE_B_STAGE3_MUX10_RSVD1      22
#define BM_PXP_WFE_B_STAGE3_MUX10_RSVD1 0x00C00000
#define BF_PXP_WFE_B_STAGE3_MUX10_RSVD1(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STAGE3_MUX10_RSVD1)
#define BP_PXP_WFE_B_STAGE3_MUX10_MUX42      16
#define BM_PXP_WFE_B_STAGE3_MUX10_MUX42 0x003F0000
#define BF_PXP_WFE_B_STAGE3_MUX10_MUX42(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STAGE3_MUX10_MUX42)
#define BP_PXP_WFE_B_STAGE3_MUX10_RSVD2      14
#define BM_PXP_WFE_B_STAGE3_MUX10_RSVD2 0x0000C000
#define BF_PXP_WFE_B_STAGE3_MUX10_RSVD2(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STAGE3_MUX10_RSVD2)
#define BP_PXP_WFE_B_STAGE3_MUX10_MUX41      8
#define BM_PXP_WFE_B_STAGE3_MUX10_MUX41 0x00003F00
#define BF_PXP_WFE_B_STAGE3_MUX10_MUX41(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE3_MUX10_MUX41)
#define BP_PXP_WFE_B_STAGE3_MUX10_RSVD3      6
#define BM_PXP_WFE_B_STAGE3_MUX10_RSVD3 0x000000C0
#define BF_PXP_WFE_B_STAGE3_MUX10_RSVD3(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STAGE3_MUX10_RSVD3)
#define BP_PXP_WFE_B_STAGE3_MUX10_MUX40      0
#define BM_PXP_WFE_B_STAGE3_MUX10_MUX40 0x0000003F
#define BF_PXP_WFE_B_STAGE3_MUX10_MUX40(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE3_MUX10_MUX40)

#define HW_PXP_WFE_B_STG1_5X8_OUT0_0	(0x00001f60)

#define BP_PXP_WFE_B_STG1_5X8_OUT0_0_LUTOUT3      24
#define BM_PXP_WFE_B_STG1_5X8_OUT0_0_LUTOUT3 0xFF000000
#define BF_PXP_WFE_B_STG1_5X8_OUT0_0_LUTOUT3(v) \
        (((v) << 24) & BM_PXP_WFE_B_STG1_5X8_OUT0_0_LUTOUT3)
#define BP_PXP_WFE_B_STG1_5X8_OUT0_0_LUTOUT2      16
#define BM_PXP_WFE_B_STG1_5X8_OUT0_0_LUTOUT2 0x00FF0000
#define BF_PXP_WFE_B_STG1_5X8_OUT0_0_LUTOUT2(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_5X8_OUT0_0_LUTOUT2)
#define BP_PXP_WFE_B_STG1_5X8_OUT0_0_LUTOUT1      8
#define BM_PXP_WFE_B_STG1_5X8_OUT0_0_LUTOUT1 0x0000FF00
#define BF_PXP_WFE_B_STG1_5X8_OUT0_0_LUTOUT1(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_5X8_OUT0_0_LUTOUT1)
#define BP_PXP_WFE_B_STG1_5X8_OUT0_0_LUTOUT0      0
#define BM_PXP_WFE_B_STG1_5X8_OUT0_0_LUTOUT0 0x000000FF
#define BF_PXP_WFE_B_STG1_5X8_OUT0_0_LUTOUT0(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_5X8_OUT0_0_LUTOUT0)

#define HW_PXP_WFE_B_STG1_5X8_OUT0_1	(0x00001f70)

#define BP_PXP_WFE_B_STG1_5X8_OUT0_1_LUTOUT7      24
#define BM_PXP_WFE_B_STG1_5X8_OUT0_1_LUTOUT7 0xFF000000
#define BF_PXP_WFE_B_STG1_5X8_OUT0_1_LUTOUT7(v) \
        (((v) << 24) & BM_PXP_WFE_B_STG1_5X8_OUT0_1_LUTOUT7)
#define BP_PXP_WFE_B_STG1_5X8_OUT0_1_LUTOUT6      16
#define BM_PXP_WFE_B_STG1_5X8_OUT0_1_LUTOUT6 0x00FF0000
#define BF_PXP_WFE_B_STG1_5X8_OUT0_1_LUTOUT6(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_5X8_OUT0_1_LUTOUT6)
#define BP_PXP_WFE_B_STG1_5X8_OUT0_1_LUTOUT5      8
#define BM_PXP_WFE_B_STG1_5X8_OUT0_1_LUTOUT5 0x0000FF00
#define BF_PXP_WFE_B_STG1_5X8_OUT0_1_LUTOUT5(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_5X8_OUT0_1_LUTOUT5)
#define BP_PXP_WFE_B_STG1_5X8_OUT0_1_LUTOUT4      0
#define BM_PXP_WFE_B_STG1_5X8_OUT0_1_LUTOUT4 0x000000FF
#define BF_PXP_WFE_B_STG1_5X8_OUT0_1_LUTOUT4(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_5X8_OUT0_1_LUTOUT4)

#define HW_PXP_WFE_B_STG1_5X8_OUT0_2	(0x00001f80)

#define BP_PXP_WFE_B_STG1_5X8_OUT0_2_LUTOUT11      24
#define BM_PXP_WFE_B_STG1_5X8_OUT0_2_LUTOUT11 0xFF000000
#define BF_PXP_WFE_B_STG1_5X8_OUT0_2_LUTOUT11(v) \
        (((v) << 24) & BM_PXP_WFE_B_STG1_5X8_OUT0_2_LUTOUT11)
#define BP_PXP_WFE_B_STG1_5X8_OUT0_2_LUTOUT10      16
#define BM_PXP_WFE_B_STG1_5X8_OUT0_2_LUTOUT10 0x00FF0000
#define BF_PXP_WFE_B_STG1_5X8_OUT0_2_LUTOUT10(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_5X8_OUT0_2_LUTOUT10)
#define BP_PXP_WFE_B_STG1_5X8_OUT0_2_LUTOUT9      8
#define BM_PXP_WFE_B_STG1_5X8_OUT0_2_LUTOUT9 0x0000FF00
#define BF_PXP_WFE_B_STG1_5X8_OUT0_2_LUTOUT9(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_5X8_OUT0_2_LUTOUT9)
#define BP_PXP_WFE_B_STG1_5X8_OUT0_2_LUTOUT8      0
#define BM_PXP_WFE_B_STG1_5X8_OUT0_2_LUTOUT8 0x000000FF
#define BF_PXP_WFE_B_STG1_5X8_OUT0_2_LUTOUT8(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_5X8_OUT0_2_LUTOUT8)

#define HW_PXP_WFE_B_STG1_5X8_OUT0_3	(0x00001f90)

#define BP_PXP_WFE_B_STG1_5X8_OUT0_3_LUTOUT15      24
#define BM_PXP_WFE_B_STG1_5X8_OUT0_3_LUTOUT15 0xFF000000
#define BF_PXP_WFE_B_STG1_5X8_OUT0_3_LUTOUT15(v) \
        (((v) << 24) & BM_PXP_WFE_B_STG1_5X8_OUT0_3_LUTOUT15)
#define BP_PXP_WFE_B_STG1_5X8_OUT0_3_LUTOUT14      16
#define BM_PXP_WFE_B_STG1_5X8_OUT0_3_LUTOUT14 0x00FF0000
#define BF_PXP_WFE_B_STG1_5X8_OUT0_3_LUTOUT14(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_5X8_OUT0_3_LUTOUT14)
#define BP_PXP_WFE_B_STG1_5X8_OUT0_3_LUTOUT13      8
#define BM_PXP_WFE_B_STG1_5X8_OUT0_3_LUTOUT13 0x0000FF00
#define BF_PXP_WFE_B_STG1_5X8_OUT0_3_LUTOUT13(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_5X8_OUT0_3_LUTOUT13)
#define BP_PXP_WFE_B_STG1_5X8_OUT0_3_LUTOUT12      0
#define BM_PXP_WFE_B_STG1_5X8_OUT0_3_LUTOUT12 0x000000FF
#define BF_PXP_WFE_B_STG1_5X8_OUT0_3_LUTOUT12(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_5X8_OUT0_3_LUTOUT12)

#define HW_PXP_WFE_B_STG1_5X8_OUT0_4	(0x00001fa0)

#define BP_PXP_WFE_B_STG1_5X8_OUT0_4_LUTOUT19      24
#define BM_PXP_WFE_B_STG1_5X8_OUT0_4_LUTOUT19 0xFF000000
#define BF_PXP_WFE_B_STG1_5X8_OUT0_4_LUTOUT19(v) \
        (((v) << 24) & BM_PXP_WFE_B_STG1_5X8_OUT0_4_LUTOUT19)
#define BP_PXP_WFE_B_STG1_5X8_OUT0_4_LUTOUT18      16
#define BM_PXP_WFE_B_STG1_5X8_OUT0_4_LUTOUT18 0x00FF0000
#define BF_PXP_WFE_B_STG1_5X8_OUT0_4_LUTOUT18(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_5X8_OUT0_4_LUTOUT18)
#define BP_PXP_WFE_B_STG1_5X8_OUT0_4_LUTOUT17      8
#define BM_PXP_WFE_B_STG1_5X8_OUT0_4_LUTOUT17 0x0000FF00
#define BF_PXP_WFE_B_STG1_5X8_OUT0_4_LUTOUT17(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_5X8_OUT0_4_LUTOUT17)
#define BP_PXP_WFE_B_STG1_5X8_OUT0_4_LUTOUT16      0
#define BM_PXP_WFE_B_STG1_5X8_OUT0_4_LUTOUT16 0x000000FF
#define BF_PXP_WFE_B_STG1_5X8_OUT0_4_LUTOUT16(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_5X8_OUT0_4_LUTOUT16)

#define HW_PXP_WFE_B_STG1_5X8_OUT0_5	(0x00001fb0)

#define BP_PXP_WFE_B_STG1_5X8_OUT0_5_LUTOUT23      24
#define BM_PXP_WFE_B_STG1_5X8_OUT0_5_LUTOUT23 0xFF000000
#define BF_PXP_WFE_B_STG1_5X8_OUT0_5_LUTOUT23(v) \
        (((v) << 24) & BM_PXP_WFE_B_STG1_5X8_OUT0_5_LUTOUT23)
#define BP_PXP_WFE_B_STG1_5X8_OUT0_5_LUTOUT22      16
#define BM_PXP_WFE_B_STG1_5X8_OUT0_5_LUTOUT22 0x00FF0000
#define BF_PXP_WFE_B_STG1_5X8_OUT0_5_LUTOUT22(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_5X8_OUT0_5_LUTOUT22)
#define BP_PXP_WFE_B_STG1_5X8_OUT0_5_LUTOUT21      8
#define BM_PXP_WFE_B_STG1_5X8_OUT0_5_LUTOUT21 0x0000FF00
#define BF_PXP_WFE_B_STG1_5X8_OUT0_5_LUTOUT21(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_5X8_OUT0_5_LUTOUT21)
#define BP_PXP_WFE_B_STG1_5X8_OUT0_5_LUTOUT20      0
#define BM_PXP_WFE_B_STG1_5X8_OUT0_5_LUTOUT20 0x000000FF
#define BF_PXP_WFE_B_STG1_5X8_OUT0_5_LUTOUT20(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_5X8_OUT0_5_LUTOUT20)

#define HW_PXP_WFE_B_STG1_5X8_OUT0_6	(0x00001fc0)

#define BP_PXP_WFE_B_STG1_5X8_OUT0_6_LUTOUT27      24
#define BM_PXP_WFE_B_STG1_5X8_OUT0_6_LUTOUT27 0xFF000000
#define BF_PXP_WFE_B_STG1_5X8_OUT0_6_LUTOUT27(v) \
        (((v) << 24) & BM_PXP_WFE_B_STG1_5X8_OUT0_6_LUTOUT27)
#define BP_PXP_WFE_B_STG1_5X8_OUT0_6_LUTOUT26      16
#define BM_PXP_WFE_B_STG1_5X8_OUT0_6_LUTOUT26 0x00FF0000
#define BF_PXP_WFE_B_STG1_5X8_OUT0_6_LUTOUT26(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_5X8_OUT0_6_LUTOUT26)
#define BP_PXP_WFE_B_STG1_5X8_OUT0_6_LUTOUT25      8
#define BM_PXP_WFE_B_STG1_5X8_OUT0_6_LUTOUT25 0x0000FF00
#define BF_PXP_WFE_B_STG1_5X8_OUT0_6_LUTOUT25(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_5X8_OUT0_6_LUTOUT25)
#define BP_PXP_WFE_B_STG1_5X8_OUT0_6_LUTOUT24      0
#define BM_PXP_WFE_B_STG1_5X8_OUT0_6_LUTOUT24 0x000000FF
#define BF_PXP_WFE_B_STG1_5X8_OUT0_6_LUTOUT24(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_5X8_OUT0_6_LUTOUT24)

#define HW_PXP_WFE_B_STG1_5X8_OUT0_7	(0x00001fd0)

#define BP_PXP_WFE_B_STG1_5X8_OUT0_7_LUTOUT31      24
#define BM_PXP_WFE_B_STG1_5X8_OUT0_7_LUTOUT31 0xFF000000
#define BF_PXP_WFE_B_STG1_5X8_OUT0_7_LUTOUT31(v) \
        (((v) << 24) & BM_PXP_WFE_B_STG1_5X8_OUT0_7_LUTOUT31)
#define BP_PXP_WFE_B_STG1_5X8_OUT0_7_LUTOUT30      16
#define BM_PXP_WFE_B_STG1_5X8_OUT0_7_LUTOUT30 0x00FF0000
#define BF_PXP_WFE_B_STG1_5X8_OUT0_7_LUTOUT30(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_5X8_OUT0_7_LUTOUT30)
#define BP_PXP_WFE_B_STG1_5X8_OUT0_7_LUTOUT29      8
#define BM_PXP_WFE_B_STG1_5X8_OUT0_7_LUTOUT29 0x0000FF00
#define BF_PXP_WFE_B_STG1_5X8_OUT0_7_LUTOUT29(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_5X8_OUT0_7_LUTOUT29)
#define BP_PXP_WFE_B_STG1_5X8_OUT0_7_LUTOUT28      0
#define BM_PXP_WFE_B_STG1_5X8_OUT0_7_LUTOUT28 0x000000FF
#define BF_PXP_WFE_B_STG1_5X8_OUT0_7_LUTOUT28(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_5X8_OUT0_7_LUTOUT28)

#define HW_PXP_WFE_B_STG1_5X8_OUT1_0	(0x00001fe0)

#define BP_PXP_WFE_B_STG1_5X8_OUT1_0_LUTOUT3      24
#define BM_PXP_WFE_B_STG1_5X8_OUT1_0_LUTOUT3 0xFF000000
#define BF_PXP_WFE_B_STG1_5X8_OUT1_0_LUTOUT3(v) \
        (((v) << 24) & BM_PXP_WFE_B_STG1_5X8_OUT1_0_LUTOUT3)
#define BP_PXP_WFE_B_STG1_5X8_OUT1_0_LUTOUT2      16
#define BM_PXP_WFE_B_STG1_5X8_OUT1_0_LUTOUT2 0x00FF0000
#define BF_PXP_WFE_B_STG1_5X8_OUT1_0_LUTOUT2(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_5X8_OUT1_0_LUTOUT2)
#define BP_PXP_WFE_B_STG1_5X8_OUT1_0_LUTOUT1      8
#define BM_PXP_WFE_B_STG1_5X8_OUT1_0_LUTOUT1 0x0000FF00
#define BF_PXP_WFE_B_STG1_5X8_OUT1_0_LUTOUT1(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_5X8_OUT1_0_LUTOUT1)
#define BP_PXP_WFE_B_STG1_5X8_OUT1_0_LUTOUT0      0
#define BM_PXP_WFE_B_STG1_5X8_OUT1_0_LUTOUT0 0x000000FF
#define BF_PXP_WFE_B_STG1_5X8_OUT1_0_LUTOUT0(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_5X8_OUT1_0_LUTOUT0)

#define HW_PXP_WFE_B_STG1_5X8_OUT1_1	(0x00001ff0)

#define BP_PXP_WFE_B_STG1_5X8_OUT1_1_LUTOUT7      24
#define BM_PXP_WFE_B_STG1_5X8_OUT1_1_LUTOUT7 0xFF000000
#define BF_PXP_WFE_B_STG1_5X8_OUT1_1_LUTOUT7(v) \
        (((v) << 24) & BM_PXP_WFE_B_STG1_5X8_OUT1_1_LUTOUT7)
#define BP_PXP_WFE_B_STG1_5X8_OUT1_1_LUTOUT6      16
#define BM_PXP_WFE_B_STG1_5X8_OUT1_1_LUTOUT6 0x00FF0000
#define BF_PXP_WFE_B_STG1_5X8_OUT1_1_LUTOUT6(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_5X8_OUT1_1_LUTOUT6)
#define BP_PXP_WFE_B_STG1_5X8_OUT1_1_LUTOUT5      8
#define BM_PXP_WFE_B_STG1_5X8_OUT1_1_LUTOUT5 0x0000FF00
#define BF_PXP_WFE_B_STG1_5X8_OUT1_1_LUTOUT5(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_5X8_OUT1_1_LUTOUT5)
#define BP_PXP_WFE_B_STG1_5X8_OUT1_1_LUTOUT4      0
#define BM_PXP_WFE_B_STG1_5X8_OUT1_1_LUTOUT4 0x000000FF
#define BF_PXP_WFE_B_STG1_5X8_OUT1_1_LUTOUT4(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_5X8_OUT1_1_LUTOUT4)

#define HW_PXP_WFE_B_STG1_5X8_OUT1_2	(0x00002000)

#define BP_PXP_WFE_B_STG1_5X8_OUT1_2_LUTOUT11      24
#define BM_PXP_WFE_B_STG1_5X8_OUT1_2_LUTOUT11 0xFF000000
#define BF_PXP_WFE_B_STG1_5X8_OUT1_2_LUTOUT11(v) \
        (((v) << 24) & BM_PXP_WFE_B_STG1_5X8_OUT1_2_LUTOUT11)
#define BP_PXP_WFE_B_STG1_5X8_OUT1_2_LUTOUT10      16
#define BM_PXP_WFE_B_STG1_5X8_OUT1_2_LUTOUT10 0x00FF0000
#define BF_PXP_WFE_B_STG1_5X8_OUT1_2_LUTOUT10(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_5X8_OUT1_2_LUTOUT10)
#define BP_PXP_WFE_B_STG1_5X8_OUT1_2_LUTOUT9      8
#define BM_PXP_WFE_B_STG1_5X8_OUT1_2_LUTOUT9 0x0000FF00
#define BF_PXP_WFE_B_STG1_5X8_OUT1_2_LUTOUT9(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_5X8_OUT1_2_LUTOUT9)
#define BP_PXP_WFE_B_STG1_5X8_OUT1_2_LUTOUT8      0
#define BM_PXP_WFE_B_STG1_5X8_OUT1_2_LUTOUT8 0x000000FF
#define BF_PXP_WFE_B_STG1_5X8_OUT1_2_LUTOUT8(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_5X8_OUT1_2_LUTOUT8)

#define HW_PXP_WFE_B_STG1_5X8_OUT1_3	(0x00002010)

#define BP_PXP_WFE_B_STG1_5X8_OUT1_3_LUTOUT15      24
#define BM_PXP_WFE_B_STG1_5X8_OUT1_3_LUTOUT15 0xFF000000
#define BF_PXP_WFE_B_STG1_5X8_OUT1_3_LUTOUT15(v) \
        (((v) << 24) & BM_PXP_WFE_B_STG1_5X8_OUT1_3_LUTOUT15)
#define BP_PXP_WFE_B_STG1_5X8_OUT1_3_LUTOUT14      16
#define BM_PXP_WFE_B_STG1_5X8_OUT1_3_LUTOUT14 0x00FF0000
#define BF_PXP_WFE_B_STG1_5X8_OUT1_3_LUTOUT14(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_5X8_OUT1_3_LUTOUT14)
#define BP_PXP_WFE_B_STG1_5X8_OUT1_3_LUTOUT13      8
#define BM_PXP_WFE_B_STG1_5X8_OUT1_3_LUTOUT13 0x0000FF00
#define BF_PXP_WFE_B_STG1_5X8_OUT1_3_LUTOUT13(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_5X8_OUT1_3_LUTOUT13)
#define BP_PXP_WFE_B_STG1_5X8_OUT1_3_LUTOUT12      0
#define BM_PXP_WFE_B_STG1_5X8_OUT1_3_LUTOUT12 0x000000FF
#define BF_PXP_WFE_B_STG1_5X8_OUT1_3_LUTOUT12(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_5X8_OUT1_3_LUTOUT12)

#define HW_PXP_WFE_B_STG1_5X8_OUT1_4	(0x00002020)

#define BP_PXP_WFE_B_STG1_5X8_OUT1_4_LUTOUT19      24
#define BM_PXP_WFE_B_STG1_5X8_OUT1_4_LUTOUT19 0xFF000000
#define BF_PXP_WFE_B_STG1_5X8_OUT1_4_LUTOUT19(v) \
        (((v) << 24) & BM_PXP_WFE_B_STG1_5X8_OUT1_4_LUTOUT19)
#define BP_PXP_WFE_B_STG1_5X8_OUT1_4_LUTOUT18      16
#define BM_PXP_WFE_B_STG1_5X8_OUT1_4_LUTOUT18 0x00FF0000
#define BF_PXP_WFE_B_STG1_5X8_OUT1_4_LUTOUT18(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_5X8_OUT1_4_LUTOUT18)
#define BP_PXP_WFE_B_STG1_5X8_OUT1_4_LUTOUT17      8
#define BM_PXP_WFE_B_STG1_5X8_OUT1_4_LUTOUT17 0x0000FF00
#define BF_PXP_WFE_B_STG1_5X8_OUT1_4_LUTOUT17(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_5X8_OUT1_4_LUTOUT17)
#define BP_PXP_WFE_B_STG1_5X8_OUT1_4_LUTOUT16      0
#define BM_PXP_WFE_B_STG1_5X8_OUT1_4_LUTOUT16 0x000000FF
#define BF_PXP_WFE_B_STG1_5X8_OUT1_4_LUTOUT16(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_5X8_OUT1_4_LUTOUT16)

#define HW_PXP_WFE_B_STG1_5X8_OUT1_5	(0x00002030)

#define BP_PXP_WFE_B_STG1_5X8_OUT1_5_LUTOUT23      24
#define BM_PXP_WFE_B_STG1_5X8_OUT1_5_LUTOUT23 0xFF000000
#define BF_PXP_WFE_B_STG1_5X8_OUT1_5_LUTOUT23(v) \
        (((v) << 24) & BM_PXP_WFE_B_STG1_5X8_OUT1_5_LUTOUT23)
#define BP_PXP_WFE_B_STG1_5X8_OUT1_5_LUTOUT22      16
#define BM_PXP_WFE_B_STG1_5X8_OUT1_5_LUTOUT22 0x00FF0000
#define BF_PXP_WFE_B_STG1_5X8_OUT1_5_LUTOUT22(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_5X8_OUT1_5_LUTOUT22)
#define BP_PXP_WFE_B_STG1_5X8_OUT1_5_LUTOUT21      8
#define BM_PXP_WFE_B_STG1_5X8_OUT1_5_LUTOUT21 0x0000FF00
#define BF_PXP_WFE_B_STG1_5X8_OUT1_5_LUTOUT21(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_5X8_OUT1_5_LUTOUT21)
#define BP_PXP_WFE_B_STG1_5X8_OUT1_5_LUTOUT20      0
#define BM_PXP_WFE_B_STG1_5X8_OUT1_5_LUTOUT20 0x000000FF
#define BF_PXP_WFE_B_STG1_5X8_OUT1_5_LUTOUT20(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_5X8_OUT1_5_LUTOUT20)

#define HW_PXP_WFE_B_STG1_5X8_OUT1_6	(0x00002040)

#define BP_PXP_WFE_B_STG1_5X8_OUT1_6_LUTOUT27      24
#define BM_PXP_WFE_B_STG1_5X8_OUT1_6_LUTOUT27 0xFF000000
#define BF_PXP_WFE_B_STG1_5X8_OUT1_6_LUTOUT27(v) \
        (((v) << 24) & BM_PXP_WFE_B_STG1_5X8_OUT1_6_LUTOUT27)
#define BP_PXP_WFE_B_STG1_5X8_OUT1_6_LUTOUT26      16
#define BM_PXP_WFE_B_STG1_5X8_OUT1_6_LUTOUT26 0x00FF0000
#define BF_PXP_WFE_B_STG1_5X8_OUT1_6_LUTOUT26(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_5X8_OUT1_6_LUTOUT26)
#define BP_PXP_WFE_B_STG1_5X8_OUT1_6_LUTOUT25      8
#define BM_PXP_WFE_B_STG1_5X8_OUT1_6_LUTOUT25 0x0000FF00
#define BF_PXP_WFE_B_STG1_5X8_OUT1_6_LUTOUT25(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_5X8_OUT1_6_LUTOUT25)
#define BP_PXP_WFE_B_STG1_5X8_OUT1_6_LUTOUT24      0
#define BM_PXP_WFE_B_STG1_5X8_OUT1_6_LUTOUT24 0x000000FF
#define BF_PXP_WFE_B_STG1_5X8_OUT1_6_LUTOUT24(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_5X8_OUT1_6_LUTOUT24)

#define HW_PXP_WFE_B_STG1_5X8_OUT1_7	(0x00002050)

#define BP_PXP_WFE_B_STG1_5X8_OUT1_7_LUTOUT31      24
#define BM_PXP_WFE_B_STG1_5X8_OUT1_7_LUTOUT31 0xFF000000
#define BF_PXP_WFE_B_STG1_5X8_OUT1_7_LUTOUT31(v) \
        (((v) << 24) & BM_PXP_WFE_B_STG1_5X8_OUT1_7_LUTOUT31)
#define BP_PXP_WFE_B_STG1_5X8_OUT1_7_LUTOUT30      16
#define BM_PXP_WFE_B_STG1_5X8_OUT1_7_LUTOUT30 0x00FF0000
#define BF_PXP_WFE_B_STG1_5X8_OUT1_7_LUTOUT30(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_5X8_OUT1_7_LUTOUT30)
#define BP_PXP_WFE_B_STG1_5X8_OUT1_7_LUTOUT29      8
#define BM_PXP_WFE_B_STG1_5X8_OUT1_7_LUTOUT29 0x0000FF00
#define BF_PXP_WFE_B_STG1_5X8_OUT1_7_LUTOUT29(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_5X8_OUT1_7_LUTOUT29)
#define BP_PXP_WFE_B_STG1_5X8_OUT1_7_LUTOUT28      0
#define BM_PXP_WFE_B_STG1_5X8_OUT1_7_LUTOUT28 0x000000FF
#define BF_PXP_WFE_B_STG1_5X8_OUT1_7_LUTOUT28(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_5X8_OUT1_7_LUTOUT28)

#define HW_PXP_WFE_B_STAGE1_5X8_MASKS_0	(0x00002060)

#define BP_PXP_WFE_B_STAGE1_5X8_MASKS_0_RSVD2      13
#define BM_PXP_WFE_B_STAGE1_5X8_MASKS_0_RSVD2 0xFFFFE000
#define BF_PXP_WFE_B_STAGE1_5X8_MASKS_0_RSVD2(v) \
        (((v) << 13) & BM_PXP_WFE_B_STAGE1_5X8_MASKS_0_RSVD2)
#define BP_PXP_WFE_B_STAGE1_5X8_MASKS_0_MASK1      8
#define BM_PXP_WFE_B_STAGE1_5X8_MASKS_0_MASK1 0x00001F00
#define BF_PXP_WFE_B_STAGE1_5X8_MASKS_0_MASK1(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STAGE1_5X8_MASKS_0_MASK1)
#define BP_PXP_WFE_B_STAGE1_5X8_MASKS_0_RSVD3      5
#define BM_PXP_WFE_B_STAGE1_5X8_MASKS_0_RSVD3 0x000000E0
#define BF_PXP_WFE_B_STAGE1_5X8_MASKS_0_RSVD3(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STAGE1_5X8_MASKS_0_RSVD3)
#define BP_PXP_WFE_B_STAGE1_5X8_MASKS_0_MASK0      0
#define BM_PXP_WFE_B_STAGE1_5X8_MASKS_0_MASK0 0x0000001F
#define BF_PXP_WFE_B_STAGE1_5X8_MASKS_0_MASK0(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STAGE1_5X8_MASKS_0_MASK0)

#define HW_PXP_WFE_B_STG1_5X1_OUT0	(0x00002070)

#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT31 0x80000000
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT31(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT31)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT30 0x40000000
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT30(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT30)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT29 0x20000000
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT29(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT29)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT28 0x10000000
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT28(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT28)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT27 0x08000000
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT27(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT27)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT26 0x04000000
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT26(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT26)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT25 0x02000000
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT25(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT25)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT24 0x01000000
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT24(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT24)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT23 0x00800000
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT23(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT23)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT22 0x00400000
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT22(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT22)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT21 0x00200000
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT21(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT21)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT20 0x00100000
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT20(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT20)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT19 0x00080000
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT19(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT19)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT18 0x00040000
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT18(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT18)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT17 0x00020000
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT17(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT17)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT16 0x00010000
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT16(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT16)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT15 0x00008000
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT15(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT15)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT14 0x00004000
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT14(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT14)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT13 0x00002000
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT13(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT13)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT12 0x00001000
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT12(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT12)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT11 0x00000800
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT11(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT11)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT10 0x00000400
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT10(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT10)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT9 0x00000200
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT9(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT9)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT8 0x00000100
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT8(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT8)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT7 0x00000080
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT7(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT7)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT6 0x00000040
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT6(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT6)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT5 0x00000020
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT5(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT5)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT4 0x00000010
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT4(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT4)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT3 0x00000008
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT3(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT3)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT2 0x00000004
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT2(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT2)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT1 0x00000002
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT1(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT1)
#define BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT0 0x00000001
#define BF_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT0(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_5X1_OUT0_LUTOUT0)

#define HW_PXP_WFE_B_STG1_5X1_MASKS	(0x00002080)

#define BP_PXP_WFE_B_STG1_5X1_MASKS_RSVD0      5
#define BM_PXP_WFE_B_STG1_5X1_MASKS_RSVD0 0xFFFFFFE0
#define BF_PXP_WFE_B_STG1_5X1_MASKS_RSVD0(v) \
        (((v) << 5) & BM_PXP_WFE_B_STG1_5X1_MASKS_RSVD0)
#define BP_PXP_WFE_B_STG1_5X1_MASKS_MASK0      0
#define BM_PXP_WFE_B_STG1_5X1_MASKS_MASK0 0x0000001F
#define BF_PXP_WFE_B_STG1_5X1_MASKS_MASK0(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_5X1_MASKS_MASK0)

#define HW_PXP_WFE_B_STG1_8X1_OUT0_0	(0x00002090)

#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT31 0x80000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT31(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT31)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT30 0x40000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT30(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT30)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT29 0x20000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT29(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT29)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT28 0x10000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT28(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT28)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT27 0x08000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT27(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT27)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT26 0x04000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT26(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT26)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT25 0x02000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT25(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT25)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT24 0x01000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT24(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT24)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT23 0x00800000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT23(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT23)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT22 0x00400000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT22(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT22)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT21 0x00200000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT21(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT21)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT20 0x00100000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT20(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT20)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT19 0x00080000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT19(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT19)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT18 0x00040000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT18(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT18)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT17 0x00020000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT17(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT17)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT16 0x00010000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT16(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT16)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT15 0x00008000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT15(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT15)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT14 0x00004000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT14(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT14)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT13 0x00002000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT13(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT13)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT12 0x00001000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT12(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT12)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT11 0x00000800
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT11(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT11)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT10 0x00000400
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT10(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT10)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT9 0x00000200
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT9(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT9)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT8 0x00000100
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT8(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT8)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT7 0x00000080
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT7(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT7)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT6 0x00000040
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT6(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT6)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT5 0x00000020
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT5(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT5)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT4 0x00000010
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT4(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT4)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT3 0x00000008
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT3(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT3)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT2 0x00000004
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT2(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT2)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT1 0x00000002
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT1(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT1)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT0 0x00000001
#define BF_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT0(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_8X1_OUT0_0_LUTOUT0)

#define HW_PXP_WFE_B_STG1_8X1_OUT0_1	(0x000020a0)

#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT63 0x80000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT63(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT63)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT62 0x40000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT62(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT62)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT61 0x20000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT61(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT61)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT60 0x10000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT60(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT60)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT59 0x08000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT59(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT59)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT58 0x04000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT58(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT58)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT57 0x02000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT57(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT57)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT56 0x01000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT56(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT56)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT55 0x00800000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT55(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT55)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT54 0x00400000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT54(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT54)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT53 0x00200000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT53(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT53)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT52 0x00100000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT52(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT52)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT51 0x00080000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT51(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT51)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT50 0x00040000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT50(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT50)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT49 0x00020000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT49(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT49)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT48 0x00010000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT48(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT48)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT47 0x00008000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT47(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT47)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT46 0x00004000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT46(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT46)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT45 0x00002000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT45(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT45)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT44 0x00001000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT44(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT44)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT43 0x00000800
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT43(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT43)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT42 0x00000400
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT42(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT42)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT41 0x00000200
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT41(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT41)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT40 0x00000100
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT40(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT40)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT39 0x00000080
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT39(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT39)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT38 0x00000040
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT38(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT38)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT37 0x00000020
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT37(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT37)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT36 0x00000010
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT36(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT36)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT35 0x00000008
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT35(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT35)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT34 0x00000004
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT34(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT34)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT33 0x00000002
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT33(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT33)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT32 0x00000001
#define BF_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT32(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_8X1_OUT0_1_LUTOUT32)

#define HW_PXP_WFE_B_STG1_8X1_OUT0_2	(0x000020b0)

#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT95 0x80000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT95(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT95)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT94 0x40000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT94(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT94)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT93 0x20000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT93(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT93)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT92 0x10000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT92(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT92)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT91 0x08000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT91(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT91)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT90 0x04000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT90(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT90)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT89 0x02000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT89(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT89)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT88 0x01000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT88(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT88)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT87 0x00800000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT87(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT87)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT86 0x00400000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT86(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT86)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT85 0x00200000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT85(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT85)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT84 0x00100000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT84(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT84)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT83 0x00080000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT83(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT83)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT82 0x00040000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT82(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT82)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT81 0x00020000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT81(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT81)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT80 0x00010000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT80(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT80)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT79 0x00008000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT79(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT79)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT78 0x00004000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT78(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT78)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT77 0x00002000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT77(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT77)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT76 0x00001000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT76(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT76)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT75 0x00000800
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT75(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT75)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT74 0x00000400
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT74(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT74)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT73 0x00000200
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT73(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT73)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT72 0x00000100
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT72(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT72)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT71 0x00000080
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT71(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT71)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT70 0x00000040
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT70(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT70)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT69 0x00000020
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT69(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT69)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT68 0x00000010
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT68(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT68)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT67 0x00000008
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT67(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT67)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT66 0x00000004
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT66(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT66)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT65 0x00000002
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT65(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT65)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT64 0x00000001
#define BF_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT64(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_8X1_OUT0_2_LUTOUT64)

#define HW_PXP_WFE_B_STG1_8X1_OUT0_3	(0x000020c0)

#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT127 0x80000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT127(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT127)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT126 0x40000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT126(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT126)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT125 0x20000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT125(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT125)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT124 0x10000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT124(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT124)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT123 0x08000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT123(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT123)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT122 0x04000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT122(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT122)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT121 0x02000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT121(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT121)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT120 0x01000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT120(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT120)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT119 0x00800000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT119(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT119)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT118 0x00400000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT118(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT118)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT117 0x00200000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT117(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT117)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT116 0x00100000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT116(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT116)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT115 0x00080000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT115(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT115)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT114 0x00040000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT114(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT114)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT113 0x00020000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT113(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT113)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT112 0x00010000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT112(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT112)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT111 0x00008000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT111(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT111)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT110 0x00004000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT110(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT110)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT109 0x00002000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT109(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT109)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT108 0x00001000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT108(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT108)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT107 0x00000800
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT107(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT107)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT106 0x00000400
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT106(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT106)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT105 0x00000200
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT105(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT105)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT104 0x00000100
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT104(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT104)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT103 0x00000080
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT103(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT103)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT102 0x00000040
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT102(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT102)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT101 0x00000020
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT101(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT101)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT100 0x00000010
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT100(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT100)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT99 0x00000008
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT99(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT99)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT98 0x00000004
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT98(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT98)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT97 0x00000002
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT97(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT97)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT96 0x00000001
#define BF_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT96(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_8X1_OUT0_3_LUTOUT96)

#define HW_PXP_WFE_B_STG1_8X1_OUT0_4	(0x000020d0)

#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT159 0x80000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT159(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT159)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT158 0x40000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT158(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT158)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT157 0x20000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT157(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT157)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT156 0x10000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT156(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT156)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT155 0x08000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT155(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT155)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT154 0x04000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT154(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT154)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT153 0x02000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT153(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT153)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT152 0x01000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT152(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT152)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT151 0x00800000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT151(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT151)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT150 0x00400000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT150(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT150)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT149 0x00200000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT149(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT149)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT148 0x00100000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT148(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT148)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT147 0x00080000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT147(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT147)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT146 0x00040000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT146(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT146)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT145 0x00020000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT145(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT145)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT144 0x00010000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT144(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT144)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT143 0x00008000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT143(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT143)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT142 0x00004000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT142(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT142)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT141 0x00002000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT141(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT141)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT140 0x00001000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT140(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT140)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT139 0x00000800
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT139(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT139)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT138 0x00000400
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT138(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT138)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT137 0x00000200
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT137(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT137)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT136 0x00000100
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT136(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT136)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT135 0x00000080
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT135(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT135)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT134 0x00000040
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT134(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT134)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT133 0x00000020
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT133(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT133)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT132 0x00000010
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT132(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT132)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT131 0x00000008
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT131(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT131)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT130 0x00000004
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT130(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT130)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT129 0x00000002
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT129(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT129)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT128 0x00000001
#define BF_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT128(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_8X1_OUT0_4_LUTOUT128)

#define HW_PXP_WFE_B_STG1_8X1_OUT0_5	(0x000020e0)

#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT191 0x80000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT191(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT191)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT190 0x40000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT190(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT190)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT189 0x20000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT189(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT189)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT188 0x10000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT188(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT188)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT187 0x08000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT187(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT187)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT186 0x04000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT186(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT186)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT185 0x02000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT185(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT185)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT184 0x01000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT184(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT184)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT183 0x00800000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT183(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT183)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT182 0x00400000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT182(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT182)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT181 0x00200000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT181(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT181)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT180 0x00100000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT180(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT180)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT179 0x00080000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT179(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT179)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT178 0x00040000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT178(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT178)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT177 0x00020000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT177(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT177)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT176 0x00010000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT176(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT176)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT175 0x00008000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT175(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT175)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT174 0x00004000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT174(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT174)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT173 0x00002000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT173(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT173)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT172 0x00001000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT172(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT172)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT171 0x00000800
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT171(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT171)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT170 0x00000400
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT170(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT170)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT169 0x00000200
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT169(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT169)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT168 0x00000100
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT168(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT168)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT167 0x00000080
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT167(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT167)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT166 0x00000040
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT166(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT166)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT165 0x00000020
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT165(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT165)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT164 0x00000010
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT164(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT164)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT163 0x00000008
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT163(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT163)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT162 0x00000004
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT162(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT162)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT161 0x00000002
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT161(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT161)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT160 0x00000001
#define BF_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT160(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_8X1_OUT0_5_LUTOUT160)

#define HW_PXP_WFE_B_STG1_8X1_OUT0_6	(0x000020f0)

#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT223 0x80000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT223(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT223)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT222 0x40000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT222(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT222)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT221 0x20000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT221(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT221)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT220 0x10000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT220(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT220)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT219 0x08000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT219(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT219)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT218 0x04000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT218(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT218)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT217 0x02000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT217(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT217)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT216 0x01000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT216(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT216)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT215 0x00800000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT215(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT215)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT214 0x00400000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT214(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT214)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT213 0x00200000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT213(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT213)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT212 0x00100000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT212(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT212)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT211 0x00080000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT211(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT211)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT210 0x00040000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT210(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT210)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT209 0x00020000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT209(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT209)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT208 0x00010000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT208(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT208)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT207 0x00008000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT207(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT207)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT206 0x00004000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT206(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT206)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT205 0x00002000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT205(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT205)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT204 0x00001000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT204(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT204)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT203 0x00000800
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT203(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT203)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT202 0x00000400
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT202(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT202)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT201 0x00000200
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT201(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT201)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT200 0x00000100
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT200(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT200)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT199 0x00000080
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT199(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT199)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT198 0x00000040
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT198(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT198)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT197 0x00000020
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT197(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT197)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT196 0x00000010
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT196(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT196)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT195 0x00000008
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT195(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT195)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT194 0x00000004
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT194(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT194)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT193 0x00000002
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT193(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT193)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT192 0x00000001
#define BF_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT192(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_8X1_OUT0_6_LUTOUT192)

#define HW_PXP_WFE_B_STG1_8X1_OUT0_7	(0x00002100)

#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT255 0x80000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT255(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT255)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT254 0x40000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT254(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT254)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT253 0x20000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT253(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT253)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT252 0x10000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT252(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT252)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT251 0x08000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT251(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT251)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT250 0x04000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT250(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT250)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT249 0x02000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT249(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT249)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT248 0x01000000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT248(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT248)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT247 0x00800000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT247(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT247)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT246 0x00400000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT246(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT246)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT245 0x00200000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT245(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT245)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT244 0x00100000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT244(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT244)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT243 0x00080000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT243(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT243)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT242 0x00040000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT242(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT242)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT241 0x00020000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT241(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT241)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT240 0x00010000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT240(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT240)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT239 0x00008000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT239(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT239)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT238 0x00004000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT238(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT238)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT237 0x00002000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT237(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT237)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT236 0x00001000
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT236(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT236)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT235 0x00000800
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT235(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT235)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT234 0x00000400
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT234(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT234)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT233 0x00000200
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT233(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT233)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT232 0x00000100
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT232(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT232)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT231 0x00000080
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT231(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT231)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT230 0x00000040
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT230(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT230)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT229 0x00000020
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT229(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT229)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT228 0x00000010
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT228(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT228)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT227 0x00000008
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT227(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT227)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT226 0x00000004
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT226(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT226)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT225 0x00000002
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT225(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT225)
#define BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT224 0x00000001
#define BF_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT224(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_8X1_OUT0_7_LUTOUT224)

#define HW_PXP_WFE_B_STG1_8X1_OUT1_0	(0x00002110)

#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT31 0x80000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT31(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT31)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT30 0x40000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT30(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT30)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT29 0x20000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT29(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT29)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT28 0x10000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT28(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT28)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT27 0x08000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT27(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT27)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT26 0x04000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT26(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT26)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT25 0x02000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT25(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT25)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT24 0x01000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT24(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT24)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT23 0x00800000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT23(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT23)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT22 0x00400000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT22(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT22)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT21 0x00200000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT21(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT21)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT20 0x00100000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT20(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT20)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT19 0x00080000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT19(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT19)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT18 0x00040000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT18(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT18)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT17 0x00020000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT17(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT17)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT16 0x00010000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT16(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT16)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT15 0x00008000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT15(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT15)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT14 0x00004000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT14(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT14)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT13 0x00002000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT13(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT13)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT12 0x00001000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT12(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT12)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT11 0x00000800
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT11(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT11)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT10 0x00000400
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT10(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT10)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT9 0x00000200
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT9(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT9)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT8 0x00000100
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT8(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT8)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT7 0x00000080
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT7(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT7)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT6 0x00000040
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT6(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT6)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT5 0x00000020
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT5(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT5)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT4 0x00000010
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT4(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT4)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT3 0x00000008
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT3(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT3)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT2 0x00000004
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT2(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT2)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT1 0x00000002
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT1(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT1)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT0 0x00000001
#define BF_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT0(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_8X1_OUT1_0_LUTOUT0)

#define HW_PXP_WFE_B_STG1_8X1_OUT1_1	(0x00002120)

#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT63 0x80000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT63(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT63)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT62 0x40000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT62(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT62)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT61 0x20000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT61(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT61)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT60 0x10000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT60(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT60)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT59 0x08000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT59(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT59)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT58 0x04000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT58(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT58)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT57 0x02000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT57(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT57)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT56 0x01000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT56(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT56)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT55 0x00800000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT55(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT55)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT54 0x00400000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT54(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT54)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT53 0x00200000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT53(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT53)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT52 0x00100000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT52(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT52)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT51 0x00080000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT51(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT51)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT50 0x00040000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT50(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT50)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT49 0x00020000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT49(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT49)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT48 0x00010000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT48(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT48)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT47 0x00008000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT47(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT47)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT46 0x00004000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT46(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT46)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT45 0x00002000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT45(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT45)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT44 0x00001000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT44(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT44)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT43 0x00000800
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT43(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT43)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT42 0x00000400
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT42(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT42)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT41 0x00000200
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT41(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT41)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT40 0x00000100
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT40(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT40)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT39 0x00000080
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT39(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT39)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT38 0x00000040
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT38(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT38)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT37 0x00000020
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT37(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT37)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT36 0x00000010
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT36(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT36)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT35 0x00000008
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT35(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT35)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT34 0x00000004
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT34(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT34)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT33 0x00000002
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT33(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT33)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT32 0x00000001
#define BF_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT32(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_8X1_OUT1_1_LUTOUT32)

#define HW_PXP_WFE_B_STG1_8X1_OUT1_2	(0x00002130)

#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT95 0x80000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT95(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT95)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT94 0x40000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT94(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT94)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT93 0x20000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT93(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT93)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT92 0x10000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT92(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT92)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT91 0x08000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT91(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT91)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT90 0x04000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT90(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT90)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT89 0x02000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT89(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT89)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT88 0x01000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT88(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT88)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT87 0x00800000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT87(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT87)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT86 0x00400000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT86(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT86)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT85 0x00200000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT85(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT85)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT84 0x00100000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT84(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT84)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT83 0x00080000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT83(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT83)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT82 0x00040000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT82(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT82)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT81 0x00020000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT81(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT81)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT80 0x00010000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT80(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT80)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT79 0x00008000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT79(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT79)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT78 0x00004000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT78(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT78)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT77 0x00002000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT77(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT77)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT76 0x00001000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT76(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT76)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT75 0x00000800
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT75(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT75)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT74 0x00000400
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT74(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT74)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT73 0x00000200
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT73(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT73)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT72 0x00000100
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT72(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT72)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT71 0x00000080
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT71(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT71)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT70 0x00000040
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT70(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT70)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT69 0x00000020
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT69(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT69)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT68 0x00000010
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT68(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT68)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT67 0x00000008
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT67(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT67)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT66 0x00000004
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT66(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT66)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT65 0x00000002
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT65(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT65)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT64 0x00000001
#define BF_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT64(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_8X1_OUT1_2_LUTOUT64)

#define HW_PXP_WFE_B_STG1_8X1_OUT1_3	(0x00002140)

#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT127 0x80000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT127(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT127)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT126 0x40000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT126(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT126)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT125 0x20000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT125(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT125)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT124 0x10000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT124(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT124)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT123 0x08000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT123(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT123)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT122 0x04000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT122(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT122)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT121 0x02000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT121(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT121)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT120 0x01000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT120(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT120)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT119 0x00800000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT119(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT119)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT118 0x00400000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT118(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT118)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT117 0x00200000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT117(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT117)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT116 0x00100000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT116(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT116)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT115 0x00080000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT115(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT115)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT114 0x00040000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT114(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT114)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT113 0x00020000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT113(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT113)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT112 0x00010000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT112(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT112)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT111 0x00008000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT111(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT111)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT110 0x00004000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT110(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT110)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT109 0x00002000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT109(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT109)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT108 0x00001000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT108(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT108)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT107 0x00000800
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT107(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT107)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT106 0x00000400
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT106(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT106)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT105 0x00000200
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT105(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT105)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT104 0x00000100
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT104(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT104)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT103 0x00000080
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT103(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT103)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT102 0x00000040
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT102(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT102)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT101 0x00000020
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT101(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT101)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT100 0x00000010
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT100(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT100)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT99 0x00000008
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT99(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT99)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT98 0x00000004
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT98(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT98)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT97 0x00000002
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT97(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT97)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT96 0x00000001
#define BF_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT96(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_8X1_OUT1_3_LUTOUT96)

#define HW_PXP_WFE_B_STG1_8X1_OUT1_4	(0x00002150)

#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT159 0x80000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT159(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT159)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT158 0x40000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT158(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT158)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT157 0x20000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT157(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT157)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT156 0x10000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT156(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT156)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT155 0x08000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT155(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT155)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT154 0x04000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT154(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT154)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT153 0x02000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT153(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT153)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT152 0x01000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT152(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT152)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT151 0x00800000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT151(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT151)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT150 0x00400000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT150(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT150)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT149 0x00200000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT149(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT149)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT148 0x00100000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT148(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT148)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT147 0x00080000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT147(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT147)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT146 0x00040000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT146(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT146)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT145 0x00020000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT145(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT145)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT144 0x00010000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT144(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT144)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT143 0x00008000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT143(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT143)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT142 0x00004000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT142(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT142)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT141 0x00002000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT141(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT141)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT140 0x00001000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT140(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT140)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT139 0x00000800
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT139(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT139)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT138 0x00000400
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT138(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT138)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT137 0x00000200
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT137(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT137)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT136 0x00000100
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT136(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT136)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT135 0x00000080
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT135(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT135)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT134 0x00000040
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT134(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT134)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT133 0x00000020
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT133(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT133)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT132 0x00000010
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT132(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT132)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT131 0x00000008
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT131(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT131)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT130 0x00000004
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT130(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT130)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT129 0x00000002
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT129(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT129)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT128 0x00000001
#define BF_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT128(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_8X1_OUT1_4_LUTOUT128)

#define HW_PXP_WFE_B_STG1_8X1_OUT1_5	(0x00002160)

#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT191 0x80000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT191(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT191)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT190 0x40000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT190(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT190)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT189 0x20000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT189(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT189)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT188 0x10000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT188(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT188)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT187 0x08000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT187(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT187)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT186 0x04000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT186(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT186)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT185 0x02000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT185(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT185)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT184 0x01000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT184(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT184)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT183 0x00800000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT183(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT183)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT182 0x00400000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT182(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT182)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT181 0x00200000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT181(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT181)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT180 0x00100000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT180(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT180)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT179 0x00080000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT179(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT179)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT178 0x00040000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT178(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT178)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT177 0x00020000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT177(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT177)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT176 0x00010000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT176(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT176)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT175 0x00008000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT175(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT175)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT174 0x00004000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT174(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT174)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT173 0x00002000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT173(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT173)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT172 0x00001000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT172(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT172)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT171 0x00000800
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT171(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT171)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT170 0x00000400
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT170(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT170)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT169 0x00000200
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT169(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT169)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT168 0x00000100
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT168(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT168)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT167 0x00000080
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT167(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT167)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT166 0x00000040
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT166(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT166)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT165 0x00000020
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT165(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT165)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT164 0x00000010
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT164(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT164)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT163 0x00000008
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT163(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT163)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT162 0x00000004
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT162(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT162)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT161 0x00000002
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT161(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT161)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT160 0x00000001
#define BF_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT160(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_8X1_OUT1_5_LUTOUT160)

#define HW_PXP_WFE_B_STG1_8X1_OUT1_6	(0x00002170)

#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT223 0x80000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT223(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT223)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT222 0x40000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT222(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT222)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT221 0x20000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT221(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT221)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT220 0x10000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT220(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT220)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT219 0x08000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT219(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT219)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT218 0x04000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT218(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT218)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT217 0x02000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT217(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT217)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT216 0x01000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT216(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT216)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT215 0x00800000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT215(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT215)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT214 0x00400000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT214(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT214)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT213 0x00200000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT213(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT213)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT212 0x00100000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT212(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT212)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT211 0x00080000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT211(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT211)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT210 0x00040000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT210(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT210)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT209 0x00020000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT209(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT209)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT208 0x00010000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT208(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT208)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT207 0x00008000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT207(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT207)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT206 0x00004000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT206(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT206)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT205 0x00002000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT205(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT205)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT204 0x00001000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT204(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT204)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT203 0x00000800
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT203(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT203)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT202 0x00000400
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT202(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT202)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT201 0x00000200
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT201(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT201)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT200 0x00000100
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT200(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT200)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT199 0x00000080
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT199(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT199)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT198 0x00000040
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT198(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT198)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT197 0x00000020
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT197(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT197)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT196 0x00000010
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT196(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT196)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT195 0x00000008
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT195(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT195)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT194 0x00000004
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT194(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT194)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT193 0x00000002
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT193(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT193)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT192 0x00000001
#define BF_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT192(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_8X1_OUT1_6_LUTOUT192)

#define HW_PXP_WFE_B_STG1_8X1_OUT1_7	(0x00002180)

#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT255 0x80000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT255(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT255)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT254 0x40000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT254(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT254)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT253 0x20000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT253(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT253)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT252 0x10000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT252(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT252)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT251 0x08000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT251(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT251)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT250 0x04000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT250(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT250)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT249 0x02000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT249(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT249)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT248 0x01000000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT248(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT248)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT247 0x00800000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT247(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT247)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT246 0x00400000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT246(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT246)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT245 0x00200000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT245(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT245)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT244 0x00100000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT244(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT244)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT243 0x00080000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT243(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT243)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT242 0x00040000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT242(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT242)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT241 0x00020000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT241(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT241)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT240 0x00010000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT240(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT240)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT239 0x00008000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT239(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT239)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT238 0x00004000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT238(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT238)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT237 0x00002000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT237(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT237)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT236 0x00001000
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT236(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT236)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT235 0x00000800
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT235(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT235)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT234 0x00000400
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT234(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT234)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT233 0x00000200
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT233(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT233)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT232 0x00000100
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT232(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT232)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT231 0x00000080
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT231(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT231)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT230 0x00000040
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT230(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT230)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT229 0x00000020
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT229(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT229)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT228 0x00000010
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT228(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT228)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT227 0x00000008
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT227(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT227)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT226 0x00000004
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT226(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT226)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT225 0x00000002
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT225(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT225)
#define BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT224 0x00000001
#define BF_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT224(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_8X1_OUT1_7_LUTOUT224)

#define HW_PXP_WFE_B_STG1_8X1_OUT2_0	(0x00002190)

#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT31 0x80000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT31(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT31)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT30 0x40000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT30(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT30)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT29 0x20000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT29(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT29)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT28 0x10000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT28(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT28)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT27 0x08000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT27(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT27)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT26 0x04000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT26(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT26)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT25 0x02000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT25(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT25)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT24 0x01000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT24(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT24)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT23 0x00800000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT23(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT23)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT22 0x00400000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT22(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT22)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT21 0x00200000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT21(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT21)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT20 0x00100000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT20(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT20)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT19 0x00080000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT19(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT19)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT18 0x00040000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT18(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT18)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT17 0x00020000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT17(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT17)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT16 0x00010000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT16(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT16)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT15 0x00008000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT15(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT15)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT14 0x00004000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT14(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT14)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT13 0x00002000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT13(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT13)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT12 0x00001000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT12(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT12)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT11 0x00000800
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT11(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT11)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT10 0x00000400
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT10(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT10)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT9 0x00000200
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT9(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT9)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT8 0x00000100
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT8(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT8)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT7 0x00000080
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT7(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT7)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT6 0x00000040
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT6(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT6)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT5 0x00000020
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT5(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT5)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT4 0x00000010
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT4(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT4)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT3 0x00000008
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT3(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT3)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT2 0x00000004
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT2(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT2)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT1 0x00000002
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT1(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT1)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT0 0x00000001
#define BF_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT0(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_8X1_OUT2_0_LUTOUT0)

#define HW_PXP_WFE_B_STG1_8X1_OUT2_1	(0x000021a0)

#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT63 0x80000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT63(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT63)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT62 0x40000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT62(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT62)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT61 0x20000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT61(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT61)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT60 0x10000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT60(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT60)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT59 0x08000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT59(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT59)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT58 0x04000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT58(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT58)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT57 0x02000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT57(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT57)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT56 0x01000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT56(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT56)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT55 0x00800000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT55(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT55)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT54 0x00400000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT54(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT54)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT53 0x00200000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT53(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT53)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT52 0x00100000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT52(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT52)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT51 0x00080000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT51(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT51)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT50 0x00040000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT50(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT50)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT49 0x00020000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT49(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT49)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT48 0x00010000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT48(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT48)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT47 0x00008000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT47(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT47)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT46 0x00004000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT46(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT46)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT45 0x00002000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT45(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT45)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT44 0x00001000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT44(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT44)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT43 0x00000800
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT43(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT43)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT42 0x00000400
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT42(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT42)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT41 0x00000200
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT41(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT41)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT40 0x00000100
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT40(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT40)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT39 0x00000080
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT39(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT39)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT38 0x00000040
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT38(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT38)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT37 0x00000020
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT37(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT37)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT36 0x00000010
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT36(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT36)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT35 0x00000008
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT35(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT35)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT34 0x00000004
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT34(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT34)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT33 0x00000002
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT33(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT33)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT32 0x00000001
#define BF_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT32(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_8X1_OUT2_1_LUTOUT32)

#define HW_PXP_WFE_B_STG1_8X1_OUT2_2	(0x000021b0)

#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT95 0x80000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT95(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT95)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT94 0x40000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT94(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT94)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT93 0x20000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT93(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT93)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT92 0x10000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT92(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT92)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT91 0x08000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT91(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT91)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT90 0x04000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT90(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT90)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT89 0x02000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT89(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT89)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT88 0x01000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT88(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT88)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT87 0x00800000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT87(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT87)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT86 0x00400000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT86(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT86)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT85 0x00200000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT85(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT85)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT84 0x00100000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT84(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT84)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT83 0x00080000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT83(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT83)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT82 0x00040000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT82(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT82)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT81 0x00020000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT81(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT81)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT80 0x00010000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT80(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT80)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT79 0x00008000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT79(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT79)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT78 0x00004000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT78(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT78)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT77 0x00002000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT77(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT77)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT76 0x00001000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT76(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT76)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT75 0x00000800
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT75(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT75)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT74 0x00000400
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT74(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT74)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT73 0x00000200
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT73(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT73)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT72 0x00000100
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT72(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT72)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT71 0x00000080
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT71(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT71)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT70 0x00000040
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT70(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT70)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT69 0x00000020
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT69(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT69)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT68 0x00000010
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT68(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT68)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT67 0x00000008
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT67(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT67)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT66 0x00000004
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT66(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT66)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT65 0x00000002
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT65(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT65)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT64 0x00000001
#define BF_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT64(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_8X1_OUT2_2_LUTOUT64)

#define HW_PXP_WFE_B_STG1_8X1_OUT2_3	(0x000021c0)

#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT127 0x80000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT127(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT127)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT126 0x40000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT126(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT126)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT125 0x20000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT125(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT125)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT124 0x10000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT124(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT124)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT123 0x08000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT123(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT123)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT122 0x04000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT122(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT122)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT121 0x02000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT121(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT121)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT120 0x01000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT120(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT120)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT119 0x00800000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT119(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT119)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT118 0x00400000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT118(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT118)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT117 0x00200000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT117(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT117)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT116 0x00100000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT116(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT116)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT115 0x00080000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT115(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT115)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT114 0x00040000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT114(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT114)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT113 0x00020000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT113(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT113)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT112 0x00010000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT112(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT112)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT111 0x00008000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT111(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT111)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT110 0x00004000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT110(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT110)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT109 0x00002000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT109(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT109)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT108 0x00001000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT108(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT108)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT107 0x00000800
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT107(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT107)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT106 0x00000400
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT106(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT106)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT105 0x00000200
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT105(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT105)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT104 0x00000100
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT104(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT104)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT103 0x00000080
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT103(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT103)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT102 0x00000040
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT102(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT102)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT101 0x00000020
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT101(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT101)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT100 0x00000010
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT100(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT100)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT99 0x00000008
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT99(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT99)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT98 0x00000004
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT98(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT98)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT97 0x00000002
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT97(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT97)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT96 0x00000001
#define BF_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT96(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_8X1_OUT2_3_LUTOUT96)

#define HW_PXP_WFE_B_STG1_8X1_OUT2_4	(0x000021d0)

#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT159 0x80000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT159(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT159)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT158 0x40000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT158(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT158)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT157 0x20000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT157(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT157)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT156 0x10000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT156(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT156)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT155 0x08000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT155(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT155)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT154 0x04000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT154(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT154)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT153 0x02000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT153(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT153)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT152 0x01000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT152(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT152)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT151 0x00800000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT151(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT151)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT150 0x00400000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT150(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT150)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT149 0x00200000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT149(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT149)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT148 0x00100000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT148(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT148)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT147 0x00080000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT147(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT147)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT146 0x00040000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT146(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT146)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT145 0x00020000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT145(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT145)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT144 0x00010000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT144(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT144)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT143 0x00008000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT143(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT143)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT142 0x00004000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT142(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT142)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT141 0x00002000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT141(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT141)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT140 0x00001000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT140(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT140)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT139 0x00000800
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT139(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT139)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT138 0x00000400
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT138(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT138)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT137 0x00000200
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT137(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT137)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT136 0x00000100
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT136(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT136)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT135 0x00000080
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT135(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT135)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT134 0x00000040
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT134(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT134)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT133 0x00000020
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT133(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT133)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT132 0x00000010
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT132(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT132)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT131 0x00000008
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT131(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT131)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT130 0x00000004
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT130(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT130)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT129 0x00000002
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT129(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT129)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT128 0x00000001
#define BF_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT128(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_8X1_OUT2_4_LUTOUT128)

#define HW_PXP_WFE_B_STG1_8X1_OUT2_5	(0x000021e0)

#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT191 0x80000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT191(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT191)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT190 0x40000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT190(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT190)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT189 0x20000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT189(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT189)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT188 0x10000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT188(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT188)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT187 0x08000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT187(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT187)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT186 0x04000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT186(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT186)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT185 0x02000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT185(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT185)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT184 0x01000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT184(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT184)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT183 0x00800000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT183(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT183)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT182 0x00400000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT182(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT182)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT181 0x00200000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT181(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT181)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT180 0x00100000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT180(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT180)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT179 0x00080000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT179(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT179)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT178 0x00040000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT178(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT178)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT177 0x00020000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT177(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT177)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT176 0x00010000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT176(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT176)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT175 0x00008000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT175(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT175)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT174 0x00004000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT174(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT174)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT173 0x00002000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT173(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT173)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT172 0x00001000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT172(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT172)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT171 0x00000800
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT171(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT171)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT170 0x00000400
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT170(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT170)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT169 0x00000200
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT169(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT169)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT168 0x00000100
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT168(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT168)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT167 0x00000080
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT167(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT167)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT166 0x00000040
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT166(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT166)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT165 0x00000020
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT165(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT165)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT164 0x00000010
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT164(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT164)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT163 0x00000008
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT163(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT163)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT162 0x00000004
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT162(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT162)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT161 0x00000002
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT161(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT161)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT160 0x00000001
#define BF_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT160(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_8X1_OUT2_5_LUTOUT160)

#define HW_PXP_WFE_B_STG1_8X1_OUT2_6	(0x000021f0)

#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT223 0x80000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT223(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT223)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT222 0x40000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT222(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT222)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT221 0x20000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT221(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT221)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT220 0x10000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT220(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT220)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT219 0x08000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT219(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT219)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT218 0x04000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT218(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT218)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT217 0x02000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT217(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT217)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT216 0x01000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT216(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT216)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT215 0x00800000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT215(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT215)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT214 0x00400000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT214(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT214)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT213 0x00200000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT213(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT213)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT212 0x00100000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT212(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT212)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT211 0x00080000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT211(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT211)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT210 0x00040000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT210(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT210)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT209 0x00020000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT209(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT209)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT208 0x00010000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT208(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT208)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT207 0x00008000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT207(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT207)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT206 0x00004000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT206(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT206)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT205 0x00002000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT205(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT205)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT204 0x00001000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT204(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT204)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT203 0x00000800
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT203(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT203)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT202 0x00000400
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT202(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT202)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT201 0x00000200
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT201(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT201)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT200 0x00000100
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT200(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT200)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT199 0x00000080
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT199(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT199)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT198 0x00000040
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT198(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT198)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT197 0x00000020
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT197(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT197)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT196 0x00000010
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT196(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT196)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT195 0x00000008
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT195(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT195)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT194 0x00000004
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT194(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT194)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT193 0x00000002
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT193(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT193)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT192 0x00000001
#define BF_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT192(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_8X1_OUT2_6_LUTOUT192)

#define HW_PXP_WFE_B_STG1_8X1_OUT2_7	(0x00002200)

#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT255 0x80000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT255(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT255)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT254 0x40000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT254(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT254)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT253 0x20000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT253(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT253)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT252 0x10000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT252(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT252)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT251 0x08000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT251(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT251)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT250 0x04000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT250(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT250)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT249 0x02000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT249(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT249)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT248 0x01000000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT248(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT248)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT247 0x00800000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT247(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT247)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT246 0x00400000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT246(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT246)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT245 0x00200000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT245(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT245)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT244 0x00100000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT244(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT244)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT243 0x00080000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT243(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT243)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT242 0x00040000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT242(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT242)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT241 0x00020000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT241(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT241)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT240 0x00010000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT240(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT240)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT239 0x00008000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT239(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT239)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT238 0x00004000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT238(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT238)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT237 0x00002000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT237(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT237)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT236 0x00001000
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT236(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT236)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT235 0x00000800
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT235(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT235)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT234 0x00000400
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT234(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT234)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT233 0x00000200
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT233(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT233)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT232 0x00000100
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT232(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT232)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT231 0x00000080
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT231(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT231)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT230 0x00000040
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT230(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT230)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT229 0x00000020
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT229(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT229)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT228 0x00000010
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT228(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT228)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT227 0x00000008
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT227(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT227)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT226 0x00000004
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT226(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT226)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT225 0x00000002
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT225(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT225)
#define BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT224 0x00000001
#define BF_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT224(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_8X1_OUT2_7_LUTOUT224)

#define HW_PXP_WFE_B_STG1_8X1_OUT3_0	(0x00002210)

#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT31 0x80000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT31(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT31)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT30 0x40000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT30(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT30)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT29 0x20000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT29(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT29)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT28 0x10000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT28(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT28)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT27 0x08000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT27(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT27)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT26 0x04000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT26(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT26)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT25 0x02000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT25(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT25)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT24 0x01000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT24(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT24)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT23 0x00800000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT23(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT23)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT22 0x00400000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT22(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT22)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT21 0x00200000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT21(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT21)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT20 0x00100000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT20(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT20)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT19 0x00080000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT19(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT19)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT18 0x00040000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT18(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT18)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT17 0x00020000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT17(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT17)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT16 0x00010000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT16(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT16)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT15 0x00008000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT15(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT15)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT14 0x00004000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT14(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT14)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT13 0x00002000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT13(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT13)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT12 0x00001000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT12(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT12)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT11 0x00000800
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT11(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT11)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT10 0x00000400
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT10(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT10)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT9 0x00000200
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT9(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT9)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT8 0x00000100
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT8(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT8)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT7 0x00000080
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT7(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT7)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT6 0x00000040
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT6(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT6)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT5 0x00000020
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT5(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT5)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT4 0x00000010
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT4(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT4)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT3 0x00000008
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT3(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT3)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT2 0x00000004
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT2(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT2)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT1 0x00000002
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT1(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT1)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT0 0x00000001
#define BF_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT0(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_8X1_OUT3_0_LUTOUT0)

#define HW_PXP_WFE_B_STG1_8X1_OUT3_1	(0x00002220)

#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT63 0x80000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT63(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT63)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT62 0x40000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT62(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT62)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT61 0x20000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT61(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT61)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT60 0x10000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT60(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT60)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT59 0x08000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT59(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT59)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT58 0x04000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT58(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT58)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT57 0x02000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT57(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT57)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT56 0x01000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT56(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT56)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT55 0x00800000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT55(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT55)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT54 0x00400000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT54(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT54)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT53 0x00200000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT53(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT53)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT52 0x00100000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT52(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT52)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT51 0x00080000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT51(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT51)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT50 0x00040000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT50(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT50)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT49 0x00020000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT49(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT49)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT48 0x00010000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT48(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT48)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT47 0x00008000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT47(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT47)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT46 0x00004000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT46(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT46)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT45 0x00002000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT45(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT45)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT44 0x00001000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT44(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT44)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT43 0x00000800
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT43(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT43)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT42 0x00000400
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT42(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT42)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT41 0x00000200
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT41(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT41)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT40 0x00000100
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT40(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT40)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT39 0x00000080
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT39(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT39)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT38 0x00000040
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT38(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT38)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT37 0x00000020
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT37(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT37)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT36 0x00000010
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT36(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT36)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT35 0x00000008
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT35(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT35)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT34 0x00000004
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT34(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT34)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT33 0x00000002
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT33(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT33)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT32 0x00000001
#define BF_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT32(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_8X1_OUT3_1_LUTOUT32)

#define HW_PXP_WFE_B_STG1_8X1_OUT3_2	(0x00002230)

#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT95 0x80000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT95(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT95)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT94 0x40000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT94(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT94)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT93 0x20000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT93(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT93)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT92 0x10000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT92(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT92)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT91 0x08000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT91(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT91)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT90 0x04000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT90(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT90)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT89 0x02000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT89(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT89)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT88 0x01000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT88(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT88)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT87 0x00800000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT87(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT87)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT86 0x00400000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT86(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT86)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT85 0x00200000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT85(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT85)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT84 0x00100000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT84(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT84)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT83 0x00080000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT83(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT83)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT82 0x00040000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT82(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT82)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT81 0x00020000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT81(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT81)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT80 0x00010000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT80(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT80)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT79 0x00008000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT79(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT79)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT78 0x00004000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT78(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT78)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT77 0x00002000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT77(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT77)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT76 0x00001000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT76(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT76)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT75 0x00000800
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT75(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT75)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT74 0x00000400
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT74(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT74)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT73 0x00000200
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT73(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT73)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT72 0x00000100
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT72(v)  \
        (((v) << 8) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT72)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT71 0x00000080
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT71(v)  \
        (((v) << 7) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT71)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT70 0x00000040
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT70(v)  \
        (((v) << 6) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT70)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT69 0x00000020
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT69(v)  \
        (((v) << 5) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT69)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT68 0x00000010
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT68(v)  \
        (((v) << 4) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT68)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT67 0x00000008
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT67(v)  \
        (((v) << 3) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT67)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT66 0x00000004
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT66(v)  \
        (((v) << 2) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT66)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT65 0x00000002
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT65(v)  \
        (((v) << 1) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT65)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT64 0x00000001
#define BF_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT64(v)  \
        (((v) << 0) & BM_PXP_WFE_B_STG1_8X1_OUT3_2_LUTOUT64)

#define HW_PXP_WFE_B_STG1_8X1_OUT3_3	(0x00002240)

#define BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT127 0x80000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT127(v) \
        (((v) << 31) & BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT127)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT126 0x40000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT126(v)  \
        (((v) << 30) & BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT126)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT125 0x20000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT125(v)  \
        (((v) << 29) & BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT125)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT124 0x10000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT124(v)  \
        (((v) << 28) & BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT124)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT123 0x08000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT123(v)  \
        (((v) << 27) & BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT123)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT122 0x04000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT122(v)  \
        (((v) << 26) & BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT122)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT121 0x02000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT121(v)  \
        (((v) << 25) & BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT121)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT120 0x01000000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT120(v)  \
        (((v) << 24) & BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT120)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT119 0x00800000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT119(v)  \
        (((v) << 23) & BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT119)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT118 0x00400000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT118(v)  \
        (((v) << 22) & BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT118)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT117 0x00200000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT117(v)  \
        (((v) << 21) & BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT117)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT116 0x00100000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT116(v)  \
        (((v) << 20) & BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT116)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT115 0x00080000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT115(v)  \
        (((v) << 19) & BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT115)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT114 0x00040000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT114(v)  \
        (((v) << 18) & BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT114)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT113 0x00020000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT113(v)  \
        (((v) << 17) & BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT113)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT112 0x00010000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT112(v)  \
        (((v) << 16) & BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT112)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT111 0x00008000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT111(v)  \
        (((v) << 15) & BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT111)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT110 0x00004000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT110(v)  \
        (((v) << 14) & BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT110)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT109 0x00002000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT109(v)  \
        (((v) << 13) & BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT109)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT108 0x00001000
#define BF_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT108(v)  \
        (((v) << 12) & BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT108)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT107 0x00000800
#define BF_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT107(v)  \
        (((v) << 11) & BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT107)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT106 0x00000400
#define BF_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT106(v)  \
        (((v) << 10) & BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT106)
#define BM_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT105 0x00000200
#define BF_PXP_WFE_B_STG1_8X1_OUT3_3_LUTOUT105(v)  \
        (((v) << 9) & BM_PXP_WFE_B_STG1_