/****************************************************************************/
/* AUTHOR:  Nagase                                                          */
/* PURPOSE: EDID FORMAR                                                     */
/*                                                                          */
/* Copyright 2021 Sony Corporation                                          */
/****************************************************************************/
#ifndef _HD_EDID_FORMAT_H_
#define _HD_EDID_FORMAT_H_

/*==== Include =============================================================*/
#include "hd_edid_common.h"

/*==== Define ==============================================================*/
/* DTV MONITOR */
#define HD_EDID_FMT_DTV__UNDERSCAN	(BIT7)
#define HD_EDID_FMT_DTV__AUDIO		(BIT6)
#define HD_EDID_FMT_DTV__YCBCR444	(BIT5)
#define HD_EDID_FMT_DTV__YCBCR422	(BIT4)

/* VIDEO */
#define HD_EDID_FMT_SVD__MANDATORY	(BIT15)
#define HD_EDID_FMT_SVD__NATIVE		(BIT14)
#define HD_EDID_FMT_SCDS__Y420		(BIT1)
#define HD_EDID_FMT_6G				(BIT2)
#define HD_EDID_FMT_8K				(BIT3)
#define HD_EDID_FMT_2ND_BLOCK		(BIT4)
#define HD_EDID_FMT_2ND_BLOCK_MAP	(BIT8)
#define HD_EDID_FMT_SINK_SUPPORT	(BIT13)

#define HD_EDID_VSDB_MASK_SIZE		16

/*==== Typedef =============================================================*/

/* DTD */
typedef struct {
	uint8_t		vic;
	uint8_t		data[HD_EDID_LEN_DTD];
} HD_EDID_DTD_TIMING_t;

typedef struct {
	uint8_t		vic;
	uint16_t	state;
} HD_EDID_VIDEO_DATA_t;

/* SAD */
typedef enum {
	HD_EDID_SAD_KIND__NOTSUPPORT = 0,
	HD_EDID_SAD_KIND__LPCM,
	HD_EDID_SAD_KIND__AC3,
	HD_EDID_SAD_KIND__DDP,
	HD_EDID_SAD_KIND__MAT,
	HD_EDID_SAD_KIND__MPEG2AAC,
	HD_EDID_SAD_KIND__DTS,
	HD_EDID_SAD_KIND__DTSHD,
	HD_EDID_SAD_KIND__DTSX,
	HD_EDID_SAD_KIND__DSD,
	HD_EDID_SAD_KIND__MPEG4AAC,
	HD_EDID_SAD_KIND__MPEGH,
	HD_EDID_SAD_KIND_MAX
} HD_EDID_SAD_KIND_t;

typedef struct {
	uint8_t	kind			: 4;		/*	Audio Kind 				*/
	uint8_t	format_code		: 4;		/*	SAD format code			*/
	uint8_t	extension_code	: 5;		/*	SAD Extension type code	*/
	uint8_t	max_channel		: 3;		/*	max channel - 1			*/
	uint8_t	freq			: 7;		/*	frequency 				*/
	uint8_t	reserve2		: 1;
	uint8_t	param			: 8;		/*	parameter				*/
} HD_EDID_AUDIO_DATA_t;

/* SPD */
typedef struct {
	uint8_t	param[HD_EDID_LEN_DESC_SPD];
} HD_EDID_SPD_DATA_t;

/* VSDB */
typedef struct {
	uint8_t		supports_ai			: 1;
	uint8_t		deep_color			: 4;
	uint8_t		reserve0			: 3;
	uint8_t		tmds_clock			: 8;
	uint8_t		cnc					: 4;
	uint8_t		_3d_present			: 1;
	uint8_t		image_size			: 2;
	uint8_t		reserve1			: 1;
	uint8_t		hdmi_vic_len		: 3;
	uint8_t		reserve2			: 5;
	uint8_t		hdmi_vic[HD_EDID_CNT_VSDB_HDMI_VIC];
} HD_EDID_VSDB_EXTENSION_t;

typedef struct {
	uint8_t		version				: 8;
	uint8_t		tmds_character_rate	: 8;
	uint8_t		scdc_present		: 1;
	uint8_t		rr_capable			: 1;
	uint8_t		cable_status		: 1;
	uint8_t		ccbpci				: 1;
	uint8_t		lte_scramble		: 1;
	uint8_t		independent_view	: 1;
	uint8_t		dual_view			: 1;
	uint8_t		_3d_osd_disparity	: 1;
	uint8_t		max_frl_rate		: 4;
	uint8_t		uhd_vic				: 1;
	uint8_t		deep_color_420		: 3;
	uint8_t		m_delta				: 1;
	uint8_t		cinema_vrr			: 1;
	uint8_t		cnm_vrr				: 1;
	uint8_t		fva					: 1;
	uint8_t		allm				: 1;
	uint8_t		fapa_start_location	: 1;
	uint8_t		vrr_max_9_8			: 2;
	uint8_t		vrr_min				: 6;
	uint8_t		vrr_max_7_0			: 8;
	uint8_t		dsc_1p2				: 1;
	uint8_t		dsc_native_420		: 1;
	uint8_t		dsc_all_bpp			: 1;
	uint8_t		dsc_16bpc			: 1;
	uint8_t		dsc_12bpc			: 1;
	uint8_t		dsc_10bpc			: 1;
	uint8_t		dsc_max_frl_rate	: 4;
	uint8_t		dsc_max_slices		: 4;
	uint8_t		dsc_total_chunkKbytes	: 6;
} HD_EDID_SCDS_EXTENSION_t;

/* Colorimetry */
typedef struct {
	uint8_t		bt2020		: 3;
	uint8_t		adobe		: 2;
	uint8_t		ycc			: 3;
	uint8_t		reserve		: 4;
	uint8_t		md			: 4;
} HD_EDID_EXT_CMR_DATA_t;

/* VCDB */
typedef struct {
	uint8_t		qy			: 1;
	uint8_t		qs			: 1;
	uint8_t		s_pt		: 2;
	uint8_t		s_it		: 2;
	uint8_t		s_ce		: 2;
} HD_EDID_EXT_VCDB_DATA_t;

/* VSVDB */
typedef enum {
	HD_EDID_VSVDB_DV_TYPE_0 = 0,
	HD_EDID_VSVDB_DV_TYPE_1_15,
	HD_EDID_VSVDB_DV_TYPE_1_12,
	HD_EDID_VSVDB_DV_TYPE_2,
} HD_EDID_EXT_VSVDB_DV_TYPE_t;

typedef struct {
	uint8_t		version					: 3;
	uint8_t		supports_global_dimming	: 1;
	uint8_t		supports_2160p60hz		: 1;
	uint8_t		supports_yuv422_12bit	: 1;
	uint8_t		rx3_0					: 4;
	uint8_t		ry3_0					: 4;
	uint8_t		rx11_4					: 8;
	uint8_t		ry11_4					: 8;
	uint8_t		gx3_0					: 4;
	uint8_t		gy3_0					: 4;
	uint8_t		gx11_4					: 8;
	uint8_t		gy11_4					: 8;
	uint8_t		bx3_0					: 4;
	uint8_t		by3_0					: 4;
	uint8_t		bx11_4					: 8;
	uint8_t		by11_4					: 8;
	uint8_t		wx3_0					: 4;
	uint8_t		wy3_0					: 4;
	uint8_t		wx11_4					: 8;
	uint8_t		wy11_4					: 8;
	uint8_t		target_min_pq3_0		: 4;
	uint8_t		target_max_pq3_0		: 4;
	uint8_t		target_min_pq11_4		: 8;
	uint8_t		target_max_pq11_4		: 8;
	uint8_t		dm_major_version		: 4;
	uint8_t		dm_minor_version		: 4;
} HD_EDID_EXT_VSVDB_DV_V0_DATA_t;

typedef struct {
	uint8_t		version					: 3;
	uint8_t		dm_version				: 3;
	uint8_t		supports_2160p60hz		: 1;
	uint8_t		supports_yuv422_12bit	: 1;
	uint8_t		target_max_luminance	: 7;
	uint8_t		supports_global_dimming	: 1;
	uint8_t		target_min_luminance	: 7;
	uint8_t		colorimetry				: 1;
	uint8_t		rx						: 8;
	uint8_t		ry						: 8;
	uint8_t		gx						: 8;
	uint8_t		gy						: 8;
	uint8_t		bx						: 8;
	uint8_t		by						: 8;
} HD_EDID_EXT_VSVDB_DV_15V1_DATA_t;

typedef struct {
	uint8_t		version					: 3;
	uint8_t		dm_version				: 3;
	uint8_t		supports_2160p60hz		: 1;
	uint8_t		supports_yuv422_12bit	: 1;
	uint8_t		target_max_luminance	: 7;
	uint8_t		supports_global_dimming	: 1;
	uint8_t		target_min_luminance	: 7;
	uint8_t		colorimetry				: 1;
	uint8_t		unique_bx2_0			: 3;
	uint8_t		unique_by2_0			: 3;
	uint8_t		low_latency1_0			: 2;
	uint8_t		unique_gx6_0			: 7;
	uint8_t		unique_ry0				: 1;
	uint8_t		unique_gy6_0			: 7;
	uint8_t		unique_ry1				: 1;
	uint8_t		unique_rx4_0			: 5;
	uint8_t		unique_ry4_2			: 3;
} HD_EDID_EXT_VSVDB_DV_12V1_DATA_t;

typedef struct {
	uint8_t		version						: 3;
	uint8_t		dm_version					: 3;
	uint8_t		supports_backlight_control	: 1;
	uint8_t		supports_yuv422_12bit		: 1;
	uint8_t		target_min_pq_v2_4_0		: 5;
	uint8_t		supports_global_dimming		: 1;
	uint8_t		backlt_min_luma1_0			: 2;
	uint8_t		target_max_pq_v2_4_0		: 5;
	uint8_t		reserved					: 1;
	uint8_t		interface1_0				: 2;
	uint8_t		unique_gx6_0				: 7;
	uint8_t		supports_10b_12b_444_1		: 1;
	uint8_t		unique_gy6_0				: 7;
	uint8_t		supports_10b_12b_444_0		: 1;
	uint8_t		unique_rx4_0				: 5;
	uint8_t		unique_bx2_0				: 3;
	uint8_t		unique_ry4_0				: 5;
	uint8_t		unique_by2_0				: 3;
} HD_EDID_EXT_VSVDB_DV_V2_DATA_t;

typedef struct {
	uint8_t		version;
	HD_EDID_EXT_VSVDB_DV_V0_DATA_t		vsvdb_dv_v0;
	HD_EDID_EXT_VSVDB_DV_15V1_DATA_t	vsvdb_dv_15v1;
	HD_EDID_EXT_VSVDB_DV_12V1_DATA_t	vsvdb_dv_12v1;
	HD_EDID_EXT_VSVDB_DV_V2_DATA_t		vsvdb_dv_v2;
} HD_EDID_EXT_VSVDB_DV_DATA_t;

/* VSADB */
typedef struct {
	uint8_t		head_phone						: 1;
	uint8_t		output_configuration_support	: 3;
	uint8_t		f63								: 1;
	uint8_t		version							: 3;
	uint8_t		f77								: 1;
	uint8_t		sink_product_capabilities		: 7;
} HD_EDID_EXT_VSADB_DATA_t;

/* HDR */
typedef struct {
	uint8_t		support_eotf;
	uint8_t		md;
	uint8_t		luminance[HD_EDID_NUM_HDR_LUMINANCE_DATA];	/* MAX, MAX Frame-ave, MIN */
} HD_EDID_EXT_HDR_DATA_t;

typedef struct {
	uint8_t						hfscdb_data[HD_EDID_LEN_HFSCDB_DATA];
	HD_EDID_SCDS_EXTENSION_t	scds_data;
} HD_EDID_EXT_HFSCDB_DATA_t;

#endif	/* _HD_EDID_FORMAT_H_ */
