/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Driver include for the RICOH5B Tuner chip.
 *
 * Copyright 2015, 2016, 2021 Sony Corporation
 *
 */

#ifndef _RICOH5B_CFG_H
#define _RICOH5B_CFG_H

#include "st_cfg.h"

/******************************************************************************/
/*!
 * @brief X'tal Setting
 */
/******************************************************************************/
#define RICOH5B_X_TAL_32KHZ    0  /*!< :X'tal oscillation frequency 32kHz */
#define RICOH5B_X_TAL_12MHZ    1  /*!< :X'tal oscillation frequency 12MHz */

  /*-------------------------------------*/
  /* Please select X'tal from above list */
  /*-------------------------------------*/
#if (ST_RICOH5B_XTAL_TYPE == ST_RICOH5B_XTAL_32KHZ)
  #define RICOH5B_SELECT_X_TAL      RICOH5B_X_TAL_32KHZ
#elif (ST_RICOH5B_XTAL_TYPE == ST_RICOH5B_XTAL_12MHZ)
  #define RICOH5B_SELECT_X_TAL      RICOH5B_X_TAL_12MHZ
#else
  #error
#endif

/******************************************************************************/
/*!
 * @brief Audio Output Setting
 */
/******************************************************************************/
#define RICOH5B_AUDIO_OUTPUT_ANALOG    0  /*!< :analog audio output */
#define RICOH5B_AUDIO_OUTPUT_IIS_32FS  1  /*!< :IIS 32fs mode */
#define RICOH5B_AUDIO_OUTPUT_IIS_64FS  2  /*!< :IIS 64fs mode */

/*----------------------------------------------------*/
/* Please select audio output setting from above list */
/*----------------------------------------------------*/
#define RICOH5B_SELECT_AUDIO_OUTPUT    RICOH5B_AUDIO_OUTPUT_ANALOG

#endif  /* _RICOH5B_CFG_H */

/* end of ricoh5b_cfg.h */
