/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Driver include for the RICOH5B Tuner chip.
 *
 * Copyright 2015, 2016, 2021 Sony Corporation
 *
 */
#ifndef _RICOH5B_DEFINE_H
#define _RICOH5B_DEFINE_H

/******************************************************************************/
/* include file                                                               */
/******************************************************************************/
#include <linux/string.h>
#include "stdrv_if_define.h"
#include "ricoh5b_cfg.h"

/******************************************************************************/
/* object generation control and special settings                             */
/******************************************************************************/
/******************************************************************************/
/* symbolic constant definition                                               */
/******************************************************************************/

#define RICOH5B_NULL              (void *)0
#define RICOH5B_FREQ_UNKNOWN      0xFFFF

/* Band Status */
enum RICOH5B_BAND_STATUS {
	RICOH5B_BAND_IDLE  = STDRV_BAND_IDLE,
				/*!< :Default State (BAND is not selected) */
	RICOH5B_BAND_FM    = STDRV_BAND_FM,    /*!< :FM */
	RICOH5B_BAND_AM    = STDRV_BAND_AM     /*!< :AM */
};

/* Initialize done/not status */
enum RICOH5B_INIT_STATUS {
	RICOH5B_INIT_NOT,
	RICOH5B_INIT_DONE
};

/* seek status */
enum RICOH5B_SEEK_STATUS {
	RICOH5B_SEEK_OFF,
	RICOH5B_SEEK_ON
};

/* audio output volume */
enum RICOH5B_VOLUME {
	RICOH5B_VOLUME_0DB        = STDRV_VOLUME_0DB,        /*!< :0dB     */
	RICOH5B_VOLUME_MINUS_3DB  = STDRV_VOLUME_MINUS_3DB,  /*!< :-3dB    */
	RICOH5B_VOLUME_MINUS_4DB  = STDRV_VOLUME_MINUS_4DB,  /*!< :-4dB    */
	RICOH5B_VOLUME_MINUS_5DB  = STDRV_VOLUME_MINUS_5DB,  /*!< :-5dB    */
	RICOH5B_VOLUME_UNKNOWN    = STDRV_VOLUME_UNKNOWN     /*!< :unknown */
};

/* immunity measure ENABLE / DISABLE */
enum RICOH5B_IMMUNITY {
	RICOH5B_IMMUNITY_DISABLE    = STDRV_IMMUNITY_DISABLE,
				/*!< :Immunity Measure is DISABLE          */
	RICOH5B_IMMUNITY_ENABLE     = STDRV_IMMUNITY_ENABLE,
				/*!< :Immunity Measure is ENABLE           */
	RICOH5B_IMMUNITY_ENABLE_KR  = STDRV_IMMUNITY_ENABLE_KR,
				/*!< :Immunity Measure is ENABLE for KOREA */
	RICOH5B_IMMUNITY_UNKNOWN    = STDRV_IMMUNITY_UNKNOWN
				/*!< :unknown                              */
};

enum RICOH5B_IF_TYPE {
	RICOH5B_IF_200K,
	RICOH5B_IF_300K,
	RICOH5B_IF_400K
};

#endif  /* _RICOH5B_DEFINE_H */
/* end of ricoh5b_define.h */
