/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Driver include for the RICOH5B Tuner chip.
 *
 * Copyright 2015, 2016, 2021, 2022 Sony Corporation
 *
 */

#ifndef _ST_CFG_H_
#define _ST_CFG_H_

/******************************************************************************/
/*              <<  Debug Setting  >>                  */
/******************************************************************************/
#define RICOH5B_CONF_DEBUG_VERBOSE  2
#define RICOH5B_CONF_DEBUG_ON       1
#define RICOH5B_CONF_DEBUG_OFF      0
#define RICOH5B_CONF_DEBUG          RICOH5B_CONF_DEBUG_ON

#define RICOH5B_TUNER_701       0
#define RICOH5B_TUNER_801       1
#define RICOH5B_USE_TUNER      RICOH5B_TUNER_701

/*----------------------------------------------*/
/*  RICOH 5BXXX X'tal setting          */
/*----------------------------------------------*/
/* Please select X'tal oscillation frequency of your enviroment. */
#define  ST_RICOH5B_XTAL_32KHZ  1  /* 32kHz */
				/* All 2012 models used this X'tal. */
#define  ST_RICOH5B_XTAL_12MHZ  2  /* 12MHz */

#if RICOH5B_USE_TUNER
#define  ST_RICOH5B_XTAL_TYPE  ST_RICOH5B_XTAL_32KHZ
#else
#define  ST_RICOH5B_XTAL_TYPE  ST_RICOH5B_XTAL_12MHZ
#endif

#endif  /* _ST_CFG_H_ */
