/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Driver include for the RICOH5B Tuner chip.
 *
 * Copyright 2015, 2016, 2021 Sony Corporation
 *
 */
#ifndef _STDRV_IF_DEFINE_H
#define _STDRV_IF_DEFINE_H

/******************************************************************************/
/* include file                                                               */
/******************************************************************************/
/******************************************************************************/
/* object generation control and special settings                             */
/******************************************************************************/
/******************************************************************************/
/* symbolic constant definition                                               */
/******************************************************************************/

/* unknown frequecny */
#define STDRV_FREQ_UNKNOWN        0xFFFF

/*! @enum STDRV_POWER_STATUS
 *        Power Status
 */
enum STDRV_POWER_STATUS {
	STDRV_POWER_OFF    = 0,  //!< :Power OFF
	STDRV_POWER_ON     = 1   //!< :Power ON
};

/*! @enum STDRV_BAND_STATUS
 *        TUNER BAND
 */
enum STDRV_BAND_STATUS {
	STDRV_BAND_IDLE    = 0,  //!< :Default State (BAND is not selected)
	STDRV_BAND_FM      = 1,  //!< :FM
	STDRV_BAND_AM      = 2   //!< :AM
};

/*! @enum STDRV_STATION_STATUS
 *        station detected / undetect in each band
 */
enum STDRV_STATION_STATUS {
	STDRV_STATION_UNDETECT  = 0,    //!< :Station is undetect
	STDRV_STATION_DETECTED  = 1,    //!< :Station is detected
	STDRV_STATION_UNKNOWN   = 0xFF  //!< :unknown
};

/*! @enum STDRV_AUDIO_STATUS
 *        audio status in each band
 */
enum STDRV_AUDIO_STATUS {
	STDRV_AUDIO_MONO     = 0,    //!< :Mono Broadcasting
	STDRV_AUDIO_STEREO   = 1,    //!< :Stereo Broadcasting
	STDRV_AUDIO_UNKNOWN  = 0xFF  //!< :unknown
};

/*! @enum STDRV_MONO_MODE
 *        force mono output mode
 */
enum STDRV_MONO_MODE {
	STDRV_MONO_OFF      = 0,    //!< :Force mono output is OFF
	STDRV_MONO_ON       = 1,    //!< :Force mono output is ON
	STDRV_MONO_UNKNOWN  = 0xFF  //!< :unknown
};

/*! @enum STDRV_VOLUME
 *        audio output volume
 */
enum STDRV_VOLUME {
	STDRV_VOLUME_0DB        = 0,    //!< :0dB
	STDRV_VOLUME_MINUS_3DB  = 1,    //!< :-3dB
	STDRV_VOLUME_MINUS_4DB  = 2,    //!< :-4dB
	STDRV_VOLUME_MINUS_5DB  = 3,    //!< :-5dB
	STDRV_VOLUME_UNKNOWN    = 0xFF  //!< :unknown
};

/*! @enum STDRV_IMMUNITY
 *        immunity measure ENABLE / DISABLE
 */
enum STDRV_IMMUNITY {
	STDRV_IMMUNITY_DISABLE   = 0, //!< :Immunity Measure is Disable
	STDRV_IMMUNITY_ENABLE    = 1, //!< :Immunity Measure is Enable
	STDRV_IMMUNITY_ENABLE_KR = 2, //!< :Immunity Measure is Enable for KOREA
	STDRV_IMMUNITY_UNKNOWN   = 0xFF  //!< :unknown
};

#endif  /* _STDRV_IF_DEFINE_H */

/* end of stdrv_if_define.h */
