/* SPDX-License-Identifier: GPL-2.0
 *
 * Copyright 2019 Sony Video & Sound Products Inc.
 * Copyright 2019 Sony Home Entertainment & Sound Products Inc.
 *
 */

#include <logo/icx_logo.h>

void __init reserve_kernel_logo_data(void)
{
	if (!memblock_is_region_memory(ICX_LOGO_ADDR_2G, ICX_LOGO_SIZE)) {
		pr_err("[kernel logo] 0x%lx+0x%08x is not a memory region\n",
			(ulong)ICX_LOGO_ADDR_2G, ICX_LOGO_SIZE);
		return;
	}

	if (memblock_is_region_reserved(ICX_LOGO_ADDR_2G, ICX_LOGO_SIZE)) {
		pr_err("[kernel logo] logo fb is overlapped\n");
		return;
	}

	if (memblock_reserve(ICX_LOGO_ADDR_2G, ICX_LOGO_SIZE) < 0) {
		pr_err("[kernel logo] memblock_reserve failed\n");
		return;
	}

	pr_info("[kernel logo] Reserved %dKB at 0x%lx for kernel logo\n",
		ICX_LOGO_SIZE >> 10, (ulong)ICX_LOGO_ADDR_2G);
}

int load_fb_from_boot_loader(void __iomem *fb_dst, ulong screen_size)
{
	void *src_virt;

	if (!fb_dst) {
		pr_err("[kernel logo] Addr of framebuffer is invalid.\n");
		return -1;
	}

	if (!screen_size || screen_size > ICX_LOGO_SIZE) {
		pr_err("[kernel logo] Screen size is invalid.\n");
		return -1;
	}

	if (!memblock_is_region_memory(ICX_LOGO_ADDR_2G, ICX_LOGO_SIZE)) {
		pr_err("[kernel logo] 0x%08lx+0x%08x is not a memory region\n",
			(ulong)ICX_LOGO_ADDR_2G, ICX_LOGO_SIZE);
		return -1;
	}

	if (!memblock_is_region_reserved(ICX_LOGO_ADDR_2G, ICX_LOGO_SIZE)) {
		pr_err("[kernel logo] Memory for logo not reserved.\n");
		return -1;
	}

	src_virt = phys_to_virt(ICX_LOGO_ADDR_2G);
	memcpy((void *)fb_dst, src_virt, screen_size);

	memblock_free(ICX_LOGO_ADDR_2G, ICX_LOGO_SIZE);

	pr_info("[kernel logo] Loaded fb from boot loader.\n");

	return 0;
}
