/* SPDX-License-Identifier: GPL-2.0
 *
 * Copyright 2019 Sony Video & Sound Products Inc.
 * Copyright 2019 Sony Home Entertainment & Sound Products Inc.
 *
 */

#ifndef ICX_LOGO_H
#define ICX_LOGO_H
#include <linux/types.h>
#include <linux/sizes.h>
#include <linux/memblock.h>

/* Reserved framebuffer for kernel logo from bootloader */
#define ICX_LOGO_SIZE (1920 * 1080 * 4)
/* Addr for kernel logo (base_addr + ram_size - (36MB(rpmsg + tee) + framebuffer)) */
#define ICX_LOGO_ADDR_2G \
	(phys_addr_t)(memblock_start_of_DRAM() +\
	 SZ_2G - (SZ_1M * 36 + ICX_LOGO_SIZE))

#ifdef CONFIG_LOGO_ICX
void __init reserve_kernel_logo_data(void);
int load_fb_from_boot_loader(void __iomem *fb_dst, ulong screen_size);
#else
void __init reserve_kernel_logo_data(void) {}
int load_fb_from_boot_loader(void __iomem *fb_dst, ulong screen_size)
{
	return 0;
}
#endif

#endif /* ICX_LOGO_H */
