// SPDX-License-Identifier: GPL-2.0
/*
 * es9080_i2c.c
 *
 * ES9080 Codec I2C driver
 *
 * Copyright 2021 Sony Corporation
 */
#include <linux/i2c.h>
#include <linux/init.h>
#include <linux/module.h>
#include <sound/soc.h>
#include "es9080.h"

static int es9080_i2c_probe(struct i2c_client *i2c,
			     const struct i2c_device_id *id)
{
	int ret;

	TRACE("enter(0x%x)\n", i2c->addr);
	ret = es9080_regist_client(i2c);
	if (ret) {
		dev_dbg(&i2c->dev, "failed to regist_regmap(%d)\n", ret);
		return ret;
	}

	TRACE("done(0x%x)\n", i2c->addr);
	return 0;
}

static int es9080_i2c_remove(struct i2c_client *i2c)
{
	TRACE("enter(0x%x)\n", i2c->addr);
	es9080_free_client(i2c);
	TRACE("done(0x%x)\n", i2c->addr);
	return 0;
}

static const struct i2c_device_id es9080_i2c_id[] = {
	{ "es9080_i2c", },
	{ }
};
MODULE_DEVICE_TABLE(i2c, es9080_i2c_id);

static const struct of_device_id es9080_i2c_of_match[] = {
	{ .compatible = "ess,es9080_i2c", },
	{ }
};
MODULE_DEVICE_TABLE(of, es9080_i2c_of_match);

static struct i2c_driver es9080_i2c_driver = {
	.probe		= es9080_i2c_probe,
	.remove		= es9080_i2c_remove,
	.id_table	= es9080_i2c_id,
	.driver		= {
		.name	= "es9080_i2c",
		.of_match_table = es9080_i2c_of_match,
	},
};
module_i2c_driver(es9080_i2c_driver);

MODULE_DESCRIPTION("es9080 codec I2C driver");
MODULE_AUTHOR("Sony Corporation");
MODULE_LICENSE("GPL v2");
