/*
 * Copyright 2017 NXP
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

/*!
 * @file  devices/MX8/include/MX8_extension.h
 *
 * @brief SDK 1.3 Extension
 *
 * Header file containing the SDK 1.3 extension for i.MX8.
 */

/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __MX8_EXTENSION_H__
#define __MX8_EXTENSION_H__

/*!
 * @addtogroup Peripheral_access_layer Device Peripheral Access Layer
 * @{
 */


/*
 * MX8 MU
 *
 * MU
 *
 * Registers defined in this header file:
 * - MU_TR - Transmit Register n
 * - MU_RR - Receive Register n
 * - MU_SR - Status Register
 * - MU_CR - Control Register
 */

/*******************************************************************************
 * MU_TR - Transmit Register n
 ******************************************************************************/

/*!
 * @brief MU_TR - Transmit Register n (RW)
 *
 * Reset value: 0x00000000U
 *
 * Use Processor A/B Transmit Register n (TRn, 32-bit, write-only) to transmit a
 * message or data to the Processor B/A. You can only write to the TRn register
 * when the TEn bit in SR register is set to "1". Reading the TRn register
 * returns all zeros.
 */
/*!
 * @name Constants and macros for entire MU_TR register
 */
/*@{*/
#define MU_RD_TR(base, index)    (MU_TR_REG(base, index))
#define MU_WR_TR(base, index, value) (MU_TR_REG(base, index) = (value))
#define MU_RMW_TR(base, index, mask, value) (MU_WR_TR(base, index, (MU_RD_TR(base, index) & ~(mask)) | (value)))
#define MU_SET_TR(base, index, value) (BME_OR32(&MU_TR_REG(base, index), (uint32_t)(value)))
#define MU_CLR_TR(base, index, value) (BME_AND32(&MU_TR_REG(base, index), (uint32_t)(~(value))))
#define MU_TOG_TR(base, index, value) (BME_XOR32(&MU_TR_REG(base, index), (uint32_t)(value)))
/*@}*/

/*******************************************************************************
 * MU_RR - Receive Register n
 ******************************************************************************/

/*!
 * @brief MU_RR - Receive Register n (RO)
 *
 * Reset value: 0x00000000U
 *
 * Use Processor A/B Receive Register n (RRn, 32-bit, read-only) to receive a
 * message or data from the Processor B/A. Data written to the Processor B/A TRn
 * register is immediately reflected in the Processor A/B RRn register. You can
 * only read the RRn register when the RFn bit in the SR register is set to "1".
 * Writing to the RRn register generates an error response to the Processor A/B.
 */
/*!
 * @name Constants and macros for entire MU_RR register
 */
/*@{*/
#define MU_RD_RR(base, index)    (MU_RR_REG(base, index))
/*@}*/

/*******************************************************************************
 * MU_SR - Status Register
 ******************************************************************************/

/*!
 * @brief MU_SR - Status Register (RW)
 *
 * Reset value: 0x00F00080U
 *
 * Use the Processor A/B Status Register (SR, 32-bit, read-write) to show
 * interrupt status from the Processor B/A, general purpose flags , and to set dual
 * function control-status bits. Some dual-purpose bits are set by the MU logic, and
 * cleared by the Processor A/B-side programmer Other dual-purpose bits are set
 * by the Processor A/B-side programmer, and cleared by the MU logic.
 */
/*!
 * @name Constants and macros for entire MU_SR register
 */
/*@{*/
#define MU_RD_SR(base)           (MU_SR_REG(base))
#define MU_WR_SR(base, value)    (MU_SR_REG(base) = (value))
#define MU_RMW_SR(base, mask, value) (MU_WR_SR(base, (MU_RD_SR(base) & ~(mask)) | (value)))
/*@}*/

/*
 * Constants & macros for individual MU_SR bitfields
 */

/*!
 * @name Register MU_SR, field Fn[2:0] (RW)
 *
 * For n = {0, 1, 2} Processor A/B Side Flag n. (Read-only) Fn bit is the
 * Processor A/B side flag that reflects the values written to the Fn bit in the
 * Processor B/A control register. Every time that the Processor B/A Fn bit in the CR
 * register is written, the Processor B/A Fn bit in the CR register write event
 * updates the Fn bit after the event update latency, which is measured in terms of
 * the number of clocks of the Processor B/A and the Processor A/B.
 *
 * Values:
 * - 0b000 - Processor B/A Fn bit in the CR register is written 0 (default).
 * - 0b001 - Processor B/A Fn bit in the CR register is written 1.
 */
/*@{*/
/*! @brief Read current value of the MU_SR_Fn field. */
#define MU_RD_SR_Fn(base)    ((MU_SR_REG(base) & MU_SR_Fn_MASK) >> MU_SR_Fn_SHIFT)

/*! @brief Set the Fn field to a new value. */
#define MU_WR_SR_Fn(base, value) (MU_RMW_SR(base, (MU_SR_Fn_MASK | MU_SR_NMIC_MASK), MU_SR_Fn(value)))
/*@}*/

/*!
 * @name Register MU_SR, field EP[4] (RW)
 *
 * Processor A/B Side Event Pending. (Read-only) EP bit is set to "1" when the
 * Processor A/B side mechanism sends an event update request to the Processor B/A
 * side. EP bit is cleared when the event update acknowledge is received. An
 * "event" is any hardware message that is reflected in the Processor B/A SR
 * register on the Processor B/A side (for example, "transmit register 0 written").
 * During normal operations, you do not have to deal with the state of the EP bit
 * because the event update mechanism works automatically. To ensure events have
 * been posted to Processor B/A before entering STOP mode, you should verify that
 * the EP bit is cleared. If EP bit is set to "1", you should wait and continue to
 * poll it (EP bit) before entering STOP mode. Reading the Processor A/B SR
 * register (to check the EP bit) should be the last access to the MU that should be
 * performed before entering STOPor WAIT modes; otherwise, the EP bit may be set
 * by subsequent additional actions. The EP bit is cleared when the MU resets.
 *
 * Values:
 * - 0b0 - The Processor A-side event is not pending (default).
 * - 0b1 - The Processor A-side event is pending.
 */
/*@{*/
/*! @brief Read current value of the MU_SR_EP field. */
#define MU_RD_SR_EP(base)    ((MU_SR_REG(base) & MU_SR_EP_MASK) >> MU_SR_EP_SHIFT)

/*! @brief Set the EP field to a new value. */
#define MU_WR_SR_EP(base, value) (MU_RMW_SR(base, (MU_SR_EP_MASK | MU_SR_NMIC_MASK), MU_SR_EP(value)))
/*@}*/

/*!
 * @name Register MU_SR, field PM[6:5] (RW)
 *
 * Processor B/A Power Mode. (Read-only) PM[1:0] bits indicate the Processor B/A
 * power mode. The Processor B/A Power Mode is platform-specific.
 *
 * Values:
 * - 0b00 - The Processor B/A is in Run Mode.
 * - 0b01 - The Processor B/A is in WAIT Mode.
 * - 0b10 - The Processor B/A is in STOP/VLPS Mode.
 * - 0b11 - The Processor B/A is in LLS/VLLS Mode.
 */
/*@{*/
#define MU_SR_PM_RUN                   (0U)          /*!< Bit field value for MU_SR_PM: The Processor B/A is in Run Mode. */
#define MU_SR_PM_WAIT                  (0x1U)        /*!< Bit field value for MU_SR_PM: The Processor B/A is in WAIT Mode. */
#define MU_SR_PM_STOP                  (0x2U)        /*!< Bit field value for MU_SR_PM: The Processor B/A is in STOP/VLPS Mode. */
#define MU_SR_PM_DSM                   (0x3U)        /*!< Bit field value for MU_SR_PM: The Processor B/A is in LLS/VLLS Mode. */
/*! @brief Read current value of the MU_SR_PM field. */
#define MU_RD_SR_PM(base)    ((MU_SR_REG(base) & MU_SR_PM_MASK) >> MU_SR_PM_SHIFT)

/*! @brief Set the PM field to a new value. */
#define MU_WR_SR_PM(base, value) (MU_RMW_SR(base, (MU_SR_PM_MASK | MU_SR_NMIC_MASK), MU_SR_PM(value)))
/*@}*/

/*!
 * @name Register MU_SR, field FUP[8] (RW)
 *
 * Processor A/B Flags Update Pending. (Read-only) FUP bit is set to "1" when
 * the Processor A/B side sends a Flags Update request to the Processor B/A side. A
 * Flags Update request is generated when there is a change to the Fn[2:0] bits
 * of the Processor A/B CR register. No flag update changes are allowed while the
 * FUP bit is set to "1". Any write to the Fn[2:0] bits of the Processor A/B CR
 * register, while the FUP bit is set to "1", will not generate a Flags Update
 * event, and the Fn[2:0] bits will stay unchanged. FUP bit is cleared when this
 * Flags Update request is internally acknowledged (that the flag is updated) from
 * the MU Processor B/A side, and during MU reset.
 *
 * Values:
 * - 0b0 - No flags updated, initiated by the Processor A, in progress (default)
 * - 0b1 - Processor A/B initiated flags update, processing
 */
/*@{*/
/*! @brief Read current value of the MU_SR_FUP field. */
#define MU_RD_SR_FUP(base)   ((MU_SR_REG(base) & MU_SR_FUP_MASK) >> MU_SR_FUP_SHIFT)

/*! @brief Set the FUP field to a new value. */
#define MU_WR_SR_FUP(base, value) (MU_RMW_SR(base, (MU_SR_FUP_MASK | MU_SR_NMIC_MASK), MU_SR_FUP(value)))
/*@}*/

/*!
 * @name Register MU_SR, field TEn[23:20] (RW)
 *
 * For n = {0, 1, 2, 3} Processor A/B Transmit Register n Empty. (Read-only) The
 * TEn bit is set to "1" after the Processor B/A RRn register is read on the
 * Processor B/A side. After the TEn bit is set to "1", the TEn bit signals the
 * Processor A/B side that the Processor A/B TRn register is ready to be written on
 * the Processor A/B side, and a Transmit n interrupt is issued on the Processor
 * A/B side (if the TEn bit in the Processor A/B CR register is set to "1"). TEn
 * bit is cleared after the Processor A/B TRn register is written on the Processor
 * A/B side. TEn bit is set to "1" when the MU is reset.
 *
 * Values:
 * - 0b0000 - Processor A/B TRn register is not empty.
 * - 0b0001 - Processor A/B TRn register is empty (default).
 */
/*@{*/
/*! @brief Read current value of the MU_SR_TEn field. */
#define MU_RD_SR_TEn(base)   ((MU_SR_REG(base) & MU_SR_TEn_MASK) >> MU_SR_TEn_SHIFT)

/*! @brief Set the TEn field to a new value. */
#define MU_WR_SR_TEn(base, value) (MU_RMW_SR(base, (MU_SR_TEn_MASK | MU_SR_NMIC_MASK), MU_SR_TEn(value)))
/*@}*/

/*!
 * @name Register MU_SR, field RFn[27:24] (RW)
 *
 * For n = {0, 1, 2, 3} Processor A/B Receive Register n Full. (Read-only) The
 * RFn bit is set to "1" when the Processor B/A TRn register is written on the
 * Processor B/A side. After the RFn bit is set to "1", the RFn bit signals the
 * Processor A/B side that new data is ready to be read by the Processor A/B in the
 * Processor A/B RRn register, and a Receive n interrupt is issued on the
 * Processor A/B side (if the RIEn bit in the Processor A/B CR register has been set to
 * "1"). RFn bit is cleared when the Processor A/B RRn register is read, and when
 * the MU is reset.
 *
 * Values:
 * - 0b0000 - Processor A/B RRn register is not full (default).
 * - 0b0001 - Processor A/B RRn register has received data from Processor B/A
 *     TRn register and is ready to be read by the Processor A/B.
 */
/*@{*/
/*! @brief Read current value of the MU_SR_RFn field. */
#define MU_RD_SR_RFn(base)   ((MU_SR_REG(base) & MU_SR_RFn_MASK) >> MU_SR_RFn_SHIFT)

/*! @brief Set the RFn field to a new value. */
#define MU_WR_SR_RFn(base, value) (MU_RMW_SR(base, (MU_SR_RFn_MASK | MU_SR_NMIC_MASK), MU_SR_RFn(value)))
/*@}*/

/*!
 * @name Register MU_SR, field GIPn[31:28] (RW)
 *
 * For n = {0, 1, 2, 3} Processor A/B General Interrupt Request n Pending.
 * (Read-Write) GIPn bit signals the Processor A/B that the GIRn bit in the BCR
 * register on the Processor B-side was set from "0" to "1". If the GIEn bit in the ACR
 * register is set to "1", a General Interrupt n request is issued. The GIPn bit
 * is cleared by writing it back as "1". Writing "0", or writing "1" when the
 * GIPn bit is cleared is ignored. Use this feature in the interrupt routine, where
 * the GIPn bit is cleared in order to de-assert the interrupt request source at
 * the interrupt controller. An example of a proper bit clearing sequence is:
 * clear Processor A register, set the desired bit in it (Processor A register),
 * and write it to the ASR register, thus clearing the GIPn bit. GIPn bit is
 * cleared when the MU is reset.
 *
 * Values:
 * - 0b0000 - Processor A/B general purpose interrupt n is not pending. (default)
 * - 0b0001 - Processor A/B general purpose interrupt n is pending.
 */
/*@{*/
/*! @brief Read current value of the MU_SR_GIPn field. */
#define MU_RD_SR_GIPn(base)  ((MU_SR_REG(base) & MU_SR_GIPn_MASK) >> MU_SR_GIPn_SHIFT)

/*! @brief Set the GIPn field to a new value. */
#define MU_WR_SR_GIPn(base, value) (MU_RMW_SR(base, (MU_SR_GIPn_MASK | MU_SR_NMIC_MASK), MU_SR_GIPn(value)))
/*@}*/

/*******************************************************************************
 * MU_CR - Control Register
 ******************************************************************************/

/*!
 * @brief MU_CR - Control Register (RW)
 *
 * Reset value: 0x00000100U
 *
 * Use the Control Register (CR, 32-bit, read-write) to enable the MU interrupts
 * on the Processor A/B-side, and trigger events and interrupts on the Processor
 * B/A-side (general purpose interrupt, flag update).
 */
/*!
 * @name Constants and macros for entire MU_CR register
 */
/*@{*/
#define MU_RD_CR(base)           (MU_CR_REG(base))
#define MU_WR_CR(base, value)    (MU_CR_REG(base) = (value))
#define MU_RMW_CR(base, mask, value) (MU_WR_CR(base, (MU_RD_CR(base) & ~(mask)) | (value)))
/*@}*/

/*
 * Constants & macros for individual MU_CR bitfields
 */

/*!
 * @name Register MU_CR, field Fn[2:0] (RW)
 *
 * For n = {0, 1, 2} Processor A/B to Processor B/A Flag n. (Read-Write) Fn bit
 * is a read-write flag that is reflected in Fn bit in the Processor B/A SR
 * register on the Processor B/A side. Fn bit is cleared when the MU resets.
 *
 * Values:
 * - 0b000 - Clears the Fn bit in the SR register.
 * - 0b001 - Sets the Fn bit in the SR register.
 */
/*@{*/
/*! @brief Read current value of the MU_CR_Fn field. */
#define MU_RD_CR_Fn(base)    ((MU_CR_REG(base) & MU_CR_Fn_MASK) >> MU_CR_Fn_SHIFT)

/*! @brief Set the Fn field to a new value. */
#define MU_WR_CR_Fn(base, value) (MU_RMW_CR(base, MU_CR_Fn_MASK, MU_CR_Fn(value)))
/*@}*/

/*!
 * @name Register MU_CR, field NMI[3] (RW)
 *
 * Processor B/A Non-maskable Interrupt. (Read-Write) When NMI bit is set to
 * "1", it initiates a Non-Maskable Interrupt to the Processor B/A. NMI bit is
 * cleared by the MU after the Processor B/A asserts the NMIC bit in the Processor B/A
 * SR register. After the NMI bit is cleared, the Processor A/B can initiate
 * another non-maskable interrupt to the Processor B/A. The NMI bit is cleared when
 * the MU resets.
 *
 * Values:
 * - 0b0 - Non-maskable interrupt is not issued to the Processor B/A by the
 *     Processor A/B (default).
 * - 0b1 - Non-maskable interrupt is issued to the Processor B/A by the
 *     Processor A/B.
 */
/*@{*/
/*! @brief Read current value of the MU_CR_NMI field. */
#define MU_RD_CR_NMI(base)   ((MU_CR_REG(base) & MU_CR_NMI_MASK) >> MU_CR_NMI_SHIFT)

/*! @brief Set the NMI field to a new value. */
#define MU_WR_CR_NMI(base, value) (MU_RMW_CR(base, MU_CR_NMI_MASK, MU_CR_NMI(value)))
/*@}*/

/*!
 * @name Register MU_CR, field MUR[5] (RW)
 *
 * Processor A MU Reset. Setting MUR bit to "1" resets both the Processor B and
 * the Processor A sides of the MU module, forcing all control and status
 * registers to return to their default values and all internal states to be cleared.
 * Before setting the MUR bit to "1", it is advisable to interrupt the Processor B
 * , because setting the MUR bit may affect the ongoing Processor B program. MUR
 * bit can only be written as "1". MUR bit is always read as "0". MUR bit is
 * cleared during the MU reset sequence. This bit is only available on the Processor
 * A side.
 *
 * Values:
 * - 0b0 - N/A. Self clearing bit (default).
 * - 0b1 - Asserts the Processor A MU reset.
 */
/*@{*/
/*! @brief Read current value of the MU_CR_MUR field. */
#define MU_RD_CR_MUR(base)   ((MU_CR_REG(base) & MU_CR_MUR_MASK) >> MU_CR_MUR_SHIFT)

/*! @brief Set the MUR field to a new value. */
#define MU_WR_CR_MUR(base, value) (MU_RMW_CR(base, MU_CR_MUR_MASK, MU_CR_MUR(value)))
/*@}*/

/*!
 * @name Register MU_CR, field GIRn[19:16] (RW)
 *
 * For n = {0, 1, 2, 3} Processor A/B General Purpose Interrupt Request n.
 * (Read-Write) Writing "1" to the GIRn bit sets the GIPn bit in the Processor B/A SR
 * register on the Processor B-side. If the GIEn bit in the Processor B/A CR
 * register is set to "1" on the Processor B/A side, a General Purpose Interrupt n
 * request is triggered. The GIRn bit is cleared if the GIPn bit (in the Processor
 * B/A SR register on the Processor B/A side) is cleared by writing it (GIPn bit)
 * as "1", thereby signalling the Processor A/B that the interrupt was accepted
 * (cleared by the software). The GIPn bit cannot be written as "0" on the
 * Processor A/B side. To ensure proper operations, you must verify that the GIRn bit
 * is cleared (meaning that there is no pending interrupt) before setting it (GIRn
 * bit). GIRn bit is cleared when the MU resets.
 *
 * Values:
 * - 0b0000 - Processor A/B General Interrupt n is not requested to the
 *     Processor B/A (default).
 * - 0b0001 - Processor A/B General Interrupt n is requested to the Processor
 *     B/A.
 */
/*@{*/
/*! @brief Read current value of the MU_CR_GIRn field. */
#define MU_RD_CR_GIRn(base)  ((MU_CR_REG(base) & MU_CR_GIRn_MASK) >> MU_CR_GIRn_SHIFT)

/*! @brief Set the GIRn field to a new value. */
#define MU_WR_CR_GIRn(base, value) (MU_RMW_CR(base, MU_CR_GIRn_MASK, MU_CR_GIRn(value)))
/*@}*/

/*!
 * @name Register MU_CR, field TIEn[23:20] (RW)
 *
 * For n = {0, 1, 2, 3} Processor A/B Transmit Interrupt Enable n. (Read-Write)
 * TIEn bit enables Processor A/B Transmit Interrupt n. If TIEn bit is set to "1"
 * (enabled), then an Processor A/B Transmit Interrupt n request is issued when
 * the TEn bit in the Processor A/B SR register is set to "1". If TIEn bit is
 * cleared (disabled), then the value of the TEn bit is ignored and no Processor A/B
 * Transmit Interrupt n request will be issued. TIEn bit is cleared when the MU
 * resets.
 *
 * Values:
 * - 0b0000 - Disables Processor A/B Transmit Interrupt n. (default)
 * - 0b0001 - Enables Processor A/B Transmit Interrupt n.
 */
/*@{*/
/*! @brief Read current value of the MU_CR_TIEn field. */
#define MU_RD_CR_TIEn(base)  ((MU_CR_REG(base) & MU_CR_TIEn_MASK) >> MU_CR_TIEn_SHIFT)

/*! @brief Set the TIEn field to a new value. */
#define MU_WR_CR_TIEn(base, value) (MU_RMW_CR(base, MU_CR_TIEn_MASK, MU_CR_TIEn(value)))
/*@}*/

/*!
 * @name Register MU_CR, field RIEn[27:24] (RW)
 *
 * For n = {0, 1, 2, 3} Processor A/B Receive Interrupt Enable n. (Read-Write)
 * RIEn bit enables Processor A/B Receive Interrupt n. If RIEn bit is set to "1"
 * (enabled), then an Processor A/B Receive Interrupt n request is issued when the
 * RFn bit in the Processor A/B SR register is set to "1". If RIEn bit is
 * cleared (disabled), then the value of the RFn bit is ignored and no Processor A/B
 * Receive Interrupt n request will be issued. RIEn bit is cleared when the MU
 * resets.
 *
 * Values:
 * - 0b0000 - Disables Processor A/B Receive Interrupt n. (default)
 * - 0b0001 - Enables Processor A/B Receive Interrupt n.
 */
/*@{*/
/*! @brief Read current value of the MU_CR_RIEn field. */
#define MU_RD_CR_RIEn(base)  ((MU_CR_REG(base) & MU_CR_RIEn_MASK) >> MU_CR_RIEn_SHIFT)

/*! @brief Set the RIEn field to a new value. */
#define MU_WR_CR_RIEn(base, value) (MU_RMW_CR(base, MU_CR_RIEn_MASK, MU_CR_RIEn(value)))
/*@}*/

/*!
 * @name Register MU_CR, field GIEn[31:28] (RW)
 *
 * For n = {0, 1, 2, 3} Processor A/B General Purpose Interrupt Enable n.
 * (Read-Write) GIEn bit enables Processor A/B General Interrupt n. If GIEn bit is set
 * to "1" (enabled), then a General Interrupt n request is issued when the GIPn
 * bit in the Processor A/B SR register is set to "1". If GIEn is cleared
 * (disabled), then the value of the GIPn bit is ignored and no General Interrupt n
 * request will be issued. GIEn bit is cleared when the MU resets.
 *
 * Values:
 * - 0b0000 - Disables Processor A/B General Interrupt n. (default)
 * - 0b0001 - Enables Processor A/B General Interrupt n.
 */
/*@{*/
/*! @brief Read current value of the MU_CR_GIEn field. */
#define MU_RD_CR_GIEn(base)  ((MU_CR_REG(base) & MU_CR_GIEn_MASK) >> MU_CR_GIEn_SHIFT)

/*! @brief Set the GIEn field to a new value. */
#define MU_WR_CR_GIEn(base, value) (MU_RMW_CR(base, MU_CR_GIEn_MASK, MU_CR_GIEn(value)))
/*@}*/


#endif /* __MX8_EXTENSION_H__ */
/* EOF */
