/*
 * Copyright 2015-2016 Freescale Semiconductor, Inc.
 * Copyright 2017 NXP
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#ifndef _IMX8_LVDS_H_
#define _IMX8_LVDS_H_

#define IMX_LVDS_SET_FIELD(__field__, __value__) (((__value__) << (__field__ ## _SHIFT)) & (__field__ ## _MASK))
#define IMX_LVDS_GET_FIELD(__field__, __reg__) (((__reg__) & (__field__ ## _MASK)) >> (__field__  ## _SHIFT))

#define IMX_LVDS_SET(__reg__)   (reg+0x4)
#define IMX_LVDS_CLEAR(__reg__) (reg+0x8)
#define IMX_LVDS_TOGGLE(__reg__)(reg+0x4)

#define LVDS_CTRL                     0x0e0
#define LVDS_CTRL_CH0_MODE_MASK       0x03U
#define LVDS_CTRL_CH0_MODE_SHIFT      0U
#define LVDS_CTRL_CH0_MODE__DISABLED  0x00U
#define LVDS_CTRL_CH0_MODE__DI0       0x01U
#define LVDS_CTRL_CH0_MODE__RESERVED  0x02U
#define LVDS_CTRL_CH0_MODE__DI1       0x03U

#define LVDS_CTRL_CH1_MODE_MASK       0x0cU
#define LVDS_CTRL_CH1_MODE_SHIFT      2U
#define LVDS_CTRL_CH1_MODE__DISABLED  0x00U
#define LVDS_CTRL_CH1_MODE__DI0       0x01U
#define LVDS_CTRL_CH1_MODE__RESERVED  0x02U
#define LVDS_CTRL_CH1_MODE__DI1       0x03U

#define LVDS_CTRL_SPLIT_MODE_MASK      0x10U
#define LVDS_CTRL_SPLIT_MODE_SHIFT     4U
#define LVDS_CTRL_SPLIT_MODE__DISABLE  0x00U
#define LVDS_CTRL_SPLIT_MODE__ENABLE   0x01U

#define LVDS_CTRL_CH0_DATA_WIDTH_MASK   0x20U
#define LVDS_CTRL_CH0_DATA_WIDTH_SHIFT  5U
#define LVDS_CTRL_CH0_DATA_WIDTH__18BIT 0x00U
#define LVDS_CTRL_CH0_DATA_WIDTH__24BIT 0x01U

#define LVDS_CTRL_CH0_BIT_MAP_MASK   0x40U
#define LVDS_CTRL_CH0_BIT_MAP_SHIFT  6U
#define LVDS_CTRL_CH0_BIT_MAP__SWWG  0x00U
#define LVDS_CTRL_CH0_BIT_MAP__JEIDA 0x01U

#define LVDS_CTRL_CH1_DATA_WIDTH_MASK   0x80U
#define LVDS_CTRL_CH1_DATA_WIDTH_SHIFT  7U
#define LVDS_CTRL_CH1_DATA_WIDTH__18BIT 0x00U
#define LVDS_CTRL_CH1_DATA_WIDTH__24BIT 0x01U

#define LVDS_CTRL_CH1_BIT_MAP_MASK  0x100U
#define LVDS_CTRL_CH1_BIT_MAP_SHIFT  8U
#define LVDS_CTRL_CH1_BIT_MAP__SWWG  0x00U
#define LVDS_CTRL_CH1_BIT_MAP__JEIDA 0x01U

#define LVDS_CTRL_DI0_VSYNC_POL_MASK        0x200U
#define LVDS_CTRL_DI0_VSYNC_POL_SHIFT        9U
#define LVDS_CTRL_DI0_VSYNC_POL__ACTIVE_LOW  0x00U
#define LVDS_CTRL_DI0_VSYNC_POL__ACTIVE_HIGH 0x01U

#define LVDS_CTRL_DI1_VSYNC_POL_MASK        0x400U
#define LVDS_CTRL_DI1_VSYNC_POL_SHIFT        10U
#define LVDS_CTRL_DI1_VSYNC_POL__ACTIVE_LOW  0x00U
#define LVDS_CTRL_DI1_VSYNC_POL__ACTIVE_HIGH 0x01U

#define LVDS_CTRL_CH0_10BIT_ENABLE_MASK         0x400000U
#define LVDS_CTRL_CH0_10BIT_ENABLE_SHIFT           22U
#define LVDS_CTRL_CH0_10BIT_ENABLE__USE_DATA_WIDTH 0x00U
#define LVDS_CTRL_CH0_10BIT_ENABLE__10BIT          0x01U

#define LVDS_CTRL_CH1_10BIT_ENABLE_MASK         0x800000U
#define LVDS_CTRL_CH1_10BIT_ENABLE_SHIFT           23U
#define LVDS_CTRL_CH1_10BIT_ENABLE__USE_DATA_WIDTH 0x00U
#define LVDS_CTRL_CH1_10BIT_ENABLE__10BIT          0x01U

#define LVDS_CTRL_DI0_DATA_WIDTH_MASK         0x03000000U
#define LVDS_CTRL_DI0_DATA_WIDTH_SHIFT        24U
#define LVDS_CTRL_DI0_DATA_WIDTH__USE_18BIT   0x00U
#define LVDS_CTRL_DI0_DATA_WIDTH__USE_24BIT   0x1U
#define LVDS_CTRL_DI0_DATA_WIDTH__USE_30BIT   0x2U

#define LVDS_CTRL_DI1_DATA_WIDTH_MASK         0x0C000000U
#define LVDS_CTRL_DI1_DATA_WIDTH_SHIFT        26U
#define LVDS_CTRL_DI1_DATA_WIDTH__USE_18BIT   0x00U
#define LVDS_CTRL_DI1_DATA_WIDTH__USE_24BIT   0x1U
#define LVDS_CTRL_DI1_DATA_WIDTH__USE_30BIT   0x2U

#define LVDS_PHY_CTRL	       (0x0)

#define LVDS_PHY_CTRL_PD_MASK       (1<<0)
#define LVDS_PHY_CTRL_PD_SHIFT      (0)
#define LVDS_PHY_CTRL_RFB_MASK      (1<<1)
#define LVDS_PHY_CTRL_RFB_SHIFT     (1)
#define LVDS_PHY_CTRL_NB_MASK       (1<<2)
#define LVDS_PHY_CTRL_NB_SHIFT      (2)
#define LVDS_PHY_CTRL_CH0_EN_MASK   (1<<3)
#define LVDS_PHY_CTRL_CH0_EN_SHIFT  (3)
#define LVDS_PHY_CTRL_CH1_EN_MASK   (1<<4)
#define LVDS_PHY_CTRL_CH1_EN_SHIFT  (4)

#define LVDS_PHY_CTRL_TST_MASK      (0x3f<<5)
#define LVDS_PHY_CTRL_TST_SHIFT     (5)

#define LVDS_PHY_CTRL_CA_MASK       (0x7<<11)
#define LVDS_PHY_CTRL_CA_SHIFT      (11)

#define LVDS_PHY_CTRL_CCM_MASK      (0x7<<14)
#define LVDS_PHY_CTRL_CCM_SHIFT     (14)

#define LVDS_PHY_CTRL_M_MASK        (0x3<<17)
#define LVDS_PHY_CTRL_M_SHIFT       (17)

#endif	/* _IMX8_LVDS_H_ */
