/****************************************************************************/
/* AUTHOR:  Yuhei Higashi                                                   */
/* PURPOSE: HDMI Common Datatypes                                           */
/*                                                                          */
/* Copyright 2015, 2021 Sony Corporation                                    */
/****************************************************************************/
#ifndef __HD_DATATYPES_H__
#define __HD_DATATYPES_H__

/*==== Include =============================================================*/
#include "uapi/linux/limits.h"

/*==== Typedef =============================================================*/
typedef signed int      int_t;
typedef unsigned int    uint_t;
/* typedef char            int_t;     *//* Eight-bit processor only */
/* typedef unsigned char   uint_t;    *//* Eight-bit processor only */
/* typedef int             prefuint_t;*//* Platform-specific efficient integers */

typedef unsigned char      uint8_t;
typedef unsigned short     uint16_t;
typedef unsigned int       uint32_t;
typedef unsigned long long uint64_t;

typedef signed char      int8_t;
typedef signed short     int16_t;
typedef signed int       int32_t;
typedef signed long long int64_t;

typedef unsigned long    clock_time_t;   /* The clock type used for returning system ticks (1ms). */
typedef unsigned short   time_ms_t;      /* Time in milliseconds */

typedef uint8_t bool_t;

/*==== Define ==============================================================*/
#define CLOCK_TIME_MAX  ULONG_MAX       /* Maximum value of time type */

#define true    1
#define false   0

#if !defined ON
#define ON  true
#define OFF false
#endif	/* ON */

#if !defined TRUE
#define TRUE  true
#define FALSE false
#endif	/* TRUE */

#define SET_BITS    0xFF
#define CLEAR_BITS  0x00

#ifndef ENABLE
#define ENABLE      (1)
#define DISABLE     (0)
#endif /* ENABLE */

#ifndef BIT0
#define BIT0        0x01
#define BIT1        0x02
#define BIT2        0x04
#define BIT3        0x08
#define BIT4        0x10
#define BIT5        0x20
#define BIT6        0x40
#define BIT7        0x80
#define BIT8        0x0100
#define BIT9        0x0200
#define BIT10       0x0400
#define BIT11       0x0800
#define BIT12       0x1000
#define BIT13       0x2000
#define BIT14       0x4000
#define BIT15       0x8000
#define BIT16       (0x00010000)
#define BIT17       (0x00020000)
#define BIT18       (0x00040000)
#define BIT19       (0x00080000)
#define BIT20       (0x00100000)
#define BIT21       (0x00200000)
#define BIT22       (0x00400000)
#define BIT23       (0x00800000)
#define BIT24       (0x01000000)
#define BIT25       (0x02000000)
#define BIT26       (0x04000000)
#define BIT27       (0x08000000)
#define BIT28       (0x10000000)
#define BIT29       (0x20000000)
#define BIT30       (0x40000000)
#define BIT31       (0x80000000)
#define BIT32       (0x000100000000)
#define BIT33       (0x000200000000)
#define BIT34       (0x000400000000)
#define BIT35       (0x000800000000)
#define BIT36       (0x001000000000)
#endif /* BIT0 */

#ifndef NULL
#define NULL       ((void*)0)
#endif /* NULL */

#endif /* __HD_DATATYPES_H__ */
