/****************************************************************************/
/* AUTHOR:  Nagase                                                          */
/* PURPOSE: EDID Common                                                     */
/*                                                                          */
/* Copyright 2021 Sony Corporation                                          */
/****************************************************************************/
#define _HD_EDID_COMMON_C_

/*==== Include =============================================================*/
#include "hd_edid_common.h"

/*==== Define ==============================================================*/

/*==== Typedef =============================================================*/

/*==== Local Variables =====================================================*/
static const uint8_t s_HdEdidHeaderBlock0[] = {
	0x00,0xff,0xff,0xff,0xff,0xff,0xff,0x00
};

static const uint8_t s_HdEdidHdmiDisplay[] = {
	0x03,0x0c,0x00
};

static const uint8_t s_HdEdidScdsIeee[] = {
	0xd8,0x5d,0xc4
};

/*==== Prototype Declaration ===============================================*/

/*==== Code ================================================================*/
/*--------------------------------------------------------------------------*/
/* @brief     : Is EDID Header Coreect Block N                              */
/*--------------------------------------------------------------------------*/
bool_t hd_edid_IsHeaderCorrectBlockN(uint8_t data)
{
	if (data == HD_EDID_EXTAG_ADDITIONAL_TIMING) {
		return HD_TRUE;
	} else {
		return HD_FALSE;
	}
}

/*--------------------------------------------------------------------------*/
/* @brief     : Is Correct HDMI Display                                     */
/*--------------------------------------------------------------------------*/
bool_t hd_edid_IsCorrectHdmiDisplay(uint8_t *p_buff)
{
	bool_t  ret_val;
	uint8_t i;

	/* Null Pointer Check */
	if (p_buff == NULL) {
		return HD_FALSE;
	}

	ret_val = HD_TRUE;
	for (i = 0; (ret_val != HD_FALSE) && (i < sizeof(s_HdEdidHdmiDisplay)); i++) {
		if (p_buff[HD_EDID_LEN_CEA_HEADER + i] != s_HdEdidHdmiDisplay[i]) {
			ret_val = HD_FALSE;
		}
	}
	return ret_val;
}

/*--------------------------------------------------------------------------*/
/* @brief     : Is Correct HDMI SCDS IEEE                                   */
/*--------------------------------------------------------------------------*/
bool_t hd_edid_IsCorrectScdsIeee(uint8_t *p_buff)
{
	bool_t  ret_val;
	uint8_t i;

	/* Null Pointer Check */
	if (p_buff == NULL) {
		return HD_FALSE;
	}

	ret_val = HD_TRUE;
	for (i = 0; (ret_val != HD_FALSE) && (i < sizeof(s_HdEdidScdsIeee)); i++) {
		if (p_buff[HD_EDID_LEN_CEA_HEADER + i] != s_HdEdidScdsIeee[i]) {
			ret_val = HD_FALSE;
		}
	}
	return ret_val;
}

/*--------------------------------------------------------------------------*/
/* @brief     : Get CEA Block Data                                          */
/*--------------------------------------------------------------------------*/
uint8_t hd_edid_GetCeaBlockData(uint8_t *p_src, uint8_t start_addr, uint8_t end_addr, uint8_t *p_dest)
{
	uint8_t rptr;
	uint8_t i, len, tag;
	bool_t  exist;

	/* Null Pointer Check */
	if ((p_src == NULL) || (p_dest == NULL)) {
		return HD_FALSE;
	}

	/* tag search */
	rptr = start_addr;
	exist = HD_FALSE;
	while ((exist == HD_FALSE) && (rptr < end_addr)) {
		len = (p_src[rptr] & HD_EDID_MASK_CEA_LEN);
		if ((end_addr - (len + HD_EDID_LEN_CEA_HEADER)) < rptr) {
			rptr = end_addr;
			break;
		}
		tag = ((p_src[rptr] & HD_EDID_MASK_CEA_TAG) >> HD_EDID_SHFT_CEA_TAG);
		if ((tag == HD_EDID_CEA_TAG_AUDIO)
		||  (tag == HD_EDID_CEA_TAG_VIDEO)
		||  (tag == HD_EDID_CEA_TAG_VENDOR)
		||  (tag == HD_EDID_CEA_TAG_SPEAKER)
		||  (tag == HD_EDID_CEA_TAG_EXT)) {
			for (i = 0; i < len + HD_EDID_LEN_CEA_HEADER; i++) {
				p_dest[i] = p_src[rptr + i];
			}
			exist = HD_TRUE;
		}
		rptr += (len + HD_EDID_LEN_CEA_HEADER);
	}
	return rptr;
}
