/****************************************************************************/
/* AUTHOR:  Nagase                                                          */
/* PURPOSE: EDID OWN SPEC                                                   */
/*                                                                          */
/* Copyright 2021 Sony Corporation                                          */
/****************************************************************************/
#ifndef _HD_EDID_OWN_SPEC_H_
#define _HD_EDID_OWN_SPEC_H_

/*==== Include =============================================================*/
#include "hd_edid_format.h"

/*==== Define ==============================================================*/

/*==== Prototype Declaration ===============================================*/
#undef EXTERN
#ifdef _HD_EDID_OWN_SPEC_C_
	#define EXTERN
#else	/* _HD_EDID_OWN_SPEC_C_ */
	#define EXTERN	extern
#endif	/* _HD_EDID_OWN_SPEC_C_ */

EXTERN void hd_edid_GetOwnManufactureId(uint8_t *);
EXTERN void hd_edid_GetOwnProductId(uint8_t *);
EXTERN void hd_edid_GetOwnWeekYear(uint8_t *, uint8_t *);
EXTERN void hd_edid_GetOwnEdidVersion(uint8_t *);
EXTERN void hd_edid_GetOwnBasicDisplay(uint8_t *);
EXTERN void hd_edid_GetOwnColor(uint8_t *);
EXTERN void hd_edid_GetOwnEtd(uint8_t *);

EXTERN uint8_t hd_edid_GetOwnDtdTiming(HD_EDID_DTD_TIMING_t *);

EXTERN void hd_edid_GetOwnDtdName(uint8_t *);
EXTERN void hd_edid_GetOwnDtdRange(uint8_t *);
EXTERN void hd_edid_GetOwnDtdSirial(uint8_t *);
EXTERN void hd_edid_GetOwnDtdVga(uint8_t *);

EXTERN void hd_edid_GetOwnDtv(uint8_t *);
EXTERN uint8_t hd_edid_GetOwnVideo(HD_EDID_VIDEO_DATA_t *);
EXTERN uint8_t hd_edid_GetOwnAudio(HD_EDID_AUDIO_DATA_t *);
EXTERN void hd_edid_GetOwnAudioBasic(HD_EDID_AUDIO_DATA_t *);
EXTERN bool_t hd_edid_GetOwnSpd(HD_EDID_SPD_DATA_t *);
EXTERN void hd_edid_GetOwnSpdBasic(HD_EDID_SPD_DATA_t *);
EXTERN bool_t hd_edid_GetOwnVsdb(HD_EDID_VSDB_EXTENSION_t *);
EXTERN uint8_t hd_edid_GetOwnScds(HD_EDID_SCDS_EXTENSION_t *);
EXTERN bool_t hd_edid_GetOwnExtVcdb(HD_EDID_EXT_VCDB_DATA_t *);
EXTERN bool_t hd_edid_GetOwnExtCmr(HD_EDID_EXT_CMR_DATA_t *);
EXTERN bool_t hd_edid_GetOwnExtHdr(HD_EDID_EXT_HDR_DATA_t *);
EXTERN uint8_t hd_edid_GetOwnExtScdb(HD_EDID_EXT_HFSCDB_DATA_t *);

EXTERN bool_t hd_edid_IsSupportVideo(uint8_t, uint16_t *);
EXTERN bool_t hd_edid_GetSupportVideoState(uint8_t, uint16_t *);
/* HDMI2.0 Y420 EDID */
EXTERN uint8_t hd_edid_GetOwnExtY420vdb(uint8_t *);
EXTERN bool_t hd_edid_IsSupportY420(uint8_t);
EXTERN uint8_t hd_edid_GetSupportAudio(uint8_t, uint8_t, HD_EDID_AUDIO_DATA_t *);
EXTERN bool_t hd_edid_IsSupportSpd(HD_EDID_SPD_DATA_t *);
bool_t hd_edid_IsSupportAudioForEarc(uint8_t , uint8_t *);
bool_t hd_edid_IsSupportVsdbHdmiVic(uint8_t);

#endif	/* _HD_EDID_OWN_SPEC_H_ */
