/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Driver include for the RICOH5B Tuner chip.
 *
 * Copyright 2015, 2016, 2021 Sony Corporation
 *
 */
#ifndef _RICOH5B_CMD_H
#define _RICOH5B_CMD_H

/******************************************************************************/
/* include file                                                               */
/******************************************************************************/
#include "ricoh5b_cmd_manager.h"

/******************************************************************************/
/* enumerated/structured type definition                                      */
/******************************************************************************/

/* Phase/Gain  */
#define RICOH5B_AGCG_NUM		5

struct ricoh5b_pg {
	unsigned short  phase[RICOH5B_AGCG_NUM];
	unsigned short  gain[RICOH5B_AGCG_NUM];
};

/******************************************************************************/
/* function prototype declaration                                             */
/******************************************************************************/

/* getter */
unsigned char ricoh5b_common_cmd_get_det_offset(void); /* get AGCDET offset */

int ricoh5b_send_dither_setting(enum RICOH5B_BAND_STATUS band,
						unsigned char audio_type);
				/* dither setting             0        */
int ricoh5b_send_set_pg_tbl(struct ricoh5b_pg *p_pg);
				/* set Phase/Gain Correction  0        */

int fm_if400_val_set(void);

#endif  /* _RICOH5B_CMD_H */
/* end of ricoh5b_cmd.h */
