/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Driver include for the RICOH5B Tuner chip.
 *
 * Copyright 2015, 2016, 2021 Sony Corporation
 *
 */

#ifndef _RICOH5B_CMD_MANAGER_H
#define _RICOH5B_CMD_MANAGER_H

/******************************************************************************/
/* include file                                                               */
/******************************************************************************/
#include <linux/i2c.h>
#include "ricoh5b_define.h"

/* Definition of Non Mask for Write Register */
#define RICOH5B_REG_NON_MASK      0xFF

/******************************************************************************/
/* enumerated/structured type definition                                      */
/******************************************************************************/
struct ricoh5b_reg {
	unsigned char address;
	unsigned char mask;
	unsigned char data;
};

/******************************************************************************/
/* macro function definition                                                  */
/******************************************************************************/
#define RICOH5B_GET_UPPER_BYTE(X)	((unsigned char)((X) >> 8))
						/* 2byte data upper level */
#define RICOH5B_GET_LOWER_BYTE(X)	((unsigned char)(X))
						/* 2byte data lower level */

/******************************************************************************/
/* function prototype declaration                                             */
/******************************************************************************/

/* ram initialize */
void ricoh5b_cmd_initialize(void);

void ricoh5b_cmd_regist_get_immunity_measure(enum RICOH5B_IMMUNITY
								(*func)(void));

/* getter */
enum RICOH5B_IMMUNITY  ricoh5b_cmd_get_immunity_measure(void);

/* command sequence */
void ricoh5b_cmd_set_sequence_timer(unsigned long timeout_ms);

int ricoh5b_cmd_read_byte(unsigned char reg_addr, unsigned char *buf);
int ricoh5b_cmd_write_byte(unsigned char reg_addr, unsigned char *buf,
								size_t count);
int ricoh5b_cmd_write_bit(unsigned char reg_addr, unsigned char data,
							unsigned char mask);
int ricoh5b_cmd_write_sequencial(struct ricoh5b_reg *tbl, unsigned char count);

#endif  /* _RICOH5B_CMD_MANAGER_H */
/* end of ricoh5b_cmd_manager.h */
