/***************************************************
  Copyright (c) 2015 Amphion Semiconductor Ltd 
                All rights reserved.               
 ***************************************************
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 ****************************************************
 Filename    : trace_types.h
 Description : Public header file containing type definitions and labels
               related to debug trace functions
 Author      : Dave Wilson
               Modified for Transcode FW by K McAdoo (from version 1.41)
               This is no longer only for RTOS builds
 ************************************************/

#ifndef _TRACE_TYPES_H_
#define _TRACE_TYPES_H_

#include "basetype.h"

/* Flag indicating a fatal error - top bit of error_num */
#define MEDIAIP_ERROR_FATAL              0x80000000
#define MEDIAIP_ERROR_WARNING            0x00000000

/* Flags for trace levels */
#define MEDIAIP_TRACE_MASK_MODULE        0x0FFFFFFF
#define MEDIAIP_TRACE_MASK_LEVEL         0x70000000
#define MEDIAIP_TRACE_MASK_TIMESTAMP     0x80000000

#define MEDIAIP_TRACE_SHIFT_LEVEL        28
#define MEDIAIP_TRACE_SHIFT_TIMESTAMP    31

#define MEDIAIP_TRACE_LEVEL_NEVER        0x00000000
#define MEDIAIP_TRACE_LEVEL_1            0x10000000
#define MEDIAIP_TRACE_LEVEL_2            0x20000000
#define MEDIAIP_TRACE_LEVEL_3            0x30000000
#define MEDIAIP_TRACE_LEVEL_4            0x40000000
#define MEDIAIP_TRACE_LEVEL_5            0x50000000
#define MEDIAIP_TRACE_LEVEL_6            0x60000000
#define MEDIAIP_TRACE_LEVEL_ALWAYS       0x70000000

/* Disable the timestamp */
#define MEDIAIP_TRACE_NO_TIMESTAMP       0x80000000

/* Module identifiers */
#define MEDIAIP_TRACE_DECODER            0x00000001
#define MEDIAIP_TRACE_DISPLAY            0x00000002
#define MEDIAIP_TRACE_ENCODER            0x00000003
#define MEDIAIP_TRACE_HANDLE             0x00000004
#define MEDIAIP_TRACE_IMGPORT            0x00000005
#define MEDIAIP_TRACE_PAL                0x00000006
#define MEDIAIP_TRACE_KAL                0x00000006
#define MEDIAIP_TRACE_MEMMOVE            0x00000007
#define MEDIAIP_TRACE_QUEUE              0x00000008
#define MEDIAIP_TRACE_VAMUX              0x00000009

/* Control Layer identifiers          */
#define MEDIAIP_TRACE_VIDEO_LAYER        0x00000050
#define MEDIAIP_TRACE_SYSTEM_LAYER       0x00000051
#define MEDIAIP_TRACE_PROC_LAYER         0x00000052
#define MEDIAIP_TRACE_API_LAYER          0x00000053

/* Additional IDs for application use */
#define MEDIAIP_TRACE_APPLICATION        0x00000060
#define MEDIAIP_TRACE_TEST               0x00000061

/* The upper supported value of a trace module identifier. Make sure that
   there are no trace IDs defined above this value since it is used to
   determine the amount of storage required for trace flags! */
#define MEDIAIP_TRACE_MAX                0x0000009F

/* ID indicating that message should be displayed regardless of the
   modules which are currently enabled. */
#define MEDIAIP_TRACE_ANY                0x00000000

/* Trace message color codes */

#define MEDIAIP_TRACE_FG_LIGHT_BLUE            "\033[1;34m"
#define MEDIAIP_TRACE_FG_LIGHT_GREEN           "\033[1;32m"
#define MEDIAIP_TRACE_FG_LIGHT_CYAN            "\033[1;36m"
#define MEDIAIP_TRACE_FG_LIGHT_RED             "\033[1;31m"
#define MEDIAIP_TRACE_FG_WHITE                 "\033[1;37m"
#define MEDIAIP_TRACE_FG_NORMAL                MEDIAIP_TRACE_FG_WHITE
#define MEDIAIP_TRACE_BG_GRAY                  "\033[0;47m"
#define MEDIAIP_TRACE_BG_BLACK                 "\033[0;40m"

/* The number of 32bit words needed to store our trace flags */
#define MEDIAIP_TRACE_FLAGS_WORDS ((MEDIAIP_TRACE_MAX+31)/32)

/* Data structure used to store trace flags */
typedef struct
{

  u_int32 Flags[MEDIAIP_TRACE_FLAGS_WORDS];

} MEDIAIP_TRACE_FLAGS;


/////////////////////////////////////////////////////////////////////////////////
// Module / Application and System Trace level definitions

#define DECODER_TL_CATASTROPHE  (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_ANY)
#define DECODER_TL_SEVERE       (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_DECODER)
#define DECODER_TL_ERROR        (MEDIAIP_TRACE_LEVEL_6      | MEDIAIP_TRACE_DECODER)
#define DECODER_TL_WARNING      (MEDIAIP_TRACE_LEVEL_5      | MEDIAIP_TRACE_DECODER)
#define DECODER_TL_FUNC         (MEDIAIP_TRACE_LEVEL_4      | MEDIAIP_TRACE_DECODER)
#define DECODER_TL_INFO         (MEDIAIP_TRACE_LEVEL_3      | MEDIAIP_TRACE_DECODER)
#define DECODER_TL_VERBOSE      (MEDIAIP_TRACE_LEVEL_2      | MEDIAIP_TRACE_DECODER)
#define DECODER_TL_DEBUG        (MEDIAIP_TRACE_LEVEL_1      | MEDIAIP_TRACE_DECODER)

#define DISPLAY_TL_CATASTROPHE  (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_ANY)
#define DISPLAY_TL_SEVERE       (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_DISPLAY)
#define DISPLAY_TL_ERROR        (MEDIAIP_TRACE_LEVEL_6      | MEDIAIP_TRACE_DISPLAY)
#define DISPLAY_TL_WARNING      (MEDIAIP_TRACE_LEVEL_5      | MEDIAIP_TRACE_DISPLAY)
#define DISPLAY_TL_FUNC         (MEDIAIP_TRACE_LEVEL_4      | MEDIAIP_TRACE_DISPLAY)
#define DISPLAY_TL_INFO         (MEDIAIP_TRACE_LEVEL_3      | MEDIAIP_TRACE_DISPLAY)
#define DISPLAY_TL_VERBOSE      (MEDIAIP_TRACE_LEVEL_2      | MEDIAIP_TRACE_DISPLAY)
#define DISPLAY_TL_DEBUG        (MEDIAIP_TRACE_LEVEL_1      | MEDIAIP_TRACE_DISPLAY)

#define ENCODER_TL_CATASTROPHE  (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_ANY)
#define ENCODER_TL_SEVERE       (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_ENCODER)
#define ENCODER_TL_ERROR        (MEDIAIP_TRACE_LEVEL_6      | MEDIAIP_TRACE_ENCODER)
#define ENCODER_TL_WARNING      (MEDIAIP_TRACE_LEVEL_5      | MEDIAIP_TRACE_ENCODER)
#define ENCODER_TL_FUNC         (MEDIAIP_TRACE_LEVEL_4      | MEDIAIP_TRACE_ENCODER)
#define ENCODER_TL_INFO         (MEDIAIP_TRACE_LEVEL_3      | MEDIAIP_TRACE_ENCODER)
#define ENCODER_TL_VERBOSE      (MEDIAIP_TRACE_LEVEL_2      | MEDIAIP_TRACE_ENCODER)
#define ENCODER_TL_DEBUG        (MEDIAIP_TRACE_LEVEL_1      | MEDIAIP_TRACE_ENCODER)

#define HANDLE_TL_CATASTROPHE   (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_ANY)
#define HANDLE_TL_SEVERE        (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_HANDLE)
#define HANDLE_TL_ERROR         (MEDIAIP_TRACE_LEVEL_6      | MEDIAIP_TRACE_HANDLE)
#define HANDLE_TL_WARNING       (MEDIAIP_TRACE_LEVEL_5      | MEDIAIP_TRACE_HANDLE)
#define HANDLE_TL_FUNC          (MEDIAIP_TRACE_LEVEL_4      | MEDIAIP_TRACE_HANDLE)
#define HANDLE_TL_INFO          (MEDIAIP_TRACE_LEVEL_3      | MEDIAIP_TRACE_HANDLE)
#define HANDLE_TL_VERBOSE       (MEDIAIP_TRACE_LEVEL_2      | MEDIAIP_TRACE_HANDLE)
#define HANDLE_TL_DEBUG         (MEDIAIP_TRACE_LEVEL_1      | MEDIAIP_TRACE_HANDLE)

#define IMGPORT_TL_CATASTROPHE  (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_ANY)
#define IMGPORT_TL_SEVERE       (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_IMGPORT)
#define IMGPORT_TL_ERROR        (MEDIAIP_TRACE_LEVEL_6      | MEDIAIP_TRACE_IMGPORT)
#define IMGPORT_TL_WARNING      (MEDIAIP_TRACE_LEVEL_5      | MEDIAIP_TRACE_IMGPORT)
#define IMGPORT_TL_FUNC         (MEDIAIP_TRACE_LEVEL_4      | MEDIAIP_TRACE_IMGPORT)
#define IMGPORT_TL_INFO         (MEDIAIP_TRACE_LEVEL_3      | MEDIAIP_TRACE_IMGPORT)
#define IMGPORT_TL_VERBOSE      (MEDIAIP_TRACE_LEVEL_2      | MEDIAIP_TRACE_IMGPORT)
#define IMGPORT_TL_DEBUG        (MEDIAIP_TRACE_LEVEL_1      | MEDIAIP_TRACE_IMGPORT)

#define KAL_TL_CATASTROPHE      (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_ANY)
#define KAL_TL_SEVERE           (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_KAL)
#define KAL_TL_ERROR            (MEDIAIP_TRACE_LEVEL_6      | MEDIAIP_TRACE_KAL)
#define KAL_TL_WARNING          (MEDIAIP_TRACE_LEVEL_5      | MEDIAIP_TRACE_KAL)
#define KAL_TL_FUNC             (MEDIAIP_TRACE_LEVEL_4      | MEDIAIP_TRACE_KAL)
#define KAL_TL_INFO             (MEDIAIP_TRACE_LEVEL_3      | MEDIAIP_TRACE_KAL)
#define KAL_TL_VERBOSE          (MEDIAIP_TRACE_LEVEL_2      | MEDIAIP_TRACE_KAL)
#define KAL_TL_DEBUG            (MEDIAIP_TRACE_LEVEL_1      | MEDIAIP_TRACE_KAL)

#define PAL_TL_CATASTROPHE      (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_ANY)
#define PAL_TL_SEVERE           (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_PAL)
#define PAL_TL_ERROR            (MEDIAIP_TRACE_LEVEL_6      | MEDIAIP_TRACE_PAL)
#define PAL_TL_WARNING          (MEDIAIP_TRACE_LEVEL_5      | MEDIAIP_TRACE_PAL)
#define PAL_TL_FUNC             (MEDIAIP_TRACE_LEVEL_4      | MEDIAIP_TRACE_PAL)
#define PAL_TL_INFO             (MEDIAIP_TRACE_LEVEL_3      | MEDIAIP_TRACE_PAL)
#define PAL_TL_VERBOSE          (MEDIAIP_TRACE_LEVEL_2      | MEDIAIP_TRACE_PAL)
#define PAL_TL_DEBUG            (MEDIAIP_TRACE_LEVEL_1      | MEDIAIP_TRACE_PAL)

#define MEMMOVE_TL_CATASTROPHE  (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_ANY)
#define MEMMOVE_TL_SEVERE       (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_MEMMOVE)
#define MEMMOVE_TL_ERROR        (MEDIAIP_TRACE_LEVEL_6      | MEDIAIP_TRACE_MEMMOVE)
#define MEMMOVE_TL_WARNING      (MEDIAIP_TRACE_LEVEL_5      | MEDIAIP_TRACE_MEMMOVE)
#define MEMMOVE_TL_FUNC         (MEDIAIP_TRACE_LEVEL_4      | MEDIAIP_TRACE_MEMMOVE)
#define MEMMOVE_TL_INFO         (MEDIAIP_TRACE_LEVEL_3      | MEDIAIP_TRACE_MEMMOVE)
#define MEMMOVE_TL_VERBOSE      (MEDIAIP_TRACE_LEVEL_2      | MEDIAIP_TRACE_MEMMOVE)
#define MEMMOVE_TL_DEBUG        (MEDIAIP_TRACE_LEVEL_1      | MEDIAIP_TRACE_MEMMOVE)

#define QUEUE_TL_CATASTROPHE    (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_ANY)
#define QUEUE_TL_SEVERE         (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_QUEUE)
#define QUEUE_TL_ERROR          (MEDIAIP_TRACE_LEVEL_6      | MEDIAIP_TRACE_QUEUE)
#define QUEUE_TL_WARNING        (MEDIAIP_TRACE_LEVEL_5      | MEDIAIP_TRACE_QUEUE)
#define QUEUE_TL_FUNC           (MEDIAIP_TRACE_LEVEL_4      | MEDIAIP_TRACE_QUEUE)
#define QUEUE_TL_INFO           (MEDIAIP_TRACE_LEVEL_3      | MEDIAIP_TRACE_QUEUE)
#define QUEUE_TL_VERBOSE        (MEDIAIP_TRACE_LEVEL_2      | MEDIAIP_TRACE_QUEUE)
#define QUEUE_TL_DEBUG          (MEDIAIP_TRACE_LEVEL_1      | MEDIAIP_TRACE_QUEUE)

#define VAMUX_TL_CATASTROPHE    (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_ANY)
#define VAMUX_TL_SEVERE         (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_VAMUX)
#define VAMUX_TL_ERROR          (MEDIAIP_TRACE_LEVEL_6      | MEDIAIP_TRACE_VAMUX)
#define VAMUX_TL_WARNING        (MEDIAIP_TRACE_LEVEL_5      | MEDIAIP_TRACE_VAMUX)
#define VAMUX_TL_FUNC           (MEDIAIP_TRACE_LEVEL_4      | MEDIAIP_TRACE_VAMUX)
#define VAMUX_TL_INFO           (MEDIAIP_TRACE_LEVEL_3      | MEDIAIP_TRACE_VAMUX)
#define VAMUX_TL_VERBOSE        (MEDIAIP_TRACE_LEVEL_2      | MEDIAIP_TRACE_VAMUX)
#define VAMUX_TL_DEBUG          (MEDIAIP_TRACE_LEVEL_1      | MEDIAIP_TRACE_VAMUX)

#define VIDEO_TL_CATASTROPHE    (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_ANY)
#define VIDEO_TL_SEVERE         (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_VIDEO_LAYER)
#define VIDEO_TL_ERROR          (MEDIAIP_TRACE_LEVEL_6      | MEDIAIP_TRACE_VIDEO_LAYER)
#define VIDEO_TL_WARNING        (MEDIAIP_TRACE_LEVEL_5      | MEDIAIP_TRACE_VIDEO_LAYER)
#define VIDEO_TL_FUNC           (MEDIAIP_TRACE_LEVEL_4      | MEDIAIP_TRACE_VIDEO_LAYER)
#define VIDEO_TL_INFO           (MEDIAIP_TRACE_LEVEL_3      | MEDIAIP_TRACE_VIDEO_LAYER)
#define VIDEO_TL_VERBOSE        (MEDIAIP_TRACE_LEVEL_2      | MEDIAIP_TRACE_VIDEO_LAYER)
#define VIDEO_TL_DEBUG          (MEDIAIP_TRACE_LEVEL_1      | MEDIAIP_TRACE_VIDEO_LAYER)

#define SYSTEM_TL_CATASTROPHE   (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_ANY)
#define SYSTEM_TL_SEVERE        (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_SYSTEM_LAYER)
#define SYSTEM_TL_ERROR         (MEDIAIP_TRACE_LEVEL_6      | MEDIAIP_TRACE_SYSTEM_LAYER)
#define SYSTEM_TL_WARNING       (MEDIAIP_TRACE_LEVEL_5      | MEDIAIP_TRACE_SYSTEM_LAYER)
#define SYSTEM_TL_FUNC          (MEDIAIP_TRACE_LEVEL_4      | MEDIAIP_TRACE_SYSTEM_LAYER)
#define SYSTEM_TL_INFO          (MEDIAIP_TRACE_LEVEL_3      | MEDIAIP_TRACE_SYSTEM_LAYER)
#define SYSTEM_TL_VERBOSE       (MEDIAIP_TRACE_LEVEL_2      | MEDIAIP_TRACE_SYSTEM_LAYER)
#define SYSTEM_TL_DEBUG         (MEDIAIP_TRACE_LEVEL_1      | MEDIAIP_TRACE_SYSTEM_LAYER)

#define PROC_TL_CATASTROPHE     (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_ANY)
#define PROC_TL_SEVERE          (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_PROC_LAYER)
#define PROC_TL_ERROR           (MEDIAIP_TRACE_LEVEL_6      | MEDIAIP_TRACE_PROC_LAYER)
#define PROC_TL_WARNING         (MEDIAIP_TRACE_LEVEL_5      | MEDIAIP_TRACE_PROC_LAYER)
#define PROC_TL_FUNC            (MEDIAIP_TRACE_LEVEL_4      | MEDIAIP_TRACE_PROC_LAYER)
#define PROC_TL_INFO            (MEDIAIP_TRACE_LEVEL_3      | MEDIAIP_TRACE_PROC_LAYER)
#define PROC_TL_VERBOSE         (MEDIAIP_TRACE_LEVEL_2      | MEDIAIP_TRACE_PROC_LAYER)
#define PROC_TL_DEBUG           (MEDIAIP_TRACE_LEVEL_1      | MEDIAIP_TRACE_PROC_LAYER)

#define API_TL_CATASTROPHE      (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_ANY)
#define API_TL_SEVERE           (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_API_LAYER)
#define API_TL_ERROR            (MEDIAIP_TRACE_LEVEL_6      | MEDIAIP_TRACE_API_LAYER)
#define API_TL_WARNING          (MEDIAIP_TRACE_LEVEL_5      | MEDIAIP_TRACE_API_LAYER)
#define API_TL_FUNC             (MEDIAIP_TRACE_LEVEL_4      | MEDIAIP_TRACE_API_LAYER)
#define API_TL_INFO             (MEDIAIP_TRACE_LEVEL_3      | MEDIAIP_TRACE_API_LAYER)
#define API_TL_VERBOSE          (MEDIAIP_TRACE_LEVEL_2      | MEDIAIP_TRACE_API_LAYER)
#define API_TL_DEBUG            (MEDIAIP_TRACE_LEVEL_1      | MEDIAIP_TRACE_API_LAYER)

#define APP_TL_CATASTROPHE      (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_ANY)
#define APP_TL_SEVERE           (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_APPLICATION)
#define APP_TL_ERROR            (MEDIAIP_TRACE_LEVEL_6      | MEDIAIP_TRACE_APPLICATION)
#define APP_TL_WARNING          (MEDIAIP_TRACE_LEVEL_5      | MEDIAIP_TRACE_APPLICATION)
#define APP_TL_FUNC             (MEDIAIP_TRACE_LEVEL_4      | MEDIAIP_TRACE_APPLICATION)
#define APP_TL_INFO             (MEDIAIP_TRACE_LEVEL_3      | MEDIAIP_TRACE_APPLICATION)
#define APP_TL_VERBOSE          (MEDIAIP_TRACE_LEVEL_2      | MEDIAIP_TRACE_APPLICATION)
#define APP_TL_DEBUG            (MEDIAIP_TRACE_LEVEL_1      | MEDIAIP_TRACE_APPLICATION)

#define TEST_TL_CATASTROPHE     (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_ANY)
#define TEST_TL_SEVERE          (MEDIAIP_TRACE_LEVEL_ALWAYS | MEDIAIP_TRACE_TEST)
#define TEST_TL_ERROR           (MEDIAIP_TRACE_LEVEL_6      | MEDIAIP_TRACE_TEST)
#define TEST_TL_WARNING         (MEDIAIP_TRACE_LEVEL_5      | MEDIAIP_TRACE_TEST)
#define TEST_TL_FUNC            (MEDIAIP_TRACE_LEVEL_4      | MEDIAIP_TRACE_TEST)
#define TEST_TL_INFO            (MEDIAIP_TRACE_LEVEL_3      | MEDIAIP_TRACE_TEST)
#define TEST_TL_VERBOSE         (MEDIAIP_TRACE_LEVEL_2      | MEDIAIP_TRACE_TEST)
#define TEST_TL_DEBUG           (MEDIAIP_TRACE_LEVEL_1      | MEDIAIP_TRACE_TEST)

#if RTOS != NONE
#if OSAL == CNXT_KAL

typedef MEDIAIP_TRACE_FLAGS CNXT_TRACE_FLAGS;

#endif /* OSAL == CNXT_KAL */
#endif /* RTOS != NOOS */

#endif /* _TRACE_TYPES_H_ */


/* End of file */
