/* SPDX-License-Identifier: GPL-2.0 */
/*
 * ist3602.h
 *
 * IST3602 Character LCD driver header
 *
 * Copyright 2021 Sony Corporation
 */


#ifndef IST3602_H_
#define IST3602_H_

#include <linux/ioctl.h>

/*** IOCTL commands for ist3602 driver ***/
struct ist3602_params {
	int width;		/* Displayed colmuns */
	int lines;		/* Displayed lines */
	int fonts;		/* Font size */
	int contrast;		/* Contrast */
	int ratio;		/* Regulation Ratio */
	int column_offset;	/* Column offset value */
	int bwidth;		/* Buffer size per line */
};

#define IST3602_IOCTL_BASE 'I'
#define IST3602_GETPARAMS _IOR(IST3602_IOCTL_BASE, 0, struct ist3602_params)

#endif
