//
// Copyright 2020 Sony Corporation
//
#ifndef     CEC_DRIVER_ADAPTER_H
#define     CEC_DRIVER_ADAPTER_H

#define CEC_DRIVER_ADAPTER_PATH "/dev/cec-driver-adapter"

#define CEC_BOOL_TRUE                   (1)
#define CEC_BOOL_FALSE                  (0)
#define CEC_LOGICAL_ADDRESS_SET         (1)
#define CEC_LOGICAL_ADDRESS_CLEAR       (0)
#define CEC_OPERAND_SIZE_MAX            (16)

/* ACK condition */
typedef enum
{
  CEC_ACK_COND_OK = 0,
  CEC_ACK_COND_NO_RESPONSE,
} CEC_ACK_COND;


/* ACK info */
typedef struct _CEC_ACK_INFO
{
  unsigned int          tag;
  CEC_ACK_COND      e_ack_cond;
} CEC_ACK_INFO;

/* Logical Address */
typedef struct
{
  unsigned char     la;
  unsigned char     set_req;
} CEC_DRV_ADDR_CFG;

typedef struct
{
  unsigned char operand_size;
  unsigned char is_no_data;  // no_data flag
  unsigned char header;
  unsigned char opcode;
  unsigned char operand[CEC_OPERAND_SIZE_MAX];
} CEC_FRAME_BLOCK_IO;

typedef struct _CEC_SEND_MSG
{
  unsigned char       is_polling;
  unsigned char       tag;
  CEC_FRAME_BLOCK_IO  command;
} CEC_SEND_MSG;


#define CEC_IOW(num, dtype)       _IOW('C', num, dtype)
#define CEC_IOR(num, dtype)       _IOR('C', num, dtype)
#define CEC_IOWR(num, dtype)      _IOWR('C', num, dtype)
#define CEC_IO(num)               _IO('C', num)


#define CEC_POWER_ENABLE          CEC_IOW(1, int)
#define CEC_GET_CECSTS            CEC_IOWR(2, CEC_ACK_INFO)
#define CEC_SET_CECCMD            CEC_IOWR(3, CEC_SEND_MSG)
#define CEC_SETLA                 CEC_IOWR(4, CEC_DRV_ADDR_CFG)
#define CEC_GET_CECCMD            CEC_IOWR(5, CEC_FRAME_BLOCK_IO)
#define CEC_HDMI_CONTROL_ENABLE   CEC_IOW(6, unsigned int)
#define CEC_SET_RETRY_CNT         CEC_IOW(7, unsigned int)
#define CEC_FILTER_CEC_RECEIVE    CEC_IOW(8, unsigned int)



#endif  // CEC_DRIVER_ADAPTER_H
