/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Driver include for the RICOH5B Tuner chip.
 *
 * Copyright 2015, 2016, 2021, 2022 Sony Corporation
 *
 */

#ifndef _RICOH5B_TUNER_H_
#define _RICOH5B_TUNER_H_

#include <linux/videodev2.h>

#define FM_DEVICE_NAME_BASE "/dev/radio"
#define RICOH5B_CARD_NAME "ricoh5b"

// sense mode
#define SENSE_MODE_HIGH 1
#define SENSE_MODE_LOW  0

// mute on/off
#define MUTE_ON  1
#define MUTE_OFF 0

// RDS
#define RDS_OFF 0
#define RDS_ON  1

// mono/stereo
#define AUDIO_MODE_MONO   0
#define AUDIO_MODE_STEREO 1

// gain
#define GAIN_0DB      0
#define GAIN_MINUS3DB 3
#define GAIN_MINUS4DB 4
#define GAIN_MINUS5DB 5

// RDS/RBDS
#define RDS_MODE_RDS  0
#define RDS_MODE_RBDS 1

// de-emphasis
#define DEEMPHASIS_50US  500
#define DEEMPHASIS_60US  600
#define DEEMPHASIS_75US  750
#define DEEMPHASIS_100US 1000

// RDS receive status
#define RDS_NOT_RECEIVED 0
#define RDS_RECEIVED     1

// poll event disable/enable
#define EVENT_ENABLE  0
#define EVENT_DISABLE 1

/* RICOH5B V4L2 IOCTL */
#define V4L2_CID_SENSE_MODE V4L2_CID_PRIVATE_BASE
#define V4L2_CID_SENSE_THRESHOLD_HIGH (V4L2_CID_PRIVATE_BASE+1)
#define V4L2_CID_SENSE_THRESHOLD_LOW  (V4L2_CID_PRIVATE_BASE+2)
#define V4L2_CID_RDS_ENABLE           (V4L2_CID_PRIVATE_BASE+3)
#define V4L2_CID_AUDIO_MODE           (V4L2_CID_PRIVATE_BASE+4)
#define V4L2_CID_GAIN_SETTING         (V4L2_CID_PRIVATE_BASE+5)
#define V4L2_CID_RDS_MODE             (V4L2_CID_PRIVATE_BASE+6)
#define V4L2_CID_DEEMPHASIS           (V4L2_CID_PRIVATE_BASE+7)
#define V4L2_CID_RAW_SIGNAL_STRENGTH  (V4L2_CID_PRIVATE_BASE+8)
#define V4L2_CID_READ_REGISTER        (V4L2_CID_PRIVATE_BASE+9)
#define V4L2_CID_RDS_RECEIVE_STATUS   (V4L2_CID_PRIVATE_BASE+10)
#define V4L2_CID_EVENT_DISABLE        (V4L2_CID_PRIVATE_BASE+11)

#endif /* _RICOH5B_TUNER_H_ */
