/* SPDX-License-Identifier: GPL-2.0 */
/*
 * icx_pm_helper.h : ICX power management helper driver
 *
 *  Copyright 2019,2020 Sony Home Entertainment & Sound Products Inc.
 */

#ifndef ICX_PM_HELPER_HEADER_INCLUDED
#define ICX_PM_HELPER_HEADER_INCLUDED

#include <linux/wakelock.h>

/* share boot loader boot reason via global varibales. */
extern int icx_pm_helper_boot_reason;
#define ICX_PM_HELPER_BOOT_REASON_KERNEL_PARAM_STR "icx_boot_reason"
#define ICX_PM_HELPER_BOOT_REASON_KERNEL_PARAM      icx_boot_reason
#define ICX_PM_HELPER_BOOT_REASON_UNKNOWN                       (-1)
#define ICX_PM_HELPER_BOOT_REASON_POWER_BUTTON          (0x00000001)

#ifdef CONFIG_ICX_USE_BID_HA
/* share board-id(bid) via global varibales. */
extern int icx_pm_helper_bid;
#endif

/* sysfs boot information */
#define ICX_PM_HELPER_BOOT_X_UNKNOWN (-1)
#define ICX_PM_HELPER_BOOT_X_FALSE    (0)
#define ICX_PM_HELPER_BOOT_X_TRUE     (1)

/* sysfs resume lock cancel control value */
#define ICX_PM_HELPER_RESUME_LOCK_CANCEL_DO_NOTHING (0)
#define ICX_PM_HELPER_RESUME_LOCK_CANCEL_CANCEL     (1)

struct icxpmh_context {
	struct device         *dev;             /* device pointer */
	struct wake_lock       resume_wakelock; /* wake_lock */
	unsigned int           resume_lock_ms;  /* resume wake lock time */
	struct notifier_block  pm_nb;           /* pm notifier */
	long                   pm_state;        /* power management state */

	int  boot_powerkey; /* boot by power key */

	ktime_t         suspend_kt;  /* .suspend (kernel time) */
	struct timespec suspend_ts;  /* .suspend (real time) */
	ktime_t         resume_kt;   /* .resume (kernel time) */
	struct timespec resume_ts;   /* .resume (real time) */
};

#endif
