/* SPDX-License-Identifier: GPL-2.0 */
/*
 * rs232c_cm4.h - rs232c Driver
 *
 * Copyright 2021 Sony Corporation
 *
 */

#ifndef DRIVERS_RS232C_CM4_H_
#define DRIVERS_RS232C_CM4_H_

#include <linux/types.h>

#define RS232C_DEV_NAME_BASE		"/dev/rs232c_cm4"

#define RS232C_CM4_OK			(0)
#define RS232C_CM4_NG			(-1)

#define RS232C_CM4_BUFF_FULL		(0x00F3)
#define RS232C_CM4_RX_BUFF_SIZE_ERROR	(0x00F4)

typedef enum {
	RS232C_CM4_BAUD_9600 = 0,	/*   9600bps */
	RS232C_CM4_BAUD_19200,		/*  19200bps */
	RS232C_CM4_BAUD_38400,		/*  38400bps */
	RS232C_CM4_BAUD_57600,		/*  57600bps */
	RS232C_CM4_BAUD_115200,		/* 115200bps */
	RS232C_CM4_BAUD_230400,		/* 230400bps */
	RS232C_CM4_BAUD_460800,		/* 460800bps */
	RS232C_CM4_BAUD_921600,		/* 921600bps */
} Rs232cCm4BaudRate_t;

typedef enum {
	RS232C_CM4_CIS_STX_CS_OFF = 0,	/*  STX_CS non set */
	RS232C_CM4_CIS_STX_CS_ON,	/*  STX_CS set */
} Rs232cCm4Format_t;

/*---- IOCTL ---------------------------------------------------------------*/
#define RS232C_CM4_IOC_MAGIC	'r'

#define RS232C_CM4_IOC_WRITE_ENABLE			\
		_IOW(RS232C_CM4_IOC_MAGIC, 0x90,	\
		struct rs232c_cm4_ioctl_data_param_def)
#define RS232C_CM4_IOC_READ_ENABLE			\
		_IOR(RS232C_CM4_IOC_MAGIC, 0x90,	\
		struct rs232c_cm4_ioctl_data_param_def)
#define RS232C_CM4_IOC_WRITE_BAUDRATE			\
		_IOW(RS232C_CM4_IOC_MAGIC, 0x91,	\
		struct rs232c_cm4_ioctl_data_param_def)
#define RS232C_CM4_IOC_READ_BAUDRATE			\
		_IOR(RS232C_CM4_IOC_MAGIC, 0x91,	\
		struct rs232c_cm4_ioctl_data_param_def)
#define RS232C_CM4_IOC_WRITE_FORMAT			\
		_IOW(RS232C_CM4_IOC_MAGIC, 0x92,	\
		struct rs232c_cm4_ioctl_data_param_def)
#define RS232C_CM4_IOC_READ_FORMAT			\
		_IOR(RS232C_CM4_IOC_MAGIC, 0x92,	\
		struct rs232c_cm4_ioctl_data_param_def)
#define RS232C_CM4_IOC_WRITE_TESTCMD			\
		_IOW(RS232C_CM4_IOC_MAGIC, 0x93,	\
		struct rs232c_cm4_ioctl_data_param_def)

struct rs232c_cm4_ioctl_data_param_def {
	__u8	write_val;		/* write data */
	__u8	read_val;		/* read  data */
};

#endif	/* DRIVERS_RS232C_CM4_H_ */
