// SPDX-License-Identifier: GPL-2.0
/*
 * es9080.h
 *
 * ES9080 Codec driver headder
 *
 * Copyright 2021,2022 Sony Corporation
 */
#ifndef _ES9080_HEADER_
#define _ES9080_HEADER_

/* Define this label when enable Trace log */
/* #define ES9080_TRACE */

/* Define this label when enable Debug log */
/* #define ES9080_DEBUG */

/* Define this label when enable Readback Reg */
/* #define ES9080_RBREG */

/* Define this label when enable Automute sysfs */
/* #define ES9080_AUTOMUTE_SYSFS */

/* Define print macros */
#ifdef ES9080_TRACE
#define TRACE(fmt, args...) pr_info("TRACE: %s(%d): " \
				fmt, __func__, __LINE__, ##args)
#else
#define TRACE(fmt, args...) {}
#endif
#ifdef ES9080_DEBUG
#define DEBUG(fmt, args...) pr_info("DEBUG: %s(%d): " \
				fmt, __func__, __LINE__, ##args)
#else
#define DEBUG(fmt, args...) pr_debug("DEBUG: %s(%d): " \
				fmt, __func__, __LINE__, ##args)
#endif

/* ### ES9080 Registers Map ### */
/* System Registers (R/W) */
#define ES9080_REG_SYS_CFG			(0x00)
#define ES9080_ENABLE_2X_MODE_MASK		(0x40)
#define ES9080_ENABLE_2X_MODE_SHIFT		(6)
#define ES9080_REG_CLK_ENB			(0x01)
#define ES9080_REG_SYS_MODE_CFG			(0x02)
#define ES9080_REG_DAC_CFG			(0x03)
#define ES9080_SELECT_IDAC_NUM_MASK		(0x3F)
#define ES9080_SELECT_IDAC_NUM_SHIFT		(0)
#define ES9080_REG_MASTER_CLK_CFG		(0x04)
#define ES9080_SELECT_MENC_NUM_MASK		(0x7F)
#define ES9080_SELECT_MENC_NUM_SHIFT		(0)
#define ES9080_REG_ANALOG_DAC_ENB		(0x05)
#define ES9080_REG_CP_CLK_DIV			(0x06)
#define ES9080_REG_ANALOG_CTRL_DELAY		(0x07)
/* (Reserved 0x08-0x0C) */
#define ES9080_REG_INT_VOL_MIN_MASKP		(0x0D)
#define ES9080_REG_INT_AUTO_MUTE_MASKP		(0x0E)
#define ES9080_REG_INT_DRE_MASKP		(0x0F)
#define ES9080_REG_INT_SOFT_RAMP_MASKP		(0x10)
#define ES9080_REG_INT_MASKP			(0x11)
/* (Reserved 0x12) */
#define ES9080_REG_INT_VOL_MIN_MASKN		(0x13)
#define ES9080_REG_INT_AUTO_MUTE_MASKN		(0x14)
#define ES9080_REG_INT_DRE_MASKN		(0x15)
#define ES9080_REG_INT_SOFT_RAMP_MASKN		(0x16)
#define ES9080_REG_INT_MASKN			(0x17)
/* (Reserved 0x18) */
#define ES9080_REG_INT_VOL_MIN_CLEAR		(0x19)
#define ES9080_REG_INT_AUTO_MUTE_CLEAR		(0x1A)
#define ES9080_REG_INT_DRE_FLAG_CLEAR		(0x1B)
#define ES9080_REG_INT_SOFT_RAMP_CLEAR		(0x1C)
#define ES9080_REG_INT_CLEAR			(0x1D)
/* (Reserved 0x1E) */
#define ES9080_REG_ANALOG_CTRL_CFG		(0x1F)
/* (Reserved 0x20-0x22) */
#define ES9080_REG_OCP_LDRV_CTRL		(0x23)
#define ES9080_REG_DAC_TRIB_CTRL		(0x24)
/* (Reserved 0x25-0x30) */
#define ES9080_DIGITAL_CTRL_OVERRIDE		(0x31)
#define ES9080_REG_FB_DIV_TUNING_CFG		(0x32)
#define ES9080_REG_FORCE_PLL_LOCK		(0x33)
#define ES9080_REG_SPDIF_CFG			(0x34)
#define ES9080_REG_GPIO12_CFG			(0x35)
#define ES9080_REG_GPIO34_CFG			(0x36)
#define ES9080_REG_GPIO56_CFG			(0x37)
/* (Reserved 0x38-0x39) */
#define ES9080_REG_GPIO_INV_OUTP_LOGIC_0	(0x3A)
#define ES9080_REG_GPIO_INV_OUTP_LOGIC_1	(0x3B)
#define ES9080_REG_GPIO_WEAKEN_CHSEL_0		(0x3C)
#define ES9080_REG_GPIO_WEAKEN_CHSEL_1		(0x3D)
#define ES9080_REG_GPIO_INP_ENB			(0x3E)
/* (Reserved 0x3F) */
#define ES9080_REG_GPIO_OUTP_ENB_0		(0x40)
#define ES9080_REG_GPIO_OUTP_ENB_1		(0x41)
#define ES9080_REG_GPIO_READ_ENB_0		(0x42)
#define ES9080_REG_GPIO_READ_ENB_1		(0x43)
#define ES9080_REG_PWM1_COUNT			(0x44)
#define ES9080_REG_PWM1_FREQ_0			(0x45)
#define ES9080_REG_PWM1_FREQ_1			(0x46)
#define ES9080_REG_PWM2_COUNT			(0x47)
#define ES9080_REG_PWM2_FREQ_0			(0x48)
#define ES9080_REG_PWM2_FREQ_1			(0x49)
#define ES9080_REG_PWM3_COUNT			(0x4A)
#define ES9080_REG_PWM3_FREQ_0			(0x4B)
#define ES9080_REG_PWM3_FREQ_1			(0x4C)
#define ES9080_REG_INP_CFG			(0x4D)
#define ES9080_INPUT_SEL_MASK			(0x0C)
#define ES9080_INPUT_SEL_SHIFT			(2)
#define ES9080_REG_MASTER_MODE_CFG		(0x4E)
#define ES9080_REG_TDM_CFG1			(0x4F)
#define ES9080_REG_TDM_CFG2			(0x50)
#define ES9080_REG_TDM_CFG3			(0x51)
#define ES9080_REG_BCK_WS_MONITOR_CFG		(0x52)
#define ES9080_REG_TDM_VALID_PULSE_CFG		(0x53)
#define ES9080_REG_TDM_CH1_CFG			(0x54)
#define ES9080_REG_TDM_CH2_CFG			(0x55)
#define ES9080_REG_TDM_CH3_CFG			(0x56)
#define ES9080_REG_TDM_CH4_CFG			(0x57)
#define ES9080_REG_TDM_CH5_CFG			(0x58)
#define ES9080_REG_TDM_CH6_CFG			(0x59)
#define ES9080_REG_TDM_CH7_CFG			(0x5A)
#define ES9080_REG_TDM_CH8_CFG			(0x5B)
#define ES9080_REG_RESYNC_CFG			(0x5C)
/* (Reserved 0x5D) */
#define ES9080_REG_VOLUME1			(0x5E)
#define ES9080_REG_VOLUME2			(0x5F)
#define ES9080_REG_VOLUME3			(0x60)
#define ES9080_REG_VOLUME4			(0x61)
#define ES9080_REG_VOLUME5			(0x62)
#define ES9080_REG_VOLUME6			(0x63)
#define ES9080_REG_VOLUME7			(0x64)
#define ES9080_REG_VOLUME8			(0x65)
#define ES9080_REG_DAC_VOL_UP_RATE		(0x66)
#define ES9080_REG_DAC_VOL_DOWN_RATE		(0x67)
#define ES9080_REG_DAC_VOL_DOWN_FAST		(0x68)
#define ES9080_REG_VOLUME_MONO_CTRL		(0x69)
#define ES9080_REG_MUTE_CTRL			(0x6A)
#define ES9080_REG_DATA_INV_CTRL		(0x6B)
#define ES9080_REG_FILTER_CFG			(0x6C)
#define ES9080_REG_IIR_CFG			(0x6D)
/* (Reserved 0x6E) */
#define ES9080_REG_THD_COMP_C2_CH1357_0		(0x6F)
#define ES9080_REG_THD_COMP_C2_CH1357_1		(0x70)
#define ES9080_REG_THD_COMP_C3_CH1357_0		(0x71)
#define ES9080_REG_THD_COMP_C3_CH1357_1		(0x72)
#define ES9080_REG_THD_COMP_C2_CH2468_0		(0x73)
#define ES9080_REG_THD_COMP_C2_CH2468_1		(0x74)
#define ES9080_REG_THD_COMP_C3_CH2468_0		(0x75)
#define ES9080_REG_THD_COMP_C3_CH2468_1		(0x76)
#define ES9080_REG_AUTOMUTE_ENB			(0x77)
#define ES9080_REG_AUTOMUTE_TIME_0		(0x78)
#define ES9080_REG_AUTOMUTE_TIME_1		(0x79)
#define ES9080_REG_AUTOMUTE_LEVEL_0		(0x7A)
#define ES9080_REG_AUTOMUTE_LEVEL_1		(0x7B)
#define ES9080_REG_AUTOMUTE_OFF_LEVEL_0		(0x7C)
#define ES9080_REG_AUTOMUTE_OFF_LEVEL_1		(0x7D)
#define ES9080_REG_SOFT_RAMP_CFG		(0x7E)
#define ES9080_REG_NSMOD_DITHER_SEL		(0x7F)
#define ES9080_REG_NSMOD_DITHER_INV		(0x80)
#define ES9080_REG_NSMOD_DITHER_CFG		(0x81)
/* (Reserved 0x82) */
#define ES9080_REG_NSMOD_DITHER_CH12		(0x83)
#define ES9080_REG_NSMOD_DITHER_CH34		(0x84)
#define ES9080_REG_NSMOD_DITHER_CH56		(0x85)
#define ES9080_REG_NSMOD_DITHER_CH78		(0x86)
#define ES9080_REG_MIN_PEAK			(0x87)
#define ES9080_REG_DRE_ATT_EN_FBAMP_CTRL	(0x88)
/* (Reserved 0x89-0x8A) */
#define ES9080_REG_DRE_FORCE			(0x8B)
#define ES9080_REG_DRE_GAIN_CH1357_0		(0x8C)
#define ES9080_REG_DRE_GAIN_CH1357_1		(0x8D)
#define ES9080_REG_DRE_GAIN_CH2468_0		(0x8E)
#define ES9080_REG_DRE_GAIN_CH2468_1		(0x8F)
#define ES9080_REG_DRE_ON_THRESHOLD_0		(0x90)
#define ES9080_REG_DRE_ON_THRESHOLD_1		(0x91)
#define ES9080_REG_DRE_OFF_THRESHOLD_0		(0x92)
#define ES9080_REG_DRE_OFF_THRESHOLD_1		(0x93)
#define ES9080_REG_DRE_DECAY_RATE		(0x94)
#define ES9080_REG_DC_OFFSET_CH1357_0		(0x95)
#define ES9080_REG_DC_OFFSET_CH1357_1		(0x96)
#define ES9080_REG_DC_OFFSET_CH2468_0		(0x97)
#define ES9080_REG_DC_OFFSET_CH2468_1		(0x98)
#define ES9080_REG_DC_RAMP_RATE			(0x99)
#define ES9080_REG_GAIN_18DB			(0x9A)
#define ES9080_REG_SPDIF1_CS_0			(0x9B)
#define ES9080_REG_SPDIF1_CS_1			(0x9C)
#define ES9080_REG_SPDIF1_CS_2			(0x9D)
#define ES9080_REG_SPDIF1_CS_3			(0x9E)
#define ES9080_REG_SPDIF1_CS_4			(0x9F)
#define ES9080_REG_SPDIF2_CS_0			(0xA0)
#define ES9080_REG_SPDIF2_CS_1			(0xA1)
#define ES9080_REG_SPDIF2_CS_2			(0xA2)
#define ES9080_REG_SPDIF2_CS_3			(0xA3)
#define ES9080_REG_SPDIF2_CS_4			(0xA4)
#define ES9080_REG_SIZE				(0xA5)
/* (Can not access 0xA5-0xBF) */
/* Synchronous Slave Interface (W/O) */
#define ES9080_REG_PLL_REGISTER1		(0xC0)
#define ES9080_REG_PLL_REGISTER2		(0xC1)
#define ES9080_REG_PLL_REGISTER3		(0xC2)
#define ES9080_REG_PLL_REGISTER4		(0xC3)
#define ES9080_REG_PLL_REGISTER5		(0xC4)
#define ES9080_REG_PLL_REGISTER6_0		(0xC5)
#define ES9080_REG_PLL_REGISTER6_1		(0xC6)
#define ES9080_REG_PLL_REGISTER6_2		(0xC7)
#define ES9080_REG_PLL_REGISTER7_0		(0xC8)
#define ES9080_REG_PLL_REGISTER7_1		(0xC9)
#define ES9080_REG_PLL_REGISTER7_2		(0xCA)
#define ES9080_REG_PLL_REGISTER8		(0xCB)
/* (Reserved 0xCC-0xDF) */
/* Read Only Registers (R/O) */
#define ES9080_REG_SYS_READ			(0xE0)
#define ES9080_REG_CHIP_ID_READ			(0xE1)
/* (Reserved 0xE2-0xE4) */
#define ES9080_REG_INT_STATE_0			(0xE5)
#define ES9080_REG_INT_STATE_1			(0xE6)
#define ES9080_REG_INT_STATE_2			(0xE7)
#define ES9080_REG_INT_STATE_3			(0xE8)
#define ES9080_REG_INT_STATE_4			(0xE9)
#define ES9080_REG_INT_STATE_5			(0xEA)
#define ES9080_REG_INT_SOURCE_0			(0xEB)
#define ES9080_REG_INT_SOURCE_1			(0xEC)
#define ES9080_REG_INT_SOURCE_2			(0xED)
#define ES9080_REG_INT_SOURCE_3			(0xEE)
#define ES9080_REG_INT_SOURCE_4			(0xEF)
#define ES9080_REG_INT_SOURCE_5			(0xF0)
#define ES9080_REG_RWS_REF_CNT_STATUS_0		(0xF1)
#define ES9080_REG_RWS_REF_CNT_STATUS_1		(0xF2)
#define ES9080_REG_RWS_REF_CNT_STATUS_2		(0xF3)
#define ES9080_REG_RWS_REF_CNT_STATUS_3		(0xF4)
/* (Reserved 0xF5-0xF6) */
#define ES9080_REG_GPIO_JD_CMP_READ_0		(0xF7)
#define ES9080_REG_GPIO_JD_CMP_READ_1		(0xF8)
#define ES9080_REG_AUTOMUTE_READ		(0xF9)
#define ES9080_REG_VOL_MIN_READ			(0xFA)
#define ES9080_REG_RAMP_UP_READ			(0xFB)
#define ES9080_REG_RAMP_DOWN_READ		(0xFC)
#define ES9080_REG_DRE_STATUS_READ		(0xFD)
#define ES9080_REG_DRE_DETECT_READ		(0xFE)
#define ES9080_REG_DATA_FLAG_READ		(0xFF)

/* External functions */
extern int es9080_regist_client(struct i2c_client *i2c);
extern void es9080_free_client(struct i2c_client *i2c);

#endif /* _ES9080_HEADER_ */
