/*
 * Copyright (c) 2012-2018 The Linux Foundation. All rights reserved.
 *
 * Permission to use, copy, modify, and/or distribute this software for
 * any purpose with or without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE
 * AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __WLAN_POLICY_MGR_TABLES_1X1_DBS_H
#define __WLAN_POLICY_MGR_TABLES_1X1_DBS_H

#include "wlan_policy_mgr_api.h"

/**
 * second_connection_pcl_dbs_1x1_table - table which provides PCL
 * for the 2nd connection, when we have a connection already in
 * the system (with DBS supported by HW)
 */
pm_dbs_pcl_second_connection_table_type
pm_second_connection_pcl_dbs_1x1_table = {
	[PM_STA_24_1x1] = {
	[PM_STA_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_SAP_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_P2P_CLIENT_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_IBSS_MODE] = {PM_5G,        PM_5G,        PM_5G       } },

	[PM_STA_24_2x2] = {
	[PM_STA_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_SAP_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_P2P_CLIENT_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_IBSS_MODE] = {PM_5G,        PM_5G,        PM_5G       } },

	[PM_STA_5_1x1] = {
	[PM_STA_MODE] = {PM_SCC_CH_24G, PM_24G_SCC_CH, PM_SCC_CH_24G},
	[PM_SAP_MODE] = {PM_SCC_CH_24G, PM_24G_SCC_CH, PM_SCC_CH_24G},
	[PM_P2P_CLIENT_MODE] =	{
			PM_SCC_CH_24G, PM_24G_SCC_CH, PM_SCC_CH_24G},
	[PM_P2P_GO_MODE] = {PM_SCC_CH_24G, PM_24G_SCC_CH, PM_SCC_CH_24G},
	[PM_IBSS_MODE] = {PM_24G,        PM_24G,        PM_24G       } },

	[PM_STA_5_2x2] = {
	[PM_STA_MODE] = {PM_SCC_CH_24G, PM_24G_SCC_CH, PM_SCC_CH_24G},
	[PM_SAP_MODE] = {PM_SCC_CH_24G, PM_24G_SCC_CH, PM_SCC_CH_24G},
	[PM_P2P_CLIENT_MODE] =	{
			PM_SCC_CH_24G, PM_24G_SCC_CH, PM_SCC_CH_24G},
	[PM_P2P_GO_MODE] = {PM_SCC_CH_24G, PM_24G_SCC_CH, PM_SCC_CH_24G},
	[PM_IBSS_MODE] = {PM_24G,        PM_24G,        PM_24G       } },

	[PM_P2P_CLI_24_1x1] = {
	[PM_STA_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_SAP_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_P2P_CLIENT_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_CLI_24_2x2] = {
	[PM_STA_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_SAP_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_P2P_CLIENT_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_CLI_5_1x1] = {
	[PM_STA_MODE] = {PM_SCC_CH_24G, PM_24G_SCC_CH, PM_SCC_CH_24G},
	[PM_SAP_MODE] = {PM_SCC_CH_24G, PM_24G_SCC_CH, PM_SCC_CH_24G},
	[PM_P2P_CLIENT_MODE] =	{
			PM_SCC_CH_24G, PM_24G_SCC_CH, PM_SCC_CH_24G},
	[PM_P2P_GO_MODE] = {PM_SCC_CH_24G, PM_24G_SCC_CH, PM_SCC_CH_24G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_CLI_5_2x2] = {
	[PM_STA_MODE] = {PM_SCC_CH_24G, PM_24G_SCC_CH, PM_SCC_CH_24G},
	[PM_SAP_MODE] = {PM_SCC_CH_24G, PM_24G_SCC_CH, PM_SCC_CH_24G},
	[PM_P2P_CLIENT_MODE] =	{
			PM_SCC_CH_24G, PM_24G_SCC_CH, PM_SCC_CH_24G},
	[PM_P2P_GO_MODE] = {PM_SCC_CH_24G, PM_24G_SCC_CH, PM_SCC_CH_24G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_24_1x1] = {
	[PM_STA_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_SAP_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_P2P_CLIENT_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_5G, PM_5G, PM_5G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_24_2x2] = {
	[PM_STA_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_SAP_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_P2P_CLIENT_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_5G, PM_5G, PM_5G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_5_1x1] = {
	[PM_STA_MODE] = {PM_SCC_CH_24G, PM_SCC_CH_24G, PM_SCC_CH_24G},
	[PM_SAP_MODE] = {PM_SCC_CH_24G, PM_SCC_CH_24G, PM_SCC_CH_24G},
	[PM_P2P_CLIENT_MODE] = {
			PM_SCC_CH_24G, PM_24G_SCC_CH, PM_SCC_CH_24G},
	[PM_P2P_GO_MODE] = {PM_24G, PM_24G, PM_24G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_5_2x2] = {
	[PM_STA_MODE] = {PM_SCC_CH_24G, PM_SCC_CH_24G, PM_SCC_CH_24G},
	[PM_SAP_MODE] = {PM_SCC_CH_24G, PM_SCC_CH_24G, PM_SCC_CH_24G},
	[PM_P2P_CLIENT_MODE] =	{
			PM_SCC_CH_24G, PM_24G_SCC_CH, PM_SCC_CH_24G},
	[PM_P2P_GO_MODE] = {PM_24G, PM_24G, PM_24G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_SAP_24_1x1] = {
	[PM_STA_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_SAP_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_P2P_CLIENT_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_SAP_24_2x2] = {
	[PM_STA_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_SAP_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_P2P_CLIENT_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_SAP_5_1x1] = {
	[PM_STA_MODE] = {PM_SCC_CH_24G, PM_SCC_CH_24G, PM_SCC_CH_24G},
	[PM_SAP_MODE] = {PM_SCC_CH_24G, PM_SCC_CH_24G, PM_SCC_CH_24G},
	[PM_P2P_CLIENT_MODE] =	{
			PM_SCC_CH_24G, PM_24G_SCC_CH, PM_SCC_CH_24G},
	[PM_P2P_GO_MODE] = {PM_SCC_CH_24G, PM_SCC_CH_24G, PM_SCC_CH_24G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_SAP_5_2x2] = {
	[PM_STA_MODE] = {PM_SCC_CH_24G, PM_SCC_CH_24G, PM_SCC_CH_24G},
	[PM_SAP_MODE] = {PM_SCC_CH_24G, PM_SCC_CH_24G, PM_SCC_CH_24G},
	[PM_P2P_CLIENT_MODE] =	{
			PM_SCC_CH_24G, PM_24G_SCC_CH, PM_SCC_CH_24G},
	[PM_P2P_GO_MODE] = {PM_SCC_CH_24G, PM_SCC_CH_24G, PM_SCC_CH_24G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_IBSS_24_1x1] = {
	[PM_STA_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_SAP_MODE] = {PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] =	{
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_IBSS_24_2x2] = {
	[PM_STA_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] =	{
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_IBSS_5_1x1] = {
	[PM_STA_MODE] = {PM_24G_SCC_CH, PM_24G_SCC_CH, PM_24G_SCC_CH},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] =	{
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_IBSS_5_2x2] = {
	[PM_STA_MODE] = {PM_24G_SCC_CH, PM_24G_SCC_CH, PM_24G_SCC_CH},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] =	{
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },
};

/**
 * third_connection_pcl_dbs_table - table which provides PCL for
 * the 3rd connection, when we have two connections already in
 * the system (with DBS supported by HW)
 */
static pm_dbs_pcl_third_connection_table_type
pm_third_connection_pcl_dbs_1x1_table = {
	[PM_STA_SAP_SCC_24_1x1] = {
	[PM_STA_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_SAP_MODE] = {PM_5G, PM_5G, PM_5G},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {PM_5G, PM_5G, PM_5G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_SAP_SCC_24_2x2] = {
	[PM_STA_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_SAP_MODE] = {PM_5G, PM_5G, PM_5G},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {PM_5G, PM_5G, PM_5G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_SAP_MCC_24_1x1] = {
	[PM_STA_MODE] = {PM_5G_MCC_CH, PM_5G, PM_5G_MCC_CH},
	[PM_SAP_MODE] = {PM_5G, PM_5G, PM_5G},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {PM_5G, PM_5G, PM_5G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_SAP_MCC_24_2x2] = {
	[PM_STA_MODE] = {PM_5G_MCC_CH, PM_5G, PM_5G_MCC_CH},
	[PM_SAP_MODE] = {PM_5G, PM_5G, PM_5G},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {PM_5G, PM_5G, PM_5G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_SAP_SCC_5_1x1] = {
	[PM_STA_MODE] = {PM_SCC_CH_24G, PM_24G_SCC_CH, PM_SCC_CH_24G},
	[PM_SAP_MODE] = {PM_24G, PM_24G, PM_24G},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {PM_24G, PM_24G, PM_24G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_SAP_SCC_5_2x2] = {
	[PM_STA_MODE] = {PM_SCC_CH_24G, PM_24G_SCC_CH, PM_SCC_CH_24G},
	[PM_SAP_MODE] = {PM_24G, PM_24G, PM_24G},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {PM_24G, PM_24G, PM_24G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_SAP_MCC_5_1x1] = {
	[PM_STA_MODE] = {PM_MCC_CH_24G, PM_24G, PM_24G},
	[PM_SAP_MODE] = {PM_24G,        PM_24G, PM_24G},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {PM_24G, PM_24G, PM_24G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_SAP_MCC_5_2x2] = {
	[PM_STA_MODE] = {PM_MCC_CH_24G, PM_24G, PM_24G},
	[PM_SAP_MODE] = {PM_24G,        PM_24G, PM_24G},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {PM_24G, PM_24G, PM_24G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_SAP_MCC_24_5_1x1] = {
	[PM_STA_MODE] = {PM_MCC_CH_5G, PM_5G, PM_5G},
	[PM_SAP_MODE] = {PM_24G,        PM_24G, PM_24G},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_SAP_MCC_24_5_2x2] = {
	[PM_STA_MODE] = {PM_MCC_CH_5G, PM_5G, PM_5G},
	[PM_SAP_MODE] = {PM_24G,        PM_24G, PM_24G},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_SAP_DBS_1x1] = {
	[PM_STA_MODE] = {
		PM_SCC_ON_5_SCC_ON_24_5G, PM_NONE, PM_SCC_ON_5_SCC_ON_24},
	[PM_SAP_MODE] = {PM_SCC_ON_5_SCC_ON_24, PM_SCC_ON_5_SCC_ON_24,
		PM_SCC_ON_5_SCC_ON_24},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {PM_SCC_ON_5_SCC_ON_24, PM_SCC_ON_5_SCC_ON_24,
		PM_SCC_ON_5_SCC_ON_24},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_SAP_SAP_SCC_24_1x1] = {
	[PM_STA_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_SAP_MODE] = {PM_5G, PM_5G, PM_5G},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {PM_5G, PM_5G, PM_5G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_SAP_SAP_SCC_24_2x2] = {
	[PM_STA_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_SAP_MODE] = {PM_5G, PM_5G, PM_5G},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {PM_5G, PM_5G, PM_5G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_SAP_SAP_MCC_24_1x1] = {
	[PM_STA_MODE] = {PM_5G, PM_5G, PM_5G},
	[PM_SAP_MODE] = {PM_5G, PM_5G, PM_5G},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_SAP_SAP_MCC_24_2x2] = {
	[PM_STA_MODE] = {PM_5G, PM_5G, PM_5G},
	[PM_SAP_MODE] = {PM_5G, PM_5G, PM_5G},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_SAP_SAP_SCC_5_1x1] = {
	[PM_STA_MODE] = {PM_24G_SCC_CH_SBS_CH_5G, PM_24G_SCC_CH,
		PM_24G_SCC_CH_SBS_CH},
	[PM_SAP_MODE] = {PM_24G, PM_24G, PM_24G},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {PM_24G, PM_24G, PM_24G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_SAP_SAP_SCC_5_2x2] = {
	[PM_STA_MODE] = {PM_24G_SCC_CH_SBS_CH_5G, PM_24G_SCC_CH,
		PM_24G_SCC_CH_SBS_CH},
	[PM_SAP_MODE] = {PM_24G, PM_24G, PM_24G},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {PM_24G, PM_24G, PM_24G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_SAP_SAP_MCC_5_1x1] = {
	[PM_STA_MODE] = {PM_24G_SBS_CH_MCC_CH, PM_24G, PM_24G_MCC_CH},
	[PM_SAP_MODE] = {PM_24G_SBS_CH_MCC_CH, PM_24G, PM_24G_MCC_CH},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_SAP_SAP_MCC_5_2x2] = {
	[PM_STA_MODE] = {PM_24G_SBS_CH_MCC_CH, PM_24G, PM_24G_MCC_CH},
	[PM_SAP_MODE] = {PM_24G_SBS_CH_MCC_CH, PM_24G, PM_24G_MCC_CH},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_SAP_SAP_MCC_24_5_1x1] = {
	[PM_STA_MODE] = {PM_5G, PM_5G, PM_5G},
	[PM_SAP_MODE] = {PM_5G, PM_5G, PM_5G},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_SAP_SAP_MCC_24_5_2x2] = {
	[PM_STA_MODE] = {PM_5G, PM_5G, PM_5G},
	[PM_SAP_MODE] = {PM_5G, PM_5G, PM_5G},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_SAP_SAP_DBS_1x1] = {
	[PM_STA_MODE] = { PM_SCC_ON_5_SCC_ON_24_5G, PM_SCC_ON_5_SCC_ON_24,
		PM_SCC_ON_5_SCC_ON_24},
	[PM_SAP_MODE] = { PM_SCC_ON_5_SCC_ON_24, PM_SCC_ON_5_SCC_ON_24,
		PM_SCC_ON_5_SCC_ON_24},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {PM_SCC_ON_5_SCC_ON_24, PM_SCC_ON_5_SCC_ON_24,
		PM_SCC_ON_5_SCC_ON_24},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_GO_SCC_24_1x1] = {
	[PM_STA_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_SAP_MODE] = {PM_5G, PM_5G, PM_5G},
	[PM_P2P_CLIENT_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_P2P_GO_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_GO_SCC_24_2x2] = {
	[PM_STA_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_SAP_MODE] = {PM_5G, PM_5G, PM_5G},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {PM_5G_SCC_CH, PM_5G_SCC_CH, PM_5G_SCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_GO_MCC_24_1x1] = {
	[PM_STA_MODE] = {PM_5G_MCC_CH, PM_5G, PM_5G_MCC_CH},
	[PM_SAP_MODE] = {PM_5G, PM_5G, PM_5G},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {PM_5G_MCC_CH, PM_5G, PM_5G_MCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_GO_MCC_24_2x2] = {
	[PM_STA_MODE] = {PM_5G_MCC_CH, PM_5G, PM_5G_MCC_CH},
	[PM_SAP_MODE] = {PM_5G, PM_5G, PM_5G},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {PM_5G_MCC_CH, PM_5G, PM_5G_MCC_CH},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_GO_SCC_5_1x1] = {
	[PM_STA_MODE] = {PM_SCC_CH_24G, PM_24G_SCC_CH, PM_SCC_CH_24G},
	[PM_SAP_MODE] = {PM_24G, PM_24G, PM_24G},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {PM_SCC_CH_24G, PM_24G_SCC_CH, PM_SCC_CH_24G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_GO_SCC_5_2x2] = {
	[PM_STA_MODE] = {PM_SCC_CH_24G, PM_24G_SCC_CH, PM_SCC_CH_24G},
	[PM_SAP_MODE] = {PM_24G, PM_24G, PM_24G},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {PM_SCC_CH_24G, PM_24G_SCC_CH, PM_SCC_CH_24G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_GO_MCC_5_1x1] = {
	[PM_STA_MODE] = {PM_MCC_CH_24G, PM_24G, PM_24G},
	[PM_SAP_MODE] = {PM_24G, PM_24G, PM_24G},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {PM_MCC_CH_24G, PM_24G, PM_24G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_GO_MCC_5_2x2] = {
	[PM_STA_MODE] = {PM_MCC_CH_24G, PM_24G, PM_24G},
	[PM_SAP_MODE] = {PM_24G, PM_24G, PM_24G},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {PM_MCC_CH_24G, PM_24G, PM_24G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_GO_MCC_24_5_1x1] = {
	[PM_STA_MODE] = {PM_MCC_CH_5G, PM_5G, PM_5G},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {PM_MCC_CH_24G, PM_24G, PM_24G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_GO_MCC_24_5_2x2] = {
	[PM_STA_MODE] = {PM_MCC_CH_5G, PM_5G, PM_5G},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {PM_MCC_CH_24G, PM_24G, PM_24G},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_GO_DBS_1x1] = {
	[PM_STA_MODE] = {
		PM_SCC_ON_5_SCC_ON_24_5G, PM_NONE, PM_SCC_ON_5_SCC_ON_24},
	[PM_SAP_MODE] = {PM_SCC_ON_5_SCC_ON_24, PM_SCC_ON_5_SCC_ON_24,
		PM_SCC_ON_5_SCC_ON_24},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_SCC_ON_5_SCC_ON_24_5G, PM_NONE, PM_SCC_ON_5_SCC_ON_24},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_CLI_SCC_24_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_CLI_SCC_24_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_CLI_MCC_24_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_CLI_MCC_24_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_CLI_SCC_5_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_CLI_SCC_5_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_CLI_MCC_5_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_CLI_MCC_5_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_CLI_MCC_24_5_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_CLI_MCC_24_5_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_STA_P2P_CLI_DBS_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_P2P_CLI_SCC_24_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_P2P_CLI_SCC_24_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_P2P_CLI_MCC_24_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_P2P_CLI_MCC_24_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_P2P_CLI_SCC_5_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_P2P_CLI_SCC_5_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_P2P_CLI_MCC_5_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_P2P_CLI_MCC_5_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_P2P_CLI_MCC_24_5_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_P2P_CLI_MCC_24_5_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_P2P_CLI_DBS_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_SAP_SCC_24_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {PM_5G, PM_5G, PM_5G},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_SAP_SCC_24_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {PM_5G, PM_5G, PM_5G},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_SAP_MCC_24_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_SAP_MCC_24_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_SAP_SCC_5_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {PM_24G, PM_24G, PM_24G},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_SAP_SCC_5_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {PM_24G, PM_24G, PM_24G},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_SAP_MCC_5_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_SAP_MCC_5_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_SAP_MCC_24_5_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_SAP_MCC_24_5_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_GO_SAP_DBS_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {PM_SCC_ON_5_SCC_ON_24, PM_SCC_ON_5_SCC_ON_24,
		PM_SCC_ON_5_SCC_ON_24},
	[PM_P2P_CLIENT_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
			PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_CLI_SAP_SCC_24_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_CLI_SAP_SCC_24_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_CLI_SAP_MCC_24_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_CLI_SAP_MCC_24_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_CLI_SAP_SCC_5_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_CLI_SAP_SCC_5_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_CLI_SAP_MCC_5_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_CLI_SAP_MCC_5_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_CLI_SAP_MCC_24_5_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_CLI_SAP_MCC_24_5_2x2] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

	[PM_P2P_CLI_SAP_DBS_1x1] = {
	[PM_STA_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_SAP_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_CLIENT_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_P2P_GO_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE},
	[PM_IBSS_MODE] = {
		PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE, PM_MAX_PCL_TYPE} },

};

/**
 * next_action_two_connection_table - table which provides next
 * action while a new connection is coming up, with one
 * connection already in the system
 */
static policy_mgr_next_action_two_connection_table_type
	pm_next_action_two_connection_dbs_1x1_table = {
	[PM_STA_24_1x1] = {PM_NOP,             PM_DBS},
	[PM_STA_24_2x2] = {PM_NOP,             PM_DBS_DOWNGRADE},
	[PM_STA_5_1x1] = {PM_DBS,             PM_NOP},
	[PM_STA_5_2x2] = {PM_DBS_DOWNGRADE,   PM_NOP},
	[PM_P2P_CLI_24_1x1] = {PM_NOP,             PM_DBS},
	[PM_P2P_CLI_24_2x2] = {PM_NOP,             PM_DBS_DOWNGRADE},
	[PM_P2P_CLI_5_1x1] = {PM_DBS,             PM_NOP},
	[PM_P2P_CLI_5_2x2] = {PM_DBS_DOWNGRADE,   PM_NOP},
	[PM_P2P_GO_24_1x1] = {PM_NOP,             PM_DBS},
	[PM_P2P_GO_24_2x2] = {PM_NOP,             PM_DBS_DOWNGRADE},
	[PM_P2P_GO_5_1x1] = {PM_DBS,             PM_NOP},
	[PM_P2P_GO_5_2x2] = {PM_DBS_DOWNGRADE,   PM_NOP},
	[PM_SAP_24_1x1] = {PM_NOP,             PM_DBS},
	[PM_SAP_24_2x2] = {PM_NOP,             PM_DBS_DOWNGRADE},
	[PM_SAP_5_1x1] = {PM_DBS,             PM_NOP},
	[PM_SAP_5_2x2] = {PM_DBS_DOWNGRADE,   PM_NOP},
	[PM_IBSS_24_1x1] = {PM_NOP,             PM_DBS},
	[PM_IBSS_24_2x2] = {PM_NOP,             PM_DBS_DOWNGRADE},
	[PM_IBSS_5_1x1] = {PM_DBS,            PM_NOP},
	[PM_IBSS_5_2x2] = {PM_DBS_DOWNGRADE,  PM_NOP},
};

/**
 * next_action_three_connection_table - table which provides next
 * action while a new connection is coming up, with two
 * connections already in the system
 */
static policy_mgr_next_action_three_connection_table_type
	pm_next_action_three_connection_dbs_1x1_table = {
	[PM_STA_SAP_SCC_24_1x1] = {PM_NOP,		PM_DBS},
	[PM_STA_SAP_SCC_24_2x2] = {PM_NOP,            PM_DBS_DOWNGRADE},
	[PM_STA_SAP_MCC_24_1x1] = {PM_NOP,            PM_DBS},
	[PM_STA_SAP_MCC_24_2x2] = {PM_NOP,            PM_DBS_DOWNGRADE},
	[PM_STA_SAP_SCC_5_1x1] = {PM_DBS,             PM_NOP},
	[PM_STA_SAP_SCC_5_2x2] = {PM_DBS_DOWNGRADE,   PM_NOP},
	[PM_STA_SAP_MCC_5_1x1] = {PM_DBS,             PM_NOP},
	[PM_STA_SAP_MCC_5_2x2] = {PM_DBS_DOWNGRADE,   PM_NOP},
	[PM_STA_SAP_MCC_24_5_1x1] = {PM_DBS,          PM_DBS},
	[PM_STA_SAP_MCC_24_5_2x2] = {PM_DBS_DOWNGRADE, PM_DBS_DOWNGRADE},
	[PM_STA_SAP_DBS_1x1] = {PM_NOP,		PM_NOP},
	[PM_STA_P2P_GO_SCC_24_1x1] = {PM_NOP,         PM_DBS},
	[PM_STA_P2P_GO_SCC_24_2x2] = {PM_NOP,         PM_DBS_DOWNGRADE},
	[PM_STA_P2P_GO_MCC_24_1x1] = {PM_NOP,         PM_DBS},
	[PM_STA_P2P_GO_MCC_24_2x2] = {PM_NOP,         PM_DBS_DOWNGRADE},
	[PM_STA_P2P_GO_SCC_5_1x1] = {PM_DBS,          PM_NOP},
	[PM_STA_P2P_GO_SCC_5_2x2] = {PM_DBS_DOWNGRADE, PM_NOP},
	[PM_STA_P2P_GO_MCC_5_1x1] = {PM_DBS,          PM_NOP},
	[PM_STA_P2P_GO_MCC_5_2x2] = {PM_DBS_DOWNGRADE, PM_NOP},
	[PM_STA_P2P_GO_MCC_24_5_1x1] = {PM_DBS,       PM_DBS},
	[PM_STA_P2P_GO_MCC_24_5_2x2] = {
			PM_DBS_DOWNGRADE,   PM_DBS_DOWNGRADE},
	[PM_STA_P2P_GO_DBS_1x1] = {PM_NOP,             PM_NOP},
	[PM_STA_P2P_CLI_SCC_24_1x1] = {PM_NOP,             PM_DBS},
	[PM_STA_P2P_CLI_SCC_24_2x2] = {
			PM_NOP,             PM_DBS_DOWNGRADE},
	[PM_STA_P2P_CLI_MCC_24_1x1] = {PM_NOP,             PM_DBS},
	[PM_STA_P2P_CLI_MCC_24_2x2] = {
			PM_NOP,             PM_DBS_DOWNGRADE},
	[PM_STA_P2P_CLI_SCC_5_1x1] = {PM_DBS,             PM_NOP},
	[PM_STA_P2P_CLI_SCC_5_2x2] = {PM_DBS_DOWNGRADE,   PM_NOP},
	[PM_STA_P2P_CLI_MCC_5_1x1] = {PM_DBS,             PM_NOP},
	[PM_STA_P2P_CLI_MCC_5_2x2] = {PM_DBS_DOWNGRADE,   PM_NOP},
	[PM_STA_P2P_CLI_MCC_24_5_1x1] = {PM_DBS,             PM_DBS},
	[PM_STA_P2P_CLI_MCC_24_5_2x2] = {
			PM_DBS_DOWNGRADE,   PM_DBS_DOWNGRADE},
	[PM_STA_P2P_CLI_DBS_1x1] = {PM_NOP,             PM_NOP},
	[PM_P2P_GO_P2P_CLI_SCC_24_1x1] = {PM_NOP,             PM_DBS},
	[PM_P2P_GO_P2P_CLI_SCC_24_2x2] = {
			PM_NOP,             PM_DBS_DOWNGRADE},
	[PM_P2P_GO_P2P_CLI_MCC_24_1x1] = {PM_NOP,             PM_DBS},
	[PM_P2P_GO_P2P_CLI_MCC_24_2x2] = {
			PM_NOP,             PM_DBS_DOWNGRADE},
	[PM_P2P_GO_P2P_CLI_SCC_5_1x1] = {PM_DBS,             PM_NOP},
	[PM_P2P_GO_P2P_CLI_SCC_5_2x2] = {PM_DBS_DOWNGRADE,   PM_NOP},
	[PM_P2P_GO_P2P_CLI_MCC_5_1x1] = {PM_DBS,             PM_NOP},
	[PM_P2P_GO_P2P_CLI_MCC_5_2x2] = {PM_DBS_DOWNGRADE,   PM_NOP},
	[PM_P2P_GO_P2P_CLI_MCC_24_5_1x1] = {PM_DBS,             PM_DBS},
	[PM_P2P_GO_P2P_CLI_MCC_24_5_2x2] = {
			PM_DBS_DOWNGRADE,   PM_DBS_DOWNGRADE},
	[PM_P2P_GO_P2P_CLI_DBS_1x1] = {PM_NOP,             PM_NOP},
	[PM_P2P_GO_SAP_SCC_24_1x1] = {PM_NOP,             PM_DBS},
	[PM_P2P_GO_SAP_SCC_24_2x2] = {PM_NOP,             PM_DBS_DOWNGRADE},
	[PM_P2P_GO_SAP_MCC_24_1x1] = {PM_NOP,             PM_DBS},
	[PM_P2P_GO_SAP_MCC_24_2x2] = {PM_NOP,             PM_DBS_DOWNGRADE},
	[PM_P2P_GO_SAP_SCC_5_1x1] = {PM_DBS,             PM_NOP},
	[PM_P2P_GO_SAP_SCC_5_2x2] = {PM_DBS_DOWNGRADE,   PM_NOP},
	[PM_P2P_GO_SAP_MCC_5_1x1] = {PM_DBS,             PM_NOP},
	[PM_P2P_GO_SAP_MCC_5_2x2] = {PM_DBS_DOWNGRADE,   PM_NOP},
	[PM_P2P_GO_SAP_MCC_24_5_1x1] = {PM_DBS,             PM_DBS},
	[PM_P2P_GO_SAP_MCC_24_5_2x2] = {
			PM_DBS_DOWNGRADE,   PM_DBS_DOWNGRADE},
	[PM_P2P_GO_SAP_DBS_1x1] = {PM_NOP,             PM_NOP},
	[PM_P2P_CLI_SAP_SCC_24_1x1] = {PM_NOP,             PM_DBS},
	[PM_P2P_CLI_SAP_SCC_24_2x2] = {PM_NOP,             PM_DBS_DOWNGRADE},
	[PM_P2P_CLI_SAP_MCC_24_1x1] = {PM_NOP,             PM_DBS},
	[PM_P2P_CLI_SAP_MCC_24_2x2] = {PM_NOP,             PM_DBS_DOWNGRADE},
	[PM_P2P_CLI_SAP_SCC_5_1x1] = {PM_DBS,             PM_NOP},
	[PM_P2P_CLI_SAP_SCC_5_2x2] = {PM_DBS_DOWNGRADE,   PM_NOP},
	[PM_P2P_CLI_SAP_MCC_5_1x1] = {PM_DBS,             PM_NOP},
	[PM_P2P_CLI_SAP_MCC_5_2x2] = {PM_DBS_DOWNGRADE,   PM_NOP},
	[PM_P2P_CLI_SAP_MCC_24_5_1x1] = {PM_DBS,             PM_DBS},
	[PM_P2P_CLI_SAP_MCC_24_5_2x2] = {PM_DBS_DOWNGRADE, PM_DBS_DOWNGRADE},
	[PM_P2P_CLI_SAP_DBS_1x1] = {PM_NOP,             PM_NOP},

	[PM_SAP_SAP_SCC_24_1x1] = {PM_NOP, PM_DBS},
	[PM_SAP_SAP_SCC_5_1x1] = {PM_DBS, PM_NOP},

};

#endif
