/*
 * Copyright 2016 Freescale Semiconductor, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0+
 */

#ifndef __ASM_ARCH_IMX7ULP_PINS_H__
#define __ASM_ARCH_IMX7ULP_PINS_H__

#include <asm/arch/iomux.h>

enum {
	MX7ULP_PAD_PTA0__CMP0_IN1_3V                                 = IOMUX_PAD(0xD000, 0xD000, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA0__PTA0                                        = IOMUX_PAD(0xD000, 0xD000, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA0__LPSPI0_PCS1                                 = IOMUX_PAD(0xD000, 0xD000, IOMUX_CONFIG_MPORTS | 0x3, 0xD104, 0x2, 0),
	MX7ULP_PAD_PTA0__LPUART0_CTS_B                               = IOMUX_PAD(0xD000, 0xD000, IOMUX_CONFIG_MPORTS | 0x4, 0xD1F8, 0x2, 0),
	MX7ULP_PAD_PTA0__LPI2C0_SCL                                  = IOMUX_PAD(0xD000, 0xD000, IOMUX_CONFIG_MPORTS | 0x5, 0xD17C, 0x2, 0),
	MX7ULP_PAD_PTA0__TPM0_CLKIN                                  = IOMUX_PAD(0xD000, 0xD000, IOMUX_CONFIG_MPORTS | 0x6, 0xD1A8, 0x2, 0),
	MX7ULP_PAD_PTA0__I2S0_RX_BCLK                                = IOMUX_PAD(0xD000, 0xD000, IOMUX_CONFIG_MPORTS | 0x7, 0xD1B8, 0x2, 0),
	MX7ULP_PAD_PTA0__LLWU0_P0                                    = IOMUX_PAD(0xD000, 0xD000, IOMUX_CONFIG_MPORTS | 0xd, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA1__CMP0_IN2_3V                                 = IOMUX_PAD(0xD004, 0xD004, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA1__PTA1                                        = IOMUX_PAD(0xD004, 0xD004, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA1__LPSPI0_PCS2                                 = IOMUX_PAD(0xD004, 0xD004, IOMUX_CONFIG_MPORTS | 0x3, 0xD108, 0x1, 0),
	MX7ULP_PAD_PTA1__LPUART0_RTS_B                               = IOMUX_PAD(0xD004, 0xD004, IOMUX_CONFIG_MPORTS | 0x4, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA1__LPI2C0_SDA                                  = IOMUX_PAD(0xD004, 0xD004, IOMUX_CONFIG_MPORTS | 0x5, 0xD180, 0x1, 0),
	MX7ULP_PAD_PTA1__TPM0_CH0                                    = IOMUX_PAD(0xD004, 0xD004, IOMUX_CONFIG_MPORTS | 0x6, 0xD138, 0x1, 0),
	MX7ULP_PAD_PTA1__I2S0_RX_FS                                  = IOMUX_PAD(0xD004, 0xD004, IOMUX_CONFIG_MPORTS | 0x7, 0xD1BC, 0x1, 0),
	MX7ULP_PAD_PTA2__CMP1_IN2_3V                                 = IOMUX_PAD(0xD008, 0xD008, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA2__PTA2                                        = IOMUX_PAD(0xD008, 0xD008, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA2__LPSPI0_PCS3                                 = IOMUX_PAD(0xD008, 0xD008, IOMUX_CONFIG_MPORTS | 0x3, 0xD10C, 0x1, 0),
	MX7ULP_PAD_PTA2__LPUART0_TX                                  = IOMUX_PAD(0xD008, 0xD008, IOMUX_CONFIG_MPORTS | 0x4, 0xD200, 0x1, 0),
	MX7ULP_PAD_PTA2__LPI2C0_HREQ                                 = IOMUX_PAD(0xD008, 0xD008, IOMUX_CONFIG_MPORTS | 0x5, 0xD178, 0x1, 0),
	MX7ULP_PAD_PTA2__TPM0_CH1                                    = IOMUX_PAD(0xD008, 0xD008, IOMUX_CONFIG_MPORTS | 0x6, 0xD13C, 0x1, 0),
	MX7ULP_PAD_PTA2__I2S0_RXD0                                   = IOMUX_PAD(0xD008, 0xD008, IOMUX_CONFIG_MPORTS | 0x7, 0xD1DC, 0x1, 0),
	MX7ULP_PAD_PTA3__CMP1_IN4_3V                                 = IOMUX_PAD(0xD00C, 0xD00C, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA3__PTA3                                        = IOMUX_PAD(0xD00C, 0xD00C, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA3__LPSPI0_PCS0                                 = IOMUX_PAD(0xD00C, 0xD00C, IOMUX_CONFIG_MPORTS | 0x3, 0xD100, 0x1, 0),
	MX7ULP_PAD_PTA3__LPUART0_RX                                  = IOMUX_PAD(0xD00C, 0xD00C, IOMUX_CONFIG_MPORTS | 0x4, 0xD1FC, 0x1, 0),
	MX7ULP_PAD_PTA3__TPM0_CH2                                    = IOMUX_PAD(0xD00C, 0xD00C, IOMUX_CONFIG_MPORTS | 0x6, 0xD140, 0x1, 0),
	MX7ULP_PAD_PTA3__I2S0_RXD1                                   = IOMUX_PAD(0xD00C, 0xD00C, IOMUX_CONFIG_MPORTS | 0x7, 0xD1E0, 0x1, 0),
	MX7ULP_PAD_PTA3__CMP0_OUT                                    = IOMUX_PAD(0xD00C, 0xD00C, IOMUX_CONFIG_MPORTS | 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA3__LLWU0_P1                                    = IOMUX_PAD(0xD00C, 0xD00C, IOMUX_CONFIG_MPORTS | 0xd, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA4__ADC1_CH3A                                   = IOMUX_PAD(0xD010, 0xD010, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA4__PTA4                                        = IOMUX_PAD(0xD010, 0xD010, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA4__LPSPI0_SIN                                  = IOMUX_PAD(0xD010, 0xD010, IOMUX_CONFIG_MPORTS | 0x3, 0xD114, 0x1, 0),
	MX7ULP_PAD_PTA4__LPUART1_CTS_B                               = IOMUX_PAD(0xD010, 0xD010, IOMUX_CONFIG_MPORTS | 0x4, 0xD204, 0x1, 0),
	MX7ULP_PAD_PTA4__LPI2C1_SCL                                  = IOMUX_PAD(0xD010, 0xD010, IOMUX_CONFIG_MPORTS | 0x5, 0xD188, 0x1, 0),
	MX7ULP_PAD_PTA4__TPM0_CH3                                    = IOMUX_PAD(0xD010, 0xD010, IOMUX_CONFIG_MPORTS | 0x6, 0xD144, 0x1, 0),
	MX7ULP_PAD_PTA4__I2S0_MCLK                                   = IOMUX_PAD(0xD010, 0xD010, IOMUX_CONFIG_MPORTS | 0x7, 0xD1B4, 0x1, 0),
	MX7ULP_PAD_PTA5__ADC1_CH3B                                   = IOMUX_PAD(0xD014, 0xD014, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA5__PTA5                                        = IOMUX_PAD(0xD014, 0xD014, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA5__LPSPI0_SOUT                                 = IOMUX_PAD(0xD014, 0xD014, IOMUX_CONFIG_MPORTS | 0x3, 0xD118, 0x1, 0),
	MX7ULP_PAD_PTA5__LPUART1_RTS_B                               = IOMUX_PAD(0xD014, 0xD014, IOMUX_CONFIG_MPORTS | 0x4, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA5__LPI2C1_SDA                                  = IOMUX_PAD(0xD014, 0xD014, IOMUX_CONFIG_MPORTS | 0x5, 0xD18C, 0x1, 0),
	MX7ULP_PAD_PTA5__TPM0_CH4                                    = IOMUX_PAD(0xD014, 0xD014, IOMUX_CONFIG_MPORTS | 0x6, 0xD148, 0x1, 0),
	MX7ULP_PAD_PTA5__I2S0_TX_BCLK                                = IOMUX_PAD(0xD014, 0xD014, IOMUX_CONFIG_MPORTS | 0x7, 0xD1C0, 0x1, 0),
	MX7ULP_PAD_PTA6__ADC1_CH4A                                   = IOMUX_PAD(0xD018, 0xD018, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA6__PTA6                                        = IOMUX_PAD(0xD018, 0xD018, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA6__LPSPI0_SCK                                  = IOMUX_PAD(0xD018, 0xD018, IOMUX_CONFIG_MPORTS | 0x3, 0xD110, 0x1, 0),
	MX7ULP_PAD_PTA6__LPUART1_TX                                  = IOMUX_PAD(0xD018, 0xD018, IOMUX_CONFIG_MPORTS | 0x4, 0xD20C, 0x1, 0),
	MX7ULP_PAD_PTA6__LPI2C1_HREQ                                 = IOMUX_PAD(0xD018, 0xD018, IOMUX_CONFIG_MPORTS | 0x5, 0xD184, 0x1, 0),
	MX7ULP_PAD_PTA6__TPM0_CH5                                    = IOMUX_PAD(0xD018, 0xD018, IOMUX_CONFIG_MPORTS | 0x6, 0xD14C, 0x1, 0),
	MX7ULP_PAD_PTA6__I2S0_TX_FS                                  = IOMUX_PAD(0xD018, 0xD018, IOMUX_CONFIG_MPORTS | 0x7, 0xD1C4, 0x1, 0),
	MX7ULP_PAD_PTA7__ADC1_CH4B                                   = IOMUX_PAD(0xD01C, 0xD01C, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA7__PTA7                                        = IOMUX_PAD(0xD01C, 0xD01C, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA7__LPUART1_RX                                  = IOMUX_PAD(0xD01C, 0xD01C, IOMUX_CONFIG_MPORTS | 0x4, 0xD208, 0x1, 0),
	MX7ULP_PAD_PTA7__TPM1_CH1                                    = IOMUX_PAD(0xD01C, 0xD01C, IOMUX_CONFIG_MPORTS | 0x6, 0xD154, 0x1, 0),
	MX7ULP_PAD_PTA7__I2S0_TXD0                                   = IOMUX_PAD(0xD01C, 0xD01C, IOMUX_CONFIG_MPORTS | 0x7, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA8__ADC1_CH5A                                   = IOMUX_PAD(0xD020, 0xD020, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA8__PTA8                                        = IOMUX_PAD(0xD020, 0xD020, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA8__LPSPI1_PCS1                                 = IOMUX_PAD(0xD020, 0xD020, IOMUX_CONFIG_MPORTS | 0x3, 0xD120, 0x1, 0),
	MX7ULP_PAD_PTA8__LPUART2_CTS_B                               = IOMUX_PAD(0xD020, 0xD020, IOMUX_CONFIG_MPORTS | 0x4, 0xD210, 0x1, 0),
	MX7ULP_PAD_PTA8__LPI2C2_SCL                                  = IOMUX_PAD(0xD020, 0xD020, IOMUX_CONFIG_MPORTS | 0x5, 0xD194, 0x1, 0),
	MX7ULP_PAD_PTA8__TPM1_CLKIN                                  = IOMUX_PAD(0xD020, 0xD020, IOMUX_CONFIG_MPORTS | 0x6, 0xD1AC, 0x1, 0),
	MX7ULP_PAD_PTA8__I2S0_TXD1                                   = IOMUX_PAD(0xD020, 0xD020, IOMUX_CONFIG_MPORTS | 0x7, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA9__ADC1_CH5B                                   = IOMUX_PAD(0xD024, 0xD024, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA9__PTA9                                        = IOMUX_PAD(0xD024, 0xD024, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA9__LPSPI1_PCS2                                 = IOMUX_PAD(0xD024, 0xD024, IOMUX_CONFIG_MPORTS | 0x3, 0xD124, 0x1, 0),
	MX7ULP_PAD_PTA9__LPUART2_RTS_B                               = IOMUX_PAD(0xD024, 0xD024, IOMUX_CONFIG_MPORTS | 0x4, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA9__LPI2C2_SDA                                  = IOMUX_PAD(0xD024, 0xD024, IOMUX_CONFIG_MPORTS | 0x5, 0xD198, 0x1, 0),
	MX7ULP_PAD_PTA9__TPM1_CH0                                    = IOMUX_PAD(0xD024, 0xD024, IOMUX_CONFIG_MPORTS | 0x6, 0xD150, 0x1, 0),
	MX7ULP_PAD_PTA9__NMI0_B                                      = IOMUX_PAD(0xD024, 0xD024, IOMUX_CONFIG_MPORTS | 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA10__ADC1_CH6A                                  = IOMUX_PAD(0xD028, 0xD028, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA10__PTA10                                      = IOMUX_PAD(0xD028, 0xD028, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA10__LPSPI1_PCS3                                = IOMUX_PAD(0xD028, 0xD028, IOMUX_CONFIG_MPORTS | 0x3, 0xD128, 0x1, 0),
	MX7ULP_PAD_PTA10__LPUART2_TX                                 = IOMUX_PAD(0xD028, 0xD028, IOMUX_CONFIG_MPORTS | 0x4, 0xD218, 0x1, 0),
	MX7ULP_PAD_PTA10__LPI2C2_HREQ                                = IOMUX_PAD(0xD028, 0xD028, IOMUX_CONFIG_MPORTS | 0x5, 0xD190, 0x1, 0),
	MX7ULP_PAD_PTA10__TPM2_CLKIN                                 = IOMUX_PAD(0xD028, 0xD028, IOMUX_CONFIG_MPORTS | 0x6, 0xD1F4, 0x1, 0),
	MX7ULP_PAD_PTA10__I2S0_RX_BCLK                               = IOMUX_PAD(0xD028, 0xD028, IOMUX_CONFIG_MPORTS | 0x7, 0xD1B8, 0x1, 0),
	MX7ULP_PAD_PTA11__ADC1_CH6B                                  = IOMUX_PAD(0xD02C, 0xD02C, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA11__PTA11                                      = IOMUX_PAD(0xD02C, 0xD02C, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA11__LPUART2_RX                                 = IOMUX_PAD(0xD02C, 0xD02C, IOMUX_CONFIG_MPORTS | 0x4, 0xD214, 0x1, 0),
	MX7ULP_PAD_PTA11__TPM2_CH0                                   = IOMUX_PAD(0xD02C, 0xD02C, IOMUX_CONFIG_MPORTS | 0x6, 0xD158, 0x1, 0),
	MX7ULP_PAD_PTA11__I2S0_RX_FS                                 = IOMUX_PAD(0xD02C, 0xD02C, IOMUX_CONFIG_MPORTS | 0x7, 0xD1BC, 0x2, 0),
	MX7ULP_PAD_PTA12__ADC1_CH7A                                  = IOMUX_PAD(0xD030, 0xD030, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA12__PTA12                                      = IOMUX_PAD(0xD030, 0xD030, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA12__LPSPI1_SIN                                 = IOMUX_PAD(0xD030, 0xD030, IOMUX_CONFIG_MPORTS | 0x3, 0xD130, 0x1, 0),
	MX7ULP_PAD_PTA12__LPUART3_CTS_B                              = IOMUX_PAD(0xD030, 0xD030, IOMUX_CONFIG_MPORTS | 0x4, 0xD21C, 0x1, 0),
	MX7ULP_PAD_PTA12__LPI2C3_SCL                                 = IOMUX_PAD(0xD030, 0xD030, IOMUX_CONFIG_MPORTS | 0x5, 0xD1A0, 0x1, 0),
	MX7ULP_PAD_PTA12__TPM2_CH1                                   = IOMUX_PAD(0xD030, 0xD030, IOMUX_CONFIG_MPORTS | 0x6, 0xD15C, 0x1, 0),
	MX7ULP_PAD_PTA12__I2S0_RXD0                                  = IOMUX_PAD(0xD030, 0xD030, IOMUX_CONFIG_MPORTS | 0x7, 0xD1DC, 0x2, 0),
	MX7ULP_PAD_PTA13__ADC1_CH7B                                  = IOMUX_PAD(0xD034, 0xD034, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA13__PTA13                                      = IOMUX_PAD(0xD034, 0xD034, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA13__LPSPI1_SOUT                                = IOMUX_PAD(0xD034, 0xD034, IOMUX_CONFIG_MPORTS | 0x3, 0xD134, 0x2, 0),
	MX7ULP_PAD_PTA13__LPUART3_RTS_B                              = IOMUX_PAD(0xD034, 0xD034, IOMUX_CONFIG_MPORTS | 0x4, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA13__LPI2C3_SDA                                 = IOMUX_PAD(0xD034, 0xD034, IOMUX_CONFIG_MPORTS | 0x5, 0xD1A4, 0x2, 0),
	MX7ULP_PAD_PTA13__TPM3_CLKIN                                 = IOMUX_PAD(0xD034, 0xD034, IOMUX_CONFIG_MPORTS | 0x6, 0xD1B0, 0x1, 0),
	MX7ULP_PAD_PTA13__I2S0_RXD1                                  = IOMUX_PAD(0xD034, 0xD034, IOMUX_CONFIG_MPORTS | 0x7, 0xD1E0, 0x2, 0),
	MX7ULP_PAD_PTA13__CMP0_OUT                                   = IOMUX_PAD(0xD034, 0xD034, IOMUX_CONFIG_MPORTS | 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA13__LLWU0_P2                                   = IOMUX_PAD(0xD034, 0xD034, IOMUX_CONFIG_MPORTS | 0xd, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA14__ADC1_CH8A                                  = IOMUX_PAD(0xD038, 0xD038, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA14__PTA14                                      = IOMUX_PAD(0xD038, 0xD038, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA14__LPSPI1_SCK                                 = IOMUX_PAD(0xD038, 0xD038, IOMUX_CONFIG_MPORTS | 0x3, 0xD12C, 0x2, 0),
	MX7ULP_PAD_PTA14__LPUART3_TX                                 = IOMUX_PAD(0xD038, 0xD038, IOMUX_CONFIG_MPORTS | 0x4, 0xD224, 0x2, 0),
	MX7ULP_PAD_PTA14__LPI2C3_HREQ                                = IOMUX_PAD(0xD038, 0xD038, IOMUX_CONFIG_MPORTS | 0x5, 0xD19C, 0x2, 0),
	MX7ULP_PAD_PTA14__TPM3_CH0                                   = IOMUX_PAD(0xD038, 0xD038, IOMUX_CONFIG_MPORTS | 0x6, 0xD160, 0x1, 0),
	MX7ULP_PAD_PTA14__I2S0_MCLK                                  = IOMUX_PAD(0xD038, 0xD038, IOMUX_CONFIG_MPORTS | 0x7, 0xD1B4, 0x2, 0),
	MX7ULP_PAD_PTA14__LLWU0_P3                                   = IOMUX_PAD(0xD038, 0xD038, IOMUX_CONFIG_MPORTS | 0xd, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA15__ADC1_CH8B                                  = IOMUX_PAD(0xD03C, 0xD03C, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA15__PTA15                                      = IOMUX_PAD(0xD03C, 0xD03C, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA15__LPSPI1_PCS0                                = IOMUX_PAD(0xD03C, 0xD03C, IOMUX_CONFIG_MPORTS | 0x3, 0xD11C, 0x1, 0),
	MX7ULP_PAD_PTA15__LPUART3_RX                                 = IOMUX_PAD(0xD03C, 0xD03C, IOMUX_CONFIG_MPORTS | 0x4, 0xD220, 0x1, 0),
	MX7ULP_PAD_PTA15__TPM3_CH1                                   = IOMUX_PAD(0xD03C, 0xD03C, IOMUX_CONFIG_MPORTS | 0x6, 0xD164, 0x1, 0),
	MX7ULP_PAD_PTA15__I2S0_TX_BCLK                               = IOMUX_PAD(0xD03C, 0xD03C, IOMUX_CONFIG_MPORTS | 0x7, 0xD1C0, 0x2, 0),
	MX7ULP_PAD_PTA16__CMP1_IN5_3V                                = IOMUX_PAD(0xD040, 0xD040, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA16__PTA16                                      = IOMUX_PAD(0xD040, 0xD040, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA16__FXIO0_D0                                   = IOMUX_PAD(0xD040, 0xD040, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA16__LPSPI0_SOUT                                = IOMUX_PAD(0xD040, 0xD040, IOMUX_CONFIG_MPORTS | 0x3, 0xD118, 0x2, 0),
	MX7ULP_PAD_PTA16__LPUART0_CTS_B                              = IOMUX_PAD(0xD040, 0xD040, IOMUX_CONFIG_MPORTS | 0x4, 0xD1F8, 0x1, 0),
	MX7ULP_PAD_PTA16__LPI2C0_SCL                                 = IOMUX_PAD(0xD040, 0xD040, IOMUX_CONFIG_MPORTS | 0x5, 0xD17C, 0x1, 0),
	MX7ULP_PAD_PTA16__TPM3_CH2                                   = IOMUX_PAD(0xD040, 0xD040, IOMUX_CONFIG_MPORTS | 0x6, 0xD168, 0x1, 0),
	MX7ULP_PAD_PTA16__I2S0_TX_FS                                 = IOMUX_PAD(0xD040, 0xD040, IOMUX_CONFIG_MPORTS | 0x7, 0xD1C4, 0x2, 0),
	MX7ULP_PAD_PTA17__CMP1_IN6_3V                                = IOMUX_PAD(0xD044, 0xD044, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA17__PTA17                                      = IOMUX_PAD(0xD044, 0xD044, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA17__FXIO0_D1                                   = IOMUX_PAD(0xD044, 0xD044, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA17__LPSPI0_SCK                                 = IOMUX_PAD(0xD044, 0xD044, IOMUX_CONFIG_MPORTS | 0x3, 0xD110, 0x2, 0),
	MX7ULP_PAD_PTA17__LPUART0_RTS_B                              = IOMUX_PAD(0xD044, 0xD044, IOMUX_CONFIG_MPORTS | 0x4, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA17__LPI2C0_SDA                                 = IOMUX_PAD(0xD044, 0xD044, IOMUX_CONFIG_MPORTS | 0x5, 0xD180, 0x2, 0),
	MX7ULP_PAD_PTA17__TPM3_CH3                                   = IOMUX_PAD(0xD044, 0xD044, IOMUX_CONFIG_MPORTS | 0x6, 0xD16C, 0x1, 0),
	MX7ULP_PAD_PTA17__I2S0_TXD0                                  = IOMUX_PAD(0xD044, 0xD044, IOMUX_CONFIG_MPORTS | 0x7, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA18__CMP1_IN1_3V                                = IOMUX_PAD(0xD048, 0xD048, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA18__PTA18                                      = IOMUX_PAD(0xD048, 0xD048, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA18__FXIO0_D2                                   = IOMUX_PAD(0xD048, 0xD048, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA18__LPSPI0_PCS0                                = IOMUX_PAD(0xD048, 0xD048, IOMUX_CONFIG_MPORTS | 0x3, 0xD100, 0x2, 0),
	MX7ULP_PAD_PTA18__LPUART0_TX                                 = IOMUX_PAD(0xD048, 0xD048, IOMUX_CONFIG_MPORTS | 0x4, 0xD200, 0x2, 0),
	MX7ULP_PAD_PTA18__LPI2C0_HREQ                                = IOMUX_PAD(0xD048, 0xD048, IOMUX_CONFIG_MPORTS | 0x5, 0xD178, 0x2, 0),
	MX7ULP_PAD_PTA18__TPM3_CH4                                   = IOMUX_PAD(0xD048, 0xD048, IOMUX_CONFIG_MPORTS | 0x6, 0xD170, 0x1, 0),
	MX7ULP_PAD_PTA18__I2S0_TXD1                                  = IOMUX_PAD(0xD048, 0xD048, IOMUX_CONFIG_MPORTS | 0x7, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA18__LLWU0_P4                                   = IOMUX_PAD(0xD048, 0xD048, IOMUX_CONFIG_MPORTS | 0xd, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA19__CMP1_IN3_3V                                = IOMUX_PAD(0xD04C, 0xD04C, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA19__PTA19                                      = IOMUX_PAD(0xD04C, 0xD04C, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA19__FXIO0_D3                                   = IOMUX_PAD(0xD04C, 0xD04C, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA19__LPUART0_RX                                 = IOMUX_PAD(0xD04C, 0xD04C, IOMUX_CONFIG_MPORTS | 0x4, 0xD1FC, 0x2, 0),
	MX7ULP_PAD_PTA19__TPM3_CH5                                   = IOMUX_PAD(0xD04C, 0xD04C, IOMUX_CONFIG_MPORTS | 0x6, 0xD174, 0x1, 0),
	MX7ULP_PAD_PTA19__I2S1_RX_BCLK                               = IOMUX_PAD(0xD04C, 0xD04C, IOMUX_CONFIG_MPORTS | 0x7, 0xD1CC, 0x1, 0),
	MX7ULP_PAD_PTA19__LPTMR0_ALT3                                = IOMUX_PAD(0xD04C, 0xD04C, IOMUX_CONFIG_MPORTS | 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA19__LLWU0_P5                                   = IOMUX_PAD(0xD04C, 0xD04C, IOMUX_CONFIG_MPORTS | 0xd, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA20__ADC0_10A                                   = IOMUX_PAD(0xD050, 0xD050, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA20__PTA20                                      = IOMUX_PAD(0xD050, 0xD050, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA20__FXIO0_D4                                   = IOMUX_PAD(0xD050, 0xD050, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA20__LPSPI0_SIN                                 = IOMUX_PAD(0xD050, 0xD050, IOMUX_CONFIG_MPORTS | 0x3, 0xD114, 0x2, 0),
	MX7ULP_PAD_PTA20__LPUART1_CTS_B                              = IOMUX_PAD(0xD050, 0xD050, IOMUX_CONFIG_MPORTS | 0x4, 0xD204, 0x2, 0),
	MX7ULP_PAD_PTA20__LPI2C1_SCL                                 = IOMUX_PAD(0xD050, 0xD050, IOMUX_CONFIG_MPORTS | 0x5, 0xD188, 0x2, 0),
	MX7ULP_PAD_PTA20__TPM0_CLKIN                                 = IOMUX_PAD(0xD050, 0xD050, IOMUX_CONFIG_MPORTS | 0x6, 0xD1A8, 0x1, 0),
	MX7ULP_PAD_PTA20__I2S1_RX_FS                                 = IOMUX_PAD(0xD050, 0xD050, IOMUX_CONFIG_MPORTS | 0x7, 0xD1D0, 0x1, 0),
	MX7ULP_PAD_PTA21__ADC0_CH10B                                 = IOMUX_PAD(0xD054, 0xD054, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA21__PTA21                                      = IOMUX_PAD(0xD054, 0xD054, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA21__FXIO0_D5                                   = IOMUX_PAD(0xD054, 0xD054, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA21__LPSPI0_PCS1                                = IOMUX_PAD(0xD054, 0xD054, IOMUX_CONFIG_MPORTS | 0x3, 0xD104, 0x1, 0),
	MX7ULP_PAD_PTA21__LPUART1_RTS_B                              = IOMUX_PAD(0xD054, 0xD054, IOMUX_CONFIG_MPORTS | 0x4, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA21__LPI2C1_SDA                                 = IOMUX_PAD(0xD054, 0xD054, IOMUX_CONFIG_MPORTS | 0x5, 0xD18C, 0x2, 0),
	MX7ULP_PAD_PTA21__TPM0_CH0                                   = IOMUX_PAD(0xD054, 0xD054, IOMUX_CONFIG_MPORTS | 0x6, 0xD138, 0x2, 0),
	MX7ULP_PAD_PTA21__I2S1_RXD0                                  = IOMUX_PAD(0xD054, 0xD054, IOMUX_CONFIG_MPORTS | 0x7, 0xD1E4, 0x1, 0),
	MX7ULP_PAD_PTA22__ADC0_CH9A                                  = IOMUX_PAD(0xD058, 0xD058, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA22__PTA22                                      = IOMUX_PAD(0xD058, 0xD058, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA22__FXIO0_D6                                   = IOMUX_PAD(0xD058, 0xD058, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA22__LPSPI0_PCS2                                = IOMUX_PAD(0xD058, 0xD058, IOMUX_CONFIG_MPORTS | 0x3, 0xD108, 0x2, 0),
	MX7ULP_PAD_PTA22__LPUART1_TX                                 = IOMUX_PAD(0xD058, 0xD058, IOMUX_CONFIG_MPORTS | 0x4, 0xD20C, 0x2, 0),
	MX7ULP_PAD_PTA22__LPI2C1_HREQ                                = IOMUX_PAD(0xD058, 0xD058, IOMUX_CONFIG_MPORTS | 0x5, 0xD184, 0x2, 0),
	MX7ULP_PAD_PTA22__TPM0_CH1                                   = IOMUX_PAD(0xD058, 0xD058, IOMUX_CONFIG_MPORTS | 0x6, 0xD13C, 0x2, 0),
	MX7ULP_PAD_PTA22__I2S1_RXD1                                  = IOMUX_PAD(0xD058, 0xD058, IOMUX_CONFIG_MPORTS | 0x7, 0xD1E8, 0x1, 0),
	MX7ULP_PAD_PTA22__LPTMR0_ALT2                                = IOMUX_PAD(0xD058, 0xD058, IOMUX_CONFIG_MPORTS | 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA22__EWM_OUT_B                                  = IOMUX_PAD(0xD058, 0xD058, IOMUX_CONFIG_MPORTS | 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA23__ADC0_CH9B                                  = IOMUX_PAD(0xD05C, 0xD05C, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA23__PTA23                                      = IOMUX_PAD(0xD05C, 0xD05C, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA23__FXIO0_D7                                   = IOMUX_PAD(0xD05C, 0xD05C, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA23__LPSPI0_PCS3                                = IOMUX_PAD(0xD05C, 0xD05C, IOMUX_CONFIG_MPORTS | 0x3, 0xD10C, 0x2, 0),
	MX7ULP_PAD_PTA23__LPUART1_RX                                 = IOMUX_PAD(0xD05C, 0xD05C, IOMUX_CONFIG_MPORTS | 0x4, 0xD208, 0x2, 0),
	MX7ULP_PAD_PTA23__TPM0_CH2                                   = IOMUX_PAD(0xD05C, 0xD05C, IOMUX_CONFIG_MPORTS | 0x6, 0xD140, 0x2, 0),
	MX7ULP_PAD_PTA23__I2S1_MCLK                                  = IOMUX_PAD(0xD05C, 0xD05C, IOMUX_CONFIG_MPORTS | 0x7, 0xD1C8, 0x1, 0),
	MX7ULP_PAD_PTA23__LLWU0_P6                                   = IOMUX_PAD(0xD05C, 0xD05C, IOMUX_CONFIG_MPORTS | 0xd, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA24__ADC0_CH8A                                  = IOMUX_PAD(0xD060, 0xD060, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA24__PTA24                                      = IOMUX_PAD(0xD060, 0xD060, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA24__FXIO0_D8                                   = IOMUX_PAD(0xD060, 0xD060, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA24__LPSPI1_PCS1                                = IOMUX_PAD(0xD060, 0xD060, IOMUX_CONFIG_MPORTS | 0x3, 0xD120, 0x2, 0),
	MX7ULP_PAD_PTA24__LPUART2_CTS_B                              = IOMUX_PAD(0xD060, 0xD060, IOMUX_CONFIG_MPORTS | 0x4, 0xD210, 0x2, 0),
	MX7ULP_PAD_PTA24__LPI2C2_SCL                                 = IOMUX_PAD(0xD060, 0xD060, IOMUX_CONFIG_MPORTS | 0x5, 0xD194, 0x2, 0),
	MX7ULP_PAD_PTA24__TPM0_CH3                                   = IOMUX_PAD(0xD060, 0xD060, IOMUX_CONFIG_MPORTS | 0x6, 0xD144, 0x2, 0),
	MX7ULP_PAD_PTA24__I2S1_TX_BCLK                               = IOMUX_PAD(0xD060, 0xD060, IOMUX_CONFIG_MPORTS | 0x7, 0xD1D4, 0x1, 0),
	MX7ULP_PAD_PTA25__ADC0_CH8B                                  = IOMUX_PAD(0xD064, 0xD064, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA25__PTA25                                      = IOMUX_PAD(0xD064, 0xD064, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA25__FXIO0_D9                                   = IOMUX_PAD(0xD064, 0xD064, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA25__LPSPI1_PCS2                                = IOMUX_PAD(0xD064, 0xD064, IOMUX_CONFIG_MPORTS | 0x3, 0xD124, 0x2, 0),
	MX7ULP_PAD_PTA25__LPUART2_RTS_B                              = IOMUX_PAD(0xD064, 0xD064, IOMUX_CONFIG_MPORTS | 0x4, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA25__LPI2C2_SDA                                 = IOMUX_PAD(0xD064, 0xD064, IOMUX_CONFIG_MPORTS | 0x5, 0xD198, 0x2, 0),
	MX7ULP_PAD_PTA25__TPM0_CH4                                   = IOMUX_PAD(0xD064, 0xD064, IOMUX_CONFIG_MPORTS | 0x6, 0xD148, 0x2, 0),
	MX7ULP_PAD_PTA25__I2S1_TX_FS                                 = IOMUX_PAD(0xD064, 0xD064, IOMUX_CONFIG_MPORTS | 0x7, 0xD1D8, 0x1, 0),
	MX7ULP_PAD_PTA26__PTA26                                      = IOMUX_PAD(0xD068, 0xD068, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA26__JTAG_TMS_SWD_DIO                           = IOMUX_PAD(0xD068, 0xD068, IOMUX_CONFIG_MPORTS | 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA26__FXIO0_D10                                  = IOMUX_PAD(0xD068, 0xD068, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA26__LPSPI1_PCS3                                = IOMUX_PAD(0xD068, 0xD068, IOMUX_CONFIG_MPORTS | 0x3, 0xD128, 0x2, 0),
	MX7ULP_PAD_PTA26__LPUART2_TX                                 = IOMUX_PAD(0xD068, 0xD068, IOMUX_CONFIG_MPORTS | 0x4, 0xD218, 0x2, 0),
	MX7ULP_PAD_PTA26__LPI2C2_HREQ                                = IOMUX_PAD(0xD068, 0xD068, IOMUX_CONFIG_MPORTS | 0x5, 0xD190, 0x2, 0),
	MX7ULP_PAD_PTA26__TPM0_CH5                                   = IOMUX_PAD(0xD068, 0xD068, IOMUX_CONFIG_MPORTS | 0x6, 0xD14C, 0x2, 0),
	MX7ULP_PAD_PTA26__I2S1_RXD2                                  = IOMUX_PAD(0xD068, 0xD068, IOMUX_CONFIG_MPORTS | 0x7, 0xD1EC, 0x1, 0),
	MX7ULP_PAD_PTA27__PTA27                                      = IOMUX_PAD(0xD06C, 0xD06C, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA27__JTAG_TDO                                   = IOMUX_PAD(0xD06C, 0xD06C, IOMUX_CONFIG_MPORTS | 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA27__FXIO0_D11                                  = IOMUX_PAD(0xD06C, 0xD06C, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA27__LPUART2_RX                                 = IOMUX_PAD(0xD06C, 0xD06C, IOMUX_CONFIG_MPORTS | 0x4, 0xD214, 0x2, 0),
	MX7ULP_PAD_PTA27__TPM1_CH1                                   = IOMUX_PAD(0xD06C, 0xD06C, IOMUX_CONFIG_MPORTS | 0x6, 0xD154, 0x2, 0),
	MX7ULP_PAD_PTA27__I2S1_RXD3                                  = IOMUX_PAD(0xD06C, 0xD06C, IOMUX_CONFIG_MPORTS | 0x7, 0xD1F0, 0x1, 0),
	MX7ULP_PAD_PTA28__PTA28                                      = IOMUX_PAD(0xD070, 0xD070, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA28__JTAG_TDI                                   = IOMUX_PAD(0xD070, 0xD070, IOMUX_CONFIG_MPORTS | 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA28__FXIO0_D12                                  = IOMUX_PAD(0xD070, 0xD070, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA28__LPSPI1_SIN                                 = IOMUX_PAD(0xD070, 0xD070, IOMUX_CONFIG_MPORTS | 0x3, 0xD130, 0x2, 0),
	MX7ULP_PAD_PTA28__LPUART3_CTS_B                              = IOMUX_PAD(0xD070, 0xD070, IOMUX_CONFIG_MPORTS | 0x4, 0xD21C, 0x2, 0),
	MX7ULP_PAD_PTA28__LPI2C3_SCL                                 = IOMUX_PAD(0xD070, 0xD070, IOMUX_CONFIG_MPORTS | 0x5, 0xD1A0, 0x2, 0),
	MX7ULP_PAD_PTA28__TPM1_CLKIN                                 = IOMUX_PAD(0xD070, 0xD070, IOMUX_CONFIG_MPORTS | 0x6, 0xD1AC, 0x2, 0),
	MX7ULP_PAD_PTA28__I2S1_TXD2                                  = IOMUX_PAD(0xD070, 0xD070, IOMUX_CONFIG_MPORTS | 0x7, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA29__PTA29                                      = IOMUX_PAD(0xD074, 0xD074, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA29__JTAG_TCLK_SWD_CLK                          = IOMUX_PAD(0xD074, 0xD074, IOMUX_CONFIG_MPORTS | 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA29__FXIO0_D13                                  = IOMUX_PAD(0xD074, 0xD074, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA29__LPSPI1_SOUT                                = IOMUX_PAD(0xD074, 0xD074, IOMUX_CONFIG_MPORTS | 0x3, 0xD134, 0x1, 0),
	MX7ULP_PAD_PTA29__LPUART3_RTS_B                              = IOMUX_PAD(0xD074, 0xD074, IOMUX_CONFIG_MPORTS | 0x4, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA29__LPI2C3_SDA                                 = IOMUX_PAD(0xD074, 0xD074, IOMUX_CONFIG_MPORTS | 0x5, 0xD1A4, 0x1, 0),
	MX7ULP_PAD_PTA29__TPM1_CH0                                   = IOMUX_PAD(0xD074, 0xD074, IOMUX_CONFIG_MPORTS | 0x6, 0xD150, 0x2, 0),
	MX7ULP_PAD_PTA29__I2S1_TXD3                                  = IOMUX_PAD(0xD074, 0xD074, IOMUX_CONFIG_MPORTS | 0x7, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA30__ADC0_CH1A                                  = IOMUX_PAD(0xD078, 0xD078, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA30__PTA30                                      = IOMUX_PAD(0xD078, 0xD078, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA30__FXIO0_D14                                  = IOMUX_PAD(0xD078, 0xD078, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA30__LPSPI1_SCK                                 = IOMUX_PAD(0xD078, 0xD078, IOMUX_CONFIG_MPORTS | 0x3, 0xD12C, 0x1, 0),
	MX7ULP_PAD_PTA30__LPUART3_TX                                 = IOMUX_PAD(0xD078, 0xD078, IOMUX_CONFIG_MPORTS | 0x4, 0xD224, 0x1, 0),
	MX7ULP_PAD_PTA30__LPI2C3_HREQ                                = IOMUX_PAD(0xD078, 0xD078, IOMUX_CONFIG_MPORTS | 0x5, 0xD19C, 0x1, 0),
	MX7ULP_PAD_PTA30__TPM2_CLKIN                                 = IOMUX_PAD(0xD078, 0xD078, IOMUX_CONFIG_MPORTS | 0x6, 0xD1F4, 0x2, 0),
	MX7ULP_PAD_PTA30__I2S1_TXD0                                  = IOMUX_PAD(0xD078, 0xD078, IOMUX_CONFIG_MPORTS | 0x7, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA30__JTAG_TRST_B                                = IOMUX_PAD(0xD078, 0xD078, IOMUX_CONFIG_MPORTS | 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA31__ADC0_CH1B                                  = IOMUX_PAD(0xD07C, 0xD07C, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA31__PTA31                                      = IOMUX_PAD(0xD07C, 0xD07C, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA31__FXIO0_D15                                  = IOMUX_PAD(0xD07C, 0xD07C, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA31__LPSPI1_PCS0                                = IOMUX_PAD(0xD07C, 0xD07C, IOMUX_CONFIG_MPORTS | 0x3, 0xD11C, 0x2, 0),
	MX7ULP_PAD_PTA31__LPUART3_RX                                 = IOMUX_PAD(0xD07C, 0xD07C, IOMUX_CONFIG_MPORTS | 0x4, 0xD220, 0x2, 0),
	MX7ULP_PAD_PTA31__TPM2_CH0                                   = IOMUX_PAD(0xD07C, 0xD07C, IOMUX_CONFIG_MPORTS | 0x6, 0xD158, 0x2, 0),
	MX7ULP_PAD_PTA31__I2S1_TXD1                                  = IOMUX_PAD(0xD07C, 0xD07C, IOMUX_CONFIG_MPORTS | 0x7, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA31__LPTMR0_ALT1                                = IOMUX_PAD(0xD07C, 0xD07C, IOMUX_CONFIG_MPORTS | 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTA31__EWM_IN                                     = IOMUX_PAD(0xD07C, 0xD07C, IOMUX_CONFIG_MPORTS | 0xc, 0xD228, 0x1, 0),
	MX7ULP_PAD_PTA31__LLWU0_P7                                   = IOMUX_PAD(0xD07C, 0xD07C, IOMUX_CONFIG_MPORTS | 0xd, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB0__ADC0_CH0A                                   = IOMUX_PAD(0xD080, 0xD080, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB0__PTB0                                        = IOMUX_PAD(0xD080, 0xD080, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB0__FXIO0_D16                                   = IOMUX_PAD(0xD080, 0xD080, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB0__LPSPI0_SIN                                  = IOMUX_PAD(0xD080, 0xD080, IOMUX_CONFIG_MPORTS | 0x3, 0xD114, 0x3, 0),
	MX7ULP_PAD_PTB0__LPUART0_TX                                  = IOMUX_PAD(0xD080, 0xD080, IOMUX_CONFIG_MPORTS | 0x4, 0xD200, 0x3, 0),
	MX7ULP_PAD_PTB0__TPM2_CH1                                    = IOMUX_PAD(0xD080, 0xD080, IOMUX_CONFIG_MPORTS | 0x6, 0xD15C, 0x2, 0),
	MX7ULP_PAD_PTB0__CLKOUT0                                     = IOMUX_PAD(0xD080, 0xD080, IOMUX_CONFIG_MPORTS | 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB0__CMP1_OUT                                    = IOMUX_PAD(0xD080, 0xD080, IOMUX_CONFIG_MPORTS | 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB0__EWM_OUT_B                                   = IOMUX_PAD(0xD080, 0xD080, IOMUX_CONFIG_MPORTS | 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB1__ADC0_CH0B                                   = IOMUX_PAD(0xD084, 0xD084, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB1__PTB1                                        = IOMUX_PAD(0xD084, 0xD084, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB1__FXIO0_D17                                   = IOMUX_PAD(0xD084, 0xD084, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB1__LPSPI0_SOUT                                 = IOMUX_PAD(0xD084, 0xD084, IOMUX_CONFIG_MPORTS | 0x3, 0xD118, 0x3, 0),
	MX7ULP_PAD_PTB1__LPUART0_RX                                  = IOMUX_PAD(0xD084, 0xD084, IOMUX_CONFIG_MPORTS | 0x4, 0xD1FC, 0x3, 0),
	MX7ULP_PAD_PTB1__TPM3_CLKIN                                  = IOMUX_PAD(0xD084, 0xD084, IOMUX_CONFIG_MPORTS | 0x6, 0xD1B0, 0x3, 0),
	MX7ULP_PAD_PTB1__I2S1_TX_BCLK                                = IOMUX_PAD(0xD084, 0xD084, IOMUX_CONFIG_MPORTS | 0x7, 0xD1D4, 0x2, 0),
	MX7ULP_PAD_PTB1__RTC_CLKOUT                                  = IOMUX_PAD(0xD084, 0xD084, IOMUX_CONFIG_MPORTS | 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB1__EWM_IN                                      = IOMUX_PAD(0xD084, 0xD084, IOMUX_CONFIG_MPORTS | 0xc, 0xD228, 0x2, 0),
	MX7ULP_PAD_PTB1__LLWU0_P8                                    = IOMUX_PAD(0xD084, 0xD084, IOMUX_CONFIG_MPORTS | 0xd, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB2__ADC0_CH6A                                   = IOMUX_PAD(0xD088, 0xD088, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB2__PTB2                                        = IOMUX_PAD(0xD088, 0xD088, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB2__FXIO0_D18                                   = IOMUX_PAD(0xD088, 0xD088, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB2__LPSPI0_SCK                                  = IOMUX_PAD(0xD088, 0xD088, IOMUX_CONFIG_MPORTS | 0x3, 0xD110, 0x3, 0),
	MX7ULP_PAD_PTB2__LPUART1_TX                                  = IOMUX_PAD(0xD088, 0xD088, IOMUX_CONFIG_MPORTS | 0x4, 0xD20C, 0x3, 0),
	MX7ULP_PAD_PTB2__TPM3_CH0                                    = IOMUX_PAD(0xD088, 0xD088, IOMUX_CONFIG_MPORTS | 0x6, 0xD160, 0x2, 0),
	MX7ULP_PAD_PTB2__I2S1_TX_FS                                  = IOMUX_PAD(0xD088, 0xD088, IOMUX_CONFIG_MPORTS | 0x7, 0xD1D8, 0x2, 0),
	MX7ULP_PAD_PTB2__TRACE_CLKOUT                                = IOMUX_PAD(0xD088, 0xD088, IOMUX_CONFIG_MPORTS | 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB3__ADC0_CH6B                                   = IOMUX_PAD(0xD08C, 0xD08C, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB3__PTB3                                        = IOMUX_PAD(0xD08C, 0xD08C, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB3__FXIO0_D19                                   = IOMUX_PAD(0xD08C, 0xD08C, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB3__LPSPI0_PCS0                                 = IOMUX_PAD(0xD08C, 0xD08C, IOMUX_CONFIG_MPORTS | 0x3, 0xD100, 0x3, 0),
	MX7ULP_PAD_PTB3__LPUART1_RX                                  = IOMUX_PAD(0xD08C, 0xD08C, IOMUX_CONFIG_MPORTS | 0x4, 0xD208, 0x3, 0),
	MX7ULP_PAD_PTB3__TPM3_CH1                                    = IOMUX_PAD(0xD08C, 0xD08C, IOMUX_CONFIG_MPORTS | 0x6, 0xD164, 0x2, 0),
	MX7ULP_PAD_PTB3__I2S1_TXD0                                   = IOMUX_PAD(0xD08C, 0xD08C, IOMUX_CONFIG_MPORTS | 0x7, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB3__TRACE_D0                                    = IOMUX_PAD(0xD08C, 0xD08C, IOMUX_CONFIG_MPORTS | 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB3__LPTMR1_ALT2                                 = IOMUX_PAD(0xD08C, 0xD08C, IOMUX_CONFIG_MPORTS | 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB3__LLWU0_P9                                    = IOMUX_PAD(0xD08C, 0xD08C, IOMUX_CONFIG_MPORTS | 0xd, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB4__PTB4                                        = IOMUX_PAD(0xD090, 0xD090, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB4__FXIO0_D20                                   = IOMUX_PAD(0xD090, 0xD090, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB4__LPSPI0_PCS1                                 = IOMUX_PAD(0xD090, 0xD090, IOMUX_CONFIG_MPORTS | 0x3, 0xD104, 0x3, 0),
	MX7ULP_PAD_PTB4__LPUART2_TX                                  = IOMUX_PAD(0xD090, 0xD090, IOMUX_CONFIG_MPORTS | 0x4, 0xD218, 0x3, 0),
	MX7ULP_PAD_PTB4__LPI2C0_HREQ                                 = IOMUX_PAD(0xD090, 0xD090, IOMUX_CONFIG_MPORTS | 0x5, 0xD178, 0x3, 0),
	MX7ULP_PAD_PTB4__TPM3_CH2                                    = IOMUX_PAD(0xD090, 0xD090, IOMUX_CONFIG_MPORTS | 0x6, 0xD168, 0x2, 0),
	MX7ULP_PAD_PTB4__I2S1_TXD1                                   = IOMUX_PAD(0xD090, 0xD090, IOMUX_CONFIG_MPORTS | 0x7, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB4__QSPIA_DATA7                                 = IOMUX_PAD(0xD090, 0xD090, IOMUX_CONFIG_MPORTS | 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB4__TRACE_D1                                    = IOMUX_PAD(0xD090, 0xD090, IOMUX_CONFIG_MPORTS | 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB4__SEC_VIO_B                                   = IOMUX_PAD(0xD090, 0xD090, IOMUX_CONFIG_MPORTS | 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB5__PTB5                                        = IOMUX_PAD(0xD094, 0xD094, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB5__FXIO0_D21                                   = IOMUX_PAD(0xD094, 0xD094, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB5__LPSPI0_PCS2                                 = IOMUX_PAD(0xD094, 0xD094, IOMUX_CONFIG_MPORTS | 0x3, 0xD108, 0x3, 0),
	MX7ULP_PAD_PTB5__LPUART2_RX                                  = IOMUX_PAD(0xD094, 0xD094, IOMUX_CONFIG_MPORTS | 0x4, 0xD214, 0x3, 0),
	MX7ULP_PAD_PTB5__LPI2C1_HREQ                                 = IOMUX_PAD(0xD094, 0xD094, IOMUX_CONFIG_MPORTS | 0x5, 0xD184, 0x3, 0),
	MX7ULP_PAD_PTB5__TPM3_CH3                                    = IOMUX_PAD(0xD094, 0xD094, IOMUX_CONFIG_MPORTS | 0x6, 0xD16C, 0x2, 0),
	MX7ULP_PAD_PTB5__I2S1_TXD2                                   = IOMUX_PAD(0xD094, 0xD094, IOMUX_CONFIG_MPORTS | 0x7, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB5__QSPIA_DATA6                                 = IOMUX_PAD(0xD094, 0xD094, IOMUX_CONFIG_MPORTS | 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB5__TRACE_D2                                    = IOMUX_PAD(0xD094, 0xD094, IOMUX_CONFIG_MPORTS | 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB5__RTC_CLKOUT                                  = IOMUX_PAD(0xD094, 0xD094, IOMUX_CONFIG_MPORTS | 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB6__ADC1_CH1A                                   = IOMUX_PAD(0xD098, 0xD098, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB6__PTB6                                        = IOMUX_PAD(0xD098, 0xD098, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB6__FXIO0_D22                                   = IOMUX_PAD(0xD098, 0xD098, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB6__LPSPI0_PCS3                                 = IOMUX_PAD(0xD098, 0xD098, IOMUX_CONFIG_MPORTS | 0x3, 0xD10C, 0x3, 0),
	MX7ULP_PAD_PTB6__LPUART3_TX                                  = IOMUX_PAD(0xD098, 0xD098, IOMUX_CONFIG_MPORTS | 0x4, 0xD224, 0x3, 0),
	MX7ULP_PAD_PTB6__LPI2C0_SCL                                  = IOMUX_PAD(0xD098, 0xD098, IOMUX_CONFIG_MPORTS | 0x5, 0xD17C, 0x3, 0),
	MX7ULP_PAD_PTB6__TPM3_CH4                                    = IOMUX_PAD(0xD098, 0xD098, IOMUX_CONFIG_MPORTS | 0x6, 0xD170, 0x2, 0),
	MX7ULP_PAD_PTB6__I2S1_TXD3                                   = IOMUX_PAD(0xD098, 0xD098, IOMUX_CONFIG_MPORTS | 0x7, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB6__QSPIA_DATA5                                 = IOMUX_PAD(0xD098, 0xD098, IOMUX_CONFIG_MPORTS | 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB6__TRACE_D3                                    = IOMUX_PAD(0xD098, 0xD098, IOMUX_CONFIG_MPORTS | 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB6__LPTMR1_ALT3                                 = IOMUX_PAD(0xD098, 0xD098, IOMUX_CONFIG_MPORTS | 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB6__LLWU0_P10                                   = IOMUX_PAD(0xD098, 0xD098, IOMUX_CONFIG_MPORTS | 0xd, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB7__ADC1_CH1B                                   = IOMUX_PAD(0xD09C, 0xD09C, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB7__PTB7                                        = IOMUX_PAD(0xD09C, 0xD09C, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB7__FXIO0_D23                                   = IOMUX_PAD(0xD09C, 0xD09C, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB7__LPSPI1_SIN                                  = IOMUX_PAD(0xD09C, 0xD09C, IOMUX_CONFIG_MPORTS | 0x3, 0xD130, 0x3, 0),
	MX7ULP_PAD_PTB7__LPUART3_RX                                  = IOMUX_PAD(0xD09C, 0xD09C, IOMUX_CONFIG_MPORTS | 0x4, 0xD220, 0x3, 0),
	MX7ULP_PAD_PTB7__LPI2C0_SDA                                  = IOMUX_PAD(0xD09C, 0xD09C, IOMUX_CONFIG_MPORTS | 0x5, 0xD180, 0x3, 0),
	MX7ULP_PAD_PTB7__TPM3_CH5                                    = IOMUX_PAD(0xD09C, 0xD09C, IOMUX_CONFIG_MPORTS | 0x6, 0xD174, 0x2, 0),
	MX7ULP_PAD_PTB7__I2S1_MCLK                                   = IOMUX_PAD(0xD09C, 0xD09C, IOMUX_CONFIG_MPORTS | 0x7, 0xD1C8, 0x2, 0),
	MX7ULP_PAD_PTB7__QSPIA_SS1_B                                 = IOMUX_PAD(0xD09C, 0xD09C, IOMUX_CONFIG_MPORTS | 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB7__CMP1_OUT                                    = IOMUX_PAD(0xD09C, 0xD09C, IOMUX_CONFIG_MPORTS | 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB7__LLWU0_P11                                   = IOMUX_PAD(0xD09C, 0xD09C, IOMUX_CONFIG_MPORTS | 0xd, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB8__ADC0_CH14A_CMP0_IN0                         = IOMUX_PAD(0xD0A0, 0xD0A0, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB8__PTB8                                        = IOMUX_PAD(0xD0A0, 0xD0A0, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB8__FXIO0_D24                                   = IOMUX_PAD(0xD0A0, 0xD0A0, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB8__LPSPI1_SOUT                                 = IOMUX_PAD(0xD0A0, 0xD0A0, IOMUX_CONFIG_MPORTS | 0x3, 0xD134, 0x3, 0),
	MX7ULP_PAD_PTB8__LPI2C1_SCL                                  = IOMUX_PAD(0xD0A0, 0xD0A0, IOMUX_CONFIG_MPORTS | 0x5, 0xD188, 0x3, 0),
	MX7ULP_PAD_PTB8__TPM0_CLKIN                                  = IOMUX_PAD(0xD0A0, 0xD0A0, IOMUX_CONFIG_MPORTS | 0x6, 0xD1A8, 0x3, 0),
	MX7ULP_PAD_PTB8__I2S1_RX_BCLK                                = IOMUX_PAD(0xD0A0, 0xD0A0, IOMUX_CONFIG_MPORTS | 0x7, 0xD1CC, 0x2, 0),
	MX7ULP_PAD_PTB8__QSPIA_SS0_B                                 = IOMUX_PAD(0xD0A0, 0xD0A0, IOMUX_CONFIG_MPORTS | 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB8__RTC_CLKOUT                                  = IOMUX_PAD(0xD0A0, 0xD0A0, IOMUX_CONFIG_MPORTS | 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB9__ADC0_CH14B_CMP0_IN2                         = IOMUX_PAD(0xD0A4, 0xD0A4, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB9__PTB9                                        = IOMUX_PAD(0xD0A4, 0xD0A4, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB9__FXIO0_D25                                   = IOMUX_PAD(0xD0A4, 0xD0A4, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB9__LPSPI1_SCK                                  = IOMUX_PAD(0xD0A4, 0xD0A4, IOMUX_CONFIG_MPORTS | 0x3, 0xD12C, 0x3, 0),
	MX7ULP_PAD_PTB9__LPI2C1_SDA                                  = IOMUX_PAD(0xD0A4, 0xD0A4, IOMUX_CONFIG_MPORTS | 0x5, 0xD18C, 0x3, 0),
	MX7ULP_PAD_PTB9__TPM0_CH0                                    = IOMUX_PAD(0xD0A4, 0xD0A4, IOMUX_CONFIG_MPORTS | 0x6, 0xD138, 0x3, 0),
	MX7ULP_PAD_PTB9__I2S1_RX_FS                                  = IOMUX_PAD(0xD0A4, 0xD0A4, IOMUX_CONFIG_MPORTS | 0x7, 0xD1D0, 0x2, 0),
	MX7ULP_PAD_PTB9__QSPIA_DQS                                   = IOMUX_PAD(0xD0A4, 0xD0A4, IOMUX_CONFIG_MPORTS | 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB9__LLWU0_P12                                   = IOMUX_PAD(0xD0A4, 0xD0A4, IOMUX_CONFIG_MPORTS | 0xd, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB10__CMP0_IN1                                   = IOMUX_PAD(0xD0A8, 0xD0A8, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB10__PTB10                                      = IOMUX_PAD(0xD0A8, 0xD0A8, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB10__FXIO0_D26                                  = IOMUX_PAD(0xD0A8, 0xD0A8, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB10__LPSPI1_PCS0                                = IOMUX_PAD(0xD0A8, 0xD0A8, IOMUX_CONFIG_MPORTS | 0x3, 0xD11C, 0x3, 0),
	MX7ULP_PAD_PTB10__LPI2C2_SCL                                 = IOMUX_PAD(0xD0A8, 0xD0A8, IOMUX_CONFIG_MPORTS | 0x5, 0xD194, 0x3, 0),
	MX7ULP_PAD_PTB10__TPM0_CH1                                   = IOMUX_PAD(0xD0A8, 0xD0A8, IOMUX_CONFIG_MPORTS | 0x6, 0xD13C, 0x3, 0),
	MX7ULP_PAD_PTB10__I2S1_RXD0                                  = IOMUX_PAD(0xD0A8, 0xD0A8, IOMUX_CONFIG_MPORTS | 0x7, 0xD1E4, 0x2, 0),
	MX7ULP_PAD_PTB10__TRACE_D4                                   = IOMUX_PAD(0xD0A8, 0xD0A8, IOMUX_CONFIG_MPORTS | 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB11__CMP0_IN3                                   = IOMUX_PAD(0xD0AC, 0xD0AC, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB11__PTB11                                      = IOMUX_PAD(0xD0AC, 0xD0AC, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB11__FXIO0_D27                                  = IOMUX_PAD(0xD0AC, 0xD0AC, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB11__LPSPI1_PCS1                                = IOMUX_PAD(0xD0AC, 0xD0AC, IOMUX_CONFIG_MPORTS | 0x3, 0xD120, 0x3, 0),
	MX7ULP_PAD_PTB11__LPI2C2_SDA                                 = IOMUX_PAD(0xD0AC, 0xD0AC, IOMUX_CONFIG_MPORTS | 0x5, 0xD198, 0x3, 0),
	MX7ULP_PAD_PTB11__TPM1_CLKIN                                 = IOMUX_PAD(0xD0AC, 0xD0AC, IOMUX_CONFIG_MPORTS | 0x6, 0xD1AC, 0x3, 0),
	MX7ULP_PAD_PTB11__I2S1_RXD1                                  = IOMUX_PAD(0xD0AC, 0xD0AC, IOMUX_CONFIG_MPORTS | 0x7, 0xD1E8, 0x2, 0),
	MX7ULP_PAD_PTB11__TRACE_D5                                   = IOMUX_PAD(0xD0AC, 0xD0AC, IOMUX_CONFIG_MPORTS | 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB12__ADC1_CH13A_CMP1_IN0                        = IOMUX_PAD(0xD0B0, 0xD0B0, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB12__PTB12                                      = IOMUX_PAD(0xD0B0, 0xD0B0, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB12__FXIO0_D28                                  = IOMUX_PAD(0xD0B0, 0xD0B0, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB12__LPSPI1_PCS2                                = IOMUX_PAD(0xD0B0, 0xD0B0, IOMUX_CONFIG_MPORTS | 0x3, 0xD124, 0x3, 0),
	MX7ULP_PAD_PTB12__LPUART2_TX                                 = IOMUX_PAD(0xD0B0, 0xD0B0, IOMUX_CONFIG_MPORTS | 0x4, 0xD218, 0x4, 0),
	MX7ULP_PAD_PTB12__LPI2C3_SCL                                 = IOMUX_PAD(0xD0B0, 0xD0B0, IOMUX_CONFIG_MPORTS | 0x5, 0xD1A0, 0x3, 0),
	MX7ULP_PAD_PTB12__TPM1_CH0                                   = IOMUX_PAD(0xD0B0, 0xD0B0, IOMUX_CONFIG_MPORTS | 0x6, 0xD150, 0x3, 0),
	MX7ULP_PAD_PTB12__I2S1_RXD2                                  = IOMUX_PAD(0xD0B0, 0xD0B0, IOMUX_CONFIG_MPORTS | 0x7, 0xD1EC, 0x2, 0),
	MX7ULP_PAD_PTB12__TRACE_D6                                   = IOMUX_PAD(0xD0B0, 0xD0B0, IOMUX_CONFIG_MPORTS | 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB13__ADC1_CH13B_CMP1_IN1                        = IOMUX_PAD(0xD0B4, 0xD0B4, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB13__PTB13                                      = IOMUX_PAD(0xD0B4, 0xD0B4, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB13__FXIO0_D29                                  = IOMUX_PAD(0xD0B4, 0xD0B4, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB13__LPSPI1_PCS3                                = IOMUX_PAD(0xD0B4, 0xD0B4, IOMUX_CONFIG_MPORTS | 0x3, 0xD128, 0x3, 0),
	MX7ULP_PAD_PTB13__LPUART2_RX                                 = IOMUX_PAD(0xD0B4, 0xD0B4, IOMUX_CONFIG_MPORTS | 0x4, 0xD214, 0x4, 0),
	MX7ULP_PAD_PTB13__LPI2C3_SDA                                 = IOMUX_PAD(0xD0B4, 0xD0B4, IOMUX_CONFIG_MPORTS | 0x5, 0xD1A4, 0x3, 0),
	MX7ULP_PAD_PTB13__TPM1_CH1                                   = IOMUX_PAD(0xD0B4, 0xD0B4, IOMUX_CONFIG_MPORTS | 0x6, 0xD154, 0x3, 0),
	MX7ULP_PAD_PTB13__I2S1_RXD3                                  = IOMUX_PAD(0xD0B4, 0xD0B4, IOMUX_CONFIG_MPORTS | 0x7, 0xD1F0, 0x2, 0),
	MX7ULP_PAD_PTB13__QSPIA_DATA4                                = IOMUX_PAD(0xD0B4, 0xD0B4, IOMUX_CONFIG_MPORTS | 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB13__TRACE_D7                                   = IOMUX_PAD(0xD0B4, 0xD0B4, IOMUX_CONFIG_MPORTS | 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB14__ADC1_CH2A                                  = IOMUX_PAD(0xD0B8, 0xD0B8, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB14__PTB14                                      = IOMUX_PAD(0xD0B8, 0xD0B8, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB14__FXIO0_D30                                  = IOMUX_PAD(0xD0B8, 0xD0B8, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB14__LPI2C2_HREQ                                = IOMUX_PAD(0xD0B8, 0xD0B8, IOMUX_CONFIG_MPORTS | 0x5, 0xD190, 0x3, 0),
	MX7ULP_PAD_PTB14__TPM2_CLKIN                                 = IOMUX_PAD(0xD0B8, 0xD0B8, IOMUX_CONFIG_MPORTS | 0x6, 0xD1F4, 0x3, 0),
	MX7ULP_PAD_PTB14__QSPIA_SS1_B                                = IOMUX_PAD(0xD0B8, 0xD0B8, IOMUX_CONFIG_MPORTS | 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB14__QSPIA_SCLK_B                               = IOMUX_PAD(0xD0B8, 0xD0B8, IOMUX_CONFIG_MPORTS | 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB14__RTC_CLKOUT                                 = IOMUX_PAD(0xD0B8, 0xD0B8, IOMUX_CONFIG_MPORTS | 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB14__LLWU0_P13                                  = IOMUX_PAD(0xD0B8, 0xD0B8, IOMUX_CONFIG_MPORTS | 0xd, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB15__ADC1_CH2B                                  = IOMUX_PAD(0xD0BC, 0xD0BC, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB15__PTB15                                      = IOMUX_PAD(0xD0BC, 0xD0BC, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB15__FXIO0_D31                                  = IOMUX_PAD(0xD0BC, 0xD0BC, IOMUX_CONFIG_MPORTS | 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB15__LPI2C3_HREQ                                = IOMUX_PAD(0xD0BC, 0xD0BC, IOMUX_CONFIG_MPORTS | 0x5, 0xD19C, 0x3, 0),
	MX7ULP_PAD_PTB15__TPM2_CH0                                   = IOMUX_PAD(0xD0BC, 0xD0BC, IOMUX_CONFIG_MPORTS | 0x6, 0xD158, 0x3, 0),
	MX7ULP_PAD_PTB15__QSPIA_SCLK                                 = IOMUX_PAD(0xD0BC, 0xD0BC, IOMUX_CONFIG_MPORTS | 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB16__ADC0_CH4A                                  = IOMUX_PAD(0xD0C0, 0xD0C0, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB16__PTB16                                      = IOMUX_PAD(0xD0C0, 0xD0C0, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB16__TPM2_CH1                                   = IOMUX_PAD(0xD0C0, 0xD0C0, IOMUX_CONFIG_MPORTS | 0x6, 0xD15C, 0x3, 0),
	MX7ULP_PAD_PTB16__QSPIA_DATA3                                = IOMUX_PAD(0xD0C0, 0xD0C0, IOMUX_CONFIG_MPORTS | 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB16__LLWU0_P14                                  = IOMUX_PAD(0xD0C0, 0xD0C0, IOMUX_CONFIG_MPORTS | 0xd, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB17__ADC0_CH4B                                  = IOMUX_PAD(0xD0C4, 0xD0C4, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB17__PTB17                                      = IOMUX_PAD(0xD0C4, 0xD0C4, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB17__TPM3_CLKIN                                 = IOMUX_PAD(0xD0C4, 0xD0C4, IOMUX_CONFIG_MPORTS | 0x6, 0xD1B0, 0x2, 0),
	MX7ULP_PAD_PTB17__QSPIA_DATA2                                = IOMUX_PAD(0xD0C4, 0xD0C4, IOMUX_CONFIG_MPORTS | 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB18__ADC0_CH5A                                  = IOMUX_PAD(0xD0C8, 0xD0C8, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB18__PTB18                                      = IOMUX_PAD(0xD0C8, 0xD0C8, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB18__TPM3_CH0                                   = IOMUX_PAD(0xD0C8, 0xD0C8, IOMUX_CONFIG_MPORTS | 0x6, 0xD160, 0x3, 0),
	MX7ULP_PAD_PTB18__QSPIA_DATA1                                = IOMUX_PAD(0xD0C8, 0xD0C8, IOMUX_CONFIG_MPORTS | 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB19__ADC0_CH5B                                  = IOMUX_PAD(0xD0CC, 0xD0CC, IOMUX_CONFIG_MPORTS | 0x0, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB19__PTB19                                      = IOMUX_PAD(0xD0CC, 0xD0CC, IOMUX_CONFIG_MPORTS | 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB19__TPM3_CH1                                   = IOMUX_PAD(0xD0CC, 0xD0CC, IOMUX_CONFIG_MPORTS | 0x6, 0xD164, 0x3, 0),
	MX7ULP_PAD_PTB19__QSPIA_DATA0                                = IOMUX_PAD(0xD0CC, 0xD0CC, IOMUX_CONFIG_MPORTS | 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTB19__USB0_ID                                    = IOMUX_PAD(0xD0CC, 0xD0CC, IOMUX_CONFIG_MPORTS | 0xa, 0xD338, 0x0, 0),
	MX7ULP_PAD_PTB19__LLWU0_P15                                  = IOMUX_PAD(0xD0CC, 0xD0CC, IOMUX_CONFIG_MPORTS | 0xd, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC0__PTC0                                        = IOMUX_PAD(0x0000, 0x0000, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC0__LPUART4_CTS_B                               = IOMUX_PAD(0x0000, 0x0000, 0x4, 0x0244, 0x1, 0),
	MX7ULP_PAD_PTC0__LPI2C4_SCL                                  = IOMUX_PAD(0x0000, 0x0000, 0x5, 0x0278, 0x1, 0),
	MX7ULP_PAD_PTC0__TPM4_CLKIN                                  = IOMUX_PAD(0x0000, 0x0000, 0x6, 0x0298, 0x1, 0),
	MX7ULP_PAD_PTC0__FB_AD0                                      = IOMUX_PAD(0x0000, 0x0000, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC0__TRACE_D15                                   = IOMUX_PAD(0x0000, 0x0000, 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC1__PTC1                                        = IOMUX_PAD(0x0004, 0x0004, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC1__LPUART4_RTS_B                               = IOMUX_PAD(0x0004, 0x0004, 0x4, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC1__LPI2C4_SDA                                  = IOMUX_PAD(0x0004, 0x0004, 0x5, 0x027C, 0x1, 0),
	MX7ULP_PAD_PTC1__TPM4_CH0                                    = IOMUX_PAD(0x0004, 0x0004, 0x6, 0x0280, 0x1, 0),
	MX7ULP_PAD_PTC1__FB_AD1                                      = IOMUX_PAD(0x0004, 0x0004, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC1__TRACE_D14                                   = IOMUX_PAD(0x0004, 0x0004, 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC2__PTC2                                        = IOMUX_PAD(0x0008, 0x0008, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC2__LPUART4_TX                                  = IOMUX_PAD(0x0008, 0x0008, 0x4, 0x024C, 0x1, 0),
	MX7ULP_PAD_PTC2__LPI2C4_HREQ                                 = IOMUX_PAD(0x0008, 0x0008, 0x5, 0x0274, 0x1, 0),
	MX7ULP_PAD_PTC2__TPM4_CH1                                    = IOMUX_PAD(0x0008, 0x0008, 0x6, 0x0284, 0x1, 0),
	MX7ULP_PAD_PTC2__FB_AD2                                      = IOMUX_PAD(0x0008, 0x0008, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC2__TRACE_D13                                   = IOMUX_PAD(0x0008, 0x0008, 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC3__PTC3                                        = IOMUX_PAD(0x000C, 0x000C, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC3__LPUART4_RX                                  = IOMUX_PAD(0x000C, 0x000C, 0x4, 0x0248, 0x1, 0),
	MX7ULP_PAD_PTC3__TPM4_CH2                                    = IOMUX_PAD(0x000C, 0x000C, 0x6, 0x0288, 0x1, 0),
	MX7ULP_PAD_PTC3__FB_AD3                                      = IOMUX_PAD(0x000C, 0x000C, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC3__TRACE_D12                                   = IOMUX_PAD(0x000C, 0x000C, 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC4__PTC4                                        = IOMUX_PAD(0x0010, 0x0010, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC4__FXIO1_D0                                    = IOMUX_PAD(0x0010, 0x0010, 0x2, 0x0204, 0x1, 0),
	MX7ULP_PAD_PTC4__LPSPI2_PCS1                                 = IOMUX_PAD(0x0010, 0x0010, 0x3, 0x02A0, 0x1, 0),
	MX7ULP_PAD_PTC4__LPUART5_CTS_B                               = IOMUX_PAD(0x0010, 0x0010, 0x4, 0x0250, 0x1, 0),
	MX7ULP_PAD_PTC4__LPI2C5_SCL                                  = IOMUX_PAD(0x0010, 0x0010, 0x5, 0x02BC, 0x1, 0),
	MX7ULP_PAD_PTC4__TPM4_CH3                                    = IOMUX_PAD(0x0010, 0x0010, 0x6, 0x028C, 0x1, 0),
	MX7ULP_PAD_PTC4__FB_AD4                                      = IOMUX_PAD(0x0010, 0x0010, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC4__TRACE_D11                                   = IOMUX_PAD(0x0010, 0x0010, 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC5__PTC5                                        = IOMUX_PAD(0x0014, 0x0014, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC5__FXIO1_D1                                    = IOMUX_PAD(0x0014, 0x0014, 0x2, 0x0208, 0x1, 0),
	MX7ULP_PAD_PTC5__LPSPI2_PCS2                                 = IOMUX_PAD(0x0014, 0x0014, 0x3, 0x02A4, 0x1, 0),
	MX7ULP_PAD_PTC5__LPUART5_RTS_B                               = IOMUX_PAD(0x0014, 0x0014, 0x4, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC5__LPI2C5_SDA                                  = IOMUX_PAD(0x0014, 0x0014, 0x5, 0x02C0, 0x1, 0),
	MX7ULP_PAD_PTC5__TPM4_CH4                                    = IOMUX_PAD(0x0014, 0x0014, 0x6, 0x0290, 0x1, 0),
	MX7ULP_PAD_PTC5__FB_AD5                                      = IOMUX_PAD(0x0014, 0x0014, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC5__TRACE_D10                                   = IOMUX_PAD(0x0014, 0x0014, 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC6__PTC6                                        = IOMUX_PAD(0x0018, 0x0018, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC6__FXIO1_D2                                    = IOMUX_PAD(0x0018, 0x0018, 0x2, 0x020C, 0x1, 0),
	MX7ULP_PAD_PTC6__LPSPI2_PCS3                                 = IOMUX_PAD(0x0018, 0x0018, 0x3, 0x02A8, 0x1, 0),
	MX7ULP_PAD_PTC6__LPUART5_TX                                  = IOMUX_PAD(0x0018, 0x0018, 0x4, 0x0258, 0x1, 0),
	MX7ULP_PAD_PTC6__LPI2C5_HREQ                                 = IOMUX_PAD(0x0018, 0x0018, 0x5, 0x02B8, 0x1, 0),
	MX7ULP_PAD_PTC6__TPM4_CH5                                    = IOMUX_PAD(0x0018, 0x0018, 0x6, 0x0294, 0x1, 0),
	MX7ULP_PAD_PTC6__FB_AD6                                      = IOMUX_PAD(0x0018, 0x0018, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC6__TRACE_D9                                    = IOMUX_PAD(0x0018, 0x0018, 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC7__PTC7                                        = IOMUX_PAD(0x001C, 0x001C, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC7__FXIO1_D3                                    = IOMUX_PAD(0x001C, 0x001C, 0x2, 0x0210, 0x1, 0),
	MX7ULP_PAD_PTC7__LPUART5_RX                                  = IOMUX_PAD(0x001C, 0x001C, 0x4, 0x0254, 0x1, 0),
	MX7ULP_PAD_PTC7__TPM5_CH1                                    = IOMUX_PAD(0x001C, 0x001C, 0x6, 0x02C8, 0x1, 0),
	MX7ULP_PAD_PTC7__FB_AD7                                      = IOMUX_PAD(0x001C, 0x001C, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC7__TRACE_D8                                    = IOMUX_PAD(0x001C, 0x001C, 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC8__PTC8                                        = IOMUX_PAD(0x0020, 0x0020, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC8__FXIO1_D4                                    = IOMUX_PAD(0x0020, 0x0020, 0x2, 0x0214, 0x1, 0),
	MX7ULP_PAD_PTC8__LPSPI2_SIN                                  = IOMUX_PAD(0x0020, 0x0020, 0x3, 0x02B0, 0x1, 0),
	MX7ULP_PAD_PTC8__LPUART6_CTS_B                               = IOMUX_PAD(0x0020, 0x0020, 0x4, 0x025C, 0x1, 0),
	MX7ULP_PAD_PTC8__LPI2C6_SCL                                  = IOMUX_PAD(0x0020, 0x0020, 0x5, 0x02FC, 0x1, 0),
	MX7ULP_PAD_PTC8__TPM5_CLKIN                                  = IOMUX_PAD(0x0020, 0x0020, 0x6, 0x02CC, 0x1, 0),
	MX7ULP_PAD_PTC8__FB_AD8                                      = IOMUX_PAD(0x0020, 0x0020, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC8__TRACE_D7                                    = IOMUX_PAD(0x0020, 0x0020, 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC9__PTC9                                        = IOMUX_PAD(0x0024, 0x0024, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC9__FXIO1_D5                                    = IOMUX_PAD(0x0024, 0x0024, 0x2, 0x0218, 0x1, 0),
	MX7ULP_PAD_PTC9__LPSPI2_SOUT                                 = IOMUX_PAD(0x0024, 0x0024, 0x3, 0x02B4, 0x1, 0),
	MX7ULP_PAD_PTC9__LPUART6_RTS_B                               = IOMUX_PAD(0x0024, 0x0024, 0x4, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC9__LPI2C6_SDA                                  = IOMUX_PAD(0x0024, 0x0024, 0x5, 0x0300, 0x1, 0),
	MX7ULP_PAD_PTC9__TPM5_CH0                                    = IOMUX_PAD(0x0024, 0x0024, 0x6, 0x02C4, 0x1, 0),
	MX7ULP_PAD_PTC9__FB_AD9                                      = IOMUX_PAD(0x0024, 0x0024, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC9__TRACE_D6                                    = IOMUX_PAD(0x0024, 0x0024, 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC10__PTC10                                      = IOMUX_PAD(0x0028, 0x0028, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC10__FXIO1_D6                                   = IOMUX_PAD(0x0028, 0x0028, 0x2, 0x021C, 0x1, 0),
	MX7ULP_PAD_PTC10__LPSPI2_SCK                                 = IOMUX_PAD(0x0028, 0x0028, 0x3, 0x02AC, 0x1, 0),
	MX7ULP_PAD_PTC10__LPUART6_TX                                 = IOMUX_PAD(0x0028, 0x0028, 0x4, 0x0264, 0x1, 0),
	MX7ULP_PAD_PTC10__LPI2C6_HREQ                                = IOMUX_PAD(0x0028, 0x0028, 0x5, 0x02F8, 0x1, 0),
	MX7ULP_PAD_PTC10__TPM7_CH3                                   = IOMUX_PAD(0x0028, 0x0028, 0x6, 0x02E8, 0x1, 0),
	MX7ULP_PAD_PTC10__FB_AD10                                    = IOMUX_PAD(0x0028, 0x0028, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC10__TRACE_D5                                   = IOMUX_PAD(0x0028, 0x0028, 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC11__PTC11                                      = IOMUX_PAD(0x002C, 0x002C, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC11__FXIO1_D7                                   = IOMUX_PAD(0x002C, 0x002C, 0x2, 0x0220, 0x1, 0),
	MX7ULP_PAD_PTC11__LPSPI2_PCS0                                = IOMUX_PAD(0x002C, 0x002C, 0x3, 0x029C, 0x1, 0),
	MX7ULP_PAD_PTC11__LPUART6_RX                                 = IOMUX_PAD(0x002C, 0x002C, 0x4, 0x0260, 0x1, 0),
	MX7ULP_PAD_PTC11__TPM7_CH4                                   = IOMUX_PAD(0x002C, 0x002C, 0x6, 0x02EC, 0x1, 0),
	MX7ULP_PAD_PTC11__FB_AD11                                    = IOMUX_PAD(0x002C, 0x002C, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC11__TRACE_D4                                   = IOMUX_PAD(0x002C, 0x002C, 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC12__PTC12                                      = IOMUX_PAD(0x0030, 0x0030, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC12__FXIO1_D8                                   = IOMUX_PAD(0x0030, 0x0030, 0x2, 0x0224, 0x1, 0),
	MX7ULP_PAD_PTC12__LPSPI3_PCS1                                = IOMUX_PAD(0x0030, 0x0030, 0x3, 0x0314, 0x1, 0),
	MX7ULP_PAD_PTC12__LPUART7_CTS_B                              = IOMUX_PAD(0x0030, 0x0030, 0x4, 0x0268, 0x1, 0),
	MX7ULP_PAD_PTC12__LPI2C7_SCL                                 = IOMUX_PAD(0x0030, 0x0030, 0x5, 0x0308, 0x1, 0),
	MX7ULP_PAD_PTC12__TPM7_CH5                                   = IOMUX_PAD(0x0030, 0x0030, 0x6, 0x02F0, 0x1, 0),
	MX7ULP_PAD_PTC12__FB_AD12                                    = IOMUX_PAD(0x0030, 0x0030, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC12__TRACE_D3                                   = IOMUX_PAD(0x0030, 0x0030, 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC13__PTC13                                      = IOMUX_PAD(0x0034, 0x0034, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC13__FXIO1_D9                                   = IOMUX_PAD(0x0034, 0x0034, 0x2, 0x0228, 0x1, 0),
	MX7ULP_PAD_PTC13__LPSPI3_PCS2                                = IOMUX_PAD(0x0034, 0x0034, 0x3, 0x0318, 0x1, 0),
	MX7ULP_PAD_PTC13__LPUART7_RTS_B                              = IOMUX_PAD(0x0034, 0x0034, 0x4, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC13__LPI2C7_SDA                                 = IOMUX_PAD(0x0034, 0x0034, 0x5, 0x030C, 0x1, 0),
	MX7ULP_PAD_PTC13__TPM7_CLKIN                                 = IOMUX_PAD(0x0034, 0x0034, 0x6, 0x02F4, 0x1, 0),
	MX7ULP_PAD_PTC13__FB_AD13                                    = IOMUX_PAD(0x0034, 0x0034, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC13__TRACE_D2                                   = IOMUX_PAD(0x0034, 0x0034, 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC13__USB0_ID                                    = IOMUX_PAD(0x0034, 0x0034, 0xb, 0x0338, 0x1, 0),
	MX7ULP_PAD_PTC14__PTC14                                      = IOMUX_PAD(0x0038, 0x0038, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC14__FXIO1_D10                                  = IOMUX_PAD(0x0038, 0x0038, 0x2, 0x022C, 0x1, 0),
	MX7ULP_PAD_PTC14__LPSPI3_PCS3                                = IOMUX_PAD(0x0038, 0x0038, 0x3, 0x031C, 0x1, 0),
	MX7ULP_PAD_PTC14__LPUART7_TX                                 = IOMUX_PAD(0x0038, 0x0038, 0x4, 0x0270, 0x1, 0),
	MX7ULP_PAD_PTC14__LPI2C7_HREQ                                = IOMUX_PAD(0x0038, 0x0038, 0x5, 0x0304, 0x1, 0),
	MX7ULP_PAD_PTC14__TPM7_CH0                                   = IOMUX_PAD(0x0038, 0x0038, 0x6, 0x02DC, 0x1, 0),
	MX7ULP_PAD_PTC14__FB_AD14                                    = IOMUX_PAD(0x0038, 0x0038, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC14__TRACE_D1                                   = IOMUX_PAD(0x0038, 0x0038, 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC15__PTC15                                      = IOMUX_PAD(0x003C, 0x003C, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC15__FXIO1_D11                                  = IOMUX_PAD(0x003C, 0x003C, 0x2, 0x0230, 0x1, 0),
	MX7ULP_PAD_PTC15__LPUART7_RX                                 = IOMUX_PAD(0x003C, 0x003C, 0x4, 0x026C, 0x1, 0),
	MX7ULP_PAD_PTC15__TPM7_CH1                                   = IOMUX_PAD(0x003C, 0x003C, 0x6, 0x02E0, 0x1, 0),
	MX7ULP_PAD_PTC15__FB_AD15                                    = IOMUX_PAD(0x003C, 0x003C, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC15__TRACE_D0                                   = IOMUX_PAD(0x003C, 0x003C, 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC16__PTC16                                      = IOMUX_PAD(0x0040, 0x0040, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC16__FXIO1_D12                                  = IOMUX_PAD(0x0040, 0x0040, 0x2, 0x0234, 0x1, 0),
	MX7ULP_PAD_PTC16__LPSPI3_SIN                                 = IOMUX_PAD(0x0040, 0x0040, 0x3, 0x0324, 0x1, 0),
	MX7ULP_PAD_PTC16__TPM7_CH2                                   = IOMUX_PAD(0x0040, 0x0040, 0x6, 0x02E4, 0x1, 0),
	MX7ULP_PAD_PTC16__FB_ALE_FB_CS1_B_FB_TS_B                    = IOMUX_PAD(0x0040, 0x0040, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC16__TRACE_CLKOUT                               = IOMUX_PAD(0x0040, 0x0040, 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC16__USB1_OC2                                   = IOMUX_PAD(0x0040, 0x0040, 0xb, 0x0334, 0x1, 0),
	MX7ULP_PAD_PTC17__PTC17                                      = IOMUX_PAD(0x0044, 0x0044, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC17__FXIO1_D13                                  = IOMUX_PAD(0x0044, 0x0044, 0x2, 0x0238, 0x1, 0),
	MX7ULP_PAD_PTC17__LPSPI3_SOUT                                = IOMUX_PAD(0x0044, 0x0044, 0x3, 0x0328, 0x1, 0),
	MX7ULP_PAD_PTC17__TPM6_CLKIN                                 = IOMUX_PAD(0x0044, 0x0044, 0x6, 0x02D8, 0x1, 0),
	MX7ULP_PAD_PTC17__FB_CS0_B                                   = IOMUX_PAD(0x0044, 0x0044, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC18__PTC18                                      = IOMUX_PAD(0x0048, 0x0048, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC18__FXIO1_D14                                  = IOMUX_PAD(0x0048, 0x0048, 0x2, 0x023C, 0x1, 0),
	MX7ULP_PAD_PTC18__LPSPI3_SCK                                 = IOMUX_PAD(0x0048, 0x0048, 0x3, 0x0320, 0x1, 0),
	MX7ULP_PAD_PTC18__TPM6_CH0                                   = IOMUX_PAD(0x0048, 0x0048, 0x6, 0x02D0, 0x1, 0),
	MX7ULP_PAD_PTC18__FB_OE_B                                    = IOMUX_PAD(0x0048, 0x0048, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC18__USB0_ID                                    = IOMUX_PAD(0x0048, 0x0048, 0xb, 0x0338, 0x2, 0),
	MX7ULP_PAD_PTC18__VIU_DE                                     = IOMUX_PAD(0x0048, 0x0048, 0xc, 0x033c, 0x1, 0),
	MX7ULP_PAD_PTC19__PTC19                                      = IOMUX_PAD(0x004C, 0x004C, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC19__FXIO1_D15                                  = IOMUX_PAD(0x004C, 0x004C, 0x2, 0x0240, 0x1, 0),
	MX7ULP_PAD_PTC19__LPSPI3_PCS0                                = IOMUX_PAD(0x004C, 0x004C, 0x3, 0x0310, 0x1, 0),
	MX7ULP_PAD_PTC19__TPM6_CH1                                   = IOMUX_PAD(0x004C, 0x004C, 0x6, 0x02D4, 0x1, 0),
	MX7ULP_PAD_PTC19__FB_A16                                     = IOMUX_PAD(0x004C, 0x004C, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC19__USB0_ID                                    = IOMUX_PAD(0x004C, 0x004C, 0xa, 0x0338, 0x3, 0),
	MX7ULP_PAD_PTC19__USB1_PWR2                                  = IOMUX_PAD(0x004C, 0x004C, 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTC19__VIU_DE                                     = IOMUX_PAD(0x004C, 0x004C, 0xc, 0x033c, 0x3, 0),
	MX7ULP_PAD_PTD0__PTD0                                        = IOMUX_PAD(0x0080, 0x0080, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTD0__SDHC0_RESET_B                               = IOMUX_PAD(0x0080, 0x0080, 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTD1__PTD1                                        = IOMUX_PAD(0x0084, 0x0084, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTD1__SDHC0_CMD                                   = IOMUX_PAD(0x0084, 0x0084, 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTD2__PTD2                                        = IOMUX_PAD(0x0088, 0x0088, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTD2__SDHC0_CLK                                   = IOMUX_PAD(0x0088, 0x0088, 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTD3__PTD3                                        = IOMUX_PAD(0x008C, 0x008C, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTD3__SDHC0_D7                                    = IOMUX_PAD(0x008C, 0x008C, 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTD4__PTD4                                        = IOMUX_PAD(0x0090, 0x0090, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTD4__SDHC0_D6                                    = IOMUX_PAD(0x0090, 0x0090, 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTD5__PTD5                                        = IOMUX_PAD(0x0094, 0x0094, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTD5__SDHC0_D5                                    = IOMUX_PAD(0x0094, 0x0094, 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTD6__PTD6                                        = IOMUX_PAD(0x0098, 0x0098, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTD6__SDHC0_D4                                    = IOMUX_PAD(0x0098, 0x0098, 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTD7__PTD7                                        = IOMUX_PAD(0x009C, 0x009C, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTD7__SDHC0_D3                                    = IOMUX_PAD(0x009C, 0x009C, 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTD8__PTD8                                        = IOMUX_PAD(0x00A0, 0x00A0, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTD8__TPM4_CLKIN                                  = IOMUX_PAD(0x00A0, 0x00A0, 0x6, 0x0298, 0x2, 0),
	MX7ULP_PAD_PTD8__SDHC0_D2                                    = IOMUX_PAD(0x00A0, 0x00A0, 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTD9__PTD9                                        = IOMUX_PAD(0x00A4, 0x00A4, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTD9__TPM4_CH0                                    = IOMUX_PAD(0x00A4, 0x00A4, 0x6, 0x0280, 0x2, 0),
	MX7ULP_PAD_PTD9__SDHC0_D1                                    = IOMUX_PAD(0x00A4, 0x00A4, 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTD10__PTD10                                      = IOMUX_PAD(0x00A8, 0x00A8, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTD10__TPM4_CH1                                   = IOMUX_PAD(0x00A8, 0x00A8, 0x6, 0x0284, 0x2, 0),
	MX7ULP_PAD_PTD10__SDHC0_D0                                   = IOMUX_PAD(0x00A8, 0x00A8, 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTD11__PTD11                                      = IOMUX_PAD(0x00AC, 0x00AC, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTD11__TPM4_CH2                                   = IOMUX_PAD(0x00AC, 0x00AC, 0x6, 0x0288, 0x2, 0),
	MX7ULP_PAD_PTD11__SDHC0_DQS                                  = IOMUX_PAD(0x00AC, 0x00AC, 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE0__PTE0                                        = IOMUX_PAD(0x0100, 0x0100, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE0__FXIO1_D31                                   = IOMUX_PAD(0x0100, 0x0100, 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE0__LPSPI2_PCS1                                 = IOMUX_PAD(0x0100, 0x0100, 0x3, 0x02A0, 0x2, 0),
	MX7ULP_PAD_PTE0__LPUART4_CTS_B                               = IOMUX_PAD(0x0100, 0x0100, 0x4, 0x0244, 0x2, 0),
	MX7ULP_PAD_PTE0__LPI2C4_SCL                                  = IOMUX_PAD(0x0100, 0x0100, 0x5, 0x0278, 0x2, 0),
	MX7ULP_PAD_PTE0__SDHC1_D1                                    = IOMUX_PAD(0x0100, 0x0100, 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE0__FB_A25                                      = IOMUX_PAD(0x0100, 0x0100, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE1__PTE1                                        = IOMUX_PAD(0x0104, 0x0104, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE1__FXIO1_D30                                   = IOMUX_PAD(0x0104, 0x0104, 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE1__LPSPI2_PCS2                                 = IOMUX_PAD(0x0104, 0x0104, 0x3, 0x02A4, 0x2, 0),
	MX7ULP_PAD_PTE1__LPUART4_RTS_B                               = IOMUX_PAD(0x0104, 0x0104, 0x4, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE1__LPI2C4_SDA                                  = IOMUX_PAD(0x0104, 0x0104, 0x5, 0x027C, 0x2, 0),
	MX7ULP_PAD_PTE1__SDHC1_D0                                    = IOMUX_PAD(0x0104, 0x0104, 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE1__FB_A26                                      = IOMUX_PAD(0x0104, 0x0104, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE2__PTE2                                        = IOMUX_PAD(0x0108, 0x0108, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE2__FXIO1_D29                                   = IOMUX_PAD(0x0108, 0x0108, 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE2__LPSPI2_PCS3                                 = IOMUX_PAD(0x0108, 0x0108, 0x3, 0x02A8, 0x2, 0),
	MX7ULP_PAD_PTE2__LPUART4_TX                                  = IOMUX_PAD(0x0108, 0x0108, 0x4, 0x024C, 0x2, 0),
	MX7ULP_PAD_PTE2__LPI2C4_HREQ                                 = IOMUX_PAD(0x0108, 0x0108, 0x5, 0x0274, 0x2, 0),
	MX7ULP_PAD_PTE2__SDHC1_CLK                                   = IOMUX_PAD(0x0108, 0x0108, 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE3__PTE3                                        = IOMUX_PAD(0x010C, 0x010C, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE3__FXIO1_D28                                   = IOMUX_PAD(0x010C, 0x010C, 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE3__LPUART4_RX                                  = IOMUX_PAD(0x010C, 0x010C, 0x4, 0x0248, 0x2, 0),
	MX7ULP_PAD_PTE3__TPM5_CH1                                    = IOMUX_PAD(0x010C, 0x010C, 0x6, 0x02C8, 0x2, 0),
	MX7ULP_PAD_PTE3__SDHC1_CMD                                   = IOMUX_PAD(0x010C, 0x010C, 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE4__PTE4                                        = IOMUX_PAD(0x0110, 0x0110, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE4__FXIO1_D27                                   = IOMUX_PAD(0x0110, 0x0110, 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE4__LPSPI2_SIN                                  = IOMUX_PAD(0x0110, 0x0110, 0x3, 0x02B0, 0x2, 0),
	MX7ULP_PAD_PTE4__LPUART5_CTS_B                               = IOMUX_PAD(0x0110, 0x0110, 0x4, 0x0250, 0x2, 0),
	MX7ULP_PAD_PTE4__LPI2C5_SCL                                  = IOMUX_PAD(0x0110, 0x0110, 0x5, 0x02BC, 0x2, 0),
	MX7ULP_PAD_PTE4__TPM5_CLKIN                                  = IOMUX_PAD(0x0110, 0x0110, 0x6, 0x02CC, 0x2, 0),
	MX7ULP_PAD_PTE4__SDHC1_D3                                    = IOMUX_PAD(0x0110, 0x0110, 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE5__PTE5                                        = IOMUX_PAD(0x0114, 0x0114, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE5__FXIO1_D26                                   = IOMUX_PAD(0x0114, 0x0114, 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE5__LPSPI2_SOUT                                 = IOMUX_PAD(0x0114, 0x0114, 0x3, 0x02B4, 0x2, 0),
	MX7ULP_PAD_PTE5__LPUART5_RTS_B                               = IOMUX_PAD(0x0114, 0x0114, 0x4, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE5__LPI2C5_SDA                                  = IOMUX_PAD(0x0114, 0x0114, 0x5, 0x02C0, 0x2, 0),
	MX7ULP_PAD_PTE5__TPM5_CH0                                    = IOMUX_PAD(0x0114, 0x0114, 0x6, 0x02C4, 0x2, 0),
	MX7ULP_PAD_PTE5__SDHC1_D2                                    = IOMUX_PAD(0x0114, 0x0114, 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE5__VIU_DE                                      = IOMUX_PAD(0x0114, 0x0114, 0xc, 0x033c, 0x2, 0),
	MX7ULP_PAD_PTE6__PTE6                                        = IOMUX_PAD(0x0118, 0x0118, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE6__FXIO1_D25                                   = IOMUX_PAD(0x0118, 0x0118, 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE6__LPSPI2_SCK                                  = IOMUX_PAD(0x0118, 0x0118, 0x3, 0x02AC, 0x2, 0),
	MX7ULP_PAD_PTE6__LPUART5_TX                                  = IOMUX_PAD(0x0118, 0x0118, 0x4, 0x0258, 0x2, 0),
	MX7ULP_PAD_PTE6__LPI2C5_HREQ                                 = IOMUX_PAD(0x0118, 0x0118, 0x5, 0x02B8, 0x2, 0),
	MX7ULP_PAD_PTE6__TPM7_CH3                                    = IOMUX_PAD(0x0118, 0x0118, 0x6, 0x02E8, 0x2, 0),
	MX7ULP_PAD_PTE6__SDHC1_D4                                    = IOMUX_PAD(0x0118, 0x0118, 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE6__FB_A17                                      = IOMUX_PAD(0x0118, 0x0118, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE6__USB0_OC                                     = IOMUX_PAD(0x0118, 0x0118, 0xb, 0x0330, 0x1, 0),
	MX7ULP_PAD_PTE7__PTE7                                        = IOMUX_PAD(0x011C, 0x011C, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE7__FXIO1_D24                                   = IOMUX_PAD(0x011C, 0x011C, 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE7__LPSPI2_PCS0                                 = IOMUX_PAD(0x011C, 0x011C, 0x3, 0x029C, 0x2, 0),
	MX7ULP_PAD_PTE7__LPUART5_RX                                  = IOMUX_PAD(0x011C, 0x011C, 0x4, 0x0254, 0x2, 0),
	MX7ULP_PAD_PTE7__TPM7_CH4                                    = IOMUX_PAD(0x011C, 0x011C, 0x6, 0x02EC, 0x2, 0),
	MX7ULP_PAD_PTE7__SDHC1_D5                                    = IOMUX_PAD(0x011C, 0x011C, 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE7__FB_A18                                      = IOMUX_PAD(0x011C, 0x011C, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE7__TRACE_D7                                    = IOMUX_PAD(0x011C, 0x011C, 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE7__USB0_PWR                                    = IOMUX_PAD(0x011C, 0x011C, 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE7__VIU_FID                                     = IOMUX_PAD(0x011C, 0x011C, 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE8__PTE8                                        = IOMUX_PAD(0x0120, 0x0120, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE8__TRACE_D6                                    = IOMUX_PAD(0x0120, 0x0120, 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE8__VIU_D16                                     = IOMUX_PAD(0x0120, 0x0120, 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE8__FXIO1_D23                                   = IOMUX_PAD(0x0120, 0x0120, 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE8__LPSPI3_PCS1                                 = IOMUX_PAD(0x0120, 0x0120, 0x3, 0x0314, 0x2, 0),
	MX7ULP_PAD_PTE8__LPUART6_CTS_B                               = IOMUX_PAD(0x0120, 0x0120, 0x4, 0x025C, 0x2, 0),
	MX7ULP_PAD_PTE8__LPI2C6_SCL                                  = IOMUX_PAD(0x0120, 0x0120, 0x5, 0x02FC, 0x2, 0),
	MX7ULP_PAD_PTE8__TPM7_CH5                                    = IOMUX_PAD(0x0120, 0x0120, 0x6, 0x02F0, 0x2, 0),
	MX7ULP_PAD_PTE8__SDHC1_WP                                    = IOMUX_PAD(0x0120, 0x0120, 0x7, 0x0200, 0x1, 0),
	MX7ULP_PAD_PTE8__SDHC1_D6                                    = IOMUX_PAD(0x0120, 0x0120, 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE8__FB_CS3_B_FB_BE7_0_BLS31_24_B                = IOMUX_PAD(0x0120, 0x0120, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE9__PTE9                                        = IOMUX_PAD(0x0124, 0x0124, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE9__TRACE_D5                                    = IOMUX_PAD(0x0124, 0x0124, 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE9__VIU_D17                                     = IOMUX_PAD(0x0124, 0x0124, 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE9__FXIO1_D22                                   = IOMUX_PAD(0x0124, 0x0124, 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE9__LPSPI3_PCS2                                 = IOMUX_PAD(0x0124, 0x0124, 0x3, 0x0318, 0x2, 0),
	MX7ULP_PAD_PTE9__LPUART6_RTS_B                               = IOMUX_PAD(0x0124, 0x0124, 0x4, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE9__LPI2C6_SDA                                  = IOMUX_PAD(0x0124, 0x0124, 0x5, 0x0300, 0x2, 0),
	MX7ULP_PAD_PTE9__TPM7_CLKIN                                  = IOMUX_PAD(0x0124, 0x0124, 0x6, 0x02F4, 0x2, 0),
	MX7ULP_PAD_PTE9__SDHC1_CD                                    = IOMUX_PAD(0x0124, 0x0124, 0x7, 0x032C, 0x1, 0),
	MX7ULP_PAD_PTE9__SDHC1_D7                                    = IOMUX_PAD(0x0124, 0x0124, 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE9__FB_TBST_B_FB_CS2_B_FB_BE15_8_BLS23_16_B     = IOMUX_PAD(0x0124, 0x0124, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE10__PTE10                                      = IOMUX_PAD(0x0128, 0x0128, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE10__TRACE_D4                                   = IOMUX_PAD(0x0128, 0x0128, 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE10__VIU_D18                                    = IOMUX_PAD(0x0128, 0x0128, 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE10__FXIO1_D21                                  = IOMUX_PAD(0x0128, 0x0128, 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE10__LPSPI3_PCS3                                = IOMUX_PAD(0x0128, 0x0128, 0x3, 0x031C, 0x2, 0),
	MX7ULP_PAD_PTE10__LPUART6_TX                                 = IOMUX_PAD(0x0128, 0x0128, 0x4, 0x0264, 0x2, 0),
	MX7ULP_PAD_PTE10__LPI2C6_HREQ                                = IOMUX_PAD(0x0128, 0x0128, 0x5, 0x02F8, 0x2, 0),
	MX7ULP_PAD_PTE10__TPM7_CH0                                   = IOMUX_PAD(0x0128, 0x0128, 0x6, 0x02DC, 0x2, 0),
	MX7ULP_PAD_PTE10__SDHC1_VS                                   = IOMUX_PAD(0x0128, 0x0128, 0x7, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE10__SDHC1_DQS                                  = IOMUX_PAD(0x0128, 0x0128, 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE10__FB_A19                                     = IOMUX_PAD(0x0128, 0x0128, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE11__PTE11                                      = IOMUX_PAD(0x012C, 0x012C, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE11__TRACE_D3                                   = IOMUX_PAD(0x012C, 0x012C, 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE11__VIU_D19                                    = IOMUX_PAD(0x012C, 0x012C, 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE11__FXIO1_D20                                  = IOMUX_PAD(0x012C, 0x012C, 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE11__LPUART6_RX                                 = IOMUX_PAD(0x012C, 0x012C, 0x4, 0x0260, 0x2, 0),
	MX7ULP_PAD_PTE11__TPM7_CH1                                   = IOMUX_PAD(0x012C, 0x012C, 0x6, 0x02E0, 0x2, 0),
	MX7ULP_PAD_PTE11__SDHC1_RESET_B                              = IOMUX_PAD(0x012C, 0x012C, 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE11__FB_A20                                     = IOMUX_PAD(0x012C, 0x012C, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE12__PTE12                                      = IOMUX_PAD(0x0130, 0x0130, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE12__FXIO1_D19                                  = IOMUX_PAD(0x0130, 0x0130, 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE12__LPSPI3_SIN                                 = IOMUX_PAD(0x0130, 0x0130, 0x3, 0x0324, 0x2, 0),
	MX7ULP_PAD_PTE12__LPUART7_CTS_B                              = IOMUX_PAD(0x0130, 0x0130, 0x4, 0x0268, 0x2, 0),
	MX7ULP_PAD_PTE12__LPI2C7_SCL                                 = IOMUX_PAD(0x0130, 0x0130, 0x5, 0x0308, 0x2, 0),
	MX7ULP_PAD_PTE12__TPM7_CH2                                   = IOMUX_PAD(0x0130, 0x0130, 0x6, 0x02E4, 0x2, 0),
	MX7ULP_PAD_PTE12__SDHC1_WP                                   = IOMUX_PAD(0x0130, 0x0130, 0x8, 0x0200, 0x2, 0),
	MX7ULP_PAD_PTE12__FB_A21                                     = IOMUX_PAD(0x0130, 0x0130, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE12__TRACE_D2                                   = IOMUX_PAD(0x0130, 0x0130, 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE12__USB1_OC2                                   = IOMUX_PAD(0x0130, 0x0130, 0xb, 0x0334, 0x2, 0),
	MX7ULP_PAD_PTE12__VIU_D20                                    = IOMUX_PAD(0x0130, 0x0130, 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE13__PTE13                                      = IOMUX_PAD(0x0134, 0x0134, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE13__FXIO1_D18                                  = IOMUX_PAD(0x0134, 0x0134, 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE13__LPSPI3_SOUT                                = IOMUX_PAD(0x0134, 0x0134, 0x3, 0x0328, 0x2, 0),
	MX7ULP_PAD_PTE13__LPUART7_RTS_B                              = IOMUX_PAD(0x0134, 0x0134, 0x4, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE13__LPI2C7_SDA                                 = IOMUX_PAD(0x0134, 0x0134, 0x5, 0x030C, 0x2, 0),
	MX7ULP_PAD_PTE13__TPM6_CLKIN                                 = IOMUX_PAD(0x0134, 0x0134, 0x6, 0x02D8, 0x2, 0),
	MX7ULP_PAD_PTE13__SDHC1_CD                                   = IOMUX_PAD(0x0134, 0x0134, 0x8, 0x032C, 0x2, 0),
	MX7ULP_PAD_PTE13__FB_A22                                     = IOMUX_PAD(0x0134, 0x0134, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE13__TRACE_D1                                   = IOMUX_PAD(0x0134, 0x0134, 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE13__USB1_PWR2                                  = IOMUX_PAD(0x0134, 0x0134, 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE13__VIU_D21                                    = IOMUX_PAD(0x0134, 0x0134, 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE14__PTE14                                      = IOMUX_PAD(0x0138, 0x0138, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE14__FXIO1_D17                                  = IOMUX_PAD(0x0138, 0x0138, 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE14__LPSPI3_SCK                                 = IOMUX_PAD(0x0138, 0x0138, 0x3, 0x0320, 0x2, 0),
	MX7ULP_PAD_PTE14__LPUART7_TX                                 = IOMUX_PAD(0x0138, 0x0138, 0x4, 0x0270, 0x2, 0),
	MX7ULP_PAD_PTE14__LPI2C7_HREQ                                = IOMUX_PAD(0x0138, 0x0138, 0x5, 0x0304, 0x2, 0),
	MX7ULP_PAD_PTE14__TPM6_CH0                                   = IOMUX_PAD(0x0138, 0x0138, 0x6, 0x02D0, 0x2, 0),
	MX7ULP_PAD_PTE14__SDHC1_VS                                   = IOMUX_PAD(0x0138, 0x0138, 0x8, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE14__FB_A23                                     = IOMUX_PAD(0x0138, 0x0138, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE14__TRACE_D0                                   = IOMUX_PAD(0x0138, 0x0138, 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE14__USB0_OC                                    = IOMUX_PAD(0x0138, 0x0138, 0xb, 0x0330, 0x2, 0),
	MX7ULP_PAD_PTE14__VIU_D22                                    = IOMUX_PAD(0x0138, 0x0138, 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE15__PTE15                                      = IOMUX_PAD(0x013C, 0x013C, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE15__FXIO1_D16                                  = IOMUX_PAD(0x013C, 0x013C, 0x2, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE15__LPSPI3_PCS0                                = IOMUX_PAD(0x013C, 0x013C, 0x3, 0x0310, 0x2, 0),
	MX7ULP_PAD_PTE15__LPUART7_RX                                 = IOMUX_PAD(0x013C, 0x013C, 0x4, 0x026C, 0x2, 0),
	MX7ULP_PAD_PTE15__TPM6_CH1                                   = IOMUX_PAD(0x013C, 0x013C, 0x6, 0x02D4, 0x2, 0),
	MX7ULP_PAD_PTE15__FB_A24                                     = IOMUX_PAD(0x013C, 0x013C, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE15__TRACE_CLKOUT                               = IOMUX_PAD(0x013C, 0x013C, 0xa, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE15__USB0_PWR                                   = IOMUX_PAD(0x013C, 0x013C, 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTE15__VIU_D23                                    = IOMUX_PAD(0x013C, 0x013C, 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF0__PTF0                                        = IOMUX_PAD(0x0180, 0x0180, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF0__LPUART4_CTS_B                               = IOMUX_PAD(0x0180, 0x0180, 0x4, 0x0244, 0x3, 0),
	MX7ULP_PAD_PTF0__LPI2C4_SCL                                  = IOMUX_PAD(0x0180, 0x0180, 0x5, 0x0278, 0x3, 0),
	MX7ULP_PAD_PTF0__TPM4_CLKIN                                  = IOMUX_PAD(0x0180, 0x0180, 0x6, 0x0298, 0x3, 0),
	MX7ULP_PAD_PTF0__FB_RW_B                                     = IOMUX_PAD(0x0180, 0x0180, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF0__VIU_DE                                      = IOMUX_PAD(0x0180, 0x0180, 0xc, 0x033C, 0x0, 0),
	MX7ULP_PAD_PTF1__PTF1                                        = IOMUX_PAD(0x0184, 0x0184, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF1__LPUART4_RTS_B                               = IOMUX_PAD(0x0184, 0x0184, 0x4, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF1__LPI2C4_SDA                                  = IOMUX_PAD(0x0184, 0x0184, 0x5, 0x027C, 0x3, 0),
	MX7ULP_PAD_PTF1__TPM4_CH0                                    = IOMUX_PAD(0x0184, 0x0184, 0x6, 0x0280, 0x3, 0),
	MX7ULP_PAD_PTF1__CLKOUT                                      = IOMUX_PAD(0x0184, 0x0184, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF1__VIU_HSYNC                                   = IOMUX_PAD(0x0184, 0x0184, 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF2__PTF2                                        = IOMUX_PAD(0x0188, 0x0188, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF2__LPUART4_TX                                  = IOMUX_PAD(0x0188, 0x0188, 0x4, 0x024C, 0x3, 0),
	MX7ULP_PAD_PTF2__LPI2C4_HREQ                                 = IOMUX_PAD(0x0188, 0x0188, 0x5, 0x0274, 0x3, 0),
	MX7ULP_PAD_PTF2__TPM4_CH1                                    = IOMUX_PAD(0x0188, 0x0188, 0x6, 0x0284, 0x3, 0),
	MX7ULP_PAD_PTF2__FB_TSIZ1_FB_CS5_B_FB_BE23_16_BLS15_8_B      = IOMUX_PAD(0x0188, 0x0188, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF2__VIU_VSYNC                                   = IOMUX_PAD(0x0188, 0x0188, 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF3__PTF3                                        = IOMUX_PAD(0x018C, 0x018C, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF3__LPUART4_RX                                  = IOMUX_PAD(0x018C, 0x018C, 0x4, 0x0248, 0x3, 0),
	MX7ULP_PAD_PTF3__TPM4_CH2                                    = IOMUX_PAD(0x018C, 0x018C, 0x6, 0x0288, 0x3, 0),
	MX7ULP_PAD_PTF3__FB_AD16                                     = IOMUX_PAD(0x018C, 0x018C, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF3__VIU_PCLK                                    = IOMUX_PAD(0x018C, 0x018C, 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF4__PTF4                                        = IOMUX_PAD(0x0190, 0x0190, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF4__FXIO1_D0                                    = IOMUX_PAD(0x0190, 0x0190, 0x2, 0x0204, 0x2, 0),
	MX7ULP_PAD_PTF4__LPSPI2_PCS1                                 = IOMUX_PAD(0x0190, 0x0190, 0x3, 0x02A0, 0x3, 0),
	MX7ULP_PAD_PTF4__LPUART5_CTS_B                               = IOMUX_PAD(0x0190, 0x0190, 0x4, 0x0250, 0x3, 0),
	MX7ULP_PAD_PTF4__LPI2C5_SCL                                  = IOMUX_PAD(0x0190, 0x0190, 0x5, 0x02BC, 0x3, 0),
	MX7ULP_PAD_PTF4__TPM4_CH3                                    = IOMUX_PAD(0x0190, 0x0190, 0x6, 0x028C, 0x2, 0),
	MX7ULP_PAD_PTF4__FB_AD17                                     = IOMUX_PAD(0x0190, 0x0190, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF4__VIU_D0                                      = IOMUX_PAD(0x0190, 0x0190, 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF5__PTF5                                        = IOMUX_PAD(0x0194, 0x0194, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF5__FXIO1_D1                                    = IOMUX_PAD(0x0194, 0x0194, 0x2, 0x0208, 0x2, 0),
	MX7ULP_PAD_PTF5__LPSPI2_PCS2                                 = IOMUX_PAD(0x0194, 0x0194, 0x3, 0x02A4, 0x3, 0),
	MX7ULP_PAD_PTF5__LPUART5_RTS_B                               = IOMUX_PAD(0x0194, 0x0194, 0x4, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF5__LPI2C5_SDA                                  = IOMUX_PAD(0x0194, 0x0194, 0x5, 0x02C0, 0x3, 0),
	MX7ULP_PAD_PTF5__TPM4_CH4                                    = IOMUX_PAD(0x0194, 0x0194, 0x6, 0x0290, 0x2, 0),
	MX7ULP_PAD_PTF5__FB_AD18                                     = IOMUX_PAD(0x0194, 0x0194, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF5__VIU_D1                                      = IOMUX_PAD(0x0194, 0x0194, 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF6__PTF6                                        = IOMUX_PAD(0x0198, 0x0198, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF6__FXIO1_D2                                    = IOMUX_PAD(0x0198, 0x0198, 0x2, 0x020C, 0x2, 0),
	MX7ULP_PAD_PTF6__LPSPI2_PCS3                                 = IOMUX_PAD(0x0198, 0x0198, 0x3, 0x02A8, 0x3, 0),
	MX7ULP_PAD_PTF6__LPUART5_TX                                  = IOMUX_PAD(0x0198, 0x0198, 0x4, 0x0258, 0x3, 0),
	MX7ULP_PAD_PTF6__LPI2C5_HREQ                                 = IOMUX_PAD(0x0198, 0x0198, 0x5, 0x02B8, 0x3, 0),
	MX7ULP_PAD_PTF6__TPM4_CH5                                    = IOMUX_PAD(0x0198, 0x0198, 0x6, 0x0294, 0x2, 0),
	MX7ULP_PAD_PTF6__FB_AD19                                     = IOMUX_PAD(0x0198, 0x0198, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF6__VIU_D2                                      = IOMUX_PAD(0x0198, 0x0198, 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF7__PTF7                                        = IOMUX_PAD(0x019C, 0x019C, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF7__FXIO1_D3                                    = IOMUX_PAD(0x019C, 0x019C, 0x2, 0x0210, 0x2, 0),
	MX7ULP_PAD_PTF7__LPUART5_RX                                  = IOMUX_PAD(0x019C, 0x019C, 0x4, 0x0254, 0x3, 0),
	MX7ULP_PAD_PTF7__TPM5_CH1                                    = IOMUX_PAD(0x019C, 0x019C, 0x6, 0x02C8, 0x3, 0),
	MX7ULP_PAD_PTF7__FB_AD20                                     = IOMUX_PAD(0x019C, 0x019C, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF7__VIU_D3                                      = IOMUX_PAD(0x019C, 0x019C, 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF8__PTF8                                        = IOMUX_PAD(0x01A0, 0x01A0, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF8__FXIO1_D4                                    = IOMUX_PAD(0x01A0, 0x01A0, 0x2, 0x0214, 0x2, 0),
	MX7ULP_PAD_PTF8__LPSPI2_SIN                                  = IOMUX_PAD(0x01A0, 0x01A0, 0x3, 0x02B0, 0x3, 0),
	MX7ULP_PAD_PTF8__LPUART6_CTS_B                               = IOMUX_PAD(0x01A0, 0x01A0, 0x4, 0x025C, 0x3, 0),
	MX7ULP_PAD_PTF8__LPI2C6_SCL                                  = IOMUX_PAD(0x01A0, 0x01A0, 0x5, 0x02FC, 0x3, 0),
	MX7ULP_PAD_PTF8__TPM5_CLKIN                                  = IOMUX_PAD(0x01A0, 0x01A0, 0x6, 0x02CC, 0x3, 0),
	MX7ULP_PAD_PTF8__FB_AD21                                     = IOMUX_PAD(0x01A0, 0x01A0, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF8__USB1_CLK                                    = IOMUX_PAD(0x01A0, 0x01A0, 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF8__VIU_D4                                      = IOMUX_PAD(0x01A0, 0x01A0, 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF9__PTF9                                        = IOMUX_PAD(0x01A4, 0x01A4, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF9__FXIO1_D5                                    = IOMUX_PAD(0x01A4, 0x01A4, 0x2, 0x0218, 0x2, 0),
	MX7ULP_PAD_PTF9__LPSPI2_SOUT                                 = IOMUX_PAD(0x01A4, 0x01A4, 0x3, 0x02B4, 0x3, 0),
	MX7ULP_PAD_PTF9__LPUART6_RTS_B                               = IOMUX_PAD(0x01A4, 0x01A4, 0x4, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF9__LPI2C6_SDA                                  = IOMUX_PAD(0x01A4, 0x01A4, 0x5, 0x0300, 0x3, 0),
	MX7ULP_PAD_PTF9__TPM5_CH0                                    = IOMUX_PAD(0x01A4, 0x01A4, 0x6, 0x02C4, 0x3, 0),
	MX7ULP_PAD_PTF9__FB_AD22                                     = IOMUX_PAD(0x01A4, 0x01A4, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF9__USB1_NXT                                    = IOMUX_PAD(0x01A4, 0x01A4, 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF9__VIU_D5                                      = IOMUX_PAD(0x01A4, 0x01A4, 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF10__PTF10                                      = IOMUX_PAD(0x01A8, 0x01A8, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF10__FXIO1_D6                                   = IOMUX_PAD(0x01A8, 0x01A8, 0x2, 0x021C, 0x2, 0),
	MX7ULP_PAD_PTF10__LPSPI2_SCK                                 = IOMUX_PAD(0x01A8, 0x01A8, 0x3, 0x02AC, 0x3, 0),
	MX7ULP_PAD_PTF10__LPUART6_TX                                 = IOMUX_PAD(0x01A8, 0x01A8, 0x4, 0x0264, 0x3, 0),
	MX7ULP_PAD_PTF10__LPI2C6_HREQ                                = IOMUX_PAD(0x01A8, 0x01A8, 0x5, 0x02F8, 0x3, 0),
	MX7ULP_PAD_PTF10__TPM7_CH3                                   = IOMUX_PAD(0x01A8, 0x01A8, 0x6, 0x02E8, 0x3, 0),
	MX7ULP_PAD_PTF10__FB_AD23                                    = IOMUX_PAD(0x01A8, 0x01A8, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF10__USB1_STP                                   = IOMUX_PAD(0x01A8, 0x01A8, 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF10__VIU_D6                                     = IOMUX_PAD(0x01A8, 0x01A8, 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF11__PTF11                                      = IOMUX_PAD(0x01AC, 0x01AC, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF11__FXIO1_D7                                   = IOMUX_PAD(0x01AC, 0x01AC, 0x2, 0x0220, 0x2, 0),
	MX7ULP_PAD_PTF11__LPSPI2_PCS0                                = IOMUX_PAD(0x01AC, 0x01AC, 0x3, 0x029C, 0x3, 0),
	MX7ULP_PAD_PTF11__LPUART6_RX                                 = IOMUX_PAD(0x01AC, 0x01AC, 0x4, 0x0260, 0x3, 0),
	MX7ULP_PAD_PTF11__TPM7_CH4                                   = IOMUX_PAD(0x01AC, 0x01AC, 0x6, 0x02EC, 0x3, 0),
	MX7ULP_PAD_PTF11__FB_CS4_B_FB_TSIZ0_FB_BE31_24_BLS7_0_B      = IOMUX_PAD(0x01AC, 0x01AC, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF11__USB1_DIR                                   = IOMUX_PAD(0x01AC, 0x01AC, 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF11__VIU_D7                                     = IOMUX_PAD(0x01AC, 0x01AC, 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF12__PTF12                                      = IOMUX_PAD(0x01B0, 0x01B0, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF12__FXIO1_D8                                   = IOMUX_PAD(0x01B0, 0x01B0, 0x2, 0x0224, 0x2, 0),
	MX7ULP_PAD_PTF12__LPSPI3_PCS1                                = IOMUX_PAD(0x01B0, 0x01B0, 0x3, 0x0314, 0x3, 0),
	MX7ULP_PAD_PTF12__LPUART7_CTS_B                              = IOMUX_PAD(0x01B0, 0x01B0, 0x4, 0x0268, 0x3, 0),
	MX7ULP_PAD_PTF12__LPI2C7_SCL                                 = IOMUX_PAD(0x01B0, 0x01B0, 0x5, 0x0308, 0x3, 0),
	MX7ULP_PAD_PTF12__TPM7_CH5                                   = IOMUX_PAD(0x01B0, 0x01B0, 0x6, 0x02F0, 0x3, 0),
	MX7ULP_PAD_PTF12__FB_AD24                                    = IOMUX_PAD(0x01B0, 0x01B0, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF12__USB1_DATA0                                 = IOMUX_PAD(0x01B0, 0x01B0, 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF12__VIU_D8                                     = IOMUX_PAD(0x01B0, 0x01B0, 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF13__PTF13                                      = IOMUX_PAD(0x01B4, 0x01B4, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF13__FXIO1_D9                                   = IOMUX_PAD(0x01B4, 0x01B4, 0x2, 0x0228, 0x2, 0),
	MX7ULP_PAD_PTF13__LPSPI3_PCS2                                = IOMUX_PAD(0x01B4, 0x01B4, 0x3, 0x0318, 0x3, 0),
	MX7ULP_PAD_PTF13__LPUART7_RTS_B                              = IOMUX_PAD(0x01B4, 0x01B4, 0x4, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF13__LPI2C7_SDA                                 = IOMUX_PAD(0x01B4, 0x01B4, 0x5, 0x030C, 0x3, 0),
	MX7ULP_PAD_PTF13__TPM7_CLKIN                                 = IOMUX_PAD(0x01B4, 0x01B4, 0x6, 0x02F4, 0x3, 0),
	MX7ULP_PAD_PTF13__FB_AD25                                    = IOMUX_PAD(0x01B4, 0x01B4, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF13__USB1_DATA1                                 = IOMUX_PAD(0x01B4, 0x01B4, 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF13__VIU_D9                                     = IOMUX_PAD(0x01B4, 0x01B4, 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF14__PTF14                                      = IOMUX_PAD(0x01B8, 0x01B8, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF14__FXIO1_D10                                  = IOMUX_PAD(0x01B8, 0x01B8, 0x2, 0x022C, 0x2, 0),
	MX7ULP_PAD_PTF14__LPSPI3_PCS3                                = IOMUX_PAD(0x01B8, 0x01B8, 0x3, 0x031C, 0x3, 0),
	MX7ULP_PAD_PTF14__LPUART7_TX                                 = IOMUX_PAD(0x01B8, 0x01B8, 0x4, 0x0270, 0x3, 0),
	MX7ULP_PAD_PTF14__LPI2C7_HREQ                                = IOMUX_PAD(0x01B8, 0x01B8, 0x5, 0x0304, 0x3, 0),
	MX7ULP_PAD_PTF14__TPM7_CH0                                   = IOMUX_PAD(0x01B8, 0x01B8, 0x6, 0x02DC, 0x3, 0),
	MX7ULP_PAD_PTF14__FB_AD26                                    = IOMUX_PAD(0x01B8, 0x01B8, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF14__USB1_DATA2                                 = IOMUX_PAD(0x01B8, 0x01B8, 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF14__VIU_D10                                    = IOMUX_PAD(0x01B8, 0x01B8, 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF15__PTF15                                      = IOMUX_PAD(0x01BC, 0x01BC, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF15__FXIO1_D11                                  = IOMUX_PAD(0x01BC, 0x01BC, 0x2, 0x0230, 0x2, 0),
	MX7ULP_PAD_PTF15__LPUART7_RX                                 = IOMUX_PAD(0x01BC, 0x01BC, 0x4, 0x026C, 0x3, 0),
	MX7ULP_PAD_PTF15__TPM7_CH1                                   = IOMUX_PAD(0x01BC, 0x01BC, 0x6, 0x02E0, 0x3, 0),
	MX7ULP_PAD_PTF15__FB_AD27                                    = IOMUX_PAD(0x01BC, 0x01BC, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF15__USB1_DATA3                                 = IOMUX_PAD(0x01BC, 0x01BC, 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF15__VIU_D11                                    = IOMUX_PAD(0x01BC, 0x01BC, 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF16__PTF16                                      = IOMUX_PAD(0x01C0, 0x01C0, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF16__USB1_DATA4                                 = IOMUX_PAD(0x01C0, 0x01C0, 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF16__VIU_D12                                    = IOMUX_PAD(0x01C0, 0x01C0, 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF16__FXIO1_D12                                  = IOMUX_PAD(0x01C0, 0x01C0, 0x2, 0x0234, 0x2, 0),
	MX7ULP_PAD_PTF16__LPSPI3_SIN                                 = IOMUX_PAD(0x01C0, 0x01C0, 0x3, 0x0324, 0x3, 0),
	MX7ULP_PAD_PTF16__TPM7_CH2                                   = IOMUX_PAD(0x01C0, 0x01C0, 0x6, 0x02E4, 0x3, 0),
	MX7ULP_PAD_PTF16__FB_AD28                                    = IOMUX_PAD(0x01C0, 0x01C0, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF17__PTF17                                      = IOMUX_PAD(0x01C4, 0x01C4, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF17__USB1_DATA5                                 = IOMUX_PAD(0x01C4, 0x01C4, 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF17__VIU_D13                                    = IOMUX_PAD(0x01C4, 0x01C4, 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF17__FXIO1_D13                                  = IOMUX_PAD(0x01C4, 0x01C4, 0x2, 0x0238, 0x2, 0),
	MX7ULP_PAD_PTF17__LPSPI3_SOUT                                = IOMUX_PAD(0x01C4, 0x01C4, 0x3, 0x0328, 0x3, 0),
	MX7ULP_PAD_PTF17__TPM6_CLKIN                                 = IOMUX_PAD(0x01C4, 0x01C4, 0x6, 0x02D8, 0x3, 0),
	MX7ULP_PAD_PTF17__FB_AD29                                    = IOMUX_PAD(0x01C4, 0x01C4, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF18__PTF18                                      = IOMUX_PAD(0x01C8, 0x01C8, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF18__USB1_DATA6                                 = IOMUX_PAD(0x01C8, 0x01C8, 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF18__VIU_D14                                    = IOMUX_PAD(0x01C8, 0x01C8, 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF18__FXIO1_D14                                  = IOMUX_PAD(0x01C8, 0x01C8, 0x2, 0x023C, 0x2, 0),
	MX7ULP_PAD_PTF18__LPSPI3_SCK                                 = IOMUX_PAD(0x01C8, 0x01C8, 0x3, 0x0320, 0x3, 0),
	MX7ULP_PAD_PTF18__TPM6_CH0                                   = IOMUX_PAD(0x01C8, 0x01C8, 0x6, 0x02D0, 0x3, 0),
	MX7ULP_PAD_PTF18__FB_AD30                                    = IOMUX_PAD(0x01C8, 0x01C8, 0x9, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF19__PTF19                                      = IOMUX_PAD(0x01CC, 0x01CC, 0x1, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF19__USB1_DATA7                                 = IOMUX_PAD(0x01CC, 0x01CC, 0xb, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF19__VIU_D15                                    = IOMUX_PAD(0x01CC, 0x01CC, 0xc, 0x0000, 0x0, 0),
	MX7ULP_PAD_PTF19__FXIO1_D15                                  = IOMUX_PAD(0x01CC, 0x01CC, 0x2, 0x0240, 0x2, 0),
	MX7ULP_PAD_PTF19__LPSPI3_PCS0                                = IOMUX_PAD(0x01CC, 0x01CC, 0x3, 0x0310, 0x3, 0),
	MX7ULP_PAD_PTF19__TPM6_CH1                                   = IOMUX_PAD(0x01CC, 0x01CC, 0x6, 0x02D4, 0x3, 0),
	MX7ULP_PAD_PTF19__FB_AD31                                    = IOMUX_PAD(0x01CC, 0x01CC, 0x9, 0x0000, 0x0, 0),
};
#endif  /* __ASM_ARCH_IMX7ULP_PINS_H__ */
