/*
 * Copyright 2017 NXP
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#include <common.h>
#include <asm/io.h>
#include <asm/arch/clock.h>
#include <asm/arch/ddr.h>
#include "ddr.h"

extern void wait_ddrphy_training_complete(void);
void ddr_cfg_phy(void) {
	unsigned int tmp, tmp_t;

	//Init DDRPHY register...
	reg32_write(0x3c080440,0x2);
	reg32_write(0x3c080444,0x3);
	reg32_write(0x3c080448,0x4);
	reg32_write(0x3c08044c,0x5);
	reg32_write(0x3c080450,0x0);
	reg32_write(0x3c080454,0x1);
	reg32_write(0x3c04017c,0x1ff);
	reg32_write(0x3c04057c,0x1ff);
	reg32_write(0x3c04417c,0x1ff);
	reg32_write(0x3c04457c,0x1ff);
	reg32_write(0x3c04817c,0x1ff);
	reg32_write(0x3c04857c,0x1ff);
	reg32_write(0x3c04c17c,0x1ff);
	reg32_write(0x3c04c57c,0x1ff);
	reg32_write(0x3c44017c,0x1ff);
	reg32_write(0x3c44057c,0x1ff);
	reg32_write(0x3c44417c,0x1ff);
	reg32_write(0x3c44457c,0x1ff);
	reg32_write(0x3c44817c,0x1ff);
	reg32_write(0x3c44857c,0x1ff);
	reg32_write(0x3c44c17c,0x1ff);
	reg32_write(0x3c44c57c,0x1ff);
	reg32_write(0x3c000154,0x1ff);
	reg32_write(0x3c004154,0x1ff);
	reg32_write(0x3c008154,0x1ff);
	reg32_write(0x3c00c154,0x1ff);
	reg32_write(0x3c010154,0x1ff);
	reg32_write(0x3c014154,0x1ff);
	reg32_write(0x3c018154,0x1ff);
	reg32_write(0x3c01c154,0x1ff);
	reg32_write(0x3c020154,0x1ff);
	reg32_write(0x3c024154,0x1ff);
	reg32_write(0x3c080314,0x19);
	reg32_write(0x3c480314,0x7);
	reg32_write(0x3c0800b8,0x2);
	reg32_write(0x3c4800b8,0x1);
	reg32_write(0x3c240810,0x0);
	reg32_write(0x3c640810,0x0);
	reg32_write(0x3c080090,0xab);
	reg32_write(0x3c0800e8,0x0);
	reg32_write(0x3c480090,0xab);
	reg32_write(0x3c0800e8,0x0);
	reg32_write(0x3c080158,0x3);
	reg32_write(0x3c480158,0xa);
	reg32_write(0x3c040134,0xe00);
	reg32_write(0x3c040534,0xe00);
	reg32_write(0x3c044134,0xe00);
	reg32_write(0x3c044534,0xe00);
	reg32_write(0x3c048134,0xe00);
	reg32_write(0x3c048534,0xe00);
	reg32_write(0x3c04c134,0xe00);
	reg32_write(0x3c04c534,0xe00);
	reg32_write(0x3c440134,0xe00);
	reg32_write(0x3c440534,0xe00);
	reg32_write(0x3c444134,0xe00);
	reg32_write(0x3c444534,0xe00);
	reg32_write(0x3c448134,0xe00);
	reg32_write(0x3c448534,0xe00);
	reg32_write(0x3c44c134,0xe00);
	reg32_write(0x3c44c534,0xe00);
	reg32_write(0x3c040124,0xfbe);
	reg32_write(0x3c040524,0xfbe);
	reg32_write(0x3c044124,0xfbe);
	reg32_write(0x3c044524,0xfbe);
	reg32_write(0x3c048124,0xfbe);
	reg32_write(0x3c048524,0xfbe);
	reg32_write(0x3c04c124,0xfbe);
	reg32_write(0x3c04c524,0xfbe);
	reg32_write(0x3c440124,0xfbe);
	reg32_write(0x3c440524,0xfbe);
	reg32_write(0x3c444124,0xfbe);
	reg32_write(0x3c444524,0xfbe);
	reg32_write(0x3c448124,0xfbe);
	reg32_write(0x3c448524,0xfbe);
	reg32_write(0x3c44c124,0xfbe);
	reg32_write(0x3c44c524,0xfbe);
	reg32_write(0x3c00010c,0x63);
	reg32_write(0x3c00410c,0x63);
	reg32_write(0x3c00810c,0x63);
	reg32_write(0x3c00c10c,0x63);
	reg32_write(0x3c01010c,0x63);
	reg32_write(0x3c01410c,0x63);
	reg32_write(0x3c01810c,0x63);
	reg32_write(0x3c01c10c,0x63);
	reg32_write(0x3c02010c,0x63);
	reg32_write(0x3c02410c,0x63);
	reg32_write(0x3c080060,0x3);
	reg32_write(0x3c0801d4,0x4);
	reg32_write(0x3c080140,0x0);
	reg32_write(0x3c080020,0x320);
	reg32_write(0x3c480020,0xa7);
	reg32_write(0x3c080220,0x9);
	reg32_write(0x3c0802c8,0xdc);
	reg32_write(0x3c04010c,0x5a1);
	reg32_write(0x3c04050c,0x5a1);
	reg32_write(0x3c04410c,0x5a1);
	reg32_write(0x3c04450c,0x5a1);
	reg32_write(0x3c04810c,0x5a1);
	reg32_write(0x3c04850c,0x5a1);
	reg32_write(0x3c04c10c,0x5a1);
	reg32_write(0x3c04c50c,0x5a1);
	reg32_write(0x3c4802c8,0xdc);
	reg32_write(0x3c44010c,0x5a1);
	reg32_write(0x3c44050c,0x5a1);
	reg32_write(0x3c44410c,0x5a1);
	reg32_write(0x3c44450c,0x5a1);
	reg32_write(0x3c44810c,0x5a1);
	reg32_write(0x3c44850c,0x5a1);
	reg32_write(0x3c44c10c,0x5a1);
	reg32_write(0x3c44c50c,0x5a1);
	reg32_write(0x3c0803e8,0x1);
	reg32_write(0x3c4803e8,0x1);
	reg32_write(0x3c080064,0x1);
	reg32_write(0x3c480064,0x1);
	reg32_write(0x3c0803c0,0x0);
	reg32_write(0x3c0803c4,0x0);
	reg32_write(0x3c0803c8,0x4444);
	reg32_write(0x3c0803cc,0x8888);
	reg32_write(0x3c0803d0,0x5555);
	reg32_write(0x3c0803d4,0x0);
	reg32_write(0x3c0803d8,0x0);
	reg32_write(0x3c0803dc,0xf000);
	reg32_write(0x3c080094,0x0);
	reg32_write(0x3c0800b4,0x0);
	reg32_write(0x3c4800b4,0x0);
	reg32_write(0x3c080180,0x2);

	//enable APB bus to access DDRPHY RAM
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x0);
	//load the 1D training image
	ddr_load_train_code(FW_1D_IMAGE);

	//configure DDRPHY-FW DMEM structure @clock0...
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099, 0x1);

	//set the PHY input clock to the desired frequency for pstate 0
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54003,0xc80);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54004,0x2);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54006,0x11);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54008,0x131f);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54009,0xc8);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5400b,0x2);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5400d,0x100);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54012,0x110);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54019,0x2dd4);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401a,0x31);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401b,0x4a66);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401c,0x4a08);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401e,0x16);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401f,0x2dd4);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54020,0x31);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54021,0x4a66);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54022,0x4a08);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54024,0x16);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5402b,0x1000);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5402c,0x1);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54032,0xd400);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54033,0x312d);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54034,0x6600);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54035,0x84a);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54036,0x4a);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54037,0x1600);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54038,0xd400);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54039,0x312d);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5403a,0x6600);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5403b,0x84a);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5403c,0x4a);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5403d,0x1600);

	//disable APB bus to access DDRPHY RAM
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x1);
	//Reset MPU and run
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099, 0x9);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099, 0x1);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099, 0x0);
	wait_ddrphy_training_complete();

	//configure DDRPHY-FW DMEM structure @clock1...
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099, 0x1);

	//set the PHY input clock to the desired frequency for pstate 1
	reg32_write(0x3038a088,0x7070000);
	reg32_write(0x3038a084,0x4030000);
	reg32_write(0x303a00ec,0xffff);
	tmp=reg32_read(0x303a00f8);
	tmp |= 0x20;
	reg32_write(0x303a00f8,tmp);
	reg32_write(0x30360068,0xf5a406);
	tmp=reg32_read(0x30360060);
	tmp &= ~0x80;
	reg32_write(0x30360060,tmp);
	tmp=reg32_read(0x30360060);
	tmp |= 0x200;
	reg32_write(0x30360060,tmp);
	tmp=reg32_read(0x30360060);
	tmp &= ~0x20;
	reg32_write(0x30360060,tmp);
	tmp=reg32_read(0x30360060);
	tmp &= ~0x10;
	reg32_write(0x30360060,tmp);
	do{
		tmp=reg32_read(0x30360060);
		if(tmp&0x80000000) break;
	}while(1);
	reg32_write(0x30389808,0x1000000);

	//enable APB bus to access DDRPHY RAM
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x0);

	reg32_write(0x3c150008,0x1);
	reg32_write(0x3c15000c,0x29c);
	reg32_write(0x3c150020,0x121f);
	reg32_write(0x3c150064,0x994);
	reg32_write(0x3c150068,0x31);
	reg32_write(0x3c15006c,0x4d46);
	reg32_write(0x3c150070,0x4d08);
	reg32_write(0x3c150074,0x0);
	reg32_write(0x3c150078,0x15);
	reg32_write(0x3c15007c,0x994);
	reg32_write(0x3c150080,0x31);
	reg32_write(0x3c150084,0x4d46);
	reg32_write(0x3c150088,0x4d08);
	reg32_write(0x3c15008c,0x0);
	reg32_write(0x3c150090,0x15);
	reg32_write(0x3c1500c8,0x9400);
	reg32_write(0x3c1500cc,0x3109);
	reg32_write(0x3c1500d0,0x4600);
	reg32_write(0x3c1500d4,0x84d);
	reg32_write(0x3c1500d8,0x4d);
	reg32_write(0x3c1500dc,0x1500);
	reg32_write(0x3c1500e0,0x9400);
	reg32_write(0x3c1500e4,0x3109);
	reg32_write(0x3c1500e8,0x4600);
	reg32_write(0x3c1500ec,0x84d);
	reg32_write(0x3c1500f0,0x4d);
	reg32_write(0x3c1500f4,0x1500);
	reg32_write(0x3c1500f8,0x0);

	//disable APB bus to access DDRPHY RAM
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x1);
	//Reset MPU and run
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099, 0x9);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099, 0x1);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099, 0x0);
	wait_ddrphy_training_complete();

	//set the PHY input clock to the desired frequency for pstate 0
	reg32_write(0x3038a088,0x7070000);
	reg32_write(0x3038a084,0x4030000);
	reg32_write(0x303a00ec,0xffff);
	tmp=reg32_read(0x303a00f8);
	tmp |= 0x20;
	reg32_write(0x303a00f8,tmp);
	reg32_write(0x30360068,0xece580);
	tmp=reg32_read(0x30360060);
	tmp &= ~0x80;
	reg32_write(0x30360060,tmp);
	tmp=reg32_read(0x30360060);
	tmp |= 0x200;
	reg32_write(0x30360060,tmp);
	tmp=reg32_read(0x30360060);
	tmp &= ~0x20;
	reg32_write(0x30360060,tmp);
	tmp=reg32_read(0x30360060);
	tmp &= ~0x10;
	reg32_write(0x30360060,tmp);
	do{
		tmp=reg32_read(0x30360060);
		if(tmp&0x80000000) break;
	}while(1);
	reg32_write(0x30389808,0x1000000);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099, 0x1);


	//enable APB bus to access DDRPHY RAM
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x0);
	//load the 2D training image
	ddr_load_train_code(FW_2D_IMAGE);

	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54003,0xc80);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54006,0x11);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54008,0x61);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54009,0xc8);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5400b,0x2);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5400f,0x100);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54010,0x1f7f);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54012,0x110);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54019,0x2dd4);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401a,0x31);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401b,0x4a66);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401c,0x4a08);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401e,0x16);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401f,0x2dd4);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54020,0x31);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54021,0x4a66);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54022,0x4a08);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54024,0x16);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5402b,0x1000);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5402c,0x1);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54032,0xd400);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54033,0x312d);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54034,0x6600);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54035,0x84a);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54036,0x4a);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54037,0x1600);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54038,0xd400);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54039,0x312d);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5403a,0x6600);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5403b,0x84a);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5403c,0x4a);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5403d,0x1600);

	//disable APB bus to access DDRPHY RAM
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x1);
	//Reset MPU and run
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099, 0x9);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099, 0x1);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099, 0x0);
	wait_ddrphy_training_complete();

	//Halt MPU
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099, 0x1);
	//enable APB bus to access DDRPHY RAM
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x0);

	//Load firmware PIE image
	reg32_write(0x3c240000,0x10);
	reg32_write(0x3c240004,0x400);
	reg32_write(0x3c240008,0x10e);
	reg32_write(0x3c24000c,0x0);
	reg32_write(0x3c240010,0x0);
	reg32_write(0x3c240014,0x8);
	reg32_write(0x3c2400a4,0xb);
	reg32_write(0x3c2400a8,0x480);
	reg32_write(0x3c2400ac,0x109);
	reg32_write(0x3c2400b0,0x8);
	reg32_write(0x3c2400b4,0x448);
	reg32_write(0x3c2400b8,0x139);
	reg32_write(0x3c2400bc,0x8);
	reg32_write(0x3c2400c0,0x478);
	reg32_write(0x3c2400c4,0x109);
	reg32_write(0x3c2400c8,0x0);
	reg32_write(0x3c2400cc,0xe8);
	reg32_write(0x3c2400d0,0x109);
	reg32_write(0x3c2400d4,0x2);
	reg32_write(0x3c2400d8,0x10);
	reg32_write(0x3c2400dc,0x139);
	reg32_write(0x3c2400e0,0xf);
	reg32_write(0x3c2400e4,0x7c0);
	reg32_write(0x3c2400e8,0x139);
	reg32_write(0x3c2400ec,0x44);
	reg32_write(0x3c2400f0,0x630);
	reg32_write(0x3c2400f4,0x159);
	reg32_write(0x3c2400f8,0x14f);
	reg32_write(0x3c2400fc,0x630);
	reg32_write(0x3c240100,0x159);
	reg32_write(0x3c240104,0x47);
	reg32_write(0x3c240108,0x630);
	reg32_write(0x3c24010c,0x149);
	reg32_write(0x3c240110,0x4f);
	reg32_write(0x3c240114,0x630);
	reg32_write(0x3c240118,0x179);
	reg32_write(0x3c24011c,0x8);
	reg32_write(0x3c240120,0xe0);
	reg32_write(0x3c240124,0x109);
	reg32_write(0x3c240128,0x0);
	reg32_write(0x3c24012c,0x7c8);
	reg32_write(0x3c240130,0x109);
	reg32_write(0x3c240134,0x0);
	reg32_write(0x3c240138,0x1);
	reg32_write(0x3c24013c,0x8);
	reg32_write(0x3c240140,0x0);
	reg32_write(0x3c240144,0x45a);
	reg32_write(0x3c240148,0x9);
	reg32_write(0x3c24014c,0x0);
	reg32_write(0x3c240150,0x448);
	reg32_write(0x3c240154,0x109);
	reg32_write(0x3c240158,0x40);
	reg32_write(0x3c24015c,0x630);
	reg32_write(0x3c240160,0x179);
	reg32_write(0x3c240164,0x1);
	reg32_write(0x3c240168,0x618);
	reg32_write(0x3c24016c,0x109);
	reg32_write(0x3c240170,0x40c0);
	reg32_write(0x3c240174,0x630);
	reg32_write(0x3c240178,0x149);
	reg32_write(0x3c24017c,0x8);
	reg32_write(0x3c240180,0x4);
	reg32_write(0x3c240184,0x48);
	reg32_write(0x3c240188,0x4040);
	reg32_write(0x3c24018c,0x630);
	reg32_write(0x3c240190,0x149);
	reg32_write(0x3c240194,0x0);
	reg32_write(0x3c240198,0x4);
	reg32_write(0x3c24019c,0x48);
	reg32_write(0x3c2401a0,0x40);
	reg32_write(0x3c2401a4,0x630);
	reg32_write(0x3c2401a8,0x149);
	reg32_write(0x3c2401ac,0x10);
	reg32_write(0x3c2401b0,0x4);
	reg32_write(0x3c2401b4,0x18);
	reg32_write(0x3c2401b8,0x0);
	reg32_write(0x3c2401bc,0x4);
	reg32_write(0x3c2401c0,0x78);
	reg32_write(0x3c2401c4,0x549);
	reg32_write(0x3c2401c8,0x630);
	reg32_write(0x3c2401cc,0x159);
	reg32_write(0x3c2401d0,0xd49);
	reg32_write(0x3c2401d4,0x630);
	reg32_write(0x3c2401d8,0x159);
	reg32_write(0x3c2401dc,0x94a);
	reg32_write(0x3c2401e0,0x630);
	reg32_write(0x3c2401e4,0x159);
	reg32_write(0x3c2401e8,0x441);
	reg32_write(0x3c2401ec,0x630);
	reg32_write(0x3c2401f0,0x149);
	reg32_write(0x3c2401f4,0x42);
	reg32_write(0x3c2401f8,0x630);
	reg32_write(0x3c2401fc,0x149);
	reg32_write(0x3c240200,0x1);
	reg32_write(0x3c240204,0x630);
	reg32_write(0x3c240208,0x149);
	reg32_write(0x3c24020c,0x0);
	reg32_write(0x3c240210,0xe0);
	reg32_write(0x3c240214,0x109);
	reg32_write(0x3c240218,0xa);
	reg32_write(0x3c24021c,0x10);
	reg32_write(0x3c240220,0x109);
	reg32_write(0x3c240224,0x9);
	reg32_write(0x3c240228,0x3c0);
	reg32_write(0x3c24022c,0x149);
	reg32_write(0x3c240230,0x9);
	reg32_write(0x3c240234,0x3c0);
	reg32_write(0x3c240238,0x159);
	reg32_write(0x3c24023c,0x18);
	reg32_write(0x3c240240,0x10);
	reg32_write(0x3c240244,0x109);
	reg32_write(0x3c240248,0x0);
	reg32_write(0x3c24024c,0x3c0);
	reg32_write(0x3c240250,0x109);
	reg32_write(0x3c240254,0x18);
	reg32_write(0x3c240258,0x4);
	reg32_write(0x3c24025c,0x48);
	reg32_write(0x3c240260,0x18);
	reg32_write(0x3c240264,0x4);
	reg32_write(0x3c240268,0x58);
	reg32_write(0x3c24026c,0xa);
	reg32_write(0x3c240270,0x10);
	reg32_write(0x3c240274,0x109);
	reg32_write(0x3c240278,0x2);
	reg32_write(0x3c24027c,0x10);
	reg32_write(0x3c240280,0x109);
	reg32_write(0x3c240284,0x5);
	reg32_write(0x3c240288,0x7c0);
	reg32_write(0x3c24028c,0x109);
	reg32_write(0x3c240290,0x10);
	reg32_write(0x3c240294,0x10);
	reg32_write(0x3c240298,0x109);
	reg32_write(0x3c100000,0x811);
	reg32_write(0x3c100080,0x880);
	reg32_write(0x3c100100,0x0);
	reg32_write(0x3c100180,0x0);
	reg32_write(0x3c100004,0x4008);
	reg32_write(0x3c100084,0x83);
	reg32_write(0x3c100104,0x4f);
	reg32_write(0x3c100184,0x0);
	reg32_write(0x3c100008,0x4040);
	reg32_write(0x3c100088,0x83);
	reg32_write(0x3c100108,0x51);
	reg32_write(0x3c100188,0x0);
	reg32_write(0x3c10000c,0x811);
	reg32_write(0x3c10008c,0x880);
	reg32_write(0x3c10010c,0x0);
	reg32_write(0x3c10018c,0x0);
	reg32_write(0x3c100010,0x720);
	reg32_write(0x3c100090,0xf);
	reg32_write(0x3c100110,0x1740);
	reg32_write(0x3c100190,0x0);
	reg32_write(0x3c100014,0x16);
	reg32_write(0x3c100094,0x83);
	reg32_write(0x3c100114,0x4b);
	reg32_write(0x3c100194,0x0);
	reg32_write(0x3c100018,0x716);
	reg32_write(0x3c100098,0xf);
	reg32_write(0x3c100118,0x2001);
	reg32_write(0x3c100198,0x0);
	reg32_write(0x3c10001c,0x716);
	reg32_write(0x3c10009c,0xf);
	reg32_write(0x3c10011c,0x2800);
	reg32_write(0x3c10019c,0x0);
	reg32_write(0x3c100020,0x716);
	reg32_write(0x3c1000a0,0xf);
	reg32_write(0x3c100120,0xf00);
	reg32_write(0x3c1001a0,0x0);
	reg32_write(0x3c100024,0x720);
	reg32_write(0x3c1000a4,0xf);
	reg32_write(0x3c100124,0x1400);
	reg32_write(0x3c1001a4,0x0);
	reg32_write(0x3c100028,0xe08);
	reg32_write(0x3c1000a8,0xc15);
	reg32_write(0x3c100128,0x0);
	reg32_write(0x3c1001a8,0x0);
	reg32_write(0x3c10002c,0x623);
	reg32_write(0x3c1000ac,0x15);
	reg32_write(0x3c10012c,0x0);
	reg32_write(0x3c1001ac,0x0);
	reg32_write(0x3c100030,0x4028);
	reg32_write(0x3c1000b0,0x80);
	reg32_write(0x3c100130,0x0);
	reg32_write(0x3c1001b0,0x0);
	reg32_write(0x3c100034,0xe08);
	reg32_write(0x3c1000b4,0xc1a);
	reg32_write(0x3c100134,0x0);
	reg32_write(0x3c1001b4,0x0);
	reg32_write(0x3c100038,0x623);
	reg32_write(0x3c1000b8,0x1a);
	reg32_write(0x3c100138,0x0);
	reg32_write(0x3c1001b8,0x0);
	reg32_write(0x3c10003c,0x4040);
	reg32_write(0x3c1000bc,0x80);
	reg32_write(0x3c10013c,0x0);
	reg32_write(0x3c1001bc,0x0);
	reg32_write(0x3c100040,0x2604);
	reg32_write(0x3c1000c0,0x15);
	reg32_write(0x3c100140,0x0);
	reg32_write(0x3c1001c0,0x0);
	reg32_write(0x3c100044,0x708);
	reg32_write(0x3c1000c4,0x5);
	reg32_write(0x3c100144,0x0);
	reg32_write(0x3c1001c4,0x2002);
	reg32_write(0x3c100048,0x8);
	reg32_write(0x3c1000c8,0x80);
	reg32_write(0x3c100148,0x0);
	reg32_write(0x3c1001c8,0x0);
	reg32_write(0x3c10004c,0x2604);
	reg32_write(0x3c1000cc,0x1a);
	reg32_write(0x3c10014c,0x0);
	reg32_write(0x3c1001cc,0x0);
	reg32_write(0x3c100050,0x708);
	reg32_write(0x3c1000d0,0xa);
	reg32_write(0x3c100150,0x0);
	reg32_write(0x3c1001d0,0x2002);
	reg32_write(0x3c100054,0x4040);
	reg32_write(0x3c1000d4,0x80);
	reg32_write(0x3c100154,0x0);
	reg32_write(0x3c1001d4,0x0);
	reg32_write(0x3c100058,0x60a);
	reg32_write(0x3c1000d8,0x15);
	reg32_write(0x3c100158,0x1200);
	reg32_write(0x3c1001d8,0x0);
	reg32_write(0x3c10005c,0x61a);
	reg32_write(0x3c1000dc,0x15);
	reg32_write(0x3c10015c,0x1300);
	reg32_write(0x3c1001dc,0x0);
	reg32_write(0x3c100060,0x60a);
	reg32_write(0x3c1000e0,0x1a);
	reg32_write(0x3c100160,0x1200);
	reg32_write(0x3c1001e0,0x0);
	reg32_write(0x3c100064,0x642);
	reg32_write(0x3c1000e4,0x1a);
	reg32_write(0x3c100164,0x1300);
	reg32_write(0x3c1001e4,0x0);
	reg32_write(0x3c100068,0x4808);
	reg32_write(0x3c1000e8,0x880);
	reg32_write(0x3c100168,0x0);
	reg32_write(0x3c1001e8,0x0);
	reg32_write(0x3c24029c,0x0);
	reg32_write(0x3c2402a0,0x790);
	reg32_write(0x3c2402a4,0x11a);
	reg32_write(0x3c2402a8,0x8);
	reg32_write(0x3c2402ac,0x7aa);
	reg32_write(0x3c2402b0,0x2a);
	reg32_write(0x3c2402b4,0x10);
	reg32_write(0x3c2402b8,0x7b2);
	reg32_write(0x3c2402bc,0x2a);
	reg32_write(0x3c2402c0,0x0);
	reg32_write(0x3c2402c4,0x7c8);
	reg32_write(0x3c2402c8,0x109);
	reg32_write(0x3c2402cc,0x10);
	reg32_write(0x3c2402d0,0x2a8);
	reg32_write(0x3c2402d4,0x129);
	reg32_write(0x3c2402d8,0x8);
	reg32_write(0x3c2402dc,0x370);
	reg32_write(0x3c2402e0,0x129);
	reg32_write(0x3c2402e4,0xa);
	reg32_write(0x3c2402e8,0x3c8);
	reg32_write(0x3c2402ec,0x1a9);
	reg32_write(0x3c2402f0,0xc);
	reg32_write(0x3c2402f4,0x408);
	reg32_write(0x3c2402f8,0x199);
	reg32_write(0x3c2402fc,0x14);
	reg32_write(0x3c240300,0x790);
	reg32_write(0x3c240304,0x11a);
	reg32_write(0x3c240308,0x8);
	reg32_write(0x3c24030c,0x4);
	reg32_write(0x3c240310,0x18);
	reg32_write(0x3c240314,0xe);
	reg32_write(0x3c240318,0x408);
	reg32_write(0x3c24031c,0x199);
	reg32_write(0x3c240320,0x8);
	reg32_write(0x3c240324,0x8568);
	reg32_write(0x3c240328,0x108);
	reg32_write(0x3c24032c,0x18);
	reg32_write(0x3c240330,0x790);
	reg32_write(0x3c240334,0x16a);
	reg32_write(0x3c240338,0x8);
	reg32_write(0x3c24033c,0x1d8);
	reg32_write(0x3c240340,0x169);
	reg32_write(0x3c240344,0x10);
	reg32_write(0x3c240348,0x8558);
	reg32_write(0x3c24034c,0x168);
	reg32_write(0x3c240350,0x70);
	reg32_write(0x3c240354,0x788);
	reg32_write(0x3c240358,0x16a);
	reg32_write(0x3c24035c,0x1ff8);
	reg32_write(0x3c240360,0x85a8);
	reg32_write(0x3c240364,0x1e8);
	reg32_write(0x3c240368,0x50);
	reg32_write(0x3c24036c,0x798);
	reg32_write(0x3c240370,0x16a);
	reg32_write(0x3c240374,0x60);
	reg32_write(0x3c240378,0x7a0);
	reg32_write(0x3c24037c,0x16a);
	reg32_write(0x3c240380,0x8);
	reg32_write(0x3c240384,0x8310);
	reg32_write(0x3c240388,0x168);
	reg32_write(0x3c24038c,0x8);
	reg32_write(0x3c240390,0xa310);
	reg32_write(0x3c240394,0x168);
	reg32_write(0x3c240398,0xa);
	reg32_write(0x3c24039c,0x408);
	reg32_write(0x3c2403a0,0x169);
	reg32_write(0x3c2403a4,0x6e);
	reg32_write(0x3c2403a8,0x0);
	reg32_write(0x3c2403ac,0x68);
	reg32_write(0x3c2403b0,0x0);
	reg32_write(0x3c2403b4,0x408);
	reg32_write(0x3c2403b8,0x169);
	reg32_write(0x3c2403bc,0x0);
	reg32_write(0x3c2403c0,0x8310);
	reg32_write(0x3c2403c4,0x168);
	reg32_write(0x3c2403c8,0x0);
	reg32_write(0x3c2403cc,0xa310);
	reg32_write(0x3c2403d0,0x168);
	reg32_write(0x3c2403d4,0x1ff8);
	reg32_write(0x3c2403d8,0x85a8);
	reg32_write(0x3c2403dc,0x1e8);
	reg32_write(0x3c2403e0,0x68);
	reg32_write(0x3c2403e4,0x798);
	reg32_write(0x3c2403e8,0x16a);
	reg32_write(0x3c2403ec,0x78);
	reg32_write(0x3c2403f0,0x7a0);
	reg32_write(0x3c2403f4,0x16a);
	reg32_write(0x3c2403f8,0x68);
	reg32_write(0x3c2403fc,0x790);
	reg32_write(0x3c240400,0x16a);
	reg32_write(0x3c240404,0x8);
	reg32_write(0x3c240408,0x8b10);
	reg32_write(0x3c24040c,0x168);
	reg32_write(0x3c240410,0x8);
	reg32_write(0x3c240414,0xab10);
	reg32_write(0x3c240418,0x168);
	reg32_write(0x3c24041c,0xa);
	reg32_write(0x3c240420,0x408);
	reg32_write(0x3c240424,0x169);
	reg32_write(0x3c240428,0x58);
	reg32_write(0x3c24042c,0x0);
	reg32_write(0x3c240430,0x68);
	reg32_write(0x3c240434,0x0);
	reg32_write(0x3c240438,0x408);
	reg32_write(0x3c24043c,0x169);
	reg32_write(0x3c240440,0x0);
	reg32_write(0x3c240444,0x8b10);
	reg32_write(0x3c240448,0x168);
	reg32_write(0x3c24044c,0x0);
	reg32_write(0x3c240450,0xab10);
	reg32_write(0x3c240454,0x168);
	reg32_write(0x3c240458,0x0);
	reg32_write(0x3c24045c,0x1d8);
	reg32_write(0x3c240460,0x169);
	reg32_write(0x3c240464,0x80);
	reg32_write(0x3c240468,0x790);
	reg32_write(0x3c24046c,0x16a);
	reg32_write(0x3c240470,0x18);
	reg32_write(0x3c240474,0x7aa);
	reg32_write(0x3c240478,0x6a);
	reg32_write(0x3c24047c,0xa);
	reg32_write(0x3c240480,0x0);
	reg32_write(0x3c240484,0x1e9);
	reg32_write(0x3c240488,0x8);
	reg32_write(0x3c24048c,0x8080);
	reg32_write(0x3c240490,0x108);
	reg32_write(0x3c240494,0xf);
	reg32_write(0x3c240498,0x408);
	reg32_write(0x3c24049c,0x169);
	reg32_write(0x3c2404a0,0xc);
	reg32_write(0x3c2404a4,0x0);
	reg32_write(0x3c2404a8,0x68);
	reg32_write(0x3c2404ac,0x9);
	reg32_write(0x3c2404b0,0x0);
	reg32_write(0x3c2404b4,0x1a9);
	reg32_write(0x3c2404b8,0x0);
	reg32_write(0x3c2404bc,0x408);
	reg32_write(0x3c2404c0,0x169);
	reg32_write(0x3c2404c4,0x0);
	reg32_write(0x3c2404c8,0x8080);
	reg32_write(0x3c2404cc,0x108);
	reg32_write(0x3c2404d0,0x8);
	reg32_write(0x3c2404d4,0x7aa);
	reg32_write(0x3c2404d8,0x6a);
	reg32_write(0x3c2404dc,0x0);
	reg32_write(0x3c2404e0,0x8568);
	reg32_write(0x3c2404e4,0x108);
	reg32_write(0x3c2404e8,0xb7);
	reg32_write(0x3c2404ec,0x790);
	reg32_write(0x3c2404f0,0x16a);
	reg32_write(0x3c2404f4,0x1f);
	reg32_write(0x3c2404f8,0x0);
	reg32_write(0x3c2404fc,0x68);
	reg32_write(0x3c240500,0x8);
	reg32_write(0x3c240504,0x8558);
	reg32_write(0x3c240508,0x168);
	reg32_write(0x3c24050c,0xf);
	reg32_write(0x3c240510,0x408);
	reg32_write(0x3c240514,0x169);
	reg32_write(0x3c240518,0xc);
	reg32_write(0x3c24051c,0x0);
	reg32_write(0x3c240520,0x68);
	reg32_write(0x3c240524,0x0);
	reg32_write(0x3c240528,0x408);
	reg32_write(0x3c24052c,0x169);
	reg32_write(0x3c240530,0x0);
	reg32_write(0x3c240534,0x8558);
	reg32_write(0x3c240538,0x168);
	reg32_write(0x3c24053c,0x8);
	reg32_write(0x3c240540,0x3c8);
	reg32_write(0x3c240544,0x1a9);
	reg32_write(0x3c240548,0x3);
	reg32_write(0x3c24054c,0x370);
	reg32_write(0x3c240550,0x129);
	reg32_write(0x3c240554,0x20);
	reg32_write(0x3c240558,0x2aa);
	reg32_write(0x3c24055c,0x9);
	reg32_write(0x3c240560,0x0);
	reg32_write(0x3c240564,0x400);
	reg32_write(0x3c240568,0x10e);
	reg32_write(0x3c24056c,0x8);
	reg32_write(0x3c240570,0xe8);
	reg32_write(0x3c240574,0x109);
	reg32_write(0x3c240578,0x0);
	reg32_write(0x3c24057c,0x8140);
	reg32_write(0x3c240580,0x10c);
	reg32_write(0x3c240584,0x10);
	reg32_write(0x3c240588,0x8138);
	reg32_write(0x3c24058c,0x10c);
	reg32_write(0x3c240590,0x8);
	reg32_write(0x3c240594,0x7c8);
	reg32_write(0x3c240598,0x101);
	reg32_write(0x3c24059c,0x8);
	reg32_write(0x3c2405a0,0x0);
	reg32_write(0x3c2405a4,0x8);
	reg32_write(0x3c2405a8,0x8);
	reg32_write(0x3c2405ac,0x448);
	reg32_write(0x3c2405b0,0x109);
	reg32_write(0x3c2405b4,0xf);
	reg32_write(0x3c2405b8,0x7c0);
	reg32_write(0x3c2405bc,0x109);
	reg32_write(0x3c2405c0,0x0);
	reg32_write(0x3c2405c4,0xe8);
	reg32_write(0x3c2405c8,0x109);
	reg32_write(0x3c2405cc,0x47);
	reg32_write(0x3c2405d0,0x630);
	reg32_write(0x3c2405d4,0x109);
	reg32_write(0x3c2405d8,0x8);
	reg32_write(0x3c2405dc,0x618);
	reg32_write(0x3c2405e0,0x109);
	reg32_write(0x3c2405e4,0x8);
	reg32_write(0x3c2405e8,0xe0);
	reg32_write(0x3c2405ec,0x109);
	reg32_write(0x3c2405f0,0x0);
	reg32_write(0x3c2405f4,0x7c8);
	reg32_write(0x3c2405f8,0x109);
	reg32_write(0x3c2405fc,0x8);
	reg32_write(0x3c240600,0x8140);
	reg32_write(0x3c240604,0x10c);
	reg32_write(0x3c240608,0x0);
	reg32_write(0x3c24060c,0x1);
	reg32_write(0x3c240610,0x8);
	reg32_write(0x3c240614,0x8);
	reg32_write(0x3c240618,0x4);
	reg32_write(0x3c24061c,0x8);
	reg32_write(0x3c240620,0x8);
	reg32_write(0x3c240624,0x7c8);
	reg32_write(0x3c240628,0x101);
	reg32_write(0x3c240018,0x0);
	reg32_write(0x3c24001c,0x0);
	reg32_write(0x3c240020,0x8);
	reg32_write(0x3c240024,0x0);
	reg32_write(0x3c240028,0x0);
	reg32_write(0x3c24002c,0x0);
	reg32_write(0x3c34039c,0x400);
	reg32_write(0x3c24005c,0x0);
	reg32_write(0x3c24007c,0x2a);
	reg32_write(0x3c240098,0x6a);
	reg32_write(0x3c100340,0x0);
	reg32_write(0x3c100344,0x101);
	reg32_write(0x3c100348,0x105);
	reg32_write(0x3c10034c,0x107);
	reg32_write(0x3c100350,0x10f);
	reg32_write(0x3c100354,0x202);
	reg32_write(0x3c100358,0x20a);
	reg32_write(0x3c10035c,0x20b);
	reg32_write(0x3c0800e8,0x2);
	reg32_write(0x3c08002c,0x65);
	reg32_write(0x3c080030,0xc9);
	reg32_write(0x3c080034,0x7d1);
	reg32_write(0x3c080038,0x2c);
	reg32_write(0x3c48002c,0x65);
	reg32_write(0x3c480030,0xc9);
	reg32_write(0x3c480034,0x7d1);
	reg32_write(0x3c480038,0x2c);
	reg32_write(0x3c240030,0x0);
	reg32_write(0x3c240034,0x173);
	reg32_write(0x3c240038,0x60);
	reg32_write(0x3c24003c,0x6110);
	reg32_write(0x3c240040,0x2152);
	reg32_write(0x3c240044,0xdfbd);
	reg32_write(0x3c240048,0x60);
	reg32_write(0x3c24004c,0x6152);
	reg32_write(0x3c080040,0x5a);
	reg32_write(0x3c080044,0x3);
	reg32_write(0x3c480040,0x5a);
	reg32_write(0x3c480044,0x3);
	reg32_write(0x3c100200,0xe0);
	reg32_write(0x3c100204,0x12);
	reg32_write(0x3c100208,0xe0);
	reg32_write(0x3c10020c,0x12);
	reg32_write(0x3c100210,0xe0);
	reg32_write(0x3c100214,0x12);
	reg32_write(0x3c500200,0xe0);
	reg32_write(0x3c500204,0x12);
	reg32_write(0x3c500208,0xe0);
	reg32_write(0x3c50020c,0x12);
	reg32_write(0x3c500210,0xe0);
	reg32_write(0x3c500214,0x12);
	reg32_write(0x3c1003f4,0xf);
	reg32_write(0x3c040044,0x1);
	reg32_write(0x3c040048,0x1);
	reg32_write(0x3c04004c,0x180);
	reg32_write(0x3c040060,0x1);
	reg32_write(0x3c040008,0x6209);
	reg32_write(0x3c0402c8,0x1);
	reg32_write(0x3c0406d0,0x1);
	reg32_write(0x3c040ad0,0x1);
	reg32_write(0x3c040ed0,0x1);
	reg32_write(0x3c0412d0,0x1);
	reg32_write(0x3c0416d0,0x1);
	reg32_write(0x3c041ad0,0x1);
	reg32_write(0x3c041ed0,0x1);
	reg32_write(0x3c0422d0,0x1);
	reg32_write(0x3c044044,0x1);
	reg32_write(0x3c044048,0x1);
	reg32_write(0x3c04404c,0x180);
	reg32_write(0x3c044060,0x1);
	reg32_write(0x3c044008,0x6209);
	reg32_write(0x3c0442c8,0x1);
	reg32_write(0x3c0446d0,0x1);
	reg32_write(0x3c044ad0,0x1);
	reg32_write(0x3c044ed0,0x1);
	reg32_write(0x3c0452d0,0x1);
	reg32_write(0x3c0456d0,0x1);
	reg32_write(0x3c045ad0,0x1);
	reg32_write(0x3c045ed0,0x1);
	reg32_write(0x3c0462d0,0x1);
	reg32_write(0x3c048044,0x1);
	reg32_write(0x3c048048,0x1);
	reg32_write(0x3c04804c,0x180);
	reg32_write(0x3c048060,0x1);
	reg32_write(0x3c048008,0x6209);
	reg32_write(0x3c0482c8,0x1);
	reg32_write(0x3c0486d0,0x1);
	reg32_write(0x3c048ad0,0x1);
	reg32_write(0x3c048ed0,0x1);
	reg32_write(0x3c0492d0,0x1);
	reg32_write(0x3c0496d0,0x1);
	reg32_write(0x3c049ad0,0x1);
	reg32_write(0x3c049ed0,0x1);
	reg32_write(0x3c04a2d0,0x1);
	reg32_write(0x3c04c044,0x1);
	reg32_write(0x3c04c048,0x1);
	reg32_write(0x3c04c04c,0x180);
	reg32_write(0x3c04c060,0x1);
	reg32_write(0x3c04c008,0x6209);
	reg32_write(0x3c04c2c8,0x1);
	reg32_write(0x3c04c6d0,0x1);
	reg32_write(0x3c04cad0,0x1);
	reg32_write(0x3c04ced0,0x1);
	reg32_write(0x3c04d2d0,0x1);
	reg32_write(0x3c04d6d0,0x1);
	reg32_write(0x3c04dad0,0x1);
	reg32_write(0x3c04ded0,0x1);
	reg32_write(0x3c04e2d0,0x1);
	reg32_write(0x3c0800e8,0x2);
	reg32_write(0x3c300200,0x2);
	//customer Post Train
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x00020010, 0x0000006a);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x0002001d, 0x00000001);
	/*
	 * CalBusy.0 =1, indicates the calibrator is actively calibrating.
	 * Wait Calibrating done.
	 */
	tmp_t = 1;
	while(tmp_t) {
		tmp = reg32_read(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x20097);
		tmp_t = tmp & 0x01;
	}
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x0);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x2006e, 0x0);
	//disable APB bus to access DDRPHY RAM
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x1);
}

void ddr_pll_bypass_100mts(void) {
	/* change the clock source of dram_alt_clk_root to source 2 --100MHz */
	reg32_write(CCM_IP_CLK_ROOT_GEN_TAGET_CLR(0),(0x7<<24)|(0x7<<16));
	reg32_write(CCM_IP_CLK_ROOT_GEN_TAGET_SET(0),(0x2<<24));

	/* change the clock source of dram_apb_clk_root to source 2 --40MHz */
	reg32_write(CCM_IP_CLK_ROOT_GEN_TAGET_CLR(1),(0x7<<24)|(0x7<<16));
	reg32_write(CCM_IP_CLK_ROOT_GEN_TAGET_SET(1),(0x2<<24)|(0x1<<16));

	/* disable the clock gating */
	reg32_write(0x303A00EC,0x0000ffff); /* PGC_CPU_MAPPING */
	reg32setbit(0x303A00F8,5);          /* PU_PGC_SW_PUP_REQ */

	/* configure pll bypass mode */
	reg32_write(0x30389804, 1<<24);

	printf("PLL bypass to 100MTS setting done \n");
}

void ddr_pll_bypass_400mts(void) {
    /* change the clock source of dram_alt_clk_root to source 2 --400MHz */
    reg32_write(CCM_IP_CLK_ROOT_GEN_TAGET_CLR(0),(0x7<<24)|(0x7<<16));
    reg32_write(CCM_IP_CLK_ROOT_GEN_TAGET_SET(0),(0x5<<24));

    /* change the clock source of dram_apb_clk_root to source 2 --40MHz/2 */
    reg32_write(CCM_IP_CLK_ROOT_GEN_TAGET_CLR(1),(0x7<<24)|(0x7<<16));
    reg32_write(CCM_IP_CLK_ROOT_GEN_TAGET_SET(1),(0x2<<24)|(0x1<<16));

    /* disable the clock gating */
    reg32_write(0x303A00EC,0x0000ffff); /* PGC_CPU_MAPPING */
    reg32setbit(0x303A00F8,5);          /* PU_PGC_SW_PUP_REQ */

    /* configure pll bypass mode */
    reg32_write(0x30389804, 1<<24);

    printf("PLL bypass to 400MTS setting done \n");
}


void dwc_ddrphy_phyinit_userCustom_E_setDfiClk(int pstate)
{
	if (pstate == 2)
		ddr_pll_bypass_100mts();
	else if (pstate == 1)
		ddr_pll_bypass_400mts();
	else {
		reg32_write(CCM_IP_CLK_ROOT_GEN_TAGET_CLR(1), (0x7 << 24) | (0x7 << 16));
		reg32_write(CCM_IP_CLK_ROOT_GEN_TAGET_SET(1), (0x4 << 24) | (0x3 << 16));
		reg32_write(0x30389808, 1 << 24);
	}
}

void lpddr4_800M_cfg_phy(void) {
	unsigned int tmp, tmp_t;

	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x20110, 0x02);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x20111, 0x03);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x20112, 0x04);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x20113, 0x05);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x20114, 0x00);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x20115, 0x01);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x1005f, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x1015f, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x1105f, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x1115f, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x1205f, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x1215f, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x1305f, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x1315f, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x11005f, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x11015f, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x11105f, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x11115f, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x11205f, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x11215f, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x11305f, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x11315f, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x21005f, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x21015f, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x21105f, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x21115f, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x21205f, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x21215f, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x21305f, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x21315f, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x55, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x1055, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x2055, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x3055, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4055, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5055, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x6055, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x7055, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x8055, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9055, 0x1ff);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x200c5, 0x19);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x1200c5, 0x7);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x2200c5, 0x7);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x2002e, 0x2);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x12002e, 0x2);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x22002e, 0x2);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90204, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x190204, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x290204, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x20024, 0xab);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x2003a, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x120024, 0xab);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x2003a, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x220024, 0xab);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x2003a, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x20056, 0x3);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x120056, 0xa);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x220056, 0xa);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x1004d, 0xe00);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x1014d, 0xe00);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x1104d, 0xe00);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x1114d, 0xe00);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x1204d, 0xe00);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x1214d, 0xe00);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x1304d, 0xe00);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x1314d, 0xe00);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x11004d, 0xe00);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x11014d, 0xe00);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x11104d, 0xe00);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x11114d, 0xe00);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x11204d, 0xe00);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x11214d, 0xe00);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x11304d, 0xe00);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x11314d, 0xe00);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x21004d, 0xe00);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x21014d, 0xe00);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x21104d, 0xe00);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x21114d, 0xe00);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x21204d, 0xe00);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x21214d, 0xe00);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x21304d, 0xe00);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x21314d, 0xe00);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x10049, 0xe38);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x10149, 0xe38);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x11049, 0xe38);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x11149, 0xe38);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x12049, 0xe38);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x12149, 0xe38);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x13049, 0xe38);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x13149, 0xe38);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x110049, 0xe38);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x110149, 0xe38);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x111049, 0xe38);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x111149, 0xe38);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x112049, 0xe38);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x112149, 0xe38);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x113049, 0xe38);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x113149, 0xe38);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x210049, 0xe38);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x210149, 0xe38);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x211049, 0xe38);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x211149, 0xe38);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x212049, 0xe38);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x212149, 0xe38);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x213049, 0xe38);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x213149, 0xe38);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x43, 0x21);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x1043, 0x21);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x2043, 0x21);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x3043, 0x21);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4043, 0x21);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5043, 0x21);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x6043, 0x21);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x7043, 0x21);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x8043, 0x21);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9043, 0x21);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x20018, 0x3);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x20075, 0x4);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x20050, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x20008, 0x320);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x120008, 0x64);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x220008, 0x19);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x20088, 0x9);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x200b2, 0x19c);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x10043, 0x5a1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x10143, 0x5a1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x11043, 0x5a1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x11143, 0x5a1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x12043, 0x5a1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x12143, 0x5a1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x13043, 0x5a1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x13143, 0x5a1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x1200b2, 0x19c);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x110043, 0x5a1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x110143, 0x5a1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x111043, 0x5a1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x111143, 0x5a1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x112043, 0x5a1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x112143, 0x5a1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x113043, 0x5a1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x113143, 0x5a1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x2200b2, 0x19c);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x210043, 0x5a1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x210143, 0x5a1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x211043, 0x5a1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x211143, 0x5a1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x212043, 0x5a1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x212143, 0x5a1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x213043, 0x5a1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x213143, 0x5a1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x200fa, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x1200fa, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x2200fa, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x20019, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x120019, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x220019, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x200f0, 0x660);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x200f1, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x200f2, 0x4444);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x200f3, 0x8888);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x200f4, 0x5555);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x200f5, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x200f6, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x200f7, 0xf000);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x2000b, 0x65);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x2000c, 0xc9);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x2000d, 0x7d1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x2000e, 0x2c);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x12000b, 0xd);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x12000c, 0x1a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x12000d, 0xfb);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x12000e, 0x10);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x22000b, 0x4);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x22000c, 0x7);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x22000d, 0x3f);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x22000e, 0x10);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x20025, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x2002d, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x12002d, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x22002d, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x20060, 0x2);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x0);
	/* load the 1D training image */
	ddr_load_train_code(FW_1D_IMAGE);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x1);

	/* set the PHY input clock to the desired frequency for pstate 2 */
	dwc_ddrphy_phyinit_userCustom_E_setDfiClk(2);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54000,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54001,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54002,0x102);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54003,0x64);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54004,0x2);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54005,0x2828);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54006,0x14);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54007,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54008,0x121f);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54009,0xc8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5400a,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5400b,0x2);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5400c,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5400d,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5400e,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5400f,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54010,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54011,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54012,0x310);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54013,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54014,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54015,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54016,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54017,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54018,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54019,0x4);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401a,0x31);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401b,0x4d46);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401c,0x4d08);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401d,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401e,0x5);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401f,0x4);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54020,0x31);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54021,0x4d46);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54022,0x4d08);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54023,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54024,0x5);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54025,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54026,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54027,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54028,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54029,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5402a,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5402b,0x1000);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5402c,0x3);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5402d,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5402e,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5402f,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54030,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54031,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54032,0x400);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54033,0x3100);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54034,0x4600);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54035,0x84d);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54036,0x4d);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54037,0x500);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54038,0x400);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54039,0x3100);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5403a,0x4600);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5403b,0x84d);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5403c, 0x4d);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5403d, 0x500);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099, 0x9);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099, 0x0);
extern void wait_ddrphy_training_complete(void);
	wait_ddrphy_training_complete();
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x1);

	/* set the PHY input clock to the desired frequency for pstate 1 */
	dwc_ddrphy_phyinit_userCustom_E_setDfiClk(1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54000,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54001,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54002,0x101);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54003,0x190);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54004,0x2);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54005,0x2828);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54006,0x14);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54007,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54008,0x121f);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54009,0xc8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5400a,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5400b,0x2);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5400c,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5400d,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5400e,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5400f,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54010,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54011,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54012,0x310);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54013,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54014,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54015,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54016,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54017,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54018,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54019,0x4);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401a,0x31);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401b,0x4d46);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401c,0x4d08);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401d,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401e,0x5);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401f,0x4);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54020,0x31);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54021,0x4d46);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54022,0x4d08);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54023,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54024,0x5);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54025,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54026,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54027,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54028,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54029,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5402a,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5402b,0x1000);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5402c,0x3);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5402d,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5402e,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5402f,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54030,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54031,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54032,0x400);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54033,0x3100);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54034,0x4600);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54035,0x84d);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54036,0x4d);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54037,0x500);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54038,0x400);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54039,0x3100);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5403a,0x4600);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5403b,0x84d);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5403c,0x4d);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5403d,0x500);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099, 0x9);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099, 0x0);
extern void wait_ddrphy_training_complete(void);
	wait_ddrphy_training_complete();
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x1);

	/* set the PHY input clock to the desired frequency for pstate 0 */
	dwc_ddrphy_phyinit_userCustom_E_setDfiClk(0);

	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54000, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54001, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54002, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54003, 0xc80);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54004, 0x2);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54005, 0x2828);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54006, 0x14);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54007, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54008, 0x131f);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54009, 0x5);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5400a, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5400b, 0x2);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5400c, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5400d, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5400e, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5400f, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54010, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54011, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54012, 0x310);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54013, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54014, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54015, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54016, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54017, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54018, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54019, 0x2dd4);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401a, 0x31);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401b, 0x4d46);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401c, 0x4d08);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401d, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401e, 0x5);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401f, 0x2dd4);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54020, 0x31);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54021, 0x4d46);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54022, 0x4d08);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54023, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54024, 0x5);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54025, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54026, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54027, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54028, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54029, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5402a, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5402b, 0x1000);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5402c, 0x3);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5402d, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5402e, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5402f, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54030, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54031, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54032, 0xd400);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54033, 0x312d);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54034, 0x4600);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54035, 0x84d);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54036, 0x4d);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54037, 0x500);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54038, 0xd400);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54039, 0x312d);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5403a, 0x4600);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5403b, 0x84d);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5403c, 0x4d);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5403d, 0x500);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099, 0x9);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099, 0x0);
extern void wait_ddrphy_training_complete(void);
wait_ddrphy_training_complete();
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x0);
	/* load the 2D training image */
	ddr_load_train_code(FW_2D_IMAGE);

	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000,0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000,0x0);

	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54000,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54001,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54002,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54003,0xc80);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54004,0x2);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54005,0x2828);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54006,0x14);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54007,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54008,0x61);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54009,0xc8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5400a,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5400b,0x2);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5400c,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5400d,0x100);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5400e,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5400f,0x100);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54010,0x1f7f);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54011,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54012,0x310);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54013,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54014,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54015,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54016,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54017,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54018,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54019,0x2dd4);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401a,0x31);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401b,0x4d46);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401c,0x4d08);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401d,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401e,0x5);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5401f,0x2dd4);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54020,0x31);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54021,0x4d46);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54022,0x4d08);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54023,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54024,0x5);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54025,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54026,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54027,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54028,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54029,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5402a,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5402b,0x1000);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5402c,0x3);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5402d,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5402e,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5402f,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54030,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54031,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54032,0xd400);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54033,0x312d);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54034,0x4600);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54035,0x084d);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54036,0x4d);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54037,0x500);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54038,0xd400);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x54039,0x312d);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5403a,0x4600);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5403b,0x084d);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5403c,0x4d);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x5403d,0x500);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000,0x1);
	/* Execute the Training Firmware */
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000,0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099,0x9);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099,0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099,0x0);
	/* wait for 2D training complete */
	extern void wait_ddrphy_training_complete(void);
	wait_ddrphy_training_complete();

	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0099,0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000,0x1);

	/* (I) Load PHY Init Engine Image */
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000,0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90000, 0x10);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90001, 0x400);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90002, 0x10e);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90003, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90004, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90005, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90029, 0xb);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9002a, 0x480);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9002b, 0x109);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9002c, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9002d, 0x448);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9002e, 0x139);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9002f, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90030, 0x478);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90031, 0x109);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90032, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90033, 0xe8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90034, 0x109);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90035, 0x2);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90036, 0x10);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90037, 0x139);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90038, 0xf);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90039, 0x7c0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9003a, 0x139);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9003b, 0x44);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9003c, 0x630);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9003d, 0x159);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9003e, 0x14f);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9003f, 0x630);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90040, 0x159);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90041, 0x47);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90042, 0x630);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90043, 0x149);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90044, 0x4f);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90045, 0x630);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90046, 0x179);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90047, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90048, 0xe0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90049, 0x109);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9004a, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9004b, 0x7c8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9004c, 0x109);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9004d, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9004e, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9004f, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90050, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90051, 0x45a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90052, 0x9);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90053, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90054, 0x448);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90055, 0x109);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90056, 0x40);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90057, 0x630);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90058, 0x179);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90059, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9005a, 0x618);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9005b, 0x109);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9005c, 0x40c0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9005d, 0x630);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9005e, 0x149);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9005f, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90060, 0x4);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90061, 0x48);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90062, 0x4040);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90063, 0x630);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90064, 0x149);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90065, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90066, 0x4);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90067, 0x48);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90068, 0x40);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90069, 0x630);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9006a, 0x149);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9006b, 0x10);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9006c, 0x4);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9006d, 0x18);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9006e, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9006f, 0x4);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90070, 0x78);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90071, 0x549);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90072, 0x630);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90073, 0x159);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90074, 0xd49);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90075, 0x630);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90076, 0x159);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90077, 0x94a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90078, 0x630);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90079, 0x159);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9007a, 0x441);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9007b, 0x630);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9007c, 0x149);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9007d, 0x42);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9007e, 0x630);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9007f, 0x149);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90080, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90081, 0x630);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90082, 0x149);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90083, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90084, 0xe0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90085, 0x109);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90086, 0xa);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90087, 0x10);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90088, 0x109);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90089, 0x9);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9008a, 0x3c0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9008b, 0x149);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9008c, 0x9);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9008d, 0x3c0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9008e, 0x159);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9008f, 0x18);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90090, 0x10);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90091, 0x109);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90092, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90093, 0x3c0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90094, 0x109);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90095, 0x18);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90096, 0x4);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90097, 0x48);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90098, 0x18);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90099, 0x4);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9009a, 0x58);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9009b, 0xa);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9009c, 0x10);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9009d, 0x109);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9009e, 0x2);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9009f, 0x10);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900a0, 0x109);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900a1, 0x5);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900a2, 0x7c0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900a3, 0x109);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900a4, 0x10);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900a5, 0x10);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900a6, 0x109);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40000, 0x811);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40020, 0x880);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40040, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40060, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40001, 0x4016);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40021, 0x83);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40041, 0x4f);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40061, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40002, 0x4040);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40022, 0x83);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40042, 0x51);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40062, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40003, 0x811);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40023, 0x880);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40043, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40063, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40004, 0x720);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40024, 0xf);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40044, 0x1740);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40064, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40005, 0x16);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40025, 0x83);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40045, 0x4b);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40065, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40006, 0x716);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40026, 0xf);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40046, 0x2001);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40066, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40007, 0x716);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40027, 0xf);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40047, 0x2800);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40067, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40008, 0x716);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40028, 0xf);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40048, 0xf00);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40068, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40009, 0x720);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40029, 0xf);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40049, 0x1400);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40069, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4000a, 0xe08);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4002a, 0xc15);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4004a, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4006a, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4000b, 0x623);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4002b, 0x15);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4004b, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4006b, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4000c, 0x4004);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4002c, 0x80);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4004c, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4006c, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4000d, 0xe08);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4002d, 0xc1a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4004d, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4006d, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4000e, 0x623);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4002e, 0x1a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4004e, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4006e, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4000f, 0x4040);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4002f, 0x80);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4004f, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4006f, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40010, 0x2604);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40030, 0x15);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40050, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40070, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40011, 0x708);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40031, 0x5);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40051, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40071, 0x2002);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40012, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40032, 0x80);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40052, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40072, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40013, 0x2604);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40033, 0x1a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40053, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40073, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40014, 0x708);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40034, 0xa);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40054, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40074, 0x2002);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40015, 0x4040);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40035, 0x80);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40055, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40075, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40016, 0x60a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40036, 0x15);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40056, 0x1200);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40076, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40017, 0x61a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40037, 0x15);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40057, 0x1300);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40077, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40018, 0x60a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40038, 0x1a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40058, 0x1200);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40078, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40019, 0x642);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40039, 0x1a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40059, 0x1300);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40079, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4001a, 0x4808);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4003a, 0x880);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4005a, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x4007a, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900a7, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900a8, 0x790);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900a9, 0x11a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900aa, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900ab, 0x7aa);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900ac, 0x2a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900ad, 0x10);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900ae, 0x7b2);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900af, 0x2a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900b0, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900b1, 0x7c8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900b2, 0x109);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900b3, 0x10);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900b4, 0x2a8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900b5, 0x129);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900b6, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900b7, 0x370);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900b8, 0x129);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900b9, 0xa);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900ba, 0x3c8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900bb, 0x1a9);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900bc, 0xc);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900bd, 0x408);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900be, 0x199);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900bf, 0x14);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900c0, 0x790);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900c1, 0x11a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900c2, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900c3, 0x4);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900c4, 0x18);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900c5, 0xc);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900c6, 0x408);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900c7, 0x199);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900c8, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900c9, 0x8568);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900ca, 0x108);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900cb, 0x18);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900cc, 0x790);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900cd, 0x16a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900ce, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900cf, 0x1d8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900d0, 0x169);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900d1, 0x10);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900d2, 0x8558);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900d3, 0x168);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900d4, 0x70);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900d5, 0x788);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900d6, 0x16a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900d7, 0x1ff8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900d8, 0x85a8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900d9, 0x1e8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900da, 0x50);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900db, 0x798);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900dc, 0x16a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900dd, 0x60);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900de, 0x7a0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900df, 0x16a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900e0, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900e1, 0x8310);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900e2, 0x168);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900e3, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900e4, 0xa310);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900e5, 0x168);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900e6, 0xa);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900e7, 0x408);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900e8, 0x169);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900e9, 0x6e);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900ea, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900eb, 0x68);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900ec, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900ed, 0x408);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900ee, 0x169);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900ef, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900f0, 0x8310);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900f1, 0x168);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900f2, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900f3, 0xa310);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900f4, 0x168);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900f5, 0x1ff8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900f6, 0x85a8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900f7, 0x1e8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900f8, 0x68);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900f9, 0x798);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900fa, 0x16a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900fb, 0x78);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900fc, 0x7a0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900fd, 0x16a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900fe, 0x68);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x900ff, 0x790);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90100, 0x16a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90101, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90102, 0x8b10);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90103, 0x168);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90104, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90105, 0xab10);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90106, 0x168);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90107, 0xa);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90108, 0x408);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90109, 0x169);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9010a, 0x58);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9010b, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9010c, 0x68);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9010d, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9010e, 0x408);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9010f, 0x169);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90110, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90111, 0x8b10);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90112, 0x168);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90113, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90114, 0xab10);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90115, 0x168);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90116, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90117, 0x1d8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90118, 0x169);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90119, 0x80);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9011a, 0x790);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9011b, 0x16a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9011c, 0x18);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9011d, 0x7aa);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9011e, 0x6a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9011f, 0xa);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90120, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90121, 0x1e9);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90122, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90123, 0x8080);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90124, 0x108);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90125, 0xf);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90126, 0x408);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90127, 0x169);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90128, 0xc);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90129, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9012a, 0x68);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9012b, 0x9);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9012c, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9012d, 0x1a9);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9012e, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9012f, 0x408);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90130, 0x169);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90131, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90132, 0x8080);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90133, 0x108);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90134, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90135, 0x7aa);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90136, 0x6a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90137, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90138, 0x8568);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90139, 0x108);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9013a, 0xb7);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9013b, 0x790);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9013c, 0x16a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9013d, 0x1d);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9013e, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9013f, 0x68);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90140, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90141, 0x8558);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90142, 0x168);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90143, 0xf);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90144, 0x408);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90145, 0x169);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90146, 0xc);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90147, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90148, 0x68);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90149, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9014a, 0x408);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9014b, 0x169);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9014c, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9014d, 0x8558);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9014e, 0x168);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9014f, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90150, 0x3c8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90151, 0x1a9);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90152, 0x3);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90153, 0x370);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90154, 0x129);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90155, 0x20);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90156, 0x2aa);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90157, 0x9);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90158, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90159, 0x400);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9015a, 0x10e);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9015b, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9015c, 0xe8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9015d, 0x109);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9015e, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9015f, 0x8140);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90160, 0x10c);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90161, 0x10);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90162, 0x8138);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90163, 0x10c);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90164, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90165, 0x7c8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90166, 0x101);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90167, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90168, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90169, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9016a, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9016b, 0x448);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9016c, 0x109);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9016d, 0xf);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9016e, 0x7c0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9016f, 0x109);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90170, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90171, 0xe8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90172, 0x109);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90173, 0x47);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90174, 0x630);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90175, 0x109);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90176, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90177, 0x618);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90178, 0x109);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90179, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9017a, 0xe0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9017b, 0x109);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9017c, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9017d, 0x7c8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9017e, 0x109);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9017f, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90180, 0x8140);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90181, 0x10c);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90182, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90183, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90184, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90185, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90186, 0x4);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90187, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90188, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90189, 0x7c8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9018a, 0x101);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90006, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90007, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90008, 0x8);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90009, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9000a, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9000b, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd00e7, 0x400);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90017, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9001f, 0x2a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90026, 0x6a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x400d0, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x400d1, 0x101);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x400d2, 0x105);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x400d3, 0x107);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x400d4, 0x10f);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x400d5, 0x202);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x400d6, 0x20a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x400d7, 0x20b);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x2003a, 0x2);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9000c, 0x0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9000d, 0x173);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9000e, 0x60);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x9000f, 0x6110);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90010, 0x2152);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90011, 0xdfbd);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90012, 0x60);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x90013, 0x6152);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x20010, 0x5a);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x20011, 0x3);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40080, 0xe0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40081, 0x12);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40082, 0xe0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40083, 0x12);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40084, 0xe0);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x40085, 0x12);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x400fd, 0xf);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x10011, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x10012, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x10013, 0x180);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x10018, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x10002, 0x6209);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x100b2, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x101b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x102b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x103b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x104b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x105b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x106b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x107b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x108b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x11011, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x11012, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x11013, 0x180);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x11018, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x11002, 0x6209);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x110b2, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x111b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x112b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x113b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x114b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x115b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x116b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x117b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x118b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x12011, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x12012, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x12013, 0x180);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x12018, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x12002, 0x6209);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x120b2, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x121b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x122b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x123b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x124b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x125b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x126b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x127b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x128b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x13011, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x13012, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x13013, 0x180);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x13018, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x13002, 0x6209);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x130b2, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x131b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x132b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x133b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x134b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x135b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x136b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x137b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x138b4, 0x1);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x2003a, 0x2);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xc0080, 0x2);
	dwc_ddrphy_apb_wr(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x1);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x000d0000, 0x00000000);
	tmp = reg32_read(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x00020010);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x00020010, 0x0000006a);
	tmp = reg32_read(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x0002001d);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x0002001d, 0x00000001);
	/*
	 * CalBusy.0 =1, indicates the calibrator is actively calibrating.
	 * Wait Calibrating done.
	 */
	tmp_t = 1;
	while(tmp_t) {
		tmp = reg32_read(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x20097);
		tmp_t = tmp & 0x01;
	}
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0xd0000, 0x0);
	reg32_write(IP2APB_DDRPHY_IPS_BASE_ADDR(0) + 4 * 0x2006e, 0x0);
}
