/*
 * Copyright 2017 NXP
 *
 * NXP i.MX8 USB HOST xHCI Controller (Cadence IP) Register Definition
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#ifndef _IMX8_USB3_H_
#define _IMX8_USB3_H_

#define REG32(m)	(m)

#define USB3_REGS_BASE	0x5B110000
#define USB3_CTRL_BASE (USB3_REGS_BASE + 0x00000)
#define USB3_CORE_BASE (USB3_REGS_BASE + 0x10000)
#define USB3_PHY_BASE (USB3_REGS_BASE + 0x50000)
/* PHY registers */
#define PHY_PMA_CMN_CTRL1			(USB3_PHY_BASE + 0xC800 * 4)
#define TB_ADDR_CMN_DIAG_HSCLK_SEL		(USB3_PHY_BASE + 0x01e0 * 4)
#define TB_ADDR_CMN_PLL0_VCOCAL_INIT_TMR	(USB3_PHY_BASE + 0x0084 * 4)
#define TB_ADDR_CMN_PLL0_VCOCAL_ITER_TMR	(USB3_PHY_BASE + 0x0085 * 4)
#define TB_ADDR_CMN_PLL0_INTDIV	                (USB3_PHY_BASE + 0x0094 * 4)
#define TB_ADDR_CMN_PLL0_FRACDIV		(USB3_PHY_BASE + 0x0095 * 4)
#define TB_ADDR_CMN_PLL0_HIGH_THR		(USB3_PHY_BASE + 0x0096 * 4)
#define TB_ADDR_CMN_PLL0_SS_CTRL1		(USB3_PHY_BASE + 0x0098 * 4)
#define TB_ADDR_CMN_PLL0_SS_CTRL2		(USB3_PHY_BASE + 0x0099 * 4)
#define TB_ADDR_CMN_PLL0_DSM_DIAG		(USB3_PHY_BASE + 0x0097 * 4)
#define TB_ADDR_CMN_DIAG_PLL0_OVRD		(USB3_PHY_BASE + 0x01c2 * 4)
#define TB_ADDR_CMN_DIAG_PLL0_FBH_OVRD		(USB3_PHY_BASE + 0x01c0 * 4)
#define TB_ADDR_CMN_DIAG_PLL0_FBL_OVRD		(USB3_PHY_BASE + 0x01c1 * 4)
#define TB_ADDR_CMN_DIAG_PLL0_V2I_TUNE          (USB3_PHY_BASE + 0x01C5 * 4)
#define TB_ADDR_CMN_DIAG_PLL0_CP_TUNE           (USB3_PHY_BASE + 0x01C6 * 4)
#define TB_ADDR_CMN_DIAG_PLL0_LF_PROG           (USB3_PHY_BASE + 0x01C7 * 4)
#define TB_ADDR_CMN_DIAG_PLL0_TEST_MODE		(USB3_PHY_BASE + 0x01c4 * 4)
#define TB_ADDR_CMN_PSM_CLK_CTRL		(USB3_PHY_BASE + 0x0061 * 4)
#define TB_ADDR_XCVR_DIAG_RX_LANE_CAL_RST_TMR	(USB3_PHY_BASE + 0x40ea * 4)
#define TB_ADDR_XCVR_PSM_RCTRL	                (USB3_PHY_BASE + 0x4001 * 4)
#define TB_ADDR_TX_PSC_A0		        (USB3_PHY_BASE + 0x4100 * 4)
#define TB_ADDR_TX_PSC_A1		        (USB3_PHY_BASE + 0x4101 * 4)
#define TB_ADDR_TX_PSC_A2		        (USB3_PHY_BASE + 0x4102 * 4)
#define TB_ADDR_TX_PSC_A3		        (USB3_PHY_BASE + 0x4103 * 4)
#define TB_ADDR_TX_DIAG_ECTRL_OVRD		(USB3_PHY_BASE + 0x41f5 * 4)
#define TB_ADDR_TX_PSC_CAL		        (USB3_PHY_BASE + 0x4106 * 4)
#define TB_ADDR_TX_PSC_RDY		        (USB3_PHY_BASE + 0x4107 * 4)
#define TB_ADDR_RX_PSC_A0	                (USB3_PHY_BASE + 0x8000 * 4)
#define TB_ADDR_RX_PSC_A1	                (USB3_PHY_BASE + 0x8001 * 4)
#define TB_ADDR_RX_PSC_A2	                (USB3_PHY_BASE + 0x8002 * 4)
#define TB_ADDR_RX_PSC_A3	                (USB3_PHY_BASE + 0x8003 * 4)
#define TB_ADDR_RX_PSC_CAL	                (USB3_PHY_BASE + 0x8006 * 4)
#define TB_ADDR_RX_PSC_RDY	                (USB3_PHY_BASE + 0x8007 * 4)
#define TB_ADDR_TX_TXCC_MGNLS_MULT_000		(USB3_PHY_BASE + 0x4058 * 4)
#define TB_ADDR_TX_DIAG_BGREF_PREDRV_DELAY	(USB3_PHY_BASE + 0x41e7 * 4)
#define TB_ADDR_RX_SLC_CU_ITER_TMR		(USB3_PHY_BASE + 0x80e3 * 4)
#define TB_ADDR_RX_SIGDET_HL_FILT_TMR		(USB3_PHY_BASE + 0x8090 * 4)
#define TB_ADDR_RX_SAMP_DAC_CTRL		(USB3_PHY_BASE + 0x8058 * 4)
#define TB_ADDR_RX_DIAG_SIGDET_TUNE		(USB3_PHY_BASE + 0x81dc * 4)
#define TB_ADDR_RX_DIAG_LFPSDET_TUNE2		(USB3_PHY_BASE + 0x81df * 4)
#define TB_ADDR_RX_DIAG_BS_TM	                (USB3_PHY_BASE + 0x81f5 * 4)
#define TB_ADDR_RX_DIAG_DFE_CTRL1		(USB3_PHY_BASE + 0x81d3 * 4)
#define TB_ADDR_RX_DIAG_ILL_IQE_TRIM4		(USB3_PHY_BASE + 0x81c7 * 4)
#define TB_ADDR_RX_DIAG_ILL_E_TRIM0		(USB3_PHY_BASE + 0x81c2 * 4)
#define TB_ADDR_RX_DIAG_ILL_IQ_TRIM0		(USB3_PHY_BASE + 0x81c1 * 4)
#define TB_ADDR_RX_DIAG_ILL_IQE_TRIM6		(USB3_PHY_BASE + 0x81c9 * 4)
#define TB_ADDR_RX_DIAG_RXFE_TM3		(USB3_PHY_BASE + 0x81f8 * 4)
#define TB_ADDR_RX_DIAG_RXFE_TM4		(USB3_PHY_BASE + 0x81f9 * 4)
#define TB_ADDR_RX_DIAG_LFPSDET_TUNE		(USB3_PHY_BASE + 0x81dd * 4)
#define TB_ADDR_RX_DIAG_DFE_CTRL3		(USB3_PHY_BASE + 0x81d5 * 4)
#define TB_ADDR_RX_DIAG_SC2C_DELAY		(USB3_PHY_BASE + 0x81e1 * 4)
#define TB_ADDR_RX_REE_VGA_GAIN_NODFE		(USB3_PHY_BASE + 0x81bf * 4)
#define TB_ADDR_XCVR_PSM_CAL_TMR		(USB3_PHY_BASE + 0x4002 * 4)
#define TB_ADDR_XCVR_PSM_A0BYP_TMR		(USB3_PHY_BASE + 0x4004 * 4)
#define TB_ADDR_XCVR_PSM_A0IN_TMR		(USB3_PHY_BASE + 0x4003 * 4)
#define TB_ADDR_XCVR_PSM_A1IN_TMR		(USB3_PHY_BASE + 0x4005 * 4)
#define TB_ADDR_XCVR_PSM_A2IN_TMR		(USB3_PHY_BASE + 0x4006 * 4)
#define TB_ADDR_XCVR_PSM_A3IN_TMR		(USB3_PHY_BASE + 0x4007 * 4)
#define TB_ADDR_XCVR_PSM_A4IN_TMR		(USB3_PHY_BASE + 0x4008 * 4)
#define TB_ADDR_XCVR_PSM_A5IN_TMR		(USB3_PHY_BASE + 0x4009 * 4)
#define TB_ADDR_XCVR_PSM_A0OUT_TMR		(USB3_PHY_BASE + 0x400a * 4)
#define TB_ADDR_XCVR_PSM_A1OUT_TMR		(USB3_PHY_BASE + 0x400b * 4)
#define TB_ADDR_XCVR_PSM_A2OUT_TMR		(USB3_PHY_BASE + 0x400c * 4)
#define TB_ADDR_XCVR_PSM_A3OUT_TMR		(USB3_PHY_BASE + 0x400d * 4)
#define TB_ADDR_XCVR_PSM_A4OUT_TMR		(USB3_PHY_BASE + 0x400e * 4)
#define TB_ADDR_XCVR_PSM_A5OUT_TMR		(USB3_PHY_BASE + 0x400f * 4)
#define TB_ADDR_TX_RCVDET_EN_TMR	        (USB3_PHY_BASE + 0x4122 * 4)
#define TB_ADDR_TX_RCVDET_ST_TMR	        (USB3_PHY_BASE + 0x4123 * 4)
#define TB_ADDR_XCVR_DIAG_LANE_FCM_EN_MGN_TMR	(USB3_PHY_BASE + 0x40f2 * 4)


/* Host registers */
#define HCIVERSION_CAPLENGTH                  (USB3_CORE_BASE + 0x10000)
#define HCSPARAMS1                            (USB3_CORE_BASE + 0x10004)
#define HCSPARAMS2                            (USB3_CORE_BASE + 0x10008)
#define HCSPARAMS3                            (USB3_CORE_BASE + 0x1000c)
#define HCCPARAMS                             (USB3_CORE_BASE + 0x10010)
#define DBOFF                                 (USB3_CORE_BASE + 0x10014)
#define RTSOFF                                (USB3_CORE_BASE + 0x10018)
#define USBCMD                                (USB3_CORE_BASE + 0x10080)
#define USBSTS                                (USB3_CORE_BASE + 0x10084)
#define PAGESIZE                              (USB3_CORE_BASE + 0x10088)
#define DNCTRL                                (USB3_CORE_BASE + 0x10094)
#define CRCR_LO                               (USB3_CORE_BASE + 0x10098)
#define CRCR_HI                               (USB3_CORE_BASE + 0x1009c)
#define DCBAAP_LO                             (USB3_CORE_BASE + 0x100b0)
#define DCBAAP_HI                             (USB3_CORE_BASE + 0x100b4)
#define CONFIG                                (USB3_CORE_BASE + 0x100b8)
#define PORTSC1USB2                           (USB3_CORE_BASE + 0x10480)
#define PORTPMSC1USB2                         (USB3_CORE_BASE + 0x10484)
#define PORT1HLPMC                            (USB3_CORE_BASE + 0x1048c)
#define PORTSC1USB3                           (USB3_CORE_BASE + 0x10490)
#define PORTPMSC1USB3                         (USB3_CORE_BASE + 0x10494)
#define PORTLI1                               (USB3_CORE_BASE + 0x10498)
#define MFINDEX                               (USB3_CORE_BASE + 0x12000)
#define IMAN0                                 (USB3_CORE_BASE + 0x12020)
#define IMOD0                                 (USB3_CORE_BASE + 0x12024)
#define ERSTSZ0                               (USB3_CORE_BASE + 0x12028)
#define XHCI_RESERVED0                        (USB3_CORE_BASE + 0x1202c)
#define ERSTBA0_LO                            (USB3_CORE_BASE + 0x12030)
#define ERSTBA0_HI                            (USB3_CORE_BASE + 0x12034)
#define ERDP0_LO                              (USB3_CORE_BASE + 0x12038)
#define ERDP0_HI                              (USB3_CORE_BASE + 0x1203c)
#define IMAN1                                 (USB3_CORE_BASE + 0x12040)
#define IMOD1                                 (USB3_CORE_BASE + 0x12044)
#define ERSTSZ1                               (USB3_CORE_BASE + 0x12048)
#define XHCI_RESERVED1                        (USB3_CORE_BASE + 0x1204c)
#define ERSTBA1_LO                            (USB3_CORE_BASE + 0x12050)
#define ERSTBA1_HI                            (USB3_CORE_BASE + 0x12054)
#define ERDP1_LO                              (USB3_CORE_BASE + 0x12058)
#define ERDP1_HI                              (USB3_CORE_BASE + 0x1205c)
#define IMAN2                                 (USB3_CORE_BASE + 0x12060)
#define IMOD2                                 (USB3_CORE_BASE + 0x12064)
#define ERSTSZ2                               (USB3_CORE_BASE + 0x12068)
#define XHCI_RESERVED2                        (USB3_CORE_BASE + 0x1206c)
#define ERSTBA2_LO                            (USB3_CORE_BASE + 0x12070)
#define ERSTBA2_HI                            (USB3_CORE_BASE + 0x12074)
#define ERDP2_LO                              (USB3_CORE_BASE + 0x12078)
#define ERDP2_HI                              (USB3_CORE_BASE + 0x1207c)
#define IMAN3                                 (USB3_CORE_BASE + 0x12080)
#define IMOD3                                 (USB3_CORE_BASE + 0x12084)
#define ERSTSZ3                               (USB3_CORE_BASE + 0x12088)
#define XHCI_RESERVED3                        (USB3_CORE_BASE + 0x1208c)
#define ERSTBA3_LO                            (USB3_CORE_BASE + 0x12090)
#define ERSTBA3_HI                            (USB3_CORE_BASE + 0x12094)
#define ERDP3_LO                              (USB3_CORE_BASE + 0x12098)
#define ERDP3_HI                              (USB3_CORE_BASE + 0x1209c)
#define IMAN4                                 (USB3_CORE_BASE + 0x120a0)
#define IMOD4                                 (USB3_CORE_BASE + 0x120a4)
#define ERSTSZ4                               (USB3_CORE_BASE + 0x120a8)
#define XHCI_RESERVED4                        (USB3_CORE_BASE + 0x120ac)
#define ERSTBA4_LO                            (USB3_CORE_BASE + 0x120b0)
#define ERSTBA4_HI                            (USB3_CORE_BASE + 0x120b4)
#define ERDP4_LO                              (USB3_CORE_BASE + 0x120b8)
#define ERDP4_HI                              (USB3_CORE_BASE + 0x120bc)
#define IMAN5                                 (USB3_CORE_BASE + 0x120c0)
#define IMOD5                                 (USB3_CORE_BASE + 0x120c4)
#define ERSTSZ5                               (USB3_CORE_BASE + 0x120c8)
#define XHCI_RESERVED5                        (USB3_CORE_BASE + 0x120cc)
#define ERSTBA5_LO                            (USB3_CORE_BASE + 0x120d0)
#define ERSTBA5_HI                            (USB3_CORE_BASE + 0x120d4)
#define ERDP5_LO                              (USB3_CORE_BASE + 0x120d8)
#define ERDP5_HI                              (USB3_CORE_BASE + 0x120dc)
#define IMAN6                                 (USB3_CORE_BASE + 0x120e0)
#define IMOD6                                 (USB3_CORE_BASE + 0x120e4)
#define ERSTSZ6                               (USB3_CORE_BASE + 0x120e8)
#define XHCI_RESERVED6                        (USB3_CORE_BASE + 0x120ec)
#define ERSTBA6_LO                            (USB3_CORE_BASE + 0x120f0)
#define ERSTBA6_HI                            (USB3_CORE_BASE + 0x120f4)
#define ERDP6_LO                              (USB3_CORE_BASE + 0x120f8)
#define ERDP6_HI                              (USB3_CORE_BASE + 0x120fc)
#define IMAN7                                 (USB3_CORE_BASE + 0x12100)
#define IMOD7                                 (USB3_CORE_BASE + 0x12104)
#define ERSTSZ7                               (USB3_CORE_BASE + 0x12108)
#define XHCI_RESERVED7                        (USB3_CORE_BASE + 0x1210c)
#define ERSTBA7_LO                            (USB3_CORE_BASE + 0x12110)
#define ERSTBA7_HI                            (USB3_CORE_BASE + 0x12114)
#define ERDP7_LO                              (USB3_CORE_BASE + 0x12118)
#define ERDP7_HI                              (USB3_CORE_BASE + 0x1211c)
#define DB0                                   (USB3_CORE_BASE + 0x13000)
#define DB1                                   (USB3_CORE_BASE + 0x13004)
#define DB2                                   (USB3_CORE_BASE + 0x13008)
#define DB3                                   (USB3_CORE_BASE + 0x1300c)
#define DB4                                   (USB3_CORE_BASE + 0x13010)
#define DB5                                   (USB3_CORE_BASE + 0x13014)
#define DB6                                   (USB3_CORE_BASE + 0x13018)
#define DB7                                   (USB3_CORE_BASE + 0x1301c)
#define DB8                                   (USB3_CORE_BASE + 0x13020)
#define DB9                                   (USB3_CORE_BASE + 0x13024)
#define DB10                                  (USB3_CORE_BASE + 0x13028)
#define DB11                                  (USB3_CORE_BASE + 0x1302c)
#define DB12                                  (USB3_CORE_BASE + 0x13030)
#define DB13                                  (USB3_CORE_BASE + 0x13034)
#define DB14                                  (USB3_CORE_BASE + 0x13038)
#define DB15                                  (USB3_CORE_BASE + 0x1303c)
#define DB16                                  (USB3_CORE_BASE + 0x13040)
#define DB17                                  (USB3_CORE_BASE + 0x13044)
#define DB18                                  (USB3_CORE_BASE + 0x13048)
#define DB19                                  (USB3_CORE_BASE + 0x1304c)
#define DB20                                  (USB3_CORE_BASE + 0x13050)
#define DB21                                  (USB3_CORE_BASE + 0x13054)
#define DB22                                  (USB3_CORE_BASE + 0x13058)
#define DB23                                  (USB3_CORE_BASE + 0x1305c)
#define DB24                                  (USB3_CORE_BASE + 0x13060)
#define DB25                                  (USB3_CORE_BASE + 0x13064)
#define DB26                                  (USB3_CORE_BASE + 0x13068)
#define DB27                                  (USB3_CORE_BASE + 0x1306c)
#define DB28                                  (USB3_CORE_BASE + 0x13070)
#define DB29                                  (USB3_CORE_BASE + 0x13074)
#define DB30                                  (USB3_CORE_BASE + 0x13078)
#define DB31                                  (USB3_CORE_BASE + 0x1307c)
#define DB32                                  (USB3_CORE_BASE + 0x13080)
#define XECP_PORT_CAP_REG                     (USB3_CORE_BASE + 0x18000)
#define XECP_PORT_1_REG                       (USB3_CORE_BASE + 0x18004)
#define XECP_CDNS_DEBUG_BUS_CAP               (USB3_CORE_BASE + 0x18008)
#define XECP_CDNS_DEBUG_BUS_CTRL              (USB3_CORE_BASE + 0x1800c)
#define XECP_CDNS_DEBUG_BUS_STATUS            (USB3_CORE_BASE + 0x18010)
#define XECP_PM_CAP                           (USB3_CORE_BASE + 0x18014)
#define XECP_PM_PMCSR                         (USB3_CORE_BASE + 0x18018)
#define XECP_MSI_CAP                          (USB3_CORE_BASE + 0x1801c)
#define XECP_MSI_ADDR_L                       (USB3_CORE_BASE + 0x18020)
#define XECP_MSI_ADDR_H                       (USB3_CORE_BASE + 0x18024)
#define XECP_MSI_DATA                         (USB3_CORE_BASE + 0x18028)
#define XECP_AXI_CAP                          (USB3_CORE_BASE + 0x1802c)
#define XECP_AXI_CFG0                         (USB3_CORE_BASE + 0x18030)
#define XECP_AXI_CTRL0                        (USB3_CORE_BASE + 0x18034)
#define XECP_AXI_CTRL1                        (USB3_CORE_BASE + 0x18038)
#define XECP_AXI_CTRL2                        (USB3_CORE_BASE + 0x1803c)
#define XECP_SUPP_USB2_CAP0                   (USB3_CORE_BASE + 0x18040)
#define XECP_SUPP_USB2_CAP1                   (USB3_CORE_BASE + 0x18044)
#define XECP_SUPP_USB2_CAP2                   (USB3_CORE_BASE + 0x18048)
#define XECP_SUPP_USB2_PROTOCOL_SLOT_TYPE     (USB3_CORE_BASE + 0x1804c)
#define XECP_PSI_FULL_SPEED                   (USB3_CORE_BASE + 0x18050)
#define XECP_PSI_LOW_SPEED                    (USB3_CORE_BASE + 0x18054)
#define XECP_PSI_HIGH_SPEED                   (USB3_CORE_BASE + 0x18058)
#define XECP_SUPP_USB3_CAP0                   (USB3_CORE_BASE + 0x18060)
#define XECP_SUPP_USB3_CAP1                   (USB3_CORE_BASE + 0x18064)
#define XECP_SUPP_USB3_CAP2                   (USB3_CORE_BASE + 0x18068)
#define XECP_SUPP_USB3_PROTOCOL_SLOT_TYPE     (USB3_CORE_BASE + 0x1806c)
#define PSI_SUPER_SPEED                       (USB3_CORE_BASE + 0x18070)
#define XECP_CMDM_STS0                        (USB3_CORE_BASE + 0x18080)
#define XECP_CMDM_RESERVED_1                  (USB3_CORE_BASE + 0x18084)
#define XECP_CMDM_RESERVED_2                  (USB3_CORE_BASE + 0x18088)
#define XECP_CMDM_RESERVED_3                  (USB3_CORE_BASE + 0x1808c)
#define XECP_CMDM_RESERVED_4                  (USB3_CORE_BASE + 0x18090)
#define XECP_CMDM_RESERVED_5                  (USB3_CORE_BASE + 0x18094)
#define XECP_CMDM_CTRL_REG1                   (USB3_CORE_BASE + 0x18098)
#define XECP_CMDM_CTRL_REG2                   (USB3_CORE_BASE + 0x1809c)
#define XECP_CMDM_CTRL_REG3                   (USB3_CORE_BASE + 0x180a0)
#define XECP_HOST_CTRL_CAP                    (USB3_CORE_BASE + 0x180b0)
#define XECP_HOST_CTRL_RSVD                   (USB3_CORE_BASE + 0x180b4)
#define XECP_HOST_CLR_MASK_REG                (USB3_CORE_BASE + 0x180b8)
#define XECP_HOST_CLR_IN_EP_VALID_REG         (USB3_CORE_BASE + 0x180bc)
#define XECP_HOST_CLR_PMASK_REG               (USB3_CORE_BASE + 0x180c0)
#define XECP_HOST_CTRL_OCRD_REG               (USB3_CORE_BASE + 0x180c4)
#define XECP_HOST_CTRL_TEST_BUS_LO            (USB3_CORE_BASE + 0x180c8)
#define XECP_HOST_CTRL_TEST_BUS_HI            (USB3_CORE_BASE + 0x180cc)
#define XECP_HOST_CTRL_TRM_REG1               (USB3_CORE_BASE + 0x180d0)
#define XECP_HOST_CTRL_SCH_REG1               (USB3_CORE_BASE + 0x180d4)
#define XECP_HOST_CTRL_ODMA_REG               (USB3_CORE_BASE + 0x180d8)
#define XECP_HOST_CTRL_IDMA_REG               (USB3_CORE_BASE + 0x180dc)
#define XECP_HOST_CTRL_PORT_CTRL              (USB3_CORE_BASE + 0x180e0)
#define XECP_AUX_CTRL_REG                     (USB3_CORE_BASE + 0x18100)
#define XECP_HOST_BW_OV_SS_REG                (USB3_CORE_BASE + 0x18104)
#define XECP_HOST_BW_OV_HS_REG                (USB3_CORE_BASE + 0x18108)
#define XECP_HOST_BW_OV_FS_LS_REG             (USB3_CORE_BASE + 0x1810c)
#define XECP_HOST_BW_OV_SYS_REG               (USB3_CORE_BASE + 0x18110)
#define XECP_HOST_CTRL_SCH_ASYNC_DELAY_REG    (USB3_CORE_BASE + 0x18114)
#define XECP_UPORTS_PON_RST_REG               (USB3_CORE_BASE + 0x18118)
#define XECP_HOST_CTRL_TRM_REG3               (USB3_CORE_BASE + 0x1811c)
#define XECP_AUX_CTRL_REG1                    (USB3_CORE_BASE + 0x18120)
#define XECP_HOST_CTRL_WATERMARK_REG          (USB3_CORE_BASE + 0x18128)
#define XECP_HOST_CTRL_PORT_LINK_REG          (USB3_CORE_BASE + 0x1812c)
#define XECP_USB2_LINK_MGR_CTRL_REG1          (USB3_CORE_BASE + 0x18130)
#define XECP_USB2_LINK_MGR_CTRL_REG2          (USB3_CORE_BASE + 0x18134)
#define XECP_USB2_LINK_MGR_CTRL_REG3          (USB3_CORE_BASE + 0x18138)
#define XECP_USB2_LINK_MGR_CTRL_REG4          (USB3_CORE_BASE + 0x1813c)
#define XECP_HOST_CTRL_BW_MAX_REG             (USB3_CORE_BASE + 0x18140)
#define XECP_FPGA_REVISION_REG                (USB3_CORE_BASE + 0x18144)
#define XECP_HOST_INTF_CTRL_REG               (USB3_CORE_BASE + 0x18148)
#define XECP_BW_OV_SS_BURST_REG               (USB3_CORE_BASE + 0x1814c)
#define XECP_HOST_CTRL_TRM_REG2               (USB3_CORE_BASE + 0x18150)
#define XECP_HOST_CTRL_BW_MAX1_REG            (USB3_CORE_BASE + 0x18168)
#define XECP_HOST_CTRL_BW_MAX2_REG            (USB3_CORE_BASE + 0x1816c)
#define XECP_USB2_LINESTATE_REG               (USB3_CORE_BASE + 0x18170)
#define XECP_HOST_PROTO_GAP_TIMER1_REG        (USB3_CORE_BASE + 0x18174)
#define XECP_HOST_PROTO_GAP_TIMER2_REG        (USB3_CORE_BASE + 0x18178)
#define XECP_HOST_PROTO_BTO_TIMER_REG         (USB3_CORE_BASE + 0x1817c)
#define XECP_HOST_CTRL_PSCH_REG               (USB3_CORE_BASE + 0x18180)
#define XECP_HOST_CTRL_PSCH1_REG              (USB3_CORE_BASE + 0x18184)
#define XECP_HOST_CTRL_LTM_REG                (USB3_CORE_BASE + 0x18190)
#define XECP_AUX_CTRL_REG2                    (USB3_CORE_BASE + 0x18194)
#define XECP_AUX_CTRL_REG3                    (USB3_CORE_BASE + 0x18198)
#define XECP_DEBUG_CTRL_REG                   (USB3_CORE_BASE + 0x1819c)
#define XECP_HOST_CTRL_SCH_REG2               (USB3_CORE_BASE + 0x181a0)
#define XECP_AUX_DEBUG_READ_ONLY              (USB3_CORE_BASE + 0x181a4)
#define XECP_AUX_CTRL_PORTNUM_REG             (USB3_CORE_BASE + 0x181a8)
#define XECP_AUX_CTRL_DEV_REMOVE_REG          (USB3_CORE_BASE + 0x181ac)
#define XECP_HOST_CTRL_DEBUG_PORT_DESC        (USB3_CORE_BASE + 0x181b0)
#define XECP_HOST_CTRL_DEBUG_PORT_TRM         (USB3_CORE_BASE + 0x181b4)
#define XECP_HOST_CTRL_DEBUG_PORT_IDMA        (USB3_CORE_BASE + 0x181b8)
#define XECP_HOST_CTRL_DEBUG_PORT_ODMA        (USB3_CORE_BASE + 0x181bc)
#define XECP_HOST_CTRL_DEBUG_PORT_MISC        (USB3_CORE_BASE + 0x181c0)
#define XECP_HOST_CTRL_TTE_REG1               (USB3_CORE_BASE + 0x181e0)
#define XECP_HOST_CTRL_LTM_REG1               (USB3_CORE_BASE + 0x181e4)
#define XECP_HOST_CTRL_LTM_REG2               (USB3_CORE_BASE + 0x181e8)
#define XECP_AUX_SCRATCHPAD_0                 (USB3_CORE_BASE + 0x18200)
#define XECP_AUX_SCRATCHPAD_1                 (USB3_CORE_BASE + 0x18204)
#define XECP_BATTERY_CHARGE_REG               (USB3_CORE_BASE + 0x18210)
#define XECP_BATTERY_CHARGE_REG1              (USB3_CORE_BASE + 0x18214)
#define XECP_BATTERY_CHARGE_REG2              (USB3_CORE_BASE + 0x18218)
#define XECP_BATTERY_CHARGE_REG3              (USB3_CORE_BASE + 0x1821c)
#define XECP_HOST_CTRL_PORT_LINK_REG1         (USB3_CORE_BASE + 0x18220)
#define XECP_USBLEGSUP                        (USB3_CORE_BASE + 0x18370)
#define XECP_USBLEGCTLSTS                     (USB3_CORE_BASE + 0x18374)
#define XECP_DCID                             (USB3_CORE_BASE + 0x18380)
#define XECP_DCDB                             (USB3_CORE_BASE + 0x18384)
#define XECP_DCERSTSZ                         (USB3_CORE_BASE + 0x18388)
#define XECP_RSVD_0C                          (USB3_CORE_BASE + 0x1838c)
#define XECP_DCERSTBA_LOW                     (USB3_CORE_BASE + 0x18390)
#define XECP_DCERSTBA_HIGH                    (USB3_CORE_BASE + 0x18394)
#define XECP_DCERDP_LOW                       (USB3_CORE_BASE + 0x18398)
#define XECP_DCERDP_HIGH                      (USB3_CORE_BASE + 0x1839c)
#define XECP_DCCTRL                           (USB3_CORE_BASE + 0x183a0)
#define XECP_DCST                             (USB3_CORE_BASE + 0x183a4)
#define XECP_DCPORTSC                         (USB3_CORE_BASE + 0x183a8)
#define XECP_RSVD_2C                          (USB3_CORE_BASE + 0x183ac)
#define XECP_DCCP_LOW                         (USB3_CORE_BASE + 0x183b0)
#define XECP_DCCP_HIGH                        (USB3_CORE_BASE + 0x183b4)
#define XECP_DCDDI1                           (USB3_CORE_BASE + 0x183b8)
#define XECP_DCDDI2                           (USB3_CORE_BASE + 0x183bc)
#define XECP_USB3_TEST_PORT0_REG              (USB3_CORE_BASE + 0x18800)

/* OTG registers */
#define OTGCMD         (USB3_CORE_BASE + 0x0)
#define OTGSTS         (USB3_CORE_BASE + 0x4)
#define OTGSTATE       (USB3_CORE_BASE + 0x8)
#define OTGREFCLK      (USB3_CORE_BASE + 0xc)
#define OTGIEN         (USB3_CORE_BASE + 0x10)
#define OTGIVECT       (USB3_CORE_BASE + 0x14)
#define OTGVERSION     (USB3_CORE_BASE + 0x18)
#define OTGSIMULATE    (USB3_CORE_BASE + 0x1c)
#define CLK_FREQ       (USB3_CORE_BASE + 0x20)
#define OTGTMR         (USB3_CORE_BASE + 0x24)
#define ADPBC_STS      (USB3_CORE_BASE + 0xe0)
#define ADP_RAMP_TIME  (USB3_CORE_BASE + 0xe4)
#define ADPBC_CTRL1    (USB3_CORE_BASE + 0xe8)
#define ADPBC_CTRL2    (USB3_CORE_BASE + 0xec)
#define SFR0           (USB3_CORE_BASE + 0xf0)
#define SFR1           (USB3_CORE_BASE + 0xf4)
#define SFR2           (USB3_CORE_BASE + 0xf8)
#define SFR3           (USB3_CORE_BASE + 0xfc)

/* Device registers */
#define usb_conf   (USB3_CORE_BASE + 0x20000)
#define usb_sts    (USB3_CORE_BASE + 0x20004)
#define usb_cmd    (USB3_CORE_BASE + 0x20008)
#define usb_iptn   (USB3_CORE_BASE + 0x2000c)
#define usb_lpm    (USB3_CORE_BASE + 0x20010)
#define usb_ien    (USB3_CORE_BASE + 0x20014)
#define usb_ists   (USB3_CORE_BASE + 0x20018)
#define ep_sel     (USB3_CORE_BASE + 0x2001c)
#define ep_traddr  (USB3_CORE_BASE + 0x20020)
#define ep_cfg     (USB3_CORE_BASE + 0x20024)
#define ep_cmd     (USB3_CORE_BASE + 0x20028)
#define ep_sts     (USB3_CORE_BASE + 0x2002c)
#define ep_sts_sid (USB3_CORE_BASE + 0x20030)
#define ep_sts_en  (USB3_CORE_BASE + 0x20034)
#define drbl       (USB3_CORE_BASE + 0x20038)
#define ep_ien     (USB3_CORE_BASE + 0x2003c)
#define ep_ists    (USB3_CORE_BASE + 0x20040)
#define usb_pwr    (USB3_CORE_BASE + 0x20044)
#define usb_conf2  (USB3_CORE_BASE + 0x20048)
#define usb_cap1   (USB3_CORE_BASE + 0x2004c)
#define usb_cap2   (USB3_CORE_BASE + 0x20050)
#define usb_cap3   (USB3_CORE_BASE + 0x20054)
#define usb_cap4   (USB3_CORE_BASE + 0x20058)
#define usb_cap5   (USB3_CORE_BASE + 0x2005c)
#define usb_cpkt1  (USB3_CORE_BASE + 0x20060)
#define usb_cpkt2  (USB3_CORE_BASE + 0x20064)
#define usb_cpkt3  (USB3_CORE_BASE + 0x20068)
#define cfg_reg1   (USB3_CORE_BASE + 0x20100)
#define dbg_link1  (USB3_CORE_BASE + 0x20104)
#define dbg_link2  (USB3_CORE_BASE + 0x20108)
#define cfg_reg4   (USB3_CORE_BASE + 0x2010c)
#define cfg_reg5   (USB3_CORE_BASE + 0x20110)
#define cfg_reg6   (USB3_CORE_BASE + 0x20114)
#define cfg_reg7   (USB3_CORE_BASE + 0x20118)
#define cfg_reg8   (USB3_CORE_BASE + 0x2011c)
#define cfg_reg9   (USB3_CORE_BASE + 0x20120)
#define cfg_reg10  (USB3_CORE_BASE + 0x20124)
#define cfg_reg11  (USB3_CORE_BASE + 0x20128)
#define cfg_reg12  (USB3_CORE_BASE + 0x2012c)
#define cfg_reg13  (USB3_CORE_BASE + 0x20130)
#define cfg_reg14  (USB3_CORE_BASE + 0x20134)
#define cfg_reg15  (USB3_CORE_BASE + 0x20138)
#define cfg_reg16  (USB3_CORE_BASE + 0x2013c)
#define cfg_reg17  (USB3_CORE_BASE + 0x20140)
#define cfg_reg18  (USB3_CORE_BASE + 0x20144)
#define cfg_reg19  (USB3_CORE_BASE + 0x20148)
#define cfg_reg20  (USB3_CORE_BASE + 0x2014c)
#define cfg_reg21  (USB3_CORE_BASE + 0x20150)
#define cfg_reg22  (USB3_CORE_BASE + 0x20154)
#define cfg_reg23  (USB3_CORE_BASE + 0x20158)
#define cfg_reg24  (USB3_CORE_BASE + 0x2015c)
#define cfg_reg25  (USB3_CORE_BASE + 0x20160)
#define cfg_reg26  (USB3_CORE_BASE + 0x20164)
#define cfg_reg27  (USB3_CORE_BASE + 0x20168)
#define cfg_reg28  (USB3_CORE_BASE + 0x2016c)
#define cfg_reg29  (USB3_CORE_BASE + 0x20170)
#define cfg_reg30  (USB3_CORE_BASE + 0x20174)
#define cfg_reg31  (USB3_CORE_BASE + 0x20178)
#define cfg_reg32  (USB3_CORE_BASE + 0x2017c)
#define cfg_reg33  (USB3_CORE_BASE + 0x20180)
#define cfg_reg34  (USB3_CORE_BASE + 0x20184)
#define cfg_reg35  (USB3_CORE_BASE + 0x20188)
#define cfg_reg36  (USB3_CORE_BASE + 0x201ac)
#define cfg_reg37  (USB3_CORE_BASE + 0x201b0)
#define cfg_reg38  (USB3_CORE_BASE + 0x201b4)
#define cfg_reg39  (USB3_CORE_BASE + 0x201b8)
#define cfg_reg40  (USB3_CORE_BASE + 0x201bc)
#define cfg_reg41  (USB3_CORE_BASE + 0x201c0)
#define cfg_reg42  (USB3_CORE_BASE + 0x201c4)
#define cfg_reg43  (USB3_CORE_BASE + 0x201c8)
#define cfg_reg44  (USB3_CORE_BASE + 0x201cc)
#define cfg_reg45  (USB3_CORE_BASE + 0x201d0)
#define cfg_reg46  (USB3_CORE_BASE + 0x201d4)
#define cfg_reg47  (USB3_CORE_BASE + 0x201d8)
#define cfg_reg48  (USB3_CORE_BASE + 0x201dc)
#define cfg_reg49  (USB3_CORE_BASE + 0x201e0)
#define cfg_reg50  (USB3_CORE_BASE + 0x201e4)
#define cfg_reg51  (USB3_CORE_BASE + 0x201e8)
#define cfg_reg52  (USB3_CORE_BASE + 0x201ec)
#define cfg_reg53  (USB3_CORE_BASE + 0x201f0)
#define cfg_reg54  (USB3_CORE_BASE + 0x201f4)
#define cfg_reg55  (USB3_CORE_BASE + 0x201f8)
#define cfg_reg56  (USB3_CORE_BASE + 0x201fc)
#define cfg_reg57  (USB3_CORE_BASE + 0x20200)
#define cfg_reg58  (USB3_CORE_BASE + 0x20204)
#define cfg_reg59  (USB3_CORE_BASE + 0x20208)
#define cfg_reg60  (USB3_CORE_BASE + 0x2020c)
#define cfg_reg61  (USB3_CORE_BASE + 0x20210)
#define cfg_reg62  (USB3_CORE_BASE + 0x20214)

/* None-core registers */
#define USB3_CORE_CTRL1    (USB3_CTRL_BASE + 0x00)
#define USB3_CORE_CTRL2    (USB3_CTRL_BASE + 0x04)
#define USB3_INT_REG       (USB3_CTRL_BASE + 0x08)
#define USB3_CORE_STATUS   (USB3_CTRL_BASE + 0x0c)
#define XHCI_DEBUG_LINK_ST (USB3_CTRL_BASE + 0x10)
#define XHCI_DEBUG_BUS     (USB3_CTRL_BASE + 0x14)
#define USB3_SSPHY_CTRL1   (USB3_CTRL_BASE + 0x40)
#define USB3_SSPHY_CTRL2   (USB3_CTRL_BASE + 0x44)
#define USB3_SSPHY_STATUS  (USB3_CTRL_BASE + 0x4c)
#define USB2_PHY_CTRL1     (USB3_CTRL_BASE + 0x50)
#define USB2_PHY_CTRL2     (USB3_CTRL_BASE + 0x54)
#define USB2_PHY_STATUS    (USB3_CTRL_BASE + 0x5c)

#endif /*  _IMX8_USB3_H_ */
